/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.media;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.zmpp.media.MediaCollection;
import org.zmpp.media.PictureManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PictureManagerImpl
implements PictureManager {
    private int release;
    private MediaCollection<BufferedImage> pictures;

    public PictureManagerImpl(int n, MediaCollection<BufferedImage> mediaCollection) {
        this.release = n;
        this.pictures = mediaCollection;
    }

    @Override
    public Dimension getPictureSize(int n) {
        BufferedImage bufferedImage = this.pictures.getResource(n);
        if (bufferedImage != null) {
            return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        return null;
    }

    @Override
    public BufferedImage getPicture(int n) {
        return this.pictures.getResource(n);
    }

    @Override
    public int getNumPictures() {
        return this.pictures.getNumResources();
    }

    @Override
    public void preload(int[] nArray) {
    }

    @Override
    public int getRelease() {
        return this.release;
    }

    @Override
    public void reset() {
    }
}

