!   FOOTNOTE.H          An Inform Library Extention for Inform 5.5 or greater
!                       To produce sequentially numbered footnotes.
!                       L. Ross Raszewski
!
! This library, based on the excercise in the manual, allows you to integrate 
! footnotes into a game, which are numbered IN THE ORDER THEY APPEAR.  It has
! two advantages over the simple, obvious system (ie. the one used in 
! Hitchhiker's Guide):  First, footnotes which have not been mentioned cannot
! be accessed.  Second, the footnotes will always count upward in series, no 
! matter what order they're called in.  The example in the manual, I found, 
! sometimes numbers the same footnote twice.  I've avoided this, so that the 
! same footnote will have the same number, regardless of how it is called 
! (sort of like Achieved(#);)  
! Include AFTER Grammar.h
! define the constant MAX_FOOTNOTES to the number of footnotes in the game
! before inclusion.
! To print a footnote in running text, call Note() with the number of the 
! footnote (THe number is internal, and may not be the one that apears on the 
! screen.  Ex: If two footnotes have already been seen, then the statement:
!                  Print "All the world's a stage.", (note) 1;
! will print "All the world's a stage. [Footnote 3]", with the [Footnote 3]
! in underline print.  Note() prints the text " [Footnote #]".  Note that 
! there is a leading space, but not a trailing one.
! The footnote is read by issuing the command FOOTNOTE 3 (or NOTE 3, or 
! READ FOOTNOTE 3).  FOOTNOTE alone will instruct the player on the use of 
! Footnotes.
!
! You must define the function Printnote(n); before inclusion.  This function 
! actually prints the footnote text after FootnoteSub has printed the words
! [Footnote #]^ and has converted the number the player typed into its 
! original number in the footnote list  A sample PrintNote sub might read:
!       [ PrintNote n;
!         switch(n){
!                 1: "William Shakespeare";
!                 2: "Sloathes have no taste";
!                 3: {Style bold; print "Sesame Street"; style roman; " was \
!                       brought to you by the letter ~K~ and the number 4.";};
!                 };
!              ];
!
!  You can have a footnote do anything you like, even call another footnote.
!  (I've tried it, it seems to work).
!  Word of warning: The footnotes_seen array is a bit array, so I think you 
!  can't have more than 256 footnotes.
!

System_file;
Array footnotes_seen -> MAX_FOOTNOTES;
Global footnote_count;
[ FNWarnSub;
        "To view a footnote, type ~FOOTNOTE #~, where # is the number \
        of the footnote you wish to read.";
        ];
[ Note n;
     if (footnotes_seen->n==0) {
     footnote_count++; footnotes_seen->n=footnote_count;};
     style underline;
     print " [Footnote ",footnotes_seen->n,"]";
     style roman;
];
[ FootnoteSub n;
     if (noun>footnote_count)
     {   print "That footnote [",noun,"] has not been mentioned.^"; rtrue; }
     if (noun==0) "Footnotes count upward from 1.";
     for(n=1:(footnotes_seen->n~=noun && n<=(MAX_FOOTNOTES-1)):n++);
     print "[Footnote ",noun,"]^";
     PrintNote(n);
 ];

Verb meta "footnote" "note" *                           ->FNWarn
           * number                                     ->Footnote;
Extend "read"
           * "footnote" number                          ->Footnote
           * "note" number                              ->Footnote
           * "footnote"                                 ->FNWarn
           * "footnotes"                                ->FNWarn;

#Stub PrintNote 1;
