/*
	HCDJGPP.C

	Non-portable functions specific to DJGPP:

		hugo_splitpath
		hugo_makepath
		hugo_closefiles

	for the Hugo Compiler

	Copyright (c) 1995-2006 by Kent Tessman
*/


#include "hcheader.h"


/*
    FILENAME MANAGEMENT:

    Different operating systems will have their own ways of naming
    files.  The following routines are simply required to know and
    be able to dissect/build the components of a particular filename,
    storing/restoring the components via the specified char arrays.

    For example, in MS-DOS:

	hugo_splitpath("C:\HUGO\FILES\HUGOLIB.H", ...)
		becomes:  C:, HUGO\FILES, HUGOLIB, H

    and

	hugo_makepath(..., "C:", "HUGO\FILES", "HUGOLIB", "H")
		becomes:  C:\HUGO\FILES\HUGOLIB.H

    The appropriate equivalent nomenclature should be used for the
    operating system in question.
*/

void hugo_splitpath(char *path, char *drive, char *dir, char *fname, char *ext)
{
	fnsplit(path, drive, dir, fname, ext);          /* from libc */
}

void hugo_makepath(char *path, char *drive, char *dir, char *fname, char *ext)
{
	fnmerge(path, drive, dir, fname, ext);          /* from libc */
}


/* hugo_closefiles

    Closes all open files.  NOTE:  If the operating system automatically
    closes any open streams upon exit from the program, this function may
    be left empty.
*/

void hugo_closefiles()
{
	fclose(sourcefile);
	fclose(objectfile);
	fclose(textfile);
	fclose(allfile);
	fclose(listfile);
}
