/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.zmpp.base.DefaultMemoryAccess;
import org.zmpp.blorb.BlorbResources;
import org.zmpp.blorb.BlorbStory;
import org.zmpp.iff.DefaultFormChunk;
import org.zmpp.iff.FormChunk;
import org.zmpp.io.IOSystem;
import org.zmpp.media.Resources;
import org.zmpp.swingui.FileSaveGameDataStore;
import org.zmpp.swingui.MemorySaveGameDataStore;
import org.zmpp.swingui.ZmppApplet;
import org.zmpp.vm.Machine;
import org.zmpp.vm.MachineFactory;
import org.zmpp.vm.SaveGameDataStore;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.StatusLine;
import org.zmpp.vmutil.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppletMachineFactory
extends MachineFactory<ZmppApplet> {
    private ZmppApplet applet;
    private InputStream storyis;
    private InputStream resourceis;
    private FormChunk blorbchunk;
    private SaveGameDataStore savegamestore;

    public AppletMachineFactory(ZmppApplet zmppApplet, URL uRL, URL uRL2, boolean bl) throws Exception {
        this.applet = zmppApplet;
        this.savegamestore = bl ? new FileSaveGameDataStore(zmppApplet) : new MemorySaveGameDataStore();
        try {
            this.storyis = uRL.openStream();
            if (uRL2 != null) {
                this.resourceis = uRL2.openStream();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AppletMachineFactory(ZmppApplet zmppApplet, URL uRL, boolean bl) throws Exception {
        this.applet = zmppApplet;
        this.savegamestore = bl ? new FileSaveGameDataStore(zmppApplet) : new MemorySaveGameDataStore();
        try {
            this.resourceis = uRL.openStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected byte[] readStoryData() throws IOException {
        if (this.storyis != null) {
            return FileUtils.readFileBytes(this.storyis);
        }
        FormChunk formChunk = this.readBlorb();
        return formChunk != null ? new BlorbStory(this.readBlorb()).getStoryData() : null;
    }

    private FormChunk readBlorb() throws IOException {
        byte[] byArray;
        if (this.blorbchunk == null && (byArray = FileUtils.readFileBytes(this.resourceis)) != null) {
            this.blorbchunk = new DefaultFormChunk(new DefaultMemoryAccess(byArray));
        }
        return this.blorbchunk;
    }

    @Override
    protected Resources readResources() throws IOException {
        FormChunk formChunk = this.readBlorb();
        return formChunk != null ? new BlorbResources(formChunk) : null;
    }

    @Override
    protected void reportInvalidStory() {
        System.err.printf("invalid story file", new Object[0]);
    }

    @Override
    protected IOSystem getIOSystem() {
        return this.applet;
    }

    @Override
    protected org.zmpp.io.InputStream getKeyboardInputStream() {
        return this.applet;
    }

    @Override
    protected StatusLine getStatusLine() {
        return this.applet;
    }

    @Override
    protected ScreenModel getScreenModel() {
        return this.applet.getScreenModel();
    }

    @Override
    protected SaveGameDataStore getSaveGameDataStore() {
        return this.savegamestore;
    }

    @Override
    protected ZmppApplet initUI(Machine machine) {
        this.applet.initUI(machine);
        return this.applet;
    }

    @Override
    public ZmppApplet getUI() {
        return this.applet;
    }
}

