/* gtlink.c: Hyperlink output control
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/
#include "gtpref.h"
#include "gtoption.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "glk.h"
#include "glkdos.h"
#ifdef GLK_MODULE_HYPERLINKS

void glk_request_hyperlink_event(winid_t win)
{
    if (!win) {
        gli_strict_warning("request_hyperlink_event: invalid ref");
        return;
    }
    
    if (win->link_request) {
        gli_strict_warning("request_hyperlink_event: window already has link request");
        return;
    }
    
    switch (win->type) {
        case wintype_TextBuffer:
        case wintype_TextGrid:
            win->link_request = TRUE;
            break;
        default:
            gli_strict_warning("request_link_event: window does not support link input");
            break;
    }
    
}

void glk_cancel_hyperlink_event(winid_t win)
{
    if (!win) {
        gli_strict_warning("cancel_link_event: invalid ref");
        return;
    }
    
    switch (win->type) {
        case wintype_TextBuffer:
        case wintype_TextGrid:
            win->link_request = FALSE;
            break;
        default:
            /* do nothing */
            break;
    }

}

void glk_set_hyperlink(glui32 linkval)
{
   glk_set_hyperlink_stream(glk_stream_get_current(),linkval);
}

void echo_to_link(strid_t s, unsigned char c)
{
  if (s->hlink && !s->hlink->done && s->hlink->buflen < LINK_BUFFER_SIZE-1)
  {
    s->hlink->text[s->hlink->buflen++]=c;
    s->hlink->text[s->hlink->buflen]=0;
  }


}
void glk_set_hyperlink_stream(strid_t str, glui32 linkval)
{
   char x[512]; glui32 v; struct glt_link *c;
     if (str->hlink && str->hlink->number==linkval) return;
     if (str->hlink && !str->hlink->done)
       str->hlink->end=glk_stream_get_position(str);
   if (linkval==0)
   {
     return;
   }
   if ((glk_preferences[pref_grid_link] && str->win->type==wintype_TextGrid) ||
       (glk_preferences[pref_buf_link] && str->win->type==wintype_TextBuffer))
   {
    sprintf(x,"[%ld]",linkval);
    v=str->win->style;
    glk_set_style_stream(str,style_Link);
    glk_put_string_stream(str,x);
    glk_set_style_stream(str,v);
   }

  c=str->hlink;
  str->hlink=(struct glt_link *)malloc(sizeof(struct glt_link));
  str->hlink->next=c;
  str->hlink->number=linkval;
  str->hlink->begin=glk_stream_get_position(str);
  str->hlink->end=0;
  str->hlink->buflen=0;
  str->hlink->text[0]=0;
  str->hlink->prev=NULL;
  str->hlink->done=FALSE;
  if (c) c->prev=str->hlink;

}
#endif /* GLK_MODULE_HYPERLINKS */
