WS [ \t]+
%option caseless
%{
/* config.l: configuration file lexical analyzer
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/

#include "gtpref.h"
#include "gtoption.h"
#include <stdio.h>
#include "glk.h"
#include "glkdos.h"
#include <ctype.h>
extern unsigned long def_style_mask[];
extern int VHORIZ_REZ;
extern int VVERT_REZ;
int bind_key(char *s, int key);
%}
%%
WIDTH{WS}[0-9]+                         glk_preferences[pref_screenwidth]= atoi(yytext+6);
HEIGHT{WS}[0-9]+                        glk_preferences[pref_screenheight]=atoi(yytext+7);
MESSAGELINE{WS}OFF                      glk_preferences[pref_messageline]=0;
MESSAGELINE{WS}ON                       glk_preferences[pref_messageline]=1;
HISTORY{WS}[0-9]+                       glk_preferences[pref_historylen] = atoi(yytext+8);
REVERSE{WS}GRID                         glk_preferences[pref_reverse_textgrids]=1;
NORMAL{WS}GRID                          glk_preferences[pref_reverse_textgrids]=0;
BORDER{WS}OFF                           glk_preferences[pref_window_borders]=0;
BORDER{WS}ON                            glk_preferences[pref_window_borders]=1;
LATIN1{WS}ON                            glk_preferences[pref_latin1]=1;
LATIN1{WS}OFF                           glk_preferences[pref_latin1]=0;
NORMALIZE{WS}BACKGROUND                 glk_preferences[pref_normalize_wipe]=1;
DEFAULT{WS}BACKGROUND                   glk_preferences[pref_normalize_wipe]=0;
FOREGROUND{WS}[0-9]+                    glk_preferences[pref_fg_color]=atoi(yytext+11);
BACKGROUND{WS}[0-9]+                    glk_preferences[pref_bg_color]=atoi(yytext+11);
GRIDLINK{WS}ON                          glk_preferences[pref_grid_link]=1;
GRIDLINK{WS}OFF                         glk_preferences[ pref_grid_link]=0;
BUFFERLINK{WS}ON                        glk_preferences[pref_buf_link]=1;
BUFFERLINK{WS}OFF                       glk_preferences[pref_buf_link]=0;
LINK{WS}[0-9]+                          def_style_mask[style_Link]=atoi(yytext+5);
NORMAL{WS}[0-9]+                        def_style_mask[style_Normal]=atoi(yytext+7);
EMPHASIS{WS}[0-9]+                      def_style_mask[style_Emphasized]=atoi(yytext+9);
PREFORMATTED{WS}[0-9]+                  def_style_mask[style_Preformatted]=atoi(yytext+13);
HEADER{WS}[0-9]+                        def_style_mask[style_Header]=atoi(yytext+7);
SUBHEADER{WS}[0-9]+                     def_style_mask[style_Subheader]=atoi(yytext+10);
ALERT{WS}[0-9]+                         def_style_mask[style_Alert]=atoi(yytext+6);
NOTE{WS}[0-9]+                          def_style_mask[style_Note]=atoi(yytext+5);
BLOCKQUOTE{WS}[0-9]+                    def_style_mask[style_BlockQuote]=atoi(yytext+11);
USER1{WS}[0-9]+                         def_style_mask[style_User1]=atoi(yytext+6);
USER2{WS}[0-9]+                         def_style_mask[style_User2]=atoi(yytext+6);
SOUND{WS}ON                             glk_preferences[pref_sound]=1;
SOUND{WS}OFF                            glk_preferences[pref_sound]=0;
MORE{WS}ON                              glk_preferences[pref_more_pager]=1;
MORE{WS}OFF                             glk_preferences[pref_more_pager]=0;
FRACT{WS}ON                             glk_preferences[pref_rat_pager]=1;
FRACT{WS}OFF                            glk_preferences[pref_rat_pager]=0;
PERCENT{WS}ON                           glk_preferences[pref_per_pager]=1;
PERCENT{WS}OFF                          glk_preferences[pref_per_pager]=0;
FONT{WS}[0-9]+                          glk_preferences[pref_font]=atoi(yytext+5);
RESOLUTION{WS}[0-9]+                    glk_preferences[pref_reso]=atoi(yytext+5);
VIRTUAL_WIDTH{WS}[0-9]+                 VHORIZ_REZ=atoi(yytext+14);
VIRTUAL_HEIGHT{WS}[0-9]+                VVERT_REZ=atoi(yytext+15);
CPL{WS}[0-9]+                           glk_preferences[pref_cpl]=atoi(yytext+4);
BUFFER{WS}ON                            glk_preferences[pref_dbl_buf]=1;
BUFFER{WS}OFF                           glk_preferences[pref_dbl_buf]=0;
DVORAK{WS}ON                            glk_preferences[pref_dvorak]=1;
DVORAK{WS}OFF                           glk_preferences[pref_dvorak]=0;
BINDKEY{WS}[0-9]+{WS}.+                 { int i=7; while (isspace(yytext[i])) i++;
                                          while(isdigit(yytext[i])) i++;
                                          while(isspace(yytext[i])) i++;
                                          if (!bind_key(yytext+i,atoi(yytext+8)))
                                           printf("Error: command not matched %s\n",yytext+i);
                                         }
[ \n\t]*
%%
void readconfig()
{
 char *s; FILE *f;
 s=getenv("GLKCFG");
 if (s==NULL) s="glk.cfg";
 f=fopen(s,"r");
 if (!f) {
           char *w=getenv("GLKDIR");
           char z[1024];
           if (w!=NULL)
           {
            sprintf(z,"%s%s",w,s);
            f=fopen(z,"r");
           
           }
           if (!f) return;
         }
 yyin=f;
 yylex();
 fclose(f);
}
int check_config()
{
 return 1;
}
