/* credita.c: GlkDOS credits (allegro version)
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/

#include "glk.h"
#include <stdio.h>
#include "gtoption.h"
#include "glkdos.h"

int check_config();
int gli_graphics_test(glui32);
int print_glk_credits(int pref_credits)
{
        printf("GlkDOS/Allegro, library version %s, GLK %s (%s %s).\n",
            LIBRARY_VERSION, GLK_VERSION, LIBRARY_PORT, __DATE__);
        if (!check_config())
         printf("(No Config) ");
        if (!gli_graphics_test(wintype_Graphics))
         printf("(No Images)");
        printf("\nBy L. Ross Raszewski, based upon GlkTerm 0.7.4 by Andrew Plotkin\n");
        if (pref_credits)
{
         printf("Graphics and sound provided by the Allegro programming library\n");
         printf("by Shawn Hargreaves, and JGMod by Jeffery Guan Foo Wah.\n");
if (gli_graphics_test(wintype_Graphics)) {
         printf("PNG support is provided via libpng, which is the property of its \n");
         printf("contributing authors. The PNG loader is based upon code by Peter Wang.\n");
         printf("Jpeg support is provided by the Independant Jpeg Group's software.\n");
         printf("The jpeg loader is based upon code by Eric Vannier.\n");
}
         printf("sglk extensions designed by L. Ross Raszewski and Evin Roberts\n");
         printf("GlkDOS is freeware, and cannot be used for any commercial ");
         printf("application, except by special permission of the author.\n");
         printf("For support and information, contact L. Ross Raszewski ");
         printf("<rraszews@acm.org>.\n");
}
        printf("For more information, see http://www.eblong.com/zarf/glk/index.html\n");      
        return 1;
}
    
