"""
t3SYMD.py

Provides a class representing a symbolic names block in a t3 image file.
"""

import struct
from t3Block import *
from t3DataHolder import *

class SYMD_Block(Block):
	"""
	A symbolic names block. There may be multiple such blocks in any image
	file, but the symbolic names defined in each must not clash.
	"""
	name = "Symbolic Names Block"

	def __init__(self, datastream, image, attribs):
		Block.__init__(self, datastream, image, attribs)
		self.read_block()
		
	def read_block(self):
		"""
		Reads the data included in the block.
		"""
		n = struct.unpack("<H", self.datastream.read(2))[0]
		entries = []
		for i in xrange(n):
			edict = {}
			edict["o_value"] = get_data_holder(self.datastream.read(5))
			namelen = struct.unpack("<B", self.datastream.read(1))[0]
			edict["s_name"] = self.datastream.read(namelen)
			entries.append(edict)
		self.data["l_entries"] = entries
		
	def report_data(self):
		s = ""
		for entry in self.data["l_entries"]:
			s = s + entry["s_name"] + ": " + repr(entry["o_value"]) + "\n"
		return s