/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * UU3 rooms, ripped out of UU2 and modified a bit here and there.
 */

#ifndef	DEMO

// The Giant Oak Tree

Dpicnicbench2: Distant
	sdesc = "picnic bench"
	ldesc = "From here, it looks very tiny."
	noun = 'table' 'bench'
	adjective = 'picnic' 'wooden'
	location = bigoak
; 
Dtrees: Distant
	sdesc = "bunch of trees"
	noun = 'trees'
	location = bigoak
;	 
Driver: Decoration
	sdesc = "rushing river"
	noun = 'river' 'rapids' 'water'
	adjective = 'rushing'
	location = bigoak

	acceptsput(actor, loctype) = { return true; }
	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = { Driver4.ioPutin(actor, dobj); }
; 

Dbigoak: Decoration
	sdesc = "giant oak tree"
	noun = 'tree' 'oak'
	adjective = 'giant' 'oak'
	location = bigoak
	
	verDoClimb(actor) = {
		"There are no branches low enough for you to grab onto.";
	}
;
bigoakrope: Decoration
	sdesc = "snapped rope"
	ldesc = {
		"The remaining piece of rope is high above you.  You
		can't really see much of it from here.";
	}
	location = bigoak
	noun = 'rope' 'piece'
	adjective = 'snapped' 'broken' 'cut' 'tire' 'swing' 'tireswing'

	verDoClimb(actor) = {
		"It's way too high up for you to reach.";
	}
	verDoTake(actor) = { "You can't reach it."; }
;

bigoak: Outside
	noun = 'oak'
	adjective = 'big' 'uu3'

	sdesc = "At the Big Oak"
	ldesc = {
		if (Me.isin(acmedinghy)) {
			I(); "You are hanging on for dear life in a mauve
			dinghy that is being tossed about like a toy near
			the bank of a rushing river.  On the shore stands a
			giant oak tree -- it must be nearly 200 feet
			tall."; P();
		}
		else {
			I(); "You are standing on the bank of a rushing 
			river at the base of a giant oak tree, easily 
			200 feet tall.  It looks to be about 
			a class 5 rapids with white-water everywhere. 
			It's at least 80 feet to the other bank.  
			Looking back, you can see your favorite 
			picnic table, a tiny square of wood tucked 
			away in the trees far to the west.  A path 
			along the river bank leads southeast."; P();
		}
		
		I(); "Hanging from a branch on the east side of the tree 
		is a short piece of rope with a frayed end.  It looks 
		like the rope must have snapped recently.";

		if (figurine.tossed) {
			P();
			I(); "A narrow strip of water leading east is now
			a brilliant jade color, and looks to be solid.";
		}
	}

	se = westbank1
	west = {
		"A voice inside your head intones, \"No, my son. The 
		right path is down the river.\"  A mysterious force 
		prevents you from heading west.";

		return nil;
	}
	up = {
		"The rope is way too far above you to reach.";
		return nil;
	}	
	east = {
		if (figurine.tossed) {
			"You walk nimbly across the jade pathway,
			the violent rapids snapping at your heels
			all the way.\b";

			return bigoakjadepath;
		}
		else {
			"Trying to swim across would surely be suicidal.";
			return nil;
		}
	}
;

// West bank of the river
soil: Decoration
	sdesc = "river bank made of red soil"
	noun = 'soil' 'dirt'
	adjective = 'red'
	location = westbank1
;

Driver3: Decoration
	sdesc = "rushing river"
	noun = 'river' 'rapids' 'water'
	adjective = 'rushing'
	location = westbank1

	acceptsput(actor, loctype) = { return true; }
	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = { Driver4.ioPutin(actor, dobj); }
;
Dwestbank1forest: Decoration
	sdesc = "dense forest"
	ldesc = {
		"The forest looks far too thick to be passable, even
		if you could get to it.";
	}
	noun = 'forest' 'trees' 'tree' 'woods'
	adjective = 'dense'
	location = westbank1
;
westbank1: Outside
	sdesc = "On the West Bank of the River"
	ldesc = {
		if (Me.isin(acmedinghy)) {
			I(); "You're being thrown from one side of
			the dinghy to the other as you quickly make your
			way downstream.  On the west bank there is little
			of interest apart from the soil, which is dark
			red.  On the east bank, far away, there is only
			dense forest.";
		}
		else {
			I(); "You're on the west bank of the river. On the 
			other side, there is only dense forest.  The 
			soil has a reddish tint here.  You can go 
			upstream, to the northwest, or downstream, to 
			the south.";
		}
	}

	nw = bigoak	
	south = westbank2
	
	east = {
		if (figurine.tossed) {
			"You walk nimbly across the jade pathway,
			the violent rapids snapping at your heels
			all the way.\b";

			return westbank1jadepath;
		}
		else {
			"Trying to swim across would surely be suicidal.";
			return nil;
		}
	}
;

// The end of the line on the West Side of the river
Driver4: Decoration
	sdesc = "rushing river"
	noun = 'river' 'rapids' 'water'
	adjective = 'rushing'
	location = westbank2

	acceptsput(actor, loctype) = { return true; }
	verIoPutin(actor) = {}
	ioPutin(actor, dobj) = {
		if (dobj = acmedinghypellet) {
			if (figurine.tossed) {
				"You toss "; dobj.thedesc; " into the river;
				seconds later you are knocked to the ground
				by a huge explosion.  As you get back up and
				brush yourself off, you notice a thick,
				billowing mauve cloud hovering above the
				water's surface.";

 				dobj.movein(nil);
			}
			else {
				"You toss "; dobj.thedesc; " into the river;
				seconds later you are knocked to the ground
				by a huge explosion.  As you get back up and
				brush yourself off, you notice a dinghy next
				to the bank, rapidly floating away down the 
				river.";

 				dobj.movein(nil);
				acmedinghy.movein(Me.location);
				acmedinghy.makeknownto(Me);
				notify(acmedinghy, &floataway, 0);
			}
		}
		else if (dobj = figurine) {
			I(); "You toss the sacred artifact into the raging 
			rapids, trusting that Duhdha will help you 
			pass this fearsome obstacle.  An instant 
			later, a narrow strip of water leading from 
			the shore to the center of river and then 
			farther downstream turns a brilliant jade 
			color and simultaneously begins to thicken, 
			as though it were running in slow motion, so 
			that it eventually seems to harden like ice!  
			Though the river rushes on as before, a solid 
			jade path now runs right through its heart -- 
			Duhdha sure knows his stuff when it comes
			to messing with nature!";

			incscore(3);

			figurine.movein(nil);
			figurine.tossed := true;
		}
		else {
			// shouldn't happen
			"You hurl "; dobj.thedesc; " into the river,
			and it's lost forever.  First it skips across
			the water a bunch of times, though, which
			is pretty neat-looking.";
		}
	}
;

boatwreck: Decoration
	sdesc = "wrecked boat"
	ldesc = "It was a one or two-person craft, but there's not much left 
		of it now.  Looks like it smashed up against the rocks and 
		splintered into a million pieces.  Most of it's probably been 
		washed away by the torrent of water."
	noun = 'boat' 'wreck' 'ship' 'boatwreck' 'shipwreck' 'pieces' 'litter'
		'craft' 'fragments'
	adjective = 'wrecked' 'splintered' 'small' 'one-person' 'two-person' 
	location = westbank2
;
Dtrees3: Decoration
	sdesc = "dense clump of trees"
	noun = 'trees'
	location = westbank2
;

westbank2: Outside
	sdesc = "On the West Bank of the River, at the Boat Wreck"
	ldesc = {
		if (Me.isin(acmedinghy)) {
			I(); "As you struggle to avoid being pitched
			out of the dinghy, you notice, to your chagrin,
			the fragments of a boat that didn't make
			it through this area in one piece scattered around
			the nearby shore.";
		}
		else {
 			I(); "You're on the west bank of the river. Some 
			fool tried to take a boat out in these 
			waters, and you see before you the end 
			result: pieces of boat litter the bank.  You 
			can only go back upstream, to the north -- 
			your path downstream is blocked by the 
			trees.";
		}
	}

	north = westbank1
	
	east = {
		if (figurine.tossed) {
			"You walk nimbly across the jade pathway,
			the violent rapids snapping at your heels
			all the way.\b";

			return westbank2jadepath;
		}
		else {
			"Trying to swim across would surely be suicidal.
			Just look what happened to the boat.";
			return nil;
		}
	}
;

//
// New stuff for Legend
//
acmedinghypellet: Item
	sdesc = "tiny mauve pellet"
	ldesc = {
		"Nearly microscopic words on the pellet read,
		\"Acme Sooper Stirdhee Deehaidredid Dingheee (tm) --
		Juhst Ahd Wadur and it Blowz Uhp in Sekundz!\"";
	}
	noun = 'pellet' 'dinghy' 'dinghee'
	adjective = 'tiny' 'mauve' 'dehydrated' 'deflated' 'dinghy'
		'acme' 'sooper' 'stirdhee' 'deehaidredid' 'dinghee'
		'super' 'sturdy'
	location = nil
;
acmedinghy: Chair, Item
	reachsurroundings = true
	islistable(actor) = {		// so the dinghy is listed only
		if (Me.isin(self))	// when we're not in it.
			return nil;
		else
			return true;
	}
	
	count = 0

	sdesc = "mauve dinghy floating in the water"
	thedesc = "the mauve dinghy"
	ldesc = {
		"It looks like an ordinary dinghy, painted a 
		particularly nauseating shade of mauve.  You can't 
		really see them, but you're sure that there are tiny 
		letters on the bottom of the craft that read, \"Acme 
		Dam Saph Dingheee,\" or something along those 
		lines.";

		if (not Me.isin(self))
			" It's rapidly drifting downstream near the shore
			here.";
	}
	weight = 500	// Don't want player to take it, but want it
	bulk = 500	// to be listed.

	noun = 'dingy' 'dinghy' 'boat' 'craft' 'ship'
	adjective = 'mauve' 'acme' 'dam' 'saph' 'damn' 'safe'
	location = nil

	verDoBoard(actor) = { self.verDoEnter(actor); }
	doBoard(actor) = { self.doEnter(actor); }

	floataway = {
		self.count := self.count + 1;
		if (self.count > 3) {
			self.count := 0;
			if (self.location = bigoak) {
				self.movein(westbank1);
				if (Me.isin(self)) {
					P();
					"The dinghy floats downstream...\b";
					Me.location.lookaround(Me, true);
				}
				else if (Me.isin(bigoak)) {
					P(); I();
					"The dinghy floats out of view
					downstream.";
				}
 				else if (Me.isin(westbank1)) {
					P(); I();
					"The dinghy floats into view
					from farther upstream.";
				}
			}
			else if (self.location = westbank1) {
				self.movein(westbank2);
				if (Me.isin(self)) {
					P();
					"The dinghy floats downstream...\b";
					Me.location.lookaround(Me, true);
				}
				else if (Me.isin(westbank1)) {
					P(); I();
					"The dinghy floats out of view
					downstream.";
				}
 				else if (Me.isin(westbank2)) {
					P(); I();
					"The dinghy floats into view
					from farther upstream.";
				}
			}
			else if (self.location = westbank2) {
				unnotify(self, &floataway);
				self.movein(nil); // must follow Me.newlocation
						  // o.w. leave(actor) will
						  // crash
				if (Me.isin(self)) {
					P(); "Just as the rapids really start
					getting tricky, the dinghy springs
					a leak!  The shoddily-made craft
					almost instantly capsizes, and for
					a moment you're sure you'll soon
					be joining Duhdha and your
					ancestors, but through a miraculous
					job of doggie paddling, you somehow
					make it back to shore and emerge...\b";

					Me.position := 'standing';
					Me.newlocation(westbank2, 'in');
				}
				else if (Me.isin(westbank2)) {
					P(); I();
					"The dinghy floats out of view
					downstream.  Unfortunately
					it seems that you have no way
					of following it from here.";
				}
			}
		}
	}

	roomdrop(actor, obj) = {
		"There's really nowhere to put <<obj.objthedesc(nil)>>
		\ in the little dinghy.";
	}
;
jadepath: floatingdecoration
	sdesc = "jade path"
	ldesc = "It looks like a strip of frozen, jade-colored water."

	noun = 'path' 'water' 'strip' 'bridge'
	adjective = 'jade' 'colored' 'jade-colored' 'narrow' 'brilliant'
		'hard' 'hardened' 'frozen' 'magic'

	location = {
		if (figurine.tossed)
			return inherited.location;
		else
			return nil;
	}
	loclist = [
		bigoak westbank1 westbank2 bigoakjadepath
		westbank1jadepath westbank2jadepath
		westbank3jadepath hutjadepath outsidehut
	]
;
jadepathwater: floatingdecoration
	sdesc = "rushing river"
	noun = 'river' 'rapids' 'water'
	adjective = 'rushing' 'violent'
	
	loclist = [
		bigoakjadepath
		westbank1jadepath westbank2jadepath
		westbank3jadepath hutjadepath
	]
;
jadepathsoil: floatingdecoration
	sdesc = "river bank"
	noun = 'soil' 'dirt' 'shore' 'bank'
	adjective = 'red' 'river'

	loclist = [
		bigoakjadepath
		westbank1jadepath westbank2jadepath
		westbank3jadepath hutjadepath
	]
;
class jaderoom: Outside
	gowest = true
	sdesc = "On the Jade River Path"
	ldesc = {
		I(); "You're standing on a brilliant jade-colored
		path made of what seems to be solid water.  You
		can travel upstream, to the north";

		if (not self.gowest)
			", or ";
		else
			"; ";

		"downstream, to the south";

		if (self.gowest)
			"; or west, back to the shore";

		".";
	}
	noexit = {
		"I wouldn't recommend leaving the path that Duhdha has
		provided for you.";

		return nil;
	}
;
bigoakjadepath: jaderoom
	ldesc = {
		I(); "You're standing on a brilliant jade-colored
		path made of what seems to be solid water.  You
		downstream, to the south, or west, back to the
		shore.";
	}

	west = {
		"You carefully follow the jade path through the water back
		to shore.\b";

		return bigoak;
	}
	se = {
		"You make your way downstream along the jade water-bridge.\b";

		return westbank1jadepath;
	}
	south = { return self.se; }
	sw = { return self.se; }
	nw = {
		"The path ends here.";
		return nil;
	}
	north = { return self.nw; }
	ne = { return self.nw; }
;
westbank1jadepath: jaderoom
	west = {
		"You carefully follow the jade path through
		the water back to shore.\b";

		return westbank1;
	}
	nw = {
		"You make your way upstream along the jade water-bridge.\b";

		return bigoakjadepath;
	}
	north = { return self.nw; }
	ne = { return self.nw; }

	se = {
		"You make your way downstream along the jade water-bridge.\b";

		return westbank2jadepath;
	}
	south = { return self.se; }
	sw = { return self.se; }
;
westbank2jadepath: jaderoom
	west = {
		"You carefully follow the jade path through
		the water back to shore.\b";

		return westbank2;
	}
	nw = {
		"You make your way upstream along the jade water-bridge.\b";

		return westbank1jadepath;
	}
	north = { return self.nw; }
	ne = { return self.nw; }

	se = {
		"You make your way downstream along the jade water-bridge.\b";

		return westbank3jadepath;
	}
	south = { return self.se; }
	sw = { return self.se; }
;
westbank3jadepath: jaderoom
	gowest = nil
	west = {
		"There's no path leading back to shore here. This may
		be related to the fact that the west bank is too
		steep for you to get up to it.";

		return nil;
	}

	nw = {
		"You make your way upstream along the jade water-bridge.\b";

		return westbank2jadepath;
 	}
	north = { return self.nw; }
	se = {
		"You make your way downstream along the jade water-bridge.\b";

		return hutjadepath;
	}
	south = { return self.se; }
;
hutjadepath: jaderoom
	ldesc = {
		I(); "You're standing on a brilliant jade-colored
		path made of what seems to be solid water.  The
		river forks here, and the jade bridge veers off
		to the west, back to shore.  If you want to continue
		downstream you'll need to find a different means
		of transportation."; P();

		I(); "You can travel upstream, to the north, or west,
		back to the shore.";
	}

	west = {
		"You carefully follow the jade path through
		the water back to shore.\b";

		return outsidehut;
	}

	nw = {
		"You make your way upstream along the jade water-bridge.\b";

		return westbank2jadepath;
	}
	north = { return self.nw; }
;
outsidehut: Outside
	sdesc = "Outside Hut"
	ldesc = {
		I(); "You are standing outside a primitive-looking hut 
		tucked snugly in the dense surrounding forest, near 
		the shore of the river.  The jade water-path that got 
		you here still leads out to the center of the 
		whirling rapids, to the east."; P();

		I(); outsidehuthut.ldesc; " The hut entrance is to the
		north.";
	}
	east = hutjadepath
	north = hut
	in = { return self.north; }
	up = {
		"What a concept.";
		return nil;
	}
	down = {
		"What do you think you are, a mole?";
		return nil;
	}
	noexit = {
		"You head out into the thick forest, but soon lose 
		your bearings completely, and, fearing that you'll 
		*really* get yourself lost in the wilderness, head 
		back the way you think you came.";

		return nil;
	}
;
outsidehuthut: Decoration
	sdesc = "hut"
	ldesc = {
		"The hut is made of grass and mud, and looks much 
		like your former master Kuulest's domicile, where the 
		old geezeburger raised you to be an untrained, 
		untutored, useless, inept... oh, never mind.";
	}

	location = outsidehut
	noun = 'hut' 'hovel' 'house' 'home'
	adjective = 'simple' 'primitive' 'primitive-looking' 'grass'
		'mud' 'humble'
;
hut: Room
	sdesc = "Hut"
	ldesc = {
		if (not self.isseen) {
			I(); "You stride into the humble hovel, assuming
			it's long-abandoned.  After all, who would possibly
			be living here, in the middle of a seemingly
			impassable forest bordered by treacherous
			rapids?"; P();

			I(); "\"Kuulest!\" you shout, amazed to find
			an answer to your rhetorical question staring
			you right in the face.  \"What are YOU doing
			here?\""; P();

			I(); "\"Ah, you again, my child.  I was hoping
			Duhdha would cross our paths before too long --
			I'm not much with mechanical things, and this
			Acme Egg Fraier (tm) seems,\" he chuckles,
			\"quite beyond all heavenly help.  And it's
			way past my normal breakfast time, you
			understand.\""; P();

			I(); "It takes all the self-control you've
			got to keep yourself from ripping the stupid
			egg fryer out of the monk's hands and clubbing
			him with it.  You just saved the planet and
			he's complaining about missing breakfast?!  You
			get the feeling it's going to be a long day..."; P();

			"***"; P();
		}

		I(); "You're inside Kuulest's hut, which is functional at 
		best.  The walls and floor are made of grass, mud, 
		and other unidentifiable (but surely unpleasant) 
		substances.  Aside from Kuulest and his Sooper Egg
		Fraier (tm), there's little here."; P();

		I(); "The exit is to the south.";
	}

	south = outsidehut
	out = { return self.south; }
	up = {
		"What a concept.";
		return nil;
	}
	down = {
		"What do you think you are, a mole?";
		return nil;
	}
	noexit = {
		"You head out into the thick forest, but soon lose 
		your bearings completely, and, fearing that you'll 
		*really* get yourself lost in the wilderness, head 
		back the way you think you came.";

		return nil;
	}

	enter(actor) = {
		notify(kuulest, &kuulesttalk, 0);
		inherited.enter(actor);
	}
	leave(actor) = {
		unnotify(kuulest, &kuulesttalk);
		inherited.leave(actor);
	}
;
kuulest: Male, Actor
	sdesc = "Kuulest"
	adesc = { self.sdesc; }
	thedesc = { self.sdesc; }

	ldesc = {
		"Kuulest looks a lot like the old monk you met back 
		at the retreat in the woods. He's studying his Egg 
		Fraier (tm) intently, evidently hoping that he has, 
		without realizing it, suddenly acquired the ability 
		to fix electrical appliances.";
	}
	noun = 'kuulest' 'man' 'monk'
	adjective = 'old' 'ancient' 'wizened' 'wise'
	location = hut
	actordesc = {
		"Kuulest is here, examining his Sooper Egg Fraier (tm)
		with great care and a puzzled look on his face.  He
		mutters something about not wanting to miss breakfast.";
	}

	verIoGiveto(actor) =  {}
	ioGiveto(actor, dobj) = {
		if (dobj = friedegg) {
			incscore(4); P();

			I(); "Kuulest gratefully accepts the fried 
			egg. \"A marvelous breakfast, my child,\" he 
			says. \"I thank you.  May you never sneeze 
			into an oncoming gale.  Perhaps we shall meet 
			again some day when you are farther along the 
			path of life.  But first, I will use Duhdha's 
			help to give you a chance at new 
			enlightenment.\""; P();

			I(); "Inexplicably, Kuulest sticks out his 
			tongue and tugs on his right ear.  Moments 
			later your realize you're...\b";
			
			friedegg.movein(nil);
			Me.travelto(AtTheCenter);
		}
		else if (dobj = friedsynthegg) {
			I(); "Kuulest gratefully accepts the fried 
			SynthEgg. \"A marvelous breakfast, my 
			child,\" he says. \"I thank...\"."; P();

			I(); "Suddenly he sniffs the SynthEgg and 
			flies into a mad rage! \"How dare you bring 
			this ghastly affront to Duhdha into my 
			abode!\" he bellows. \"May a thousand smelly 
			warts afflict the monstrous chemists who 
			brought this evil into the world!\".  He 
			carries the SynthEgg to the river and 
			sneeringly hurls it into the depths.  He 
			refuses to speak to you as you follow him 
			back to his hut."; P();

			I(); "It is a great while before he is calm 
			again.";

			friedsynthegg.movein(nil);
		}
		else if (dobj = egg or dobj = synthegg) {
			"Kuulest looks up from his Sooper Egg Fraier 
			(tm) and shakes a finger at you.  \"An egg is 
			a fine breakfast indeed.  But uncooked eggs 
			are the devil's drink.\"";
		}
		else if (dobj = cinder or dobj = synthcinder) {
			"Kuulest shakes his head and frowns 
			disapprovingly. \"My child, that is not a fit 
			breakfast for even the lowest of all Duhdha's 
			creatures, the obsessive adventure gamer.\"";
		}
		else if (dobj.isseeds) {
			"\"Those may produce nourishment some day, my 
			child,\" Kuulest patiently explains, \"but my 
			breakfast will already be late enough 
			today.\"";
		}
		else if (dobj = snax) {
			"Kuulest reels in horror. \"What foul manner 
			of Unnkulian poison is this?!\" he bellows.";
		}
		else if (dobj = wackyputty) {
			"Kuulest gasps.  \"Get that horrible 
			demon seed out of my sight at once!\"
			he bellows.";
		}
		else {
			"Kuulest pats you on the head and chuckles.  \"What
			need I of such worldly things, my child?\"";
		}
	}
	verDoAskabout(actor, io) = {}
	doAskabout(actor, io) = {
		if (io = egg)
			"Kuulest frowns. \"An uncooked egg is the pitiful
			dregs.\"";
		else if (io = friedegg)
			"Kuulest smiles. \"Of such things, a friend of mine
			used to say, 'If cooked it be, it's damn tasty.'";
		else if (io = acmedinghypellet)
			"Kuulest grabs his gut. \"A foul affront to
			Duhdha!\"";
		else if (io = outsidehuthut)
			"\"It's humble,\" Kuulest says serenely, \"but
			it is home enough for me.\"";
		else
			"Kuulest is absorbed in trying to fix his
			broken egg fryer.";
	}

	verDoTellabout(actor, io) = {}
	doTellabout(actor, io) = {
		"Kuulest listens intently for a moment, then
		frowns.  \"Tut-tut,\" he chides, \"so interested
		in worldly concerns.  Blessed be the oblivious,
		for they shall be pleased with the dregs.";
	}

	KuulestMessage = [
		'Kuulest puts the Egg Fraier (tm) down for a second, and
		begins to sing to himself quietly: "Zippity Duh-dha, zippity
		Dei; my, oh my, what a wonderful Way..."'

		'Kuulest cautiously taps the base of the Egg Fraier (tm)
		several times, then holds the device up to his ear, his
		brow furrowed.'

		'Kuulest scratches at one of the screws holding the
		handle on the Egg Fraier (tm). "Praise be, why so
		complicated?" he mutters.'

		'All of the sudden, Kuulest flies into a rage and
		begins cursing to himself and repeatedly whamming the Egg
		Fraier into the floor of his hut.  Moments later he takes a
		deep breath, looks up at you, laughs nervously, and says,
		"It would seem that Duhdha no longer wills this item to
		function."'

		'Kuulest lectures you briefly on proper egg care, and
		relates a drawn-out allegory about an unfortunate
		fellow who accidentally sat on Duhdha\'s Favorite Egg.'

		'After a brief period of absolute silence, Kuulest begins
		chanting quietly to himself: "ooooooh... muuuuuuu...
		leeeeeeeht..."'

		'Kuulest adjusts some knobs on the Egg Fraier (tm) and
		then blows on it.  He looks surprised when he turns it on
		and finds that it still fails to function.'
	]

	kuulesttalk = {
		if (self.location = Me.location) {
			P(); I();
			say(self.KuulestMessage[rnd(7)]);
		}
	}

	verDoSmell(actor) = {}
	doSmell(actor) = { "Kuulest smells like an Egg McMuffin."; }
	verDoRub(actor) = {
		"I don't think Kuulest would appreciate your amorous
		advances, frankly.";
	}

;

AtTheCenter: Room
	walls = nil
	ceiling = nil
	ground = nil

	sdesc = "At the Center of All Things"
	ldesc = {
		I(); "This place is like nowhere you have ever been 
		or imagined.  It seems to have no end.  It encloses 
		you with terrifying completeness, and yet here you 
		feel like you are outside -- above, beyond -- every 
		other place you've visited in your travels."; P();

		I(); "The form changes with every moment; at once an 
		infinite black void, and then a vivid technicolor 
		landscape that seems to hint at every scene you have
		cast your gaze upon."; P();

		I(); "The power in this place is immense.  You feel 
		tendrils from the ethereal energy web that courses 
		through your surroundings.  They dance across your
		body, probing and manipulating you.";
	}
	
	noexit = {
		"This place seems to continue without end in all 
		directions.";

		return nil;
	}
;
centernote: Item, Readable
	location = AtTheCenter
	noun = 'scrap' 'paper' 'calligraphy'
	adjective = 'ordinary' 'looking' 'ordinary-looking' 'white'
			'beautiful' 'beautifully' 'ornate'

	sdesc = "scrap of paper"
	ldesc = {
		"It's an ordinary-looking scrap of white paper, with
		beautifully ornate calligraphy on it. ";

		self.readdesc;
	}
	readdesc = {
		"The paper reads as follows:"; P();

		I(); "\"You have proven your fortitude and your 
		courage. But these are only two virtues of many. 
		Wisdom and clarity of thought are also essential to 
		continued growth in this life.  Understanding the 
		meaning and power of words is part of this."; P();

		I(); "\"To improve, we must practice.  And so here is 
		a riddle of words for you to begin with:"; P();

		I(); "For mama and papa they meet twice.\n";
		I(); "For grandma and grandpa they meet but once.\n";
		I(); "For son and daughter they do not meet at all.\n";
		I(); "What are they?"; P();
		
		I(); "\"Puzzles have another great significance -- 
		they have egg-nature; to reach the seed of knowledge 
		inside we must first crack them open."; P();

		I(); "\"Many students of The Way find this puzzle 
		quite difficult, and thus it has come to be known as 
		'Duhdha's Riddle of Extreme Annoyance.'  Once you 
		have found the answer, say it aloud to prove that 
		your are worthy of advancement. Until then, you can 
		stay for a time and ponder.";
	}
;
answerriddle: object
	scored = nil
	transition = {
		if (not self.scored) {
			self.scored := true;
			"Congratulations!  You have solv\b";
			"\t*** System error: unidentified external interrupt";
			
			uu3transition.backtolegend;

			P(); I(); "Your load seems a bit heavier.";

			incscore(4);

			mirror.movein(Me);
		}
		else {
			"Congratulations!  You have solv\b";
			"\t*** An inexplicable system error has occurred.";
			
			uu3transition.backtolegend;

			P(); I(); "A voice in your head says, \"Nice try,
			you cheater.\"";
		}
	}
;

mirror: Item
	firsttime = true
	sdesc = "mirror"
	ldesc = {
		if (self.firsttime) {
			self.firsttime := nil;

			I(); "You gaze into the mirror, and are 
			greeted not with your own image, but with the
			likeness of a king!  The king seems to 
			speak:"; P();

			I(); "\"At the end of each life we are born 
			anew.  Your artifact, the program, has been a 
			window to a past you helped to forge in 
			another life.  Now when you set your eyes 
			upon this glass, be reminded that once again 
			all the peoples of your domain need your 
			leadership.\""; P();

			I(); "\"This mirror will help you; reflect upon its
			many uses.  When you carry it with you, Duhdha will
			be at your side. But remember that time is the one
			assassin of hopes and desires who shall always escape
			justice.\""; P();

			I(); "The image fades.";
		}
		else {
			"The mirror looks fairly typical, except that 
			it seems unusually sturdy and is backed with 
			a shiny black crystalline material.";
		}
	}
	location = nil
	noun = 'mirror' 'glass' 'back'
	adjective = 'looking' 'mirror'

	verDoLookin(actor) = {}
	doLookin(actor) = {
		if (self.firsttime) {
			self.ldesc;
		}
		else
			"You see your reflection.  It looks uncommonly
			noble.";
	}
;
mirrorback: Part
	partof = mirror
	sdesc = "mirror backing"
	ldesc = {
		"Examining the backing provides you no clue
		to its structural characteristics or origin.";
	}
	noun = 'back' 'backing' 'material'
	adjective = 'mirror' 'glass' 'back' 'looking' 'mirror'
		'shiny' 'black' 'crystal' 'crystalline'
;

#endif	/* DEMO */
