#charset "us-ascii"
#include <advlite.h>

//    narrowLedge
//    byTheKiosk
//    peeWeeTee
//    byTheDragon

//////////////////////////////////////////////////////////////////////////////
// narrowLedge
//////////////////////////////////////////////////////////////////////////////

Doer 'jump'
    execAction(c) { "It's an awful long way down. "; }
    where = [narrowLedge, ledgeSouth]
;

narrowLedge: Room 'Narrow Ledge'
    "This narrow and precarious ledge runs along the eastern edge of the roof of
    Stufftown. A large, vividly colored, and rather stupid-looking dragon (or at least the head of
    the dragon) is visible on the main part of the roof, off to the west, but there
    appears to be no way to get there from here. A slightly broader area
    at the south end of the ledge is accessible, however. To the northwest
    is the upper part of the round tower, the wall of which is interrupted by a
    stone archway. "
    
    // The arch will always be open when you're here.
    north asExit(northwest)
    northwest = narrowLedgeArch
    south = ledgeSouth
    
    iobjFor(PutOn) {
        verify() {}
        action() {
            doInstead(Drop, gDobj);
        }
    }
;

+ Decoration 'round tower; ; exterior'
    "The round tower is to the north and northwest of where you\'re standing. "
    notImportantMsg = 'Other than being part of the structure of Stufftown, the exterior
        of the tower is not important. '
;

+ Decoration 'roof'
    "The roof stretches away from you to the west, but you can't get there from here.
    You could go south, however. "
;

+ narrowLedgeArch: OctagonExteriorPassage '+; (northwest)'
;

//------------------------------------------------------------------------------
// ledgeSouth
//------------------------------------------------------------------------------

ledgeSouth: Room 'The South End of the Ledge'
    "The ledge ends here, at the southeast corner of the roof. Other than the possibility
    of pitching over the edge and breaking your neck, the main attraction of this remote
    location is a large trough.
    
    <.p>From here, the ledge extends northward. "
    
    north = narrowLedge
    
    beforeTravel(traveler, connector) {
        if (zarbolphung.isIn(ledgeSouth) && (connector == narrowLedge)) {
            "As you turn to leave, the wizard waves bye-bye, says, <q>See
            you soon,</q> and leaps off of the ledge. His robes billow out
            around him as he plunges down out of sight.
            <.p>With a mighty <i>scrawkkk!</i>, the pterodactyl flaps its
            wings heavily and takes its leave as well. ";
            zarbolphung.moveInto(seeressLair);
            pterodactyl.moveInto(nil);
            rawChow.moveInto(nil);
        }
    }
;

+ Decoration 'edge'
    "The edge is devoid of railing. "
;

+ Unthing 'railing'
    notHereMsg = 'There\'s no railing. '
;

+ Decoration 'roof'
    "The roof stretches away from you to the west, but you can't get there from here.
    You could go north, however. "
;

+ trough: Container, Fixture 'rough-hewn trough; rough dark heavily scarred; wood'
    "The trough is hewn of some rough, dark wood. Its sides are heavily scarred,
    as if by claws, and other claw marks are evident around its base. "
    iobjFor(PourInto) {
        verify() { logical; }
        check() {
            if (contents.car != nil) "Maybe before you do that, you should pick
                up what you put in the trough. ";
        }
    }
    smellDesc = "It has an earthy, biological odor. "
;

+ clawMarks: Decoration 'claw marks'
    "The claw marks are scored into the wood of the trough. "
    plural = true
;

//------------------------------------------------------------------------------
// byTheKiosk
//------------------------------------------------------------------------------

distantDragon: MultiLoc, Distant
    'dragon\'s head; vividly colored stupid-looking large scaly garishly painted; dragon'
    "The dragon's head is large, scaly, and garishly painted. <<if (junctionBox.isPowered)>>Its toothy
    mouth is opening and closing in a dangerous and unceasing grimace. "
    locationList = [byTheKiosk, peeWeeTee, narrowLedge]
;

byTheKiosk: Room 'The Miniature Golf Course'
    "The roof of Stufftown is flat, and is being put to better commercial use
    than it was ten years ago. From the roof you can see, in the distance, the treetops and roofs of the town.
    Directly before you stands a kiosk, or shed, atop which a sign reads,
    <q>SKY HIGH PEE WEE.</q> Evidently the reference is to miniature golf, because a
    rather minimal miniature golf course is indeed laid out across the roof.
    <.p>To the
    south is an enclosed structure with a door, above which a sign reads, <q>STAIRWELL.</q>
    To the east is an open stairway leading downward. The first tee of the golf course
    is to the north, and a large, garishly painted dragon's head is located not far
    off to the northeast. "
    
    down = roofStairwayDown
    east asExit(down)
    south = stairwellTopExitDoorExterior
    north = peeWeeTee
    northeast = byDragonHead
;

+ Decoration 'roof'
    "The roof is all around you. "
;

+ peeweeSign: ShopSign 'sky high pee wee +; miniature (golf)'
    "The <q>SKY HIGH PEE WEE</q> sign is affixed to the front of the shed. "
;

+ stairwellTopExitDoorExterior: Door 'stairwell door'
    "It's a sturdy-looking door. "
    
    isLocked = true
    otherSide = stairwellTopExitDoorInterior
    isOpen = nil
    lockability = indirectLockable
;

+ roofStairwayDown: StairwayDown 'stairway; (down); stairs staircase'
    "The stairway descends through a large gap in the roof. "
    destination = upperConcourseWest
    travelDesc = "(descending the stairs) "
    dobjFor(ClimbDown) {
        action() {
            if ((betsy.getOutermostRoom() == gPlayerChar.getOutermostRoom()) &&
                betsy.curState == betsyClinging)
                betsyClinging.departMessages.doScript();
            inherited();
        }
    }
;

+ kiosk: Fixture 'kiosk;; shed'
    "At a guess, the shed is where people who want to try their hand at miniature golf
    can acquire golf balls and putters. An iron grille has been drawn down over
    the open front of the shed; like most of the shops in Stufftown,
    Sky High Pee Wee is closed. The grille doesn't quite reach the floor, however. "
    dobjFor(LookIn) {
        verify() {}
        action() {
            doInstead(LookIn, ironGrille);
        }
    }
    dobjFor(Enter) {
        verify() {}
        check() {
            "Alas, the grille is in the way. ";
        }
    }
;

++ ironGrille: Component 'iron grille; metal; grill mesh bars'
    "The grille blocks access to the interior of the shed. However, there's a narrow
    gap between the bottom of the grille and the floor. "
    dobjFor(Lift) asDobjFor(Open)
    dobjFor(Open) {
        verify() {}
        check() {
            "You rattle the grille, but it's securely fastened in place, and there's
            no keyhole or anything of the sort. ";
        }
    }
    dobjFor(LookUnder) asDobjFor(LookIn)
    dobjFor(LookThrough) asDobjFor(LookIn)
    dobjFor(LookIn) {
        verify() {}
        check() {}
        action() {
            if (putter.isIn(narrowGap)) "Through the grille you can see a putter
                lying on the floor not too far from the narrow gap below the grille. ";
        }
    }
    iobjFor(PutUnder) {
        verify() {}
        action() {
            doInstead(PutIn, gDobj, narrowGap);
        }
    }
;

++ narrowGap: Component, Container 'narrow gap'
    "The gap is between the floor and the bottom of the grille. It's too narrow to
    slip your hand and arm into it, but you might be able to reach in if you had something
    long and thin. "
    iobjFor(SlideInto) {
        verify() { logical; }
        check() {
            if ((gDobj != knittingNeedle) && (gDobj != blowgun)) "If you put anything into the narrow gap, you're
                going to find it impossible to get it out again. Unless, of course, it's
                long and thin and rigid and you're holding onto the near end. ";
        }
        // We'll let the knitting needle retrieve the putter ... or the blowgun.
    }
    iobjFor(PutIn) {
        check() {
            if ((gDobj != knittingNeedle) && (gDobj != blowgun))
                "If you put anything into the narrow gap, you're going to find it impossible to
                get it out again. You might be able to slide something long and thin into the
                gap, however. ";
        }
    }
    
;
    
//------------------------------------------------------------------------------
// peeWeeTee
//------------------------------------------------------------------------------

distantTooth: Distant 'tooth'
    "The tooth is down there by the dragon's head. "
;

peeWeeTee: Room 'At the Tee'
    "From this little pad (weathered green AstroTurf) you could smack a golf ball
    eastward to where an impressively large dragon's head awaits. If you had
    a golf ball and something to smack it with, that is. "
    
    floorObj = teePad
    
    south = byTheKiosk
    east = byDragonHead
    
    dobjFor(PutOn) {
        verify() {}
        action() {
            doInstead (Drop, gDobj);
        }
    }
;

+ teePad: Fixture, Surface 'pad; weathered green scuffed astroturf; mat'
    "The pad is rather scuffed, evidently from people dropping golf balls onto it
    and then hitting them toward the dragon's head. "
    dobjFor(PutOn) {
        verify() {}
        action() {
            doInstead (Drop, gDobj);
        }
    }
;

//------------------------------------------------------------------------------
// byDragonHead
//------------------------------------------------------------------------------

dragonTeeth: Component 'teeth; dragon dragon\'s sharp large dangerous rapidly moving;; them'
    "The dragon's teeth are large, sharp, and rapidly moving. "
    dobjFor(Feel) {
        check() {
            "Do you want to have your fingers sliced off? (This is a rhetorical question.) ";
        }
    }
;

byDragonHead: Room 'By the Dragon\'s Head'
    "The large and garishly painted dragon's head is close enough to
    touch<<if (junctionBox.isPowered)>> --- but given the alacrity with which its
    mechanical jaws are opening and closing, that might not be such a swell
    idea<<else>>. Its wide mouth is firmly closed<<end>>.
    
    <.p>From here, you can go west to the tee, or southwest to the kiosk. "
    
    west = peeWeeTee
    southwest = byTheKiosk
    
    iobjFor(PutIn) {
        action() {
            doInstead (PutIn, gDobj, dragonHead);
        }
    }
;

+ dragonHead: Fixture 'dragon\'s head; garishly painted; beast reptile monster dragon'
    "The dragon's head is taller than you are. Its scales are an iridescent gray,
    and its head is crowned by spiky purple tufts. Fortunately, it doesn't seem to have any
    body; it's all head. <<if (junctionBox.isPowered)>>The grotesquely toothy mouth
    is opening and closing with a rapid up-and-down motion of the lower jaw. Apparently
    the idea is that you'll be able to putt a golf ball into the mouth during the intervals
    when the mouth is open, but the timing of the movements is irregular. What happens to
    the golf ball after the dragon ingests it --- let's not think too much about that,
    shall we? <<else>>The dragon's lower jaw is firmly clamped shut, revealing neither
    teeth nor tongue (if it has either). <<end>>The eyes of the dragon are larger than
    dinner plates<<if (junctionBox.isPowered)>>, and the pupils tumble around in a
    rapid and hypnotic but disorienting way, blinking first green, then
    pink, then blue, and then violet, after which they go dark for a moment before
    repeating the pattern<<end>>. "
    
    vocabLikelihood = 15
    
    // the showTeeth command will be issued by the junctionBox when it's turned on or off,
    // in order to manage the visibility of the component parts of the dragon. However,
    // be aware that this doesn't work well when you use the 'poweron' testing command.
    // If you examine the dragon itself, it will call the junction box, whose code for
    // isPowered will get rid of the teeth.
    teethShowing = nil
    showTeeth(stat) {
        if (stat) {
            dragonTeeth.moveInto(dragonHead);
            teethShowing = true;
        }
        else {
            dragonTeeth.moveInto(nil);
            teethShowing = nil;
        }
    }
    dobjFor(Feel) {
        check() {
            if (junctionBox.isPowered) "The constant clashing of the jaws, and the size
                and sharpness of the teeth housed therein, make touching it an undesirable
                act. ";
        }
        action() {
            "Its surface feels roughly scaly. ";
        }
    }
    dobjFor(LookIn) {
        verify() {}
        check() {
            if (!teethShowing) "The dragon's mouth is firmly closed. ";
            else "The only thing you're going to see in there is a nasty lot of very large,
                sharp teeth. ";
        }
    }
    dobjFor(Open) {
        verify() {}
        check() {
            if (!teethShowing) "You have a go at prying its mouth open, but to no avail. ";
            else "The thing's mouth is already wide open (though intermittently, as it opens
                and closes in an irregular rhythm). ";
        }
    }
;

++ dragonEyes: Component '(dragon\'s) eyes; ; eye'
    "The dragon\'s eyes are huge<<if (junctionBox.isPowered)>>, and the pupils tumble around in a
    rapid and hypnotic but disorienting way, blinking first green, then
    pink, then blue, and then violet, after which they go dark for a moment before
    repeating the pattern<<end>>. "
    plural = true
;

++ Decoration 'jaw'
    "The dragon\'s lower jaw is situated, in the usual anatomical manner, below its mouth. "
;
++ Decoration 'purple tufts; spiky'
    "The tufts are purple and tufty. Last year Samantha had a boyfriend with hair like that,
    but he didn\'t last long. "
    plural = true
;
++ Decoration 'scales; iridescent gray'
    "The scales lend an air of forlorn nobility to the beast. "
    plural = true
;

++ dragonMouth: Component '(dragon\'s) mouth'
    "The mouth of the dragon is <<if (!dragonHead.teethShowing)>>grinning evilly, but
    without revealing any of its doubtless fearsome complement of teeth<<else>>gnashing
    open and shut, displaying a fearsome array of large teeth<<end>>. "
    dobjFor(PutIn) {
        verify() {}
        check() {
            if (!dragonHead.teethShowing) "The dragon\'s mouth is closed. ";
            else "The dragon could probably chew up almost anything, the way those teeth
                are operating, but you have nothing that you want mangled. ";
        }
    }
    dobjFor(Feel) {
        verify() {}
        check() {
            if (dragonHead.teethShowing) "You'd probably lose a few fingers. ";
        }
        action() {
            "You feel nothing unexpected. ";
        }
    }
    dobjFor(Open) {
        verify() {}
        check() {
            if (dragonHead.teethShowing) "The dragon's mouth is basically wide open. ";
            else "There\'s no obvious way to do that. ";
        }
    }
;
    