#charset "us-ascii"
#include <advlite.h>

// Because 'hold a seance' is a useful command:
seance: Decoration 'seance' @seeressLair
    "No seance is being held just now. "
    notImportantMsg = 'If you want the fortune teller to summon a ghost, tell her 
        <q>summon a ghost.</q> '
;

madameB: Actor
    'fortune teller; heavy heavy-set well padded well-padded rotund fat old; madame lady seeress woman; her' @seeressLair
    "{The madame} is quite heavy-set. Rotund, basically. Well padded, let\'s say.
    Her hair is long, curly, and of an unconvincing
    dead black hue, which contrasts with her pale, powdered features. Her eyebrows are tweezed to
    thin lines. She's wearing a multicolored
    muumuu somewhat smaller than a circus tent, and she has more rings on her fingers than she has
    fingers. "
    cannotTakeMsg = 'You wouldn\'t be able to lift her. '
    cannotPutPersonMsg = 'That\'s unlikely to be a useful thing to do. '
    cannotEatMsg = 'Too much cholesterol. '
    kissResponseMsg = 'You don\'t know her that well. '
    attackResponseMsg = 'She hasn\'t done anything to deserve such treatment. '
    attentionSpan = nil
    cardsReceived = nil
    receiveCards () {
        playingCards.moveInto(madameB);
        cardsReceived = true;
    }
    globalParamName = 'madame'
    giveName {
        proper = true;
        replaceVocab ('Madame Bloviatsky; well padded well-padded heavy heavy-set rotund fat old (fortune); woman teller; her');
    }
    smellDesc = "A thick and cloying floral perfume. "
    shouldNotFeelMsg = "She's on the other side of the table. "
    
;

+ Decoration 'long curly hair; profligate black'
    "Her hair is profligate in its profusion. "
;
+ Decoration 'eyebrows; tweezed thin; lines'
    "Her eyebrows are part of her face. Nothing surprising there. "
    plural = true
;
+ Decoration 'face; pale powdered; features'
    "Her face is located on the front of her head. Do try to pay attention to your ostensible
    goal here. There\'s no need to examine absolutely <i>everything</i>. "
;
+ Decoration 'rings'
    "Yes, they're rings, all right. "
    plural = true
;

+ madameSitting: ActorState
    stateDesc = "She is gazing at you with a benign, mildly inquisitive expression. "
    specialDesc = "A well-padded old woman is sitting behind the table, knitting. "
    isInitState = true
    // This afterTravel code works adequately as a greeting. Could it be fine-tuned?
    afterTravel (traveler, connector) {
        if (traveler == gPlayerChar) greeting.doScript();
    }
    greeting: StopEventList {
        [
            { : "As you enter, {the subj madame} looks up at you brightly. <q>Well, hello, dearie,</q> she
            says in a cheerful tone. <q>I\'ve been expecting you. I expect you\'d
            like to have your fortune told. I wish I could oblige, but someone has absconded
            with my Tarot cards. I always use the Tarot for my magical workings, you see. So
            <<tCards.makeFamiliar()>>all I can do is sit here and knit.</q> " },
            
            '<q>Well, hello, dear,</q> {the subj madame} says as you enter. <q>So nice of
            you to come back to see me again.</q> '
        ]
    }
;

++ TellTopic @tSamantha
    "<q>Oh, that\'s certainly a difficulty,</q> she replies when you tell her about your
    predicament. <q>But I\'m certain you\'ll be able to acquire a suitable dress for her very soon.</q> "
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        '<q>I could tell you a great deal,</q> she murmurs. <q>Perhaps some other time....</q> ',
        
        '<q>Ah, you\'re so inquisitive. That\'s a virtue, you know.</q> ',
        
        '<q>Some things must always remain shrouded in mystery,</q> she says solemnly. ',
        
        '<q>The spirits sometimes whisper to me about such things,</q> she says. <q>But
        their utterances are often enigmatic.</q> ',
        
        '<q>I don\'t know quite what to tell you,</q> she says. '
    ]
;

// To do: Flesh this out.
++ DefaultGiveShowTopic
    "<q>That\'s very nice, isn\'t it?</q> she says. "
;

++ CommandTopic @Summon
    handleTopic() {
            nestedAction(Summon, ralphGhost);
    }
    matchDobj = ralphGhost
    allowAction() { return madameB.cardsReceived; }
;

++ CommandTopic @Hold
    handleTopic() {
            nestedAction(Summon, ralphGhost);
    }
    matchDobj = seance
    allowAction() { return madameB.cardsReceived; }
;

++ DefaultCommandTopic
    handleTopic() {
        if (!ralphGhost.responseGiven) {
            "<q>I\'m just a tiny bit busy at the moment,</q> she replies. <q>There are, I
            suppose, one or two things I might be able to do for you. Perhaps
            you\'ll want to suggest that possibility again later in the afternoon.</q> ";
            ralphGhost.responseGiven = nil;
        }
    }
;

++ AskTellTopic @tSummoning
    "<q>Did you say you could summon a ghost?</q> you ask.
    <.p><q>That is among my abilities, yes,</q> she replies. <q>You need
    only tell me to do so, and I shall.</q> "
;

++ AskTellTopic @rareBookShop
    "<q>Isn\'t there something odd about the book shop?</q> you ask.
    <.p><q>Oh, yes,</q> she replies. <q>Some of the things they do in there
    are --- well, there\'s no pornography, let me put it that way. But some
    of their other publications are not entirely on the up-and-up. There\'s
    a back room, you see.</q>
    <.p><q>Can you tell me how to get into the back room?</q>
    <.p><q>Not in so many words, no. But it\'s all about words, I know
    that much. As you might expect, it being a bookstore. I was told the
    words are a closely guarded secret.</q> She winks at you. <q>A secret,
    definitely.</q> "
;
+++ AltTopic
    "<q>There\'s a machine in the secret room behind the bookstore,</q> you
    tell her. <q>But I don\'t see how to operate it. It seems to want some
    kind of secret code.</q>
    <.p>I\'m sure it does,</q> she replies. <q>Now, let me see. What was I
    told? Ah, that\'s it. You need to take a tour of the future. There are
    signposts, but they\'re in the future. Beyond that, I\'m sure I can\'t
    tell you a single blessed thing.</q> "
    isActive = (shelfDoor.isOpen)
;

++ AskTellTopic @archibald
    "<q>I met the art dealer,</q> you tell her. <q>He seems so sad.</q>
    <.p><q>That\'s so,</q> she replies. <q>It\'s often the case with
    creative people. I\'m sure you could find something that would cheer him
    up, but it would have to be something exotic. I believe he\'s fond of
    music, but simply playing a musical instrument --- no, I\'m sure that wouldn\'t
    work at all. Not exotic enough.</q> "
    isActive = (archibald.curState == archibaldSad)
;

++ TellTopic @playersGroup
    "<q>I saw some men playing cards in the garden,</q> you tell her. <q>It looked
    like they might even be using your cards.</q>
    <.p>Her eyes widen in anger. <q>Is that so? Well, then, I trust you\'ll get the
    cards away from the scoundrels without delay and return the cards to me!</q> "
;
+++ AltTopic
    "<q>After the men got into a fight and ran off,</q> you tell her, <q>I picked
    up your cards.</q> 
    <.p><q>For which I thank you most profusely,</q> she replies. "
    isActive = madameB.cardsReceived
;

++ AskTopic @tCards
    "<q>They're my special cards. Very useful things, cards. I wish someone would find
    them and bring them back to me.</q> "
;
+++ AltTopic
    "<q>Thank you <i>so</i> much for returning them to me! If there's any little service I
    can provide, I'm sure you'll let me know.</q> "
    isActive = madameB.cardsReceived
;

++ AskTellTopic, StopEventList [tPromDress, tBoutique]
    [
        '<q>I came here this afternoon to get a dress for my daughter for the senior prom,</q>
        you say.<.p>
        <q>Such a nice thing to do,</q> the fortune teller replies. <q>I remember my senior
        prom! I know they have lots of nice dresses downstairs in the boutique, but I\'m
        sure they\'ve closed up for the parade.</q> ',
        
        '<q>Do you think you might be able to help me get the dress?</q> you ask.
        <.p><q>I don\'t see how,</q> she replies. <q>If there\'s any way at all to do it, some
        magic might be required. My friend the wizard <<tWizard.makeFamiliar()>> is
        adept at magic. Have you met
        him? But he lost his crystal ball, so he\'s in a foul mood. As matters
        stand, you can\'t expect any help from him.</q> ',
        
        '<q>I\'m afraid I\'ll be no help at all with that,</q> she replies. '
    ]
;

++ AskTellTopic, StopEventList @tWizard
    [
        '<q>You know a wizard?</q> you ask. <q>You mean, like he\'s really a wizard, not
        just a stage magician?</q>
        <.p><q>Oh, yes,</q> she replies. <q>Zarbolphung is the genuine article. He has been
        experimenting with ways to bring wooden figures to life. But don\'t mention Pinocchio
        to him, please --- he prefers to think his conceptions are entirely his own.</q> ',
        
        '<q>Do you think this --- what did you call him, Zarbolphung? --- might be able to
        help me get the prom dress for my daughter?</q>
        <.p><q>Such a spell would be too commonplace to interest him, I fear. But if there
        were something that gave him a challenge, he might be persuaded to assist you.</q> ',
        
        '<q>But where would I find him?</q>
        <.p><q>When he\'s not nearby, he\'s usually flying around on his pterodactyl,</q>
        she explains, not entirely helpfully. <q>Dreadful beast. The pterodactyl, I mean,
        not dear Zarbolphung. It never descends from the roof, fortunately.</q> ',
        
        'She has told you that her friend the wizard might be able to help, but only if
        your request gives him a real challenge. She also mentioned that he and his pterodactyl
        are sometimes to be found up on the roof. '
    ]
;

++ AltTopic
    "<q>Yes, this is my dear friend Zarbolphung,</q> she says, nodding at the wizard. <q>If you\'d like to get
    to know him, I\'m sure you could address questions to him directly.</q> "
    isActive = (zarbolphung.getOutermostRoom() == seeressLair)
;

++ AskTellTopic @guardsGroup
    "<q>Do you know if the security guards here are very efficient?</q> you ask.
    <.p><q>I suppose they're about average,</q> she says. <q>They let somebody run off
    with my Tarot cards, you know. Probably they were taking their afternoon break, so
    they weren't watching the security cameras. Or else the cameras malfunctioned. Or
    else they were responding to an emergency. Last week the octopus escaped from its
    tank, poor thing. They had to chase it all around the lower concourse, or so I
    heard.</q> "
;

++ AskTellTopic @tTarzan
    "<q>There\'s an odd-looking phone booth or something in the travel agency,</q> you
    comment. <q>Do you know anything about it?</q>
    <.p><q>Oh, that? Yes, Sir Ralph once used it in his travels. It takes people places.
    He\'s the only one who ever understood how it\'s supposed to work. I think he may have
    put some details about it in his book --- the book about his travels, you know.</q> "
;

++ AskTellTopic @tParade
    "<q>I know most of the shops are closed on account of the parade,</q> you say. <q>I
    was hoping the fashion boutique would still be open, because ... oh, well, Never mind.</q>
    <.p><q>I seldom pay much attention to athletic competitions,</q> she replies. <q>I heard
    about the lacrosse championship, of course. A few of us are still at our stations, you
    could say. But the young ladies who work in the boutique are excitable, I suppose
    you could say. Perhaps you could come back tomorrow.</q>
    <.p>You go on to explain why tomorrow would be too late. She's sympathetic, but she has
    no useful suggestions to offer. "
;

++ AskTellTopic, StopEventList [tJoe, tPixies]
    [
        '<q>I noticed a man out behind the shopping center,</q> you say. <q>Is he homeless?</q>
        <.p><q>I\'m afraid so,</q> she replies. <q>He\'s nice enough. I keep meaning to take care of
        his little problem --- with the pixies, you know. I just haven\'t gotten around to it. I\'m
        sure he\'d be able to do more if he weren\'t constantly distracted by the little things.</q>
        <.p><q>So you think the pixies are real?</q>
        <.p><q>Oh, they\'re quite real,</q> she assures you.
        <.p><q>How would you get rid of them?</q> you inquire.
        <.p><q>Well, I suppose you could catch them in some sort of net. But you\'d have to be able
        to see them in order to do that. And then do something that would cause them to lose interest
        in him.</q> ',
        
        '<q>Well, now, let me see.</q> She rubs her nose thoughtfully. <q>You might be able to see
        the pixies if they were flying around in a cloud of smoke, I suppose that\'s possible. A
        light piece of cloth could serve as a net. To make them lose interest in the poor man --- I\'m
        not sure. Perhaps if they were simply bored, they would fly away.</q> ',
        
        'She has given you some good suggestions about how to help {the joe} with his pixies problem ---
        make them visible in a cloud of smoke, catch them in a net, and then cause them to get bored and fly
        away. '
    ]
;

++ AskTopic, StopEventList @madameB
    [
        { : "<q>Am I right in guessing you're the seeress?</q> <<madameB.giveName()>>you ask.<.p>
        <q>Right you are,</q> she replies, sitting up a little straighter. <q>I am Madame
        Bloviatsky. Doubtless you've heard me spoken of. I'm world-renowned for my
        unexcelled knowledge of spiritual matters. I never boast about it, however. I'm far too
            modest to boast.</q> " },
        
        '<q>So you have psychic powers?</q> you ask.
        <.p><q>I am sometimes privy to deeper truths,</q> she admits with a little smile.
        <.P<q>Then could you tell me how to solve a couple of problems I\'m having this
        afternoon?</q>
        <.p><q>Ah, if only it were that easy,</q> she says, shaking her head. <q>Each of us
        must forge our own path through life. You <i>do</i> see the wisdom in that, I\'m sure.</q> ',
        
        { : "<q>Is there anything <<if (madameB.cardsReceived)>>else<<end>> I could do for you
            while I\'m wandering around the shopping center?</q> you ask.
        <.p><q><<if (madameB.cardsReceived)>>Oh, you\'ve already been quite helpful<<else>>If you
            should happen to see my deck of special fortune-telling cards anywhere, you could
            bring the cards back to me<<end>>,</q> she replies. " }
    ]
;

++ GiveShowTopic @playingCards
    "<q>Are these your cards?</q> you ask.<.p>
    <q>Well, my goodness, yes! Thank you!</q> <<madameB.receiveCards()>>She takes the cards
    from you. <q>Now if there's
    anything I can do in return.... Let me just see.</q> She shuffles the cards and swiftly
    flips a few of them face up on her table. <q>Hmm. It appears to me ... yes, you'll soon
    be going on a long journey, and using an unusual type of transportation. And while there
    it appears you'll encounter some individuals of the simian variety. Monkeys, that is. My
    predictions are most astonishingly accurate. You can count on it.</q><.p>She raises her
    eyebrows expectantly. <q>Is there anything <<tSummoning.makeFamiliar()>>
    else? I could summon a spirit, if you'd care to converse with one. Or, I know. Would
    you like a spare knitting needle? They usually come in pairs, but for some
    reason Amazon sent me three of these.</q> She holds up a long red knitting needle.
    <q>I hardly need the third one, do I?<<knittingNeedle.moveInto(me)>> Here you go.</q>
    She hands it to you. "
;

++ GiveShowTopic, StopEventList @travelGuide
    [   
        { : "<q>I found this book downstairs,</q> you say, holding out the fat leather-bound book.
            <.p>Her eyes light up. <q>Oh, that's Sir Ralph's <i>Travel Guide!</i> So tragic that he died.
            He still appears downstairs from time to time. I know --- we can have a seance! I'm sure
            you'd like to ask him about the book. <<if (!madameB.cardsReceived)>>But you know, I
            can't do a seance without my Tarot cards. I'm rather useless without the cards.<<else>>If
            you'd like me to summon the ghost, you need only say so.<<end>></q> " },
        
        { : "<q>I'm still puzzled about this book,</q> you say.<.p><q>Yes, we talked about that
            earlier,</q> she replies. <q>I myself know nothing about what's in the book, except
            that it's a record of Sir Ralph's amazing travels. If you'd like to know anything more
            than that, any details, we could have a seance. I can summon his ghost if you'd like.</q> " }
    ]
;

++ AskTellTopic [tFlogg, tGrabby]
    "<q>Those two gentlemen, Phineas Flogg and Eustace Grabby --- well, I shouldn\'t like to criticize,
    but I do think they\'re rather <i>worldly,</i> if you see what I mean.</q> She leans
    forward confidentially and raises a finger next to her eye. <q>And though they make a
    show of being staunch friends, I don\'t believe they entirely trust one another. Have you
    noticed the large safe in their office? I was told they\'ve rigged it up so that the safe
    can only be opened when they\'re both present and seated at their desks.</q> "
;

++ AskTellTopic @tBetsy
    "<q>I\'m sure {the betsy} is really a very nice person,</q> you say, though you\'re not sure
    of that at all. <q>But she\'s rather annoying, don\'t you think?</q>
    <.p><q>I try to be charitable,</q> the fortune teller replies. <q>We all have failings. She
    smokes cigarettes, for instance. Filthy habit.</q> "
;
