/*---------------------------------------------------------------------------**
**
**
** File: CYOA_LIB
**
** Author: Mark J. Musante
**
** Revision History:
**
**	1998-Feb-09	Added 'restart' command.
**
**	1998-Jan-25	Added 'save' and 'restore' commands.
**
**	1998-Jan-22	Added 'undo' command.
**
**	1998-Jan-20	Initial version.
**
**
**---------------------------------------------------------------------------*/

//
// These definitions are required by the compiler, but are not
// used in this game.
//
takeVerb: object;
strObj: object;
numObj: object;
againVerb: object;
pardon: object;


// "Me" is used by the runtime to determine the left-hand side
// of the status line. Whatever is in 'Me.location.statusLine' 
// appears up there.
Me: object
	roomCheck( v ) = {
		return true;
	}
;

//
// Some global definitions.
//
global: object
	// ary is used by the choiceVerb class. Don't change it without
	// changing choiceVerb.action() as well
	ary = [ &choice_1, &choice_2, &choice_3,
	        &choice_4, &choice_5, &choice_6,
		&choice_7, &choice_8, &choice_9 ]
	
	// change death_msg before calling die(); if you want some
	// other message than 'You have died'
	death_msg = 'died'

	// if you want to change the propmt, change this
	prompt = '> '

	// this is the value that gets passed to initRestart when the user
	// requests a restart
	initRestartParam = 0


	// this is set to true in the default initRestart function
	restarting = nil
;

Place: object
	statusLine = "Wandering"
	desc = "* NO DESCRIPTION DEFINED *"
	choices = "\t* NO CHOICES DEFINED *"
	choice_1 = nil
	choice_2 = nil
	choice_3 = nil
	choice_4 = nil
	choice_5 = nil
	choice_6 = nil
	choice_7 = nil
	choice_8 = nil
	choice_9 = nil
;

/* 'modify' this object in your source code.
**
** Sample:
**	modify intro
**		desc = "Here's a really cool introduction to my game. "
**	;
*/
intro: object
	desc = "(*) CREATE AN OBJECT NAMED 'intro' AND GIVE IT A 'desc'
		PROPERTY. "
;

/* 'modify' this object in your source code
**
** Sample:
**	modify version
**		desc = "The Cool Game, Serial Number 050123, Release 6. ";
**	;
*/
version: object
	desc = "A Work of Fiction, created with TADS (the Text Adventure
		Development System) in conjunction with the CYOA_LIB by
		Mark J.\ Musante. "
;

/* 'modify' this object in your source code. This is the message that is
** displayed after the user decides to quit.
*/
endgame: object
	desc = "Thanks for playing!\b"
;

die: function
{
	local response;

	"\b\t* * * You have <<global.death_msg>>. * * *\b";

	while( 1 ) {
		"Would you like to (R)estart, Re(s)tore, (U)ndo, or (Q)uit? ";

		response := lower(input());
		if ( response = 's' || response = 'restore' ) {
			response := askfile( 'File to restore' );
			if ( response = nil )
				"Restore failed. ";
			else if ( restore( response ) )
				"Restore failed. ";
			else
				return;
		} else if ( response = 'r' || response = 'restart' ) {
			restart();
			return;
		} else if ( response = 'u' || response = 'undo' ) {
			if ( undo() ) {
				"(Undoing one command)\b\t";
				Me.location.desc;
				return;
			} else {
				"No undo information available. ";
			}
		} else {
			endgame.desc;
			quit();
		}
	}
}

//
// Here's where we give some basic advice.
//
parseError: function( err, str )
{
	if ( err = 2 )
		return 'I don\'t understand that command. For a list of ' +
			'valid comands, please type \'help\'.';
	else
		return nil;
}

//
// This function allows us to convert the command line into a word
// that the TADS parser will allow us to handle.
//
preparse: function( str )
{
	local foo;

	if ( str = '' ) {
		"Pardon me? ";
		return nil;
	}

	foo := cvtnum( str );
	switch( foo ) {
	case 1: return 'one';
	case 2: return 'two';
	case 3: return 'three';
	case 4: return 'four';
	case 5: return 'five';
	case 6: return 'six';
	case 7: return 'seven';
	case 8: return 'eight';
	case 9: return 'nine';
	default:
		if ( foo < 0 || foo > 9 || str = '0' ) {
			"Enter a choice from the menu, please. ";
			return nil;
		}
		return true;
	}
}

//
// only allow one entry per command line
//
preparseCmd: function( list )
{
	local foo := [];

	if ( length( list ) = 1 )
		return true;
	else {
		foo += list[ 1 ];
		return foo;
	}
}

//
// This is the startup code
//
init: function
{
	"\b\b";
	intro.desc;
	"\b";
	version.desc;
	"\b\t";

	Me.location := startplace;

	Me.location.desc;
}

//
// Here's where we display the choice list & give the player the prompt
//
commandPrompt: function( type )
{
	if ( type = 0 || type = 1 ) {
		"\bWhat would you like to do?\b";
		Me.location.choices;
		"\b";
		say( global.prompt );
	} else {
		">";
	}
}

//
// Basic choices.  Numbered 1 through 9.
//
choiceVerb: object
	num = 0
	action( actor ) = {
		local newloc;
		
		if ( self.num = 0 ) {
			"Parse error: number not set in verb.\n";
			abort;
		}

		if ( self.num < 1 || self.num > 9 ) {
			"Parse error: choice out of range.\b";
			abort;
		}

		if ( proptype( Me.location, global.ary[ self.num ] ) = 5 ) {
			"Please enter a choice from the menu. ";
			abort;
		}

		newloc := Me.location.( global.ary[ self.num ] );

		if ( newloc != nil ) {
			Me.location := newloc;
			"\b\t";
			Me.location.desc;
		}
	}
;

oneVerb: choiceVerb
	verb = 'one'
	num = 1
;

twoVerb: choiceVerb
	verb = 'two'
	num = 2
;

threeVerb: choiceVerb
	verb = 'three'
	num = 3
;

fourVerb: choiceVerb
	verb = 'four'
	num = 4
;

fiveVerb: choiceVerb
	verb = 'five'
	num = 5
;

sixVerb: choiceVerb
	verb = 'six'
	num = 6
;

sevenVerb: choiceVerb
	verb = 'seven'
	num = 7
;

eightVerb: choiceVerb
	verb = 'eight'
	num = 8
;

nineVerb: choiceVerb
	verb = 'nine'
	num = 9
;

//
// Here's where the user can quit.
//
quitVerb: object
	verb = 'quit' 'q'
	action( actor ) = {
		local yn;
		"\bDo you really want to quit (YES or NO) > ";
		yn := yorn();
		"\b";
		if ( yn = 1 ) {
			endgame.desc;
			quit();
		} else {
			"Okay. ";
		}
	}
;

//
// Here's where the user can back up one turn
//
undoVerb: object
	verb = 'undo' 'u'
	action( actor ) = {
		if ( undo() && undo() ) {
			"(Undoing one command.)\b\t";
			Me.location.desc;
		} else {
			"No more undo information available.\b";
		}
	}
;

//
// This command is a concession to convention.
//
lookVerb: object
	verb = 'l' 'look'
	action( actor ) = {
		"\t";
		Me.location.desc;
	}
;

//
// Some very basic help
//
helpVerb: object
	verb = 'help'
	action( actor ) = {
		"This game does not accept standard interactive commands.
		Instead, it presents you with a situation and a number of
		choices to make. You can choose one of the options given,
		or you may enter one of the following:\n
		\thelp\tThis help message.\n
		\tquit\tEnd the game (abbr: 'q').\n
		\tlook\tRe-display the description of the situation (abbr: 'l').\n
		\tundo\tUndo the previous command (abbr: 'u').\n
		\tsave\tSave the current game in progress.\n
		\trestore\tRestore a previously saved game.\n
		\trestart\tRestart the game from the beginning.\n";
	}
;

//
// Save code paraphrased from adv.t
//
saveVerb: object
	verb = 'save'
	action( actor ) = {
		local savefile;

		savefile := askfile( 'File to save game in' );
		if ( savefile = nil or savefile = '' ) {
			"Failed. ";
		} else if ( save( savefile ) ) {
			"Saved failed. ";
		} else {
			"Saved. ";
		}
	}
;


//
// restore code paraphrased from adv.t
//
restoreVerb: object
	verb = 'load' 'restore'
	action( actor ) = {
		local savefile;

		savefile := askfile( 'File to restore game from' );
		if ( savefile = nil or savefile = '' ) {
			"Failed. ";
		} else if ( restore( savefile ) ) {
			"Restore failed. ";
		} else {
			"Restored.\b\t";
			Me.location.desc;
		}
	}
;

//
// restart code paraphrased from adv.t
//
initRestart: function( param )
{
	global.restarting := true;
}

restartVerb: object
	verb = 'restart'
	action( actor ) = {
		local yesno;
		while ( true ) {
			"Are you sure you want to start over? (YES or NO) > ";
			yesno := yorn();
			if ( yesno = 1 ) {
				"\b\b* * * RESTARTING * * *\b\b";
				restart(initRestart, global.initRestartParam);
				break;
			} else if ( yesno = 0 ) {
				"\nOkay.\n";
				break;
			}
		}
	}
;
