!----------------------------------------------------------------------------
routine DoWalkthru
{
    if (after_comp) {
        PrintMessage(15,2,19)
    } else {
        Walkthrough !Display the walkthrough.
        !! "The built-in walkthrough is not yet completed. Sorry."
    }
}

!----------------------------------------------------------------------------
routine DoHelp
{
    PrintMessage(19,6) !Mention that there is a walkthrough instead.
}

!----------------------------------------------------------------------------
routine DoHint
{
    PrintMessage(19,6) !Mention that there is a walkthrough instead.
}

!----------------------------------------------------------------------------
replace DoScore
{
    print "You have completed "; number score; "% of this adventure, in ";
    print number counter; " turns."
}

!----------------------------------------------------------------------------
routine DoMagicWord
{
    if (player = swordsman) {
        "You can't hear the hollow voice."
    } else {
        "A hollow voice says \"oh, but to be young and imaginative again.\""
    }
}

!----------------------------------------------------------------------------
routine DoAbout
{
    if (after_comp) {
        print "" !Leave a blank line
        Font(PROP_OFF)
        print "\_\_+------------------------+"
        print "\_\_| Tales of the Traveling |"
        print "\_\_| Swordsman, version "; version; " |"
        print "\_\_| An entry in IFComp '06 |"
        print "\_\_| Written by Mi"; "ke "; "Sny"; "der |"
        print "\_\_| si"; "dne"; "yme"; "rk"; "@h"; "otm"; "ail."; "com |"
        print "\_\_| At: ww"; "w.si"; "dne"; "yme"; "rk"; ".com |"
        print "\_\_+------------------------+\n"
        print "\_\_"; BANNER; "."
        Font(PROP_ON)
    } else {
        print "Tales of the Traveling Swordsman"
        print "For the 2006 Interactive Fiction Comp"
        print "Version "; version; " / "; BANNER
        print "Author's Contact - tales_ts@hotmail.com"
    }
}

!----------------------------------------------------------------------------
routine DoCheatMessage
{
    if (cheats_enabled) {
        PrintMessage(15,2,12) !Cheat commands are already enabled.
    } else {
        PrintMessage(15,2,11) !Sorry, cheats have not been enabled.
    }
}

!----------------------------------------------------------------------------
routine DoCheatEnable
{
    if (cheats_enabled) {
        PrintMessage(15,2,12) !Cheat commands are already enabled.
    } else {
        cheats_enabled = true !Turn on cheats.
        PrintMessage(15,2,13) !Cheat commands are enabled now.
    }
}

!----------------------------------------------------------------------------
routine DoCheatDisable
{
    if (cheats_enabled) {
        cheats_enabled = false !Turn off cheats.
        PrintMessage(15,2,14) !Cheat commands are disabled now.
    } else {
        PrintMessage(15,2,11) !Sorry, they're not enabled.
    }
}

!----------------------------------------------------------------------------
routine DoCheatSkip0
{
    if (cheats_enabled) {
        DoCheatSkip(0)
    } else {
        PrintMessage(15,2,11) !Sorry, they're not enabled.
    }
}

!----------------------------------------------------------------------------
routine DoCheatSkip1
{
    if (cheats_enabled) {
        DoCheatSkip(1)
    } else {
        PrintMessage(15,2,11) !Sorry, they're not enabled.
    }
}

!----------------------------------------------------------------------------
routine DoCheatSkip2
{
    if (cheats_enabled) {
        DoCheatSkip(2)
    } else {
        PrintMessage(15,2,11) !Sorry, they're not enabled.
    }
}

!----------------------------------------------------------------------------
routine DoCheatSkip3
{
    if (cheats_enabled) {
        DoCheatSkip(3)
    } else {
        PrintMessage(15,2,11) !Sorry, they're not enabled.
    }
}

!----------------------------------------------------------------------------
routine DoCheatSkip4
{
    if (cheats_enabled) {
        DoCheatSkip(4)
    } else {
        PrintMessage(15,2,11) !Sorry, they're not enabled.
    }
}

!----------------------------------------------------------------------------
! This doesn't work too well, because the "anything" verb def will only
! work for things that have already been seen.
!
routine DoCheatGet
{
    if (cheats_enabled) {
        if (object is not static) and (object is not living) {
            if Contains(player,object) {
                Vmessage(&DoGet, 1) !You already have that.
            } else {
                !We can get it... so give it to the player.
                Acquire(player,object) : object is moved
                PrintMessage(15,2,18) !You now have the object.
            }
        } else {
            PrintMessage(15,2,17) !Wrong type of object.
        }
    } else {
        PrintMessage(15,2,11) !Sorry, they're not enabled.
    }
}

!----------------------------------------------------------------------------
routine DoRead
{
    !If the object doesn't have a custom "read" handler, then we send it
    !on to "look" instead, as was the default in the Hugo libraries.
    return Perform(&DoLook, object)
}

!----------------------------------------------------------------------------
routine DoArrange
{
    ! This is a very specific verb, for use on the deck of the barge. All
    ! other cases would probably make sense to just re-route through Move.
    return Perform(&DoMove, object, xobject)
}

!----------------------------------------------------------------------------
routine DoRight
{
    !!PrintMessage(3,2,1) !You can't do that.
    PrintMessage(3,2,20)  !You can't turn it over.
}

!----------------------------------------------------------------------------
routine DoPush
{
    if not CheckReach(object):  return false

    PrintMessage(3,0,object) !Trying to push it doesn't get you anywhere.
    return true
}

!----------------------------------------------------------------------------
routine DoPull
{
    if not CheckReach(object): return false

    PrintMessage(3,0,object) !Trying to pull it doesn't get you anywhere.
    return true
}

!----------------------------------------------------------------------------
!Standard "DoSearch" assumes syntax like "Search X for Y" (the player is
!trying to find Y, located in X). So if they phrase it the opposite way,
!such as "Search for Y in X" then we need to swap object and xobject.
!
routine DoSearchReverse
{
    return perform (&DoSearch, xobject, object)
}

!----------------------------------------------------------------------------
!Not exactly the same as what's in VerbStub -- searching self results in an
!inventory check, and we allow searching "for" objects. Anything that can
!really be found should be in the appropriate before/after code, though.
!
routine DoSearch
{
    if (object = nothing) {
        !Handles "Search For Y" without specifying where to search.
        if not (xobject.after) {
            if (xobject = player) {
                print CThe(player); IsOrAre(player); " right here."
            } elseif (FindObject(xobject, location) > 0) {
                if Contains(player, xobject) {
                    print "Yes, "; The(player); IsOrAre(player); " carrying";
                    print MatchPlural(xobject, "that.", "those.")
                } else {
                    ! If it's non-scenery that's hidden, or something the
                    ! player hasn't yet encountered, then it shouldn't be
                    ! "seen" just by doing a general searching. If a general
                    ! search will find it, we should handle that in code
                    ! at the xobject's DoSearch BEFORE routine, probably.
                    if ((xobject is hidden) and (xobject is not static)) \
                            or (xobject is not known) \
                            or (xobject is concealed) {
                        PrintMessage(3,2,18) !You can't see that here.
                    } else {
                        print "Yes, "; The(player); " can see";
                        ! Note that some things "searched for" can be
                        ! weird if we triggered on the adjective instead
                        ! of the noun. For instance, "search for apple" in
                        ! the orchard, when the apple isn't here, might
                        ! hit on "apple trees". For that reason, we use
                        ! an attribute "full_named" to handle it.
                        if (xobject is full_named) {
                            print " "; The(xobject);
                        } else {
                            print MatchPlural(xobject, "that", "those");
                        }
                        " from here."
                    }
                }
            } else {
                PrintMessage(3,2,18) !You can't see that here.
            }
        }
    } elseif object = player {
        if xobject = nothing {
            perform(&DoInventory)
        } elseif (xobject in player) {
            if not (xobject.after) {
                print "Yes, "; The(player); IsOrAre(player); " carrying";
                print MatchPlural(xobject, "that.", "those.")
            }
        } else {
            print MatchPlural(xobject, "That isn't", "Those aren't");
            print " in "; player.pronouns #3; " inventory."
        }
    } elseif object is container or object is platform {
        !if child(object) {
            if (xobject = nothing) {
                Perform(&DoLookIn, object) !Print a list of what's inside.
            !} elseif (xobject in object) {
            !} elseif (FindObject(xobject, object) > 0) {
            } elseif (xobject in object) or InList(xobject,found_in,object) {
                if not (xobject.after) {
                    if not (object.after) {
                        print "Yes, "; The(xobject); IsOrAre(xobject, true);
                        if (object is container) { " in "; } else { " on "; }
                        print The(object); "."
                    }
                }
            } else {
                print CThe(xobject); IsOrAre(xobject, true); "n't";
                if (object is container) { " in "; } else { " on "; }
                print The(object); "."
            }
        !} else {
        !    print "Nothing is in"; MatchPlural(object, "that.", "those.")
        !}
    } elseif object is living {
        print CThe(object); MatchPlural(object, "doesn't", "don't");
        print " let "; The(player);
        if (object.pronouns #2) {
            print " search "; object.pronouns #2;
        }
        print "."
    } else {
        if not (object.after) {
            if (xobject = nothing) {
                print CThe(player);
                MatchPlural(player, "doesn't", "don't")
                if (object is searched_indirectly) {
                    " see ";
                } else {
                    " find ";
                }
                "anything new."
            } else {
                if not (xobject.after) {
                    print CThe(player);
                    MatchPlural(player, "doesn't", "don't")
                    if (object is searched_indirectly) {
                        " see ";
                    } else {
                        " find ";
                    }
                    "what ";
                    print The(player); IsOrAre(player);
                    " looking for there."
                }
            }
        }
	}
	return true
}

!----------------------------------------------------------------------------
routine DoJump
{
    if (object = nothing) {
        "Save your energy."
    } else {
        if not (object.after) {
            PrintMessage(3,2,1) !You can't do that.
            return false !Don't increment counter.
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
!Give a different response for the general "listen" now.
!
replace DoListen
{
    PrintMessage(3,9) !Handle default "listen" text.
    return true !So it increments the turns counter.
}

!----------------------------------------------------------------------------
! This is a separate routine so that "climb up ladder" (for a ladder that's
! going down instead of up) can be trapped for without actually assuming the
! player means to climb down.
!
routine DoClimbUp
{
    !!!!! print "climb up "; object.name
    !Ordinarily we'll trap for DoClimbUp in a ladder's verbroutine.
    if (object = nothing, u_obj) {
        return Perform(&DoGo, u_obj) !"go up" and let the game handle.
    } else {
        return Perform(&DoClimb, object) !Redirect to the object.
    }
}

!----------------------------------------------------------------------------
! This is a separate routine so that "climb down ladder" (for a ladder that's
! going up instead of down) can be trapped for without actually assuming the
! player means to climb up.
!
routine DoClimbDown
{
    !!!!! print "climb down "; object.name
    !Ordinarily we'll trap for DoClimbDown in a ladder's verbroutine.
    if (object = nothing, d_obj) {
        return Perform(&DoGo, d_obj) !"go down" and let the game handle.
    } else {
        return Perform(&DoClimb, object) !Redirect to the object.
    }
}

!----------------------------------------------------------------------------
routine DoClimb
{
    if (object = nothing) {
        DoVague
    } else {
        PrintMessage(3,15,object) !You can't [climb] it.
    }
}

!----------------------------------------------------------------------------
routine DoRide
{
    if (object.after) {
        return true
    } else {
        PrintMessage(3,15,object) !You can't [ride] it.
    }
}

!----------------------------------------------------------------------------
routine DoTieReverse
{
    !Specified object and xobject backward, so reverse it.
    return Perform(&DoTie, xobject, object)
}

!----------------------------------------------------------------------------
routine DoTie
{
    if not CheckReach(object):  return false

    !Okay, since we can only use "attachables" to tie things, we should be
    !able to check to see if the "object" is attachable or not. The Library
    !DoAttachObject will handle that for us, but the good thing is, if we
    !know the user *has* an attachable in inventory (no more than one is
    !going to be present per chapter) we can imply that xobject = attachable
    !if the user didn't specify an xobject and the object isn't attachable.
    !This basically allows for "tie object (with the rope)"

    if (object.type ~= attachable) and (xobject = nothing) {
        !We know the rope is an attachable.
        if Contains(player, rope) {
            ! First, let the player know what's going on.
            PrintMessage(6,12,rope)
            ! We can't just set xobject=object and object=rope, then pass
            ! through to normal handling, because that doesn't give object
            ! "before" routines a chance to react to this new condition.
            ! For example, "tie hatch" won't work unless we allow a perform
            ! on the "DoTie" (or really, directly to DoAttachObject).
            return Perform(&DoAttachObject, rope, object)
        } else {
            !Maybe some elseifs for handling other attachables.
            !Right now, there aren't any others in the game.
        }
    }

    !Otherwise, we just let DoAttachObject do its business as normal.

    !This would be handled in the library, if I was including verb stubs.
    return Perform(&DoAttachObject, object, xobject)
}

!----------------------------------------------------------------------------
routine DoStrapReverse
{
    !Specified object and xobject backward, so reverse it.
    return Perform(&DoStrap, xobject, object)
}

!----------------------------------------------------------------------------
routine DoStrap
{
    if not CheckReach(object): return false

    ! Unlike the "DoTie" verb, we're not going to assume that
    ! "attach object" or "strap object" (where the object itself is not an
    ! attachble) should assume "with the rope". Because things like this,
    ! "attach harness (with the rope)" don't make a lot of sense. But, what
    ! if we trie to attach something that isn't attachable to something
    ! that is? For instance "attach harness to rope" intentionally? Well,
    ! in that case, we can reverse it and route it into DoAttachObject.

    if (object.type = attachable) {
        ! It's a rope or something. So let's allow the lib "attach" method.
        ! First, check to see if the xobject is attachable TO this object.
        ! This will handle "attach harness to rope" for instance, where
        ! both the harness and the rope are attachables but the harness is
        ! not made to "attach to" the rope. No attachables will reference
        ! each other (by design in this game), so this should be safe.
        if (xobject.type = attachable) and \
                  InList(xobject,attachable_to,object) {
            !Xobject *can* be attached to object, so swap and handle it.
            return Perform(&DoAttachObject, xobject, object)
        } else {
            !Attempt to attach the object to the xobject, as requested.
            return Perform(&DoAttachObject, object, xobject)
        }
    } else {
        if (xobject.type = attachable) {
            ! The xobject is attachable, so swap and use lib "attach" now.
            return Perform(&DoAttachObject, xobject, object)
        } else {
            ! We could just let the DoAttachObject handle telling the player
            ! that they can't attach this to anything, but let's give a
            ! custom message that differs from "DoTie" somewhat.
            PrintMessage(3,24,object) !That's not readily possible to do.
        }
    }
}

!----------------------------------------------------------------------------
routine DoUnTie
{
    if not CheckReach(object):  return false

    !This would be handled in the library, if I was including verb stubs.
    return Perform(&DoDetachObject, object, xobject)
}

!----------------------------------------------------------------------------
routine DoUnstrap
{
    if not CheckReach(object):  return false

    ! Tell the library to unattach the current object.
    return Perform(&DoDetachObject, object, xobject)
}

!----------------------------------------------------------------------------
routine DoWind
{
    ! If this isn't handled by an object, we assume "turn"
    ! There isn't an xobject in DoWind
    return Perform(&DoTurn, object)
}

!----------------------------------------------------------------------------
routine DoUnwind
{
    ! If this isn't handled by an object, we assume "untie"
    ! There isn't an xobject in DoUnwind
    return Perform(&DoUntie, object)
}

!----------------------------------------------------------------------------
routine DoGoForward
{
    !Unlike real direction-based movement, we'll need to trap for this in
    !any rooms where it's allowed, in before{} code. Otherwise, can't go.
    VMessage(&DoGo, 2)
}

!----------------------------------------------------------------------------
routine DoGoBackward
{
    !Unlike real direction-based movement, we'll need to trap for this in
    !any rooms where it's allowed, in before{} code. Otherwise, can't go.
    VMessage(&DoGo, 2)
}

!----------------------------------------------------------------------------
routine DoGoBoatFore
{
    !If we really can, we need location.before.DoGoBoatFore trapping
    PrintMessage(9,1,1) !Can't go to Fore.
}

!----------------------------------------------------------------------------
routine DoGoBoatAft
{
    !If we really can, we need location.before.DoGoBoatAft trapping
    PrintMessage(9,1,2) !Can't go to Aft.
}

!----------------------------------------------------------------------------
routine DoGetFrom
{
    !Check for "Contains" since we removed "parent" from the grammar defs
    if Contains(xobject,object) or InList(object,found_in,xobject) {
        return Perform(&DoGet, object, xobject)
    } else {
        ParseError(14, object)
    }
}

!----------------------------------------------------------------------------
routine DoSheathe
{
    ! that's handled in before.DoSheathe for the sword object. Well, that's
    ! not entirely true. If we say "sheathe" without an object, we assume
    ! that the player intends to sheathe the sword.
    if Contains(player,sword) {
        print "("; art(sword); ")"
        return Perform(&DoSheathe, sword)
    } else {
        PrintMessage(3,2,1) !You can't do that.
    }
}

!----------------------------------------------------------------------------
routine DoUnsheathe
{
    !Nothing to do, since the only thing we can unsheath is the sword, and
    !that's handled in before.DoUnsheathe for the sword object. Well, that's
    ! not entirely true. If we say "unsheathe" without an object, we assume
    ! that the player intends to unsheathe the sword.
    if Contains(player,sword) {
        print "("; art(sword); ")"
        return Perform(&DoUnsheathe, sword)
    } else {
        PrintMessage(3,2,1) !You can't do that.
    }
}

!----------------------------------------------------------------------------
routine DoSayString
{
    !check to see if user put a greeting in quotes.
    if IsEqual(parse$,"hi","Hi","HI") {
        return Perform(&DoHello,object);
    }
    if IsEqual(parse$,"hello","Hello","HELLO") {
        return Perform(&DoHello,object);
    }
    if IsEqual(parse$,"howdy","Howdy","HOWDY") {
        return Perform(&DoHello,object);
    }
    if IsEqual(parse$,"yes","Yes","YES") {
        return Perform(&DoYes,object);
    }
    if IsEqual(parse$,"no","No","NO") {
        return Perform(&DoNo,object);
    }

    !Otherwise, we just ignore parse$. It could be
    !checked in an object "before" but for this game
    !we're not really relying on things "said" at all.
    !Actually, this whole routine is probably crap.
    !I wouldn't suggest using it as-is in another game.

    return Perform(&DoTell,object,nothing);
}

!----------------------------------------------------------------------------
replace DoTell
{
    !If the user didn't specify who they're talking to, then either assume
    !it's the last person they were talking to, or if there is nobody who
    !fits the bill, then he's talking to himself.

    if (object = nothing) {
        if (speaking = nothing) {
            object = player
        } else {
            object = speaking
        }
    }

    if object = player {

    	VMessage(&DoAsk, 2)      ! "Talking to yourself..."

    } else {

        speaking = object !Remember who we're talking to.

        if object is unfriendly {

            if (not object.ignore_response) {
                Message(&Speakto, 4) ! "X ignores you."
            }
            speaking = 0

        } else {

            !The grammar definition doesn't allow for the player to say
            !nothing at all *to* an NPC, so if object = nothing, it may
            !mean that we are performing DoTell out of DoSayString. If
            !that's the case, then parse$ contains the player's input.

            if not xobject.after {
                if not object.after {
                    !If the player said nothing, then it's parse$
                    if (xobject = nothing) {
                        !Repeat back what the player just said.
                        print CThe(player);
                        print MatchPlural(player, "says ", "say ");
                        print "\""; parse$; "\" to ";
                        print The(object); ". ";
                    }
                    VMessage(&DoTell, 2) ! "Not interested..."
                }
            }
#ifclear NO_SCRIPTS
            SkipScript(object)
#endif
        }
    }
	return true
}

!----------------------------------------------------------------------------
!I'm going to make "Say" just a front-end to DoTell, replacing the default
!routine out of the library. That means object and xobject have to be
!flipped around ("say X to Y" becomes "Tell Y about X"). In this game,
!talking isn't important anyway, so it really doesn't matter that much.
!
routine DoSay
{
    return perform(&DoTell,xobject,object);
}

!----------------------------------------------------------------------------
routine DoYes
{
    if (player = swordsman) {
        return Perform(&DoNodYes, object);
    } else {
        !Pretty generic.
        if (object = nothing) {
            print CThe(player); " say \"yes.\""
        } else {
            print CThe(player); " say \"yes\" to "; The(object); ". ";
            if (object.after) {
                !Nothing to do but to let the "after" routine run.
            } else {
                print newline !Just end the line, if nothing added in "after"
            }
        }
    }
}

!----------------------------------------------------------------------------
routine DoNo
{
    if (player = swordsman) {
        return Perform(&DoShakeNo, object);
    } else {
        !Pretty generic.
        if (object = nothing) {
            print CThe(player); " say \"no.\""
        } else {
            print CThe(player); " say \"no\" to "; The(object); ". ";
            if (object.after) {
                !Nothing to do but to let the "after" routine run.
            } else {
                print newline !Just end line, if nothing was added in "after"
            }
        }
    }
}

!----------------------------------------------------------------------------
routine DoNodYes
{
    !Pretty generic.
    print CThe(player); " nod "; player.pronouns #3; " head \"yes";
    if (object = nothing) {
        ".\"" !Just end the statment.
    } else {
        print "\" at "; The(object); ". ";
        if (object.after) {
            !Nothing to do but to let the "after" routine run.
        } else {
            print newline !Just end line, if nothing was added in "after".
        }
    }
}

!----------------------------------------------------------------------------
routine DoShakeNo
{
    !Pretty generic.
    print CThe(player); " shake "; player.pronouns #3; " head \"no";
    if (object = nothing) {
        ".\"" !Just end the statment.
    } else {
        print "\" at "; The(object); ". ";
        if (object.after) {
            !Nothing to do but to let the "after" routine run.
        } else {
            print newline !Just end line, if nothing was added in "after".
        }
    }
}

!----------------------------------------------------------------------------
routine DoPoint
{
    if (object = nothing) {
        "At what?"
        return false
    } else {
        if (object is concealed) {
            !Not happy with ParseError #11 in this case. I think I'll
            !customize it to be less library-like.
            !ParseError(11, self) !You don't see that.
            PrintMessage(3,6,object) !You can't see it.
            return false
        } else {
            print CThe(player); MatchPlural(player,"points", "point");
            if (object = player) {
                print " at yourself. ";
            } elseif (object.type = direction) {
                print " "; object.name; ". ";
            } elseif (object = sword,sheath) {
                print " at "; Art(object); ". ";
            } else {
                print " at "; The(object); ". ";
            }
            ! If an NPC is here, we're going to attempt to route
            ! the action through to DoShow. This allows NPC reactions
            ! to things that we point to.
            rnd = CheckForNPC
            if (rnd): Perform(&DoShow,object,rnd) !Show.
            else: print newline !Pointed and that's all.
            return true !Regardless, the player did point.
        }
    }
}

!----------------------------------------------------------------------------
! This is basically to accomodate attempts to "cut rope off handle" and the
! likes. We'll end up dropping the xobject, but at least we can check to see
! if the the object is really "in" the xobject first. This will usually
! prevent the need to check DoCutOff in object "before" routines.
!
routine DoCutOff
{
    if (object in xobject) or \
       (InList(object, found_in, xobject)) or \
       (InList(object, attached_to, xobject)) {
        return perform(&DoCut, object, nothing) !Dropping xobject.
    } else {
        PrintMessage(3,16,object) !You don't see it there.
    }
}

!----------------------------------------------------------------------------
! Basic syntax: Cut Object with XObject
!
routine DoCut
{
    !Adding support for implying the attacker.
    if (object = nothing) and (xobject = nothing) {
        if (attacker ~= nothing) {
            ! Fix a bug that causes the spider to get listed twice. I have
            ! it auto-listed when attacking the spider if you don't specify
            ! it's color (so the player knows which one), but if you go at
            ! it this way, it's going to list twice. So, only do it if we
            ! are not attacking the spiders, when implying the attacker.
            if (attacker ~= red_spider, black_spider, gray_spider) {
                print "("; The(attacker); ")" !Let the player know it.
            }
            return Perform(&DoCut, attacker) !And then redirect it.
        } else {
            DoVague : return false
        }
    }
    
    if (object is concealed) {
        PrintMessage(3,6,object) !You can't see it.
        return false !Don't increment turns counter
    } else {
        if (xobject = nothing) and (Contains(player, sword)) {
            xobject = sword
            PrintMessage(6,12,sword)
        }
    }

    if (xobject = sword) {
        if (object is living) {
            !To support attacking living objects, do xobject.before.
            PrintMessage(5,14,object) !Can't attack something living.
        } else {
            PrintMessage(3,11,object) !It's not to be used as a toy.
        }
    } else {
        ! Unless I add anything else "sharp" in the game, there really is
        ! no need to handle this condition. So, for now, it's nothing.
        ! Well, this will also handle things for the mother, at the end.
        PrintMessage(3,2,1) !You can't do that.
    }

    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoStabReverse
{
    !We specified the command backwards, so swap objects and perform DoStab.
    return perform (&DoStab, xobject, object)
}

!----------------------------------------------------------------------------
! Basic syntax: Stab Object with XObject
!
routine DoStab
{

    !Adding support for implying the attacker.
    if (object = nothing) and (xobject = nothing) {
        if (attacker ~= nothing) {
            ! Fix a bug that causes the spider to get listed twice. I have
            ! it auto-listed when attacking the spider if you don't specify
            ! it's color (so the player knows which one), but if you go at
            ! it this way, it's going to list twice. So, only do it if we
            ! are not attacking the spiders, when implying the attacker.
            if (attacker ~= red_spider, black_spider, gray_spider) {
                print "("; The(attacker); ")" !Let the player know it.
            }
            return Perform(&DoStab, attacker) !And then redirect it.
        } else {
            DoVague : return false
        }
    }

    if (object is concealed) {
        PrintMessage(3,6,object) !You can't see it.
        return false !Don't increment turns counter
    } else {
        if (xobject = nothing) and (Contains(player, sword)) {
            xobject = sword
            PrintMessage(6,12,sword)
        }
    }

    if (xobject = sword) {
        if (object is living) {
            !To support attacking living objects, do xobject.before.
            PrintMessage(5,14,object) !Can't attack something living.
        } else {
            PrintMessage(3,11,object) !It's not to be used as a toy.
        }
    } else {
        !Unless I add anything else "sharp" in the game, there really is
        !no need to handle this condition. So, for now, it's nothing.
    }

    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoBlockReverse
{
    !We specified the command backwards, so swap objects and perform DoBlock.
    return perform (&DoBlock, xobject, object)
}

!----------------------------------------------------------------------------
routine DoBlock
{
    if (player = swordsman) {

        if (object is concealed) {
            PrintMessage(3,6,object) !You can't see it.
            return false !Don't increment turns counter
        } elseif (object = nothing) {
            if (attacker = nothing) {
                PrintMessage(5,2,1) !You aren't being attacked.
                return false !Don't increment turn counter
            } else {
                print "("; The(attacker); ")"
                return Perform(&DoBlock, attacker, xobject)
            }
        }

        if (attacker = object) {
            if (xobject = nothing, sword) {
                if (MakeReadySword) {
                    PrintMessage(5,4,object) !You try your best to defend.
                }
            }
        } else {
            PrintMessage(5,3,object) !That's not attacking you.
            return false !Because it doesn't count.
        }

    } else {
        PrintMessage(3,2,4) !You don't know how (for the motherly maiden).
        return false !Because it doesn't count.
    }

    return true !To increment move counter
}

!----------------------------------------------------------------------------
! Player is attempting to dodge something.
!
routine DoDodge
{
    if (player = swordsman) {

        if (object = nothing) {
            if (attacker = nothing) {
                PrintMessage(5,2,1) !You aren't being attacked.
                return false !Don't increment turn counter
            } else {
                print "("; The(attacker); ")"
                return Perform(&DoDodge, attacker)
            }
        }

        if (attacker = object) {
            PrintMessage(5,8,object) !You try your best to dodge.
        } else {
            PrintMessage(5,3,object) !That's not attacking you.
            return false !Because it doesn't count.
        }

    } else {
        PrintMessage(3,2,4) !You don't know how (for the motherly maiden).
        return false !Because it doesn't count.
    }

    return true !To increment move counter
}

!----------------------------------------------------------------------------
! A lot of work for something most players probably won't even try. :)
!
routine DoRepair
{
    if (object is concealed) {
        PrintMessage(3,6,object) !You can't see it.
        return false !Don't increment turns counter
    } else {
        if not (object.after) {
            if (object is broken) {
                if (object is fixable) {
                    if (xobject = nothing) {
                        ! If we really *can* fix something without xobject,
                        ! we need to trap in object.before or object.after.
                        PrintMessage(3,22,object) !How do you intend to?
                    } elseif not Contains(player, xobject) {
                        ParseError(15,xobject) !You're not holding that.
                    } else {
                        ! When we really *can* fix something, we'd better
                        ! trap for it in object.before or object.after.
                        PrintMessage(3,20,object) !Can't fix it that way.
                    }
                } else {
                    !There's no way to fix that.
                    PrintMessage(3,23,object) !It's beyond repair, etc.
                }
            } else {
                if (object is fixable) {
                    PrintMessage(3,21,object) !It's already fixed.
                } else {
                    PrintMessage(3,12,object) !It's not broken.
                }
            }
        }
    }
    return true
}

!----------------------------------------------------------------------------
! This handles the player saying "with the object" in some specific cases.
!
routine DoAnswerWith
{
    local retval = false
    if (answer_object = nothing) or (answer_verbroutine = nothing) {
        return Perform(&DoUse, object) !Re-route to the "using" routine.
    } elseif (answer_needheld) and not Contains(player, object) {
        ParseError(15,object) !You're not holding it.
    } else {
        !Otherwise, the player just answered the question. Perform!
        word[1] = answer_verbword !Because some messages expect it.
        retval = Perform(answer_verbroutine, answer_object, object)
    }
    return (retval)
}

!----------------------------------------------------------------------------
! Used for reversed versions, such as "swing HELD at OBJECT"
!
routine DoHitReverse
{
    return Perform(&DoHit, xobject, object)
}

!----------------------------------------------------------------------------
! This is a replacment to the verblib.h library version. Minor changes.
!
replace DoHit
{
    if not CheckReach(object):  return false

    !Adding support for implying the attacker.
    if (object = nothing) and (xobject = nothing) {
        if (attacker ~= nothing) {
            ! Fix a bug that causes the spider to get listed twice. I have
            ! it auto-listed when attacking the spider if you don't specify
            ! it's color (so the player knows which one), but if you go at
            ! it this way, it's going to list twice. So, only do it if we
            ! are not attacking the spiders, when implying the attacker.
            if (attacker ~= red_spider, black_spider, gray_spider) {
                print "("; The(attacker); ")" !Let the player know it.
            }
            return Perform(&DoHit, attacker) !And then redirect it.
        } else {
            DoVague : return false
        }
    }

    if (xobject is sharp) {
        !Re-route "hit with" to "cut with"
        return Perform(&DoCut,object,xobject)
    } elseif (xobject.after) {
        return true
    } elseif (object.after) {
        return true
    } elseif (object is unholdable) {
        PrintMessage(3,2,1) !You can't do that.
    } else {
        VMessage(&DoHit) ! "Venting frustrations doesn't accomplish much..."
    }
}

!----------------------------------------------------------------------------
! For shaking or rattling things, like a gate or an apple tree.
!
routine DoShake
{
    if not CheckReach(object):  return false

    if (object.after) {
        return true
    } elseif (object is unholdable) {
        PrintMessage(3,2,1) !You can't do that.
    } else {
        PrintMessage(3,2,3) !Nothing happens.
    }
}

!----------------------------------------------------------------------------
! Unless we specifically handle "DoBreak" in objects, we'll assume the
! player meant to "cut" or "hit" the object, so that our objects can react
! to those things if needed.
!
routine DoBreak
{
    if not CheckReach(object):  return false

    if (xobject.after) {
        return true
    } elseif (object.after) {
        return true
    } else {
        if (xobject is sharp) {
            return Perform(&DoCut, object, xobject)
        } else {
            return Perform(&DoHit, object, xobject)
        }
    }
}

!----------------------------------------------------------------------------
! Unless we specifically handle "DoKill" in objects, we'll assume the
! player meant to "cut" or "hit" the object, so that our objects can
! react to those things if needed.
!
routine DoKill
{
    if not CheckReach(object):  return false

    !Adding support for implying the attacker.
    if (object = nothing) and (xobject = nothing) {
        if (attacker ~= nothing) {
            ! Fix a bug that causes the spider to get listed twice. I have
            ! it auto-listed when attacking the spider if you don't specify
            ! it's color (so the player knows which one), but if you go at
            ! it this way, it's going to list twice. So, only do it if we
            ! are not attacking the spiders, when implying the attacker.
            if (attacker ~= red_spider, black_spider, gray_spider) {
                print "("; The(attacker); ")" !Let the player know it.
            }
            return Perform(&DoKill, attacker) !And then redirect it.
        } else {
            DoVague : return false
        }
    }

    if (object is not living) {
    
        ! By default, we can't "kill" something that's not alive. We'll
        ! be able to by trapping in object "before" routines, if needed.
        ! About the only place where it is, is attacking the windmill.
        PrintMessage(5,2,2) !That's not alive. You can't fight it.

    } else {

        if (xobject = nothing) and (sword in player) {
            !Let player know that it was implied.
            xobject = sword
            PrintMessage(6,12,sword)
        }
    
        if (xobject.after) {
            return true
        } elseif (object.after) {
            return true
        } else {
            if (xobject is sharp) {
                return Perform(&DoCut, object, xobject)
            } else {
                return Perform(&DoHit, object, xobject)
            }
        }
    }
}

!----------------------------------------------------------------------------
! Unless we specifically handle "DoAttack" in objects, we'll assume the
! player meant to "cut" or "hit" the object, so that our objects can
! react to those things if needed.
!
routine DoAttack
{
    if not CheckReach(object):  return false

    !Adding support for implying the attacker.
    if (object = nothing) and (xobject = nothing) {
        if (attacker ~= nothing) {
            ! Fix a bug that causes the spider to get listed twice. I have
            ! it auto-listed when attacking the spider if you don't specify
            ! it's color (so the player knows which one), but if you go at
            ! it this way, it's going to list twice. So, only do it if we
            ! are not attacking the spiders, when implying the attacker.
            if (attacker ~= red_spider, black_spider, gray_spider) {
                print "("; The(attacker); ")" !Let the player know it.
            }
            return Perform(&DoAttack, attacker) !And then redirect it.
        } else {
            DoVague : return false
        }
    }
    
    if (object is not living) and (VerbWord = "fight","combat","battle") {
    
        ! By default, we can't "kill" something that's not alive. We'll
        ! be able to by trapping in object "before" routines, if needed.
        ! About the only place where it is, is attacking the windmill.
        PrintMessage(5,2,2) !That's not alive. You can't fight it.
        
    } else {

        if (xobject = nothing) and (sword in player) {
            !Let player know that it was implied.
            xobject = sword
            PrintMessage(6,12,sword)
        }
    
        if (xobject.after) {
            return true
        } elseif (object.after) {
            return true
        } else {
            if (xobject is sharp) {
                return Perform(&DoCut, object, xobject)
            } else {
                return Perform(&DoHit, object, xobject)
            }
        }
    }
}

!----------------------------------------------------------------------------
! Unless we specifically handle "DoKick" in objects, we'll assume the
! player meant to "cut" or "hit" the object, so that our objects can
! react to those things if needed.
!
routine DoKick
{
    if not CheckReach(object):  return false

    !Adding support for implying the attacker.
    if (object = nothing) and (xobject = nothing) {
        if (attacker ~= nothing) {
            ! Fix a bug that causes the spider to get listed twice. I have
            ! it auto-listed when attacking the spider if you don't specify
            ! it's color (so the player knows which one), but if you go at
            ! it this way, it's going to list twice. So, only do it if we
            ! are not attacking the spiders, when implying the attacker.
            if (attacker ~= red_spider, black_spider, gray_spider) {
                print "("; The(attacker); ")" !Let the player know it.
            }
            return Perform(&DoKick, attacker) !And then redirect it.
        } else {
            DoVague : return false
        }
    }

    if (object.after) {
        return true
    } elseif (object is unholdable) {
        PrintMessage(3,2,1) !You can't do that.
    } else {
        return Perform(&DoHit, object)
    }
}

!----------------------------------------------------------------------------
! No version of DoPunch accepts an xobject, so we always assume fists.
!
routine DoPunch
{
    if not CheckReach(object):  return false

    !Adding support for implying the attacker.
    if (object = nothing) and (xobject = nothing) {
        if (attacker ~= nothing) {
            ! Fix a bug that causes the spider to get listed twice. I have
            ! it auto-listed when attacking the spider if you don't specify
            ! it's color (so the player knows which one), but if you go at
            ! it this way, it's going to list twice. So, only do it if we
            ! are not attacking the spiders, when implying the attacker.
            if (attacker ~= red_spider, black_spider, gray_spider) {
                print "("; The(attacker); ")" !Let the player know it.
            }
            return Perform(&DoPunch, attacker) !And then redirect it.
        } else {
            DoVague : return false
        }
    }

    if (object.after) {
        return true
    } else {
        return Perform(&DoHit, object)
    }
}

!----------------------------------------------------------------------------
! User is trying to sniff or smell something.
!
routine DoSniff
{
    if (object = nothing) {
        Perform(&DoSniff, location) !We're smelling the location itself.
    } else {
        if (object.type = room) {
            ! If the air *doesn't* smell fine, trap this at the room level,
            ! with a "before object DoSniff" routine. That will work okay.
            PrintMessage(13,sky,1) !the air smells fine.
        } else {
            PrintMessage(3,2,2) !Nothing notable there.
        }
    }
}

!----------------------------------------------------------------------------
!If we get here, then the object didn't have a DoLookBehind trap. So, let's
!go for the Hugo default, and re-route to DoLookUnder.
!
routine DoLookBehind
{
    if (object is living) {
        PrintMessage(3,4,2) !
    } else {
        return Perform(&DoLookUnder,object)
    }
}

!----------------------------------------------------------------------------
! I want to give a different message when it involves a living character.
! This is so I don't have to remember to trap for this all over the place.
!
replace DoLookUnder
{
    if not CheckReach(object): return false

    if (object is living) {
        PrintMessage(3,4,1) !
    } else {
        VMessage(&DoLookUnder, 1)   ! "You don't find anything."
        return true
    }
}

!----------------------------------------------------------------------------
! The only time DoSwitchOnOff is called is in the simple "turn object" form.
!
replace DoSwitchOnOff
{
    if (object is switchable) {
        if object is switchedon
            return Perform(&DoSwitchOff, object)
        else
            return Perform(&DoSwitchOn, object)
    } else {
        if (word[1] = "turn") {
            return Perform(&DoTurn, object)
        } else {
            !Emulate what the lib would say if it *wasn't* switchable.
            ParseError(12,object) !You can't do that with the object.
        }
    }
}

!----------------------------------------------------------------------------
routine DoTurn
{
    if (object.after) {
        return true
    } elseif (object is unholdable) {
        PrintMessage(3,2,1) !You can't do that.
    } else {
        PrintMessage(3,2,3) !Nothing happens.
    }
}

!----------------------------------------------------------------------------
routine DoLasso
{
    if (xobject = nothing) {
        if Contains(player,rope) {
            xobject = rope
            PrintMessage(6,12,rope) !Let player know it's implied.
        } else {
            PrintMessage(3,2,7) !You don't have anything to use as a lasso.
            return false
        }
    }

    if (xobject = rope) {
        if (object is unholdable) {
            PrintMessage(3,2,1) !You can't do that.
        } elseif (AttachedCount(xobject) >= xobject.#attached_to) {
            PrintMessage(3,2,8) !Rope is already attached to things.
        } else {
            PrintMessage(3,2,5) !You see no good way to do that.
        }
    } else {
        PrintMessage(3,2,9) !You can't lasso anything with that.
    }
}

!----------------------------------------------------------------------------
routine DoProvoke
{
    if (object.after) {
        return true !Move ahead the turns counter.
    } else {
        PrintMessage(3,2,4) !"You don't know how."
    }
}

!----------------------------------------------------------------------------
! This is to accomodate the rare (but possible) case where a player might
! open something, and then try to "look inside" (without saying "it").
!
routine DoLookInside
{
    local retval = false
    local obj

    if (obj <= nothing): obj = last_object
    if (obj <= nothing): obj = it_obj
    if (obj <= nothing): obj = them_obj

    object = obj !So pronoun will persist.

    if (obj <= nothing) or (obj = in_obj) {
        PrintMessage(3,2,1) !You can't do that.
    } else {
        Message(&parse,2) !"(assuming you mean...)"
        print " "; The(obj); ")"
        if (obj is not container) {
            ParseError(12,obj) !You can't do that with...
        } else {
            retval = Perform(&DoLookIn,obj)
        }
    }
    return (retval)
}

!----------------------------------------------------------------------------
routine DoLift
{
    ! Ordinarily, lift, pick, and raise equate to "DoGet". But, in order to
    ! make it easier for trapping real "lift" attempts, separate it out into
    ! its own verbroutine. If it's not trapped in "before" code, just DoGet.

    ! If we said "lift x from y" then it'll be a "DoGetFrom" instead.
    return Perform(&DoGet, object) !XObject doesn't apply, when lifting.
}

!----------------------------------------------------------------------------
routine DoLower
{
    ! Lowering something you hold, when the verbword was "let", probably
    ! means that the player wanted to drop it.

    if (Contains(player,object) and VerbWord = "let") {
        return Perform(&DoDrop, object)
    } else {
        PrintMessage(3,2,5) !You see no good way to do that.
    }
}

!----------------------------------------------------------------------------
routine DoGiveReverse
{
    !We specified the command backwards, such as "let NPC have OBJECT"
    return perform (&DoGive, xobject, object)
}

!----------------------------------------------------------------------------
routine DoTouch
{
    if not CheckReach(object): return false

    if (xobject = nothing) or not (xobject.after) {
        if not (object.after) {
            PrintMessage(3,2,3) !Nothing happens.
        }
    }
    return true !To increment move counter
}

!----------------------------------------------------------------------------
routine DoThrowAt
{
    !Note that if we change the max size of this, we also have to change it
    !in other places, like the PrintMessage(3,26,obj) routine.

    if (object.size > 50) {
        PrintMessage(4,16,1) !It's too large to throw
        return false !No turns used
    } else {
        if (xobject = nothing) {
            if (object.size > 25) {
                move object to location !It falls to the ground
                if not (object.after) {
                    PrintMessage(4,16,2) !We're able to throw it.
                }
            } else {
                move object to location !It falls to the ground
                if not (object.after) {
                    PrintMessage(4,16,3) !We're easily able to throw it.
                }
            }
        } elseif (xobject is living) {
            !If we really *can* throw at the NPC, then check in
            !the BEFORE code. Otherwise, if we get here, we can't.
            PrintMessage(4,16,6) !Try throwing at an NPC. We can't.
        } else {
            !We'll allow them to throw OBJECT at XOBJECT.
            if (xobject is container) and \
               (xobject is openable) and \
               (xobject is open) {
                !If we're throwing "into" something, here's how we do it.
                return Perform(&DoPutIn,object,xobject) !Do "PutIn" instead.
            } else {
                PrintMessage(4,16,4) !We throw object at xobject.
                move object to location !It falls to the ground
            }
        }
    }
    return true !Incremement moves counter
}

!----------------------------------------------------------------------------
routine DoChase
{
    if (object.after) {
        return true !Increment the move counter. We did something.
    } else {
        if (object is living) {
            if (object in location) {
                PrintMessage(3,2,24) !The NPC is still here.
            } else {
                PrintMessage(3,2,5) !You see no good way to do that.
            }
        } else {
            !It's not something that can be followed.
            PrintMessage(3,15,object) !You can't CHASE/FOLLOW the OBJECT.
        }
    }
}

!----------------------------------------------------------------------------
routine DoStyleThemes
{
    PrintMessage(15,2,9) !Tell the player which themes are available.
    PrintMessage(15,2,8) !Tell the player what theme/style we are using.
}

!----------------------------------------------------------------------------
routine DoStyleString
{
    local theme = 0
    !Check to see if the user put the theme name in quotation marks.
    if IsEqual(parse$,"original","Original","ORIGINAL") {
        word[2] = "original" : theme = 1
    }
    if IsEqual(parse$,"default","Default","DEFAULT") {
        word[2] = "default" : theme = 1
    }
    if IsEqual(parse$,"normal","Normal","NORMAL") {
        word[2] = "normal" : theme = 1
    }
    if IsEqual(parse$,"blue","Blue","BLUE") {
        word[2] = "blue" : theme = 1
    }
    if IsEqual(parse$,"old","Old","OLD") {
        word[2] = "old" : theme = 1
    }

    !Check to see if the user put the theme name in quotation marks.
    if IsEqual(parse$,"swordsman","Swordsman","SWORDSMAN") {
        word[2] = "swordsman" : theme = 2
    }
    if IsEqual(parse$,"custom","Custom","CUSTOM") {
        word[2] = "custom" : theme = 2
    }
    if IsEqual(parse$,"white","White","WHITE") {
        word[2] = "white" : theme = 2
    }
    if IsEqual(parse$,"tales","Tales","TALES") {
        word[2] = "tales" : theme = 2
    }
    if IsEqual(parse$,"new","New","NEW") {
        word[2] = "new" : theme = 2
    }

    if (theme = 1): perform(&DoStyleNormal)
    elseif (theme = 2): perform(&DoStyleCustom)
    else: PrintMessage(15,2,10) !No such theme, and show real ones.
}

!----------------------------------------------------------------------------
routine DoStyleNormal
{
    if (glk_port) {
        PrintMessage(15,2,1) !Not supported in GLK versions.
    } else {
        if (GAME_PRINTSTYLE = 1) {
            PrintMessage(15,2,2) !You are already using this style.
        } else {
            set_colors(1)
            cls !Not GLK, so no GLK_CLS
            PrintMessage(15,2,3) !Switching to the other style.
            PrintStatusLine
            DescribePlace(location,true)
        }
    }
}

!----------------------------------------------------------------------------
routine DoStyleCustom
{
    if (glk_port) {
        PrintMessage(15,2,1) !Not supported in GLK versions.
    } else {
        if (GAME_PRINTSTYLE = 2) {
            PrintMessage(15,2,2) !You are already using this style.
        } else {
            set_colors(2)
            cls !Not GLK, so no GLK_CLS
            PrintMessage(15,2,3) !Switching to the other style.
            PrintStatusLine
            DescribePlace(location,true)
        }
    }
}

!----------------------------------------------------------------------------
! Although players will likely never do this, there are times when things do
! appear in descriptions and would be missed otherwise. So, prevent it.
!
replace DoSuperBrief
{
    PrintMessage(3,2,1) !You can't do that.
}

!----------------------------------------------------------------------------
! I want to warn players that they might miss things that happen if they
! switch to verbose mod!.
!
replace DoVerbose
{
    local ok
    if (verbosity = 2) {
        PrintMessage(15,2,5)
    } else {
        PrintMessage(15,2,6)
        GetInput
        ok = YesOrNO
        if (ok) {
            print "" !Because "linefeed" wasn't working.
            VMessage(&DoVerbose)
            PrintMessage(15,2,7)
            verbosity = 2
        }
    }
}
!----------------------------------------------------------------------------
replace DoBrief
{
    if (verbosity = 0) {
        PrintMessage(15,2,5)
    } else {
        VMessage(&DoBrief)
        verbosity = 0
    }
}

!----------------------------------------------------------------------------
! This will ordinarily call "DoDrop" or "DoPutIn" as needed. It was added,
! though, to trap for things like trying to drop the beam over the edge of
! the loft. Everything can be handled by defaults except what needs trapped.
!
routine DoDropDown
{
    if (xobject) and (xobject ~= d_obj) {
        ! Attempt to put the object into the container/platform.
        ! The lib DoPutIn routine will check to be sure it works.
        return Perform(&DoPutIn,object,xobject)
    } else {
        ! We specified no xobject, so we're just dropping it.
        return DoDrop(object)
    }
}

!----------------------------------------------------------------------------
routine DoBarReverse
{
    !Swap object and xobject and re-route the request.
    return perform(&DoBar, xobject, object)
}

!----------------------------------------------------------------------------
! For this verbroutine to have a purpose, it needs to be trapped in object
! or xobject "before" handlers. Otherwise, we're going to say you can't
! bar/block the object ("with anything" if there was an xobject specified).
!
routine DoBar
{
    if not CheckReach(object):  return false

    if (word[1] = "block") {
        if (object is living) {
            if (xobject is sharp) or (xobject = nothing) {
                return perform(&DoBlock, object, xobject)
            } else {
                PrintMessage(3,2,9) !You can't BLOCK anything with the xobject.
            }
        } else {
            PrintMessage(3,15,object) !You can't BLOCK the OBJECT.
        }
    } else {
        if (xobject) {
            ! Unless I want to add an attribute "canblock" or something, to
            ! all holdable items, I need to remember to trap for DoBar in
            ! the xobject for anything that *can* be used to block stuff.
            PrintMessage(3,2,9) !You can't BAR anything with the xobject.
        } else {
            ! Same here. If something can be barred, but we did not
            ! specify an xobject, I either need to say "be more specific"
            ! in the handling for the object *or* imply whatever thing we
            ! may be holding that can bar the object.
            PrintMessage(3,15,object) !You can't BAR the OBJECT.
        }
    }
}

!----------------------------------------------------------------------------
routine DoUnbarReverse
{
    !Swap object and xobject and re-route the request.
    return perform(&DoUnbar, xobject, object)
}

!----------------------------------------------------------------------------
! Because I'm supporting "bar" and "block", it stands to reason that some
! players might try to "unbar" or "unblock" something. So, I need some
! default handling for that. Things that really can be "unbarred" should be
! trapped for in object or xobject "before" handling. Otherwise, we're going
! to assume "DoUnlock" for lockables, etc.
!
routine DoUnbar
{

    if not CheckReach(object):  return false

    ! If it's a lockable thing *and* it's either locked or an xobject
    ! was specified, then we're going to route it through the DoUnlock.
    if (object is lockable) and ((object is locked) or xobject) {
        if (object.key_object = xobject) or (xobject = nothing) {
            perform(&DoUnlock,object,xobject)
        } else {
            if (object is not locked) {
                VMessage(&DoUnlock,3) !It's already unlocked.
            } else {
                VMessage(&DoUnlock,1) !Doesn't seem to do the trick.
            }
        }
    } elseif (object is openable) {
        if (object is open) {
            VMessage(&DoOpen,2) ! It's already open.
        } else {
            if (xobject = nothing) {
                perform(&DoOpen,object)
            } else {
                ! Xobject can be specified in reversed version. For instance,
                ! "unbar X from Y". If translated into "open Y with X" then
                ! it won't make a lot of sense. So, we give an appropriate
                ! message. Or, if the user said "unbar door with key" and
                ! the door isn't something that's lockable, we will fall
                ! down to here. You don't need an xobject just to "open"
                ! something, really.
                PrintMessage(3,2,5) !You see no good way to do that.
            }
        }
    } else {
        !We're trying to unbar something that isn't really applicable.
        !For anything that is, we should be doing object.before trapping.
        PrintMessage(3,2,5) !You see no good way to do that.
    }
}

!----------------------------------------------------------------------------
! I want to suggest that the player "pick up" things which aren't static,
! instead of saying "You can't move that". It would make more sense in
! certain situations, such as "move beam" which actually *can* be done
! when it's on the floor of the loft, but ordinarily can't.
!
replace DoMove
{
    if not CheckReach(object):  return false

    if (object is static) {
        VMessage(&DoMove)                ! "You can't move that."
        return true
    } else {
        PrintMessage(3,26,object)
    }
}

!----------------------------------------------------------------------------
routine DoTrap
{
    !Real/successful attempts should be handled in "living.before" code.
    if not CheckReach(object):  return false
    PrintMessage(3,2,5) !You see no good way to do that.
}

!----------------------------------------------------------------------------
routine DoPry
{
    if not CheckReach(object): return false

    if (xobject = nothing) {
        ! Give the player a "how do you intend to do that?" prompt,
        ! which will set the LookForAnswer ("with object") condition.
        PrintMessage(3,22,object) !How do you intend to? (with x?)
    } else {
        PrintMessage(3,2,5) !You see no good way to do that.
    }
    !Since we essentially accomplish nothing...
    return false !Don't increment the turn counter though.
}

!----------------------------------------------------------------------------
routine DoSleep
{
    !If we really can, we should trap for it in object routines.
    if (object = nothing) {
        PrintMessage(15,7,1) !You don't feel particularly tired, etc.
    } elseif (object is sleepable) {
        PrintMessage(15,7,object) !Display the custom response to sleep.
    } else {
        PrintMessage(15,7,2) !Object doesn't seem like a comfortable place.
    }
    return false !Because we didn't actually do anything.
}

!----------------------------------------------------------------------------
routine DoRelease
{
    !The "xobject" handling is obsolete, as the verb def was changed.
    !if (xobject) {
    !    if Contains(xobject,object) or InList(object,found_in,xobject) {
    !        PrintMessage(3,2,5) !You see no good way to do that.
    !    } else {
    !        ParseError(14, object) !You don't see the object there.
    !    }
    !} else {
        PrintMessage(3,2,5) !You see no good way to do that.
    !}
    return false !Nothing was accomplished, so don't waste a turn.
}

!----------------------------------------------------------------------------
routine DoHang
{
    if not CheckReach(xobject): return false
   
    !We should handle attempts to "hang" things in specific object routines.
    if (xobject = nothing) {
        ParseError(13) !You'll have to be more specific.
    } else {
        PrintMessage(3,29,object) !You see no way to hang it there.
    }
}

!----------------------------------------------------------------------------
! If player tries to do a "water object (with held)" instead of a
! "pour held (on xobject)" then this will be here to handle it.
!
routine DoWater
{
    if (xobject = nothing) {
        if Contains(player,flask) {
            xobject = flask
            PrintMessage(6,12,flask)
        } else {
            PrintMessage(3,2,5) !You see no good way to do that.
            return false
        }
    }
    if (xobject = flask) {
        return Perform(&DoEmpty, xobject, object) !Reverse and do a POUR.
    } else {
        PrintMessage(3,2,9) !You can't water anything with the xobject.
        return false
    }
}

!----------------------------------------------------------------------------
! To support "stand on plate"
!
routine DoStandOn
{
    ! We should trap for it in object "before" for anything that's valid.
    ! Otherwise, we're just going to re-route it to DoStand.
    return Perform(&DoStand)
    !TODO - should we check anything and say "you see no good way" or maybe
    !redirect to DoClimb in certain cases? Investigate those things later.
}

!----------------------------------------------------------------------------
replace DoRestore
{
    if restore
    {
        ! First, re-evaluate things that might have changed between now
        ! and whenever the save file was made.
        
        glk_port = is_glk_port !Are we using a GLK Hugo port?
        after_comp = is_after_comp !Comp vote deadline passed?
        
        ! For whatever reason, "local" vars are erased after a restore.
        ! So, unlike "undo" where I can remember if the theme changed,
        ! here, I can't. So I'm going to have to clear the screen always.
        if (not glk_port) {
            set_colors(GAME_PRINTSTYLE)
            cls !Not GLK, so no GLK_CLS
        }
        
        VMessage(&DoRestore, 1)         ! "Restored."
        PrintStatusline
        DescribePlace(location, true)
        return true
    }
    else:  VMessage(&DoRestore, 2)           ! "Unable to restore."
}

!----------------------------------------------------------------------------
replace DoUndo
{
    !Use a junk as an initial parm, due to a prior Hugo quirk.
    local junk = false, oldtheme
    oldtheme = GAME_PRINTSTYLE
    
    if (junk) { } !Just to avoid compiler warning.

    if not UNDO_OFF
    {
        if undo
        {
            if (not glk_port) and (oldtheme ~= GAME_PRINTSTYLE) {
                GAME_PRINTSTYLE = oldtheme
                word[1] = "theme" !For the message.
                select oldtheme
                case 1 {
                    word[2] = "custom"
                    perform (&DoStyleCustom)
                }
                case 2 {
                    word[2] = "default"
                    perform (&DoStyleNormal)
                }
            } else {
                DescribePlace(location)
                PrintStatusline
            }
        }
        else
            VMessage(&DoUndo) !Can't Undo
    }
    else
        VMessage(&DoUndo) !Can't Undo
}

!----------------------------------------------------------------------------
! Ordinarily, this just auto-routes into DoGo.
!
routine DoRun
{
    local retval = false
    if (object = nothing) {
    	VMessage(&DoGo, 4)	! "Which way...?"
    	print "1"
    } else {
        if (object = u_obj, d_obj) {
            PrintMessage(3,30,object) !You can't run upward/downward.
        } else {
            retval = Perform(&DoGo, object) !Redirect
        }
    }
    return (retval)
}

!----------------------------------------------------------------------------
! I want to be able to "imply" the NPC, so modified the top part a little.
!
replace DoShow
{
	if (not xobject) {
	    xobject = CheckForNPC
	    if (xobject) {
	        print "(to "; The(xobject); ")"
	        return Perform(&DoShow, object, xobject)
	    } else {
    		VMessage(&DoShow, 1)    ! "Be more specific..."
	    	return false	
	    }
	}

	if not xobject.after
	{
		if not object.after
		{
			if xobject is not living
				! showing it to something inanimate
				VMessage(&DoShow, 2)
			else
				! character ignores it
				VMessage(&DoShow, 3)
		}
	}
	return true
}

!----------------------------------------------------------------------------
! Not using VerbStub, so we need to include this to handle the "use" verb.
!
routine DoUse
{
	"Be a little more specific about what you'd like ";
	if player_person ~= 2
		print player.pronoun #2; " ";
	"to do with ";
	print The(object, true); "."
}

!----------------------------------------------------------------------------
! This is called for "approach object" and "go to object" both. It should be
! a good indicator that the player is trying to approach something.
!
routine DoApproach
{
    if not CheckReach(object): return false
    
    PrintMessage(9,3,object) !It's right here. No need to approach.
    return false
}

!----------------------------------------------------------------------------
! This will call the print-message that shows what exits are available.
!
routine DoExits
{
    PrintMessage(14,location) !Show the available exits
}

!----------------------------------------------------------------------------
routine DoScare
{
    PrintMessage(15,11,object) !How do you intend to do that?
    return false !No turn incrementation.
}