/* credits.c: GlkDOS credits (curses version)
        for GlkDOS, curses.h/allegro implementation of the Glk API
    Designed by L. Ross Raszewski <lraszewski@justice.loyola.edu>
    
    based upon GlkTerm by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/index.html
*/

#include "glk.h"
#include <stdio.h>
#include "gtoption.h"
#include "glkdos.h"
#include "cscr.h"

int check_config();
int print_glk_credits(int pref_credits)
{
#ifdef UNIX
        printf("GlkDOS for unix, library version %s, GLK %s (%s %s).\n",
#else
        printf("GlkDOS classic, library version %s, GLK %s (%s %s).\n",
#endif
            LIBRARY_VERSION, GLK_VERSION, LIBRARY_PORT, __DATE__);
        if (cscr_version()==CSCR_DOS)
         printf("PC-BIOS accelerated version\n");

#ifdef NO_SOUND
        printf("(No Sound) ");
#endif
        if (!check_config())
         printf("(No Config)");
        printf("\nBy L. Ross Raszewski, based upon GlkTerm 0.7.4 by Andrew Plotkin\n");
        if (pref_credits)
{
#ifndef NO_SOUND
         printf("Sound support provided by the Allegro programming library\n");
         printf("by Shawn Hargreaves, and JGMod by Jeffery Guan Foo Wah.\n");
#endif
         printf("sglk extensions designed by L. Ross Raszewski and Evin Roberts\n");
         printf("GlkDOS is freeware, and cannot be used for any commercial ");
         printf("application, except by special permission of the author.\n");
         printf("For support and information, contact L. Ross Raszewski ");
         printf("<rraszews@acm.org>.\n");
}
        printf("For more information, see http://www.eblong.com/zarf/glk/index.html\n");      
        return 1;
}
    
