#charset "us-ascii"

/* 
 *   Copyright (c) 1999, 2000 by Michael J. Roberts
 *   
 *   This file is part of TADS 3 
 */

/*
 *   TADS Input/Output intrinsic function set 
 */

#ifndef TADSIO_H
#define TADSIO_H

/*
 *   the TADS input/output function set 
 */
intrinsic 'tads-io/030003'
{
    /* display values on the console */
    tadsSay(val, ...);

    /* set the display capture log file */
    setLogFile(fname);

    /* clear the display */
    clearScreen();

    /* show the "more" prompt, if supported on the platform */
    morePrompt();

    /* read a line of text from the keyboard */
    inputLine();

    /* read a single keystroke from the keyboard */
    inputKey();

    /* read a single input event */
    inputEvent(timeout?);

    /* display a simple dialog */
    inputDialog(icon, prompt, buttons, defaultButton, cancelButton);

    /* display a file selector dialog */
    inputFile(prompt, dialogType, fileType, flags);

    /* pause */
    timeDelay(delayMilliseconds);

    /* retrieve local system information */
    systemInfo(infoType, ...);

    /* set the status-line display mode, for text-only interpreters */
    statusMode(mode);

    /* write text on the right half of the status, for text-only terps */
    statusRight(txt);

    /* determine if a multimedia resource exists */
    resExists(fname);

    /* set the script input file */
    setScriptFile(filename, flags?);

    /* get the local default character set */
    getLocalCharacterSet(which);

    /* flush text output and update the display */
    flushOutput();
}

/* 
 *   constants for the event codes returned by the inputEvent() intrinsic
 *   function 
 */
#define INEVT_KEY        1
#define INEVT_TIMEOUT    2
#define INEVT_HREF       3
#define INEVT_NOTIMEOUT  4
#define INEVT_EOF        5

/*
 *   constants for inputDialog() 
 */
#define INDLG_OK               1
#define INDLG_OKCANCEL         2
#define INDLG_YESNO            3
#define INDLG_YESNOCANCEL      4

#define INDLG_ICON_NONE        0
#define INDLG_ICON_WARNING     1
#define INDLG_ICON_INFO        2
#define INDLG_ICON_QUESTION    3
#define INDLG_ICON_ERROR       4

#define INDLG_LBL_OK           1
#define INDLG_LBL_CANCEL       2
#define INDLG_LBL_YES          3
#define INDLG_LBL_NO           4

/*
 *   inputFile() dialog types 
 */
#define INFILE_OPEN    1               /* open an existing file for reading */
#define INFILE_SAVE    2                                /* save to the file */

/*
 *   inputFile() return codes - these are returned in the first element of
 *   the list returned from askfile() 
 */
#define INFILE_SUCCESS        0   /* success - 2nd list element is filename */
#define INFILE_FAILURE        1      /* an error occurred asking for a file */
#define INFILE_CANCEL         2        /* player canceled the file selector */

/*
 *   constants for inputFile() file type codes 
 */
#define FILETYPE_LOG     2                       /* a transcript (log) file */
#define FILETYPE_DATA    4          /* general data file (used for fopen()) */
#define FILETYPE_CMD     5                            /* command input file */
#define FILETYPE_TEXT    7                                     /* text file */
#define FILETYPE_BIN     8                              /* binary data file */
#define FILETYPE_UNKNOWN 11                            /* unknown file type */
#define FILETYPE_T3IMAGE 12              /* T3 executable image (game) file */
#define FILETYPE_T3SAVE  15                          /* T3 saved state file */

/*
 *   constants for systemInfo information type codes 
 */
#define SYSINFO_VERSION       2
#define SYSINFO_OS_NAME       3
#define SYSINFO_HTML          4
#define SYSINFO_JPEG          5
#define SYSINFO_PNG           6
#define SYSINFO_WAV           7
#define SYSINFO_MIDI          8
#define SYSINFO_WAV_MIDI_OVL  9
#define SYSINFO_WAV_OVL      10
#define SYSINFO_PREF_IMAGES  11
#define SYSINFO_PREF_SOUNDS  12
#define SYSINFO_PREF_MUSIC   13
#define SYSINFO_PREF_LINKS   14
#define SYSINFO_MPEG         15
#define SYSINFO_MPEG1        16
#define SYSINFO_MPEG2        17
#define SYSINFO_MPEG3        18
#define SYSINFO_HTML_MODE    19
#define SYSINFO_LINKS_HTTP   20
#define SYSINFO_LINKS_FTP    21
#define SYSINFO_LINKS_NEWS   22
#define SYSINFO_LINKS_MAILTO 23
#define SYSINFO_LINKS_TELNET 24
#define SYSINFO_PNG_TRANS    25
#define SYSINFO_PNG_ALPHA    26

/*
 *   constants for statusMode 
 */
#define STATMODE_NORMAL    0                      /* displaying normal text */
#define STATMODE_STATUS    1                    /* display status line text */

/*
 *   flags for setScriptFile 
 */
#define SCRFILE_QUIET    1    /* do not display output while reading script */
#define SCRFILE_NONSTOP  2     /* turn off MORE prompt while reading script */

/*
 *   selectors for getLocalCharSet
 */
#define CHARSET_DISPLAY  1            /* the display/keyboard character set */
#define CHARSET_FILE     2                 /* the file system character set */


#endif /* TADSIO_H */
