/*----------------------------------------------------------------------*\

	smScan.c

	ScannerMaker generated scanner

\*----------------------------------------------------------------------*/

/* %%IMPORT */


#include "sysdep.h"

#include "types.h"

#include "alan.h"
#include "lmList.h"
#include "encode.h"

/* For open, read & close */
#include <fcntl.h>
#ifndef _O_RAW
#define _O_RAW 0
#endif
#ifdef __sun__
#include <unistd.h>
#endif
#ifdef __vms__
#include <unixio.h>
#endif
#ifdef __dos__
#include <io.h>
#endif


/* END %%IMPORT */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "smScan.h"

/* Local imports */
extern int smScReader( smScContext smThis, unsigned char *smBuffer, unsigned int smLength );
extern int smScAction( smScContext smThis, int smInternalCode, Token *smToken );
extern int smScPostHook( smScContext smThis, Token *smToken );

/* System dependencies */

/* These datatypes should be defined to be unsigned integers of length 1, 2
 * and 4 bytes respectively.
 */
typedef unsigned char UByte1;
typedef unsigned short UByte2;
typedef unsigned int UByte4;


/* START of scanning tables */
UByte1 *smMap;
UByte1 *smDFAcolVal;
UByte1 *smDFAerrCol;

/* ISO scanner tables */
UByte1 smIsoMap[256]={
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47
,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63
,64,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111
,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95
,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111
,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143
,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159
,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175
,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191
,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
,240,241,242,243,244,245,246,215,248,249,250,251,252,253,254,223
,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
}
;

UByte1 smIsoDFAcolVal[256]={
0,0,0,0,0,0,0,0,0,30,29,0,0,30,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,30,39,40,0,41,0,0,31,42,43,44,45,46,32,37,38
,0,0,0,0,0,0,0,0,0,0,33,0,36,28,27,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,0,0,0,0,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,34,0,35,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
,10,10,10,10,10,10,10,0,10,10,10,10,10,10,10,0
,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
,10,10,10,10,10,10,10,0,10,10,10,10,10,10,10,0
}
;

UByte1 smIsoDFAerrCol[256]={
0,0,0,0,0,0,0,0,0,1,2,0,0,3,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,1,4,5,0,4,0,0,6,4,4,4,4,4,7,4,4
,8,8,8,8,8,8,8,8,8,8,4,0,4,9,10,0
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,0,0,0,0,19
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,4,0,4,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,11,11,11,11,11,11,11,0,11,11,11,11,11,11,11,0
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,11,11,11,11,11,11,11,0,11,11,11,11,11,11,11,0
}
;

/* MAC scanner tables */
UByte1 smMacMap[256]={
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47
,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63
,64,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111
,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95
,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111
,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143
,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159
,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175
,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191
,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
,240,241,242,243,244,245,246,215,248,249,250,251,252,253,254,223
,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
}
;

UByte1 smMacDFAcolVal[256]={
0,0,0,0,0,0,0,0,0,30,29,0,0,30,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,30,39,40,0,41,0,0,31,42,43,44,45,46,32,37,38
,0,0,0,0,0,0,0,0,0,0,33,0,36,28,27,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,0,0,0,0,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,34,0,35,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
,10,10,10,10,10,10,10,0,10,10,10,10,10,10,10,0
,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
,10,10,10,10,10,10,10,0,10,10,10,10,10,10,10,0
}
;

UByte1 smMacDFAerrCol[256]={
0,0,0,0,0,0,0,0,0,1,2,0,0,3,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,1,4,5,0,4,0,0,6,4,4,4,4,4,7,4,4
,8,8,8,8,8,8,8,8,8,8,4,0,4,9,10,0
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,0,0,0,0,19
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,4,0,4,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,11,11,11,11,11,11,11,0,11,11,11,11,11,11,11,0
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,11,11,11,11,11,11,11,0,11,11,11,11,11,11,11,0
}
;

/* DOS scanner tables */
UByte1 smDosMap[256]={
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47
,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63
,64,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111
,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95
,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111
,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127
,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143
,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159
,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175
,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191
,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
,240,241,242,243,244,245,246,215,248,249,250,251,252,253,254,223
,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
}
;

UByte1 smDosDFAcolVal[256]={
0,0,0,0,0,0,0,0,0,30,29,0,0,30,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,30,39,40,0,41,0,0,31,42,43,44,45,46,32,37,38
,0,0,0,0,0,0,0,0,0,0,33,0,36,28,27,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,0,0,0,0,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,34,0,35,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
,10,10,10,10,10,10,10,0,10,10,10,10,10,10,10,0
,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
,10,10,10,10,10,10,10,0,10,10,10,10,10,10,10,0
}
;

UByte1 smDosDFAerrCol[256]={
0,0,0,0,0,0,0,0,0,1,2,0,0,3,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,1,4,5,0,4,0,0,6,4,4,4,4,4,7,4,4
,8,8,8,8,8,8,8,8,8,8,4,0,4,9,10,0
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,0,0,0,0,19
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,4,0,4,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,11,11,11,11,11,11,11,0,11,11,11,11,11,11,11,0
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,11,11,11,11,11,11,11,0,11,11,11,11,11,11,11,0
}
;



/*
 * MAP
 *
 * [character] -> character
 *
 */



/*
 * SCANNER
 *
 * [scanner] -> state
 */

static UByte1 smScanner[2]={
0,1
}
;

/*
 * ACCEPT (internal token code)
 *
 * [state] -> icode
 */

static UByte1 smAccept[461]={
0,0,146,10,7,8,9,11,1,12,2,13,140,6,15,5
,14,141,3,4,152,143,142,147,33,30,31,18,32,22,19,24
,27,25,20,17,21,23,29,26,28,16,149,39,37,40,35,44
,41,38,46,47,36,42,43,48,34,45,54,71,53,50,55,66
,61,70,68,63,73,67,56,62,76,65,52,74,64,59,72,58
,75,49,60,51,57,69,92,83,80,82,90,86,78,77,88,91
,79,87,85,84,81,89,108,103,104,100,96,99,102,101,97,95
,107,94,93,106,98,105,111,117,120,112,116,114,115,110,109,113
,119,118,148,129,128,122,125,124,127,130,123,126,121,133,132,134
,131,135,138,136,137,139,0,141,142,0,141,0,141,0,141,0
,141,0,141,0,141,0,141,0,141,0,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141
,141,141,141,141,141,141,141,141,141,141,141,141,141
}
;

/*
 * EXTERNAL TOKEN CODE
 *
 * [icode] -> ecode
 */

static UByte1 smTokenCode[152]={
5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20
,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36
,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52
,53,54,55,56,58,59,60,61,62,63,64,65,66,67,68,69
,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85
,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101
,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117
,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133
,134,135,136,137,138,139,140,141,142,143,144,4,3,3,57,1
,2,0,0,0,3,1,2,0
}
;

/*
 * EOT and Unknown
 *
 * [scanner] -> icode
 *
 */

static UByte1 smEOTCode[2]={
144,150
}
;
static UByte1 smUnknownCode[2]={
143,149
}
;

/*
 * DFA
 */

  
static UByte1 smDFAdetRow[461]={
1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1
,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0
,1,0,1,1,0,1,0,1,0,0,0,0,0,0,0,1
,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0
,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0
,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,0
,1,0,1,0,1,0,1,0,1,0,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1
}
;
static UByte1 smDFAdetCol[256]={
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
}
;
  
static UByte2 smDFArowVal[461]={
141,188,2,461,461,461,461,461,461,23,461,461,12,461,220,188
,28,519,461,461,20,150,461,23,461,461,461,461,461,600,654,400
,188,400,220,249,400,276,400,303,400,400,157,400,400,400,400,330
,400,400,400,400,400,400,400,400,357,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,384,400,400,400,400,400,400,400,400
,400,400,400,400,400,411,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,438,400,400,400,400,400,400,465
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,461,400,400,400,400,400,400,400,400,400,400,492,400,400
,400,400,400,400,400,400,0,546,155,159,573,47,627,94,681,161
,708,163,735,165,762,167,789,169,816,130,843,870,897,924,951,978
,1005,1032,1059,1086,1113,1140,1167,1194,1221,1248,1275,1302,1329,1356,1383,1410
,1437,1464,1491,1518,1545,1572,1599,1626,1653,1680,1707,1734,1761,1788,1815,1842
,1869,1896,1923,1950,1977,2004,2031,2058,2085,2112,2139,2166,2193,2220,2247,2274
,2301,2328,2355,2382,2409,2436,2463,2490,2517,2544,2571,2598,2625,2652,2679,2706
,2733,2760,2787,2814,2841,2868,2895,2922,2949,2976,3003,3030,3057,3084,3111,3138
,3165,3192,3219,3246,3273,3300,3327,3354,3381,3408,3435,3462,3489,3516,3543,3570
,3597,3624,3651,3678,3705,3732,3759,3786,3813,3840,3867,3894,3921,3948,3975,4002
,4029,4056,4083,4110,4137,4164,4191,4218,4245,4272,4299,4326,4353,4380,4407,4434
,4461,4488,4515,4542,4569,4596,4623,4650,4677,4704,4731,4758,4785,4812,4839,4866
,4893,4920,4947,4974,5001,5028,5055,5082,5109,5136,5163,5190,5217,5244,5271,5298
,5325,5352,5379,5406,5433,5460,5487,5514,5541,5568,5595,5622,5649,5676,5703,5730
,5757,5784,5811,5838,5865,5892,5919,5946,5973,6000,6027,6054,6081,6108,6135,6162
,6189,6216,6243,6270,6297,6324,6351,6378,6405,6432,6459,6486,6513,6540,6567,6594
,6621,6648,6675,6702,6729,6756,6783,6810,6837,6864,6891,6918,6945,6972,6999,7026
,400,7053,7080,7107,7134,7161,7188,7215,7242,7269,7296,7323,7350,7377,7404,7431
,7458,7485,7512,7539,7566,7593,7620,7647,7674,7701,7728,7755,7782,7809,7836,7863
,7890,7917,7944,7971,7998,8025,8052,8079,8106,8133,8160,8187,8214,8241,8268,8295
,8322,8349,8376,8403,8430,8457,8484,8511,8538,8565,8592,8619,8646
}
;
static UByte1 smDFAerr[(21*20+7)/8]={
0x80,0x00,0x19,0xDF,0xFF,0x8F,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xF7,0xFF,0xFF,
0x9F,0xFF,0xFB,0xFF,0xFF,0x60,0x09,0xFF,0xFF,0xFB,0xFF,0xF3,0x00,0x00,0xFD,0xFF,
0xF0,0x00,0x00,0xFF,0xFE,0xFF,0xFF,0xFB,0xFF,0xF7,0xFF,0xFF,0xF7,0xFF,0xFF,0xDF,
0xFF,0xBF,0xFF,0xFD,0xF0
};
  
static UByte1 smDFAerrRow[461]={
0,1,2,3,3,3,3,3,3,4,3,3,5,3,6,6
,7,8,3,3,9,10,3,11,3,3,3,3,3,8,8,8
,8,8,8,8,8,8,8,8,8,8,12,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,3,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,13,8,12,14,8,13,8,13,8,15
,8,16,8,17,8,18,8,19,8,20,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8
}
;
  
static UByte2 smDFAval[8673]={
150,150,150,150,150,150,150,150,150,150,150,150,150,150,150,150
,150,150,150,150,150,150,150,150,150,150,150,150,150,150,150,150
,150,150,150,150,150,150,150,150,21,150,150,150,150,150,150,155
,155,155,155,155,155,155,155,155,155,155,155,155,155,155,155,155
,155,155,155,155,155,155,155,155,155,155,155,155,22,155,152,155
,155,155,155,155,155,155,155,155,155,155,155,155,155,155,157,157
,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157
,157,157,157,157,157,157,157,157,157,157,157,157,157,42,157,157
,157,157,157,157,157,157,157,157,157,157,157,157,157,12,17,151
,154,156,266,267,400,268,158,400,400,346,269,160,162,347,348,435
,270,164,271,349,350,400,400,400,16,15,2,2,155,9,13,18
,19,14,10,11,3,150,153,4,5,6,7,8,400,400,400,400
,400,180,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,27,26,20,20,157,400,400,400,416
,459,400,400,400,400,460,400,400,400,400,400,400,400,400,400,400
,186,400,400,400,400,400,400,25,24,400,49,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,52,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,193,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,62,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,79,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,228,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,101,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,340
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,126,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,146
,400,400,400,400,400,400,400,400,400,400,351,166,400,352,400,400
,400,400,400,400,400,29,400,400,400,168,400,30,400,400,400,400
,400,400,400,400,400,400,400,401,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,31,400,400,402,400
,400,400,400,400,400,353,400,400,400,400,400,400,354,400,400,400
,400,400,436,400,400,400,400,400,400,400,400,400,44,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,403,400,400,400,452,400,400,400
,400,400,32,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,458,400,400,400,400,400,400,400,400,400,400,400,400,33
,400,400,400,400,400,400,404,34,400,400,400,400,35,36,400,400
,400,400,400,400,400,280,400,400,400,281,400,400,400,400,400,400
,400,400,400,37,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,38,400,400,400,400,400,400,400,39,400,405
,400,40,400,400,400,400,400,400,400,400,400,408,400,400,400,400
,400,400,178,400,400,400,400,400,400,41,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,43,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,45,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,410,400,400,400,400,400,400,400,400,400,400,46
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,413
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,47,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,48,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,190,400,400,400,400,400,400,400,400
,400,400,400,400,50,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,51,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,196,400,400,53,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,54,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,55,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,56,400,400,400,200,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,57,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,58,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,59,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,60,400,400,400,210,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,61,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,63,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,64,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,65,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,66,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,67,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,68,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,69,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,70,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,71
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,72,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,73,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,74,400,400,400,400,400,400,400,400,400,400,400,75,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,76,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,77
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,78,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,80,400,400,400,400,400,400,400
,400,400,81,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,82
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,83,400,400,400,220,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,84,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,85,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,86,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,87,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,88,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,89,400,400,400
,400,400,400,400,400,400,400,400,400,90,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,91,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,92,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,93,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,94,400,400,400,400,400,400,400,400,400,400,400,95
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,96,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,97,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,98,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,99,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,100,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,102,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,103,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,104,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,105
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,106,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,107,400,400,400,400,400,400,400,400,400
,400,400,400,108,400,400,400,335,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,109,400,400,400,400,400,400,110,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,111,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,112,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,113,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,114,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,115,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,116,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,117,400,400,400,400,400,400,400,400,400,400,400
,400,118,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,119,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,120,400,400,400,400,400,400,400,400,400
,400,121,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,122,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,123,400,400,400,400,400,400,400,400
,400,400,400,124,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,125,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,127,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,128,400,400,400,400,400,400,400,400,400,400,400,129
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,259,400,400,400,400,400
,400,400,400,400,400,400,400,400,131,400,400,400,400,400,400,400
,400,400,400,400,400,132,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,133,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,134,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,135,400,400,400,400,400
,400,136,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,137,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,138,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,139,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,140,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,141,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,142,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,143,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,144,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,145,400,400,400,400,400,400,400,400,400,400,400,400,147
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,148,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,149,400
,400,400,400,400,400,400,400,400,400,400,400,400,272,400,400,400
,400,400,400,400,400,400,400,273,355,170,400,400,400,400,400,400
,400,356,400,274,400,400,400,400,400,400,400,400,400,400,400,357
,400,400,400,400,400,171,400,400,275,400,400,400,400,400,400,400
,400,400,172,400,400,400,276,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,173,400,400
,400,437,400,400,400,174,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,175,400,358,400,176,400,400,284
,400,400,400,400,400,400,400,400,400,400,400,285,177,400,400,400
,407,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,359,400,400,400,400,179,400,400,400,400,400,400,400,400,400,400
,181,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,182,400,400,400,400
,400,400,400,400,400,400,414,400,400,400,400,400,183,400,400,400
,400,400,400,400,400,400,400,415,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,184,400,400
,400,400,400,400,400,400,400,400,400,400,363,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,185,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,187,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,365,400,400,400
,400,400,188,400,400,400,400,400,400,400,400,400,400,366,400,400
,400,400,400,400,400,400,400,400,400,189,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,191,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,192,400,400,400,400,400,445,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,194,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,195
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,197,400,400,400,400,400,400,400,400,400,400,400,400,299,400,400
,400,198,400,400,400,400,400,400,400,400,400,199,400,400,300,400
,400,400,400,400,400,301,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,201,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,202,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,203,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,204,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,205,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,206,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,207,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,208,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,209,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,211,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,212,400,400,400,213,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,214,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,215,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,216,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,217,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,218,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,219,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,221,400,400,400,400,400,400,400,400,400,400,400
,400,400,222,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,223,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,224,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,225,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,226,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,227,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,229,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,230,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,231,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,232,400,400,400,400,400,400,400,400,400,400,400,233,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,234,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,235
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,236,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,237,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,238,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,239,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,240,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,241,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,242,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,243,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,244,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,245,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,246,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,247,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,248,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,249,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,250,400,400,400,400,400
,400,400,400,251,400,400,400,400,400,400,400,400,400,400,400,400
,400,434,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,252,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,253,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,254,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,255,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,256,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,257,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,258,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,260,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,261,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,262,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,263,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,264
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,265
,400,400,400,400,400,400,400,400,400,400,400,400,277,400,400,400
,400,400,400,400,278,400,400,400,400,400,279,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,282,400,400,400,400,400,438,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,283,400,400,400,400,400,400,400,400,400
,400,286,400,400,400,409,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,287,400,400,400,400,400,400,288
,289,400,400,400,400,400,290,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,291,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,292,400,400,400,400,400,400,400,453,400,400,400,293,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,440,400,400,400,400,400,400,294,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,295,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,296,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,297,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,446,400,400,400,400,400,400,298,400
,400,370,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,302,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,303,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,304,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,305,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,306,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,307,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,308,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,309,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,310,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,311,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,312,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,313,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,428,400,400
,400,400,314,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,315,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,316,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,317,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,318,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,319,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,320,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,321,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,322,400,400,400,400
,400,400,323,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,324,400,400,400,400,400,400,325,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,326,400,400,400,400,400,400,400,400,400,400,400,400,327,400
,400,400,400,400,400,400,400,400,400,400,400,400,328,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,329,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,330,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,331,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,332,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,333,400,400,400,400,400,400,400
,334,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,336,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,337,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,338,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,339
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,341,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,342,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,343,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,344,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,345,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,360,400,400,400,400,400,400,400,400,400,400,400,400
,400,411,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,361,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,441,400,400,442,400,400,400,400,400,400
,400,400,400,362,400,400,443,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,364,400
,400,400,400,400,400,400,400,400,400,400,367,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,368,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,369,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,371,400,400
,400,400,372,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,373,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,374,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,375,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,376,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,377,400,400,400,400,400,400,400
,400,400,400,400,400,400,378,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,379,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,380,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,381,400
,400,400,400,400,425,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,382,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,383,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,384,400,400,400,400,400,400,400,385
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,386,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,387,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,388,400,400,400,400,400,400,400,400,400,400,400,389,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,390,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,391,400,400,400,400,400,400,400,400,400,400,392
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,393,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,394,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,395,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,396,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,397,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,398,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,399,400,400,400
,400,400,400,400,406,400,400,400,439,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,412,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,454,400,400,400,400,417,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,418,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,419,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,420,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,421,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,422,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,423,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,424,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,426,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,427,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,429,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,430,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,431
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,432,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,433,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,444,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,447,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,448,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,449,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,450,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,451,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,455,400,400,400,400,400,400,400,400,400,400,400,400,400
,456,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400,400
,400,400,400,400,400,400,400,400,400,400,457,400,400,400,400,400
,400
}
;
  


/* END of scanning tables */






/*
 * Source position calculation 
 */

static void smSourcePosition(
     smScContext smThis,
     unsigned char *smAt,
     unsigned char *smEnd)
{
  int crFound = 0;
  if(smThis->smPosContinue<smEnd) {
    if(smThis->smPosContinue>smAt) smAt=smThis->smPosContinue;
    smThis->smNextPosition+=smEnd-smAt;
    for(;smAt<smEnd;smAt++) 
      if(*smAt==10) {
	smThis->smPosLine=smAt;
	smThis->smNextLine++;
      } else if((*smAt==13) && (*(smAt+1)==10)) {
	smThis->smPosLine=++smAt;
	smThis->smNextLine++;
	crFound = 1;
      }

    smThis->smNextColumn=smEnd-smThis->smPosLine-(crFound?1:0);
    smThis->smPosContinue=smEnd;
  }
}

static void smRewindSourcePosition(
     smScContext smThis,
     unsigned char *smAt,
     unsigned char *smEnd)
{
  if(smThis->smPosContinue>smEnd) return;
  smThis->smNextPosition-=smEnd-smAt;
  while(smAt<smEnd--) if(*smEnd==10) smThis->smNextLine--;
  while(smThis->smBegining<smEnd) 
    if(*smEnd==10) {
      smThis->smPosLine=smEnd;
      break; 
    }
    else smEnd--;
  if(smAt<smThis->smPosLine) smThis->smPosLine=smThis->smPosPrevLine;
  smThis->smNextColumn=smAt-smThis->smPosLine;
  smThis->smPosContinue=smAt;
}


/*
 * int smReadBuffer(SMContext smThis)
 *
 * SmThis function reads charcters using the reader into the buffer in a
 * context. The buffer is enlarged if the current buffer is full
 * (smEnd-smText==smSize) or reduced if current buffer is larger than
 * the standard buffer size and the token may fit the standard buffer
 * (smEnd-smText<smTokenSize AND smSize>smTokenSize). The function
 * returns the number of characters read into the buffer.
 *
 */

static int smReadBuffer(smScContext smThis)
{
  long length;
  int size;
  long mod;

  if(smThis->smBegining!=smThis->smText) {
    /* Move data to beginning of buffer */
    length=smThis->smEnd-smThis->smText;
    memcpy((void *)smThis->smBegining,(void *)smThis->smText,(size_t)length);
    if(length<1024 && smThis->smSize>1024) {
      /* Reduce buffer size */
      smThis->smSize=1024;
      smThis->smBegining=(unsigned char *)realloc(smThis->smBegining,(size_t)1024+1);
    }
  }
  else if(smThis->smBegining+smThis->smSize==smThis->smEnd) {
    /* Try to enlarge buffer */
    if(smThis->smSize==524288) {
      /* Cut Buffer */
      smSourcePosition(smThis,smThis->smText,smThis->smEnd-1024);
      memcpy((void *)smThis->smBegining,(void *)(smThis->smEnd-1024),(size_t)1024);
      mod=smThis->smEnd-smThis->smBegining-1024;
      smThis->smContinue-=mod;
      smThis->smEnd-=mod;
      smThis->smPosPrevLine-=mod;
      smThis->smPosLine-=mod;
      smThis->smPosContinue-=mod;
      smThis->smBufferOverflow+=mod;
    }
    else {
      unsigned char *begining = smThis->smBegining;
      size=smThis->smSize*1.5;
      if(size>524288) size=524288;
      /* Enlarge buffer */
      smThis->smBegining=(unsigned char *)realloc(smThis->smBegining,(size_t)size+1);
      if(smThis->smBegining==NULL) {
	/* Cut Buffer */
	smThis->smBegining = begining;	/* Restore to original buffer */
	smSourcePosition(smThis,smThis->smText,smThis->smEnd-1024);
	memcpy((void *)smThis->smBegining, (void *)(smThis->smEnd-1024), (size_t)1024);
	mod=smThis->smEnd-smThis->smBegining-1024;
	smThis->smContinue-=mod;
	smThis->smEnd-=mod;
	smThis->smPosPrevLine-=mod;
	smThis->smPosLine-=mod;
	smThis->smPosContinue-=mod;
        smThis->smBufferOverflow+=mod;
      }
      else
	smThis->smSize=size;
    }
  }
  if(smThis->smBegining!=smThis->smText) {
    mod=smThis->smText-smThis->smBegining;
    smThis->smContinue-=mod;
    smThis->smEnd-=mod;
    smThis->smPosPrevLine-=mod;
    smThis->smPosLine-=mod;
    smThis->smPosContinue-=mod;
    smThis->smText-=mod;
  }
  length=smThis->smSize-(smThis->smEnd-smThis->smBegining);
  length=smScReader(smThis,smThis->smEnd,(unsigned int)length);
  if(length<0) return length;
  smThis->smEnd+=length;
  return length;
}

/*
 * SMContext SMNew( smScScanner scanner )
 *
 * Create a new context.
 *
 */

smScContext smScNew(smScScanner smScanner)
{
  smScContext smThis;

  smThis=(smScContext)malloc((size_t)sizeof(smScContextItem));
  if(smThis==NULL) {
    return NULL;
  }
  smThis->smBegining=(unsigned char *)malloc((size_t)1024+1);
  if(smThis->smBegining==NULL) {
    free((char *)smThis);
    return NULL;
  }
  smThis->smSize=1024;
  smThis->smContinue=smThis->smBegining;
  smThis->smEnd=smThis->smBegining;
  smThis->smPosPrevLine=smThis->smBegining-1;
  smThis->smPosLine=smThis->smBegining-1;
  smThis->smPosContinue=smThis->smBegining;
  smThis->smText=smThis->smBegining;
  
  smThis->smLength=0;
  smThis->smNextLine=1;
  smThis->smNextColumn=1;
  smThis->smNextPosition=0;
  smThis->smLine=1;
  smThis->smColumn=1;
  smThis->smPosition=0;
  smThis->smScanner=smScanner;
  smThis->smBegining[0]=0;
  return smThis;
}

/*
 * void SMDelete( SMContext smThis )
 *
 * Destroy a context and associated buffer.
 *
 */

void smScDelete(smScContext smThis)
{
  free((char *)smThis->smBegining);
  free((char *)smThis);
}

/*
 * int SMSkip( SMContext smThis, int smLength )
 *
 * Enlarge/reduce the current token in a context with length characters.
 * If length is less than zero reduce the token, if length is greater
 * than zero enlarge the token.
 *
 */

int smScSkip(
     smScContext smThis,
     int smLength)
{
  int empty;

  if(smLength>0) {
    empty=smThis->smEnd-smThis->smContinue;
    if(empty<smLength) {
      empty=smReadBuffer(smThis);
      if(empty<0) return empty;
      empty=smThis->smEnd-smThis->smContinue;
      if(empty<smLength) smLength=empty;
    }
    smSourcePosition(smThis,smThis->smContinue,smThis->smContinue+smLength);
    smThis->smContinue+=smLength;
    smThis->smLength+=smLength;
  }
  else if(smLength<0) {
    smLength= -smLength;
    if(smLength>smThis->smLength) smLength=smThis->smLength;
    smRewindSourcePosition(smThis,smThis->smContinue-smLength,smThis->smContinue);
    smThis->smContinue-=smLength;
    smThis->smLength-=smLength;
    }
  return smLength;
}

int smScModify(
     smScContext smThis,
     unsigned char *smBuffer,
     int smLength)
{
  if(smLength<0) {
/* This code is identical to smSkip but no source position is rewinded */
    smLength= -smLength;
    if(smLength>smThis->smLength) smLength=smThis->smLength;
    smThis->smContinue-=smLength;
    smThis->smLength-=smLength;
/***********************************************************************/
    memcpy((void *)smThis->smContinue,(void *)smBuffer,(size_t)smLength);
    return smLength;
  }
  else if(smLength>0) {
    int length1;
    int length2;
    
    for(length2=smLength;(length1=smScSkip(smThis,length2));length2-=length1) {
      if(length1<0) return length1;
      memcpy((void *)(smThis->smContinue-length1),(void *)smBuffer,(size_t)length1);
      smBuffer+=length1;
    }
    return smLength-length2;
  }
  return smLength;
}

int smScCopy(
     smScContext smThis,
     unsigned char *smBuffer,
     unsigned int smFrom,
     unsigned int smTo)
{
  if(smFrom>smThis->smLength) smFrom=smThis->smLength;
  if(smTo>smThis->smLength) smTo=smThis->smLength;
  memcpy((void *)smBuffer,(void *)(smThis->smText+smFrom),(size_t)smTo-smFrom);
  return smTo-smFrom;
}

int smScMapCopy(
     smScContext smThis,
     unsigned char *smBuffer,
     unsigned int smFrom,
     unsigned int smTo)
{
  int n;
  int len;
  unsigned char *at;

  if(smFrom>smThis->smLength) smFrom=smThis->smLength;
  if(smTo>smThis->smLength) smTo=smThis->smLength;
  len=0;
  for(n=smFrom,at=smThis->smText+smFrom;n<smTo;n++) {
*smBuffer++=smMap[*at++];
    len++;
  }
  return len;
}

void smScScrScanner(
     smScScanner smScanner,
     int smOnOff)
{
}

void smScScrToken(
     smScScanner smScanner,
     int smCode,
     int smOnOff)
{
}

void smScScrRule(
     smScScanner smScanner,
     int smCode,
     int smOnOff)
{
}

int smScan(
     smScContext smThis,
     Token *smToken)
{
  unsigned char *at;
  unsigned char *end;
  unsigned char *rew_at;
  unsigned char ch;
  int state;
  int rew_state;
  int code;

  do {				/* Skip loop */
    smThis->smLine=smThis->smNextLine;
    smThis->smColumn=smThis->smNextColumn;
    smThis->smPosition=smThis->smNextPosition;
    end=(smThis->smEnd);
    smThis->smText=smThis->smContinue;
    smThis->smBufferOverflow=0;
    smToken->srcp.line=smThis->smNextLine;
    smToken->srcp.col=smThis->smNextColumn;
    smThis->smPosPrevLine=smThis->smPosLine;
    rew_at=smThis->smText;
    do {			/* Continue loop */
      rew_state=461;
      rew_at++;
      at=(smThis->smContinue);
      state=smScanner[smThis->smScanner];
      for (;;) {
	if(at==end) {
	  int mod;
	  
	  if(state>=461) state-=461+1;
	  smThis->smContinue=end;
	  mod=smReadBuffer(smThis);
	  if(mod<0) return mod;
	  rew_at-=end-smThis->smContinue;
	  at=smThis->smContinue;
	  end=smThis->smEnd;
          if(at==end) 
	    break;
        }
	  ch = *at++;
{
  int smERRindex;

  
  
  
  smERRindex=smDFAerrRow[state]*20+smDFAerrCol[ch];
  
  if(smDFAerr[smERRindex>>3] & (0x80>>(smERRindex&0x7))) 
    state=461;
  else {
  
    if(smDFAdetRow[state]<smDFAdetCol[ch])
   state=smDFArowVal[state];
    else if(smDFAdetRow[state]>smDFAdetCol[ch])
    state=smDFAcolVal[ch];
    else
  
  
      state=smDFAval[smDFArowVal[state]+smDFAcolVal[ch]];
  
  }
}
	  if(state>=461) break;
	  if(smAccept[state]>0) {
	    rew_state=state;
	    rew_at=at;
	  }
      }
      if(rew_state==461) {
        if(rew_at>end) {
  	  code=smEOTCode[smThis->smScanner];
	  rew_at=end;
        }
        else
	  code=smUnknownCode[smThis->smScanner];
      }	
      else
	code=smAccept[rew_state]-1;	
      smThis->smContinue=rew_at;
      smThis->smLength=smThis->smContinue-smThis->smText;
      smSourcePosition(smThis,smThis->smText,smThis->smContinue);
      smToken->code=smTokenCode[code]-1;
      code=smScAction(smThis,code,smToken);
    } while(code<-1);
    smToken->code=code;
    code=smScPostHook(smThis,smToken);
  } while(code<0);
  return smToken->code=code;
}
