
#ifndef sound_interface_h_INCLUDED
#define sound_interface_h_INCLUDED

#include "../fizmo/types.h"

// volume: 1-8, 8 being loudest
// repeats: 1-254, 255 means forever
// routine: set "start_interrupt_routine" to (routine) when sound
//    finishes (00 for don't call anything).

struct z_sound_interface
{
  void (*init_sound)();
  void (*close_sound)();
  void (*prepare_sound)(int sound_nr, int volume, int repeats);
  void (*play_sound)(int sound_nr, int volume, int repeats, uint16_t routine);
  void (*stop_sound)(int sound_nr);
  void (*finish_sound)(int sound_nr);
  void (*keyboard_input_has_occurred)();
  uint16_t (*get_next_sound_end_routine)();
};

#endif /* sound_interface_h_INCLUDED */

