!vim: set sw=4 sts=4
! config.inf - compile-time options for ZedFunge

! Memory constants - as they're set, they push the limits of the Z-Machine's
! 64K limit. Play around with them if you're running out of output/stack space,
! or want a bigger playfield, or more IPs, or a greater block-depth limit, or
! more long board cells.

! Initial board dimensions - change at run-time with F7
Constant MAX_LINE_WIDTH=80;           
Constant MAX_PAGE_HEIGHT=25;        
Constant MAX_SPACE_THICKNESS=7;

Constant output_memory_size=10000;
Array output -> output_memory_size;  !  Funge programme output

Constant stack_memory_size = 2000; ! Note we use 4 bytes per cell of the stack, so this is only 500 cells

! If you feel like writing some dynamic memory handling for the IPs, so they
! share a single stack, that would be very neat indeed.

! Extend these in the obvious way if you want more/fewer IPs
Constant NUM_IPS=5;
Global stack;
Array stack0 -> stack_memory_size;
Array stack1 -> stack_memory_size; 
Array stack2 -> stack_memory_size; 
Array stack3 -> stack_memory_size; 
Array stack4 -> stack_memory_size; 
Array stacks --> stack0 stack1 stack2 stack3 stack4;

! sim.
Constant MAX_BLOCKS = 5;
Global blocks;
Array blocks0 --> MAX_BLOCKS; 
Array blocks1 --> MAX_BLOCKS; 
Array blocks2 --> MAX_BLOCKS; 
Array blocks3 --> MAX_BLOCKS; 
Array blocks4 --> MAX_BLOCKS; 
Array blockses --> blocks0 blocks1 blocks2 blocks3 blocks4;

Constant LONG_BOARD_CELLS = 25;

