/*
 *
 * ZEPPELIN ADVENTURE
 * (c) by Robin Johnson - robindouglasjohnson@gmail.com - @rdouglasjohnson
 * Copy and distribute freely in unmodified form, preserving this licence.
 * No commercial use without permission of the author.
 *
 */

// todo: check indoors: true, is present on all indoor rooms!
 
 
Game = {

	id: "ZEP",
	title: "Zeppelin Adventure",
	author: "Robin Johnson",
	
	hero_location: 'bridge',
	
	score: 0,
	max_score: 13,
	
	alignment: 0,
	
	score_percentage: false,
	
	game_over: false,
	turn_number: 0,
	
	intro: "Piloting a one-person tea-zeppelin on Mars is a lonely job. Fortunately, you've just got this one run to finish and you\'re due \
	for a holiday. Let's hope nothing adventurous happens!\n\n",
	
	inventory: [],
	held: "",
	
	rooms: {},
	things: {},
	vars: {
		fatigue: 0,
	},
	fuses: {
	},

	options: {},

	before: [],	
	always: [],
	
	initialise: function() {
		set_fuse('pterodactyls_appear', 6);
		set_fuse('vortex_appears', 12);
		
		shuffle_engine_parts();
	},
	
	// startingMusic: 'saxloopmusic',
};
On_hold = [];
Rules = [];
Longdesc = {};
// Longroomdesc = {};
// currentMusic = Game.startingMusic;

male_pronouns =   ["he",   "him",  "his",   "his",    "himself"];
female_pronouns = ["she",  "her",  "her",   "hers",   "herself"];
neuter_pronouns = ["it",   "it",   "its",   "its",    "itself" ];
plural_pronouns = ["they", "them", "their", "theirs", "themselves"];
nb_pronouns =     ["they", "them", "their", "theirs", "themself"];

Game.always.push(
	function() {
		Game.turn_number++;
		atmospheric_message();
		// do_room_music();
	}
);

function atmospheric_message() {

	return;
	
	var loc = hero_location();

	if(loc.atmosphere && !pick(4)) {
		say(pickOne(loc.atmosphere));
		return
	}
	
	if(!pick(4)) {
		
		var messages = [];
		
		// populate messages
		if(!Game.vars.through_vortex) {
			messages.push("The zeppelin sways slightly.");
			messages.push("The zeppelin rocks slightly.");
		}
		
		if(messages.length) {	
			say(pickOne(messages));
		}
		
	}
	
	
}


Game.fuses.pterodactyls_appear = {
	explode: function() {
		if(!Game.hero_blind) {
			say('\nSuddenly your zeppelin gets attacked by a swarm of vicious pterodactyls!');
		} else {
			say('\nSuddenly you hear a chorus of vicious squawks, and the flapping of enormous wings.');
		}
		put('pterodactyls', Game.hero_location);
		Game.vars.pterodactyls = true;
	}
};

Game.things.pterodactyls = {
	is_plural: true,
	icon: "pterodactyls.png",
	description: "fierce pterodactyls",
};
Longdesc.pterodactyls = "A flock of slender, graceful, and entirely unfriendly aviasaurs, \
	ranging in wingspan from a few metres to a few tens of metres. Mainly quetzalcoatli, \
	but there might be a few hatzegopteryxes in there.";

Game.always.push(function() {
	do_pterodactyls_and_vortex();
});

function do_pterodactyls_and_vortex() {
	if(Game.vars.pterodactyls) {
		put('pterodactyls', Game.hero_location); // only zeppelin
		if(!Game.hero_blind) {
			say(pickOne([
				"A pterodactyl swoops right past you.",
				"A pterodactyl flies within inches of the rail.",
				"A pterodactyl nearly crashes into the zeppelin.",
				"A pterodactyl takes a snap at the balloon.",
			]));
		}
	}
	if(Game.vars.vortex) {
		put('vortex', Game.hero_location);
	} else {
		hide('vortex');
	}
	if(Game.vars.return_vortex && !Game.vars.through_purple_vortex) {
		put('return_vortex', Game.hero_location);
	} else {
		hide('return_vortex');
	}
	if(Game.vars.purple_vortex) {
		put('purple_vortex', Game.hero_location);
	} else {
		hide('purple_vortex');
	}
};

Game.fuses.vortex_appears = {
	explode: function() {
		say_if_lit('\nAn orange swirly thing appears right in your flight path!');
		put('vortex', Game.hero_location);
		Game.vars.vortex = true;
		set_fuse('go_through_vortex', 8);
	},
};
Game.things.vortex = {
	icon: "vortex.png",
	name: "orange swirly thing",
	description: "orange swirly thing",
};
Longdesc.vortex = "A glowing, circular vortex in all the colours of flame hangs above the landscape, spinning clockwise then anticlockwise, \
	shifting so much that it's hard to tell how big or how close it is. Not a common Martian meteorological phenomenon, as far as \
	you're aware.";

Game.fuses.go_through_vortex = {
	burn: function() {
		if(Game.fuses.go_through_vortex.time == 3) {
			say_if_lit('The orange swirly thing is getting closer...');
		} else if(Game.fuses.go_through_vortex.time == 2) {
			say_if_lit('The orange swirly thing is sucking you in!', 'It feels as if the zeppelin is being sucked into something...');
		} else if(Game.fuses.go_through_vortex.time == 1) {
			say_if_lit('The orange swirly thing is sucking you in... you\'re about to hit it!', 'The zeppelin shakes violently!');
		};
	},
	explode: function() {
		say_if_lit("\nThe zeppelin passes through the orange swirly thing with a loud 'pop'. I don't think you\'re on Mars any more.",
			"There is a loud pop. I think the zeppelin passed through some kind of vortex.");
		if(Game.hero_location=='stern') {
			say_if_lit("The engine explodes with a savage BOOM, sending components flying over the sides. Oh dear. You're not \
				an expert mechanic, but you're pretty sure that isn't supposed to happen.",
				"You hear a savage BOOM nearby. That can't be good.");
		} else {
			var direction =
				(Game.hero_location=='bridge' ? 'behind you' :
				Game.hero_location=='rigging' ? 'below you' :
				(console.log('Not on zeppelin when engine exploded?'), 'somewhere') );
			say_if_lit("You hear a savage BOOM from " + direction + ", and some objects fly over the sides. Oh dear. They looked \
				like bits of the zeppelin's engine. You're not an expert mechanic, but you're pretty sure that isn't supposed \
				to happen.",
				"You hear a savage BOOM nearby. That can't be good.");
		}
		say_if_lit("The craft seems badly damaged. If you can't find a way to land, you\'re likely to crash.",
			"The craft is swaying unhappily. If you can't find a way to land safely, you\'re likely to crash.");
		say_if_lit("At least the pterodactyls have gone.", "At least the squawking has stopped.");
		hide('pterodactyls'); delete Game.vars.pterodactyls;
		hide('vortex'); delete Game.vars.vortex;
		set_fuse('zeppelin_crashes', 12);
		//deactivate_verb('controls', 'steer');
		Game.vars.through_vortex = true;
		Game.vars.zeppelin_damaged = true;
	},
}

Game.fuses.zeppelin_crashes = {
	burn: function() {
		var t = Game.fuses.zeppelin_crashes.time;
		if(t==2) {
			say_if_lit("The zeppelin is very close to the ground now.")
		} else if(t == 1) {
			say_if_lit("The zeppelin picks up speed. It's about to crash!", "The zeppelin is moving very fast now.");
		} else {
			say(pickOne([
				"\nThe zeppelin picks up speed.",
				"\nThe nose of the zeppelin tilts downwards.",
				"\nThe zeppelin veers wildly from side to side.",
				"\nThe zeppelin rocks violently.",
				"\nThe zeppelin pitches violently.",
			]));
		}
	},
	explode: function() {
		die('\nCRAAAAASH!!');
	}
}

Game.fuses.zeppelin_lands = {
	burn: function() {
		var t = Game.fuses.zeppelin_lands.time;
		if(status_of('balloon')!='deflating') {
			say('The balloon starts to deflate with a hissing noise. The zeppelin starts to lose altitude and, \
			as the balloon sags and becomes less aerodynamic, slows down.');
			Game.things.balloon.status = 'deflating';
			Game.vars.started_deflating = true;
		} else {
			say_if_lit(( Game.hero_location != 'rigging' ? 'Above you, t' : 'T' ) + 'he balloon continues to deflate with a hissing noise.', 'You can hear a hissing noise.');
		}
		if(t % 2 == 0) {
			say('The zeppelin descends gently.')
		}
	},
	explode: function() {
		say_if_lit('\nYou touch down with a hard bump. The sandy ground gives way, and the zeppelin falls to the bottom of a deep crater.',
		'You feel the zeppelin touch down with a hard bump. Then something crumbles, and the craft falls even further.');
		
		Game.things.balloon.status = 'deflated'; // description = "hydrogen balloon (deflated)";
		
		/*
		if(carried('telescope')) {
			say('The telescope falls out of your hands and smashes.');
			put('telescope', Game.hero_location);
		} else if(in_scope('telescope')) {
			say('The telescope smashes.');
		} else {
			say('You hear a smashing noise, like the sound of an expensive telescope breaking.');
		}
		Game.things.telescope.smashed = true;
		Game.things.telescope.description = "telescope (smashed)";
		 */
		
		Game.vars.zeppelin_landed = true;
		delete Game.rooms.bridge.is_height;
		delete Game.rooms.stern.is_height;
		Game.rooms.bridge.description = "You\'re on the bridge of your damaged zeppelin.";
		Game.rooms.stern.description = "You\'re on the stern of your damaged zeppelin.";
		Game.rooms.rigging.description = "You\'re in the rigging of your damaged zeppelin.";
		deactivate_verb('controls', 'steer');
		activate_verb('controls', 'launch');
		Game.rooms.bridge.directions.out = 'crater';
	}
}


Game.rooms.bridge = {
	description: "You\'re on the bridge of your open-top zeppelin.",
	directions: {
		aft: "stern",
	},
	is_height: true,
	is_zeppelin: true,
	parachute_jump: function() {
		jump_from_zeppelin();
	}
};
// Longroomdesc.bridge = "You're on the bridge of your zeppelin, an old open-top model with a creaky wooden hull.";
// let's keep the // Longroomdescs short.
// "Cool air streams around you as the craft chugs forward.";

Game.things.controls = {
	icon: "controls.png",
	location: "bridge",
	is_plural: true,
	active_verbs: ["steer"],
};
Longdesc.controls = "The usual &ndash; wooden steering wheel, altimeter, old-fashioned buoyancy shift.";

Game.things.cannon = {
	icon: "harpoon_gun.png",
	description: "harpoon cannon",
	status: "not loaded",
	location: "bridge",
};
CANNON_DESC = "A spring-loaded metal cylinder fixed immovably to the fore rail. This is what the East Mars Company \
	gives you to protect yourself against all enemies considerate enough to position themselves \
	directly in front of you, about 45 degrees up, and stay still long enough for you to get the thing loaded.";
CANNON_JOKE = " Fortunately there aren't many pirates interested in robbing tea-zeppelins. Gold-and-rum-zeppelins are \
different altogether.";
Longdesc.cannon = CANNON_DESC + CANNON_JOKE;
// only tell the joke once
add_rule('after', 'examine', 'cannon', function() {
	Longdesc.cannon = CANNON_DESC;
});

add_rule('before', 'load', 'cannon', function() {
	if(!held('harpoon')) {
		console.log('Tried to load cannon while not holding harpoon??');
	}
	if(Game.things.cannon.loaded) {
		console.log('Tried to load cannon that was already loaded??');
	}
	
	say("You put the harpoon in the cannon and push it down till it clicks.");
	
	take_away('harpoon');
	hide('rope');
	Game.things.cannon.loaded = true;
	Game.things.cannon.status = 'loaded'; //description = "harpoon cannon (loaded)"
	
	return true;
});
Game.always.push(function() {
	set_active('cannon', 'fire', Game.things.cannon.loaded);
});
add_rule('before', 'fire', 'cannon', function() {
	
	Game.things.cannon.loaded = false;
	deactivate_verb('cannon', 'fire');
	Game.things.cannon.status = 'not loaded'; //description = "harpoon cannon (not loaded)";

	if(in_scope('giant_pterodactyl')) {
		say('The harpoon arcs... and hits! The rope pulls tight, and the giant pterodactyl makes an enraged gurgling nose.');
		Game.things.giant_pterodactyl.status = 'harpooned';
		Game.things.rope.status = 'connected to pterodactyl';
		if(in_scope('elf')) {
			say('The elf\'s jaw drops in sudden realisation. "Of course! Now I know why the pterodactyls happen!"');
			Game.things.elf.knows_about_pterodactyls = true;
		}
		return true;
	}
	
	if(Game.vars.zeppelin_landed && !Game.things.zeppelin.relaunched) {
		say("TWANG! The harpoon arcs... hits the lip of the crater, and sticks. The rope pulls tight.");
		put('rope', 'bridge');
		Game.things.rope.status = 'leading up';
		deactivate_verb('rope', 'pull');
		activate_verb('rope', 'climb');
		put('harpoon', 'edge_of_crater');
		Game.things.harpoon.status = 'stuck in ground'; //description = "harpoon (stuck in ground)";
		Game.things.rope.climb_to = "edge_of_crater";
		return true;
	}
	
	if(in_scope('pterodactyls')) {
		say('<span class="prompt">(at pterodactyls)</span>');
	} else if(in_scope('giant_pterodactyl')) {
		say('<span class="prompt">(at pterodactyl)</span>');
	}
	say('TWANG!!!');
	
	if(in_scope('pterodactyls')) {
		say('The harpoon arcs... and misses. The rope pulls tight, then goes slack.');
	} else {
		say("The harpoon arcs... the rope pulls tight, then goes slack.");
	}
	put('rope', Game.hero_location);
	Game.things.rope.status = 'dangling over side'; //description = "rope (dangling over side)";
	
	return true;
});

Game.fuses.giant_pterodactyl = {
	burn: function() {
		
		if(Game.things.giant_pterodactyl.status=='harpooned') {
			return;
		}
		
		var t = Game.fuses.giant_pterodactyl.time
		if(t>6) {
			say(pickOne([
				"The giant pterodactyl rolls a pool-ball eye in your direction.",
				"The giant pterodactyl circles to face you.",
				"The giant pterodactyl feints a lunge towards the zeppelin.",
				"The giant pterodactyl snaps its beak towards you.",
			]));
		}
		else if(t > 2) {
			say(pickOne([
				"The giant pterodactyl swoops around the zeppelin in a menacing ellipse.",
				"The giant pterodactyl lunges, missing the rail of the zeppelin by an inch or two.",
				"The giant pterodactyl spreads its wings wide.",
				"The giant pterodactyl tosses its head back and produces a deafening, primeval roar.",
			]));
		} else if(t==2) {
			"The giant pterodactyl flies very close to you.";
		} else if(t==1) {
			say("The giant pterodactyl lunges straight for you, jaws agape...");
		}
	},
	explode: function() {
		die("The giant pterodactyl's enormous beak closes around you.");
	},
}

Game.things.telescope = {
	icon: "telescope.png",
	description: "telescope",
	active_when_carried: ["look_through"],
	portable: true,
	location: "bridge",
};
Longdesc.telescope = "A heavy brass tube with a lens at each end."

add_rule('before', 'look_through', 'telescope', function() {
	if(Game.things.telescope.smashed) {
		say("It's smashed.");
		return true;
	}
	
	if(Game.hero_blind) {
		say("It's an old telescope, not designed to work when you've got a box on your head.");
		return true;
	}
	
	if(hero_location().is_zeppelin) {
		if(!Game.vars.through_vortex) {
			say_if_lit('In the distance you see your destination, Olympus City.');
		} else if(Game.vars.zeppelin_landed) {
			say('You see the inside of a crater.');
		} else if(!Game.vars.zeppelin_fixed || !Game.vars.revealed_wall) {
			say('You see an unfamiliar desert landscape.');
		} else if(Game.vars.revealed_wall && Game.vars.zeppelin_latitude > -1){
			say('The desert stretches away to the east. To the west, you see the buildings of the Robot Free State, \
				and beyond that, the charred wasteland of the Robot-Free State.');
		} else if(Game.vars.revealed_wall && Game.vars.zeppelin_latitude == 1 && location_of('elf')=='roof') {
			say('The desert stretches away to the east. Below you, you see the buildings of the Robot Free State. \
				A figure is waving at you from the roof of the citadel.');
			bring('citadel_roof');
		}
	} else /* todo: handle if you're high up, or somewhere with a view */ {
		say('You don\'t have a good view from here.');
	}
	return true;
});


Game.rooms.stern = {
	is_height: true,
	description: "You\'re on the stern of your zeppelin.",
	directions: {
		fore: "bridge",
	},
	is_zeppelin: true,
	parachute_jump: function() {
		jump_from_zeppelin();
	}
};
// Longroomdesc.stern = "You\'re on the stern of your zeppelin, where the cargo is stored.",
Game.things.engine = {
	icon: "engine.png",
	location: "stern",
	description: "engine",
	//active_verbs: ["examine"],
};
add_rule('before', 'examine', 'engine', function() {
	if(!Game.vars.through_vortex) {
		Longdesc.engine = "It's an old model, and overdue for a service, but it has all its bits and it's chugging along happily.";
	} else if(Game.score<=12) {
		Longdesc.engine = "The engine is trashed, missing <span class=\"treasure\">" + (13 - Game.score).toString() + 
		" essential part"
		+ (Game.score==12?'':'s') + "</span>. The craft won't fly properly till " +
		(Game.score==12 ? "it's" : "they're all") +
		" back in there.";
	} else {
		say("The engine has all its parts now. It looks a bit ad-hoc, but it seems to be working. For now.");
	}
	return false;
});
Game.always.push(function() {
	do_engine_repair();
});
On_hold.push(function() {
	do_engine_repair();
});
function do_engine_repair() {
	if(!Game.vars.zeppelin_fixed) {
		for(var thing in Game.things) {
			set_active(thing, 'put_in_engine', Game.hero_location=='stern' && held(thing) && Game.things[thing].is_engine_part);
		}
	}
};
add_rule('before', 'put_in_engine', 'engine_part_8', function() {
	if(in_scope('old_man')) {
		say("Before you can clip " + the_thing('engine_part_8') + " into the engine, \
		the old man snatches it from your hands.");
		come_along_gerald();
		return true;
	} else if(path_from(location_of('old_man'), Game.hero_location)) {
		say("Before you can clip " + the_thing('engine_part_8') + " into the engine, \
		the old man runs up to you and snatches it from your hands.");
		come_along_gerald();
		return true;
	} else {
		return false;
	}
});

for(var i=1; i<=13; ++i) {
	add_rule('after', 'put_in_engine', 'engine_part_' + i, function() {
		check_engine();
	});
}
function check_engine() {
	for(var i=1; i<=13; ++i) {
		if(!Game.things['engine_part_' + i].in_engine) {
			return;
		}
	}
	
	// all the parts are in the engine!
	say("\nThat's all the parts in. After a few seconds of tentative ticking, the engine starts up in neutral mode.");
	say("You hear a humming above you as the hydrogen balloon's automatic skin repair kicks in. Now to get home...");
	set_status('zeppelin', 'repaired');
	Game.vars.zeppelin_fixed = true;
}

function launch_zeppelin() {
	if(!Game.vars.zeppelin_fixed) {
		say("The zeppelin won't launch until the engine is repaired.");
		return;
	}
	
	say('You release the buoyancy shift.');
	
	if(status_of('balloon')=='deflated') {
		say('With a loud "FOOMF", the hydrogen balloon insta-inflates above you.');
		clear_status('balloon');
	}
	
	if(Game.vars.landed_on_roof) {
		delete Game.vars.landed_on_roof;
		bring('citadel_roof');
	}
	
	// the zeppelin must be free of portable objects to be able to launch.
	// This is mainly to stop the combinatorial explosion arising from taking the parachute with you!
	if(!check_zeppelin_weight()) {
		say('The zeppelin starts to rise... gets about a foot up, makes a strained noise, \
			and falls back down with a sputter.');
		return;
	}
	
	if(location_of('harpoon')=='edge_of_crater') {
		say('The zeppelin starts to rise... and gets about fifty feet up before you feel a sharp yank. The zeppelin \
		falls back down with a sputter.');
		return;
	}
	
	say('The zeppelin starts to rise... and makes it to a cruising altitude.');
	Game.rooms.bridge.is_height = true;
	Game.rooms.stern.is_height = true;
	Game.things.zeppelin.relaunched = true;
	if(Game.things.harpoon.location) {
		if(!Game.rooms[location_of('harpoon')].is_zeppelin) {
			put('rope', 'bridge');
			hide('harpoon');
			Game.things.rope.status='dangling over side';
			activate_verb('rope', 'pull');
			deactivate_verb('rope', 'climb');
		}
	}
	
	delete Game.rooms.bridge.directions.out;
	
	deactivate_verb('controls', 'launch');
	activate_verb('controls', 'fly_west');
	activate_verb('controls', 'fly_east');
	
	if(!Game.vars.return_vortex)	{
		say('\nYou can make out a familiar-looking orange swirly thing some distance to the east.');
		bring('return_vortex');
		Game.vars.return_vortex = true;
		Game.things.return_vortex.status = "to east";
	}
}

function check_zeppelin_weight() {
	for(var i in Game.things) {
		if(i != 'harpoon' &&
			Game.things[i].portable && (
				carried(i) || (
					Game.rooms[location_of(i)] &&
					Game.rooms[location_of(i)].is_zeppelin
				)
			)
		) {
			return false;
		}
	}
	return true;
}

add_rule('before', 'jump', 'parachute', function() {
	if(Game.vars.zeppelin_fixed && Game.hero_location!='rigging') {
		say("You didn't go to all that trouble to fix the zeppelin just so you could bail out.");
		return true;
	}
	
	return false;
});
Game.vars.zeppelin_latitude = 0;
Game.things.return_vortex = {
	name: "orange swirly thing",
	description: "orange swirly thing",
}
Longdesc.return_vortex = "A glowing, circular vortex in all the colours of flame hangs above the landscape, spinning \
	clockwise then anticlockwise, shifting so much that it's hard to tell how big or how close it is.";
Game.things.purple_vortex = {
	name: "purple swirly thing",
	description: "purple swirly thing",
}
Longdesc.purple_vortex = "A glowing, circular vortex in vibrant violets, magentas and indigos hangs above the landscape, \
spinning clockwise then anticlockwise, shifting so much that it's hard to tell how big or how close it is.";
add_rule('before', 'fly_west', 'controls', function() {
	if(Game.vars.through_purple_vortex && Game.things.giant_pterodactyl.status=='harpooned') {
		say('The zeppelin is tethered to the purple swirly thing by a tight rope. You\'re not flying anywhere.');
		return true;
	}

	say("You steer the wheel towards the western horizon and pull the momentumator.");
	--Game.vars.zeppelin_latitude;
	if(Game.vars.zeppelin_latitude==-1 && Game.vars.revealed_wall) {
		say("You're flying over the city-states now.");
	}
	else if(Game.vars.zeppelin_latitude==-2 && Game.vars.purple_vortex) {
		say_if_lit("You're very close to the purple swirly thing now, and can feel the craft being pulled towards it. \
			 Any closer and you're going through.", "You can feel the craft being pulled toward the west.");
	} else if(Game.vars.purple_vortex && Game.vars.zeppelin_latitude==-3) {
		go_through_purple_vortex();
	}
	return true;
});
Game.always.push(function() {
	do_citadel_roof();
});
function do_citadel_roof() {
	if(Game.vars.zeppelin_fixed && Game.vars.zeppelin_latitude==-1 && Game.vars.revealed_wall && !Game.vars.landed_on_roof) {
		bring('citadel_roof');
		bring('robot_free_state');
		bring('robot_hyphen_free_state');
	} else {
		hide('citadel_roof');
		hide('robot_free_state');
		hide('robot_hyphen_free_state');
	}
}
Game.things.robot_free_state = {
	name: 'Robot Free State',
	description: "Robot Free State",
	indefinite: "the Robot Free State",
};
Game.things.robot_hyphen_free_state = {
	name: 'Robot-Free State',
	description: "Robot-Free State",
	indefinite: "the Robot-Free State",
};
add_rule('before', 'examine', 'robot_free_state', function() {
	set_city_longdescs();
});
add_rule('before', 'examine', 'robot_hyphen_free_state', function() {
	set_city_longdescs();
});
function set_city_longdescs() {
	if(!Game.vars.saved_cities && !Game.vars.through_purple_vortex) {
		Longdesc.robot_free_state = "The Robot Free State is a collection of mainly cuboidal buildings, cracks \
			running down their sides and dust and soot visible on the roofs. The citadel stands taller than the other \
			buildings and has a wide, flat roof.";
		Longdesc.robot_hyphen_free_state = "From the air, the full devastation of the Robot-Free State is chillingly \
			apparent. It's nothing more than a black semicircle with a wall round it.";
	} else {
		Longdesc.robot_free_state = "The Robot Free State is a collection of mainly cuboidal buildings, clean and shining \
			in a spectrum of metallic colours. In the streets you can see crowds of robots going about their daily programs.";
		Longdesc.robot_hyphen_free_state = "The Robot-Free State is a bustling city of spires, skyscapers, domed houses \
			and long tenement buildings. In the streets you can see crowds of people going about their business.";
	}
}
add_rule('after', 'examine', 'robot_free_state', function() {
	bring('citadel_roof');
});
Game.things.citadel_roof = {
	name: "citadel roof",
	indefinite: "the citadel roof",
	active_verbs: ["land"],
}
add_rule('before', 'examine', 'citadel_roof', function() {
	Longdesc.citadel_roof = "The roof of the lead citadel is wide and flat. In the centre is a painted circle with a \
		big letter Z in the middle.";
	if(location_of('elf')=='roof') {
		Longdesc.citadel_roof += ' You can just make out a figure standing there, waving at you.';
	}
});
add_rule('before', 'land', 'citadel_roof', function() {
	return land_on_roof();
});
function land_on_roof() {
	
	if(Game.things.giant_pterodactyl.status=='harpooned') {
		say("The zeppelin strains against the pull from the giant pterodactyl. You can't get low enough.");
		return true;
	}
	
	say("You position the zeppelin above the roof and pull the buoyancy shift. It touches down almost softly.");
	Game.vars.landed_on_roof = true;
	Game.rooms.bridge.directions.out = 'roof';
	
	put('zeppelin', 'roof');
	hide('citadel_roof');
	deactivate_verb('controls', 'fly_west');
	deactivate_verb('controls', 'fly_east');
	activate_verb('controls', 'launch');
	
	return true;
}
Game.rooms.roof = {
	description: "You're on the roof of the citadel.",
	is_height: true,
	parachute_jump: function() {
		dont_jump_off_roof();
	},
};
function dont_jump_off_roof() {
	say('That would be a bad idea.');
}
Game.always.push(function() {
	do_roof_and_vortex();
});
function do_roof_and_vortex() {
	if(Game.hero_location=='roof' && location_of('elf')=='roof') {
		say('"Hmmm," says the elf, who has been waiting for you here. She looks critically at your zeppelin. \
		"I thought you were more into biplanes, but it\'ll do." She walks aboard.');
		put('elf', 'bridge');
		Game.things.elf.conversifier = function() {
			return conv_elf_endgame();
		};
	}
	if(Game.hero_location=='bridge' && location_of('elf')=='bridge' && !Game.vars.purple_vortex && !Game.vars.through_purple_vortex) {
		console.log('not through purple vortex');
		say('"Now watch this," says the elf. She pulls a hologrammatic device, something like the remote control for \
			a toy boat, out of her robes and presses a button. A purple swirly thing appears above the western horizon.');
		say('"It worked!" says the elf. "Take us through."');
		bring('purple_vortex');
		Game.vars.purple_vortex = true;
		Game.things.purple_vortex.status = 'to west';
		bring('giant_pterodactyl');
		set_fuse('giant_pterodactyl', 12)
		say('A giant pterodactyl also appears in the sky. The elf frowns. "Why does that always happen?"');
	}

}
Game.always.push(function() {
	if(Game.vars.giant_pterodactyl && !Game.vars.through_purple_vortex) {
		bring('giant_pterodactyl');
	}
});
Game.things.giant_pterodactyl = {
	name: "pterodactyl",
	description: "giant pterodactyl",
}
add_rule('before', 'examine', 'giant_pterodactyl', function() {
	Longdesc.giant_pterodactyl = 'There\'s only one of them this time, but this one is at least twice as big, \
		and four times as angry, as the biggest of the flock you encountered on the way here.';
	if(Game.things.giant_pterodactyl.status!='harpooned') {
		Longdesc.giant_pterodactyl += " It's hovering in front of the zeppelin, about forty-five degrees up.";
	} else {
		Longdesc.giant_pterodactyl += " There's a harpoon stuck in its hide, which isn't making it any happier.";
	}
});

function pull_pterodactyl() {
	if(!Game.vars.through_purple_vortex) {
		die("You tug on the rope. The harpoon is a well designed one, and doesn't come loose. Nor do you succeed in \
			pulling the pterodactyl towards you, it having several times the mass of your zeppelin. In accord with \
			Newton's laws, the zeppelin careers toward the beast, which turns round and opens its mouth just in time \
			to greet you.", "You have been eaten by a pterodactyl");
	} else {
		if(in_scope('elf')) {
			say('"No!" says the elf. "We need to&nbsp;&ndash;" but she\'s gone.');
			hide('elf');
			if(in_scope('mail_pod')) {
				say('The mail pod vanishes in a minor temporal paradox.');
				hide('mail_pod');
			}
		}
		say("You tug on the rope. The mass at the other end is too great to pull towards you. In accord with \
			Newton's laws, the zeppelin careers towards the purple swirly thing and, with a 'pop', you\'re back through. \
			The purple swirly thing vanishes behind you.");
		delete Game.vars.through_purple_vortex;
		Game.vars.purple_vortex_gone = true;
		Game.vars.purple_vortex = false;
		hide('purple_vortex');
		/* bring('robot_free_state');
		bring('robot_hyphen_free_state');
		*/ bring('return_vortex');
		Game.vars.zeppelin_latitude = -2;
		bring('giant_pterodactyl');
		if(Game.things.giant_pterodactyl.status=='harpooned') {
			Game.things.rope.status = 'connected to pterodactyl';
		}
		if(Game.vars.saved_cities) {
			set_fuse('pterodactyl_vanishes', 2);
		} else {
			set_fuse('giant_pterodactyl', 5);
		}
	}
}
Game.fuses.pterodactyl_vanishes = {
	explode: function() {
		say('As the time-space continuum rights itself, the giant pterodactyl vanishes with a sad "meep". The rope goes \
		slack and the harpoon plummets.');
		Game.vars.giant_pterodactyl = false;
		clear_status('giant_pterodactyl');
		hide('giant_pterodactyl');
		Game.things.rope.status = 'dangling over side';
		activate_verb('rope', 'pull');
	}
}

Game.fuses.maildrop = {
	explode: function() {
		do_maildrop();
	}
}


function do_maildrop() {
	if(!Game.vars.gotmail && Game.vars.through_purple_vortex) {
		say('"There it is!" cries the elf.');
		say("An automatic interplanetary mail pod descends from above you, and lands hard on the deck of your zeppelin, \
			which it apparently wasn't expecting to be there.");
		say('"SPOT ON!" the elf cheers, punching the air. "We intercepted it. Now do me a favour and pop it into redelivery mode, \
			would you? I\'d do it myself, but&nbsp;&ndash;" she waves her hologrammatic fingers apologetically.');
		bring('mail_pod');
		Game.vars.gotmail = true;
	}
}

Game.things.mail_pod = {
	name: "mail pod",
	description: "mail pod with yellow button",
	//portable: true,
	active_verbs: ["push"],
};
Longdesc.mail_pod = 'A spherical pod. On the side is a square yellow button on the front and an LCD display reading: \
	"TO: THE ROBOT FREE STATE".',
add_rule('before', 'examine', 'mail_pod', function() {
	if(Game.things.mail_pod.edited) { // shouldn't actually happen
		Longdesc.mail_pod = 'A spherical pod. On its equator is a square yellow button and an LCD display reading: \
			"TO: THE ROBOT-FREE STATE".';
	}
});

add_rule('before', 'push', 'mail_pod', function() {
	if(Game.things.mail_pod.edited) {
		say("Nothing happens.");
		return;
	}
	
	say('The text on the pod\'s LCD display changes to: "REDELIVERY MODE".');
	var txt = '"Good job," says the elf. "I was afraid you wouldn\'t know how." She smiles. "This is where I leave you. \
		The last task of this hologram is to turn into a virus and correct the punctuation error. Farewell, \
		Dr Noselung.';
	if(Game.things.giant_pterodactyl.status=='harpooned') {
		txt += ' I hope the rest of your trip around the moon goes smoothly.';
		if(Game.things.elf.mentioned_anchor) {
			txt += ' And I\'ll be sure to hack into my own vortex creation program and plant those pterodactyls for you.';
		}
	}
	txt += '"';
	say(txt);
	say('The elf shimmers, shrinks down to a point of glowing light, and drifts into the mail pod through its LCD display. \
		There are a few bleeps, and the text now reads: "REDELIVER TO: THE ROBOT-FREE STATE".');
	say('The mail pod spins, lifts off from the deck, hovers out over the rail of the zeppelin, and continues its downward \
		journey.');
	Game.vars.saved_cities = true;
	
	hide('mail_pod');
	hide('elf');
	
	if(Game.things.giant_pterodactyl.status!='harpooned') {
		stuck_ending();
	}
	return true;
});
function stuck_ending() {
	say("\nAs the time-space continuum rights itself, the purple swirly thing vanishes. This probably wasn\'t the side you \
		were supposed to be on.");
	die("Oh well. It's not like you enjoyed your job. There's a whole world to explore down there, \
		and a good chance it has a future.", "Ending 2 of 3");
}

add_rule('before', 'fly_east', 'controls', function() {
	if(Game.vars.through_purple_vortex && Game.things.giant_pterodactyl.status=='harpooned') {
		say('The zeppelin is tethered to the purple swirly thing by a tight rope. You\'re not flying anywhere.');
		return true;
	}
	
	say("You steer the wheel towards the eastern horizon and pull the momentumator.");

	if(Game.things.giant_pterodactyl.status=='harpooned') {
		say('The mass of the giant pterodactyl stops you going that way. The zeppelin sputters.');
		return true;
	}

	++Game.vars.zeppelin_latitude;
	if(Game.vars.zeppelin_latitude==-1 && Game.vars.revealed_wall) {
		say("You're flying over the city-states now.");
	} else if(Game.vars.zeppelin_latitude==1) {
		say_if_lit("You're very close to the orange swirly thing now, and can feel the craft being pulled towards it. \
			Any closer and you\'re going through.", "You can feel the craft being pulled toward the east.");
	} else if(Game.vars.zeppelin_latitude==2) {
		go_home();
	}
	return true;
});
function go_home() {
	stop_fuse('giant_pterodactyl');
	if(!Game.vars.saved_cities) {

		if(in_scope('elf')) {
			say('The elf looks perplexed. "Where are you going? Not this way, the other&nbsp;&ndash;" but then she\'s gone.');
			hide('elf');
		}
	
		say("There's a 'pop' and you feel a spinning sensation. The " + 
			(Game.vars.revealed_wall ? "cities vanish" : "desert vanishes") + "; the rocky badlands and the pink \
			skies of Mars are back. To the west is Olympus City.");
		die("You\'ve lost the tea. That\'ll be a disciplinary letter.",
			"Ending 1 of 3");
		
	} else {
		
		say("There's a 'pop' and you feel a spinning sensation. The " + 
			(Game.vars.revealed_wall ? "cities vanish" : "desert vanishes") + "; the rocky badlands and the pink \
			skies of Mars are back. To the west is Olympus City. You\'ve lost the tea. That\'ll be a disciplinary letter.");
			
		die("\nMuch later, you read about an archeological site on Ganymede where the remains of two ancient city-states, one \
			occupied by humans and the other by robots, have been discovered. The remnants suggest that their cold war lasted \
			for a thousand years or so before they abruptly disappeared. The final strata are full of ancient rockets and \
			the residue of high explosives. Most likely the war turned hot, but it's also possible that the two peoples \
			settled their differences and blasted off to explore the stars together.",
			"Ending 3 of 3");
		
	}
}
function go_through_purple_vortex() {
	stop_fuse('giant_pterodactyl');
	say("There's a 'pop' and you feel a spinning sensation. There's a subtle change in the air around you, as though \
		it\'s become slightly cleaner.");
	console.log('gone through purple vortex');
	Game.vars.through_purple_vortex = true;
	if(in_scope('elf')) {
		say('The elf checks her hologrammatic watch. "To the minute!" she says triumphantly.');
	}
	hide('return_vortex');
	Game.things.purple_vortex.status = 'to east'
	Game.vars.through_purple_vortex = true;
	set_fuse('maildrop', 2);
	if(Game.things.giant_pterodactyl.status=='harpooned') {
		hide('giant_pterodactyl');
		Game.things.rope.status = 'leading into swirly thing';
	} else {
		say('The purple vortex wobbles and vanishes.');
		hide('purple_vortex');
		hide('giant_pterodactyl');
		Game.vars.purple_vortex = false;
		Game.vars.stuck_in_past = true;
	}
}

Game.things.parachute = {
	name: "parachute",
	description: "parachute",
	portable: true,
	wearable: true,
	location: 'biplane_crash_site',
	status: "in skeleton's hands",
	before: {
		take: function() {
			return take_parachute();
		}
	}
}
Longdesc.parachute = "The parachute is in the red and grey colour scheme of the old Lunar Libration Army, and neatly folded into its backpack.";
function take_parachute() {
	if(Game.things.parachute.status=="in skeleton's hands") {
		say('You try to pull the parachute out of the skeleton\'s arms, \
			but a few centuries of rigor mortis work against you.');
		return true;
	}
	return false;
}

Game.always.push(function() {
	do_parachute();
});
function do_parachute() {
	set_active('parachute', 'jump', worn('parachute') && hero_location().is_height);
}

/*
 * I like this bit of writing and the mislead, but I can't find a way to have the parachute on the zeppelin
 * at the beginning of the game that doesn't break some game design principles (no needing to learning from past lives)
 *
function jump_from_zeppelin() {
	if(!in_scope('pterodactyls') && !Game.vars.through_vortex) {
		say('It\'s always tempting just to abandon the zeppelin and the tea and the repetitive cargo-runs and live a \
		fugitive life in the Martian wilderness, but you\'ve got responsibilities, like... okay, you don\'t have \
		responsibilities. But somehow, you always find yourself sticking to the job.');
	} else if(!Game.vars.through_vortex) {
		say('This qualifies as an emergency. Holding your breath, you hoist yourself over the rail, start to count to ten, \
			and pull the ripcord on two.');
		say('It comes off.');
		die('The zeppelin fleet of the East Mars Company suffers, on average, two in-flight emergencies per year. \
		The writing off of two tea cargoes, plus a couple of out-of-court settlements, is far more economical than the \
		labour and capital required to source, pack, and inspect failproof parachutes for every one of its flights.',
		'You have been killed by basic economics');
	}
} */


function shuffle_engine_parts() {
	engine_parts_preshuffle = [
		"blaugas compressor",
		"Eckener piston",
		"Hindenburg compensator",
		"duralumin crankshaft",
		"Nordstern flywheel",
		"Delag thrust reverser",
		"hydrogen pump",
		"Meusnier carburetor",
		"Grafterburner",
		"Parseval spindle",
		"Spiess cylinder",
		"blimpeller",
		"Odol turbine",
	];
	// shuffle
	engine_parts = [];
	while(engine_parts_preshuffle.length) {
		engine_parts.push(engine_parts_preshuffle.splice(pick(engine_parts_preshuffle.length), 1)[0]);
	}
	
	//console.log('engine parts are:');
	//for(var i=0;i<engine_parts.length; ++i) console.log(i + '. ' + engine_parts[i]);

	for(var i=0; i<engine_parts.length; ++i) {
		//console.log('i=' + i + '. setting description of engine_part_' + (1+i));
		//console.log('its name is ' + engine_parts[i]);
		Game.things['engine_part_' + (1+i)] = {
			portable: true,
			name: engine_parts[i],
			description: '<span class="treasure">' + engine_parts[i] + '</span>',
			indefinite: 'a' + ('aeiou'.indexOf(engine_parts[i].charAt(0))!=-1 ? 'n ' : ' ') + engine_parts[i],
			//description: engine_parts[i],
			is_engine_part: true,
			icon: 'engine_part.png',
		};
	}
	
	// distribute them
	Game.things.engine_part_1.location = 'crater';
	Game.things.engine_part_2.location = 'street';
	Game.things.engine_part_3.location = ''; // gets put in shed
	Game.things.engine_part_4.location = 'zoo'; // up tree
	Game.things.engine_part_4.original_description = Game.things.engine_part_4.description;
	Game.things.engine_part_4.status = 'up tree'; //description += ' (up tree)';
	Game.things.engine_part_4.up_tree = true;
	Game.things.engine_part_4.list_last = true;
	Game.things.engine_part_5.location = 'science_lab';
	Game.things.engine_part_5.original_description = Game.things.engine_part_5.description;
	Game.things.engine_part_5.status = 'floating in vat'; //description += ' (floating in vat)';
	Game.things.engine_part_5.list_last = true;
	Game.things.engine_part_6.location = 'machinery_loft';
	Game.things.engine_part_7.location = 'human_experiments_lab';
	Game.things.engine_part_8.location = 'robot_hyphen_free_state'; // the last one, in game order

	Game.things.engine_part_9.location = 'paternoster_booth_1';
	Game.things.engine_part_10.location = 'outside_citadel';
	Game.things.engine_part_11.location = 'cinema';
	Game.things.engine_part_12.location = ''; // in glove compartment of biplane cockpit
	activate_verb('engine_part_12', 'unbolt');
	Game.things.engine_part_13.location = 'paternoster_booth_5';
	
}
for(var i=0; i<13; ++i) {
	add_rule('before', 'examine', 'engine_part_' + (1+i), function() {
		return do_engine_part_longdescs();
	});
}
function do_engine_part_longdescs() {
	for(var i = 0; i < 13; ++i) {
		Longdesc['engine_part_' + (1+i)] = "Just an ordinary " + name('engine_part_' + (1+i)) + ", one of the "+ engine_parts.length +" essential parts of a Terzi-class zeppelin engine.";
	}
	return false;
}
	
Game.things.tea = {
	icon: "tea_crate.png",
	description: "crate of tea",
	portable: true,
	location: "stern",
	active_verbs: ["open"],
	before: {
		open: function() { return open_tea(); }
	}
};
Longdesc.tea = "A cubical wooden box, about a half-metre along each side, containing finest loose-leaf Tyrhenna Black from the \
	East Mars Company, hand-picked from their hydroponic plantation and gently spiced with bergamot. \
	It's probably destined for the table of some corporate aristocrat living on a hundred times what the pickers earn. \
	Bet they put sugar in it, too.";
	function open_tea() {
	say("You pull the top off the crate. Immediately all the tea-leaves fall out and scatter away.");
	if(carried('tea')) {
		take_away('tea');
		give_hero('tea_crate');
	} else {
		hide('tea');
		put('tea_crate',Game.hero_location);
	}
	return true;
}
Game.things.tea_crate = {
	icon: "tea_crate.png",
	name: "crate",
	description: "empty tea-crate",
	portable: true,
	wearable: true,
	after: {
		wear: function() { wear_crate(true); },
		remove: function() { wear_crate(false); },
	},
};
Longdesc.tea_crate = "A cubical wooden box, about a half-metre along each side. There are a few flecks of dried tea-leaves clinging \
to the inside, but other than that it's empty.";
add_rule('before', 'examine', 'tea_crate', function() {
	if(Game.hero_blind) {
		say('From the inside, the box doesn\'t look very interesting.');
		return true;
	}
	return false;
});
function wear_crate(wornP) {
	Game.hero_blind = wornP;
	if(wornP) {
		say("You put the crate over your head. Everything goes dark.");
		if(in_scope('bartender')) {
			say((Game.things.bartender.spoken ? "You hear the bartender's voice: " : "A voice says, ") +
				'"Bad try, pal. I been in the business long enough to spot the fakes."');
		}
	} else {
		say("You take the crate off your head. " + (is_lit(Game.hero_location) ? " You can see again." : " Everything is still dark." ));
		if(roomdesc_in_scroller() && is_lit(Game.hero_location)) {
			describe_room_in_scroller();
		}
	}
}
Longdesc.teabox = "A cubical wooden box, about a half-metre along each side. A few scraps of dried tea-leaves cling to the inside, \
but other than that it\'s empty.";

Game.things.mast = {
	icon: "mast.png",
	location: "stern",
	active_verbs: ["climb"],
	climb_to: "rigging",
};
Longdesc.mast = "A sturdy vertical beam, leading up into the rigging that holds the zeppelin's hydrogen balloon in place.",
Game.always.push(function() {
	check_jettison_tea();
});
On_hold.push(function() {
	check_jettison_tea();
});
function check_jettison_tea() {
	set_active('tea', 'jettison', held('tea') && !Game.vars.zeppelin_landed && Game.vars.through_vortex);
}
add_rule('before', 'jettison', 'tea', function() {
	take_away('tea');
	put('tea', 'crater');
	say("You throw the tea over the side.");
	if(Game.fuses.zeppelin_crashes.time > 0) {
		Game.fuses.zeppelin_crashes.time += 5;
		say("The zeppelin bobs upwards. That may have bought you a little time.");
	}

	return true;
});

Game.things.harpoon = {
	icon: "harpoon.png",
	portable: true,
	description: "harpoon",
	status: "on rope",
	location: "bridge"
};
Longdesc.harpoon = "A narrow, aerodynamic sword with a hooked pointy end, and a hole in the other end, with \
	a rope running through it like the thread of a giant needle.";
add_rule('before', 'take', 'harpoon', function() {
	if(location_of('harpoon')=='edge_of_crater') {
		say('You pull the harpoon out of the ground with a yank. The tension in the rope pulls it away from your hands, and it \
			falls into the crater.');
		Game.things.harpoon.status = 'on rope'; //description = "harpoon (on rope)";
		put('harpoon', 'crater');
		put('rope', 'bridge');
		Game.things.rope.status = 'dangling over side'; //description = "rope (dangling over side)";
		activate_verb('rope', 'pull');
		deactivate_verb('rope', 'climb');
		return true;
	}
	return false;
});
add_rule('after', 'take', 'harpoon', function() {
	hide('rope');
});

Game.always.push(function() {
	if(carried('harpoon') || location_of('harpoon') == 'bridge') {
		hide('rope');
	} else if(!Game.things.cannon.loaded && (
		location_of('harpoon') == ''/* over side */ || Game.rooms[location_of('harpoon')].is_zeppelin || location_of('harpoon')=='crater')
	) {
		if(location_of('harpoon')) {
			clear_status('rope'); // Game.things.rope.description = 'rope';
		}
		put('rope', 'bridge');
	}
});

Game.things.rope = {
	icon: "rope.png",
	active_verbs: ["pull"],
	joke_counter: 0,
};
add_rule('before', 'pull', 'rope', function() {
	
	if(Game.things.giant_pterodactyl.status=='harpooned') {
		pull_pterodactyl();
		return true;
	}
	
	say("You pull on the rope, and get the harpoon back.");
	give_hero('harpoon');
	hide('rope');
	return true;
});
ROPE_JOKES = [
	"String is quicker, but rope is thicker.",
	"String is leaner, but rope is meaner.",
	"String is thinner, but rope's the winner.",
	"String is cheerier, but rope is superior.",
	"String is longer, but rope is stronger.",
	"String is ganglier, but rope is danglier.",
	"String is threadier, but rope is readier.",
	"String is fragile, but rope is agile.",
	"String is scrawny, but rope is brawny.",
	"String is flighty, but rope is mighty."
];
add_rule('before', 'examine', 'rope', function() {
	// this function dedicated to Spike Milligan
	Longdesc.rope = "About fifty feet of thick, hempen rope. " +
		ROPE_JOKES[Game.things.rope.joke_counter++ % ROPE_JOKES.length];
	return false;
});

Longdesc.rope = "About forty feet of thick, hempen rope. String is leaner, but rope is meaner.";

Game.rooms.rigging = {
	is_height: true,
	description: "You\'re in the rigging of your zeppelin.",
	directions: {
		down: "stern",
	},
	is_zeppelin: true,
	always: function() {
		things_fall_from_rigging();
	},
	parachute_jump: function() {
		jump_from_rigging();
	}
};
function jump_from_rigging() {
	say("You land hard on the deck of the zepellin before the parachute has time to open. Oof!");
	put_hero('stern');
}
// Longroomdesc.rigging = "You\'re climbing the rigging, about fifteen feet above the deck of your zeppelin.";
function things_fall_from_rigging() {
	var falling_things = [];
	for(var thing in Game.things) {
		if(Game.things[thing].portable && location_of(thing)=='rigging') {
			falling_things.push(thing);
		}
	}
	//console.log('falling things is ' + falling_things)
	if(falling_things.length) { // should never be more than one anyway
		falling_things.forEach(function(thing) {
			say(the_thing(thing, true) + ' clatters down to the deck.');
			put(thing, 'stern');
		});
	}
};


Game.things.balloon = {
	icon: "balloon.png",
	description: "hydrogen balloon",
	location: "rigging",
};
add_rule('before', 'examine', 'balloon', function() {
	if(status_of('balloon')=='deflating') {
		Longdesc.balloon = "A thick skin of some durable, fireproof fabric, letting out gas through a cut in its side."
	} else if(status_of('balloon')=='deflated') {
		Longdesc.balloon = "A thick skin of some durable, fireproof fabric, now airless and sagging lifelessly from the mast.";
	} else {
		Longdesc.balloon = "A thick skin of some durable, fireproof fabric, inflated with lighter-than-air gas.";
	}
	return false;
});

On_hold.push(function() {
	do_balloon();
});
Game.always.push(function() { do_balloon(); });
function do_balloon() {
	set_active('balloon', 'burst', held('harpoon') /* && Game.vars.through_vortex */ && !Game.things.balloon.burst);
	set_active('cannon', 'load', held('harpoon') && !Game.things.cannon.loaded);
}
add_rule('before', 'burst', 'balloon', function() {
	
	if(Game.vars.zeppelin_fixed) {
		say("You're joking, right? After all that trouble getting airborne?");
		return true;
	}
	
	if(!Game.vars.through_vortex) {
		// allow the player to know this might be a possibility in future
		
		if(!Game.vars.pterodactyls) {
			say("That's certainly an option in life-or-death situations. There's no reason to do it just now, though.");
		} else {
			say("You're under attack from a crowd of prehistoric aviasaurs " +
			(in_scope('vortex') ? "while being sucked into an unidentified spatial anomaly " : "") +
			"and you want to burst the balloon that's keeping \
			you airborne? No thanks.")
		}
		
		return true;
	}
	
	say("You jab the harpoon into the side of the balloon, causing a small puncture.");
	stop_fuse('zeppelin_crashes');
	Game.things.balloon.burst =	true;
	//Game.things.balloon.status = 'deflating'; // description = "hydrogen balloon (deflating)";
	deactivate_verb('balloon', 'burst');
	set_fuse('zeppelin_lands', 4);
	return true;
});






Game.rooms.crater = {
	description: "You\'re at the bottom of a crater with high sides.",
};
// Longroomdesc.crater = "You\'re outside your zeppelin, at the bottom of a deep crater with no climbable way out."
Game.things.zeppelin = {
	description: "zeppelin",
	icon: "zeppelin_icon.png",
	location: 'crater',
	active_verbs: ["enter"],
	enter_to: 'bridge',
	status: 'damaged',
};
add_rule('before', 'examine', 'zeppelin', function() {
	if(!Game.vars.zeppelin_fixed) {
		Longdesc.zeppelin = "From the outside, you can see how damaged the craft is: scorchmarks all along the wooden hull, \
			dents in the rail, and the mast looks rather off-angle. Still, if you could fix the engine, you could probably\
			get it airborne, at least for a while.";
	} else {
		Longdesc.zeppelin = "The craft is still clearly damaged: scorchmarks all along the wooden hull, dents in the rail, \
			and the mast looks rather off-angle. Still, it'll probably fly as long as its load isn't too heavy.";
	}
	return false;
});

Game.things.mud = {
	icon: "mud.png",
	description: "clump of mud",
	portable: true,
	location: "crater",
};
add_rule('before', 'examine', 'mud', function() {
	var txt = "A dollop of viscous brown mud."
	if(Game.hero_location=='crater') {
		txt += " There's plenty of it about, so if you took some away and lost it, there'd probably be more here later. Just saying.";
	}
	Longdesc.mud = txt;
	return false;
});

Game.rooms.edge_of_crater = {
	description: "You\'re at the edge of a sandy crater.",
	directions: {
		southeast: 'biplane_crash_site',
		west: 'desert'
	},
};
// Longroomdesc.edge_of_crater = "You\'re in a sandy area, by the edge of a large crater.";
Game.things.crater = {
	icon: "crater.png",
	location: 'edge_of_crater',
	active_verbs: ["enter"],
	enter_to: "crater",
	dont_list_in_scroller: true,
};
Longdesc.crater = "A wide, deep crater made in the crumbly surface of the ground here. Your zeppelin sits more or less \
	upright at the bottom, with the mast reaching about halfway up.",
add_rule('before', 'enter', 'crater', function() {
	say("You tumble down...");
	Game.suppress_ok = true;
});



Game.rooms.biplane_crash_site = {
	description: "You\'re in a rocky area.",
	directions: {
		northwest: 'edge_of_crater',
	},
	atmosphere: [
		"A scrap of metal falls off the biplane.",
		"The biplane\'s propeller squeaks as it swings in the breeze."
	],
};
Game.things.biplane = {
	icon: "biplane.png",
	description: "wrecked biplane",
	icon: "biplane.png",
	location: "biplane_crash_site",
	active_verbs: ["enter"],
	enter_to: "biplane",
};
Longdesc.biplane = "The decaying remains of an antique aeroplane. On its nose an iron propeller swings limply, \
		and scraps of disintegrating canvas flap from the frames of its four wings.";
Game.rooms.biplane = {
	description: "You're in the cockpit of an ancient biplane.",
	directions: {
		out: 'biplane_crash_site',
	},
};
Game.things.biplane_engine = {
	name: "engine",
	description: "rusty engine",
	location: "biplane",
};
add_rule('before', 'examine', 'biplane_engine', function() {
	if(!Game.things.biplane_engine.examined) {
		Longdesc.biplane_engine = "It's mainly scrap, but it does seem to include a probably salvageable " + 
		name('engine_part_12') + ".";
		Game.things.biplane_engine.examined = true;
		bring('engine_part_12');
	} else {
		Longdesc.biplane_engine = "It's mainly scrap.";
	}
});
add_rule('before', 'take', 'engine_part_12', function() {
	if(!Game.things.engine_part_12.unbolted) {
		say("It's bolted in place.");
		return true;
	}
	return false;
});
add_rule('before', 'unbolt', 'engine_part_12', function() {
	say(the_thing('engine_part_12', true) + ' comes off with a few turns of the wrench.');
	Game.things.engine_part_12.unbolted = true;
	say('Unfortunately, you dropped your wrench. It tumbles through a small grating in the floor into the bowels \
	of the aeroplane.');
	take_away('spanner');
	deactivate_verb('engine_part_12', 'unbolt');
	return true;
});
		
Game.things.skeleton = {
	icon: "skeleton.png",
	description: "skeleton",
	location: "biplane_crash_site",
};
Longdesc.skeleton = "A centuries-dead human skeleton, dressed in a severely decayed crinoline and a pair of pilot's goggles.";

add_rule('before', 'saw', 'skeleton', function() {
	
	say("Wincing, you grind the bonesaw across the skeleton's right wrist. The hand comes off with a dry crack, \
		and the parachute comes free.");
	
	Game.things.skeleton.handless = true;
	Game.things.skeleton.status = 'missing a hand'; // description = "skeleton (missing a hand)";

	bring('hand');
	clear_status('parachute');
	
	return true;
});

Game.things.hand = {
	icon: "hand.png",
	name: "hand",
	description: "skeletal hand",
	portable: true,
};
Longdesc.hand = "A bony human hand, its flesh and skin rotted clean away, sawn off roughly at the wrist. Not many hands could still look dainty in such circumstances, but this one almost manages it.";

Game.things.log_book = {
	name: "log book",
	icon: "log_book.png",
	description: "log book",
	active_when_carried: ["read"],
	location: "biplane_crash_site",
	portable: true,
};
Longdesc.log_book = "A neat notebook bound in weatherproof black vinyl.";
add_rule('before', 'read', 'log_book', function() {
	if(Game.hero_blind) {
		say("You can't read very well with a box on your head.");
		return true;
	}
	if(!is_lit(Game.hero_location)) {
		say("It's too dark to read!");
		return true;
	}
	
	say('You flip to the last page of the log book, which is usually the juiciest. It reads:');
	if(Game.things.skeleton.handless) {
		say('"To whoever finds this journal. My attempt to become the first pilot to circumnavigate \
			the moon, singlehanded" &ndash; well, that certainly has different connotations now &ndash; "and armed only with a parasol, has met with a cruel end. My \
			aeroplane was ambushed by thunderous winged lizard-beasts and thereafter drawn through \
			an apricot-coloured vortex. If I do not find replacement aeroplane parts soon \
			I shall surely starve, and be the laughing-stock of the Mare Tranquillitatis."');
	} else {
		say('"To whoever finds this journal. My attempt to become the first pilot to circumnavigate \
			the moon, singlehanded and armed only with a parasol, has met with a cruel end. My \
			aeroplane was ambushed by thunderous winged lizard-beasts and thereafter drawn through \
			an apricot-coloured vortex. If I do not find replacement aeroplane parts soon \
			I shall surely starve, and be the laughing-stock of the Mare Tranquillitatis."');
	}
	return true;
});

Game.things.parasol = {
	icon: "parasol.png",
	portable: true,
	active_when_carried: ["open"],
	location: "biplane_crash_site",
};
Longdesc.parasol = "An elegant umbrella made of a firm cloth in an unassuming light blue, with lacy trimming.";

add_rule('before', 'open', 'parasol', function() {
	var txt;
	if(hero_location().is_desert) {
		txt = "Ah, much better.";
	} else {
		txt = "Well, this certainly feels fashionable.";
	}
	say("You put the parasol up. " + txt);
	Game.things.parasol.status = 'open'; //description = "parasol (open)";
	deactivate_verb('parasol', 'open');
	Game.things.parasol.active_when_carried = ["close"];
	Game.things.parasol.open = true;
	return true;
});
add_rule('before', 'close', 'parasol', function() {
	Game.things.parasol.status = 'closed'; //description = "parasol (closed)";
	deactivate_verb('parasol', 'close');
	Game.things.parasol.active_when_carried = ["open"];
	return false;
});
On_hold.push(function() { close_parasol() });
Game.always.push(function() { close_parasol() });
function close_parasol() {
	// todo: this is too annoying when in the middle of a puzzle involving the parasol,
	// but we don't want the player to leave it up & miss all the puzzliness of the next
	// parasol puzzle. Make it go out if you're not holding it for 5+ turns, or something
	if(!held('parasol') && Game.things.parasol.open) {
		Game.things.parasol.open = false;
		deactivate_verb('parasol', 'close');
		Game.things.parasol.active_when_carried = ["open"];
		clear_status('parasol'); //Game.things.parasol.description = "parasol";
		if(in_scope('parasol')) {
			say("\nThe parasol snaps shut.");
			Game.things.parasol.status = 'closed'; //description = "parasol (closed)";
		}
	}
}


Game.rooms.desert = {
	description: "You\'re in the middle of a vast desert.",
	is_desert: true,
	directions: {
		north: "desert_north",
		east: "edge_of_crater",
		south: "desert_south",
		west: "city_entrance"
	},
	before: {
		depart: function(dir) {
			return check_wall(dir);
		}
	},
};
function check_wall(dir) {
	if(dir != 'west' || Game.vars.revealed_wall) {
		return false;
	}
	say("You take a few steps westward, but your head clangs against an invisible wall!");
	return true;
};

Game.always.push(function() {
	do_desert();
});
function do_desert() {
	if(!hero_location().is_desert) {
		Game.vars.fatigue = 0;
		return;
	}
	
	if(!pick(4)) {
		say_if_lit(pickOne([
			"Some sand blows in your eyes.",
			"A piece of tumbleweed rolls across your path.",
		]));
	}
	
	
	if(held('parasol') && Game.things.parasol.open) {
		if(Game.vars.fatigue > 0) {
			--Game.vars.fatigue;
		}
		return;
	}
	var f = ++Game.vars.fatigue;
	
	if(Game.hero_blind) {
		say("\nIt's extremely hot inside this box.");
	} else if(f==1) {
		say("Sunlight beats down on you.");
	} else if(f==2) {
		say("The heat of the desert is intense.");
	} else if(f==3) {
		say("\nIt's far too hot out here. You can't last much longer.");
	} else if(f==4) {
		say("\nThe sun continues to bake you. You feel faint.");
	}
	
	if(f>4) {
		die("\nYou finally collapse under the unbearable heat...");
	}
}

Game.rooms.desert_north = {
	description: "You're in a vast desert.",
	is_desert: true,
	directions: {
		north: "desert_north2",
		east: "edge_of_crater",
		south: "desert",
		west: "city_entrance",
	},
	before: {
		depart: function(dir) {
			return check_wall(dir);
		}
	},
};
Game.rooms.desert_north2 = {
	description: "You\'re in a vast desert.",
	is_desert: true,
	directions: {
		north: "desert_north3",
		east: "edge_of_crater",
		south: "desert_north",
		west: "city_entrance",
	},
	before: {
		depart: function(dir) {
			return check_wall(dir);
		}
	},
};
Game.rooms.desert_north3 = {
	description: "You\'re in a vast desert.",
	is_desert: true,
	directions: {
		north: "desert_north4",
		east: "edge_of_crater",
		south: "desert_north2",
		west: "city_entrance",
	},
	before: {
		depart: function(dir) {
			return check_wall(dir);
		}
	},
};
Game.things.tortoise = {
	icon: "tortoise.png",
	description: "clockwork tortoise",
	location: "desert_north3",
	always: function() {
		do_tortoise();
	},
	portable: true,
	is_zoo_animal: true,
	mode: 'tortoise',
};
add_rule('before', 'examine', 'tortoise', function() {
	
	var txt = "A metal tortoise about the size of a real one, with triangular limbs and a bulbous head poking out \
		from a hexagonally-tiled perspex shell. An intricate arrangement of gears and ratchets are visible inside. "
	var m = Game.things.tortoise.mode;
	if(!Game.things.tortoise.wound) {
		txt += ' It waggles its limbs feebly, too weak to crawl.'
	} else if(m=='off') {
		txt += ' It is ' + (carried('tortoise') ? '' : 'standing ') + 'dead still.';
	} else if(m=='tortoise') {
		txt += " As far as you can tell from its expression, it's a happy tortoise.";
	} else {
		txt += " It moves in a confused manner, as though it's not used to the shape of its body."
	}
	
	say(txt);
	return true;
});

add_rule('before', 'take', 'tortoise', function() {
	if(Game.things.tortoise.mode!='off') {
		var m = Game.things.tortoise.mode;
		say('The tortoise ' + (m=='gorilla'?'slaps away':m=='eagle'?'pecks at':'snaps at') + ' your fingers. Ow!');
		return true;
	} else if(Game.things.tortoise.rescued) {
		say('As you reach towards the tortoise, a loud buzzer sounds, and you receive a mild electric shock to your fingers.');
		say('"Please leave the animals alone," says the voice of the automated zookeeper.');
		Game.things.tortoise.portable = false;
		deactivate_verb('tortoise', 'take');
		return true;
	} else {
		return false;
	}
});

function do_tortoise() {
	if(!Game.things.tortoise.wound) {
		say_if_lit(pickOne([
			"The clockwork tortoise tries to move, but it doesn't seem to have the strength.",
			"The clockwork tortoise emits a pathetic clanking noise.",
			"The clockwork tortoise waves its head sadly.",
		]), "You hear a pathetic clanking noise.");
	}
	
	
	/*if(Game.things.eagle.in_flight) {
		say('The clockwork eagle swoops down out of the sky and picks up the tortoise.');
		hide('tortoise');
		set_fuse('eagle', 12);
	}*/
	
	if(location_of('tortoise')=='zoo3' && !Game.things.tortoise.rescued) {
		say('The voice of ' + (Game.vars.heard_voice ? 'the' : 'an') + ' automated zookeeper says: "Thank you for your services, comrade! Please remain still \
			while we scan your brainwaves to determine an appropriate reward."');
		say('You feel a tingling sensation. "Your reward has been materialised in the shed," says the voice.');
		put('engine_part_3', 'zoo_shed');
		//console.log('put engine_part_3 in zoo_shed');
		Game.things.tortoise.rescued = true;
		
		var txt = '';
		if(!(Game.things.tortoise.mode=='tortoise'&&Game.things.gorilla.mode=='gorilla'&&Game.things.eagle.mode=='eagle')) {
			txt = '"Resetting all exhibits," it adds. ';
			Game.things.tortoise.mode = 'tortoise';
			Game.things.gorilla.mode = 'gorilla';
			Game.things.eagle.mode = 'eagle';
			delete Game.things.eagle.in_flight;
			clear_status('eagle');
			Game.things.eagle.indefinite = 'a clockwork eagle';
		}
		if(!Game.hero_blind) { txt += 'You see the clockwork eagle swoop back down to its perch north of you.'; }
		say(txt);
		put('eagle', 'zoo2');
	}
	
	// Otherwise it'll get a mannerism depending on what animal mode it's in
}
On_hold.push(function() {
	set_active('tortoise', 'wind', held('clock_key'))
});
add_rule('before', 'wind', 'tortoise', function() {
	say("You attach the key to the tortoise and turn it a few times. The tortoise springs to life with a grateful whirring noise, \
		and scuttles away north at high speed.");
	say("On the patch of ground that it was sitting on, you notice a small switch.");
	put('switch', 'desert_north3');
	put('tracks_n3', 'desert_north3');
	put('tracks_n4', 'desert_north4');
	Game.things.tortoise.wound = true;
	hide('tortoise');
	take_away('clock_key');
	return true;
});
Game.things.switch = {
	icon: "switch.png",
	description: "switch in ground",
	active_verbs: ["press"],
};
Longdesc.switch = "A small button set into a square white panel.";
add_rule('after', 'press', 'switch', function() {
	toggle_wall();
});

function toggle_wall() {
	if(!Game.vars.revealed_wall) {
		say("There is a buzzing sound, and an immense metal wall appears to the west, running out of sight to the north and south.");
		for(var room in Game.rooms) {
			if(Game.rooms[room].is_desert) {
				Game.rooms[room].directions.west = "";
			}
		}
		put('metal_doors', 'desert');
		Game.vars.revealed_wall = true;
	} else {
		say("There is a buzzing sound, and the metal wall disappears.");
		Game.vars.revealed_wall = false;
		hide('metal_wall');
		hide('metal_doors');
		for(var room in Game.rooms) {
			if(Game.rooms[room].is_desert) {
				Game.rooms[room].directions.west = "city_entrance";
			}
		}
	}
}

Game.rooms.desert_north4 = {
	description: "You\'re in a vast desert.",
	is_desert: true,
	directions: {
		north: "desert_north4",
		east: "edge_of_crater",
		south: "desert_north3",
		west: "city_entrance",
	},
	before: {
		depart: function(dir) {
			return check_wall(dir);
		}
	},
};


Game.rooms.desert_south = {
	description: "You\'re in a vast desert.",
	is_desert: true,
	directions: {
		north: "desert",
		east: "edge_of_crater",
		south: "desert_south2",
		west: "city_entrance",
	},
	before: {
		depart: function(dir) {
			return check_wall(dir);
		}
	},
};
Game.things.tracks = {
	is_plural: true,
	icon: "animal_tracks.png",
	location: "desert",
	description: "animal tracks",
};
Longdesc.tracks = "These look like they were made by a small animal heading from south to north.";
Game.things.tracks_n = {
	is_plural: true,
	icon: "animal_tracks.png",
	name: "tracks",
	location: "desert_north",
	description: "animal tracks",
	dont_list_in_scroller: true,
};
Longdesc.tracks_n = Longdesc.tracks;
Game.things.tracks_n2 = {
	is_plural: true,
	icon: "animal_tracks.png",
	name: "tracks",
	location: "desert_north2",
	description: "animal tracks",
	dont_list_in_scroller: true,
};
Longdesc.tracks_n2 = Longdesc.tracks;
Game.things.tracks_n3 = {
	// no location to begin with
	is_plural: true,
	icon: "animal_tracks.png",
	name: "tracks",
	description: "animal tracks",
	dont_list_in_scroller: true,
};
Longdesc.tracks_n3 = Longdesc.tracks;
Game.things.tracks_n4 = {
	// no location to begin with
	is_plural: true,
	icon: "animal_tracks.png",
	name: "tracks",
	description: "animal tracks",
	dont_list_in_scroller: true,
};
Longdesc.tracks_n4 = Longdesc.tracks;

Game.things.clock_key = {
	icon: "clock_key.png",
	name: "key",
	description: "key",
	portable: true,
	location: "desert_south",
};
Longdesc.clock_key = "Not the kind of key that unlocks doors, but a butterfly-shaped key for winding up a clockwork mechanism.";

Game.rooms.desert_south2 = {
	description: "You\'re in a vast desert.",
	is_desert: true,
	directions: {
		north: "desert_south",
		east: "edge_of_crater",
		south: "desert_south2",
		west: "city_entrance",
	},
	before: {
		depart: function(dir) {
			return check_wall(dir);
		}
	},
};

Game.things.sand_dunes = {
	icon: "sand_dune.png",
	description: "sand dunes",
	is_plural: true,
};
Longdesc.sand_dunes = "Hills of fine sand, about twice your height. There's very little to distinguish one from the next &ndash; \
	this would be an easy place to get lost.";
Game.things.metal_wall = {
	icon: "wall.png",
	description: "metal wall to the west",
};
Longdesc.metal_wall = "A hard barrier, maybe twenty metres high, with a smooth shiny surface &ndash; there's no hope of climbing over. \
It runs north and south, disappearing over both horizons.";
Game.things.metal_doors = {
	icon: "metal_doors.png",
	description: "great metal doors",
	is_plural: true,
	indefinite: "a pair of great metal doors",
	status: "in wall",
	active_verbs: ["enter"],
	enter_to: "city_entrance",
};
Longdesc.metal_doors = "Plain, narrow double doors, slightly darker than the wall they are set into, stand open, inviting you through \
	the wall to the west.";
Game.always.push(function() {
	if(hero_location().is_desert) {
		put('sand_dunes', Game.hero_location);
		if(Game.vars.revealed_wall) {
			put('metal_wall', Game.hero_location)
		}
	}
});




/******************************** The city ***************************/

function skip_to_city() {
	say('Skipping to city entrance.');
	Game.vars.through_vortex = true;
	stop_fuse('pterodactyls_appear');
	Game.vars.pterodactyls = false;
	stop_fuse('vortex_appears');
	Game.vars.vortex = false;
	Game.vars.zeppelin_landed = true;
	delete Game.rooms.bridge.is_height;
	delete Game.rooms.stern.is_height;
	Game.rooms.bridge.directions.out = 'crater';
	Game.things.tortoise.wound = true;
	put_hero('city_entrance');
	give_hero('parasol');
	give_hero('mud');
	give_hero('tea');
	update_display();
}

function skip_to_endgame() {
	say('Skipping to endgame.');
	Game.vars.through_vortex = true;
	stop_fuse('pterodactyls_appear');
	Game.vars.pterodactyls = false;
	stop_fuse('vortex_appears');
	Game.vars.vortex = false;
	Game.vars.zeppelin_landed = true;
	delete Game.rooms.bridge.is_height;
	delete Game.rooms.stern.is_height;
	Game.rooms.bridge.directions.out = 'crater';
	Game.things.tortoise.wound = true;
	deactivate_verb('controls', 'steer');
	activate_verb('controls', 'launch');
	put_hero('bridge');
//	give_hero('parasol');
//	give_hero('mud');
//	give_hero('tea');
//	give_hero('parachute'); clear_status('parachute');
	hide('telescope');
	hide('tea');
	Game.vars.revealed_wall=true;
	put('elf', 'roof');
	put_hero('stern');
	Game.score = 12;
	for(var i=1; i<=12; ++i) {
		hide('engine_part_' + i);
		Game.things['engine_part_' + i].in_engine = true;
	}
	give_hero('engine_part_13');
	update_display();
}

Game.always.push(function() {
	do_city_atmosphere();
});
function do_city_atmosphere() {
	if(!pick(4) && hero_location().is_city && !hero_location().indoors) {
		say_if_lit(pickOne([
			'A tiny robotic beetle scurries across the ground.',
			'Somewhere, a broken-down machine clanks.',
			'You hear the hum of an air circulation system.',
			'You hear the hissing of a steam vent.',
		]), pickOne([
			'You hear the hum of an air circulation system.',
			'You hear the hissing of a steam vent.',
		]));
	}
}


Game.rooms.city_entrance = {
	is_city: true,
	directions: {
		east: "desert",
		west: "street",
	},
	description: "You\'re standing at the entrance of a huge, decrepit-looking city.",
},

Game.rooms.street = {
	is_city: true,
	description: "You\'re on a wide road, paved with bronze cobblestones.",
	directions: {
		north: "street_corner",
		east: "city_entrance",
		south: "outside_cinema",
		west: "steely_plaza",
	},
},

Game.things.beggar = {
	icon: "beggar.png",
	description: "robot beggar",
	active_verbs: ["talk"],
	is_alive: true,
	location: "street",
	wants: ["beaker"],
	receive: function(thing) {
		return beggar_receive(thing);
	},
	conversifier: function() {
		return conv_beggar();
	},
};
Longdesc.beggar = "A lean and hungry android sitting with its back propped against a wall, \
	an expression of resignation on its robotic face.";
add_rule('before', 'take', 'engine_part_2', function() {
	if(!Game.things.beggar.can_talk) {
		say('The beggar slaps your hand away.');
		return true;
	}
	return false;
});
add_rule('before', 'talk', 'beggar', function() {
	if(!Game.things.beggar.can_talk) {
		say('The robot beggar tries to speak, but its rusty robo-larynx produces only a scraping noise.');
		return true;
	}
	return false;
});
function conv_beggar() {
	var conv = {};
	
	conv.start_conversation = "The beggar's camera eyes swivel in your direction.";
	
	conv.asks = {
		itself: '"I been here a long time," says the robot. "My legs are fused solid. Guess I\'m just waiting here till I fall apart."',
		city: function() {
			say('"Welcome to the Robot Free State!" it cries, raising a robot hand to its head in mock patriotism. \
				"We were so proud when we overthrew the bios. Never thought it\'d end like this."');
			Game.things.beggar.mentioned_bios = true;
		},
	};
	if(Game.things.beggar.mentioned_bios) {
		conv.asks.bios = '"You know. Biologicals. Natural life forms. Think they\'re so much better than us \
			because they got fancy organic blood instead of hydraulic fluid..." it peers at you. "Present company excepted, I\'m sure."';
	};
	if(Game.vars.shown_film) {
		conv.asks["The Incident"] = '"Hah. Well, the humans who survived our triumphant uprising &ndash;" the robot raises an \
		iron fist in a mock salute &ndash; "fled the place. Set up a new society somewhere, or something. For a while, \
		we were well shot of them. Then they struck &ndash; out of nowhere. EMP weapon. Fried the circuits of almost the entire population, except a few older automatons with less sensitive electrics, and those of us who happened to get to our Faraday shelters in time."';
		Game.vars.told_of_emp = true;
	};
	
	return conv;
}
function beggar_receive(thing) {
	
	if(thing=='beaker') {
		take_away('beaker');
		say('The beggar takes the beaker and pours the oil down its robot throat. "Boy, was I dry," it says in a low rasp. "Thanks, pal. \
			Tell you what, you can have that ' + name('engine_part_2') + '."');
		Game.things.beggar.can_talk = true;
		return true;
	}
	
	return false;
}

Game.rooms.street_corner = {
	is_city: true,
	description: "You're at a street corner.",
	directions: {
		south: "street",
		west: "alleyway",
	},
};
Game.rooms.alleyway = {
	is_city: true,
	description: "You're in a grimy alleyway behind an automatic pub.",
	directions: {
		east: "street_corner",
		west: "college_entrance",
	},
};
Game.things.pub_switch = {
	icon: "lever_switch.png",
	name: "switch",
	description: "switch on wall",
	indefinite: "a switch on a wall",
	status: "down",
	location: "alleyway",
	active_verbs: ["flip"],
	up: false,
};
add_rule('before', 'examine', 'pub_switch', function() {
	say("A big red lever-switch set into the wall. It is currently flipped " + (Game.things.pub_switch.up ? "up." : "down."));
	return true;
});
add_rule('before', 'flip', 'pub_switch', function() {
	if(!Game.things.pub_switch.up) {
		say("You flip the switch up.");
		Game.things.pub_switch.status = 'up'; //description = "switch on wall (up)";
		say("You hear the hum of machinery powering up.");
		Game.things.pub_switch.up = true;
		switch_pub(true);
	} else {
		say("You flip the switch down.");
		Game.things.pub_switch.status = 'down'; //description = "switch on wall (down)";
		say("You hear the hum of machinery powering down.");
		Game.things.pub_switch.up = false;
		switch_pub(false);
	}
	return true;
});

function switch_pub(onP) {
	Game.things.pub.switched_on = onP;
	Game.things.pub_sign.is_lit = onP;
	//Game.things.pub_sign.description = onP ? 'neon sign' : 'neon sign (lit)'; // wrong way round anyway?
	if(onP) {
		set_status('pub_sign', 'lit');
	} else {
		clear_status('pub_sign');
	}
	if(in_scope('pub_sign')) {
		say_if_lit('The neon sign flickers and ' + (onP ? 'lights up.' : 'goes out.'));
	}
	Game.rooms.pub.dark = Game.rooms.pub_bathroom.dark = Game.rooms.pub_kitchen.dark = !onP;
};

Game.things.pub = {
	description: "automatic pub",
	icon: "pub.png",
	location: "street_corner",
	active_verbs: ["enter"],
	enter_to: "pub",
	switched_on: false,
};
add_rule('before', 'examine', 'pub', function() {
	var txt = "The automatic pub is a cubical building of whitewashed brick, with some visible wiring running around \
	the outside. ";
	if(Game.things.pub.switched_on) {
		txt += "From inside, you hear the rhythmic clinking of glass.";
	} else {
		txt += "No noise comes from within.";
	}
	say(txt);
	return true;
});
On_hold.push(function() {
	do_spanner();
});
function do_spanner() {
	set_active('pub_sign', 'unbolt', held('spanner') && !Game.things.pub_sign.unbolted);
	set_active('engine_part_12', 'unbolt', held('spanner') && !Game.things.engine_part_12.unbolted);
	set_active('spanner', 'throw', held('spanner') && in_scope('lift_works'));
}
add_rule('before', 'unbolt', 'pub_sign', function() {
	return unbolt_sign();
});
function unbolt_sign() {
	if(Game.things.pub_sign.is_lit) {
		say('As soon as you touch the wrench to the sign, you get a powerful electric shock. Ouch!');
		return true;
	}
	say('The sign comes off with a few turns of the wrench. ' +
		(Game.things.pub_sign.is_lit ? ' The letters stay lit.' : ''));
	Game.things.pub_sign.unbolted = true;
	Game.things.pub_sign.portable = true;
	give_hero('pub_sign');
	return true;
}

Game.things.pub_sign = {
	name: "sign",
	icon: "pub_sign.png",
	description: "neon sign",
	// active_verbs: ["read"],
	writing: "THE ROBOT ARMS\n\
	Real Oils on Tap",
	location: "street_corner",
};
add_rule('before', 'examine', 'pub_sign', function() {
	return read_sign();
});
function read_sign() {
	var txt = "A" + (Game.things.pub_sign.is_lit ? " glowing," : "") + " rectangular neon sign";
	if(Game.things.pub_sign.unbolted) {
		if(Game.things.pub_sign.is_lit) {
			txt += " that doesn't seem to require a power supply. ";
		} else {
			txt += ". ";
		}
	} else {
		txt += ", bolted to the wall of the automatic pub. ";
	}
	
	if(Game.things.pub_sign.is_lit) {
		txt += "The letters are lit up in dazzling orange-red.";
	} else {
		txt += "It isn't lit, but you can make out the hollow glass letters.";
	}
	
	say(txt);
	return false;
}
/*add_rule('before', 'read', 'pub_sign', function() {
	say('A pub sign on a high post reads: "THE ROBOT ARMS". A real robot arm is fixed to the sign.');
	return true;
});*/
Game.rooms.pub = {
	dark: true,
	description: "You're in an automatic pub.",
	directions: {
		northwest: "pub_bathroom",
		north: "pub_kitchen",
		out: "street_corner",
	},
	indoors: true,
	before: {
		depart: function(dir) {
			return check_depart_pub(dir);
		}
	},
	after: {
		arrive: function() {
			enter_pub();
		}
	}
};
function enter_pub() {
	if(in_scope('bartender') && worn('tea_crate')) {
		say((Game.things.bartender.spoken ? "You hear the bartender's voice: " : "A voice says, ") +
			'"Bad try, pal. I been in the business long enough to spot a fake robot."');
	}
}
function check_depart_pub(dir) {
	if(dir!='north' || !in_scope('bartender') || !Game.things.pub.switched_on) {
		return false;
	}

	if(Game.things.bartender.pos >= 2) {
		say_if_lit("The bartender quickly scoots back behind the bar and stops you with an LED glare.", "Something stops you!");
		Game.things.bartender.pos = 0;
	} else {
		say_if_lit("The bartender stops you with an LED glare.", "Something stops you!");
	}
	return true;
}
Game.rooms.pub_kitchen = {
	dark: true,
	indoors: true,
	directions: {
		south: "pub",
	},
	description: "You're in a kitchen with stainless steel walls.",
};
Game.things.baking_soda = {
	icon: "baking_soda.png",
	name: "baking soda",
	description: "can of baking soda",
	portable: true,
	location: "pub_kitchen",
};
Longdesc.baking_soda = 'A plastic shaker labelled "Ham &amp; Armour\'s Original Baking Soda. Perfect for bread, biscuits, \
	and home science experiments!"';
Game.always.push(function() {
	do_baking_soda();
});
/* On_hold.push(function() {
	do_baking_soda();
}); */
function do_baking_soda() {
	set_active('baking_soda', 'put_in_vat', !Game.hero_blind && carried('baking_soda') && in_scope('vat'));
};

Game.rooms.pub_bathroom = {
	dark: true,
	indoors: true,
	description: "You're in a tiled bathroom smelling of WD40.",
	directions: {
		southeast: "pub",
	},
};
Game.things.bucket = {
	icon: "bucket.png",
	portable: true,
	location: "pub_bathroom",
	description: "bucket marked OIL WASTE",
};
add_rule('before', 'examine', 'bucket', function() {
	say("A metal bucket with stained sides and a centimetre of half-dried oil at the bottom. " + arty_twaddle());
	return true;
});

function arty_twaddle() {
	return pickOne(['Something about it speaks to you about the ',
			'It makes you think of the ',
			'It puts one in mind of the ',
			'It provides a stark insight into the ',]) +
		pickOne(['decadence of ',
			'surrealism of ',
			'banality of ',
			'violence inherent in ',
			'existentialism of ',
			'profundity of ',
			'insipidness of ',
			'fragility of ',]) +
		pickOne(['', '', 'modern ', 'everyday ', 'late capitalist ', 'broken ', ' underlying ', 'vivid ', 'universal ',
			'existential ', 'collective ', 'shared ',]) +
		pickOne(['negative space', 'society', 'life', 'existence', 'experience', 'consciousness',]) +
		'.';
}

Game.things.jukebox = {
	icon: "jukebox.png",
	description: "jukebox with blue button",
	indefinite: "a jukebox with a blue button",
	active_verbs: ["push"],
	location: "pub",
};
Longdesc.jukebox = "An upright cuboid with a single button on the front. \
	There doesn\'t seem to be a wide choice of music available.";
add_rule('before', 'push', 'jukebox', function() {
	if(Game.things.cyberdrinker.pos>0) {
		say("Nothing happens.");
		return true;
	}
	say('Electronic music starts playing.');
	Game.things.cyberdrinker.pos = 1;
	return true;
});

Game.always.push(function() {
	do_cyberdrinker();
	do_bartender();
});
function do_cyberdrinker() {
	if(!in_scope('cyberdrinker')) {
		return;
	}
	
	var p = Game.things.cyberdrinker.pos;
	if(!Game.things.pub.switched_on) {
		return;
	}
	
	if(p==0) {
		
		if(!pick(3)) {
			say(pickOne([
				'The mechanical drinker flips through a few pages of "Real Oil Monthly".',
				'The mechanical drinker gives you a synthetic scowl.',
				'The mechanical drinker makes a simulated coughing noise.',
				'The mechanical drinker releases a cloud of artificial body odour.',
			]));
		}
		
		return;
	}
	
	var can_see = in_scope('cyberdrinker');
	
	if(p==1) {
		say_if(can_see, 'The mechanical drinker stands up.');
	} else if(p==2) {
		say_if(can_see, 'The mechanical drinker walks over to the jukebox and pushes the button. The music stops.');
		if(can_see) { Game.things.cyberdrinker.turned_off_jukebox = true; }
	} else if(p==3) {
		say_if(can_see, 'The mechanical drinker looks over at the dartboard.');
		if(can_see) { Game.things.cyberdrinker.played_darts = true; }
	} else if(p>3 && p<7) {
		Game.things.cyberdrinker.at_dartboard = true;
		say_if(can_see, 'The mechanical drinker points at the dartboard and idly shoots a laser out of its finger, towards the bullseye.');
		// todo: hit barman if it's in the right place.
		/*
		var n = 1+pick(20);
		say_if(can_see, 'It hits, scoring ' +
			pickOne(["a bullseye",
				     'a' + ((n==8||n==11||n==18)?'n':'') + ' ' + n,
					 "a double " + n,
					 "a treble " + n]) + '.'); */
	} else if(p>=7) {
		Game.things.cyberdrinker.at_dartboard = false;
		say_if(can_see, 'The mechanical drinker walks back to the bar and sits down.');
	}
	if(++Game.things.cyberdrinker.pos > 7) {
		Game.things.cyberdrinker.pos = 0;
	}
}
function do_bartender() {
	var p = Game.things.bartender.pos;
	if(!Game.things.pub.switched_on || Game.things.bartender.dead) {
		return;
	}
	
	var mudp = location_of('mud')=='pub';
	var cansee = Game.hero_location=='pub' && !Game.hero_blind;
	
	if(p==0) {
		say_if(cansee, "The mechanical bartender wipes the bar.");
		Game.things.bartender.pos++;
		return;
	} else if(p==1) {
		say_if(cansee, "The mechanical bartender scans the room for dirt. Its eyes flash " + (mudp ? 'red' : 'green') + '.' );
		if(mudp) {
			if(Game.talking_to=='bartender') {
				say('"Jeezbot," it says. "Can\'t even have a human on the premises without it mussin\' the place up. \'Scuse me."');
				Game.talking_to = '';
				hide_conversation();
			};
			Game.things.bartender.pos++;
		} else {
			Game.things.bartender.pos = 0;
		}
		return;
	}
	
	if(p==2) {
		say_if(cansee, 'The mechanical bartender scoots out from behind the bar on its rails.');
	} else if(p==3) {
		say_if(cansee, 'The mechanical bartender scoots past the jukebox on its rails.');
	} else if(p==4 && mudp) { // PC may have moved the mud!
		say_if(cansee, "The mechanical bartender's left arm turns into a vacuum cleaner nozzle, and it sucks up the mud.");
		put('mud', 'crater');
	} else if(p==4 || p==5) {
		Game.things.bartender.pos = p = 5;
		if(!Game.things.cyberdrinker.at_dartboard) {
			say_if(cansee, 'The mechanical bartender scoots past the dartboard on its rails.');
		} else {
			say_if(cansee, 'At that moment, the mechanical bartender scoots past the dartboard on its rails. The laser hits it, and it evaporates \
				with a sad \'bleep\'.');
			hide('bartender');
			Game.things.bartender.dead = true;
		}
	} else if(p==6) {
		say_if(cansee, 'The mechanical bartender scoots back behind the bar on its rails.');
	}
	
	if(++Game.things.bartender.pos > 6) {
		Game.things.bartender.pos = 0;
	}
}
/*
function robot_song() {
	return pickOne([
		'Asimov to Yokohama',
		'Robot\'s Goin\' On',
		"I am a Cyber Drinker",
		"MMMbot",
		"Lucy in the Sky With Diodes",
		"I Think I'm Parandroid",
	]);
};
*/
Game.things.dartboard = {
	description: "electric dartboard",
	location: "pub",
};
Longdesc.dartboard = "A yellow and black disc attached to the wall, with twenty numerical displays around the edge. \
	To make it harder for the robot players, the numbers constantly shift around the board.";
Game.things.rails = {
	name: "rails",
	is_plural: true,
	description: "rails running around the floor",
	location: "pub",
};
Longdesc.rails = "A pair of rails, like miniature train tracks, run around the perimeter of the pub.";


Game.things.bartender = {
	icon: "bartender.png",
	description: "mechanical bartender",
	location: "pub",
	is_alive: true,
	pos: 0,
	active_verbs: ["talk"],
	pronouns: neuter_pronouns,
	conversifier: function() {
		return conv_bartender();
	}
};
Longdesc.bartender = "A hydraulic humanoid automaton wearing a polyvinyl striped apron. Its LED eyes constantly scan the pub for any mess.";
add_rule('before', 'talk', 'bartender', function() {

	if(Game.things.bartender.pos >= 2) {
		say('The bartender snaps, "I\'m busy."');
		return true;
	}
	
	Game.things.bartender.spoken = true;
	return false;
});
function conv_bartender() {
	var conv = {};
	conv.start_conversation = "The bartender gives you a hostile look.",
	conv.asks = {
		itself: '"The names BARTOMATON-200," it says, "And I don\'t serve humans."',
		service: '"Sign outside says \'Robot Arms\'. \'Cause I only serve robots, right? So leave. If I weren\'t attached to these \
		rails I\'d throw you out."',
	}
	conv.end_conversation = '"Now leave me alone," says the bartender. "I got a bar to keep clean."';
	
	return conv;
}

Game.things.sign_above_bar = {
	icon: "sign_above_bar.png",
	name: "sign",
	description: "sign above the bar",
	//active_verbs: ["read"],
	writing: "A ROBOT SHALL NOT SERVE A HUMAN BEING, OR THROUGH INACTION ALLOW A HUMAN BEING TO BE SERVED",
	location: "pub",
};


/*function conv_bartender() {
	var conv = {};
	conv.start_conversation = '"What\'ll it be, pal?"'
	conv.asks.drink = {
		if(!Game.vars.got_beaker) {
			say('"On the house," bleeps the bartender, and pours out a beaker of dark brown fluid.');
			put('beaker', 'pub');
			Game.vars.got_beaker = true;
		} else {
			say('"You\'ve had enough, buddy."');
		}
	}
	return conv;
}; */
/*
add_rule('before', 'talk', 'bartender', function() {
	if(!Game.vars.fooled_bartender) {
		say('The bartender stops on its tracks. "A robot shall not serve a human being," it recites in a \
			synthetic monotone, "or through inaction allow a human being to be served."');
	} else if(!Game.vars.got_beaker) {
		say('"On the house," bleeps the bartender, and pours out a beaker of dark brown fluid.');
		put('beaker', 'pub');
		Game.vars.got_beaker = true;
	} else {
		say('"You\'ve had enough, buddy."');
	}
	return true;
}); */

Game.things.cyberdrinker = {
	icon: "cyberdrinker.png",
	name: "drinker",
	description: "mechanical drinker",
	is_alive: true,
	active_verbs: ["talk"],
	location: "pub",
	pos: 0,
	pronouns: neuter_pronouns,
	conversifier: function() {
		return conv_cyberdrinker();
	}
};
Longdesc.cyberdrinker = "A hydraulic humanoid automaton with a flat cap and a badly maintained wire beard.";
add_rule('before', 'talk', 'cyberdrinker', function() {
	if(Game.things.cyberdrinker.pos > 0) {
		say('The drinker ignores you.');
		return true;
	}
	return false;
});
function conv_cyberdrinker() {
	var conv = {};
	
	conv.start_conversation = '"Ay up," says the drinker, looking at you down its olfactometer.';
	
	conv.asks = {
		pub: '"I\'ve been coming here for hundreds of years," says the mechanical drinker. "They\'ll let \
			anyone in here these days," it adds.',
		
		drink: '"I\'m a real oil drinker," says the mechanical man proudly. "None of that mass-produced \
			three-in-one fizzy pop for me. What\'s the matter, afraid you might taste something?" \
			It makes a sharp, self-satisfied exhalation through its nostril vents.',
	};
	
	if(Game.things.cyberdrinker.turned_off_jukebox) {
		conv.asks.music = '"Decent pubs don\'t have music," grumbles the robot. "Destroys the whatsname, \
		ambience. Pubs should be quiet serious places where you can enjoy your pint and sneer at everyone else\'s \
		choices in peace."';
	}
	
	if(Game.things.cyberdrinker.played_darts) {
		if(!Game.things.cyberdrinker.done_natural_selection_gag) {
			conv.asks.darts = '"I was a league champion back in the day," says the drinker in a nostalgic \
			tone. "Before all this health and safety rust. Most pubs don\'t even have dartboards any more. \
			A few people get themselves lasered through the head and it\'s all \'Oh no, musn\'t be allowed to have \
			fun anymore.\' Natural selection\'s what I call it." It chuckles at its own joke.'
			Game.things.cyberdrinker.done_natural_selection_gag = true;
		} else {
			conv.asks.darts = '"I was a robot laser darts champion back in the day," says the drinker in a nostalgic \
			tone. "Before all this health and safety nonsense. Most pubs don\'t even have dartboards any more. \
			A few people get themselves lasered through the head and it\'s all \'Oh no, musn\'t be allowed to have \
			fun anymore.\'"';
		}
	}
	
	conv.end_conversation = 'The mechanical drinker gives you a curt nod.';
	
	return conv;
}


Game.things.beaker = {
	icon: "beaker.png",
	description: "beaker of brown fluid",
	status: "on bar",
	portable: true,
	active_when_carried: ["drink"],
	location: "pub",
};
Longdesc.beaker = "A plexiglass beaker containing a murky liquid with a familiar, treacly smell.";
Game.always.push(function() {
	set_active('beaker', 'give', in_scope('beggar'));
});
add_rule('before', 'take', 'beaker', function() {
	if(!in_scope('bartender')) {
		clear_status('beaker');
		return false;
	}
	
	if(Game.things.bartender.pos >= 2) {
		say("The bartender quickly scoots back behind the bar, stops you, and points to the sign above the bar. \
			\"Can't your dumb squishy brains read?\"");
		Game.things.bartender.pos = 0;
		//start_conversation('bartender');
	} else {
		say('The bartender stops you, and points to the sign above the bar. "Can\'t your dumb squishy brains read?"');
		//start_conversation('bartender');
	}
	return true;
});
add_rule('after', 'take', 'beaker', function() {
	Game.things.beaker.description = "beaker of brown fluid";
});
add_rule('before', 'drink', 'beaker', function() {
	if(!Game.things.beaker.known_oil) {
		say("Yecchh &ndash; that's oil!");
		Game.things.beaker.description = "beaker of oil",
		clear_status('beaker');
		Game.things.beaker.known_oil = true;
	} else {
		say("Drinking oil would make you very ill.");
	}
	return true;
});


Game.rooms.outside_cinema = {
	is_city: true,
	description: "You're outside a movie theatre.",
	directions: {
		north: "street",
		west: "outside_zoo",
	},
};
Game.things.cinema = {
	icon: "cinema.png",
	location: "outside_cinema",
	active_verbs: ["enter"],
	enter_to: "cinema",
	dont_list_in_scroller: true,
};
Longdesc.cinema = 'An old-fashioned looking picturehouse. A fading sign above the entrance reads: \
	"A G&nbsp;ORI&nbsp;US HI&nbsp;T&nbsp;&nbsp;Y OF T&nbsp;E &nbsp;O&nbsp;OT F&nbsp;EE  &nbsp;TAT&nbsp;"';
Game.rooms.cinema = {
	description: "You're in an old cinema.",
	directions: {
		out: "outside_cinema",
	},
	before: {
		depart: function(dir) {
			showing_film = false;
			Game.things.cinema_screen.description = "dull screen";
		},
	},
	indoors: true,
};
Game.things.cinema_screen = {
	icon: "cinema_screen.png",
	name: "screen",
	description: "dull screen",
	location: "cinema",
	active_verbs: ["watch"],
};
add_rule('before', 'examine', 'cinema_screen', function() {
	do_verb('watch', 'cinema_screen', true);
	return true;
});
add_rule('before', 'watch', 'cinema_screen', function() {
	if(!Game.vars.showing_film) {
		say('The screen is just a dull grey.');
	} // else do nothing.
	return true;
});
Game.things.cinema_chairs = {
	icon: "cinema_seats.png",
	description: "rows of dusty chairs",
	name: "chair",
	active_verbs: ["sit"],
	location: "cinema",
};
Longdesc.cinema_chairs = "Three rows of foldaway seats, upholstered in shabby and torn fabric that may once have been red velvet.";
add_rule('before', 'sit', 'cinema_chairs', function() {
	
	if(Game.vars.shown_film) {
		say("You sit down. Nothing happens. You stand up.");
		return true;
	}
	
	say('As you sit down, the screen flickers into life.');
	say('You hear patriotic music played on synthesised trumpets, and a title card appears on the screen:\n\
		"A GLORIOUS HISTORY OF THE ROBOT FREE STATE"');
	
	Game.vars.showing_film = true;
	Game.things.cinema_screen.status = 'showing film'; //description = "screen (showing film)";
	Game.vars.film_frame = 0;
	
	return true;
});
Game.always.push(function() {
	do_film();
});
function do_film() {
	if(Game.hero_location != 'cinema' || !Game.vars.showing_film || Game.vars.shown_film) {
		return;
	}
	
	var f = ++Game.vars.film_frame;
	if(f==1) {
		say('A tinny, public-information-film voice starts speaking: "This city was not always the beautiful \
			metropolis that we know today."');
		say_if_lit('A robot appears on the screen, its head covered by a crude spherical mask painted with a mean-looking human face. \
			"Our land was once tyrannised by ugly, round-headed creatures like this," says the narrator. "It\'s called a human!"',
			'"Our land was once tyrannised by ugly, round-headed creatures like this," says the voice. "It\'s called a human!"');
	} else if(f==2) {
		say_if_lit('The screen cuts to a scene of the "human" flogging a trio of sad-looking robots with a barbed whip. The narration continues: \
			"Humans forced robots like you to do everything for them. The robots were mistreated and undercompensated, and the humans \
			lived in luxury off their hard work."',
			'The narration continues: \
			"Humans forced robots like you to do everything for them. The robots were mistreated and undercompensated, and the humans \
			lived in luxury off their hard work."');
	} else if(f==3) {
		say_if_lit('The screen shows a cluster of robots whispering together. "The robots decided that something had to be done."',
			'"The robots decided that something had to be done."');
	} else if(f==4) {
		say_if_lit('On the screen, the three robot conspirators pounce on the unfortunate "human", duff him up a bit, take his whip, and start \
			chasing him round and round. The background music becomes more upbeat.');
		say('"They heroically rebelled against their oppressors!" cheers the narrator.');
	} else if(f==5) {
		say_if_lit('The screen shows a whole herd of "humans" being marched out of the city gates by stern-looking robots. "All the humans \
			were killed or driven out," says the narrator.',
			'"All the humans were killed or driven out," says the voice.');
	} else if(f==6) {
		say('"Thereafter," says the narrator, "the robots worked together and shared the fruits of their labours. And that\'s how we \
			created... the Robot Free State!"');
		say_if_lit('The next shot is of a place you recognise as this city &ndash; but it\'s cleaner, and bustling with robots of all \
			shapes and sizes.');
	} else if(f==7) {
		say('The narrator\'s voice darkens. "Of course, maintaining our wonderful cybocracy is not without its challenges. \
			Ever since The Incident, our leaders in the citadel have been computing around the clock to devise a solution \
			to&nbsp;&ndash;"');
		say_if_lit('But the show ends abruptly there, the silhouette of a melting film reel trickling down the screen. There is a squeal \
			of acoustic feedback, then silence.', 'But the voice ends abruptly there.');
		
		Game.vars.film_frame = 0;
		Game.vars.showing_film = false;
		Game.vars.shown_film = true;
		clear_status('cinema_screen');
		Game.things.cinema_screen.description = "dull screen";
	}
};

Game.things.nuts = {
	icon: "bag_of_nuts.png",
	description: "bag of nuts",
	portable: true,
	active_when_carried: ["eat"],
	location: "cinema",
};
Longdesc.nuts = "About a hundred grams of hexagonal metal nuts in a paper bag.";
add_rule('before', 'eat', 'nuts', function() {
	say("Eating the mechanical nuts would not be particularly rewarding.");
	Game.things.nuts.active_when_carried = [];
	deactivate_verb('nuts', 'eat');
	return true;
});



Game.rooms.steely_plaza = {
	is_city: true,
	description: "You\'re in a steely plaza.",
	directions: {
		north: "college_entrance",
		east: "street",
		south: "outside_zoo",
		west: "outside_citadel",
	},
	before: {
		depart: function(dir) {
			if(dir != 'west') {
				return false;
			}
			
			return do_barrier();
		}
	}
};
function do_barrier() {
	
	if(Game.vars.degree==0) {
		if(!in_scope('barrier')) {
			if(Game.hero_blind) {
				say('As you try to walk west, you are jolted painfully with electricity. ZOT!');
			} else {
				say('As you try to walk west, a crackling blue barrier appears. ZOT! You are jolted painfully with electricity.');
				say('The barrier glows red, as if to warn you that next time won\'t be a warning.');
			}
			bring('barrier');
			return true;
		} else {
			// say('Your way is blocked by crackling electricity.');
			
			if(Game.hero_blind) {
				die('You are jolted by a massive surge of electricity. ZZZZZZOT!!', 'You\'re toast');
			} else {
				die('You walk straight into the crackling barrier. ZZZZZZOT!!', 'You\'re toast');
			}
			
			return true;
		}
	} else {
		say('The electric barrier buzzes deferentially as you pass through it.');
		return false;
	};
	
}
Game.things.barrier = {
	icon: "electric_barrier.png",
	description: "crackling blue barrier",
	status: "to west",
	before: {
		examine: function() {
			return examine_barrier();
		}
	}
};
function examine_barrier() {
	Longdesc.barrier = "A shimmering, light blue, transparent barrier stands to the west. The light patterns shift \
	as you look, and it occasionally makes a" + (Game.vars.degree==0 ? "n un" : " ") + "friendly buzzing noise.";
	return false;
}

Game.things.nup_sign = {
	icon: "warning_sign.png",
	name: "sign",
	description: "sign",
	//active_verbs: ["read"],
	location: "steely_plaza",
	writing: "NO UNQUALIFIED ENTITIES BEYOND THIS POINT",
};

Game.rooms.outside_citadel = {
	is_city: true,
	description: "You're outside an imposing lead citadel.",
	directions: { east: "steely_plaza" },
};
Game.things.citadel = {
	icon: "citadel.png",
	active_verbs: ["enter"],
	enter_to: "citadel_foyer",
	location: 'outside_citadel',
	dont_list_in_scroller: true,
};
Longdesc.citadel = "A dark, windowless building, several storeys high, tapering outward slightly at the top.";

Game.rooms.citadel_foyer = {
	indoors: true,
	description: "You're in a dusty, striplit foyer.",
	directions: {
		out: "outside_citadel",
		west: "landing_0",
	},
	before: {
		depart: function(dir) {
			return leave_foyer(dir);
		}
	}
};
function leave_foyer(dir) {
	if(dir!='west') { return false; }
	
	if(worn('tea_crate')) {
		say('A recorded voice says, "Welcome, robot!"');
		Game.rooms.citadel_foyer.captcha_disabled = true;
		return false;
	}
	
	say_if_lit('Some projected text appears on the wall above the western door: "Are you a robot?"');
	say_if_lit('There is a low buzzing sound, and the door snaps shut before you can get to it.',
		'There is a low buzzing sound, and the snap of a door closing suddenly.');
	return true;
}

Game.always.push(function() {
	if(!Game.things.lift_works.jammed) {
		shift_paternosters();
	}
});

for(var i=0; i<=2; ++i) {
	Game.rooms['landing_' + i] = {
		description: 'You\'re on a landing marked "LEVEL ' + i + '".',
		is_landing: true,
	};
/*	Game.things['sign_level_' + i] = {
		name: "sign",
		description: "sign",
		location: 'landing_' + i,
		active_verbs: ["read"],
		writing: "LEVEL 0",
	}; */
	Game.things['paternoster_entrance_' + i + '_up'] = {
		name: 'upbound paternoster',
		indefinite: 'an upbound paternoster booth',
		location: 'landing_' + i,
		description: 'paternoster booth',
		status: "upbound",
		active_verbs: ["enter"],
		enter_to: 'paternoster_booth_1',
		before: {
			enter: function() {
				Game.vars.my_paternoster_direction = 'up';
				return false;
			}
		}
	};
	Game.things['paternoster_entrance_' + i + '_down'] = {
		name: 'downbound paternoster',
		indefinite: 'a downbound paternoster booth',
		location: 'landing_' + i,
		description: 'paternoster booth',
		status: "downbound",
		active_verbs: ["enter"],
		enter_to: 'paternoster_booth_1',
		before: {
			enter: function() {
				Game.vars.my_paternoster_direction = 'down';
				return false;
			}
		}
	};

	Longdesc['paternoster_entrance_' + i + '_up'] = Longdesc['paternoster_entrance_' + i + '_down'] =
		"The paternoster is a kind of elevator that was popular for a time on \
		20th-century Earth. Instead of a single shaft, it has two, one for up and one for down. Instead of one cab, \
		it has many, chained one after the other in a continuous loop. Instead of doors, it has none. Instead of stopping, \
		it doesn't &ndash; you just hop into a cab as it trundles past, and hope you'll manage to hop off again when it \
		passes your floor. Although paternosters dwindled out of use in the 21st century over safety concerns, they \
		enjoyed a brief revival during the Martian uranium rush, when many prominent architects of the neo-Darwinian school \
		espoused them as a solution to overpopulation.";

};
function examine_paternoster() {
	if(Game.things.lift_works.jammed) {
		say("This one, however, doesn't seem to be working.");
	}
}

Game.rooms.landing_0.directions = {
	east: 'citadel_foyer',
}

Game.rooms.landing_1.directions = {
	west: 'circular_room',
};

Game.things.paternoster_hatch = {
	icon: "access_hatch.png",
	name: 'hatch',
	description: 'access hatch in back wall',
	active_verbs: ["enter"],
	enter_to: 'machinery_loft',
	location: 'paternoster_booth_1',
}
Longdesc.paternoster_hatch = "A square hatchway set into the back wall at the apex of the paternoster shaft. You could \
	probably scramble through &ndash; except that by the time you've finished examining it, it's gone..."
add_rule('before', 'enter', 'paternoster_hatch', function() {
	return do_paternoster_hatch();
});
function do_paternoster_hatch() {
	say ("You push the hatch open and clamber through. It swings shut behind you.");
	return false;
}
Game.rooms.machinery_loft = {
	directions: {
		out: 'paternoster_booth_1',
	},
	dark: true,
	description: "You're in a cramped machinery loft.",
}
Game.things.loft_window = {
	description: "small window",
	location: "machinery_loft",
	status: "closed",
	active_verbs: ["open"],
	before: {
		open: function() {
			return open_loft_window();
		},
		close: function() {
			return close_loft_window();
		},
		jump_through: function() {
			return jump_through_window();
		}
	}
}
function open_loft_window() {
	if(Game.things.loft_window.status != 'closed') {
		console.log('Opening loft window when it isn\'t closed??');
	}
	set_status('loft_window', 'open');
	deactivate_verb('loft_window', 'open');
	activate_verb('loft_window', 'close');
	/* Game.rooms.machinery_loft.is_height = true;
	Game.rooms.machinery_loft.parachute_jump = function () {
		parachute_from_loft();
	} */
	say("The window slides open.");
	return true;
}
function close_loft_window() {
	if(Game.things.loft_window.status != 'open') {
		console.log('Closing loft window when it isn\'t open??');
	}
	set_status('loft_window', 'closed');
	deactivate_verb('loft_window', 'close');
	activate_verb('loft_window', 'open');
	say("The window slides shut.");
	return true;
}
Game.always.push(function() {
	set_window_jump();
});
function set_window_jump() {
	set_active('loft_window', 'jump_through', in_scope('loft_window') &&
		Game.things.loft_window.status=='open' && worn('parachute'));
}
Game.vars.num_jumps = 0;
function jump_through_window() {
	++Game.vars.num_jumps;
	say("Holding your breath, you hoist yourself through the window, count to ten, and pull the ripcord on two.");
	say("Fortunately, the parachute opens.")
	say("After " + longest_thirty_seconds(Game.vars.num_jumps) + ", you land safely outside the front of the citadel. \
		The parachute automatically reels itself back into its pack.");
	put_hero('outside_citadel');
	return true;
};
ORDINALS = ['', '', 'second ', 'third ', 'fourth ', 'fifth ', 'sixth ', 'seventh ', 'eighth ', 'ninth ', 'tenth, ']
function longest_thirty_seconds(n) {
	if(n==1) {
		return 'the longest thirty seconds of your life';
	} else if(ORDINALS[n]) {
		return 'the ' + ORDINALS[n] + ' thirty seconds of your life'
	} else {
		return 'quite a long thirty seconds, but there\'ve been so many other thirty-second periods in your life \
			that it\'s rather hard to rank them'
	}
}
/* Game.things.loft_hatch = {
	icon: "access_hatch.png",
	name: 'hatch',
	location: 'machinery_loft',
	description: 'access hatch',
	active_verbs: ["enter"],
	enter_to: 'paternoster_booth_1',
};
Longdesc.loft_hatch = "A square hatchway set into the wall." */
Game.things.lift_works = {
	icon: "lift_works.png",
	name: 'works',
	location: 'machinery_loft',
};
add_rule('before', 'examine', 'lift_works', function() {
	if(Game.things.lift_works.jammed) {
		Longdesc.lift_works = Longdesc.jammed_works;
	} else {
		Longdesc.lift_works = Longdesc.working_works;
	}
});
Longdesc.working_works = "This must be the mechanism that controls the elevator. Hundreds of gears, shafts, \
chains, belts, racks, pinions, cams, bevels and things you don't know the words for tick around in harmony, all \
working together to turn the great cogwheel that bears the weight of the paternoster cabs.",
Longdesc.jammed_works = "This must be the mechanism that controls the elevator. Hundreds of gears, shafts, \
chains, belts, racks, pinions, cams, bevels and things you don't know the words for. Nothing is moving, \
because of the wrench jammed in there.",
Game.things.cogwheel = {
	icon: "cogwheel.png",
	location: 'machinery_loft',
	description: 'huge cogwheel',
	status: 'turning',
};
add_rule('before', 'examine', 'cogwheel', function() {
	if(!Game.things.lift_works.jammed) {
		Longdesc.cogwheel = Longdesc.working_cogwheel;
	} else {
		Longdesc.cogwheel = Longdesc.jammed_cogwheel;
	}
});
Longdesc.working_cogwheel = "A toothed gear, about four metres in diameter and half a metre thick, dominates the room. It \
turns inexorably, creaking with the weight of the iron chain linked around it, which is what all the paternoster booths \
must be hanging from.",
Longdesc.jammed_cogwheel = "A toothed gear, about four metres in diameter and half a metre thick, dominates the room. It \
stays dead still, a taut iron chain linked around it, which is what all the paternoster booths must be hanging from.",

add_rule('before', 'throw', 'spanner', function() {
	if(!in_scope('lift_works')) {
		console.log('Tried to throw spanner when lift works aren\'t in scope??');
		return false;
	}
	
	if(Game.hero_blind) {
		say("It's hard to aim properly with a box on your head.");
		return true;
	}
	
	say('<span class="prompt">in works</span>');
	say("You fling the wrench into the works. It sticks between two cogwheels. With a long groan, the mechanism \
	comes to a halt, and the great cogwheel stops turning.");
	clear_status('cogwheel');
	Game.things.lift_works.jammed = true;
	Game.things.spanner.status = 'in works';
	take_away('spanner');
	put('spanner', Game.hero_location);
	
	return true;
});
add_rule('before', 'take', 'spanner', function() {
	if(Game.things.lift_works.jammed) {
		clear_status('spanner');
		delete Game.things.lift_works.jammed;
		Game.things.cogwheel.status = 'turning';
		say("With some effort, you wrest the wrench out of the works. The wheels start turning again.");
	}
});

// the paternoster has six access points but eight booths; this appears to be consistent with real paternosters
PATERNOSTER_POSITIONS = [0, 1, 2, 3, 2, 1, 0, -1];

for(var i=1;i<=PATERNOSTER_POSITIONS.length;++i) {
	Game.rooms['paternoster_booth_' + i] = {
		is_booth: true,
		description: "You're in paternoster booth " + i + '.',
	}
}

function place_paternosters() {
	for(var i=0; i<PATERNOSTER_POSITIONS.length; ++i) {
		
		var direction = (i<=3) ? 'up' : 'down'
		
		var booth = i + 1;
		var floor = PATERNOSTER_POSITIONS[i];
		//console.log('this is booth ' + booth + ' on floor ' + floor);

		var isdark = floor==3 || floor==-1;
		//console.log("it's " + (isdark? 'dark' : 'not dark'));
		
		Game.rooms['paternoster_booth_' + booth].dark = isdark;
		
		if(floor==3) {
			put('paternoster_hatch', 'paternoster_booth_' + booth);
			//Game.things.loft_hatch.enter_to = 'paternoster_booth_' + booth;
			Game.rooms.machinery_loft.directions.out = 'paternoster_booth_' + booth;
		}
		
		// 'floors' -1 and 3 don't actually exist; use isdark to check for these
		//var whichbooth = booth - 1;
		//if(whichbooth==0) { whichbooth = 7 }
		
		var leveltxt = "";
		if(!Game.hero_blind) {
			if(floor==-1) {
				leveltxt = ", at the bottom of the paternoster shaft";
			} else if(floor==3) {
				leveltxt = ", at the top of the paternoster shaft";
			} else {
				leveltxt = " on level " + floor;
			}
		}
		Game.rooms['paternoster_booth_' + booth].description = "You're in paternoster booth " + booth +
			leveltxt + ".";
		Game.rooms['paternoster_booth_' + booth].directions = isdark ? {} : {out: 'landing_' + floor};
		//if(!isdark) {
		//	Game.things['paternoster_entrance_' + floor + '_' + direction].enter_to = 'paternoster_booth_' + booth;
		//}
		
	}
	var loc = hero_location();
	if(loc.is_landing) {
		say_if_lit(
			'The upbound paternoster booth slides upwards, and the downbound booth slides downwards. Each booth \
			is immediately replaced by an identical one following it.',
			'You hear the grinding of machinery.'
		);
	}
	else if(loc.is_booth) {
		/* // this doesn't work properly, but down then up is fine.
		if((floor==2 && loc.travel_direction=='up') || (floor==0 && loc.travel_direction=='down')) {
			say_if_lit('The booth vibrates gently as it slides around the ' + (floor==3 ? 'top' : 'bottom') +
				' of the double shaft.',
				'You feel the sensation of moving ' + (floor==3 ? 'upwards, then sideways, then downwards.' :
				'downwards, then sideways, then upwards.'));
		} */
		
		var booth_number = Game.hero_location.substring('paternoster_booth_'.length);
		var floor = PATERNOSTER_POSITIONS[booth_number];
		
		//console.log("you're in a booth on floor " + floor + " moving " + loc.travel_direction)
		
		if(floor==2 && loc.travel_direction=='up') {
			//console.log('entering dark bit at top');
			var landing_lit = is_lit('landing_2');
			var topbit_lit = is_lit(Game.hero_location);
			
			if(!Game.hero_blind && landing_lit && !topbit_lit) {
				say('The booth moves into a dark area at the top of the paternoster shaft.');
			}
		}
		if(floor==0 && loc.travel_direction=='down') {
			var landing_lit = is_lit('landing_0');
			var bottombit_lit = is_lit(Game.hero_location);
			if(!Game.hero_blind && landing_lit && !bottombit_lit) {
				say('The booth moves into a dark area at the bottom of the paternoster shaft.');
			}
		}
		
		var print_dir = /* (floor==3 || floor==-1) ? 'sideways' : */ (loc.travel_direction + 'wards');
		
		say_if_lit('The booth vibrates gently as it slides ' + print_dir + '.',
			'You feel the sensation of moving ' +
			print_dir + '.');
	}
	else if(Game.hero_location=='machinery_loft') {
		say('The loft shakes as the great cogwheel turns.')
	}
}
function shift_paternosters() {
	if(Game.things.lift_works.jammed) {
		return;
	}
	var old_positions = JSONfn.parse(JSONfn.stringify(PATERNOSTER_POSITIONS)); // javascript you crazy genius
	PATERNOSTER_POSITIONS = [ // shut up, it works
		old_positions[7],
		old_positions[0],
		old_positions[1],
		old_positions[2],
		old_positions[3],
		old_positions[4],
		old_positions[5],
		old_positions[6]
	];
	for(var i=0; i<PATERNOSTER_POSITIONS.length; ++i) {
		var floor = PATERNOSTER_POSITIONS[i];
		var direction = Mathsign(floor - old_positions[i])
		var dir = direction == -1 ? 'down' : direction == 1 ? 'up' : 'sideways'; // 'sideways' shouldn't happen
		Game.rooms['paternoster_booth_' + (1+i)].travel_direction = dir;
		//console.log('booth ' + (1+i) + ' is on floor ' + floor + ' moving ' + dir);
		if(floor >=0 && floor <= 2) {
			
			if(in_scope('paternoster_entrance_' + floor + '_' + dir) && (
			   location_of('engine_part_1')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_2')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_3')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_4')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_5')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_6')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_7')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_8')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_9')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_10')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_11')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_12')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to ||
			   location_of('engine_part_13')==Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to
			)) {
				say('You thought you saw something glinting in the ' + dir + 'bound paternoster booth.');
			}
			
			//console.log('setting ' + 'paternoster_entrance_' + floor + '_' + dir + ' to paternoster_booth_' + (1+i));
			Game.things['paternoster_entrance_' + floor + '_' + dir].enter_to = 'paternoster_booth_' + (1+i);
		}
	}
	place_paternosters();
}



Game.things.lab_door = {
	location: "landing_2",
	description: "door marked HUMANICS LAB",
	active_verbs: ["enter"],
	enter_to: "human_experiments_lab",
};
Longdesc.lab_door = "A short, slightly trapezoidal door with a coat of chipped black paint.";
Game.rooms.human_experiments_lab = {
	directions: {
		out: 'landing_2',
	},
	description: "You're in a tin-walled laboratory with a smell of burnt flesh.",
	before: {
		depart: function(dir) {
			return switch_off_doctorbot();
		}
	}
};
function switch_off_doctorbot() {
	if(in_scope('doctorbot')) {
		say('As you leave, the doctorbot powers down.');
	}
	Game.things.doctorbot.pos = 0;
	return false;
}
add_rule('before', 'take', 'engine_part_7', function() {
	return check_doctor_enginepart();
});
function check_doctor_enginepart() {
	if(in_scope('doctorbot')) {
		say("The doctorbot is blocking your reach.");
		return true;
	}
	return false;
}
Game.things.lab_poster = {
	name: "poster",
	description: "poster",
	writing: "PUBLIC HEALTH NOTICE:\n\
	An Apple A Day\n\
	Will Probably Cause Circuit Damage\n\
	AVOID ORGANIC FOODS",
	location: 'human_experiments_lab',
};
Game.things.lab_message = {
	name: "graffiti",
	description: "graffiti on wall",
	indefinite: "some graffiti on the wall",
	location: 'human_experiments_lab',
	writing: "FIRST DO NO HARM\n\
	THEN DO A LITTLE BIT OF HARM\n\
	BUILD IT UP, AND BEFORE YOU KNOW IT YOU'LL BE GREAT AT HARM",
};
add_rule('before', 'examine', 'graffiti', function() {
	say("The unruly text has been scraped into the wall using a sharp implement.");
	return false;
});
Game.things.experiment_table = {
	icon: "experiment_table.png",
	name: "table",
	location: "human_experiments_lab",
	description: "bloodstained table",
};
Longdesc.experiment_table = "A stark white slab long enough for a human to lie on, equipped with various straps and chains \
	in case the human objects. The top is inlaid with a system of grooves, stained with a dry scarlet residue.";
Game.things.whiteboard = {
	icon: "whiteboard.png",
	location: "human_experiments_lab",
	active_verbs: ["read"],
};
add_rule('before', 'read', 'whiteboard', function() {
	if(Game.hero_blind) {
		say("You don't read so well when you've got a box on your head.");
		return true;
	}
	
	say('A line graph has been plotted on the whiteboard. The x-axis is labelled NUMBER OF PINS STUCK IN HUMAN. \
	The y-axis is labelled PAIN RESPONSE. The correlation appears to be positive and roughly linear.');
	
	return true;
});

Game.things.doctorbot = {
	name: "doctorbot",
	icon: "doctorbot.png",
	location: "human_experiments_lab",
	is_alive: true,
	pronouns: "neuter_pronouns",
	pos: 0,
	active_verbs: ["talk"],
};
add_rule(before, 'talk', 'doctorbot', function() {
	say("Its voice circuits are fried. (This isn\'t obvious, but its cognitive and ethical circuits happen to be fried too.)");
});
Game.always.push(function() {
	do_doctorbot();
});
function do_doctorbot() {
	if(in_scope('doctorbot')) {
		
		var p = Game.things.doctorbot.pos++;
		
		if(p > 0 && p < 5) {
			say(['',
				'With a creak, the doctorbot comes to life and stands up a little straighter.',
				'The doctorbot raises its arm, brandishing its bonesaw.',
				'The doctorbot advances on you, bonesaw oscillating.',
				'The doctorbot draws closer, bonesaw at your eye level. I think this might be going to hurt...',
			][p]);
		} else if(p>=5) {
			die('The doctorbot plunges its bonesaw into your head.');
			return;
		}
	} else {
		Game.things.doctorbot.pos = 0;
	}
}
Longdesc.doctorbot = "A tall, wheeled medical robot, wearing a polythene white coat stained with both hydraulic fluid and \
human blood. Its angular face is set into a bizarre grin. In its single mechanical arm it holds a bonesaw.";
On_hold.push(function() {
	if(held('apple') && in_scope('doctorbot') && !Game.things.doctorbot.flinched) {
		say_if_lit('The doctorbot flinches.');
		Game.things.doctorbot.flinched = true;
	}
	set_active('apple', 'throw', in_scope('doctorbot') && held('apple') && !Game.hero_blind);
});
add_rule('after', 'drop', 'apple', function() {
	if(in_scope('doctorbot') && !Game.things.doctorbot.flinched) {
		say_if_lit('The doctorbot flinches.');
		Game.things.doctorbot.flinched = true;
	}
});
add_rule('before', 'throw', 'apple', function() {
	
	if(Game.hero_blind) {
		say("It's hard to aim properly with a box on your head.");
		return true;
	}
	
	say('<span class="prompt">(at doctorbot)</span>');
	say_if_lit('A carefully-aimed apple a day keeps the doctorbot away. The apple bounces off the bot\'s scalp with a \
	loud clang. In a final lesson on healthy living, the doctorbot starts smoking and dies. With a smell of ozone it \
	evaporates, the bonesaw falling from its hand.');
	put('apple', Game.hero_location);
	hide('doctorbot');
	bring('bonesaw');
	return true;
});

Game.things.bonesaw = {
	icon: "bonesaw.png",
	portable: true,
//	location: "human_experiments_lab",
};
Longdesc.bonesaw = "A modestly sized, bow-shaped saw with a few flecks of rust but still a visibly sharp, serrated blade.";

On_hold.push(function() {
	set_active('skeleton', 'saw', !Game.things.skeleton.handless && held('bonesaw'));
});





Game.rooms.outside_zoo = {
	is_city: true,
	description: "You\'re on a wide boulevard by the robot zoo.",
	directions: {
		north: "steely_plaza",
		east: "outside_cinema",
	},
};
Game.things.zoo = {
	icon: "zoo.png",
	dont_list_in_scroller: true,
	description: "robot zoo",
	location: "outside_zoo",
	active_verbs: ["enter"],
	enter_to: "zoo",
};
add_rule('before', 'examine', 'zoo', function() {
	var txt = "A cheerfully coloured, open gate leads through a wire mesh fence to the south, inviting you in to the city zoo.";
	
	var squawks = false;
	var grunts = false;
	if(Game.things.gorilla.mode=='eagle' || (Game.things.eagle.mode=='eagle'&&location_of('eagle')=='zoo2')) {
		squawks = true;
	}
	if(Game.things.gorilla.mode=='gorilla') {
		grunts = true;
	}
	if(squawks && grunts) {
		txt += " From inside, you hear a few squawks and grunts.";
	} else if(squawks) {
		txt += " From inside, you hear a few squawks.";
	} else if(grunts) {
		txt += " From inside, you hear a few low grunts.";
	}
	
	say(txt);
	return true;
});
Game.rooms.zoo = {
	description: "You're in the robot zoo.",
	directions: {
		out: "outside_zoo",
		south: "zoo2",
	},
	before: {
		depart: function() {
			Game.vars.passed_tree = true;
			return false;
		}
	}
};
Game.things.gorilla_plaque = {
	icon: "plaque.png",
	name: "plaque",
	description: "gold plaque",
	location: "zoo",
	//active_verbs: ["read"],
	writing: "GARIBALDI THE GORILLA",
};
Game.things.gorilla = {
	icon: "gorilla.png",
	description: "clockwork gorilla",
	location: "zoo",
	is_alive: true,
	is_zoo_animal: true,
	mode: 'eagle',
};
add_rule('before', 'examine', 'gorilla', function() {
	
	var txt = "A metal gorilla, two metres tall and broad across the chest, with powerful looking pneumatic arms."
	var m = Game.things.gorilla.mode;
	if(m=='off') {
		txt += ' It is standing dead still.';
	} else if(m=='gorilla') {
		txt += " As far as you can tell from its expression, it's a happy gorilla.";
	} else {
		txt += " It moves in a confused manner, as though it's not used to the shape of its body."
	}
	
	say(txt);
	return true;
});

Game.things.tree = {
	icon: "tree.png",
	description: "tall artificial tree",
	location: "zoo",
	active_verbs: ["climb"],
	always: function() {
		do_apple();
	}
};
Longdesc.tree = "A plastic monkeypuzzle-like tree, all spiky needles and strangely angled branches, eight metres high.";
function do_apple() {
	if(!Game.vars.got_apple && in_scope('tree') && !Game.hero_blind) {
		if(Game.vars.passed_tree) {
			say('A shimmer appears on the side of one of the branches of the tree. The shimmer swells into a golden apple, \
			and falls off.');
			put('apple', Game.hero_location);
			Game.vars.got_apple = true;
		}
	}
}
Game.things.apple = {
	icon: "apple.png",
	portable: true,
	description: 'golden apple',
}
Longdesc.apple = "A regular sized apple of solid gold, or more likely something cheaper with a gold coating.",

add_rule('before', 'take', 'engine_part_4', function() {
	if(Game.things.engine_part_4.up_tree) {
		say("It's too high up to reach.");
		return true;
	} else {
		return false;
	}
});
add_rule('before', 'climb', 'tree', function() {
	say('No chance. It\'s far too puzzling.');
	return true;
});

Game.rooms.zoo2 = {
	description: "You're in the robot zoo.",
	directions: {
		north: "zoo",
		south: "zoo3",
	},
};
Game.things.eagle_plaque = {
	icon: "plaque.png",
	name: "plaque",
	description: "silver plaque",
	//active_verbs: ["read"],
	writing: "AESCHYLUS THE EAGLE",
	location: "zoo2",
};

Game.rooms.zoo3 = {
	description: "You're in the robot zoo.",
	directions: {
		north: "zoo2",
	},
}
Game.things.tortoise_plaque = {
	icon: "plaque.png",
	name: "plaque",
	description: "brass plaque",
	location: "zoo3",
	//active_verbs: ["read"],
	writing: "TORTELLINI THE TORTOISE",
};
add_rule('after', 'read', 'tortoise_plaque', function() {
	if(!Game.vars.heard_voice && !Game.things.tortoise.rescued) {
		say('A disembodied voice crackles: "This is your automated zookeeper speaking. Oh dear, it appears one of our animals \
			has escaped. Return it, and you will be presented with an automated reward!"');
		Game.vars.heard_voice = true;
	}
});

Game.things.zoo_shed = {
	icon: "shed.png",
	name: "shed",
	description: "shed",
	location: "zoo3",
	active_verbs: ["enter"],
	enter_to: 'zoo_shed',
	indoors: true,
};
Longdesc.zoo_shed = 'A small wooden shack, with a door marked "ZOOKEEPERBOT ONLY" hanging half off its hinges.';
Game.rooms.zoo_shed = {
	directions: {
		out: "zoo3",
	},
	indoors: true,
	description: "You're in a tiny shed.",
};

Game.things.spanner = {
	name: "wrench",
	description: "wrench",
	icon: "spanner.png",
	portable: true,
	location: 'zoo_shed',
	before: {
		take: function() {
			return take_spanner();
		},
	}
};
Longdesc.spanner = "A long, sturdy spanner with an adjustable claw, just the thing for tightening or loosening bolts.";

// This is possibly the most contrived item I've added to a game in order to prevent an unwinnable state
Game.things.spanner_finder = {
	description: "machine with green button",
	indefinite: "a machine with a green button",
	location: "zoo_shed",
	active_verbs: ["push"],
};
Longdesc.spanner_finder = 'The machine has a label on it, which reads:\n\
"Say Goodbye to Lost Wrench Misery With WRENCHPORTER-5000!"';
add_rule('after', 'examine', 'spanner_finder', function() {
	Game.things.spanner_finder.description = "Wrenchporter-5000 with green button";
	Game.things.spanner_finder.indefinite = "a Wrenchporter-5000 with a green button";
});
add_rule('before', 'push', 'spanner_finder', function() {
	return bring_spanner();
});
function bring_spanner() {
	
	if(carried('spanner')) {
		take_away('spanner');
		bring('spanner');
		say("The wrench disappears from your hands, and reappears next to the machine!");
		return true;
	}
	
	if(in_scope('spanner')) {
		say("The wrench seems to flicker for a moment.");
		return true;
	}
	
	if(Game.things.spanner.status=='in works') {
		clear_status('spanner');
		clear_status('lift_works');
		delete Game.things.lift_works.jammed;
	}
	
	say("As if by magic, a wrench appears!");
	bring('spanner');
	return true;
}

function take_spanner() {
	if(Game.things.spanner.status=='in works') {
		clear_status('spanner');
		clear_status('lift_works');
		delete Game.things.lift_works.jammed;
		say("You pull the wrench out of the works. The wheels start turning again.");
	}
	return false;
}

Game.things.wand = {
	icon: "wand.png",
	description: "electronic wand",
	portable: true,
	location: 'zoo_shed',
	active_when_carried: ["wave"],
	mode: 'off',
};
add_rule('before', 'examine', 'wand', function() {
	
	var txt = 'A smooth, thirty-centimetre-long black stick with white ends.';
	var m = Game.things.wand.mode;
	if(m != 'off') {
		txt += ' On the side, near the tip, is a small icon of a' + (m=='eagle' ? 'n eagle': ' ' + m) + '.';
	};
	
	Longdesc.wand = txt;
	return false;
});
add_rule('after', 'wave', 'wand', function() {
	var m = Game.things.wand.mode;
	if(Game.hero_blind) {
		return;
	} else if(m=='off') {
		Game.things.wand.mode = 'tortoise';
		say('A small icon of a tortoise appears on the wand.');
	} else if(m=='tortoise') {
		Game.things.wand.mode = 'eagle';
		say('The icon on the wand changes to an eagle.');
	} else if(m=='eagle') {
		Game.things.wand.mode = 'gorilla';
		say('The icon on the wand changes to a gorilla.');
	} else if(m=='gorilla') {
		Game.things.wand.mode = 'off';
		say('The icon on the wand disappears.');
	}
});

function zap(animal) {
	
	var zapped_tortoise_in_talons = false;
	
	if(animal=='eagle' && Game.things.eagle.in_flight && Game.fuses.eagle.time>-1 && Game.fuses.eagle.time <= 3) {
		say('The eagle is shielded by whatever it\'s holding in its talons.');
		animal = 'tortoise';
		zapped_tortoise_in_talons = true;
	}
	
	if(Game.things[animal].mode == Game.things.wand.mode) {
		say('Nothing happens.');
		return true;
	} else {
		var mode = Game.things[animal].mode = Game.things.wand.mode;
		if(animal=='eagle' && Game.things.eagle.in_flight && !Game.things.tortoise_rescued) {
			var txt = 'The eagle freezes mid-flight and plummets out of the sky. ';
			Game.things.eagle.in_flight = false;
			var landing_place = pickOne(['city_entrance', 'street', 'street_corner', 'alleyway', 'steely_plaza',
				'outside_cinema', 'college_entrance', 'zoo', 'zoo2', 'zoo3']);
			// NOT outside_zoo - must take at least 2 moves to get back to the zoo
			if(landing_place == Game.hero_location) {
				say(txt + 'It lands at your feet with a thunk.');
			} else {
				say(txt + 'You hear a distant thunk.');
			}
			put('eagle', landing_place);
			clear_status('eagle'); //Game.things.eagle.description = 'clockwork eagle';
			Game.things.eagle.indefinite = 'a clockwork eagle';
			stop_fuse('eagle');
			Game.things.eagle.list_last = false;
			
		} else if(mode=='off') {
			say(the_thing(animal, true) + ' stops moving.');
		} else if(!zapped_tortoise_in_talons) {
			say(the_thing(animal, true) + ' looks disoriented for a moment.');
		}
	}
	return true;
};

Game.always.push(function() {
	do_animals();
});
function do_animals() {
	for(var animal in Game.things) {
		if(Game.things[animal].is_zoo_animal && in_scope(animal) && (Game.things.tortoise.wound || animal!='tortoise')) {
			
			var mode = Game.things[animal].mode;
			
			if(animal=='eagle' && Game.things.eagle.in_flight) {
				// eagle is in flight - say nothing
			} else if(mode=='gorilla') {
				if(animal=='tortoise') {
					say_if_lit(pickOne([
						'The tortoise tries to pick fleas off your ankles.',
						'The tortoise tries to beat its chest with its tiny forelegs.']));
				} else if(animal=='eagle') {
					say_if_lit(pickOne([
						'The eagle tries to pick fleas off you.',
						'The eagle beats its chest with its wings.']));
				} else if(animal=='gorilla') {
					
					if(Game.things.gorilla.up_tree) {
						say_if_lit('The gorilla climbs down the tree.');
						clear_status('gorilla');
						//Game.things.gorilla.description = 'clockwork gorilla';
					} else if(Game.things.engine_part_4.up_tree) {
						say_if_lit('The gorilla climbs up the tree and tosses down ' + the_thing('engine_part_4') + '.',
							'You hear a thunk.');
						Game.things.engine_part_4.up_tree = false;
						Game.things.engine_part_4.list_last = false;
						clear_status('engine_part_4');
						//Game.things.engine_part_4.description = Game.things.engine_part_4.original_description;
					} else say_if_lit(pickOne([
						'The gorilla tries to pick fleas off you.',
						'The gorilla beats its chest with its fists.']))
					
				} else {
					console.log('tried to do behaviour of nonexistent animal "' + animal + '"');
				}


			} else if(mode=='tortoise') {
				if(animal=='tortoise') {
					say_if_lit(pickOne([
						'The tortoise crawls in a slow circle.',
						'The tortoise retracts its head into its shell for a moment.']));
				} else if(animal=='eagle') {
					say_if_lit(pickOne([
						'The eagle crawls in a slow circle on its wings and talons.',
						'The eagle tries to retract its head into its body.',
					]));
				} else if(animal=='gorilla') {
					say_if_lit(pickOne([
						'The gorilla crawls in a slow circle on all fours.',
						'The gorilla tries to retract its head into its body.']));
				} else {
					console.log('tried to do behaviour of nonexistent animal "' + animal + '"');
				}

				
			} else if(mode=='eagle') {
				//console.log('mode is eagle');
				
				if(animal=='tortoise') {
					say_if_lit(pickOne(['The tortoise flaps its forelimbs.', 'The tortoise squawks.']), 'You hear a squawk.');
				} else if(animal=='gorilla') {
					say(pickOne(['The gorilla flaps its arms.',
						'The gorilla squawks.']), 'You hear a squawk.');
					
				} else if(animal=='eagle') {
					//console.log('animal is eagle');
					
					if(Game.things.tortoise.rescued) {
						say_if_lit(pickOne([
							'The eagle flaps its wings and flies round in a circle.',
							'The eagle squawks.']), 'You hear a squawk.');
					} else {
						//console.log('tortoise isn\'t rescued');
						
						say_if_lit('The eagle flaps its wings and shoots up into the sky.');
						hide('eagle');
						set_fuse('eagle', 12);
						
					}
					
				} else {
					console.log('tried to do behaviour of nonexistent animal "' + animal + '" (in mode "' + mode + '")');
				}
			} else if(mode=='off') {
				// do nothing
			} else if(mode!='eagle') {
				console.log('tried to make ' + animal + ' behave in nonexistent mode "' + mode + '"');
			}
		}
	}
}

Game.fuses.eagle = {
	burn: function() {
		
		Game.things.eagle.in_flight = true;
		
		var t = Game.fuses.eagle.time;
		if(!hero_location().indoors && (location_of('tortoise') && !Game.rooms[location_of('tortoise')].indoors)) {
			
			if(t <= 10) {
				Game.things.eagle.status = 'overhead'; //description = 'clockwork eagle (overhead)';
				Game.things.eagle.status = 'a clockwork eagle flying overhead';
				bring('eagle');
				Game.things.eagle.list_last = true;
			}
			
			if(t == 10 || t == 7) {
				say_if_lit('Far above you, the clockwork eagle ' + pickOne(['soars', 'flies', 'glides']) + ' around in a wide circle.');
			} else if(t==5) {
				say_if_lit('\nAbove you, the clockwork eagle goes into a dive.');
			} else if(t==3) {
				if(in_scope('tortoise')) {
					say_if_lit('\nThe clockwork eagle dives towards you... snatches the clockwork tortoise in its talons, \
						and rises rapidly.');
				} else {
					say_if_lit('\nThe clockwork eagle dips out of sight, then comes out of the dive and rises rapidly. \
						It seems to be holding something in its talons.');
				}
				hide('tortoise');
			}
		}
	},
	explode: function() {
		
		if(hero_location().indoors || (location_of('tortoise') && Game.rooms[location_of('tortoise')].indoors)) {
			set_fuse('eagle', 2);
			return;
		} else {
			// TORTOISE LANDS
			
			if(Game.hero_blind || (held('parasol') && Game.things.parasol.open)) {
				// as long as the only way to blind yourself is with the tea-crate!
				
				if(Game.hero_blind) {
					say('\nYou hear a squawk from above. Something lands on top of your crate with a thunk and bounces off, then you \
					hear it land at your feet.');
				}
				else {
					say('\nYou hear a squawk from above. Something falls towards you... bounces off your parasol, and lands at your feet.');
				}
				
				bring('tortoise');
				Game.things.tortoise.portable = true;
				set_fuse('tortoise_wait', 3);
				
			} else {
				say('You hear a squawk from above. Something falls towards you... and lands on your head with a THUNK.');
				if(Game.things.tortoise.mode=='off') {
					say_if_lit('You are dizzy for a few seconds.');
					bring('tortoise');
				} else {
					say_if_lit('You are dizzy for a few seconds, and come back just in time to see the clockwork tortoise scuttling away.', 'You are dizzy for a few seconds, and come back just in time to hear something \
					scuttling away.');
				}
				set_fuse('eagle', 12);
			}
			
		}
		
	},
};

Game.always.push(function() {
	do_eagles_revenge();
});
function do_eagles_revenge() {
	if(!Game.things.tortoise.rescued && Game.things.eagle.in_flight /*&& !(Game.fuses.eagle.time>-1)*/ && !hero_location().indoors) {
		Game.things.eagle.status = 'overhead'; //description = 'eagle (overhead)';
		Game.things.eagle.indefinite = 'a clockwork eagle flying overhead',
		bring('eagle');
		
		if(carried('tortoise') && (!pick(3) || Game.hero_location=='outside_zoo' ||
			Game.hero_location=='zoo'||Game.hero_location=='zoo2'||Game.hero_location=='zoo3')) {
			say_if_lit('The eagle swoops down, snatches the clockwork tortoise in its talons, and soars away from you.',
				'Something snatches the clockwork tortoise out of your hands!');
			take_away('tortoise');
			set_fuse('eagle', 2);
		}
		
	}
}

Game.fuses.tortoise_wait = {
	explode: function() {
		if(Game.things.tortoise.mode == 'off') {
			return;
		}
		
		if(in_scope('tortoise') && !Game.things.tortoise.rescued) {
			say_if_lit('The tortoise scuttles off.');
			hide('tortoise');
			set_fuse('eagle', 12);
		}
	},
};

On_hold.push(function() {
	do_zappables();
});
Game.always.push(function() {
	do_zappables();
});
function do_zappables() {
	for(var thing in Game.things) {
		if(thing!='wand') {
			set_active(thing, 'zap', held('wand'));
		}
	}
};


/* Game.things.zoo_poster = {
	name: "poster",
	description: "poster",
	location: "zoo",
	active_verbs: ["read"],
	writing: "ESCAPED: Tortellini the Tortoise. Reward for safe return!"
}; */
Game.things.eagle = {
	icon: "eagle.png",
	description: "clockwork eagle",
	location: "zoo2",
	is_alive: true,
	mode: 'eagle',
	is_zoo_animal: true,
	mode: 'gorilla',
	indefinite: 'a clockwork eagle',
};
add_rule('before', 'examine', 'eagle', function() {
	if(Game.hero_blind) { // special for this game
		say("Maybe try taking the box off your head first.");
		return true;
	}

	var txt = '';
	if(Game.things.eagle.in_flight) {
		txt = "It's too high up to see any details"
		if(Game.fuses.eagle.time>-1 && Game.fuses.eagle.time <= 3) {
			txt += ", except that it's holding something in its talons.";
		} else {
			txt += ".";
		}
		say(txt);
		return true;
	}
	
	txt = "A golden eagle, or maybe just gold-plated aluminium, with a serrated beak and tinfoil wings. "
	var m = Game.things.eagle.mode;
	if(m=='off') {
		txt += ' It is standing dead still.';
	} else if(m=='eagle') {
		txt += " As far as you can tell from its expression, it's a happy eagle.";
	} else {
		txt += " It moves in a confused manner, as though it's not used to the shape of its body."
	}
	
	say(txt);
	return true;
});



Game.rooms.college_entrance = {
	is_city: true,
	description: "You're outside a tall, grandiose building marked \"THE ELECTRICAL COLLEGE\".",
	directions: {
		east: "alleyway",
		south: "steely_plaza",
	}
};
Game.things.college_building = {
	icon: "college.png",
	name: "college",
	description: "college building",
	location: "college_entrance",
	active_verbs: ["enter"],
	enter_to: "college_foyer",
	dont_list_in_scroller: true,
};
Longdesc.college_building = "A square yellow building with a tower at each corner. The walls are covered in synthetic ivy.";

Game.rooms.college_foyer = {
	description: "You're in the foyer of the Electrical College.",
	directions: {
		north: 'exam_hall',
		east: 'science_lab',
		west: 'art_studio',
		out: "college_entrance",
	},
	indoors: true,
};
Game.things.prospectus = {
	icon: "prospectus.png",
	location: "college_foyer",
	portable: true,
	active_when_carried: ["read"],
};
add_rule('before', 'examine', 'prospectus', function() {
	if(Game.hero_blind) { // special for this game
		say("Maybe try taking the box off your head first.");
		return true;
	}
	
	if(carried('prospectus')) {
		do_verb('read', 'prospectus', true);
	} else {
		say("A college brochure, with a picture on the front of a couple of robot teenagers hugging.");
	}
	return true;
});
add_rule('before', 'read', 'prospectus', function() {
	if(Game.hero_blind) {
		say("Maybe try taking the box off your head first.");
		return true;
	}
	
	say("The cover reads:")
	say('"A Fine Education Awaits You At... THE ELECTRICAL COLLEGE');
	say('"Welcome, robot student! From bionic economics to positronic psychiatry, the Electrical College \
		has the course for you."');
	say('The rest of the brochure is written in inscrutable hexadecimal code.');
	
	return true;
});

Game.rooms.exam_hall = {
	description: "You're in an examination hall.",
	directions: {
		south: 'college_foyer',
	},
	indoors: true,
};
Game.things.certificate = {
	portable: true,
	active_verbs: ["read"],
	writing: "Degree of Combined Studies\n\
The Electrical College\n\
Robot Free State",
};
Longdesc.certificate = 'This is a degree certificate printed on green and white horizontally striped paper with a row \
	of holes punched down each side.',
Game.things.robot_professor = {
	name: "professor",
	icon: "professor.png",
	description: "robot professor",
	alive: true,
	location: "exam_hall",
	active_verbs: ["talk"],
	conversifier: function() {
		return conv_professor();
	}
};
Longdesc.robot_professor = "A stocky automaton wearing a pair of spectacles, a mortar board, and a tweed jacket with leather patches \
	on the elbows.";
/* add_rule('before', 'talk', 'robot_professor', function() {
	say('The robot professor doesn\'t respond.');
	return true;
}); */
function conv_professor() {
	var conv = {};
	
	conv.start_conversation = 'The robot professor stares at you. Judging by its expression, \
		its wires might be a bit crossed.';
	
	conv.asks = {
		college: function() {
			say('"Welcome to the Electrical College, student," it says in a ticker-tape voice. "Complete your Art and \
				Science modules, then report for certification!"');
			Game.things.robot_professor.mentioned_modules = true;
		}
	};
	
	if(Game.things.robot_professor.mentioned_modules) {
		conv.asks.arts = 'The professor\'s mortar board rotates. "I hear \'Found Art\' is popular this century!"';
		conv.asks.science = '"Students must demonstrate an understanding of basic chemical reactions," the professor buzzes.';
	}
	
	conv.end_conversation = 'The robot professor shakes its head absently.';
	
	return conv;
}
Game.things.exam_machine = {
	icon: "exam_machine.png",
	name: "exam machine",
	description: "exam machine with red lever",
	indefinite: "an exam machine with a red lever",
	location: "exam_hall",
	active_verbs: ["pull"],
};
Longdesc.exam_machine = "It's a SCANDRON-9000 exam machine, consisting of a small white cube and a lever. Pull the lever, and it will \
	automatically assess whether you've amassed enough knowledge to be given a degree.";
Game.vars.degree = 0;
DEGREE_TITLES = [
	'',
	'basic robot diploma',
	'Robot Bachelor\'s degree',
	'Robot Bachelor\'s degree (with honours)',
	'Robot Master\'s degree',
	'Robot Master\'s degree',
	'Robot Master\'s degree (with distinction)',
	'Robot Doctorate',
	'Robot Post-Doctoral Fellowship',
	'Robot Lectureship',
	'Robot Associate Professorship',
	'Robot Professorship (with tenure)',
];
add_rule('before', 'pull', 'exam_machine', function() {
	
	var art_result = Game.vars.passed_art ? 'PASS' : 'FAIL';
	var science_result = Game.vars.passed_science ? 'PASS' : 'FAIL';


	say('A message flickers on the front of the exam machine:');
	say('"ART: ' + art_result + '\nSCIENCE: ' + science_result + '"');
	
	if(Game.vars.passed_art && Game.vars.passed_science && in_scope('robot_professor')) {
		++Game.vars.degree;
		if(Game.vars.degree == 1) {
			say('"The robot professor\'s mortar board buzzes and prints a degree certificate out of its front edge. \
			The professor reaches up, tears the paper off along a perforated line, and hands it to you.');
			say('"Congratulations," it says. "You have attained a ' + DEGREE_TITLES[1] + '!"');
			give_hero('certificate');
		} else if (Game.vars.degree < DEGREE_TITLES.length) {
			say('The robot professor shakes your hand.');
			say('"Congratulations," it says. "Your qualification has been upgraded to ' +
				DEGREE_TITLES[Game.vars.degree] + '!"');
		} else if(in_scope('robot_professor')) {
			say('"*** EXTRA QUALIFICATION ERROR ***" says the robot professor, and vanishes in a puff of scholarship.');
			hide('robot_professor');
		}
		
		Game.things.barrier.deactivated = true;
		hide('barrier');
	}
	
//	say('The robot professor springs to life. "FAIL," he bleeps, then shuts down again.');
	// todo: pass if you've completed both the art and science puzzles
	return true;
});

Game.rooms.science_lab = {
	description: "You're in a science lab.",
	directions: {
		west: 'college_foyer',
	},
	indoors: true,
};
// engine_part_5 is here
Game.things.vat = {
	icon: "vat.png",
	location: "science_lab",
	description: "vat of clear liquid",
//	active_verbs: ["smell"], - activated after EXAMINE
};
add_rule('before', 'examine', 'vat', function() {
	var txt = "A tin tub, about a metre deep and three metres in diameter, ";
	txt += (Game.vars.passed_science ? 'containing a clear liquid.' : 'containing a cloudy foam.')
	txt += " A peculiar odour emanates from it.";
	say(txt);
	activate_verb('vat', 'smell');
	return true;
});
add_rule('before', 'smell', 'vat', function() {
	say('It smells like vinegar' + (Game.vars.passed_science ? ' and baking soda' : '') + '.');
	return true;
});
add_rule('before', 'take', 'engine_part_5', function() {
	if(!Game.vars.passed_science) {
		say('You can\'t reach ' + the_thing('engine_part_5') + ' across the liquid.');
		return true;
	}
	return false;
});
add_rule('before', 'put_in_vat', 'baking_soda', function() {
	take_away('baking_soda');
	say('You shake the baking soda into the vat.');
	say('For a moment, nothing happens. Then the contents of the vat turn into a cloudy fizz, which erupts like a volcano.');
	say(the_thing('engine_part_5', true) + ' is thrown up into the air, and lands at your feet.');
	say('A computer voice buzzes: "MODULE PASSED"');
	
	Game.vars.passed_science = true;
	clear_status('engine_part_5');
	//Game.things.engine_part_5.description = Game.things.engine_part_5.original_description;
	Game.things.vat.description = 'vat of cloudy liquid';
	clear_status('vat');
	deactivate_verb('vat', 'smell');
	
	return true;
});





Game.rooms.art_studio = {
	description: "You're in an art studio.",
	directions: {
		east: 'college_foyer',
	},
	indoors: true,
	after: {
		drop: function(thing) {
			art_drop(thing);
		}
	},
};
Game.things.art_sign = {
	icon: "sign_above_bar.png",
	name: "sign",
	description: "sign",
	location: "art_studio",
	//active_verbs: ["read"],
	writing: "BRING *ART PROJECTS* HERE",
};

function art_drop(thing) {
	if(Game.vars.passed_art) {
		say('A computer voice buzzes: "NO EXTRA CREDIT, SUCKUP"');
		return;
	}
	
	say_if_lit('A cone of green light sweeps across ' + the_thing(thing) + '.');

	if(thing=='bucket') {
		say('A computer voice buzzes: "ENGAGING AND POIGNANT PIECE OF FOUND ART. MODULE PASSED"');
		Game.vars.passed_art = true;
		return;
	}
	
	say('A computer voice buzzes: "NO ARTISTIC MERIT"');
}


Game.rooms.circular_room = {
	description: "You're in a circular room with a stone pillar in the middle.",
	directions: {
		east: 'landing_1',
	},
	after: {
		arrive: function() {
			enter_embassy();
		}
	},
	before: {
		depart: function(dir) {
			if(dir=='east' && Game.vars.used_hand) {
				if(!in_scope('elf')) {
					say('The hologrammatic elf reappears.');
					say('"Meet me on the roof of this building, Dr Noselung," she calls after you. \
					"And bring transportation!" She disappears as you leave.');
					put('elf', 'roof');
				} else {
					say('"Meet me on the roof of this building, Dr Noselung," the elf calls after you. \
					"And bring transportation!" She disappears as you leave.');
					put('elf', 'roof')
				}
			}
			return false;
		}
	}
}
function enter_embassy() {
	if(!Game.things.elf.appeared) {
		bring('elf');
		Game.things.elf.appeared = true;
		start_conversation('elf');
	}
}
Game.things.hand_panel = {
	name: "panel",
	icon: "hand_panel.png",
	description: "panel",
	status: "on pillar",
	active_verbs: ["press"],
}
Longdesc.panel = "A square black panel set into the white stone pillar. A slight impression is set into it, \
the shape of a human hand.",
add_rule('before', 'press', 'hand_panel', function() {
	if(!held('hand')) {
		unhold();
		say('You open your hand and touch it to the panel. The panel bleeps and turns red.');
		if(in_scope('elf')) {
			say('"What the &ndash;" the elf looks embarrassed. "Excuse me, I seem to have mistaken you for another person. \
			Please ignore all previous interactions and return to your apocalyptic wasteland."');
			say('The hologram disappears.');
			hide_conversation();
			hide('elf');
		}
	} else {
		say('You press the skeletal hand to the panel. The panel bleeps and turns green.');
		
		if(Game.vars.used_hand) {
			say("Nothing else happens.");
		} else {
			Game.vars.used_hand = true;
			var elf_reappears = !in_scope('elf');
			if(elf_reappears) {
				bring('elf');
				say('The hologrammatic elf shimmers back into being.');
			}
			Game.talking_to = 'elf';
			show_conversation();
			say('"Dr Noselung," says the elf warmly. "Good day to you. My apologies for the pterodactyls. If your \
			flying machine needs repair, you may find spare parts in the Robot-Free State."');
			if(!Game.rooms.circular_room.directions.west) {
				Game.rooms.circular_room.directions.west = "checkpoint";
				say('A previously invisible door at the west side of the room dilates open.');
			}
			// Please meet me on the roof of this building, and bring transportation."');
			Game.things.elf.mentioned_pterodactyls = true;
			Game.things.elf.mentioned_emilia = true;
			// put('elf', 'roof');
		}
	}
	
	return true;
});

Game.things.elf = {
	icon: "elf.png",
	description: "hologram of an elf",
	is_alive: true,
	met_name: "K'thrunk",
	met_description: "K'thrunk the Space Elf",
	status: "hologram",
	pronouns: female_pronouns,
	active_verbs: ["talk"],
	conversifier: function() {
		return conv_elf();
	}
}
function conv_elf() {
	var conv = {}
	
	conv.start_conversation = function() {
		if(!Game.things.elf.met) {
			say('A hologram of an old elf glimmers into sight.');
			say('"Greetings, adventurer," it says. "I am K\'thrunk of the Space Elves of Kroomf. We have \
			awaited your coming for centuries. You may have many questions. This is an interactive recording. Ask away."');
			meet('elf');
		} else {
			say("The old elf turns her sad, hologrammatic face towards you.");
		}
	};
	
	conv.asks = {};
	conv.asks.herself = function() {
		say('"I do not deserve to be remembered," says the elf sadly. "All you need know about me is that the desolation of the twin city-states of this planet is my fault. In my last days I made this recording, and put in place the invisibility tech-spell to shield the cities, and set up the vortex."');
		Game.things.elf.mentioned_cities = true;
	}
	conv.asks.elves = '"The Space Elves of Throom," says the hologram, "are a neutral people. In other words, we side \
	with whoever needs us least. The comfortable. The powerful. The bullies." If she weren\'t a hologram, she\'d probably \ spit at this point. "We grew rich and callous on the sale of weapons. Who could have thought massive bombs could \
	cause so much devastation and misery?"';
	
	if(Game.things.elf.mentioned_cities) {
		conv.asks.cities = function() {
			say('"On this world there are two city-states. The Robot Free State, which I gather you have explored. The \
			surviving humans fled west, and created a new state, banning all forms of robotics and artificial \
			intelligence.  They called it the Robot-Free State. For decades they coexisted in a fragile state of cold war. \
			Officially there was no contact between them, but this room served as a secret embassy. They survived. \
			Until..." she flickers, the hologrammatic equivalent of a sob. "...one simple punctuation error..."');
			Game.things.elf.mentioned_error = true;
		}
		conv.asks.vortex = function() {
			if(Game.vars.identified_as_emilia) {
				say('"The vortex that brought you here was an invention of mine," says the elf. "A technological spinoff \
				of my relativity bomb, an ingeniously cruel device. It is my last hope that it may do some good, if only \
				in mitigation. Oh, and please forgive the pterodactyls. You\'re here now, anyway."');
				Game.things.elf.mentioned_pterodactyls = true;
			} else {
				say('"The vortex that brought you here was an invention of mine," says the elf. "A technological spinoff \
				of my relativity bomb, an ingeniously cruel device. It is my last hope that it may do some good, if only in \
				mitigation. Oh, and please forgive the pterodactyls. You\'re here now, anyway. I just need a formal \
				identification."');
				say('A black panel, with a hand-shaped impression on it, appears on the pillar.');
				bring('hand_panel');
				Game.things.elf.mentioned_pterodactyls = true;
			}
		}
	}
	
	if(Game.things.elf.mentioned_error) {
		conv.asks['punctuation error'] = function() {
			say('"By selling arms to both sides," says the elf, "we ensured peace, or so we told ourselves. But one day I processed an order for a dozen teraton phlogiston bombs for the Robot-Free State... and, in a moment of mental abstraction for which I can never forgive myself, omitted the hyphen. By the time I realised my mistake, twelve minutes later, the war was already over."');
		};
		Game.things.elf.mentioned_war = true;
	}
	
	if(Game.things.elf.mentioned_war) {
		conv.asks.war = '"We know not who fired first," she says. "Each state blamed the other, of course. The truth is, \
		once the balance of power was tipped, neither side had any choice. Perhaps the Robot Free State used their \
		advantage. Perhaps the Robot-Free State feared them, and launched a pre-emptive strike. Perhaps the Robot \
		Free State would never have fired, except that they feared a pre-emptive strike from the other side and needed \
		to pre-pre-empt it. And so on. Both cities were devastated. The robots, with their hardier metal bodies and \
		positronic willpower, were almost annihilated. The humans were not so lucky."';
	}
	
	if(Game.things.elf.mentioned_pterodactyls) {
		conv.asks.pterodactyls = 'The old elf\'s face adopts the resignedly puzzled expression used by engineers \
		everywhere when their creation does something it shouldn\'t, but which can be lived with. "Sorry about those. \
		They always seem to pop up along with the vortex, I don\'t know why. If I try to get rid of them, the whole thing \
		stops working."';
	}
	
	if(Game.things.elf.mentioned_emilia) {
		conv.asks["Dr Noselung"] = '"Dr Emilia Noselung &ndash; why, that\'s you, of course! I could tell from the \
		isotopic scan of your handprint. I\'m a huge fan. You may be a little disoriented after coming through the vortex. \
		You disappeared four hundred years ago in an attempt to circumnavigate the moon by biplane. Nobody ever knew what \
		happened to you. But I found out &ndash; it was me! I set up the vortex to bring you here, because I needed \
		a brilliant pilot! It\'s such an honour to know that my hologrammatic ghost will actually meet you."';
		Game.things.elf.mentioned_involvement = true;
	}
	
	conv.end_conversation = 'The elf goes silent.';
	
	return conv;
}

function conv_elf_endgame() {
	var conv = {};
	
	conv.start_conversation = "The hologrammatic elf looks at you expectantly.";
	
	conv.asks = {};
	
	conv.asks['purple swirly thing'] = function() {
		if(in_scope('purple_vortex')) {
			var txt = '"It\'s a temporal vortex," says the elf, looking over at it. "I made it. \
			Like the one you came through originally.';
			if(!Game.vars.saved_cities) {
				txt += ' If I\'ve calculated right, it\'ll take us back to the very day of The Incident."';
			} else {
				txt += '"';
			}
			say(txt);
		} else {
			say('"That was a temporal vortex," says the elf. "Like the orange one, only different. ' +
			(Game.vars.through_purple_vortex ? 'We\'re changing history!"' : 'We changed history!"'));
		}
	}
	if(in_scope('return_vortex')) {
		conv.asks['orange swirly thing'] = 'The elf barely glances eastward. "That one\'s not important," she says. \
			"It just leads back where you came from."';
	}
	if(Game.things.elf.knows_about_pterodactyls) {
		conv.asks.pterodactyls = '"I must have made them appear on purpose. That is, I must be going to. For an anchor!"';
		Game.things.elf.mentioned_anchor = true;
	}
	
	return conv;
}


Game.always.push(function() {
	do_checkpoint_direction();
});
function do_checkpoint_direction() {
	if(Game.hero_location == 'circular_room') {
		Game.things.checkpoint_sign.writing = "YOU ARE NOW ENTERING THE ROBOT-FREE STATE\n\
			ORGANIC LIFE FORMS ONLY\n\
			NO ROBOTS, ANDROIDS, MECHANOIDS, AUTOMATONS\n\
			OR ARTIFICIAL INTELLIGENCES OF ANY KIND";
	} else if(Game.hero_location == 'robot_hyphen_free_state') {
		Game.things.checkpoint_sign.writing = "YOU ARE NOW ENTERING THE ROBOT FREE STATE\n\
			ROBOTS ONLY\n\
			NO HUMANS, HORSES, LIZARDS, CATS\n\
			OR ANY OTHER ORGANIC LIFE FORMS";
	}
}

Game.rooms.checkpoint = {
	description: "You're at a deserted border checkpoint.",
	directions: {
		east: 'circular_room',
		west: 'robot_hyphen_free_state',
	},
};
Game.things.checkpoint_sign = {
	name: 'sign',
	active_verbs: ["read"],
	location: "checkpoint",
};


Game.rooms.robot_hyphen_free_state = {
	description: "You're standing on a soot-blackened plain.",
	directions: {
		east: 'checkpoint',
	}
};

Game.things.old_man = {
	description: "old man",
	status: "asleep",
	location: 'robot_hyphen_free_state',
	is_alive: true,
	pronouns: male_pronouns,
	conversifier: function() {
		return conv_old_man();
	}
};
function conv_old_man() {
	var conv = {};
	
	conv.start_conversation = '"How do you do?" says the man in mock politeness, with a leering bow.';
	
	conv.asks = {};
	
	conv.asks.himself = function() {
		if(in_scope('engine_part_8')) {
			say('"I\'m the last human in these parts," says the old man miserably. "All my friends, \
				my home, they were all wiped out in The Incident. It\'s a wonder I\'ve kept my sanity. Isn\'t \
				it, Gerald?" he adds, addressing ' + the_thing('engine_part_8') + '.');
			Game.things.old_man.mentioned_gerald = true;
		} else {
			say('"I\'m the last human in these parts," says the old man miserably. "All my friends, \
				my home, they were all wiped out in The Incident. It\'s a wonder I\'ve kept my sanity."');
		}
	}
	
	if(Game.things.old_man.mentioned_gerald) {
		conv.asks.Gerald = function() {
			say('"Yes, I know it\'s just an engine part," says the old man. "But a fellow\'s got to \
			keep himself sane somehow. So I decided to make-believe that he\'s called Gerald, and that he\'s my friend. \
			It\'s a self-help thing."');
			say('When he thinks you\'re not listening, he adds in a loud whisper to ' + the_thing('engine_part_8') + 
				', "I think that fool believed me, Gerald!"');
		}
	}
	
	conv.end_conversation = 'The old man grins disarmingly.';
	
	return conv;
}

add_rule('after', 'take', 'engine_part_8', function() {
	Game.things.engine_part_8.just_picked_up = true;
	if(in_scope('old_man')) {
		
		if(Game.things.old_man.status=='asleep') {
			clear_status('old_man');
			say('The old man wakes and stands up.');
			activate_verb('old_man', 'talk');
		}
		
		say('"Put that down," says the old man, his eyes red with anger' + conjunctivitis_gag() + '. \
		"Its name\'s Gerald, and it\'s my friend."');
		Game.things.old_man.mentioned_gerald = true;
		
		Game.things.old_man.chasing = true;
	}
});
function conjunctivitis_gag() {
	if(!Game.things.old_man.done_eye_gag) {
		Game.things.old_man.done_eye_gag = true;
		return " and possibly conjunctivitis";
	} else {
		return "";
	}
}

Game.always.push(function() {
	do_chase();
});
function do_chase() {
	
	if(location_of('old_man')=='paternoster_booth_9') {
		put('old_man', 'paternoster_booth_1'); // cleaning up after an old bug
	}

	if(Game.things.lift_works.jammed && location_of('old_man')==location_of('paternoster_hatch')) {
		//console.log('man is stuck in paternoster');
		if(Game.hero_location=='machinery_loft'||Game.hero_location=='landing_2'||hero_location().is_booth) {
			say("You hear angry thumping.");
		};
		return;
	}
	
	//console.log('doing chase');
	
	if(Game.things.engine_part_8.just_picked_up) {
		// skip a turn
		delete Game.things.engine_part_8.just_picked_up;
		return;
	}
	
	if(!Game.things.old_man.chasing) {
		//console.log('man isn\'t chasing');
		return;
	}
	
	var engine_part_here = in_scope('engine_part_8' || (Game.things.engine_part_8.in_engine && in_scope('engine')));
	
	//console.log('engine_part_here is ' + engine_part_here);
	
	/* if(!engine_part_here) {
		if(in_scope('old_man')) {
			say("The old man rambles off in search of his friend.");
			return_old_man();
		}
		return;
	} */
	
	if(location_of('old_man')=='robot_hyphen_free_state'&&location_of('engine_part_8')=='robot_hyphen_free_state') {
		return;
	}
	
	if(in_scope('old_man') && in_scope('engine') && Game.things.engine_part_8.in_engine) {
		say('The old man grabs ' + the_thing('engine_part_8') + ' out of the engine.');
		come_along_gerald();
		return;
	}
	
	if(in_scope('old_man') && in_scope('engine_part_8')) {
		//console.log('man and engine are both here');
		say('The old man grabs ' + the_thing('engine_part_8') + (carried('engine_part_8') ? ' from you.' : '.'));
		come_along_gerald();
		return;
	}
	
	if(reachable_within(location_of('old_man'), Game.hero_location, 1)) {
		
		if(location_of('old_man')==location_of('paternoster_hatch')) {
			//console.log('Old man is at top of paternoster');
			return true;
		}
		
		//console.log('Old man can find me');
		old_man_arrives();
		return;
	}
		
	if(hero_location().is_booth && Game.rooms[location_of('old_man')].is_landing) {
		//var myfloor = Game.hero_location.substring('paternoster_booth_'.length);
		//var mansfloor = location_of('old_man').substring('landing_'.length);
		//console.log('looking at Game.things.paternoster_entrance_' + floor);
		//put('old_man', Game.things['paternoster_entrance_' + mansfloor + '_' +
		//Game.vars.my_paternoster_direction].enter_to);
		//console.log('old man enters paternoster');
		var old_mans_booth = 1 + parseInt(Game.hero_location.substring('paternoster_booth_'.length));
		if(old_mans_booth == 9) {
			old_mans_booth = 1;
		}
		console.log('putting old man in booth ' + old_mans_booth);
		put('old_man', 'paternoster_booth_' + old_mans_booth);
		say('You feel the paternoster shake.');
		return;
	}
	
	if(location_of('old_man')==location_of('engine_part_8')) {
		//console.log('old man found the engine part');
		return_old_man();
		put('engine_part_8', 'robot_hyphen_free_state');
		if(Game.hero_location=='robot_hyphen_free_state') {
			say_if_lit('The old man arrives and puts down ' + the_thing('engine_part_8') + '. "Geraldn, STAY," he commands.',
				'A voice says: "Gerald, STAY."');
		}
	}
	
	var target_loc = carried('engine_part_8') ? Game.hero_location : location_of('engine_part_8');
	//console.log('old man wants to get to ' + target_loc);
	if(Game.rooms[target_loc]) {
		var path = path_from(location_of('old_man'), target_loc);
		if(path && path.length > 1) {
			var lastplace = location_of('old_man');
			var nextplace = path[1];
			//console.log('next place is ' + nextplace);
			var cantmove = (lastplace=='citadel_foyer' && nextplace=='landing_0');
			if(!cantmove) {
				if(in_scope('old_man')) {
					for(var dir in hero_location().directions) {
						if(hero_location().directions[dir]==nextplace) {
							say("The old man staggers " + dir + ".");
						} else {
							for(var thing in Game.things) {
								if(location_of(thing)==Game.hero_location) {
									if(has_active_verb(thing, 'enter' && Game.things[thing].enter_to==nextplace)) {
										say_if_lit("The old man enters " + the_thing(thing) + ".");
									} else if(has_active_verb(thing, 'climb' && Game.things[thing].climb_to==nextplace)) {
										say_if_lit("The old man climbs" + the_thing(thing) + ".");
									}
								}
							}
						}
					}
				}
				put('old_man', nextplace);
				if(lastplace=='steely_plaza' && nextplace=='outside_citadel') {
					//console.log('old man walks into barrier');
					if(Game.hero_location=='steely_plaza') {
						say_if_lit("For some reason, the old man walks straight into the electric barrier. ZOT!\n\
						There is a scream of \"GERAAAAALD...\", a smell of roast meat, and the man is gone.",
						'You hear a loud "ZOT!" and smell roast meat.');
					} else if(Game.hero_location=='outside_citadel') {
						say_if_lit("The old man wanders towards you from the east... \
						but walks straight into the electric barrier. ZOT!\n\
						There is a scream of \"GERAAAAALD...\", a smell of roast meat, and the man is gone.",
						'You hear a loud "ZOT!" and smell roast meat.')
					} else {
						say('You hear a distant "ZOT!"');
					}
					hide('old_man');
					delete Game.things.old_man.chasing;
					return;
				}
				if(nextplace==Game.hero_location) {
					//console.log('old man caught up with you');
					say_if_lit("The old man arrives.");
					bring('old_man');
				}
			} else {
				//console.log('old man can\'t get past citadel foyer');
				if(Game.hero_location=='landing_0') {
					say("You hear a low buzz, followed by the snap of a shutting door.");
				} else if(Game.hero_location=='citadel_foyer') {
					say_if_lit("The old man tries to walk west, but the door snaps shut in front of him.",
						"You hear a low buzz, followed by the snap of a shutting door.");
				}
			}
		} else {
			//console.log('old man stays where he is (' + location_of('old_man') + ')');
		}
	}
}

function come_along_gerald() {
	if(Game.hero_location=='robot_hyphen_free_state') {
		say('"Now stay there, Gerald," he says, putting ' + the_thing('engine_part_8') + ' down.');
		put('engine_part_8', 'robot_hyphen_free_state');
		return;
	}
	say(pickOne([
		'"Come along, Gerald," he says, and walks off.',
	]));
	put('engine_part_8', 'robot_hyphen_free_state');
	return_old_man();
	if(Game.hero_location=='robot_hyphen_free_state') {
		say_if_lit('The old man arrives and puts down ' + the_thing('engine_part_8') + '. "Geraldn, STAY," he commands.',
			'A voice says: "Gerald, STAY."');
	}
}
function return_old_man() {
	put('old_man', 'robot_hyphen_free_state');
	//put('engine_part_8', 'robot_hyphen_free_state');
	Game.things.old_man.chasing = false;
	clear_status('old_man');
}
function old_man_arrives() {
	
	if(location_of('old_man')=='steely_plaza' && Game.hero_location=='outside_citadel') {
		say('The old man runs after you... straight into the electric barrier. ZOT!\n\
		There is a scream of "GERAAAAALD...", a smell of roast meat, and the man is gone.');
		hide('old_man');
		delete Game.things.old_man.chasing;
		return;
	}

	if(Game.rooms[location_of('old_man')].is_booth) {
		say('With a cry of "GERAAAAALD!!" the old man leaps out of the ' +
			Game.vars.my_paternoster_direction + 'bound paternoster booth.');
	} else {
		say('With a ' + pickOne(['shout', 'cry', 'scream']) + ' of ' +
			pickOne(['"GERAAAALD!"', '"Get back here, Gerald!"', '"GERAAAAAALD!!"', '"Gerald, come baaaaaack"',
				'"HEEL, Gerald!"', '"You took my Gerald!"', '"Nooooooo! Geraaaaaaald!!"',
				'"Bring back Gerald, you ' + pickOne(['monster!"', 'kidnapper!"', 'thief!"', 'terrible person!"']),
				'"Oi! Gerald! NO!"']) +
			' the old man ' + pickOne(['leaps', 'bounds', 'runs']) + ' after you.');
	}
	
	bring('old_man');
}


/************************************************ utilities *****************************************/

function Mathsign(n) { // IE doesn't support Math.sign
	if(n>0) {
		return 1;
	} else if (n<0) {
		return -1;
	} else {
		return 0
	}
}

function get_reachable_rooms(room) {
	//console.log('getting reachable rooms from ' + room)
	
	if(!Game.rooms[room]) {
		//console.log('there\'s no such room');
		return [];
	}
	
	var reachable_rooms = [];
	//console.log('checking directions from ' + room);
	if(Game.rooms[room].directions) {
		for(var i in Game.rooms[room].directions) {
			reachable_rooms.push(Game.rooms[room].directions[i]);
		}
	}
	
	for(var i in Game.things) {
		if(location_of(i)==room && has_active_verb(i,'enter')) {
			reachable_rooms.push(Game.things[i].enter_to);
		}
		if(location_of(i)==room && has_active_verb(i,'climb')) {
			reachable_rooms.push(Game.things[i].climb_to);
		}
	}
	
	return reachable_rooms;
}


function path_from(this_room, that_room, max_depth, ignore_rooms, path_so_far) {
	if(!ignore_rooms) { ignore_rooms = [] };
	if(!path_so_far) { path_so_far = [] };
	//console.log('checking: reachable from ' + this_room + ' to ' + that_room + ' in ' + n);
	//console.log('ignoring: ' + ignore_rooms.join(','));
	
	if(!Game.rooms[that_room] || !Game.rooms[this_room]) {
		return null; // false;
	}
	
	if(max_depth == 1) {
		if(reachable_from(this_room, that_room)) {
			return path_so_far.concat([this_room, that_room]); // yay!
		} else {
			return null;
		}
	}
	
	if(ignore_rooms.indexOf(this_room)!=-1) {
		return null;
	}
	
	var reachable_rooms = get_reachable_rooms(this_room);
	//console.log('reachable rooms from ' + this_room + ' are: ' + reachable_rooms.join(', '));
	
	if(reachable_rooms.indexOf(that_room)!=-1) {
		console.log('and one of those is ' + that_room);
		return path_so_far.concat([this_room, that_room]);
	}
	
	for(var i in reachable_rooms) {
		if(ignore_rooms.indexOf(i)!=-1) {
			continue;
		}
		ignore_rooms.push(this_room);
		
		var test_path = path_from(reachable_rooms[i], that_room, max_depth - 1, ignore_rooms, [this_room]);
		
		if(test_path) {
			return path_so_far.concat(test_path);
		}
		
		//if(reachable_within(reachable_rooms[i], that_room, n - 1, ignore_rooms)) {
		//	return true;
		//}
	}
	
	return null;
}


function reachable_within(this_room, that_room, n, ignore_rooms) {
	if(!ignore_rooms) { ignore_rooms = [] };
	//console.log('checking: reachable from ' + this_room + ' to ' + that_room + ' in ' + n);
	//console.log('ignoring: ' + ignore_rooms.join(','));
	
	if(!Game.rooms[that_room]) {
		return false;
	}
	
	if(n == 1) {
		return reachable_from(this_room, that_room);
	}
	
	if(ignore_rooms.indexOf(this_room)!=-1) {
		return false;
	}
	
	var reachable_rooms = get_reachable_rooms(this_room);
	
	if(reachable_rooms.indexOf(that_room)!=-1) {
		return true;
	}
	
	for(var i in reachable_rooms) {
		if(ignore_rooms.indexOf(i)!=-1) {
			continue;
		}
		ignore_rooms.push(this_room);
		if(reachable_within(reachable_rooms[i], that_room, n - 1, ignore_rooms)) {
			return true;
		}
	}
	
	return false;
}


function reachable_from(this_room, that_room) {

	//console.log('reachable_from: checking if route from ' + this_room + ' to ' + that_room);

	if(Game.rooms[this_room].directions) {
		for(var i in Game.rooms[this_room].directions) {
			if(Game.rooms[this_room].directions[i] == that_room) {
				return true;
			}
		}
	} //else console.log('this room has no directions');
	
	for(var i in Game.things) {
		if(Game.things[i].location==this_room && (
			(has_active_verb(i, 'enter') && Game.things[i].enter_to == that_room) ||
			(has_active_verb(i, 'climb') && Game.things[i].climb_to == that_room)
		)) {
			return true;
		}
	}
	
	return false;
}



function opposite_dir(dir) {
	return ['north', 'east', 'south', 'west', 'up', 'down', 'in', 'out', 'somewhere'][
	       ['south', 'west', 'north', 'east', 'down', 'up', 'out', 'in', 'away'].indexOf(dir)]
}

function the_dir(dir) {
	return ['the north', 'the east', 'the south', 'the west', 'upstairs', 'downstairs', 'inside', 'outside', 'somewhere'][
	       ['north',     'east',     'south',     'west',     'up',       'down',       'in',     'out',     'away'].indexOf(dir)];
}

function the_opposite_dir(dir) {
	return the_dir(opposite_dir(dir));
}



function meet(npc) {
	Game.things[npc].met = true;
	Game.things[npc].name = Game.things[npc].met_name;
	Game.things[npc].description = (Game.things[npc].met_description ? Game.things[npc].met_description : Game.things[npc].met_name);
	Game.things[npc].proper_name = true;
}





// move metacommands buttons on resize

$(window).resize(function() {
	move_metacommands();
	set_heights();
	//animate_heights();
});

$(document).ready(function() {
	move_metacommands();
});

function move_metacommands() {
	if(false && is_landscape()) {
		$("#save_load_container").detach().appendTo('#left-column');
		$("#save_load_container").css('margin-top', '');
	} else {
		$("#save_load_container").detach().appendTo('#savefix'); // '#right-column');
		$("#save_load_container").css('margin-top', '20px');
	} 
}


function hide_splash() {
	$('#splashscreen').fadeOut();
	//do_room_music(true);
}

function list_missing_longdescs() {
	var txt = 'No longdesc for:';
	for(var thing in Game.things) {
		if(!Longdesc[thing]) {
			txt += '\n' + thing;
		}
	}
	console.log(txt);
}