#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"
#define gNbmLoc (gActor.location)

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// JUNK
// NATION MAZES: DIRECTIONS: DIRECTION MACROS
// NATION MAZES: DIRECTIONS: DIRECTION CLASSES, ETC.
// NATION MAZES: DIRECTIONS: AFRICA DIRECTIONS
// NATION MAZES: DIRECTIONS: MEXICO DIRECTIONS
// NATION MAZES: DIRECTIONS: AMBIGUOUS DIRECTION HACKS
// NATION MAZES: DIRECTIONS: EXITLISTER MODIFICATIONS
// NATION MAZES: MESSAGES
// NATION MAZES: PASSAGES: CLASSES: GENERAL PASSAGE CLASSES
// NATION MAZES: PASSAGES: CLASSES: AFRICA PASSAGE CLASSES
// NATION MAZES: PASSAGES: CLASSES: MEXICO PASSAGE CLASSES
// NATION MAZES: PASSAGES: AFRICA PASSAGES
// NATION MAZES: PASSAGES: MEXICO PASSAGES
// NATION MAZES: ROOMS: CLASSES
// NATION MAZES: ROOMS: AFRICA ROOMS
// NATION MAZES: ROOMS: MEXICO ROOMS
// NATION MAZES: SCENERY: AFRICA SCENERY
// NATION MAZES: SCENERY: MEXICO SCENERY
// NATION MAZES: MAPS: FUNCTIONS: AFRICA MAP FUNCTIONS
// NATION MAZES: MAPS: FUNCTIONS: MEXICO MAP FUNCTIONS
// NATION MAZES: MAPS: AFRICA MAP
// NATION MAZES: MAPS: MEXICO MAP
// DEBUG STUFF

// -------------------------------------------------------------------
// JUNK
// -------------------------------------------------------------------

/*
Note that the following must still be taken care of:
-- As with all mazes, Sheila must say "Before you begin, be aware of RESET and ESCAPE."
-- When trapped but unvictorious, Sheila must say "Uh oh, I think I'm trapped. Try RESET."
-- When victorious (in this case, one is also nominally trapped), a hole must appear in the ground, and perhaps Sheila should say someting about it.
*/


// &aacute; = \u00E1
// &eacute; = \u00E9
// &iacute; = \u00ED
// &oacute; = \u00F3
// &uacute; = \u00FA
// &yacute; = \u00FD
// &ntilde; = \u00F1
// &uuml;   = \u00FC
// &iquest; = \u00BF
// &iexcl;  = \u00A1
// &acirc;  = \u00E2
// &ocirc;  = \u00F4

/*
http://en.wikipedia.org/wiki/Category:Wildlife_of_Africa
lions
gorillas
camels
elephants
crocodiles
jackals
rhinoceroses
hippopotami
ostriches

chimpanzees
zebras
buffalo(s?)
cheetahs
*/

// 
// Things that still need to be changed:
// 
// Figure out what the hell to do for Baja California/Sur. DefLngNationDir & class PassToBaja/etc.
// mexMsg
// MexPass
// Mexico passage classes
// Mexico rooms (already done now?)
// Mexico scenery (including cities)
// Africa cities (diacritical marks)
// 

/*
use StyleTags to avoid repetition of HTML code.
override gambia scenery description.
Fix ExitLister to prevent semicolon in "Obvious exits lead to Libya; and Sudan. "
Fix Congo/Guinea/Republic/Africa disambiguation
fix "ne"
permit "go to direction" and "go to the direction" and maybe "the direction"
*/

// -------------------------------------------------------------------
// NATION MAZES: DIRECTIONS: DIRECTION MACROS
// -------------------------------------------------------------------

#define DefineDirection(prop, base, order) \
    prop##Direction: base##Direction \
    dirProp = &prop \
    sortingOrder = order

#define DefineLangDir(root, dirNames, backPre) \
grammar directionName(root): dirNames: DirectionProd \
   dir = root##Direction \
; \
\
modify root##Direction \
   name = #@root \
   backToPrefix = backPre

// replaced so that 'ne' doesn't *always* mean northeast.
replace grammar directionName(northeast): 'northeast': DirectionProd
   dir = northeastDirection
;
; // I have no idea why this extra semicolon is needed. I'm very
  // confused, in fact.

#define DefineDirection(prop, base, order) \
    prop##Direction: base##Direction \
    dirProp = &prop \
    sortingOrder = order

/*
#define DefineLangDir(root, dirNames, backPre) \
grammar directionName(root): dirNames: DirectionProd \
   dir = root##Direction \
; \
\
modify root##Direction \
   name = #@root \
   backToPrefix = backPre
*/

#define DefLngNationDir(root, nm, dirNames, backPre) \
grammar directionName(root): dirNames: DirectionProd \
   dir = root##Direction \
; \
\
modify root##Direction \
   name = #@nm \
   backToPrefix = backPre

// -------------------------------------------------------------------
// NATION MAZES: DIRECTIONS: DIRECTION CLASSES, ETC.
// -------------------------------------------------------------------

class AfricaDirection: Direction
  defaultConnector(loc) {
    return (loc.isInAfrica ? noTravel : noAfricaTravel);
  }
;
class MexicoDirection: Direction
  defaultConnector(loc) {
    return (loc.isInMexico ? noTravel : noMexicoTravel);
  }
;
class AfrMexDirection: Direction
  defaultConnector(loc) {
    return ((loc.isInMexico || loc.isInAfrica) 
      ? noTravel : noAfrMexTravel);
  }
;

noAfricaTravel: noTravel
  dobjFor(TravelVia) {
    action() {
      //libMessages.notOnboardShip();
      //"That direction isn<./s>t meaningful here. ";
      //"{You/he} can<./s>t go that way. ";
      say(playerActionMessages.cannotGoThatWayMsg);
      exit;
    }
  }
;
noMexicoTravel: noTravel
  dobjFor(TravelVia) {
    action() {
      say(playerActionMessages.cannotGoThatWayMsg);
      exit;
    }
  }
;
noAfrMexTravel: noTravel
  dobjFor(TravelVia) {
    action() {
      say(playerActionMessages.cannotGoThatWayMsg);
      exit;
    }
  }
;

// -------------------------------------------------------------------
// NATION MAZES: DIRECTIONS: AFRICA DIRECTIONS
// -------------------------------------------------------------------

DefineDirection(algeria,    Africa, 11010);
DefineDirection(angola,     Africa, 11020);
DefineDirection(benin,      Africa, 11030);
DefineDirection(botswana,   Africa, 11040);
DefineDirection(burkfaso,   Africa, 11050);
DefineDirection(burundi,    Africa, 11060);
DefineDirection(cameroon,   Africa, 11070);
DefineDirection(centafri,   Africa, 11080);
DefineDirection(chad,       Africa, 11090);
DefineDirection(congo,      Africa, 11100);
DefineDirection(demorepu,   Africa, 11110);
DefineDirection(djibouti,   Africa, 11120);
DefineDirection(egypt,      Africa, 11130);
DefineDirection(equaguin,   Africa, 11140);
DefineDirection(eritrea,    Africa, 11150);
DefineDirection(ethiopia,   Africa, 11160);
DefineDirection(gabon,      Africa, 11170);
DefineDirection(gambia,     Africa, 11180);
DefineDirection(ghana,      Africa, 11190);
DefineDirection(guinea,     Africa, 11200);
DefineDirection(guinbiss,   Africa, 11210);
DefineDirection(ivorcoas,   Africa, 11220);
DefineDirection(kenya,      Africa, 11230);
DefineDirection(lesotho,    Africa, 11240);
DefineDirection(liberia,    Africa, 11250);
DefineDirection(libya,      Africa, 11260);
DefineDirection(malawi,     Africa, 11270);
DefineDirection(mali,       Africa, 11280);
DefineDirection(mauritania, Africa, 11290);
DefineDirection(morocco,    Africa, 11300);
DefineDirection(mozambique, Africa, 11310);
DefineDirection(namibia,    Africa, 11320);
DefineDirection(niger,      Africa, 11330);
DefineDirection(nigeria,    Africa, 11340);
DefineDirection(rwanda,     Africa, 11350);
DefineDirection(senegal,    Africa, 11360);
DefineDirection(sierleon,   Africa, 11370);
DefineDirection(somalia,    Africa, 11380);
DefineDirection(soutafri,   Africa, 11390);
DefineDirection(sudan,      Africa, 11400);
DefineDirection(southsudan, Africa, 11400);
DefineDirection(swaziland,  Africa, 11410);
DefineDirection(tanzania,   Africa, 11420);
DefineDirection(togo,       Africa, 11430);
DefineDirection(tunisia,    Africa, 11440);
DefineDirection(uganda,     Africa, 11450);
DefineDirection(westsaha,   Africa, 11460);
DefineDirection(zambia,     Africa, 11470);
DefineDirection(zimbabwe,   Africa, 11480);





DefLngNationDir(algeria,   Algeria,   'dz'|'algeria'   ,'back to');
DefLngNationDir(angola,    Angola,    'ao'|'angola'    ,'back to');
DefLngNationDir(benin,     Benin,     'bj'|'benin'     ,'back to');
DefLngNationDir(botswana,  Botswana,  'bw'|'botswana'  ,'back to');
DefLngNationDir(burundi,   Burundi,   'bi'|'burundi'   ,'back to');
DefLngNationDir(cameroon,  Cameroon,/*'cm'|*/'cameroon','back to');
DefLngNationDir(chad,      Chad,      'td'|'chad'      ,'back to');
DefLngNationDir(djibouti,  Djibouti,  'dj'|'djibouti'  ,'back to');
DefLngNationDir(egypt,     Egypt,     'eg'|'egypt'     ,'back to');
DefLngNationDir(eritrea,   Eritrea,   'er'|'eritrea'   ,'back to');
DefLngNationDir(ethiopia,  Ethiopia,  'et'|'ethiopia'  ,'back to');
DefLngNationDir(gabon,     Gabon,     'ga'|'gabon'     ,'back to');
DefLngNationDir(gambia,    Gambia,    'gm'|'gambia'    ,'back to');
DefLngNationDir(ghana,     Ghana,     'gh'|'ghana'     ,'back to');
DefLngNationDir(kenya,     Kenya,     'ke'|'kenya'     ,'back to');
DefLngNationDir(lesotho,   Lesotho,   'ls'|'lesotho'   ,'back to');
DefLngNationDir(liberia,   Liberia,   'lr'|'liberia'   ,'back to');
DefLngNationDir(libya,     Libya,     'ly'|'libya'     ,'back to');
DefLngNationDir(malawi,    Malawi,    'mw'|'malawi'    ,'back to');
DefLngNationDir(mali,      Mali,      'ml'|'mali'      ,'back to');
DefLngNationDir(mauritania,Mauritania,/*'mr'|*/'mauritania','back to');
DefLngNationDir(morocco,   Morocco,   'ma'|'morocco'   ,'back to');
DefLngNationDir(mozambique,Mozambique,'mz'|'mozambique','back to');
DefLngNationDir(namibia,   Namibia,   'na'|'namibia'   ,'back to');
DefLngNationDir(nigeria,   Nigeria,   'ng'|'nigeria'   ,'back to');
DefLngNationDir(rwanda,    Rwanda,    'rw'|'rwanda'    ,'back to');
DefLngNationDir(senegal,   Senegal,   'sn'|'senegal'|'s\u00E9n\u00E9gal'|'le' 's\u00E9n\u00E9gal','back to');
DefLngNationDir(somalia,   Somalia,/*'so'|*/'somalia'  ,'back to');
DefLngNationDir(swaziland, Swaziland, 'sz'|'swaziland' ,'back to');
DefLngNationDir(tanzania,  Tanzania,  'tz'|'tanzania'  ,'back to');
DefLngNationDir(togo,      Togo,      'tg'|'togo'      ,'back to');
DefLngNationDir(tunisia,   Tunisia,   'tn'|'tunisia'   ,'back to');
DefLngNationDir(uganda,    Uganda,    'ug'|'uganda'    ,'back to');
DefLngNationDir(zambia,    Zambia,    'zm'|'zambia'    ,'back to');
DefLngNationDir(zimbabwe,  Zimbabwe,  'zw'|'zimbabwe'  ,'back to');
DefLngNationDir(burkfaso, Burkina Faso,
  'bf'|'burkina'|'faso'|'burkina' 'faso', 'back to');
DefLngNationDir(equaguin, Equatorial Guinea,
  'gq'|'equatorial'|'guinea'|'equatorial' 'guinea', 'back to');
DefLngNationDir(sierleon, Sierra Leone,
  /*'sl'|*/'sierra'|'leone'|'sierra' 'leone', 'back to');
DefLngNationDir(westsaha, Western Sahara,
  'eh'|('western'|) 'sahara', 'back to');
DefLngNationDir(ivorcoas, Ivory Coast,
  'ci'|'ivory'|('ivory'|) 'coast'|'c\u00F4te'|'cote'|
  ('c\u00F4te'|'cote'|) ('d\'ivoire'|'divoire'|'d' 'ivoire'|'de' 'ivoire')
  ,'back to');

//"NE", "NW", "SE", "SW" conflicts
DefLngNationDir(niger,     Niger,     /*'ne'|*/'niger'     ,'back to');

// Nations whose names conflict
DefLngNationDir(congo,     Congo,     'cg'/*|'congo' */    ,'back to');
DefLngNationDir(guinea,    Guinea,    'gn'/*|'guinea'*/    ,'back to');
DefLngNationDir(sudan,     Sudan,     'sd'/*|'sudan' */    ,'back to');
DefLngNationDir(southsudan,South Sudan,
  'ss'|'south' 'sudan', 'back to');
DefLngNationDir(centafri, Central African Republic,
  'cf'|'central'|('central'|) 'african'|
  ('central'|'african'|'central' 'african') 'republic',
  'back to');
DefLngNationDir(guinbiss, Guinea-Bissau,
  'gw'|'guinea-bissau'|'bissau' /*|'guinea'*/ , 'back to');
DefLngNationDir(soutafri, South Africa,
  'za' |'south' 'africa' /*|'south'|'africa'*/ , 'back to');
DefLngNationDir(demorepu, Democratic Republic of the Congo,
  'zr'| 'cd' |
  'zaire'|'za\u00EFre'|
  'democratic'|
  'democratic' 'republic'|
  'democratic' 'congo'|
  'republic' 'democratic'|
  'congo' 'democratic'|
  'democratic' 'republic' 'congo'|
  'congo' 'democratic' 'republic'|
  'democratic' 'republic' 'of' 'congo'|
  'democratic' 'republic' 'of' 'the' 'congo'
  //AMBIGUOUS, AND HAVE THEIR OWN DIRECTIONS:
  //'republic'
  //'congo'
  //WOULD IN FACT REFER TO THE CONGO, NOT THE D.R. OF CONGO:
  //'republic' 'congo'
  //'congo' 'republic'
  //'republic' 'of' 'congo'
  //'republic' 'of' 'the' 'congo'
  //JUST TOO DAMN RIDICULOUS:
  //'democratic' 'of' 'congo'
  //'democratic' 'of' 'the' 'congo'
  //'republic' 'democratic' 'of' 'congo'
  //'republic' 'democratic' 'of' 'the' 'congo'
  , 'back to the');

// Directional ambiguous cases:
// republic, congo, guinea, africa
DefineDirection(ambRepub,  Africa, 11810);
DefineDirection(ambCongo,  Africa, 11820);
DefineDirection(ambGuinea, Africa, 11830);
DefineDirection(ambAfrica, Africa, 11840);
DefineDirection(ambSudan,  Africa, 11850);
DefLngNationDir(ambRepub,  ERROR-ambRepub,  'republic','back to');
DefLngNationDir(ambCongo,  ERROR-ambCongo,  'congo'   ,'back to');
DefLngNationDir(ambGuinea, ERROR-ambGuinea, 'guinea'  ,'back to');
DefLngNationDir(ambAfrica, ERROR-ambAfrica, 'africa'  ,'back to');
DefLngNationDir(ambSudan,  ERROR-ambSudan,  'sudan'   ,'back to');

// -------------------------------------------------------------------
// NATION MAZES: DIRECTIONS: MEXICO DIRECTIONS
// -------------------------------------------------------------------

DefineDirection(aguascal,   Mexico, 12010);
DefineDirection(bajacali,   Mexico, 12020);
DefineDirection(bajasur,    Mexico, 12030);
DefineDirection(chihuahua,  Mexico, 12040);
DefineDirection(colima,     Mexico, 12050);
DefineDirection(campeche,   Mexico, 12060);
DefineDirection(coahuila,   Mexico, 12070);
DefineDirection(chiapas,    Mexico, 12080);
DefineDirection(distrito,   Mexico, 12090);
DefineDirection(durango,    Mexico, 12100);
DefineDirection(guanajuato, Mexico, 12110);
DefineDirection(guerrero,   Mexico, 12120);
DefineDirection(hidalgo,    Mexico, 12130);
DefineDirection(jalisco,    Mexico, 12140);
DefineDirection(michoacan,  Mexico, 12150);
DefineDirection(morelos,    Mexico, 12160);
DefineDirection(mexico,     Mexico, 12170);
DefineDirection(nuevoleon,  Mexico, 12180);
DefineDirection(nayarit,    Mexico, 12190);
DefineDirection(oaxaca,     Mexico, 12200);
DefineDirection(puebla,     Mexico, 12210);
DefineDirection(quintana,   Mexico, 12220);
DefineDirection(queretaro,  Mexico, 12230);
DefineDirection(sinaloa,    Mexico, 12240);
DefineDirection(sanluis,    Mexico, 12250);
DefineDirection(sonora,     Mexico, 12260);
DefineDirection(tabasco,    Mexico, 12270);
DefineDirection(tlaxcala,   Mexico, 12280);
DefineDirection(tamaulipas, Mexico, 12290);
DefineDirection(veracruz,   Mexico, 12300);
DefineDirection(yucatan,    Mexico, 12310);
DefineDirection(zacatecas,  Mexico, 12320);

DefLngNationDir(aguascal,  Aguascal,  'ag'|'aguascalientes','back to');
DefLngNationDir(chihuahua, Chihuahua, 'ch'|'chihuahua' ,'back to');
DefLngNationDir(colima,    Colima,    'cl'|'colima'    ,'back to');
DefLngNationDir(campeche,  Campeche,/*'cm'|*/'campeche','back to');
DefLngNationDir(coahuila,  Coahuila,  'co'|'coahuila'  ,'back to');
DefLngNationDir(chiapas,   Chiapas,   'cp'|'chiapas'   ,'back to');
DefLngNationDir(durango,   Durango,   'dr'|'durango'   ,'back to');
DefLngNationDir(guanajuato,Guanajuato,'gn'|'guanajuato','back to');
DefLngNationDir(guerrero,  Guerrero,  'gr'|'guerrero'  ,'back to');
DefLngNationDir(hidalgo,   Hidalgo,   'hd'|'hidalgo'   ,'back to');
DefLngNationDir(jalisco,   Jalisco,   'jl'|'jalisco'   ,'back to');
DefLngNationDir(mexico,    M\u00E9xico,'mx'|'mexico'|'m\u00E9xico','back to');
DefLngNationDir(michoacan, Michoac\u00E1n,'mc'|'michoacan'|'michoac\u00E1n','back to');
DefLngNationDir(morelos,   Morelos, /*'mr'|*/'morelos' ,'back to');
DefLngNationDir(nayarit,   Nayarit,   'ny'|'nayarit'   ,'back to');
DefLngNationDir(oaxaca,    Oaxaca,    'ox'|'oaxaca'    ,'back to');
DefLngNationDir(puebla,    Puebla,    'pb'|'puebla'    ,'back to');
DefLngNationDir(queretaro, Quer\u00E9taro, 'qr'|'queretaro'|'quer\u00E9taro','back to');
DefLngNationDir(sinaloa,   Sinaloa,   'si'|'sinaloa'   ,'back to');
DefLngNationDir(sonora,    Sonora,  /*'so'|*/'sonora'  ,'back to');
DefLngNationDir(tabasco,   Tabasco,   'tb'|'tabasco'   ,'back to');
DefLngNationDir(tlaxcala,  Tlaxcala,  'tl'|'tlaxcala'  ,'back to');
DefLngNationDir(tamaulipas,Tamaulipas,'tm'|'tamaulipas','back to');
DefLngNationDir(veracruz,  Veracruz,  'vr'|'veracruz'  ,'back to');
DefLngNationDir(yucatan,   Yucat\u00E1n,   'yc'|'yucatan'|'yucat\u00E1n','back to');
DefLngNationDir(zacatecas, Zacatecas, 'zc'|'zacatecas' ,'back to');
DefLngNationDir(bajacali,  BajaCali,  'bc'|'bajacali'|'baja'|'california'|'baja' 'california'
  ,'back to');
DefLngNationDir(bajasur,   BajaSur,   'bs'|'bajacali'|'baja'|'california'|'baja' 'california'|('baja'|'california'|'baja' 'california'|) 'sur'
  ,'back to');
DefLngNationDir(distrito,  Distrito,  'df'|'distrito' (|'federal')|'federal'|('federal'|) 'district'
  ,'back to');
DefLngNationDir(nuevoleon, NuevoLeon, 'nl'|'nuevo'|('nuevo'|) ('le\u00F3n'|'leon')
  ,'back to');
DefLngNationDir(quintana,  Quintana,  'qn'|'quintana'|'roo'|'quintana' 'roo'
  ,'back to');
DefLngNationDir(sanluis,   SanLuis, /*'sl'|*/('san'|) 'luis'|('san'|'luis'|'san' 'luis'|) ('potosi'|'potos\u00ED')
  ,'back to');
/*
class PassToBajaCali  : MexPass
  vocabWords='baja california bc'
  name='Baja California'
;
class PassToBajaSur   : MexPass
  vocabWords='baja california sur bs'
  name='Baja California Sur'
;
class PassToDistrito  : MexPass
  vocabWords='distrito federal df'
  name='Distrito Federal'
;
class PassToNuevoLeon : MexPass
  vocabWords='nuevo leon le\u00F3n nl'
  name='Nuevo Le\u00F3n'
;
class PassToQuintana  : MexPass
  vocabWords='quintana roo qn'
  name='Quintana Roo'
;
class PassToSanLuis   : MexPass
  vocabWords='san luis potosi potos\u00ED sl'
  name='San Luis Potos\u00ED'
;
*/
// -------------------------------------------------------------------
// NATION MAZES: DIRECTIONS: AMBIGUOUS DIRECTION HACKS
// -------------------------------------------------------------------

DefineDirection(ne, Compass, 1450); // northeast   /Niger
DefineDirection(cm, AfrMex, 12510); // Cameroon    /Campeche
DefineDirection(gn, AfrMex, 12520); // Guinea      /Guanajuato
DefineDirection(mr, AfrMex, 12530); // Mauritania  /Morelos
DefineDirection(sl, AfrMex, 12540); // Sierra Leone/San Luis Potosi
DefineDirection(so, AfrMex, 12550); // Somalia     /Sonora

DefineLangDir  (ne,     'ne', 'back to the');
DefLngNationDir(cm, cm, 'cm', 'back to'    );
DefLngNationDir(gn, gn, 'gn', 'back to'    );
DefLngNationDir(mr, mr, 'mr', 'back to'    );
DefLngNationDir(sl, sl, 'sl', 'back to'    );
DefLngNationDir(so, so, 'so', 'back to'    );

class AfricaRoom: NationRoom
  cm : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Cameroon)
  }
  gn : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Guinea)
  }
  mr : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Mauritania)
  }
  sl : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(SierLeon)
  }
  so : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Somalia)
  }
  resetThisMazeSet {
    afrMsg.afrPassCount = 0;
    afrMsg.africaPassCount = 0;
    glob.africaHintState = 0;
    africaSign.hasBeenDescribed = nil;
    for(local cur=firstObj(AfricaRoom); cur != nil; cur=nextObj(cur,AfricaRoom)) {
      cur.beenThere = nil;
    }
    inherited();
  }
;
class MexicanRoom: NationRoom
  cm : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Campeche)
  }
  gn : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Guanajuato)
  }
  mr : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Morelos)
  }
  sl : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(SanLuis)
  }
  so : TravelConnector {
    isConnectorListed = nil
    dobjFor(TravelVia) remapTo(Sonora)
  }
  resetThisMazeSet {
    mexMsg.mexPassCount = 0;
    mexMsg.mexicoPassCount = 0;
    glob.mexicoHintState = 0;
    mexicoSign.hasBeenDescribed = nil;
    for(local cur=firstObj(MexicanRoom); cur != nil; cur=nextObj(cur,MexicanRoom)) {
      cur.beenThere = nil;
    }
    inherited();
  }
;
modify Room
  //northeast = nil
  //ne  asExit(northeast)
  ne : TravelConnector { 
    isConnectorListed = nil
    //getDestination(origin, traveler) { self.ofKind(nil); return nil; }
    dobjFor(TravelVia) remapTo(Northeast) 
  } 
  //getDestination(origin, traveler) { return nil; }
  //ne {
  //  if (northeast != nil)
  //    static (ne.createUnlistedProxy())
  //}
;

DefineAction(Cameroon, TravelAction)
  getDirection = cameroonDirection
;
DefineAction(Guinea, TravelAction)
  getDirection = guineaDirection
;
DefineAction(Mauritania, TravelAction)
  getDirection = mauritaniaDirection
;
DefineAction(SierLeon, TravelAction)
  getDirection = sierleonDirection
;
DefineAction(Somalia, TravelAction)
  getDirection = somaliaDirection
;
DefineAction(Campeche, TravelAction)
  getDirection = campecheDirection
;
DefineAction(Guanajuato, TravelAction)
  getDirection = guanajuatoDirection
;
DefineAction(Morelos, TravelAction)
  getDirection = morelosDirection
;
DefineAction(SanLuis, TravelAction)
  getDirection = sanluisDirection
;
DefineAction(Sonora, TravelAction)
  getDirection = sonoraDirection
;

// -------------------------------------------------------------------
// NATION MAZES: DIRECTIONS: EXITLISTER MODIFICATIONS
// -------------------------------------------------------------------

modify ExitLister
  showListPrefixWide(cnt, pov, parent) {
    if (cnt == 1)
      "The only obvious exit leads ";
    else
      "Obvious exits lead ";
    // My hack:
    if (gNbmLoc.isNation) "to ";
  }
  /*
  showListSuffixWide(cnt, pov, parent) { ". "; }
  isListed(obj) { return true; }
  listCardinality(obj) { return 1; }
  */
  ///*
  showListItem(obj, options, pov, infoTab) {
    // Show the back-to-direction prefix, if we don't know the
    // destination name but this is the back-to direction: "back to
    // the north" and so on. 
    if (obj.destIsBack_ && obj.destName_ == nil)
      say(obj.dir_.backToPrefix + ' ');
    // show the direction
    showListItemDirName(obj, nil);
    // if the destination is known --
    // and if location is not a "nation" location --
    // then show it as well
    if (obj.destName_ != nil && !gNbmLoc.isNation) {
      // if we have a list of other directions going to the same
      // place, show it parenthetically 
      otherExitLister.showListAll(obj.others_, 0, 0);
      // Show our destination name.  If we know the "back to"
      // destination name, show destination names in the format
      // "east, to the living room" so that they are consistent
      // with "west, back to the dining room".  Otherwise, just
      // show "east to the living room".  
      if ((options & hasBackNameFlag) != 0)
        ",";
      // if this is the way back, say so
      if (obj.destIsBack_)
        " back";
      // show the destination
      " to <<obj.destName_>>";
    }
  }
  //*/
  /*
  showListSeparator(options, curItemNum, totalItems) {
    // if we have a "back to" name, use the "long" notation - this is
    // important because we'll use commas in the directions with
    // known destination names 
    if ((options & hasBackNameFlag) != 0)
        options |= ListLong;
    // for a two-item list, if either item has a destination name,
    // show a comma or semicolon (depending on 'long' vs 'short' list
    // mode) before the "and"; for anything else, use the default
    // handling 
    if (curItemNum == 1
      && totalItems == 2
      && (options & hasDestNameFlag) != 0) {
      if ((options & ListLong) != 0)
        "; and ";
      else
        ", and ";
    }
    else
      inherited(options, curItemNum, totalItems);
  }
  // show a direction name, hyperlinking it if appropriate
  showListItemDirName(obj, initCap)
  {
    local dirname;
    // get the name
    dirname = obj.dir_.name;
    // capitalize the first letter, if desired
    if (initCap)
      dirname = dirname.substr(1,1).toUpper() + dirname.substr(2);
    // show the name with a hyperlink or not, as configured
    if (libGlobal.exitListerObj.enableHyperlinks)
      say(aHref(dirname, dirname));
    else
      say(dirname);
  }
  // this lister shows destination names
  listerShowsDest = true
  // 
  //   My special options flag: at least one object in the list has a
  //   destination name.  The caller should set this flag in our options
  //   if applicable. 
  //
  hasDestNameFlag = ListerCustomFlag(1)
  hasBackNameFlag = ListerCustomFlag(2)
  nextCustomFlag = ListerCustomFlag(3)
  */
;

// -------------------------------------------------------------------
// NATION MAZES: MESSAGES
// -------------------------------------------------------------------

//http://en.wikipedia.org/wiki/List_of_animal_names

camels: object
  name = 'camels'
  herdName = 'herd'
  threateningGesture =
    "The great beasts growl, spit, and brandish their hooves,
      firmly defending their side of the border. "
;
crocodiles: object
  name = 'crocodiles'
  herdName = 'group' // Wikipedia says "bask" of crocodiles. I, however, would rather speak English.
  threateningGesture =
    "The reptiles growl and snap their jaws, 
      firmly defending their side of the border. "
;
hippos: object
  name = 'hippos'
  herdName = 'group' // Wikipedia says "bloat" of hippos. I did not laugh at this joke.
  threateningGesture =
    "The great beasts gape their jaws threateningly, 
      defending their side of the border. "
;
elephants: object
  name = 'elephants'
  herdName = 'herd'
  threateningGesture =
    "The great beasts trumpet and stamp their hooves, 
      firmly defending their side of the border. "
;
hyenas: object
  name = 'hyenas'
  herdName = 'pack'
  threateningGesture =
    "The animals growl and brandish their teeth, 
      firmly defending their side of the border. "
;
lions: object
  name = 'lions'
  herdName = 'pack' // I could say "pride", but "pack" sounds more natural to me in this context
  threateningGesture =
    "The great beasts growl with enormous ferocity, 
      defending their side of the border. "
;
rhinos: object
  name = 'rhinos'
  herdName = 'band' // Wikipedia, ever-absurd, says "crash" of rhinos.
  threateningGesture =
    "The great beasts brandish their horns fiercely, 
      defending their side of the border. "
;
ostriches: object
  name = 'ostriches'
  herdName = 'flock'
  threateningGesture =
    "The giant birds leap into the air and make kicking gestures, 
      firmly defending their side of the border. "
;
jackals: object
  name = 'jackals'
  herdName = 'pack'
  threateningGesture =
    "The animals growl and brandish their teeth, 
      firmly defending their side of the border. "
;

afrMsg: object
  // See also:
  // ambigCompass function
  // alreadyInNation function
  afrPassDesc(x) {
    //(<<x.destination.abbr>>) 
    "<<capthex(x.name)>> is visible on the ";
    if (!x.passDir)
      "horizon. ";
    else if (x.vague)
      "horizon, more or less to the <<x.passDir>>. ";
    else
      "<<x.passDir>>ern horizon. ";
  }
  afrPassBarrier(x) {
    "Sheila wanders off towards <<thex(x.name)>>, but is met 
      at the border by a <<x.asscAnimals.herdName>> of wild
      <<x.asscAnimals.name>>! 
      <<x.asscAnimals.threateningGesture>>";
    afrPassCount++;
    switch (afrPassCount) {
      case 1:
        "<p><.q>Uh oh,<./q> says Sheila. <.q>Looks like I 
          escaped from there just in time. 
          I<./s>m not sure I<./s>ll be able to get back in there!<./q> ";
        "<p>Sheila wisely retreats back where she came from, and 
          at length the <<x.asscAnimals.name>> disappear back
          into the wilderness. ";
        break;
      //case 2:
      //  " ";
      //  break;
      //case 3:
      //  " ";
      //  break;
      default:
        "Sheila wisely retreats back where she came from, and 
          at length the <<x.asscAnimals.name>> disappear back
          into the wilderness. ";
        break;
    }
    //"Sorry, but you<./s>ve already been to <<thex(x)>> and can<./s>t go back. ";
  }
  afrPassCount = 0
  afrAmbAfrica {
    "You<./s>ll have to be more specific about where you want to go. ";
  }
  //passSahara(x) {
  //  "{You/he} trot{s} across the Sahara into <<thex(x)>>. ";
  //}
  passGeneric(x) {
    //"{You/he} head{s} into <<thex(x)>>. ";
    //"{You/he} head{s} from 
    //  <<thex(bot.getOutermostRoom.name)>> 
    //  into <<thex(x)>>. ";
    if (africaPassCount < 5)
      africaPassCount++;
    switch (africaPassCount) {
      case 1:
        "As Sheila wheels across the border into <<thex(x)>>,
          she thinks she hears some rustling coming from the land
          behind her. She turns to look, but nothing is visible,
          so she continues on into <<thex(x)>>. ";
        break;
      case 2:
        "As Sheila passes over the border into <<thex(x)>>,
          once again she thinks she hears some rustling. ";
        break;
      case 3:
        "Just as before, when Sheila passes over the border,
          she thinks she hears some rustling. ";
        break;
      case 4:
        "As always, when Sheila passes over the border,
          she thinks she hears some rustling. ";
        break;
    }
  }
  africaPassCount = 0
  thex(x)    { thexarg(x, nil ); }
  capthex(x) { thexarg(x, true); }
  thexarg(x, cap) {
    if (x == 'Democratic Republic of the Congo' /*|| x == 'Gambia'*/) {
      if (cap) "The ";
      else "the ";
    }
    "<<x>>";
  }
;

modify glob
  thexahref(x, ahref) {
    if (x == demorepuRoom)
      "the ";
    "<a href='<<ahref>>'>";
    "<<x.name>>";
    "</a>";
  }
;

mexMsg: object
  // See also:
  // ambigCompass function
  // alreadyInNation function
  mexPassDesc(x) {
    //(<<x.destination.abbr>>) 
    "<<capthex(x.name)>> is visible on the ";
    if (!x.passDir)
      "horizon. ";
    else if (x.vague)
      "horizon, more or less to the <<x.passDir>>. ";
    else
      "<<x.passDir>>ern horizon. ";
  }
  mexPassBarrier(x) {
    "Sheila wanders off towards <<thex(x.name)>>, but is met 
      at the border by a pack of wild chupacabras! 
      The fierce beasts growl and bare their teeth, 
      defending their side of the border. ";
    mexPassCount++;
    switch (mexPassCount) {
      case 1:
        "<p><.q>Uh oh,<./q> says Sheila. <.q>Looks like I 
          escaped from there just in time. 
          I<./s>m not sure I<./s>ll be able to get back in there!<./q> ";
        "<p>Sheila wisely retreats back where she came from, and 
          at length the chupacabras disappear back into the wilderness. ";
        break;
      //case 2:
      //  " ";
      //  break;
      //case 3:
      //  " ";
      //  break;
      default:
        "Sheila wisely retreats back where she came from, and 
          at length the chupacabras disappear back into the wilderness. ";
        break;
    }
    //"Sorry, but you<./s>ve already been to <<thex(x)>> and can<./s>t go back. ";
  }
  mexPassCount = 0
  //afrPassBarrier(x) {
  //  "Sorry, but you've already been to <<thex(x)>> and can't go back. ";
  //}
  //afrAmbAfrica {
  //  "You<./s>ll have to be more specific about where you want to go. ";
  //}
  passGeneric(x) {
    //"{You/he} head{s} into <<thex(x)>>. ";
    //"{You/he} head{s} from 
    //  <<thex(bot.getOutermostRoom.name)>> 
    //  into <<thex(x)>>. ";
    if (mexicoPassCount < 5)
      mexicoPassCount++;
    switch (mexicoPassCount) {
      case 1:
        "As Sheila wheels across the border into <<thex(x)>>,
          she thinks she hears some rustling coming from the land
          behind her. She turns to look, but nothing is visible,
          so she continues on into <<thex(x)>>. ";
        break;
      case 2:
        "As Sheila passes over the border into <<thex(x)>>,
          once again she thinks she hears some rustling. ";
        break;
      case 3:
        "Just as before, when Sheila passes over the border,
          she thinks she hears some rustling. ";
        break;
      case 4:
        "As always, when Sheila passes over the border,
          she thinks she hears some rustling. ";
        break;
    }
  }
  mexicoPassCount = 0
  thex(x)    { thexarg(x, nil ); }
  capthex(x) { thexarg(x, true); }
  thexarg(x, cap) {
    if (x == 'The Name of a Mexican State That Needs <.q>The<./q> in 
        front of it, if any') {
      if (cap) "The ";
      else "the ";
    }
    "<<x>>";
  }
;

function ambigCompass([dirs]) {
  local a;
  local b;
  local num;
  num = dirs.length;
  "Where do you want to go, ";
  for (a = 1; a <= num; ++a) {
    b = dirs[a];
    say(b.capname);
    say(' (' + b.abbr + ')');
    if (a < num) {
      if (num >= 3) ", ";
      else " ";
    }
    if (a == num - 1) "or ";
  }
  "? ";
}

function alreadyInNation() {
  "You<./s>re already in ";
  if (gNbmLoc == demorepuRoom || gNbmLoc == gambiaRoom) "the ";
  say (gNbmLoc.capname);
  ". ";
}

// -------------------------------------------------------------------
// NATION MAZES: PASSAGES: CLASSES: GENERAL PASSAGE CLASSES
// -------------------------------------------------------------------

class NbmEnterable: /*TravelConnectorLink,*/ Fixture
  dobjFor(Enter)     remapTo(TravelVia, self)
  dobjFor(GoThrough) remapTo(TravelVia, self)
  mapPushTravelIobj(PushTravelEnter, TravelVia)
  //nbmConn = self
  connector = nil
  //dobjFor(TravelVia) {
  //  // the physical link object has to be touchable
  //  preCond = [touchObj]
  //  verify() { }
  //  action() {
  //    // carry out the action by traveling via our connector
  //    replaceAction(TravelVia, nbmConn);
  //  }
  //}
;

class NationPassage: object;

class AfrPass: NbmEnterable, TravelWithMessage, Passage, NationPassage
  desc = afrMsg.afrPassDesc(self)
  //desc {
  //  "<<name>> (<<destination.abbr>>) is visible on the ";
  //  if (vague)
  //    "horizon, more or less to the <<passDir>>. ";
  //  else
  //    "<<passDir>>ern horizon. ";
  //}
  vague = nil
  passDir {
    if (determine(gNbmLoc.north    ) == self.destination) return 'north';
    if (determine(gNbmLoc.south    ) == self.destination) return 'south';
    if (determine(gNbmLoc.east     ) == self.destination) return 'east';
    if (determine(gNbmLoc.west     ) == self.destination) return 'west';
    if (determine(gNbmLoc.northeast) == self.destination) return 'northeast';
    if (determine(gNbmLoc.northwest) == self.destination) return 'northwest';
    if (determine(gNbmLoc.southeast) == self.destination) return 'southeast';
    if (determine(gNbmLoc.southwest) == self.destination) return 'southwest';
    //self.ofKind(nil);
    return nil;
  }
  determine(d) {
    //self.ofKind(nil);
    if (d == nil) return nil;
    if (d.ofKind(UnlistedProxyConnector)) 
      return d.destination;
    // Otherwise, we assume that d is a room.
    return d;
  }
  canTravelerPass(traveler) {
    return !destination.beenThere;
  }
  explainTravelBarrier (traveler) {
    afrMsg.afrPassBarrier(destination);
    //"Sorry, but you've already been to that country and can't go back. ";
  }
;

class MexPass: NbmEnterable, TravelWithMessage, Passage, NationPassage
  desc = mexMsg.mexPassDesc(self)
  vague = nil
  passDir {
    if (determine(gNbmLoc.north    ) == self.destination) return 'north';
    if (determine(gNbmLoc.south    ) == self.destination) return 'south';
    if (determine(gNbmLoc.east     ) == self.destination) return 'east';
    if (determine(gNbmLoc.west     ) == self.destination) return 'west';
    if (determine(gNbmLoc.northeast) == self.destination) return 'northeast';
    if (determine(gNbmLoc.northwest) == self.destination) return 'northwest';
    if (determine(gNbmLoc.southeast) == self.destination) return 'southeast';
    if (determine(gNbmLoc.southwest) == self.destination) return 'southwest';
    //self.ofKind(nil);
    return nil;
  }
  determine(d) {
    //self.ofKind(nil);
    if (d == nil) return nil;
    if (d.ofKind(UnlistedProxyConnector)) 
      return d.destination;
    // Otherwise, we assume that d is a room.
    return d;
  }
  canTravelerPass(traveler) {
    return !destination.beenThere;
  }
  explainTravelBarrier (traveler) {
    mexMsg.mexPassBarrier(destination);
    //"Sorry, but you've already been there and can't go back. ";
  }
;

// -------------------------------------------------------------------
// NATION MAZES: PASSAGES: CLASSES: AFRICA PASSAGE CLASSES
// -------------------------------------------------------------------

class PassToAlgeria   : AfrPass vocabWords='dz/algeria'    name='Algeria'   ;
class PassToAngola    : AfrPass vocabWords='ao/angola'     name='Angola'    ;
class PassToBenin     : AfrPass vocabWords='bj/benin'      name='Benin'     ;
class PassToBotswana  : AfrPass vocabWords='bw/botswana'   name='Botswana'  ;
class PassToBurundi   : AfrPass vocabWords='bi/burundi'    name='Burundi'   ;
class PassToCameroon  : AfrPass vocabWords='cm/cameroon'   name='Cameroon'  ;
class PassToChad      : AfrPass vocabWords='td/chad'       name='Chad'      ;
class PassToCongo     : AfrPass vocabWords='cg/congo'      name='Congo'     ;
class PassToDjibouti  : AfrPass vocabWords='dj/djibouti'   name='Djibouti'  ;
class PassToEgypt     : AfrPass vocabWords='eg/egypt'      name='Egypt'     ;
class PassToEritrea   : AfrPass vocabWords='er/eritrea'    name='Eritrea'   ;
class PassToEthiopia  : AfrPass vocabWords='et/ethiopia'   name='Ethiopia'  ;
class PassToGabon     : AfrPass vocabWords='ga/gabon'      name='Gabon'     ;
class PassToGambia    : AfrPass vocabWords='gm/gambia'     name='Gambia'    ;
class PassToGhana     : AfrPass vocabWords='gh/ghana'      name='Ghana'     ;
class PassToGuinea    : AfrPass vocabWords='gn/guinea'     name='Guinea'    ;
class PassToKenya     : AfrPass vocabWords='ke/kenya'      name='Kenya'     ;
class PassToLesotho   : AfrPass vocabWords='ls/lesotho'    name='Lesotho'   ;
class PassToLiberia   : AfrPass vocabWords='lr/liberia'    name='Liberia'   ;
class PassToLibya     : AfrPass vocabWords='ly/libya'      name='Libya'     ;
class PassToMalawi    : AfrPass vocabWords='mw/malawi'     name='Malawi'    ;
class PassToMali      : AfrPass vocabWords='ml/mali'       name='Mali'      ;
class PassToMauritania: AfrPass vocabWords='mr/mauritania' name='Mauritania';
class PassToMorocco   : AfrPass vocabWords='ma/morocco'    name='Morocco'   ;
class PassToMozambique: AfrPass vocabWords='mz/mozambique' name='Mozambique';
class PassToNamibia   : AfrPass vocabWords='na/namibia'    name='Namibia'   ;
class PassToNiger     : AfrPass vocabWords='ne/niger'      name='Niger'     ;
class PassToNigeria   : AfrPass vocabWords='ng/nigeria'    name='Nigeria'   ;
class PassToRwanda    : AfrPass vocabWords='rw/rwanda'     name='Rwanda'    ;
class PassToSenegal   : AfrPass vocabWords='(le) sn/senegal/s\u00E9n\u00E9gal' name='Senegal';
class PassToSomalia   : AfrPass vocabWords='so/somalia'    name='Somalia'   ;
class PassToSudan     : AfrPass vocabWords='sd/sudan'      name='Sudan'     ;
class PassToSwaziland : AfrPass vocabWords='sz/swaziland'  name='Swaziland' ;
class PassToTanzania  : AfrPass vocabWords='tz/tanzania'   name='Tanzania'  ;
class PassToTogo      : AfrPass vocabWords='tg/togo'       name='Togo'      ;
class PassToTunisia   : AfrPass vocabWords='tn/tunisia'    name='Tunisia'   ;
class PassToUganda    : AfrPass vocabWords='ug/uganda'     name='Uganda'    ;
class PassToZambia    : AfrPass vocabWords='zm/zambia'     name='Zambia'    ;
class PassToZimbabwe  : AfrPass vocabWords='zw/zimbabwe'   name='Zimbabwe'  ;
class PassToSouthSudan: AfrPass
  vocabWords = 'south sudan ss' // sudan left as an adjective to flag it as a less likely choice than sudan if you're in Ethiopia and you type "X SUDAN".
  name       = 'South Sudan'
;
class PassToBurkFaso: AfrPass
  vocabWords = 'burkina faso/bf'
  name       = 'Burkina Faso'
;
class PassToEquaGuin: AfrPass
  vocabWords = 'equatorial guinea/gq'
  name       = 'Equatorial Guinea'
;
class PassToSierLeon: AfrPass
  vocabWords = 'sierra leone/sl'
  name       = 'Sierra Leone'
;
class PassToWestSaha: AfrPass
  vocabWords = 'western sahara/eh'
  name       = 'Western Sahara'
;
class PassToIvorCoas: AfrPass
  vocabWords = 'ivory cote c\u00F4te (d) (de) coast/divoire/d\'ivoire/ivoire/ci'
  name       = 'C\u00F4te d<./s>Ivoire'
;
class PassToCentAfri: AfrPass
  vocabWords = 'central african republic/cf'
  name       = 'Central African Republic'
;
class PassToGuinBiss: AfrPass
  vocabWords = 'guinea bissau/guinea-bissau/guineabissau/gw'
  name       = 'Guinea-Bissau'
;
class PassToSoutAfri: AfrPass
  vocabWords = 'south africa/za'
  name       = 'South Africa'
;
class PassToDemoRepu: AfrPass
  vocabWords = 'democratic republic of the congo/zaire/za\u00EFre/zr/cd'
  name       = 'Democratic Republic of the Congo'
;

// -------------------------------------------------------------------
// NATION MAZES: PASSAGES: CLASSES: MEXICO PASSAGE CLASSES
// -------------------------------------------------------------------

class PassToAguascal  : MexPass vocabWords='ag/aguascalientes' name='Aguascalientes';
class PassToCampeche  : MexPass vocabWords='cm/campeche'   name='Campeche'  ;
class PassToChiapas   : MexPass vocabWords='cp/chiapas'    name='Chiapas'   ;
class PassToChihuahua : MexPass vocabWords='ch/chihuahua'  name='Chihuahua' ;
class PassToCoahuila  : MexPass vocabWords='co/coahuila'   name='Coahuila'  ;
class PassToColima    : MexPass vocabWords='cl/colima'     name='Colima'    ;
class PassToDurango   : MexPass vocabWords='dr/durango'    name='Durango'   ;
class PassToGuanajuato: MexPass vocabWords='gn/guanajuato' name='Guanajuato';
class PassToGuerrero  : MexPass vocabWords='gr/guerrero'   name='Guerrero'  ;
class PassToHidalgo   : MexPass vocabWords='hd/hidalgo'    name='Hidalgo'   ;
class PassToJalisco   : MexPass vocabWords='jl/jalisco'    name='Jalisco'   ;
class PassToMexico    : MexPass vocabWords='mx/mexico/m\u00E9xico' name='M\u00E9xico';
class PassToMichoacan : MexPass vocabWords='mc/michoacan/michoac\u00E1n' name='Michoac\u00E1n';
class PassToMorelos   : MexPass vocabWords='mr/morelos'    name='Morelos'   ;
class PassToNayarit   : MexPass vocabWords='ny/nayarit'    name='Nayarit'   ;
class PassToOaxaca    : MexPass vocabWords='ox/oaxaca'     name='Oaxaca'    ;
class PassToPuebla    : MexPass vocabWords='pb/puebla'     name='Puebla'    ;
class PassToQueretaro : MexPass vocabWords='qr/queretaro/quer\u00E9taro' name='Quer\u00E9taro';
class PassToSinaloa   : MexPass vocabWords='si/sinaloa'    name='Sinaloa'   ;
class PassToSonora    : MexPass vocabWords='so/sonora'     name='Sonora'    ;
class PassToTabasco   : MexPass vocabWords='tb/tabasco'    name='Tabasco'   ;
class PassToTamaulipas: MexPass vocabWords='tm/tamaulipas' name='Tamaulipas';
class PassToTlaxcala  : MexPass vocabWords='tl/tlaxcala'   name='Tlaxcala'  ;
class PassToVeracruz  : MexPass vocabWords='vr/veracruz'   name='Veracruz'  ;
class PassToYucatan   : MexPass vocabWords='yc/yucatan/yucat\u00E1n' name='Yucat\u00E1n';
class PassToZacatecas : MexPass vocabWords='zc/zacatecas'  name='Zacatecas' ;
class PassToBajaCali  : MexPass
  vocabWords='baja california bc'
  name='Baja California'
;
class PassToBajaSur   : MexPass
  vocabWords='(baja) (california) sur bs'
  name='Baja California Sur'
;
class PassToDistrito  : MexPass
  vocabWords='distrito federal df'
  name='Distrito Federal'
;
class PassToNuevoLeon : MexPass
  vocabWords='nuevo leon le\u00F3n nl'
  name='Nuevo Le\u00F3n'
;
class PassToQuintana  : MexPass
  vocabWords='quintana roo qn'
  name='Quintana Roo'
;
class PassToSanLuis   : MexPass
  vocabWords='san luis potosi potos\u00ED sl'
  name='San Luis Potos\u00ED'
;

// -------------------------------------------------------------------
// NATION MAZES: PASSAGES: AFRICA PASSAGES
// -------------------------------------------------------------------

NationPassage template @location? "travelDesc"?;
NationPassage template @location? "travelDesc"? ->masterObject?;

afrPassMoroWest: PassToWestSaha   @moroccoRoom    "<<afrMsg.passGeneric(name)>>";
afrPassMoroAlge: PassToAlgeria    @moroccoRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassAlgeMoro;
afrPassAlgeMoro: PassToMorocco    @algeriaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassAlgeWest: PassToWestSaha   @algeriaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassAlgeMaur: PassToMauritania @algeriaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassAlgeMali: PassToMali       @algeriaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassAlgeNige: PassToNiger      @algeriaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassAlgeLiby: PassToLibya      @algeriaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassAlgeTuni: PassToTunisia    @algeriaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassTuniAlge: PassToAlgeria    @tunisiaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassAlgeTuni;
afrPassTuniLiby: PassToLibya      @tunisiaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassLibyTuni;
afrPassLibyTuni: PassToTunisia    @libyaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassLibyAlge: PassToAlgeria    @libyaRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassAlgeLiby;
afrPassLibyNige: PassToNiger      @libyaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassLibyChad: PassToChad       @libyaRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassChadLiby;
afrPassLibySuda: PassToSudan      @libyaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassLibyEgyp: PassToEgypt      @libyaRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassEgypLiby;
afrPassEgypLiby: PassToLibya      @egyptRoom      "<<afrMsg.passGeneric(name)>>";
afrPassEgypSuda: PassToSudan      @egyptRoom      "<<afrMsg.passGeneric(name)>>";
afrPassWestMoro: PassToMorocco    @westsahaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassMoroWest;
afrPassWestAlge: PassToAlgeria    @westsahaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassAlgeWest;
afrPassWestMaur: PassToMauritania @westsahaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassMaurWest;
afrPassMaurWest: PassToWestSaha   @mauritaniaRoom "<<afrMsg.passGeneric(name)>>";
afrPassMaurAlge: PassToAlgeria    @mauritaniaRoom "<<afrMsg.passGeneric(name)>>" -> afrPassAlgeMaur;
afrPassMaurMali: PassToMali       @mauritaniaRoom "<<afrMsg.passGeneric(name)>>" -> afrPassMaliMaur;
afrPassMaurSene: PassToSenegal    @mauritaniaRoom "<<afrMsg.passGeneric(name)>>";
afrPassMaliMaur: PassToMauritania @maliRoom       "<<afrMsg.passGeneric(name)>>";
afrPassMaliAlge: PassToAlgeria    @maliRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassAlgeMali;
afrPassMaliNige: PassToNiger      @maliRoom       "<<afrMsg.passGeneric(name)>>";
afrPassMaliBurk: PassToBurkFaso   @maliRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassBurkMali;
afrPassMaliIvor: PassToIvorCoas   @maliRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassIvorMali;
afrPassMaliGuin: PassToGuinea     @maliRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassGuinMali;
afrPassMaliSene: PassToSenegal    @maliRoom       "<<afrMsg.passGeneric(name)>>";
afrPassNigeBeni: PassToBenin      @nigerRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassBeniNige;
afrPassNigeBurk: PassToBurkFaso   @nigerRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassBurkNige;
afrPassNigeMali: PassToMali       @nigerRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassMaliNige;
afrPassNigeAlge: PassToAlgeria    @nigerRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassAlgeNige;
afrPassNigeLiby: PassToLibya      @nigerRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassLibyNige;
afrPassNigeChad: PassToChad       @nigerRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassChadNige;
afrPassNigeNiri: PassToNigeria    @nigerRoom      "<<afrMsg.passGeneric(name)>>";
afrPassChadCame: PassToCameroon   @chadRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassCameChad;
afrPassChadNiri: PassToNigeria    @chadRoom       "<<afrMsg.passGeneric(name)>>";
afrPassChadNige: PassToNiger      @chadRoom       "<<afrMsg.passGeneric(name)>>";
afrPassChadLiby: PassToLibya      @chadRoom       "<<afrMsg.passGeneric(name)>>";
afrPassChadSuda: PassToSudan      @chadRoom       "<<afrMsg.passGeneric(name)>>";
afrPassChadCent: PassToCentAfri   @chadRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassCentChad;
afrPassSudaEgyp: PassToEgypt      @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassEgypSuda;
afrPassSudaLiby: PassToLibya      @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassLibySuda;
afrPassSudaChad: PassToChad       @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassChadSuda;
afrPassSudaCent: PassToCentAfri   @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassCentSuda;
afrPassSudaEthi: PassToEthiopia   @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassEthiSuda;
afrPassSudaErit: PassToEritrea    @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassEritSuda;
afrPassEritSuda: PassToSudan      @eritreaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassEritEthi: PassToEthiopia   @eritreaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassEritDjib: PassToDjibouti   @eritreaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassDjibErit;
afrPassEthiErit: PassToEritrea    @ethiopiaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassEritEthi;
afrPassEthiDjib: PassToDjibouti   @ethiopiaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassDjibEthi;
afrPassEthiSoma: PassToSomalia    @ethiopiaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassEthiKeny: PassToKenya      @ethiopiaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassEthiSuda: PassToSudan      @ethiopiaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDjibErit: PassToEritrea    @djiboutiRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDjibEthi: PassToEthiopia   @djiboutiRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDjibSoma: PassToSomalia    @djiboutiRoom   "<<afrMsg.passGeneric(name)>>";
afrPassSomaDjib: PassToDjibouti   @somaliaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassDjibSoma;
afrPassSomaEthi: PassToEthiopia   @somaliaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassEthiSoma;
afrPassSomaKeny: PassToKenya      @somaliaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassKenySoma;
afrPassSeneMaur: PassToMauritania @senegalRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassMaurSene;
afrPassSeneMali: PassToMali       @senegalRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassMaliSene;
afrPassSeneGuin: PassToGuinea     @senegalRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassGuinSene;
afrPassSeneGubi: PassToGuinBiss   @senegalRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassGubiSene;
afrPassSeneGamb: PassToGambia     @senegalRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassGambSene;
afrPassGambSene: PassToSenegal    @gambiaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassGubiSene: PassToSenegal    @guinbissRoom   "<<afrMsg.passGeneric(name)>>";
afrPassGubiGuin: PassToGuinea     @guinbissRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassGuinGubi;
afrPassGuinGubi: PassToGuinBiss   @guineaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassGuinSene: PassToSenegal    @guineaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassGuinMali: PassToMali       @guineaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassGuinIvor: PassToIvorCoas   @guineaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassGuinLibe: PassToLiberia    @guineaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassGuinSier: PassToSierLeon   @guineaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassSierGuin: PassToGuinea     @sierleonRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassGuinSier;
afrPassSierLibe: PassToLiberia    @sierleonRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassLibeSier;
afrPassLibeSier: PassToSierLeon   @liberiaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassLibeGuin: PassToGuinea     @liberiaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassGuinLibe;
afrPassLibeIvor: PassToIvorCoas   @liberiaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassIvorLibe;
afrPassIvorLibe: PassToLiberia    @ivorcoasRoom   "<<afrMsg.passGeneric(name)>>";
afrPassIvorGuin: PassToGuinea     @ivorcoasRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassGuinIvor;
afrPassIvorMali: PassToMali       @ivorcoasRoom   "<<afrMsg.passGeneric(name)>>";
afrPassIvorBurk: PassToBurkFaso   @ivorcoasRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassBurkIvor;
afrPassIvorGhan: PassToGhana      @ivorcoasRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassGhanIvor;
afrPassBurkIvor: PassToIvorCoas   @burkfasoRoom   "<<afrMsg.passGeneric(name)>>";
afrPassBurkMali: PassToMali       @burkfasoRoom   "<<afrMsg.passGeneric(name)>>";
afrPassBurkNige: PassToNiger      @burkfasoRoom   "<<afrMsg.passGeneric(name)>>";
afrPassBurkBeni: PassToBenin      @burkfasoRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassBeniBurk;
afrPassBurkTogo: PassToTogo       @burkfasoRoom   "<<afrMsg.passGeneric(name)>>";
afrPassBurkGhan: PassToGhana      @burkfasoRoom   "<<afrMsg.passGeneric(name)>>";
afrPassGhanIvor: PassToIvorCoas   @ghanaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassGhanBurk: PassToBurkFaso   @ghanaRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassBurkGhan;
afrPassGhanTogo: PassToTogo       @ghanaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassTogoGhan: PassToGhana      @togoRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassGhanTogo;
afrPassTogoBurk: PassToBurkFaso   @togoRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassBurkTogo;
afrPassTogoBeni: PassToBenin      @togoRoom       "<<afrMsg.passGeneric(name)>>" -> afrPassBeniTogo;
afrPassBeniTogo: PassToTogo       @beninRoom      "<<afrMsg.passGeneric(name)>>";
afrPassBeniBurk: PassToBurkFaso   @beninRoom      "<<afrMsg.passGeneric(name)>>";
afrPassBeniNige: PassToNiger      @beninRoom      "<<afrMsg.passGeneric(name)>>";
afrPassBeniNiri: PassToNigeria    @beninRoom      "<<afrMsg.passGeneric(name)>>";
afrPassNiriBeni: PassToBenin      @nigeriaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassBeniNiri;
afrPassNiriNige: PassToNiger      @nigeriaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassNigeNiri;
afrPassNiriChad: PassToChad       @nigeriaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassChadNiri;
afrPassNiriCame: PassToCameroon   @nigeriaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassCameNiri;
afrPassCameNiri: PassToNigeria    @cameroonRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCameChad: PassToChad       @cameroonRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCameCent: PassToCentAfri   @cameroonRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCameCong: PassToCongo      @cameroonRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCameGabo: PassToGabon      @cameroonRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCameEqua: PassToEquaGuin   @cameroonRoom   "<<afrMsg.passGeneric(name)>>";
afrPassEquaCame: PassToCameroon   @equaguinRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassCameEqua;
afrPassEquaGabo: PassToGabon      @equaguinRoom   "<<afrMsg.passGeneric(name)>>";
afrPassGaboEqua: PassToEquaGuin   @gabonRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassEquaGabo;
afrPassGaboCame: PassToCameroon   @gabonRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassCameGabo;
afrPassGaboCong: PassToCongo      @gabonRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassCongGabo;
afrPassCongGabo: PassToGabon      @congoRoom      "<<afrMsg.passGeneric(name)>>";
afrPassCongCame: PassToCameroon   @congoRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassCameCong;
afrPassCongCent: PassToCentAfri   @congoRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassCentCong;
afrPassCongDemo: PassToDemoRepu   @congoRoom      "<<afrMsg.passGeneric(name)>>";
afrPassCentCame: PassToCameroon   @centafriRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassCameCent;
afrPassCentChad: PassToChad       @centafriRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCentSuda: PassToSudan      @centafriRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCentDemo: PassToDemoRepu   @centafriRoom   "<<afrMsg.passGeneric(name)>>";
afrPassCentCong: PassToCongo      @centafriRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDemoCong: PassToCongo      @demorepuRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassCongDemo;
afrPassDemoCent: PassToCentAfri   @demorepuRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassCentDemo;
afrPassDemoUgan: PassToUganda     @demorepuRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDemoRwan: PassToRwanda     @demorepuRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDemoBuru: PassToBurundi    @demorepuRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassBuruDemo;
afrPassDemoTanz: PassToTanzania   @demorepuRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDemoZamb: PassToZambia     @demorepuRoom   "<<afrMsg.passGeneric(name)>>";
afrPassDemoAngo: PassToAngola     @demorepuRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassAngoDemo;
afrPassUganDemo: PassToDemoRepu   @ugandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassDemoUgan;
afrPassUganKeny: PassToKenya      @ugandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassKenyUgan;
afrPassUganTanz: PassToTanzania   @ugandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassTanzUgan;
afrPassUganRwan: PassToRwanda     @ugandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassRwanUgan;
afrPassKenyTanz: PassToTanzania   @kenyaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassKenyUgan: PassToUganda     @kenyaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassKenyEthi: PassToEthiopia   @kenyaRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassEthiKeny;
afrPassKenySoma: PassToSomalia    @kenyaRoom      "<<afrMsg.passGeneric(name)>>";
afrPassRwanUgan: PassToUganda     @rwandaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassRwanTanz: PassToTanzania   @rwandaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassRwanBuru: PassToBurundi    @rwandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassBuruRwan;
afrPassRwanDemo: PassToDemoRepu   @rwandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassDemoRwan;
afrPassBuruRwan: PassToRwanda     @burundiRoom    "<<afrMsg.passGeneric(name)>>";
afrPassBuruTanz: PassToTanzania   @burundiRoom    "<<afrMsg.passGeneric(name)>>";
afrPassBuruDemo: PassToDemoRepu   @burundiRoom    "<<afrMsg.passGeneric(name)>>";
afrPassTanzKeny: PassToKenya      @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassKenyTanz;
afrPassTanzUgan: PassToUganda     @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassTanzRwan: PassToRwanda     @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassRwanTanz;
afrPassTanzBuru: PassToBurundi    @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassBuruTanz;
afrPassTanzDemo: PassToDemoRepu   @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassDemoTanz;
afrPassTanzZamb: PassToZambia     @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassTanzMala: PassToMalawi     @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassMalaTanz;
afrPassTanzMoza: PassToMozambique @tanzaniaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassMozaTanz;
afrPassAngoDemo: PassToDemoRepu   @angolaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassAngoZamb: PassToZambia     @angolaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassAngoNami: PassToNamibia    @angolaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassZambNami: PassToNamibia    @zambiaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassNamiZamb;
afrPassZambAngo: PassToAngola     @zambiaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassAngoZamb;
afrPassZambDemo: PassToDemoRepu   @zambiaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassDemoZamb;
afrPassZambTanz: PassToTanzania   @zambiaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassTanzZamb;
afrPassZambMala: PassToMalawi     @zambiaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassMalaZamb;
afrPassZambMoza: PassToMozambique @zambiaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassMozaZamb;
afrPassZambZimb: PassToZimbabwe   @zambiaRoom     "<<afrMsg.passGeneric(name)>>";
afrPassZambBots: PassToBotswana   @zambiaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassBotsZamb;
afrPassMalaTanz: PassToTanzania   @malawiRoom     "<<afrMsg.passGeneric(name)>>";
afrPassMalaMoza: PassToMozambique @malawiRoom     "<<afrMsg.passGeneric(name)>>";
afrPassMalaZamb: PassToZambia     @malawiRoom     "<<afrMsg.passGeneric(name)>>";
afrPassMozaTanz: PassToTanzania   @mozambiqueRoom "<<afrMsg.passGeneric(name)>>";
afrPassMozaMala: PassToMalawi     @mozambiqueRoom "<<afrMsg.passGeneric(name)>>" -> afrPassMalaMoza;
afrPassMozaZamb: PassToZambia     @mozambiqueRoom "<<afrMsg.passGeneric(name)>>";
afrPassMozaZimb: PassToZimbabwe   @mozambiqueRoom "<<afrMsg.passGeneric(name)>>";
afrPassMozaSout: PassToSoutAfri   @mozambiqueRoom "<<afrMsg.passGeneric(name)>>";
afrPassMozaSwaz: PassToSwaziland  @mozambiqueRoom "<<afrMsg.passGeneric(name)>>";
afrPassNamiAngo: PassToAngola     @namibiaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassAngoNami;
afrPassNamiZamb: PassToZambia     @namibiaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassNamiBots: PassToBotswana   @namibiaRoom    "<<afrMsg.passGeneric(name)>>" -> afrPassBotsNami;
afrPassNamiSout: PassToSoutAfri   @namibiaRoom    "<<afrMsg.passGeneric(name)>>";
afrPassBotsNami: PassToNamibia    @botswanaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassBotsZamb: PassToZambia     @botswanaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassBotsZimb: PassToZimbabwe   @botswanaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassBotsSout: PassToSoutAfri   @botswanaRoom   "<<afrMsg.passGeneric(name)>>";
afrPassZimbZamb: PassToZambia     @zimbabweRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassZambZimb;
afrPassZimbMoza: PassToMozambique @zimbabweRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassMozaZimb;
afrPassZimbSout: PassToSoutAfri   @zimbabweRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassSoutZimb;
afrPassZimbBots: PassToBotswana   @zimbabweRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassBotsZimb;
afrPassSwazSout: PassToSoutAfri   @swazilandRoom  "<<afrMsg.passGeneric(name)>>" -> afrPassSoutSwaz;
afrPassSwazMoza: PassToMozambique @swazilandRoom  "<<afrMsg.passGeneric(name)>>" -> afrPassMozaSwaz;
afrPassSoutNami: PassToNamibia    @soutafriRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassNamiSout;
afrPassSoutBots: PassToBotswana   @soutafriRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassBotsSout;
afrPassSoutZimb: PassToZimbabwe   @soutafriRoom   "<<afrMsg.passGeneric(name)>>";
afrPassSoutMoza: PassToMozambique @soutafriRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassMozaSout;
afrPassSoutSwaz: PassToSwaziland  @soutafriRoom   "<<afrMsg.passGeneric(name)>>";
afrPassSoutLeso: PassToLesotho    @soutafriRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassLesoSout;
afrPassLesoSout: PassToSoutAfri   @lesothoRoom    "<<afrMsg.passGeneric(name)>>";

// South Sudan has added these passages to the map!
afrPassSosuSuda: PassToSudan      @southsudanRoom "<<afrMsg.passGeneric(name)>>";
afrPassSosuEthi: PassToEthiopia   @southsudanRoom "<<afrMsg.passGeneric(name)>>";
afrPassSosuKeny: PassToKenya      @southsudanRoom "<<afrMsg.passGeneric(name)>>";
afrPassSosuUgan: PassToUganda     @southsudanRoom "<<afrMsg.passGeneric(name)>>";
afrPassSosuDemo: PassToDemoRepu   @southsudanRoom "<<afrMsg.passGeneric(name)>>";
afrPassSosuCent: PassToCentAfri   @southsudanRoom "<<afrMsg.passGeneric(name)>>";
afrPassSudaSosu: PassToSouthSudan @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassSosuSuda;
afrPassEthiSosu: PassToSouthSudan @ethiopiaRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassSosuEthi;
afrPassKenySosu: PassToSouthSudan @kenyaRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassSosuKeny;
afrPassUganSosu: PassToSouthSudan @ugandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassSosuUgan;
afrPassDemoSosu: PassToSouthSudan @demorepuRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassSosuDemo;
afrPassCentSosu: PassToSouthSudan @centafriRoom   "<<afrMsg.passGeneric(name)>>" -> afrPassSosuCent;

// South Sudan has wiped these passages off the map!
//afrPassDemoSuda: PassToSudan      @demorepuRoom   "<<afrMsg.passGeneric(name)>>";
//afrPassSudaDemo: PassToDemoRepu   @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassDemoSuda;
//afrPassSudaUgan: PassToUganda     @sudanRoom      "<<afrMsg.passGeneric(name)>>";
//afrPassUganSuda: PassToSudan      @ugandaRoom     "<<afrMsg.passGeneric(name)>>" -> afrPassSudaUgan;
//afrPassKenySuda: PassToSudan      @kenyaRoom      "<<afrMsg.passGeneric(name)>>";
//afrPassSudaKeny: PassToKenya      @sudanRoom      "<<afrMsg.passGeneric(name)>>" -> afrPassKenySuda;

modify afrPassGambSene
  vague = true
  passDir = 'east'
;
modify afrPassSeneGamb
  vague = true
  passDir = 'west'
;
//modify afrPassSudaUgan
//  vague = true
//  passDir = 'south'
//;
modify afrPassBurkTogo
  vague = true
  passDir = 'south'
;
modify afrPassDemoUgan
  vague = true
  passDir = 'northeast'
;
modify afrPassDemoRwan
  vague = true
  passDir = 'east'
;
modify afrPassDemoBuru
  vague = true
  passDir = 'east'
;
modify afrPassTanzRwan
  vague = true
  passDir = 'northwest'
;
modify afrPassZambBots
  vague = true
  passDir = 'south'
;
modify afrPassMozaSwaz
  vague = true
  passDir = 'southwest'
;
modify afrPassSoutZimb
  vague = true
  passDir = 'northeast'
;

// -------------------------------------------------------------------
// NATION MAZES: PASSAGES: MEXICO PASSAGES
// -------------------------------------------------------------------

mexPassAguaJali: PassToJalisco    @aguascalRoom   "<<mexMsg.passGeneric(name)>>";
mexPassJaliAgua: PassToAguascal   @jaliscoRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassAguaJali;
mexPassAguaZaca: PassToZacatecas  @aguascalRoom   "<<mexMsg.passGeneric(name)>>";
mexPassZacaAgua: PassToAguascal   @zacatecasRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassAguaZaca;
mexPassBacaBasu: PassToBajaSur    @bajacaliRoom   "<<mexMsg.passGeneric(name)>>";
mexPassBasuBaca: PassToBajaCali   @bajasurRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassBacaBasu;
mexPassBacaSono: PassToSonora     @bajacaliRoom   "<<mexMsg.passGeneric(name)>>";
mexPassSonoBaca: PassToBajaCali   @sonoraRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassBacaSono;
mexPassChihCoah: PassToCoahuila   @chihuahuaRoom  "<<mexMsg.passGeneric(name)>>";
mexPassCoahChih: PassToChihuahua  @coahuilaRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassChihCoah;
mexPassChihDura: PassToDurango    @chihuahuaRoom  "<<mexMsg.passGeneric(name)>>";
mexPassDuraChih: PassToChihuahua  @durangoRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassChihDura;
mexPassChihSina: PassToSinaloa    @chihuahuaRoom  "<<mexMsg.passGeneric(name)>>";
mexPassSinaChih: PassToChihuahua  @sinaloaRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassChihSina;
mexPassChihSono: PassToSonora     @chihuahuaRoom  "<<mexMsg.passGeneric(name)>>";
mexPassSonoChih: PassToChihuahua  @sonoraRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassChihSono;
mexPassColiJali: PassToJalisco    @colimaRoom     "<<mexMsg.passGeneric(name)>>";
mexPassJaliColi: PassToColima     @jaliscoRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassColiJali;
mexPassColiMich: PassToMichoacan  @colimaRoom     "<<mexMsg.passGeneric(name)>>";
mexPassMichColi: PassToColima     @michoacanRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassColiMich;
mexPassCampQuin: PassToQuintana   @campecheRoom   "<<mexMsg.passGeneric(name)>>";
mexPassQuinCamp: PassToCampeche   @quintanaRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassCampQuin;
mexPassCampTaba: PassToTabasco    @campecheRoom   "<<mexMsg.passGeneric(name)>>";
mexPassTabaCamp: PassToCampeche   @tabascoRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassCampTaba;
mexPassCampYuca: PassToYucatan    @campecheRoom   "<<mexMsg.passGeneric(name)>>";
mexPassYucaCamp: PassToCampeche   @yucatanRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassCampYuca;
mexPassCoahDura: PassToDurango    @coahuilaRoom   "<<mexMsg.passGeneric(name)>>";
mexPassDuraCoah: PassToCoahuila   @durangoRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassCoahDura;
mexPassCoahNuev: PassToNuevoLeon  @coahuilaRoom   "<<mexMsg.passGeneric(name)>>";
mexPassNuevCoah: PassToCoahuila   @nuevoleonRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassCoahNuev;
mexPassCoahZaca: PassToZacatecas  @coahuilaRoom   "<<mexMsg.passGeneric(name)>>";
mexPassZacaCoah: PassToCoahuila   @zacatecasRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassCoahZaca;
mexPassChiaOaxa: PassToOaxaca     @chiapasRoom    "<<mexMsg.passGeneric(name)>>";
mexPassOaxaChia: PassToChiapas    @oaxacaRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassChiaOaxa;
mexPassChiaTaba: PassToTabasco    @chiapasRoom    "<<mexMsg.passGeneric(name)>>";
mexPassTabaChia: PassToChiapas    @tabascoRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassChiaTaba;
mexPassChiaVera: PassToVeracruz   @chiapasRoom    "<<mexMsg.passGeneric(name)>>";
mexPassVeraChia: PassToChiapas    @veracruzRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassChiaVera;
mexPassDistMore: PassToMorelos    @distritoRoom   "<<mexMsg.passGeneric(name)>>";
mexPassMoreDist: PassToDistrito   @morelosRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassDistMore;
mexPassDistMexi: PassToMexico     @distritoRoom   "<<mexMsg.passGeneric(name)>>";
mexPassMexiDist: PassToDistrito   @mexicoRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassDistMexi;
mexPassDuraNaya: PassToNayarit    @durangoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassNayaDura: PassToDurango    @nayaritRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassDuraNaya;
mexPassDuraSina: PassToSinaloa    @durangoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassSinaDura: PassToDurango    @sinaloaRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassDuraSina;
mexPassDuraZaca: PassToZacatecas  @durangoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassZacaDura: PassToDurango    @zacatecasRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassDuraZaca;
mexPassGuanJali: PassToJalisco    @guanajuatoRoom "<<mexMsg.passGeneric(name)>>";
mexPassJaliGuan: PassToGuanajuato @jaliscoRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassGuanJali;
mexPassGuanMich: PassToMichoacan  @guanajuatoRoom "<<mexMsg.passGeneric(name)>>";
mexPassMichGuan: PassToGuanajuato @michoacanRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassGuanMich;
mexPassGuanQuer: PassToQueretaro  @guanajuatoRoom "<<mexMsg.passGeneric(name)>>";
mexPassQuerGuan: PassToGuanajuato @queretaroRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassGuanQuer;
mexPassGuanSanl: PassToSanLuis    @guanajuatoRoom "<<mexMsg.passGeneric(name)>>";
mexPassSanlGuan: PassToGuanajuato @sanluisRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassGuanSanl;
mexPassGuerMich: PassToMichoacan  @guerreroRoom   "<<mexMsg.passGeneric(name)>>";
mexPassMichGuer: PassToGuerrero   @michoacanRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassGuerMich;
mexPassGuerMore: PassToMorelos    @guerreroRoom   "<<mexMsg.passGeneric(name)>>";
mexPassMoreGuer: PassToGuerrero   @morelosRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassGuerMore;
mexPassGuerMexi: PassToMexico     @guerreroRoom   "<<mexMsg.passGeneric(name)>>";
mexPassMexiGuer: PassToGuerrero   @mexicoRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassGuerMexi;
mexPassGuerOaxa: PassToOaxaca     @guerreroRoom   "<<mexMsg.passGeneric(name)>>";
mexPassOaxaGuer: PassToGuerrero   @oaxacaRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassGuerOaxa;
mexPassGuerPueb: PassToPuebla     @guerreroRoom   "<<mexMsg.passGeneric(name)>>";
mexPassPuebGuer: PassToGuerrero   @pueblaRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassGuerPueb;
mexPassHidaMexi: PassToMexico     @hidalgoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassMexiHida: PassToHidalgo    @mexicoRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassHidaMexi;
mexPassHidaPueb: PassToPuebla     @hidalgoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassPuebHida: PassToHidalgo    @pueblaRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassHidaPueb;
mexPassHidaQuer: PassToQueretaro  @hidalgoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassQuerHida: PassToHidalgo    @queretaroRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassHidaQuer;
mexPassHidaSanl: PassToSanLuis    @hidalgoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassSanlHida: PassToHidalgo    @sanluisRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassHidaSanl;
mexPassHidaTlax: PassToTlaxcala   @hidalgoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassTlaxHida: PassToHidalgo    @tlaxcalaRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassHidaTlax;
mexPassHidaVera: PassToVeracruz   @hidalgoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassVeraHida: PassToHidalgo    @veracruzRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassHidaVera;
mexPassJaliMich: PassToMichoacan  @jaliscoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassMichJali: PassToJalisco    @michoacanRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassJaliMich;
mexPassJaliNaya: PassToNayarit    @jaliscoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassNayaJali: PassToJalisco    @nayaritRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassJaliNaya;
mexPassJaliSanl: PassToSanLuis    @jaliscoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassSanlJali: PassToJalisco    @sanluisRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassJaliSanl;
mexPassJaliZaca: PassToZacatecas  @jaliscoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassZacaJali: PassToJalisco    @zacatecasRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassJaliZaca;
mexPassMichMexi: PassToMexico     @michoacanRoom  "<<mexMsg.passGeneric(name)>>";
mexPassMexiMich: PassToMichoacan  @mexicoRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassMichMexi;
mexPassMichQuer: PassToQueretaro  @michoacanRoom  "<<mexMsg.passGeneric(name)>>";
mexPassQuerMich: PassToMichoacan  @queretaroRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassMichQuer;
mexPassMoreMexi: PassToMexico     @morelosRoom    "<<mexMsg.passGeneric(name)>>";
mexPassMexiMore: PassToMorelos    @mexicoRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassMoreMexi;
mexPassMorePueb: PassToPuebla     @morelosRoom    "<<mexMsg.passGeneric(name)>>";
mexPassPuebMore: PassToMorelos    @pueblaRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassMorePueb;
mexPassMexiPueb: PassToPuebla     @mexicoRoom     "<<mexMsg.passGeneric(name)>>";
mexPassPuebMexi: PassToMexico     @pueblaRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassMexiPueb;
mexPassMexiQuer: PassToQueretaro  @mexicoRoom     "<<mexMsg.passGeneric(name)>>";
mexPassQuerMexi: PassToMexico     @queretaroRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassMexiQuer;
mexPassMexiTlax: PassToTlaxcala   @mexicoRoom     "<<mexMsg.passGeneric(name)>>";
mexPassTlaxMexi: PassToMexico     @tlaxcalaRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassMexiTlax;
mexPassNuevSanl: PassToSanLuis    @nuevoleonRoom  "<<mexMsg.passGeneric(name)>>";
mexPassSanlNuev: PassToNuevoLeon  @sanluisRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassNuevSanl;
mexPassNuevTama: PassToTamaulipas @nuevoleonRoom  "<<mexMsg.passGeneric(name)>>";
mexPassTamaNuev: PassToNuevoLeon  @tamaulipasRoom "<<mexMsg.passGeneric(name)>>" -> mexPassNuevTama;
mexPassNayaSina: PassToSinaloa    @nayaritRoom    "<<mexMsg.passGeneric(name)>>";
mexPassSinaNaya: PassToNayarit    @sinaloaRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassNayaSina;
mexPassNayaZaca: PassToZacatecas  @nayaritRoom    "<<mexMsg.passGeneric(name)>>";
mexPassZacaNaya: PassToNayarit    @zacatecasRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassNayaZaca;
mexPassOaxaPueb: PassToPuebla     @oaxacaRoom     "<<mexMsg.passGeneric(name)>>";
mexPassPuebOaxa: PassToOaxaca     @pueblaRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassOaxaPueb;
mexPassOaxaVera: PassToVeracruz   @oaxacaRoom     "<<mexMsg.passGeneric(name)>>";
mexPassVeraOaxa: PassToOaxaca     @veracruzRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassOaxaVera;
mexPassPuebTlax: PassToTlaxcala   @pueblaRoom     "<<mexMsg.passGeneric(name)>>";
mexPassTlaxPueb: PassToPuebla     @tlaxcalaRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassPuebTlax;
mexPassPuebVera: PassToVeracruz   @pueblaRoom     "<<mexMsg.passGeneric(name)>>";
mexPassVeraPueb: PassToPuebla     @veracruzRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassPuebVera;
mexPassQuinYuca: PassToYucatan    @quintanaRoom   "<<mexMsg.passGeneric(name)>>";
mexPassYucaQuin: PassToQuintana   @yucatanRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassQuinYuca;
mexPassQuerSanl: PassToSanLuis    @queretaroRoom  "<<mexMsg.passGeneric(name)>>";
mexPassSanlQuer: PassToQueretaro  @sanluisRoom    "<<mexMsg.passGeneric(name)>>" -> mexPassQuerSanl;
mexPassSinaSono: PassToSonora     @sinaloaRoom    "<<mexMsg.passGeneric(name)>>";
mexPassSonoSina: PassToSinaloa    @sonoraRoom     "<<mexMsg.passGeneric(name)>>" -> mexPassSinaSono;
mexPassSanlTama: PassToTamaulipas @sanluisRoom    "<<mexMsg.passGeneric(name)>>";
mexPassTamaSanl: PassToSanLuis    @tamaulipasRoom "<<mexMsg.passGeneric(name)>>" -> mexPassSanlTama;
mexPassSanlVera: PassToVeracruz   @sanluisRoom    "<<mexMsg.passGeneric(name)>>";
mexPassVeraSanl: PassToSanLuis    @veracruzRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassSanlVera;
mexPassSanlZaca: PassToZacatecas  @sanluisRoom    "<<mexMsg.passGeneric(name)>>";
mexPassZacaSanl: PassToSanLuis    @zacatecasRoom  "<<mexMsg.passGeneric(name)>>" -> mexPassSanlZaca;
mexPassTabaVera: PassToVeracruz   @tabascoRoom    "<<mexMsg.passGeneric(name)>>";
mexPassVeraTaba: PassToTabasco    @veracruzRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassTabaVera;
mexPassTamaVera: PassToVeracruz   @tamaulipasRoom "<<mexMsg.passGeneric(name)>>";
mexPassVeraTama: PassToTamaulipas @veracruzRoom   "<<mexMsg.passGeneric(name)>>" -> mexPassTamaVera;

modify mexPassGuerMore
  vague = true
  passDir = 'north'
;
modify mexPassJaliAgua
  vague = true
  passDir = 'northeast'
;
modify mexPassMexiMore
  vague = true
  passDir = 'south'
;
modify mexPassPuebMore
  vague = true
  passDir = 'west'
;
modify mexPassPuebMexi
  vague = true
  passDir = 'west'
;
modify mexPassSanlQuer
  vague = true
  passDir = 'south'
;

// -------------------------------------------------------------------
// NATION MAZES: ROOMS: CLASSES
// -------------------------------------------------------------------

class NationRoom: OutdoorRoom
  isNation = true
  giveHint {
    glob.(hintProp)++;
    switch (glob.(hintProp)) {
      case 1:
        "Sheila says, ";
        if ((ofKind(AfricaRoom) && africaSign.hasBeenDescribed) ||
            (ofKind(MexicanRoom) && mexicoSign.hasBeenDescribed))
          "<.q>Well, you read the sign, and it talked about 
            exploring this maze as thoroughly as possible. 
            That<./s>s your first clue.<./q> ";
        else
          "<.q>In the first room of this maze, the sign there 
            talks about exploring this maze as thoroughly 
            as possible. That's your first clue.<./q> ";
        break;
      case 2:
        "Sheila says, ";
        if ((ofKind(AfricaRoom) && afrMsg.afrPassCount > 1) ||
            (ofKind(MexicanRoom) && mexMsg.mexPassCount > 1))
          "<.q>As you<./s>ve already discovered, ";
        else if ((ofKind(AfricaRoom) && afrMsg.afrPassCount == 1) ||
            (ofKind(MexicanRoom) && mexMsg.mexPassCount == 1))
          "<.q>As you may have noticed, ";
        else
          "<.q>In case you didn<./s>t know, ";
        "once you leave a room in this maze, you can<./s>t 
          return to it. That is the main challenge here.<./q> ";
        if (glob.(potentialScoreProp) > (glob.(initialPsp) - 10))
          glob.(potentialScoreProp) = glob.(initialPsp) - 10;
        break;
      case 3:
        "Sheila says, <.q>So, just in case this isn<./s>t clear,
          we need to visit every room, but we can<./s>t visit 
          any room more than once. That is the whole challenge.<./q> ";
        break;
      case 4:
        "Sheila says, <.q>It is somewhat of a challenge to visit
          all the rooms in this maze without visiting any of them
          more than once. To accomplish this, it helps
          to identify things that would need to be part of any
          conceivable solution. ";
        if (ofKind(MexicanRoom))
          "<p><.q>For instance, only one state--Tabasco 
            (TB)--separates the three states of the 
            Yucat&aacute;n Peninsula from the other states of Mexico. 
            Therefore, if you want to visit all of Mexico<./s>s states, 
            you'll have to go through Tabasco as the fourth-to-last 
            state you visit, finishing up somewhere on the 
            Yucat&aacute;n Peninsula.<./q> ";
        else
          "<p><.q>For instance, there are two countries 
            in Africa that have only one neighboring country each. 
            One of them is Gambia, where you started out. 
            The other is Lesotho (LS), a landlocked country 
            surrounded by South Africa. Therefore, in order 
            to visit all of the countries exactly once, 
            you<./s>ll have to finish up in Lesotho.<./q> ";
        if (glob.(potentialScoreProp) > (glob.(initialPsp) - 20))
          glob.(potentialScoreProp) = glob.(initialPsp) - 20;
        break;
      case 5:
        "Sheila says, ";
        if (ofKind(MexicanRoom))
          "<.q>It also helps to look at situations like the one 
            in Aguascalientes (AG) in central Mexico. 
            Aguascalientes borders on only two other states, 
            Zacatecas (ZC) and Jalisco (JL). Therefore, 
            in order to visit each state exactly once, 
            you'll have to go from ZC to AG to JL 
            as part of your trip, or else from JL to AG to ZC. ";
        else
          "<.q>It also helps to look at situations 
            like the one in Egypt (EG). Egypt borders 
            on only two other countries, Libya and Sudan. 
            Therefore, in order to visit each country 
            exactly once, you<./s>ll have to go from Libya 
            to Egypt to Sudan as part of your trip, 
            or else from Sudan to Egypt to Libya. ";
        "<p><.q>So look for things like that--common
           features that would have to be part of
           any possible solution to this maze.
           After you<./s>ve done that, hopefully it will be 
           easier to solve the maze.<./q> ";
        if (glob.(potentialScoreProp) > (glob.(initialPsp) - 30))
          glob.(potentialScoreProp) = glob.(initialPsp) - 30;
        break;
      case 6:
        "Sheila says, <.q>I<./s>ve given you all the hints I can.
          All I can do now is give you the complete solution.
          Is that what you want?<./q> ";
        if (!sayYesOrNo()) {
          "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
          glob.(hintProp)--;
        }
        else {
          giveCompleteSolution();
        }
        break;
      default:
        giveCompleteSolution();
        break;
    }
  }
  down {
    if (nationHole.isIn(self))
      return nationHole;
    else
      return nil;
  }
  enteringRoom(traveler) {
    beenThere = true;
    if (self == lesothoRoom || self == yucatanRoom || self == quintanaRoom) {
      if (allRoomsInThisMazeHaveBeenVisited)
        nationHole.moveInto(self);
    }
    nbmBanner.updateMe();
  }
  allRoomsInThisMazeHaveBeenVisited {
    for (local cur=firstObj(asscClass); cur != nil; cur=nextObj(cur,asscClass)) {
      if (!cur.beenThere)
        return nil;
    }
    return true;
  }
;

modify glob
  africaHintState = 0
  mexicoHintState = 0
;

// My attempt to estimate the distance of going through the necessary
// circuitous route through the nation mazes:
// Mexico:  4,500 miles
// Africa: 15,000 miles

nationHole: StairwayDown
  vocabWords = 'hole'
  name = 'hole'
  specialDesc = "There is a hole in the ground here. "
  desc = "The hole is rather wide, and goes down into the ground 
    so far that it disappears into darkness. 
    There are no handholds in it, so be careful.
    If you went there, I can't imagine how you'd ever
    get back up again. "
  soundDesc {
    "From deep inside the hole, your bot thinks she can hear 
      the sound of a hollow cave. ";
  }
  dobjFor(LookThrough) {
    action() {
      "The hole goes down, way down, vanishing into darkness. ";
    }
  }
  dobjFor(Enter) remapTo(TravelVia, self)
  dobjFor(TravelVia) {
    action {
      "<.q>Okay, you<./s>re the boss!<./q> cries Sheila. 
        <p>With that, she wheels herself up the hole,
          then gingerly rolls over the edge 
          and plummets down and down\ .\ .\ . ";
      returnToCaveVictoriously('Well, my legs hurt now,
        but at least that '
        + (getOutermostRoom.ofKind(AfricaRoom) ? 'fifteen' : 'five') 
        + '-thousand-mile hike is over with.');
    }
  }
;


modify AfricaRoom//: NationRoom
  isInAfrica = true
  bannerValue = africa
  beenThere = nil
  hintProp = &africaHintState
  potentialScoreProp = &potentialScoreAfrica
  initialPsp = &initialPotentialScoreAfrica
  asscClass = AfricaRoom
  desc {
    mainDesc;
    "<p>";
    canGoDesc;
    //"<p>From ";
    //"You are in Africa. ";
    //africaMapPrint();
    //"\b";
    //"South takes you back to where you came from. North takes you to Egypt. ";
  }
  canGoDesc {
    "This region borders on ";
    //local k = 0; k=k/k;
    for (local a = 1; a <= borderRooms.length; a++) {
      //"<<a>>";
      glob.thexahref(borderRooms[a], borderRooms[a].abbr);
      if (borderRooms.length > 2 && a < borderRooms.length)
        ", ";
      if (a == borderRooms.length - 1)
        " and ";
    }
    ". ";
  }
  ambAfrica : NoTravelMessage { "<<afrMsg.afrAmbAfrica>>" }
  firstRoomInThisMazeSet = gambiaRoom
  holeSound = 'the sound of the wind rushing through the Sahara Desert'
  giveCompleteSolution() {
    "<.q>Okay, here<./s>s one possible solution,<./q> Sheila says. 
      <.q>Starting in GM, go to SN, GW, GN, SL, LR, CI, BF, 
      GH, TG, BJ, NG, CM, GQ, GA, CG, CF, TD, NE, ML, MR, 
      EH, MA, DZ, TN, LY, EG, SD, SS, ET, ER, DJ, SO, KE, UG, 
      RW, BI, TZ, CD, AO, NA, BW, ZW, ZM, MW, MZ, SZ, ZA, 
      and finally LS.<./q> ";
    glob.(potentialScoreProp) = 0;
  }
;



modify MexicanRoom//: NationRoom 
  isInMexico = true
  bannerValue = elmexico
  beenThere = nil
  hintProp = &mexicoHintState
  potentialScoreProp = &potentialScoreMexico
  initialPsp = &initialPotentialScoreMexico
  asscClass = MexicanRoom
  desc {
    mainDesc;
    "<p>";
    canGoDesc;
  }
  canGoDesc {
    "This region borders on ";
    //local k = 0; k=k/k;
    for (local a = 1; a <= borderRooms.length; a++) {
      //"<<a>>";
      glob.thexahref(borderRooms[a], borderRooms[a].abbr);
      if (borderRooms.length > 2 && a < borderRooms.length)
        ", ";
      if (a == borderRooms.length - 1)
        " and ";
    }
    ". ";
  }
  //up : NoTravelMessage { "No can do, se&ntilde;or. " }
  //ambAfrica : NoTravelMessage { "<<afrMsg.afrAmbAfrica>>" }
  firstRoomInThisMazeSet = bajasurRoom
  holeSound = 'the sound of the wind rushing through the Sierra Madre'
  giveCompleteSolution() {
    "<.q>Okay, here<./s>s one possible solution,<./q> Sheila says. 
      <.q>Starting in BS, go to BC, SO, SI, NY, DR, CH, CO, 
      NL, TM, SL, ZC, AG, JL, CL, MC, GN, QR, HD, PB, TL, 
      MX, DF, MR, GR, OX, VR, CP, TB, CM, YC, and finally QN.<./q> ";
    glob.(potentialScoreProp) = 0;
  }
;

// -------------------------------------------------------------------
// NATION MAZES: ROOMS: AFRICA ROOMS
// -------------------------------------------------------------------

moroccoRoom: AfricaRoom
  vocabWords = 'morocco ma'
  name       = 'Morocco'
  capname    = 'Morocco'
  abbr       = 'MA'
  mainDesc = 
    "The Atlas Mountains run through here. To the north, 
      the Strait of Gibraltar separates the Atlantic 
      from the Mediterranean. "
  westsaha   = afrPassMoroWest
  algeria    = afrPassMoroAlge
  //westsaha   = westsahaRoom
  //algeria    = algeriaRoom
  east       asExit(algeria)
  southeast  asExit(algeria)
  south      asExit(westsaha)
  southwest  asExit(westsaha)
  morocco    : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(algeriaRoom, westsahaRoom)>>" }
;
algeriaRoom: AfricaRoom
  vocabWords = 'algeria dz'
  name       = 'Algeria'
  capname    = 'Algeria'
  abbr       = 'DZ'
  mainDesc = 
    "This huge area is mostly Sahara Desert, while the 
      Atlas Mountains lie to the north. "
  morocco    = afrPassAlgeMoro
  westsaha   = afrPassAlgeWest
  mauritania = afrPassAlgeMaur
  mali       = afrPassAlgeMali
  niger      = afrPassAlgeNige
  libya      = afrPassAlgeLiby
  tunisia    = afrPassAlgeTuni
  //morocco    = moroccoRoom
  //westsaha   = westsahaRoom
  //mauritania = mauritaniaRoom
  //mali       = maliRoom
  //niger      = nigerRoom
  //libya      = libyaRoom
  //tunisia    = tunisiaRoom
  northwest  asExit(morocco)
  west       asExit(westsaha)
  southwest  asExit(mauritania)
  south      asExit(mali)
  southeast  asExit(niger)
  east       asExit(libya)
  northeast  asExit(tunisia)
  ne         asExit(niger)
  algeria    : NoTravelMessage { "<<alreadyInNation()>>" }
  //west      : NoTravelMessage { "<<ambigCompass(moroccoRoom,    westsahaRoom, 
  //                                              mauritaniaRoom, maliRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(mauritaniaRoom, maliRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(maliRoom,       nigerRoom)>>" }
;
tunisiaRoom: AfricaRoom
  vocabWords = 'tunisia tn'
  name       = 'Tunisia'
  capname    = 'Tunisia'
  abbr       = 'TN'
  mainDesc = 
    "This smallish region hugs the Mediterranean coast. "
  algeria    = afrPassTuniAlge
  libya      = afrPassTuniLiby
  //algeria    = algeriaRoom
  //libya      = libyaRoom
  west       asExit(algeria)
  southwest  asExit(algeria)
  south      asExit(libya)
  southeast  asExit(libya)
  east       asExit(libya)
  tunisia    : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(algeriaRoom, libyaRoom)>>" }
;
libyaRoom: AfricaRoom
  vocabWords = 'libya ly'
  name       = 'Libya'
  capname    = 'Libya'
  abbr       = 'LY'
  mainDesc = 
    "The wastes of the Sahara Desert take up most 
      of this large region. "
  tunisia    = afrPassLibyTuni
  algeria    = afrPassLibyAlge
  niger      = afrPassLibyNige
  chad       = afrPassLibyChad
  sudan      = afrPassLibySuda
  egypt      = afrPassLibyEgyp
  //tunisia    = tunisiaRoom
  //algeria    = algeriaRoom
  //niger      = nigerRoom
  //chad       = chadRoom
  //sudan      = sudanRoom
  //egypt      = egyptRoom
  northwest  asExit(tunisia)
  west       asExit(algeria)
  southwest  asExit(niger)
  south      asExit(chad)
  southeast  asExit(sudan)
  east       asExit(egypt)
  ne         asExit(niger)
  libya      : NoTravelMessage { "<<alreadyInNation()>>" }
;
egyptRoom: AfricaRoom
  vocabWords = 'egypt eg'
  name       = 'Egypt'
  capname    = 'Egypt'
  abbr       = 'EG'
  mainDesc = 
    "The Nile River relieves the dryness of this desert region. 
      The Suez Canal connects the Mediterranean to 
      the Red Sea here, while the Sinai Peninsula 
      lies off to the east. "
  libya      = afrPassEgypLiby
  sudan      = afrPassEgypSuda
  //libya      = libyaRoom
  //sudan      = sudanRoom
  west       asExit(libya)
  southwest  asExit(libya)
  south      asExit(sudan)
  southeast  asExit(sudan)
  egypt      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest  asExit(libya)
  //southwest : NoTravelMessage { "<<ambigCompass(libyaRoom, sudanRoom)>>" }
;
westsahaRoom: AfricaRoom
  vocabWords = 'western (sahara) eh'
  name       = 'Western Sahara'
  capname    = 'Western Sahara'
  abbr       = 'EH'
  mainDesc =
    "This aptly named region is taken up by desert. "
  morocco    = afrPassWestMoro
  algeria    = afrPassWestAlge
  mauritania = afrPassWestMaur
  //morocco    = moroccoRoom
  //algeria    = algeriaRoom
  //mauritania = mauritaniaRoom
  north      asExit(morocco)
  northeast  asExit(morocco)
  east       asExit(algeria)
  southeast  asExit(mauritania)
  south      asExit(mauritania)
  westsaha   : NoTravelMessage { "<<alreadyInNation()>>" }
;
mauritaniaRoom: AfricaRoom
  vocabWords = 'mauritania mr'
  name       = 'Mauritania'
  capname    = 'Mauritania'
  abbr       = 'MR'
  mainDesc =
    "This large region is mostly filled with the Sahara Desert. "
  westsaha   = afrPassMaurWest
  algeria    = afrPassMaurAlge
  mali       = afrPassMaurMali
  senegal    = afrPassMaurSene
  //westsaha   = westsahaRoom
  //algeria    = algeriaRoom
  //mali       = maliRoom
  //senegal    = senegalRoom
  northwest  asExit(westsaha)
  north      asExit(westsaha)
  northeast  asExit(algeria)
  east       asExit(mali)
  southeast  asExit(mali)
  south      asExit(mali)
  southwest  asExit(senegal)
  //south     : NoTravelMessage { "<<ambigCompass(senegalRoom, maliRoom)>>" }
  mauritania : NoTravelMessage { "<<alreadyInNation()>>" }
;
maliRoom: AfricaRoom
  vocabWords = 'mali ml'
  name       = 'Mali'
  capname    = 'Mali'
  abbr       = 'ML'
  mainDesc =
    "The Sahara Desert is here to the north, with 
      the Niger River flowing through to the south. "
  mauritania = afrPassMaliMaur
  algeria    = afrPassMaliAlge
  niger      = afrPassMaliNige
  burkfaso   = afrPassMaliBurk
  ivorcoas   = afrPassMaliIvor
  guinea     = afrPassMaliGuin
  senegal    = afrPassMaliSene
  //mauritania = mauritaniaRoom
  //algeria    = algeriaRoom
  //niger      = nigerRoom
  //burkfaso   = burkfasoRoom
  //ivorcoas   = ivorcoasRoom
  //guinea     = guineaRoom
  //senegal    = senegalRoom
  northwest  asExit(mauritania)
  north      asExit(algeria)
  northeast  asExit(algeria)
  east       asExit(niger)
  southeast  asExit(burkfaso)
  south      asExit(ivorcoas)
  southwest  asExit(guinea)
  west       asExit(senegal)
  ne         asExit(niger)
  ambGuinea  asExit(guinea)
  mali       : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(mauritaniaRoom, algeriaRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(ivorcoasRoom, burkfasoRoom)>>" }
  //west      : NoTravelMessage { "<<ambigCompass(mauritaniaRoom, senegalRoom)>>" }
;
nigerRoom: AfricaRoom
  vocabWords = 'niger ne'
  name       = 'Niger'
  capname    = 'Niger'
  abbr       = 'NE'
  mainDesc =
    "There is a large stretch of Sahara Desert here, 
      with the Niger River valley to the southwest. "
  benin      = afrPassNigeBeni
  burkfaso   = afrPassNigeBurk
  mali       = afrPassNigeMali
  algeria    = afrPassNigeAlge
  libya      = afrPassNigeLiby
  chad       = afrPassNigeChad
  nigeria    = afrPassNigeNiri
  //benin      = beninRoom
  //burkfaso   = burkfasoRoom
  //mali       = maliRoom
  //algeria    = algeriaRoom
  //libya      = libyaRoom
  //chad       = chadRoom
  //nigeria    = nigeriaRoom
  west       asExit(mali)
  northwest  asExit(algeria)
  north      asExit(algeria)
  northeast  asExit(libya)
  east       asExit(chad)
  southeast  asExit(chad)
  south      asExit(nigeria)
  southwest  asExit(burkfaso)
  niger      : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(algeriaRoom, libyaRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(nigeriaRoom, chadRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(burkfasoRoom, beninRoom)>>" }
;
chadRoom: AfricaRoom
  vocabWords = 'chad td'
  name       = 'Chad'
  capname    = 'Chad'
  abbr       = 'TD'
  mainDesc =
    "This large region is filled with desert in the north, 
      and grasslands and forests to the south. "
  cameroon   = afrPassChadCame
  nigeria    = afrPassChadNiri
  niger      = afrPassChadNige
  libya      = afrPassChadLiby
  sudan      = afrPassChadSuda
  centafri   = afrPassChadCent
  //cameroon   = cameroonRoom
  //nigeria    = nigeriaRoom
  //niger      = nigerRoom
  //libya      = libyaRoom
  //sudan      = sudanRoom
  //centafri   = centafriRoom
  northwest  asExit(niger)
  north      asExit(libya)
  northeast  asExit(sudan)
  east       asExit(sudan)
  southeast  asExit(centafri)
  south      asExit(centafri)
  southwest  asExit(cameroon)
  west       asExit(nigeria)
  ne         asExit(niger)
  ambRepub   asExit(centafri)
  chad       : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(libyaRoom, sudanRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(centafriRoom, sudanRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(nigeriaRoom, cameroonRoom)>>" }
  //west      : NoTravelMessage { "<<ambigCompass(nigerRoom, nigeriaRoom,
  //                                              cameroonRoom)>>" }
;
sudanRoom: AfricaRoom // modified 2016-11-07
  vocabWords = 'sudan sd'
  name       = 'Sudan'
  capname    = 'Sudan'
  abbr       = 'SD'
  mainDesc =
    "This is a large area of deserts and forests. 
        The Blue Nile and White Nile join here. "
  egypt      = afrPassSudaEgyp
  libya      = afrPassSudaLiby
  chad       = afrPassSudaChad
  centafri   = afrPassSudaCent
  southsudan = afrPassSudaSosu
  //demorepu   = afrPassSudaDemo
  //uganda     = afrPassSudaUgan
  //kenya      = afrPassSudaKeny
  ethiopia   = afrPassSudaEthi
  eritrea    = afrPassSudaErit
  //egypt      = egyptRoom
  //libya      = libyaRoom
  //chad       = chadRoom
  //centafri   = centafriRoom
  //demorepu   = demorepuRoom
  //uganda     = ugandaRoom
  //kenya      = kenyaRoom
  //ethiopia   = ethiopiaRoom
  //eritrea    = eritreaRoom
  north      asExit(egypt)
  northwest  asExit(libya)
  west       asExit(chad)
  southwest  asExit(centafri)
  south      asExit(southsudan)
  southeast  asExit(ethiopia)
  east       asExit(eritrea)
  //northeast  asExit(eritrea) // commented out 2016-11-06; will have to test this
  //ambCongo   asExit(demorepu) // commented out 2016-11-06; will have to test this
  ambRepub   asExit(centafri) // commented out 2016-11-06; will have to test this
  sudan      : NoTravelMessage { "<<alreadyInNation()>>" }
  ambSudan   : NoTravelMessage { "<<alreadyInNation()>>" }
  //west      : NoTravelMessage { "<<ambigCompass(chadRoom, centafriRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(demorepuRoom, ugandaRoom,
  //                                              kenyaRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(ethiopiaRoom, kenyaRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(eritreaRoom, ethiopiaRoom)>>" }
;
southsudanRoom: AfricaRoom // modified 2016-11-07
  vocabWords = 'south sudan ss'
  name       = 'South Sudan'
  capname    = 'South Sudan'
  abbr       = 'SS'
  mainDesc =
    "This region is filled with savannas and forests
      The White Nile flows through here from south to north. "
  // custom directions
  sudan      = afrPassSosuSuda
  ethiopia   = afrPassSosuEthi
  kenya      = afrPassSosuKeny
  uganda     = afrPassSosuUgan
  demorepu   = afrPassSosuDemo
  centafri   = afrPassSosuCent
  // classic directions
  north      asExit(sudan)
  northwest  asExit(sudan)
  west       asExit(centafri)
  southwest  asExit(demorepu)
  south      asExit(uganda)
  southeast  asExit(kenya)
  east       asExit(ethiopia)
  northeast  asExit(ethiopia)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(centafri) // I guess default to Central African Republic?
  ambSudan   asExit(sudan)
  southsudan : NoTravelMessage { "<<alreadyInNation()>>" }
;
eritreaRoom: AfricaRoom
  vocabWords = 'eritrea er'
  name       = 'Eritrea'
  capname    = 'Eritrea'
  abbr       = 'ER'
  mainDesc =
    "This long, narrow region hugs the Red Sea. "
  //eritreaRoom   
  sudan      = afrPassEritSuda
  ethiopia   = afrPassEritEthi
  djibouti   = afrPassEritDjib
  //sudan      = sudanRoom
  //ethiopia   = ethiopiaRoom
  //djibouti   = djiboutiRoom
  northwest  asExit(sudan)
  west       asExit(sudan)
  southwest  asExit(sudan)
  south      asExit(ethiopia)
  southeast  asExit(djibouti)
  east       asExit(djibouti)
  eritrea    : NoTravelMessage { "<<alreadyInNation()>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(sudanRoom, ethiopiaRoom)>>" }
;
ethiopiaRoom: AfricaRoom // modified 2016-11-07
  vocabWords = 'ethiopia et'
  name       = 'Ethiopia'
  capname    = 'Ethiopia'
  abbr       = 'ET'
  mainDesc =
    "This mountainous region is taken up by the Ethiopian Highlands. "
  eritrea    = afrPassEthiErit
  djibouti   = afrPassEthiDjib
  somalia    = afrPassEthiSoma
  kenya      = afrPassEthiKeny
  southsudan = afrPassEthiSosu
  sudan      = afrPassEthiSuda
  //eritrea    = eritreaRoom
  //djibouti   = djiboutiRoom
  //somalia    = somaliaRoom
  //kenya      = kenyaRoom
  //sudan      = sudanRoom
  north      asExit(eritrea)
  northeast  asExit(djibouti)
  east       asExit(somalia)
  southeast  asExit(somalia)
  south      asExit(kenya)
  southwest  asExit(kenya)
  west       asExit(southsudan)
  northwest  asExit(sudan)
  ethiopia   : NoTravelMessage { "<<alreadyInNation()>>" }
  ambSudan   asExit(sudan)
  //southwest : NoTravelMessage { "<<ambigCompass(sudanRoom, kenyaRoom)>>" }
;
djiboutiRoom: AfricaRoom
  vocabWords = 'djibouti dj'
  name       = 'Djibouti'
  capname    = 'Djibouti'
  abbr       = 'DJ'
  mainDesc =
    "This is a small area on the Gulf of Aden. "
  eritrea    = afrPassDjibErit
  ethiopia   = afrPassDjibEthi
  somalia    = afrPassDjibSoma
  //eritrea    = eritreaRoom
  //ethiopia   = ethiopiaRoom
  //somalia    = somaliaRoom
  north      asExit(eritrea)
  northwest  asExit(eritrea)
  west       asExit(ethiopia)
  southwest  asExit(ethiopia)
  south      asExit(ethiopia)
  southeast  asExit(somalia)
  east       asExit(somalia)
  djibouti   : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(ethiopiaRoom, somaliaRoom)>>" }
;
somaliaRoom: AfricaRoom
  vocabWords = 'somalia so'
  name       = 'Somalia'
  capname    = 'Somalia'
  abbr       = 'SO'
  mainDesc =
    "The Horn of Africa juts out eastward here into the Indian Ocean. "
  djibouti   = afrPassSomaDjib
  ethiopia   = afrPassSomaEthi
  kenya      = afrPassSomaKeny
  //djibouti   = djiboutiRoom
  //ethiopia   = ethiopiaRoom
  //kenya      = kenyaRoom
  northwest  asExit(djibouti)
  west       asExit(ethiopia)
  southwest  asExit(kenya)
  somalia    : NoTravelMessage { "<<alreadyInNation()>>" }
;
senegalRoom: AfricaRoom
  vocabWords = 'senegal sn'
  name       = 'Senegal'
  //'s\u00E9n\u00E9gal': add to vocabWords
  capname    = 'Senegal'
  mainDesc =
    "This area includes most of the Senegal and Gambia river valleys. "
  abbr       = 'SN'
  mauritania = afrPassSeneMaur
  mali       = afrPassSeneMali
  guinea     = afrPassSeneGuin
  guinbiss   = afrPassSeneGubi
  gambia     = afrPassSeneGamb
  //mauritania = mauritaniaRoom
  //mali       = maliRoom
  //guinea     = guineaRoom
  //guinbiss   = guinbissRoom
  //gambia     = gambiaRoom
  north      asExit(mauritania)
  northeast  asExit(mauritania)
  east       asExit(mali)
  southeast  asExit(guinea)
  south      asExit(guinbiss)
  southwest  asExit(guinbiss)
  west       asExit(gambia)
  in         asExit(gambia)
  ambGuinea  asExit(guinea)
  senegal    : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(guinbissRoom, guineaRoom)>>" }
;
gambiaRoom: AfricaRoom
  vocabWords = 'gambia gm'
  name       = 'Gambia'
  capname    = 'Gambia'
  abbr       = 'GM'
  mainDesc =
    "This small region hugs close to the Gambia River. "
  senegal    = afrPassGambSene
  //senegal    = senegalRoom
  north      asExit(senegal)
  northeast  asExit(senegal)
  east       asExit(senegal)
  southeast  asExit(senegal)
  south      asExit(senegal)
  out        asExit(senegal)
  gambia     : NoTravelMessage { "<<alreadyInNation()>>" }
;
guinbissRoom: AfricaRoom
  vocabWords = 'guinea-bissau (guinea) bissau gw'
  name       = 'Guinea-Bissau'
  capname    = 'Guinea-Bissau'
  abbr       = 'GW'
  mainDesc =
    "This is a small area of swamps and forests along 
      the Atlantic coast. "
  senegal    = afrPassGubiSene
  guinea     = afrPassGubiGuin
  //senegal    = senegalRoom
  //guinea     = guineaRoom
  northwest  asExit(senegal)
  north      asExit(senegal)
  northeast  asExit(senegal)
  east       asExit(guinea)
  southeast  asExit(guinea)
  south      asExit(guinea)
  ambGuinea  asExit(guinea)
  guinbiss   : NoTravelMessage { "<<alreadyInNation()>>" }
;
guineaRoom: AfricaRoom
  vocabWords = 'guinea gn'
  name       = 'Guinea'
  capname    = 'Guinea'
  abbr       = 'GN'
  mainDesc =
    "Highlands dominate the northeast of this region, 
      while the Atlantic coast lies to the southwest. "
  guinbiss   = afrPassGuinGubi
  senegal    = afrPassGuinSene
  mali       = afrPassGuinMali
  ivorcoas   = afrPassGuinIvor
  liberia    = afrPassGuinLibe
  sierleon   = afrPassGuinSier
  //guinbiss   = guinbissRoom
  //senegal    = senegalRoom
  //mali       = maliRoom
  //ivorcoas   = ivorcoasRoom
  //liberia    = liberiaRoom
  //sierleon   = sierleonRoom
  west       asExit(guinbiss)
  northwest  asExit(guinbiss)
  north      asExit(senegal)
  northeast  asExit(mali)
  east       asExit(ivorcoas)
  southeast  asExit(ivorcoas)
  south      asExit(liberia)
  southwest  asExit(sierleon)
  ambGuinea  asExit(guinbiss)
  guinea     : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(guinbissRoom, senegalRoom)>>" }
  //north     : NoTravelMessage { "<<ambigCompass(senegalRoom, maliRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(maliRoom, ivorcoasRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(sierleonRoom, liberiaRoom)>>" }
;
sierleonRoom: AfricaRoom
  vocabWords = 'sierra leone sl'
  name       = 'Sierra Leone'
  capname    = 'Sierra Leone'
  abbr       = 'SL'  // Si
  mainDesc =
    "Mangrove swamps line the coast in this small region. "
  guinea     = afrPassSierGuin
  liberia    = afrPassSierLibe
  //guinea     = guineaRoom
  //liberia    = liberiaRoom
  northwest  asExit(guinea)
  north      asExit(guinea)
  northeast  asExit(guinea)
  east       asExit(liberia)
  southeast  asExit(liberia)
  ambGuinea  asExit(guinea)
  sierleon   : NoTravelMessage { "<<alreadyInNation()>>" }
;
liberiaRoom: AfricaRoom
  vocabWords = 'liberia lr'
  name       = 'Liberia'
  capname    = 'Liberia'
  abbr       = 'LR'
  mainDesc =
    "Coastal plains take up most of this area, 
      with a few hills to the north. "
  sierleon   = afrPassLibeSier
  guinea     = afrPassLibeGuin
  ivorcoas   = afrPassLibeIvor
  //sierleon   = sierleonRoom
  //guinea     = guineaRoom
  //ivorcoas   = ivorcoasRoom
  northwest  asExit(sierleon)
  north      asExit(guinea)
  northeast  asExit(ivorcoas)
  east       asExit(ivorcoas)
  ambGuinea  asExit(guinea)
  liberia    : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(guineaRoom, ivorcoasRoom)>>" }
;
ivorcoasRoom: AfricaRoom
  vocabWords = 'c\u00f4te cote (d) (de) d\'ivoire ivoire ivory (coast) ci'
  name       = 'C\u00F4te d<./s>Ivoire'
  capname    = 'C\u00F4te d<./s>Ivoire'
  abbr       = 'CI'
  mainDesc =
    "This region is mostly jungle, with grasslands to the north. "
  liberia    = afrPassIvorLibe
  guinea     = afrPassIvorGuin
  mali       = afrPassIvorMali
  burkfaso   = afrPassIvorBurk
  ghana      = afrPassIvorGhan
  //liberia    = liberiaRoom
  //guinea     = guineaRoom
  //mali       = maliRoom
  //burkfaso   = burkfasoRoom
  //ghana      = ghanaRoom
  southwest  asExit(liberia)
  west       asExit(liberia)
  northwest  asExit(guinea)
  north      asExit(mali)
  northeast  asExit(burkfaso)
  east       asExit(ghana)
  ambGuinea  asExit(guinea)
  ivorcoas   : NoTravelMessage { "<<alreadyInNation()>>" }
  //west      : NoTravelMessage { "<<ambigCompass(guineaRoom, liberiaRoom)>>" }
  //north     : NoTravelMessage { "<<ambigCompass(maliRoom, burkfasoRoom)>>" }
;
burkfasoRoom: AfricaRoom
  vocabWords = 'burkina faso bf'
  name       = 'Burkina Faso'
  capname    = 'Burkina Faso'
  abbr       = 'BF'
  mainDesc =
    "This is a broad region of semi-arid grasslands. "
  ivorcoas   = afrPassBurkIvor
  mali       = afrPassBurkMali
  niger      = afrPassBurkNige
  benin      = afrPassBurkBeni
  togo       = afrPassBurkTogo
  ghana      = afrPassBurkGhan
  //ivorcoas   = ivorcoasRoom
  //mali       = maliRoom
  //niger      = nigerRoom
  //benin      = beninRoom
  //togo       = togoRoom
  //ghana      = ghanaRoom
  west       asExit(mali)
  northwest  asExit(mali)
  north      asExit(mali)
  northeast  asExit(niger)
  east       asExit(niger)
  southeast  asExit(benin)
  south      asExit(ghana)
  southwest  asExit(ivorcoas)
  ne         asExit(niger)
  burkfaso   : NoTravelMessage { "<<alreadyInNation()>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(ghanaRoom, togoRoom, beninRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(ivorcoasRoom, ghanaRoom,
  //                                              togoRoom, beninRoom)>>" }
;
ghanaRoom: AfricaRoom
  vocabWords = 'ghana gh'
  name       = 'Ghana'
  capname    = 'Ghana'
  abbr       = 'GH'
  mainDesc =
    "The White Volta and Black Volta rivers empty here 
      into Lake Volta, Earth's largest artificial lake. "
  ivorcoas   = afrPassGhanIvor
  burkfaso   = afrPassGhanBurk
  togo       = afrPassGhanTogo
  //ivorcoas   = ivorcoasRoom
  //burkfaso   = burkfasoRoom
  //togo       = togoRoom
  west       asExit(ivorcoas)
  northwest  asExit(burkfaso)
  north      asExit(burkfaso)
  northeast  asExit(togo)
  east       asExit(togo)
  ghana      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(ivorcoasRoom, burkfasoRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(burkfasoRoom, togoRoom)>>" }
;
togoRoom: AfricaRoom
  vocabWords = 'togo tg'
  name       = 'Togo'
  capname    = 'Togo'
  abbr       = 'TG'
  mainDesc =
    "Rugged hills run through the center of this narrow region. "
  ghana      = afrPassTogoGhan
  burkfaso   = afrPassTogoBurk
  benin      = afrPassTogoBeni
  //ghana      = ghanaRoom
  //burkfaso   = burkfasoRoom
  //benin      = beninRoom
  west       asExit(ghana)
  northwest  asExit(ghana)
  north      asExit(burkfaso)
  northeast  asExit(benin)
  east       asExit(benin)
  togo       : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(ghanaRoom, burkfasoRoom)>>" }
;
beninRoom: AfricaRoom
  vocabWords = 'benin bj'
  name       = 'Benin'
  capname    = 'Benin'
  abbr       = 'BJ'
  mainDesc =
    "This area is taken up mostly by flat plateaus. "
  togo       = afrPassBeniTogo
  burkfaso   = afrPassBeniBurk
  niger      = afrPassBeniNige
  nigeria    = afrPassBeniNiri
  //togo       = togoRoom
  //burkfaso   = burkfasoRoom
  //niger      = nigerRoom
  //nigeria    = nigeriaRoom
  west       asExit(togo)
  northwest  asExit(burkfaso)
  north      asExit(niger)
  northeast  asExit(nigeria)
  east       asExit(nigeria)
  ne         asExit(niger)
  benin      : NoTravelMessage { "<<alreadyInNation()>>" }
;
nigeriaRoom: AfricaRoom
  vocabWords = 'nigeria ng'
  name       = 'Nigeria'
  capname    = 'Nigeria'
  abbr       = 'NG'
  mainDesc =
    "This is a fairly large region of hills and jungles. 
      The Niger River empties into the Atlantic here. "
  benin      = afrPassNiriBeni
  niger      = afrPassNiriNige
  chad       = afrPassNiriChad
  cameroon   = afrPassNiriCame
  //benin      = beninRoom
  //niger      = nigerRoom
  //chad       = chadRoom
  //cameroon   = cameroonRoom
  west       asExit(benin)
  northwest  asExit(niger)
  north      asExit(niger)
  northeast  asExit(chad)
  east       asExit(cameroon)
  southeast  asExit(cameroon)
  south      asExit(cameroon)
  ne         asExit(niger)
  nigeria    : NoTravelMessage { "<<alreadyInNation()>>" }
;
cameroonRoom: AfricaRoom
  vocabWords = 'cameroon cm'
  name       = 'Cameroon'
  capname    = 'Cameroon'
  abbr       = 'CM'
  mainDesc = "This is a diverse area of mountains, plateaus, 
    jungles, grasslands, and plains. "
  nigeria    = afrPassCameNiri
  chad       = afrPassCameChad
  centafri   = afrPassCameCent
  congo      = afrPassCameCong
  gabon      = afrPassCameGabo
  equaguin   = afrPassCameEqua
  //nigeria    = nigeriaRoom
  //chad       = chadRoom
  //centafri   = centafriRoom
  //congo      = congoRoom
  //gabon      = gabonRoom
  //equaguin   = equaguinRoom
  west       asExit(nigeria)
  northwest  asExit(nigeria)
  north      asExit(nigeria)
  northeast  asExit(chad)
  east       asExit(centafri)
  southeast  asExit(congo)
  south      asExit(gabon)
  southwest  asExit(equaguin)
  ambGuinea  asExit(equaguin)
  ambCongo   asExit(congo)
  ambRepub   asExit(centafri)
  cameroon   : NoTravelMessage { "<<alreadyInNation()>>" }
  //east      : NoTravelMessage { "<<ambigCompass(chadRoom, centafriRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(equaguinRoom, gabonRoom, congoRoom)>>" }
;
equaguinRoom: AfricaRoom
  vocabWords = 'equatorial guinea gq'
  name       = 'Equatorial Guinea'
  capname    = 'Equatorial Guinea'
  abbr       = 'GQ'
  mainDesc =
    "This small region hugs the Atlantic coast. "
  cameroon   = afrPassEquaCame
  gabon      = afrPassEquaGabo
  //cameroon   = cameroonRoom
  //gabon      = gabonRoom
  north      asExit(cameroon)
  northeast  asExit(cameroon)
  east       asExit(gabon)
  southeast  asExit(gabon)
  south      asExit(gabon)
  equaguin   : NoTravelMessage { "<<alreadyInNation()>>" }
  ambGuinea  : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(cameroonRoom, gabonRoom)>>" }
;
gabonRoom: AfricaRoom
  vocabWords = 'gabon ga'
  name       = 'Gabon'
  capname    = 'Gabon'
  abbr       = 'GA'
  mainDesc =
    "The Ogoou&eacute; River empties into the Atlantic here. "
  equaguin   = afrPassGaboEqua
  cameroon   = afrPassGaboCame
  congo      = afrPassGaboCong
  //equaguin   = equaguinRoom
  //cameroon   = cameroonRoom
  //congo      = congoRoom
  northwest  asExit(equaguin)
  north      asExit(cameroon)
  northeast  asExit(cameroon)
  east       asExit(congo)
  southeast  asExit(congo)
  south      asExit(congo)
  ambGuinea  asExit(equaguin)
  ambCongo   asExit(congo)
  gabon      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(cameroonRoom, gabonRoom)>>" }
;
congoRoom: AfricaRoom
  vocabWords = 'congo cg'
  name       = 'Congo'
  capname    = 'Congo'
  abbr       = 'CG'
  mainDesc =
    "This region is filled with jungle. The Congo River 
      lies just to the east. "
  gabon      = afrPassCongGabo
  cameroon   = afrPassCongCame
  centafri   = afrPassCongCent
  demorepu   = afrPassCongDemo
  //gabon      = gabonRoom
  //cameroon   = cameroonRoom
  //centafri   = centafriRoom
  //demorepu   = demorepuRoom
  west       asExit(gabon)
  northwest  asExit(cameroon)
  north      asExit(cameroon)
  northeast  asExit(centafri)
  east       asExit(demorepu)
  southeast  asExit(demorepu)
  south      asExit(demorepu)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(centafri)
  congo      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(gabonRoom, cameroonRoom)>>" }
  //north     : NoTravelMessage { "<<ambigCompass(cameroonRoom, centafriRoom)>>" }
;
centafriRoom: AfricaRoom // modified 2016-11-07
  vocabWords = 'central (african) (republic) cf'
  name       = 'Central African Republic'
  capname    = 'Central African Republic'
  abbr       = 'CF'
  mainDesc =
    "This is a broad region of plateaus and savannas. "
  cameroon   = afrPassCentCame
  chad       = afrPassCentChad
  sudan      = afrPassCentSuda
  southsudan = afrPassCentSosu
  demorepu   = afrPassCentDemo
  congo      = afrPassCentCong
  //cameroon   = cameroonRoom
  //chad       = chadRoom
  //sudan      = sudanRoom
  //demorepu   = demorepuRoom
  //congo      = congoRoom
  west       asExit(cameroon)
  northwest  asExit(chad)
  north      asExit(chad)
  northeast  asExit(sudan)
  east       asExit(southsudan)
  southeast  asExit(demorepu)
  south      asExit(demorepu)
  southwest  asExit(congo)
  ambCongo   asExit(congo)
  ambRepub   asExit(demorepu)
  ambSudan   asExit(sudan)
  centafri   : NoTravelMessage { "<<alreadyInNation()>>" }
;
demorepuRoom: AfricaRoom // modified 2016-11-07
  vocabWords = 'democratic (republic) (the) (congo) zaire za\u00EFre zr cd'
  name       = 'Democratic Republic of the Congo'
  capname    = 'Democratic Republic of the Congo'
  abbr       = 'CD'
  mainDesc =
    "The Congo River flows through here, encircling 
      a huge tropical forest. "
  congo      = afrPassDemoCong
  centafri   = afrPassDemoCent
  //sudan      = afrPassDemoSuda
  southsudan = afrPassDemoSosu
  uganda     = afrPassDemoUgan
  rwanda     = afrPassDemoRwan
  burundi    = afrPassDemoBuru
  tanzania   = afrPassDemoTanz
  zambia     = afrPassDemoZamb
  angola     = afrPassDemoAngo
  //congo      = congoRoom
  //centafri   = centafriRoom
  //sudan      = sudanRoom
  //uganda     = ugandaRoom
  //rwanda     = rwandaRoom
  //burundi    = burundiRoom
  //tanzania   = tanzaniaRoom
  //zambia     = zambiaRoom
  //angola     = angolaRoom
  west       asExit(congo)
  northwest  asExit(centafri)
  north      asExit(centafri)
  northeast  asExit(southsudan)
  east       asExit(tanzania)
  southeast  asExit(zambia)
  south      asExit(angola)
  southwest  asExit(angola)
  ambCongo   asExit(congo)
  ambRepub   asExit(centafri)
  ambSudan   asExit(southsudan)
  demorepu   : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(congoRoom, centafriRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(sudanRoom, ugandaRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(ugandaRoom, rwandaRoom,
  //                                              burundiRoom, tanzaniaRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(angolaRoom, zambiaRoom)>>" }
;
ugandaRoom: AfricaRoom // modified 2016-11-07
  vocabWords = 'uganda ug'
  name       = 'Uganda'
  capname    = 'Uganda'
  abbr       = 'UG'
  mainDesc = 
    "This area is on a high plateau. Lake Victoria 
      lies to the southeast. "
  demorepu   = afrPassUganDemo
  //sudan      = afrPassUganSuda
  southsudan = afrPassUganSosu
  kenya      = afrPassUganKeny
  tanzania   = afrPassUganTanz
  rwanda     = afrPassUganRwan
  //demorepu   = demorepuRoom
  //sudan      = sudanRoom
  //kenya      = kenyaRoom
  //tanzania   = tanzaniaRoom
  //rwanda     = rwandaRoom
  west       asExit(demorepu)
  northwest  asExit(southsudan)
  north      asExit(southsudan)
  northeast  asExit(southsudan)
  east       asExit(kenya)
  southeast  asExit(tanzania)
  south      asExit(rwanda)
  southwest  asExit(rwanda)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  ambSudan   asExit(southsudan)
  uganda     : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(demorepuRoom, sudanRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(sudanRoom, kenyaRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(rwandaRoom, kenyaRoom)>>" }
;
kenyaRoom: AfricaRoom // modified 2016-11-07
  vocabWords = 'kenya ke'
  name       = 'Kenya'
  capname    = 'Kenya'
  abbr       = 'KE'
  mainDesc =
    "This area is taken up by highlands and coastal plains. 
      Lake Victoria lies to the west. "
  tanzania   = afrPassKenyTanz
  uganda     = afrPassKenyUgan
  //sudan      = afrPassKenySuda
  southsudan = afrPassKenySosu
  ethiopia   = afrPassKenyEthi
  somalia    = afrPassKenySoma
  //tanzania   = tanzaniaRoom
  //uganda     = ugandaRoom
  //sudan      = sudanRoom
  //ethiopia   = ethiopiaRoom
  //somalia    = somaliaRoom
  south      asExit(tanzania)
  southwest  asExit(tanzania)
  west       asExit(uganda)
  northwest  asExit(southsudan)
  north      asExit(ethiopia)
  northeast  asExit(somalia)
  east       asExit(somalia)
  ambSudan   asExit(southsudan)
  kenya      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(ethiopiaRoom, somaliaRoom)>>" }
;
rwandaRoom: AfricaRoom
  vocabWords = 'rwanda rw'
  name       = 'Rwanda'
  capname    = 'Rwanda'
  abbr       = 'RW'
  mainDesc =
    "This is a small region of countless hills. "
  uganda     = afrPassRwanUgan
  tanzania   = afrPassRwanTanz
  burundi    = afrPassRwanBuru
  demorepu   = afrPassRwanDemo
  //uganda     = ugandaRoom
  //tanzania   = tanzaniaRoom
  //burundi    = burundiRoom
  //demorepu   = demorepuRoom
  west       asExit(demorepu)
  northwest  asExit(demorepu)
  north      asExit(uganda)
  northeast  asExit(uganda)
  east       asExit(tanzania)
  southeast  asExit(tanzania)
  south      asExit(burundi)
  southwest  asExit(demorepu)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  rwanda     : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(demorepuRoom, ugandaRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(ugandaRoom, tanzaniaRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(burundiRoom, tanzaniaRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(demorepuRoom, burundiRoom)>>" }
;
burundiRoom: AfricaRoom
  vocabWords = 'burundi bi'
  name       = 'Burundi'
  capname    = 'Burundi'
  abbr       = 'BI'
  mainDesc =
    "This is a small region of mountains and plateaus, 
      bordering Lake Tanganyika. "
  rwanda     = afrPassBuruRwan
  tanzania   = afrPassBuruTanz
  demorepu   = afrPassBuruDemo
  //rwanda     = rwandaRoom
  //tanzania   = tanzaniaRoom
  //demorepu   = demorepuRoom
  north      asExit(rwanda)
  northeast  asExit(rwanda)
  east       asExit(tanzania)
  southeast  asExit(tanzania)
  south      asExit(tanzania)
  southwest  asExit(demorepu)
  west       asExit(demorepu)
  northwest  asExit(demorepu)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  burundi    : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(rwandaRoom, tanzaniaRoom)>>" }
;
tanzaniaRoom: AfricaRoom
  vocabWords = 'tanzania tz'
  name       = 'Tanzania'
  capname    = 'Tanzania'
  abbr       = 'TZ'
  mainDesc =
    "Mountains and plateaus run through this area, including 
      Mt. Kilimanjaro. Also nearby are Africa's 
      three biggest lakes: Victoria, Tanganyika, and Malawi. "
  kenya      = afrPassTanzKeny
  uganda     = afrPassTanzUgan
  rwanda     = afrPassTanzRwan
  burundi    = afrPassTanzBuru
  demorepu   = afrPassTanzDemo
  zambia     = afrPassTanzZamb
  malawi     = afrPassTanzMala
  mozambique = afrPassTanzMoza
  //kenya      = kenyaRoom
  //uganda     = ugandaRoom
  //rwanda     = rwandaRoom
  //burundi    = burundiRoom
  //demorepu   = demorepuRoom
  //zambia     = zambiaRoom
  //malawi     = malawiRoom
  //mozambique = mozambiqueRoom
  northeast  asExit(kenya)
  north      asExit(uganda)
  northwest  asExit(burundi)
  west       asExit(demorepu)
  southwest  asExit(zambia)
  south      asExit(malawi)
  southeast  asExit(mozambique)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  tanzania   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(ugandaRoom, kenyaRoom)>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(ugandaRoom, rwandaRoom, burundiRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(zambiaRoom, malawiRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(malawiRoom, mozambiqueRoom)>>" }
;
angolaRoom: AfricaRoom
  vocabWords = 'angola ao'
  name       = 'Angola'
  capname    = 'Angola'
  abbr       = 'AO'
  mainDesc =
    "This area is mostly filled with plateaus and highlands. "
  demorepu   = afrPassAngoDemo
  zambia     = afrPassAngoZamb
  namibia    = afrPassAngoNami
  //demorepu   = demorepuRoom
  //zambia     = zambiaRoom
  //namibia    = namibiaRoom
  north      asExit(demorepu)
  northeast  asExit(demorepu)
  east       asExit(zambia)
  southeast  asExit(namibia)
  south      asExit(namibia)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  angola     : NoTravelMessage { "<<alreadyInNation()>>" }
;
zambiaRoom: AfricaRoom
  vocabWords = 'zambia zm'
  name       = 'Zambia'
  capname    = 'Zambia'
  abbr       = 'ZM'
  mainDesc =
    "This is a broad plateau region. The Zambezi River 
      flows by to the south. "
  namibia    = afrPassZambNami
  angola     = afrPassZambAngo
  demorepu   = afrPassZambDemo
  tanzania   = afrPassZambTanz
  malawi     = afrPassZambMala
  mozambique = afrPassZambMoza
  zimbabwe   = afrPassZambZimb
  botswana   = afrPassZambBots
  //namibia    = namibiaRoom
  //angola     = angolaRoom
  //demorepu   = demorepuRoom
  //tanzania   = tanzaniaRoom
  //malawi     = malawiRoom
  //mozambique = mozambiqueRoom
  //zimbabwe   = zimbabweRoom
  //botswana   = botswanaRoom
  west       asExit(angola)
  northwest  asExit(demorepu)
  north      asExit(demorepu)
  northeast  asExit(tanzania)
  east       asExit(malawi)
  southeast  asExit(mozambique)
  south      asExit(zimbabwe)
  southwest  asExit(namibia)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  zambia     : NoTravelMessage { "<<alreadyInNation()>>" }
  //east      : NoTravelMessage { "<<ambigCompass(malawiRoom, mozambiqueRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(mozambiqueRoom, zimbabweRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(botswanaRoom, zimbabweRoom)>>" }
;
malawiRoom: AfricaRoom
  vocabWords = 'malawi mw'
  name       = 'Malawi'
  capname    = 'Malawi'
  abbr       = 'MW'
  mainDesc =
    "This narrow region follows along Lake Malawi to the east. "
  tanzania   = afrPassMalaTanz
  mozambique = afrPassMalaMoza
  zambia     = afrPassMalaZamb
  //tanzania   = tanzaniaRoom
  //mozambique = mozambiqueRoom
  //zambia     = zambiaRoom
  west       asExit(zambia)
  northwest  asExit(zambia)
  north      asExit(tanzania)
  northeast  asExit(tanzania)
  east       asExit(mozambique)
  southeast  asExit(mozambique)
  south      asExit(mozambique)
  southwest  asExit(mozambique)
  malawi     : NoTravelMessage { "<<alreadyInNation()>>" }
;
mozambiqueRoom: AfricaRoom
  vocabWords = 'mozambique mz'
  name       = 'Mozambique'
  capname    = 'Mozambique'
  abbr       = 'MZ'
  mainDesc =
    "This large area runs along the Indian Ocean 
      for hundreds of miles. The Zambezi River flows through here. "
  tanzania   = afrPassMozaTanz
  malawi     = afrPassMozaMala
  zambia     = afrPassMozaZamb
  zimbabwe   = afrPassMozaZimb
  soutafri   = afrPassMozaSout
  swaziland  = afrPassMozaSwaz
  //tanzania   = tanzaniaRoom
  //malawi     = malawiRoom
  //zambia     = zambiaRoom
  //zimbabwe   = zimbabweRoom
  //soutafri   = soutafriRoom
  //swaziland  = swazilandRoom
  northeast  asExit(tanzania)
  north      asExit(malawi)
  northwest  asExit(zambia)
  west       asExit(zimbabwe)
  southwest  asExit(soutafri)
  south      asExit(soutafri)
  ambAfrica  asExit(soutafri)
  mozambique : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(malawiRoom, tanzaniaRoom)>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(zambiaRoom, malawiRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(soutafriRoom, swazilandRoom)>>" }
;
namibiaRoom: AfricaRoom
  vocabWords = 'namibia na'
  name       = 'Namibia'
  capname    = 'Namibia'
  abbr       = 'NA'
  mainDesc =
    "This dry region includes the Namib Desert 
      and part of the Kalahari. "
  angola     = afrPassNamiAngo
  zambia     = afrPassNamiZamb
  botswana   = afrPassNamiBots
  soutafri   = afrPassNamiSout
  //angola     = angolaRoom
  //zambia     = zambiaRoom
  //botswana   = botswanaRoom
  //soutafri   = soutafriRoom
  north      asExit(angola)
  northeast  asExit(zambia)
  east       asExit(botswana)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  ambAfrica  asExit(soutafri)
  namibia    : NoTravelMessage { "<<alreadyInNation()>>" }
;
botswanaRoom: AfricaRoom
  vocabWords = 'botswana bw'
  name       = 'Botswana'
  capname    = 'Botswana'
  abbr       = 'BW'
  mainDesc =
    "Most of this area is taken up by the arid Kalahari Desert. "
  namibia    = afrPassBotsNami
  zambia     = afrPassBotsZamb
  zimbabwe   = afrPassBotsZimb
  soutafri   = afrPassBotsSout
  //namibia    = namibiaRoom
  //zambia     = zambiaRoom
  //zimbabwe   = zimbabweRoom
  //soutafri   = soutafriRoom
  west       asExit(namibia)
  northwest  asExit(namibia)
  north      asExit(zambia)
  northeast  asExit(zimbabwe)
  east       asExit(zimbabwe)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  southwest  asExit(soutafri)
  ambAfrica  asExit(soutafri)
  botswana   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(namibiaRoom, zambiaRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(zimbabweRoom, soutafriRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(namibiaRoom, soutafriRoom)>>" }
;
zimbabweRoom: AfricaRoom
  vocabWords = 'zimbabwe zw'
  name       = 'Zimbabwe'
  capname    = 'Zimbabwe'
  abbr       = 'ZW'
  mainDesc =
    "This is a rugged region of ridges and plateaus. 
      The Zambezi River flows by to the north. "
  zambia     = afrPassZimbZamb
  mozambique = afrPassZimbMoza
  soutafri   = afrPassZimbSout
  botswana   = afrPassZimbBots
  //zambia     = zambiaRoom
  //mozambique = mozambiqueRoom
  //soutafri   = soutafriRoom
  //botswana   = botswanaRoom
  northwest  asExit(zambia)
  north      asExit(zambia)
  northeast  asExit(mozambique)
  east       asExit(mozambique)
  southeast  asExit(mozambique)
  south      asExit(soutafri)
  southwest  asExit(botswana)
  west       asExit(botswana)
  ambAfrica  asExit(soutafri)
  zimbabwe   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(zambiaRoom, mozambiqueRoom)>>" }
;
swazilandRoom: AfricaRoom
  vocabWords = 'swaziland sz'
  name       = 'Swaziland'
  capname    = 'Swaziland'
  abbr       = 'SZ'
  mainDesc =
    "This is a small region of mountains and plateaus. "
  soutafri   = afrPassSwazSout
  mozambique = afrPassSwazMoza
  //soutafri   = soutafriRoom
  //mozambique = mozambiqueRoom
  northeast  asExit(mozambique)
  east       asExit(mozambique)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  southwest  asExit(soutafri)
  west       asExit(soutafri)
  northwest  asExit(soutafri)
  north      asExit(soutafri)
  ambAfrica  asExit(soutafri)
  swaziland  : NoTravelMessage { "<<alreadyInNation()>>" }
;
soutafriRoom: AfricaRoom
  vocabWords = 'south (africa) za'
  name       = 'South Africa'
  capname    = 'South Africa'
  abbr       = 'ZA'
  mainDesc =
    "This southern part of Africa consists of a large plateau 
      surrounded by mountains. "
  namibia    = afrPassSoutNami
  botswana   = afrPassSoutBots
  zimbabwe   = afrPassSoutZimb
  mozambique = afrPassSoutMoza
  swaziland  = afrPassSoutSwaz
  lesotho    = afrPassSoutLeso
  //namibia    = namibiaRoom
  //botswana   = botswanaRoom
  //zimbabwe   = zimbabweRoom
  //mozambique = mozambiqueRoom
  //swaziland  = swazilandRoom
  //lesotho    = lesothoRoom
  northwest  asExit(namibia)
  north      asExit(botswana)
  northeast  asExit(mozambique)
  east       asExit(swaziland)
  southeast  asExit(lesotho)
  in         asExit(lesotho)
  ambAfrica  : NoTravelMessage { "<<alreadyInNation()>>" }
  soutafri   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(namibiaRoom, botswanaRoom,
  //                                              zimbabweRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(zimbabweRoom, mozambiqueRoom,
  //                                              swazilandRoom, lesothoRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(mozambiqueRoom, swazilandRoom,
  //                                              lesothoRoom)>>" }
;
lesothoRoom: AfricaRoom
  vocabWords = 'lesotho ls'
  name       = 'Lesotho'
  capname    = 'Lesotho'
  abbr       = 'LS'
  mainDesc =
    "This small region is filled with high mountains. "
  soutafri   = afrPassLesoSout
  //soutafri   = soutafriRoom
  north      asExit(soutafri)
  northeast  asExit(soutafri)
  east       asExit(soutafri)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  southwest  asExit(soutafri)
  west       asExit(soutafri)
  northwest  asExit(soutafri)
  out        asExit(soutafri)
  ambAfrica  asExit(soutafri)
  lesotho     : NoTravelMessage { "<<alreadyInNation()>>" }
;

// Animal associations for each nation.

//enum camels, crocodiles, hippos, elephants, hyenas,
//  lions, rhinos, ostriches, jackals;

modify moroccoRoom    asscAnimals=camels    ;
modify algeriaRoom    asscAnimals=camels    ;
modify tunisiaRoom    asscAnimals=camels    ;
modify libyaRoom      asscAnimals=camels    ;
modify egyptRoom      asscAnimals=camels    ;
modify westsahaRoom   asscAnimals=camels    ;
modify mauritaniaRoom asscAnimals=camels    ;
modify maliRoom       asscAnimals=camels    ;
modify nigerRoom      asscAnimals=camels    ;
modify chadRoom       asscAnimals=camels    ;
modify sudanRoom      asscAnimals=camels    ;
modify southsudanRoom asscAnimals=elephants ;
modify senegalRoom    asscAnimals=crocodiles;
modify gambiaRoom     asscAnimals=crocodiles;
modify guinbissRoom   asscAnimals=crocodiles;
modify guineaRoom     asscAnimals=crocodiles;
modify sierleonRoom   asscAnimals=crocodiles;
modify liberiaRoom    asscAnimals=crocodiles;
modify ivorcoasRoom   asscAnimals=hippos    ;
modify burkfasoRoom   asscAnimals=hippos    ;
modify ghanaRoom      asscAnimals=hippos    ;
modify togoRoom       asscAnimals=hippos    ;
modify beninRoom      asscAnimals=hippos    ;
modify nigeriaRoom    asscAnimals=hippos    ;
modify cameroonRoom   asscAnimals=elephants ;
modify equaguinRoom   asscAnimals=elephants ;
modify gabonRoom      asscAnimals=elephants ;
modify congoRoom      asscAnimals=elephants ;
modify centafriRoom   asscAnimals=elephants ;
modify demorepuRoom   asscAnimals=elephants ;
modify eritreaRoom    asscAnimals=hyenas    ;
modify ethiopiaRoom   asscAnimals=hyenas    ;
modify djiboutiRoom   asscAnimals=hyenas    ;
modify somaliaRoom    asscAnimals=hyenas    ;
modify ugandaRoom     asscAnimals=lions     ;
modify kenyaRoom      asscAnimals=lions     ;
modify rwandaRoom     asscAnimals=lions     ;
modify burundiRoom    asscAnimals=lions     ;
modify tanzaniaRoom   asscAnimals=lions     ;
modify malawiRoom     asscAnimals=lions     ;
modify mozambiqueRoom asscAnimals=lions     ;
modify angolaRoom     asscAnimals=rhinos    ;
modify zambiaRoom     asscAnimals=rhinos    ;
modify zimbabweRoom   asscAnimals=rhinos    ;
modify namibiaRoom    asscAnimals=ostriches ;
modify botswanaRoom   asscAnimals=ostriches ;
modify swazilandRoom  asscAnimals=jackals   ;
modify soutafriRoom   asscAnimals=jackals   ;
modify lesothoRoom    asscAnimals=jackals   ;

modify moroccoRoom
  borderRooms = [westsahaRoom, algeriaRoom]
;
modify algeriaRoom
  borderRooms = [moroccoRoom, westsahaRoom, mauritaniaRoom, maliRoom, nigerRoom, libyaRoom, tunisiaRoom]
;
modify tunisiaRoom
  borderRooms = [algeriaRoom, libyaRoom]
;
modify libyaRoom
  borderRooms = [tunisiaRoom, algeriaRoom, nigerRoom, chadRoom, sudanRoom, egyptRoom]
;
modify egyptRoom
  borderRooms = [libyaRoom, sudanRoom]
;
modify westsahaRoom
  borderRooms = [moroccoRoom, algeriaRoom, mauritaniaRoom]
;
modify mauritaniaRoom
  borderRooms = [westsahaRoom, algeriaRoom, maliRoom, senegalRoom]
;
modify maliRoom
  borderRooms = [algeriaRoom, nigerRoom, burkfasoRoom, ivorcoasRoom, guineaRoom, senegalRoom, mauritaniaRoom]
;
modify nigerRoom
  borderRooms = [algeriaRoom, libyaRoom, chadRoom, nigeriaRoom, beninRoom, burkfasoRoom, maliRoom]
;
modify chadRoom
  borderRooms = [cameroonRoom, nigeriaRoom, nigerRoom, libyaRoom, sudanRoom, centafriRoom]
;
modify sudanRoom // modified 2016-11-07
  borderRooms = [egyptRoom, libyaRoom, chadRoom, centafriRoom, southsudanRoom, ethiopiaRoom, eritreaRoom]
;
modify southsudanRoom // modified 2016-11-07
  borderRooms = [sudanRoom, ethiopiaRoom, kenyaRoom, ugandaRoom, demorepuRoom, centafriRoom]
;
modify eritreaRoom
  borderRooms = [sudanRoom, ethiopiaRoom, djiboutiRoom]
;
modify ethiopiaRoom // modified 2016-11-07
  borderRooms = [eritreaRoom, djiboutiRoom, somaliaRoom, kenyaRoom, southsudanRoom, sudanRoom]
;
modify djiboutiRoom
  borderRooms = [eritreaRoom, ethiopiaRoom, somaliaRoom]
;
modify somaliaRoom
  borderRooms = [djiboutiRoom, ethiopiaRoom, kenyaRoom]
;
modify senegalRoom
  borderRooms = [gambiaRoom, mauritaniaRoom, maliRoom, guineaRoom, guinbissRoom]
;
modify gambiaRoom
  borderRooms = [senegalRoom]
;
modify guinbissRoom
  borderRooms = [senegalRoom, guineaRoom]
;
modify guineaRoom
  borderRooms = [guinbissRoom, senegalRoom, maliRoom, ivorcoasRoom, liberiaRoom, sierleonRoom]
;
modify sierleonRoom
  borderRooms = [guineaRoom, liberiaRoom]
;
modify liberiaRoom
  borderRooms = [sierleonRoom, guineaRoom, ivorcoasRoom]
;
modify ivorcoasRoom
  borderRooms = [liberiaRoom, guineaRoom, maliRoom, burkfasoRoom, ghanaRoom]
;
modify burkfasoRoom
  borderRooms = [maliRoom, nigerRoom, beninRoom, togoRoom, ghanaRoom, ivorcoasRoom]
;
modify ghanaRoom
  borderRooms = [ivorcoasRoom, burkfasoRoom, togoRoom]
;
modify togoRoom
  borderRooms = [ghanaRoom, burkfasoRoom, beninRoom]
;
modify beninRoom
  borderRooms = [togoRoom, burkfasoRoom, nigerRoom, nigeriaRoom]
;
modify nigeriaRoom
  borderRooms = [beninRoom, nigerRoom, chadRoom, cameroonRoom]
;
modify cameroonRoom
  borderRooms = [nigeriaRoom, chadRoom, centafriRoom, congoRoom, gabonRoom, equaguinRoom]
;
modify equaguinRoom
  borderRooms = [cameroonRoom, gabonRoom]
;
modify gabonRoom
  borderRooms = [equaguinRoom, cameroonRoom, congoRoom]
;
modify congoRoom
  borderRooms = [gabonRoom, cameroonRoom, centafriRoom, demorepuRoom]
;
modify centafriRoom // modified 2016-11-07
  borderRooms = [chadRoom, sudanRoom, southsudanRoom, demorepuRoom, congoRoom, cameroonRoom]
;
modify demorepuRoom // modified 2016-11-07
  borderRooms = [congoRoom, centafriRoom, southsudanRoom, ugandaRoom, rwandaRoom, burundiRoom, tanzaniaRoom, zambiaRoom, angolaRoom]
;
modify ugandaRoom // modified 2016-11-07
  borderRooms = [southsudanRoom, kenyaRoom, tanzaniaRoom, rwandaRoom, demorepuRoom]
;
modify kenyaRoom // modified 2016-11-07
  borderRooms = [somaliaRoom, ethiopiaRoom, southsudanRoom, ugandaRoom, tanzaniaRoom]
;
modify rwandaRoom
  borderRooms = [ugandaRoom, tanzaniaRoom, burundiRoom, demorepuRoom]
;
modify burundiRoom
  borderRooms = [rwandaRoom, tanzaniaRoom, demorepuRoom]
;
modify tanzaniaRoom
  borderRooms = [kenyaRoom, ugandaRoom, rwandaRoom, burundiRoom, demorepuRoom, zambiaRoom, malawiRoom, mozambiqueRoom]
;
modify angolaRoom
  borderRooms = [demorepuRoom, zambiaRoom, namibiaRoom]
;
modify zambiaRoom
  borderRooms = [demorepuRoom, tanzaniaRoom, malawiRoom, mozambiqueRoom, zimbabweRoom, botswanaRoom, namibiaRoom, angolaRoom]
;
modify malawiRoom
  borderRooms = [tanzaniaRoom, mozambiqueRoom, zambiaRoom]
;
modify mozambiqueRoom
  borderRooms = [tanzaniaRoom, malawiRoom, zambiaRoom, zimbabweRoom, soutafriRoom, swazilandRoom]
;
modify namibiaRoom
  borderRooms = [angolaRoom, zambiaRoom, botswanaRoom, soutafriRoom]
;
modify botswanaRoom
  borderRooms = [namibiaRoom, zambiaRoom, zimbabweRoom, soutafriRoom]
;
modify zimbabweRoom
  borderRooms = [zambiaRoom, mozambiqueRoom, soutafriRoom, botswanaRoom]
;
modify swazilandRoom
  borderRooms = [mozambiqueRoom, soutafriRoom]
;
modify soutafriRoom
  borderRooms = [namibiaRoom, botswanaRoom, zimbabweRoom, mozambiqueRoom, swazilandRoom, lesothoRoom]
;
modify lesothoRoom
  borderRooms = [soutafriRoom]
;


/*
moroccoRoom: AfricaRoom 'Morocco'
  capname    = 'Morocco'
  abbr       = 'MA'
  westsaha   = afrPassMoroWest
  algeria    = afrPassMoroAlge
  //westsaha   = westsahaRoom
  //algeria    = algeriaRoom
  east       asExit(algeria)
  southeast  asExit(algeria)
  south      asExit(westsaha)
  southwest  asExit(westsaha)
  morocco    : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(algeriaRoom, westsahaRoom)>>" }
;
algeriaRoom: AfricaRoom 'Algeria'
  capname    = 'Algeria'
  abbr       = 'DZ'
  morocco    = afrPassAlgeMoro
  westsaha   = afrPassAlgeWest
  mauritania = afrPassAlgeMaur
  mali       = afrPassAlgeMali
  niger      = afrPassAlgeNige
  libya      = afrPassAlgeLiby
  tunisia    = afrPassAlgeTuni
  //morocco    = moroccoRoom
  //westsaha   = westsahaRoom
  //mauritania = mauritaniaRoom
  //mali       = maliRoom
  //niger      = nigerRoom
  //libya      = libyaRoom
  //tunisia    = tunisiaRoom
  northwest  asExit(morocco)
  west       asExit(westsaha)
  southwest  asExit(mauritania)
  south      asExit(mali)
  southeast  asExit(niger)
  east       asExit(libya)
  northeast  asExit(tunisia)
  ne         asExit(niger)
  algeria    : NoTravelMessage { "<<alreadyInNation()>>" }
  //west      : NoTravelMessage { "<<ambigCompass(moroccoRoom,    westsahaRoom, 
  //                                              mauritaniaRoom, maliRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(mauritaniaRoom, maliRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(maliRoom,       nigerRoom)>>" }
;
tunisiaRoom: AfricaRoom 'Tunisia'
  capname    = 'Tunisia'
  abbr       = 'TN'
  algeria    = afrPassTuniAlge
  libya      = afrPassTuniLiby
  //algeria    = algeriaRoom
  //libya      = libyaRoom
  west       asExit(algeria)
  southwest  asExit(algeria)
  south      asExit(libya)
  southeast  asExit(libya)
  east       asExit(libya)
  tunisia    : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(algeriaRoom, libyaRoom)>>" }
;
libyaRoom: AfricaRoom 'Libya'
  capname    = 'Libya'
  abbr       = 'LY'
  tunisia    = afrPassLibyTuni
  algeria    = afrPassLibyAlge
  niger      = afrPassLibyNige
  chad       = afrPassLibyChad
  sudan      = afrPassLibySuda
  egypt      = afrPassLibyEgyp
  //tunisia    = tunisiaRoom
  //algeria    = algeriaRoom
  //niger      = nigerRoom
  //chad       = chadRoom
  //sudan      = sudanRoom
  //egypt      = egyptRoom
  northwest  asExit(tunisia)
  west       asExit(algeria)
  southwest  asExit(niger)
  south      asExit(chad)
  southeast  asExit(sudan)
  east       asExit(egypt)
  ne         asExit(niger)
  libya      : NoTravelMessage { "<<alreadyInNation()>>" }
;
egyptRoom: AfricaRoom 'Egypt'
  capname    = 'Egypt'
  abbr       = 'EG'
  libya      = afrPassEgypLiby
  sudan      = afrPassEgypSuda
  //libya      = libyaRoom
  //sudan      = sudanRoom
  west       asExit(libya)
  southwest  asExit(libya)
  south      asExit(sudan)
  southeast  asExit(sudan)
  egypt      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest  asExit(libya)
  //southwest : NoTravelMessage { "<<ambigCompass(libyaRoom, sudanRoom)>>" }
;
westsahaRoom: AfricaRoom 'Western Sahara'
  capname    = 'Western Sahara'
  abbr       = 'EH'
  morocco    = afrPassWestMoro
  algeria    = afrPassWestAlge
  mauritania = afrPassWestMaur
  //morocco    = moroccoRoom
  //algeria    = algeriaRoom
  //mauritania = mauritaniaRoom
  north      asExit(morocco)
  northeast  asExit(morocco)
  east       asExit(algeria)
  southeast  asExit(mauritania)
  south      asExit(mauritania)
  westsaha   : NoTravelMessage { "<<alreadyInNation()>>" }
;
mauritaniaRoom: AfricaRoom 'Mauritania'
  capname    = 'Mauritania'
  abbr       = 'MR'
  westsaha   = afrPassMaurWest
  algeria    = afrPassMaurAlge
  mali       = afrPassMaurMali
  senegal    = afrPassMaurSene
  //westsaha   = westsahaRoom
  //algeria    = algeriaRoom
  //mali       = maliRoom
  //senegal    = senegalRoom
  northwest  asExit(westsaha)
  north      asExit(westsaha)
  northeast  asExit(algeria)
  east       asExit(mali)
  southeast  asExit(mali)
  south      asExit(mali)
  southwest  asExit(senegal)
  //south     : NoTravelMessage { "<<ambigCompass(senegalRoom, maliRoom)>>" }
  mauritania : NoTravelMessage { "<<alreadyInNation()>>" }
;
maliRoom: AfricaRoom 'Mali'
  capname    = 'Mali'
  abbr       = 'ML'
  mauritania = afrPassMaliMaur
  algeria    = afrPassMaliAlge
  niger      = afrPassMaliNige
  burkfaso   = afrPassMaliBurk
  ivorcoas   = afrPassMaliIvor
  guinea     = afrPassMaliGuin
  senegal    = afrPassMaliSene
  //mauritania = mauritaniaRoom
  //algeria    = algeriaRoom
  //niger      = nigerRoom
  //burkfaso   = burkfasoRoom
  //ivorcoas   = ivorcoasRoom
  //guinea     = guineaRoom
  //senegal    = senegalRoom
  northwest  asExit(mauritania)
  north      asExit(algeria)
  northeast  asExit(algeria)
  east       asExit(niger)
  southeast  asExit(burkfaso)
  south      asExit(ivorcoas)
  southwest  asExit(guinea)
  west       asExit(senegal)
  ne         asExit(niger)
  ambGuinea  asExit(guinea)
  mali       : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(mauritaniaRoom, algeriaRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(ivorcoasRoom, burkfasoRoom)>>" }
  //west      : NoTravelMessage { "<<ambigCompass(mauritaniaRoom, senegalRoom)>>" }
;
nigerRoom: AfricaRoom 'Niger'
  capname    = 'Niger'
  abbr       = 'NE'
  benin      = afrPassNigeBeni
  burkfaso   = afrPassNigeBurk
  mali       = afrPassNigeMali
  algeria    = afrPassNigeAlge
  libya      = afrPassNigeLiby
  chad       = afrPassNigeChad
  nigeria    = afrPassNigeNiri
  //benin      = beninRoom
  //burkfaso   = burkfasoRoom
  //mali       = maliRoom
  //algeria    = algeriaRoom
  //libya      = libyaRoom
  //chad       = chadRoom
  //nigeria    = nigeriaRoom
  west       asExit(mali)
  northwest  asExit(algeria)
  north      asExit(algeria)
  northeast  asExit(libya)
  east       asExit(chad)
  southeast  asExit(chad)
  south      asExit(nigeria)
  southwest  asExit(burkfaso)
  niger      : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(algeriaRoom, libyaRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(nigeriaRoom, chadRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(burkfasoRoom, beninRoom)>>" }
;
chadRoom: AfricaRoom 'Chad'
  capname    = 'Chad'
  abbr       = 'TD'
  cameroon   = afrPassChadCame
  nigeria    = afrPassChadNiri
  niger      = afrPassChadNige
  libya      = afrPassChadLiby
  sudan      = afrPassChadSuda
  centafri   = afrPassChadCent
  //cameroon   = cameroonRoom
  //nigeria    = nigeriaRoom
  //niger      = nigerRoom
  //libya      = libyaRoom
  //sudan      = sudanRoom
  //centafri   = centafriRoom
  northwest  asExit(niger)
  north      asExit(libya)
  northeast  asExit(sudan)
  east       asExit(sudan)
  southeast  asExit(centafri)
  south      asExit(centafri)
  southwest  asExit(cameroon)
  west       asExit(nigeria)
  ne         asExit(niger)
  ambRepub   asExit(centafri)
  chad       : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(libyaRoom, sudanRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(centafriRoom, sudanRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(nigeriaRoom, cameroonRoom)>>" }
  //west      : NoTravelMessage { "<<ambigCompass(nigerRoom, nigeriaRoom,
  //                                              cameroonRoom)>>" }
;
sudanRoom: AfricaRoom 'Sudan'
  capname    = 'Sudan'
  abbr       = 'SD'
  egypt      = afrPassSudaEgyp
  libya      = afrPassSudaLiby
  chad       = afrPassSudaChad
  centafri   = afrPassSudaCent
  demorepu   = afrPassSudaDemo
  uganda     = afrPassSudaUgan
  kenya      = afrPassSudaKeny
  ethiopia   = afrPassSudaEthi
  eritrea    = afrPassSudaErit
  //egypt      = egyptRoom
  //libya      = libyaRoom
  //chad       = chadRoom
  //centafri   = centafriRoom
  //demorepu   = demorepuRoom
  //uganda     = ugandaRoom
  //kenya      = kenyaRoom
  //ethiopia   = ethiopiaRoom
  //eritrea    = eritreaRoom
  north      asExit(egypt)
  northwest  asExit(libya)
  west       asExit(chad)
  southwest  asExit(centafri)
  south      asExit(demorepu)
  southeast  asExit(kenya)
  east       asExit(ethiopia)
  northeast  asExit(eritrea)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(centafri)
  sudan      : NoTravelMessage { "<<alreadyInNation()>>" }
  //west      : NoTravelMessage { "<<ambigCompass(chadRoom, centafriRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(demorepuRoom, ugandaRoom,
  //                                              kenyaRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(ethiopiaRoom, kenyaRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(eritreaRoom, ethiopiaRoom)>>" }
;
eritreaRoom: AfricaRoom 'Eritrea'
  capname    = 'Eritrea'
  abbr       = 'ER'
  //eritreaRoom   
  sudan      = afrPassEritSuda
  ethiopia   = afrPassEritEthi
  djibouti   = afrPassEritDjib
  //sudan      = sudanRoom
  //ethiopia   = ethiopiaRoom
  //djibouti   = djiboutiRoom
  northwest  asExit(sudan)
  west       asExit(sudan)
  southwest  asExit(sudan)
  south      asExit(ethiopia)
  southeast  asExit(djibouti)
  east       asExit(djibouti)
  eritrea    : NoTravelMessage { "<<alreadyInNation()>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(sudanRoom, ethiopiaRoom)>>" }
;
ethiopiaRoom: AfricaRoom 'Ethiopia'
  capname    = 'Ethiopia'
  abbr       = 'ET'
  eritrea    = afrPassEthiErit
  djibouti   = afrPassEthiDjib
  somalia    = afrPassEthiSoma
  kenya      = afrPassEthiKeny
  sudan      = afrPassEthiSuda
  //eritrea    = eritreaRoom
  //djibouti   = djiboutiRoom
  //somalia    = somaliaRoom
  //kenya      = kenyaRoom
  //sudan      = sudanRoom
  north      asExit(eritrea)
  northeast  asExit(djibouti)
  east       asExit(somalia)
  southeast  asExit(somalia)
  south      asExit(kenya)
  southwest  asExit(kenya)
  west       asExit(sudan)
  northwest  asExit(sudan)
  ethiopia   : NoTravelMessage { "<<alreadyInNation()>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(sudanRoom, kenyaRoom)>>" }
;
djiboutiRoom: AfricaRoom 'Djibouti'
  capname    = 'Djibouti'
  abbr       = 'DJ'
  eritrea    = afrPassDjibErit
  ethiopia   = afrPassDjibEthi
  somalia    = afrPassDjibSoma
  //eritrea    = eritreaRoom
  //ethiopia   = ethiopiaRoom
  //somalia    = somaliaRoom
  north      asExit(eritrea)
  northwest  asExit(eritrea)
  west       asExit(ethiopia)
  southwest  asExit(ethiopia)
  south      asExit(ethiopia)
  southeast  asExit(somalia)
  east       asExit(somalia)
  djibouti   : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(ethiopiaRoom, somaliaRoom)>>" }
;
somaliaRoom: AfricaRoom 'Somalia'
  capname    = 'Somalia'
  abbr       = 'SO'
  djibouti   = afrPassSomaDjib
  ethiopia   = afrPassSomaEthi
  kenya      = afrPassSomaKeny
  //djibouti   = djiboutiRoom
  //ethiopia   = ethiopiaRoom
  //kenya      = kenyaRoom
  northwest  asExit(djibouti)
  west       asExit(ethiopia)
  southwest  asExit(kenya)
  somalia    : NoTravelMessage { "<<alreadyInNation()>>" }
;
senegalRoom: AfricaRoom 'Senegal'
  //'s\u00E9n\u00E9gal': add to vocabWords
  capname    = 'Senegal'
  abbr       = 'SN'
  mauritania = afrPassSeneMaur
  mali       = afrPassSeneMali
  guinea     = afrPassSeneGuin
  guinbiss   = afrPassSeneGubi
  gambia     = afrPassSeneGamb
  //mauritania = mauritaniaRoom
  //mali       = maliRoom
  //guinea     = guineaRoom
  //guinbiss   = guinbissRoom
  //gambia     = gambiaRoom
  north      asExit(mauritania)
  northeast  asExit(mauritania)
  east       asExit(mali)
  southeast  asExit(guinea)
  south      asExit(guinbiss)
  southwest  asExit(guinbiss)
  west       asExit(gambia)
  in         asExit(gambia)
  ambGuinea  asExit(guinea)
  senegal    : NoTravelMessage { "<<alreadyInNation()>>" }
  //south     : NoTravelMessage { "<<ambigCompass(guinbissRoom, guineaRoom)>>" }
;
gambiaRoom: AfricaRoom 'Gambia'
  capname    = 'Gambia'
  abbr       = 'GM'
  senegal    = afrPassGambSene
  //senegal    = senegalRoom
  north      asExit(senegal)
  northeast  asExit(senegal)
  east       asExit(senegal)
  southeast  asExit(senegal)
  south      asExit(senegal)
  out        asExit(senegal)
  gambia     : NoTravelMessage { "<<alreadyInNation()>>" }
;
guinbissRoom: AfricaRoom 'Guinea-Bissau'
  capname    = 'Guinea-Bissau'
  abbr       = 'GW'
  senegal    = afrPassGubiSene
  guinea     = afrPassGubiGuin
  //senegal    = senegalRoom
  //guinea     = guineaRoom
  northwest  asExit(senegal)
  north      asExit(senegal)
  northeast  asExit(senegal)
  east       asExit(guinea)
  southeast  asExit(guinea)
  south      asExit(guinea)
  ambGuinea  asExit(guinea)
  guinbiss   : NoTravelMessage { "<<alreadyInNation()>>" }
;
guineaRoom: AfricaRoom 'Guinea'
  capname    = 'Guinea'
  abbr       = 'GN'
  guinbiss   = afrPassGuinGubi
  senegal    = afrPassGuinSene
  mali       = afrPassGuinMali
  ivorcoas   = afrPassGuinIvor
  liberia    = afrPassGuinLibe
  sierleon   = afrPassGuinSier
  //guinbiss   = guinbissRoom
  //senegal    = senegalRoom
  //mali       = maliRoom
  //ivorcoas   = ivorcoasRoom
  //liberia    = liberiaRoom
  //sierleon   = sierleonRoom
  west       asExit(guinbiss)
  northwest  asExit(guinbiss)
  north      asExit(senegal)
  northeast  asExit(mali)
  east       asExit(ivorcoas)
  southeast  asExit(ivorcoas)
  south      asExit(liberia)
  southwest  asExit(sierleon)
  ambGuinea  asExit(guinbiss)
  guinea     : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(guinbissRoom, senegalRoom)>>" }
  //north     : NoTravelMessage { "<<ambigCompass(senegalRoom, maliRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(maliRoom, ivorcoasRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(sierleonRoom, liberiaRoom)>>" }
;
sierleonRoom: AfricaRoom 'Sierra Leone'
  capname    = 'Sierra Leone'
  abbr       = 'SL'  // Si
  guinea     = afrPassSierGuin
  liberia    = afrPassSierLibe
  //guinea     = guineaRoom
  //liberia    = liberiaRoom
  northwest  asExit(guinea)
  north      asExit(guinea)
  northeast  asExit(guinea)
  east       asExit(liberia)
  southeast  asExit(liberia)
  ambGuinea  asExit(guinea)
  sierleon   : NoTravelMessage { "<<alreadyInNation()>>" }
;
liberiaRoom: AfricaRoom 'Liberia'
  capname    = 'Liberia'
  abbr       = 'LR'
  sierleon   = afrPassLibeSier
  guinea     = afrPassLibeGuin
  ivorcoas   = afrPassLibeIvor
  //sierleon   = sierleonRoom
  //guinea     = guineaRoom
  //ivorcoas   = ivorcoasRoom
  northwest  asExit(sierleon)
  north      asExit(guinea)
  northeast  asExit(ivorcoas)
  east       asExit(ivorcoas)
  ambGuinea  asExit(guinea)
  liberia    : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(guineaRoom, ivorcoasRoom)>>" }
;
ivorcoasRoom: AfricaRoom 'C\u00F4te d<./s>Ivoire'
  capname    = 'C\u00F4te d<./s>Ivoire'
  abbr       = 'CI'
  liberia    = afrPassIvorLibe
  guinea     = afrPassIvorGuin
  mali       = afrPassIvorMali
  burkfaso   = afrPassIvorBurk
  ghana      = afrPassIvorGhan
  //liberia    = liberiaRoom
  //guinea     = guineaRoom
  //mali       = maliRoom
  //burkfaso   = burkfasoRoom
  //ghana      = ghanaRoom
  southwest  asExit(liberia)
  west       asExit(liberia)
  northwest  asExit(guinea)
  north      asExit(mali)
  northeast  asExit(burkfaso)
  east       asExit(ghana)
  ambGuinea  asExit(guinea)
  ivorcoas   : NoTravelMessage { "<<alreadyInNation()>>" }
  //west      : NoTravelMessage { "<<ambigCompass(guineaRoom, liberiaRoom)>>" }
  //north     : NoTravelMessage { "<<ambigCompass(maliRoom, burkfasoRoom)>>" }
;
burkfasoRoom: AfricaRoom 'Burkina Faso'
  capname    = 'Burkina Faso'
  abbr       = 'BF'
  ivorcoas   = afrPassBurkIvor
  mali       = afrPassBurkMali
  niger      = afrPassBurkNige
  benin      = afrPassBurkBeni
  togo       = afrPassBurkTogo
  ghana      = afrPassBurkGhan
  //ivorcoas   = ivorcoasRoom
  //mali       = maliRoom
  //niger      = nigerRoom
  //benin      = beninRoom
  //togo       = togoRoom
  //ghana      = ghanaRoom
  west       asExit(mali)
  northwest  asExit(mali)
  north      asExit(mali)
  northeast  asExit(niger)
  east       asExit(niger)
  southeast  asExit(benin)
  south      asExit(ghana)
  southwest  asExit(ivorcoas)
  ne         asExit(niger)
  burkfaso   : NoTravelMessage { "<<alreadyInNation()>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(ghanaRoom, togoRoom, beninRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(ivorcoasRoom, ghanaRoom,
  //                                              togoRoom, beninRoom)>>" }
;
ghanaRoom: AfricaRoom 'Ghana'
  capname    = 'Ghana'
  abbr       = 'GH'
  ivorcoas   = afrPassGhanIvor
  burkfaso   = afrPassGhanBurk
  togo       = afrPassGhanTogo
  //ivorcoas   = ivorcoasRoom
  //burkfaso   = burkfasoRoom
  //togo       = togoRoom
  west       asExit(ivorcoas)
  northwest  asExit(burkfaso)
  north      asExit(burkfaso)
  northeast  asExit(togo)
  east       asExit(togo)
  ghana      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(ivorcoasRoom, burkfasoRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(burkfasoRoom, togoRoom)>>" }
;
togoRoom: AfricaRoom 'Togo'
  capname    = 'Togo'
  abbr       = 'TG'
  ghana      = afrPassTogoGhan
  burkfaso   = afrPassTogoBurk
  benin      = afrPassTogoBeni
  //ghana      = ghanaRoom
  //burkfaso   = burkfasoRoom
  //benin      = beninRoom
  west       asExit(ghana)
  northwest  asExit(ghana)
  north      asExit(burkfaso)
  northeast  asExit(benin)
  east       asExit(benin)
  togo       : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(ghanaRoom, burkfasoRoom)>>" }
;
beninRoom: AfricaRoom 'Benin'
  capname    = 'Benin'
  abbr       = 'BJ'
  togo       = afrPassBeniTogo
  burkfaso   = afrPassBeniBurk
  niger      = afrPassBeniNige
  nigeria    = afrPassBeniNiri
  //togo       = togoRoom
  //burkfaso   = burkfasoRoom
  //niger      = nigerRoom
  //nigeria    = nigeriaRoom
  west       asExit(togo)
  northwest  asExit(burkfaso)
  north      asExit(niger)
  northeast  asExit(nigeria)
  east       asExit(nigeria)
  ne         asExit(niger)
  benin      : NoTravelMessage { "<<alreadyInNation()>>" }
;
nigeriaRoom: AfricaRoom 'Nigeria'
  capname    = 'Nigeria'
  abbr       = 'NG'
  benin      = afrPassNiriBeni
  niger      = afrPassNiriNige
  chad       = afrPassNiriChad
  cameroon   = afrPassNiriCame
  //benin      = beninRoom
  //niger      = nigerRoom
  //chad       = chadRoom
  //cameroon   = cameroonRoom
  west       asExit(benin)
  northwest  asExit(niger)
  north      asExit(niger)
  northeast  asExit(chad)
  east       asExit(cameroon)
  southeast  asExit(cameroon)
  south      asExit(cameroon)
  ne         asExit(niger)
  nigeria    : NoTravelMessage { "<<alreadyInNation()>>" }
;
cameroonRoom: AfricaRoom 'Cameroon'
  capname    = 'Cameroon'
  abbr       = 'CM'
  nigeria    = afrPassCameNiri
  chad       = afrPassCameChad
  centafri   = afrPassCameCent
  congo      = afrPassCameCong
  gabon      = afrPassCameGabo
  equaguin   = afrPassCameEqua
  //nigeria    = nigeriaRoom
  //chad       = chadRoom
  //centafri   = centafriRoom
  //congo      = congoRoom
  //gabon      = gabonRoom
  //equaguin   = equaguinRoom
  west       asExit(nigeria)
  northwest  asExit(nigeria)
  north      asExit(nigeria)
  northeast  asExit(chad)
  east       asExit(centafri)
  southeast  asExit(congo)
  south      asExit(gabon)
  southwest  asExit(equaguin)
  ambGuinea  asExit(equaguin)
  ambCongo   asExit(congo)
  ambRepub   asExit(centafri)
  cameroon   : NoTravelMessage { "<<alreadyInNation()>>" }
  //east      : NoTravelMessage { "<<ambigCompass(chadRoom, centafriRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(equaguinRoom, gabonRoom, congoRoom)>>" }
;
equaguinRoom: AfricaRoom 'Equatorial Guinea'
  capname    = 'Equatorial Guinea'
  abbr       = 'GQ'
  cameroon   = afrPassEquaCame
  gabon      = afrPassEquaGabo
  //cameroon   = cameroonRoom
  //gabon      = gabonRoom
  north      asExit(cameroon)
  northeast  asExit(cameroon)
  east       asExit(gabon)
  southeast  asExit(gabon)
  south      asExit(gabon)
  equaguin   : NoTravelMessage { "<<alreadyInNation()>>" }
  ambGuinea  : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(cameroonRoom, gabonRoom)>>" }
;
gabonRoom: AfricaRoom 'Gabon'
  capname    = 'Gabon'
  abbr       = 'GA'
  equaguin   = afrPassGaboEqua
  cameroon   = afrPassGaboCame
  congo      = afrPassGaboCong
  //equaguin   = equaguinRoom
  //cameroon   = cameroonRoom
  //congo      = congoRoom
  northwest  asExit(equaguin)
  north      asExit(cameroon)
  northeast  asExit(cameroon)
  east       asExit(congo)
  southeast  asExit(congo)
  south      asExit(congo)
  ambGuinea  asExit(equaguin)
  ambCongo   asExit(congo)
  gabon      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(cameroonRoom, gabonRoom)>>" }
;
congoRoom: AfricaRoom 'Congo'
  capname    = 'Congo'
  abbr       = 'CG'
  gabon      = afrPassCongGabo
  cameroon   = afrPassCongCame
  centafri   = afrPassCongCent
  demorepu   = afrPassCongDemo
  //gabon      = gabonRoom
  //cameroon   = cameroonRoom
  //centafri   = centafriRoom
  //demorepu   = demorepuRoom
  west       asExit(gabon)
  northwest  asExit(gabon)
  north      asExit(cameroon)
  northeast  asExit(centafri)
  east       asExit(demorepu)
  southeast  asExit(demorepu)
  south      asExit(demorepu)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(centafri)
  congo      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(gabonRoom, cameroonRoom)>>" }
  //north     : NoTravelMessage { "<<ambigCompass(cameroonRoom, centafriRoom)>>" }
;
centafriRoom: AfricaRoom 'Central African Republic'
  capname    = 'Central African Republic'
  abbr       = 'CF'
  cameroon   = afrPassCentCame
  chad       = afrPassCentChad
  sudan      = afrPassCentSuda
  demorepu   = afrPassCentDemo
  congo      = afrPassCentCong
  //cameroon   = cameroonRoom
  //chad       = chadRoom
  //sudan      = sudanRoom
  //demorepu   = demorepuRoom
  //congo      = congoRoom
  west       asExit(cameroon)
  northwest  asExit(chad)
  north      asExit(chad)
  northeast  asExit(sudan)
  east       asExit(sudan)
  southeast  asExit(demorepu)
  south      asExit(demorepu)
  southwest  asExit(congo)
  ambCongo   asExit(congo)
  ambRepub   asExit(demorepu)
  centafri   : NoTravelMessage { "<<alreadyInNation()>>" }
;
demorepuRoom: AfricaRoom 'Democratic Republic of the Congo'
  capname    = 'Democratic Republic of the Congo'
  abbr       = 'ZR'
  congo      = afrPassDemoCong
  centafri   = afrPassDemoCent
  sudan      = afrPassDemoSuda
  uganda     = afrPassDemoUgan
  rwanda     = afrPassDemoRwan
  burundi    = afrPassDemoBuru
  tanzania   = afrPassDemoTanz
  zambia     = afrPassDemoZamb
  angola     = afrPassDemoAngo
  //congo      = congoRoom
  //centafri   = centafriRoom
  //sudan      = sudanRoom
  //uganda     = ugandaRoom
  //rwanda     = rwandaRoom
  //burundi    = burundiRoom
  //tanzania   = tanzaniaRoom
  //zambia     = zambiaRoom
  //angola     = angolaRoom
  west       asExit(congo)
  northwest  asExit(centafri)
  north      asExit(centafri)
  northeast  asExit(sudan)
  east       asExit(tanzania)
  southeast  asExit(zambia)
  south      asExit(angola)
  southwest  asExit(angola)
  ambCongo   asExit(congo)
  ambRepub   asExit(centafri)
  demorepu   : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(congoRoom, centafriRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(sudanRoom, ugandaRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(ugandaRoom, rwandaRoom,
  //                                              burundiRoom, tanzaniaRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(angolaRoom, zambiaRoom)>>" }
;
ugandaRoom: AfricaRoom 'Uganda'
  capname    = 'Uganda'
  abbr       = 'UG'
  demorepu   = afrPassUganDemo
  sudan      = afrPassUganSuda
  kenya      = afrPassUganKeny
  tanzania   = afrPassUganTanz
  rwanda     = afrPassUganRwan
  //demorepu   = demorepuRoom
  //sudan      = sudanRoom
  //kenya      = kenyaRoom
  //tanzania   = tanzaniaRoom
  //rwanda     = rwandaRoom
  west       asExit(demorepu)
  northwest  asExit(sudan)
  north      asExit(sudan)
  northeast  asExit(sudan)
  east       asExit(kenya)
  southeast  asExit(tanzania)
  south      asExit(rwanda)
  southwest  asExit(rwanda)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  uganda     : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(demorepuRoom, sudanRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(sudanRoom, kenyaRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(rwandaRoom, kenyaRoom)>>" }
;
kenyaRoom: AfricaRoom 'Kenya'
  capname    = 'Kenya'
  abbr       = 'KE'
  tanzania   = afrPassKenyTanz
  uganda     = afrPassKenyUgan
  sudan      = afrPassKenySuda
  ethiopia   = afrPassKenyEthi
  somalia    = afrPassKenySoma
  //tanzania   = tanzaniaRoom
  //uganda     = ugandaRoom
  //sudan      = sudanRoom
  //ethiopia   = ethiopiaRoom
  //somalia    = somaliaRoom
  south      asExit(tanzania)
  southwest  asExit(tanzania)
  west       asExit(uganda)
  northwest  asExit(sudan)
  north      asExit(ethiopia)
  northeast  asExit(ethiopia)
  east       asExit(somalia)
  kenya      : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(ethiopiaRoom, somaliaRoom)>>" }
;
rwandaRoom: AfricaRoom 'Rwanda'
  capname    = 'Rwanda'
  abbr       = 'RW'
  uganda     = afrPassRwanUgan
  tanzania   = afrPassRwanTanz
  burundi    = afrPassRwanBuru
  demorepu   = afrPassRwanDemo
  //uganda     = ugandaRoom
  //tanzania   = tanzaniaRoom
  //burundi    = burundiRoom
  //demorepu   = demorepuRoom
  west       asExit(demorepu)
  northwest  asExit(demorepu)
  north      asExit(uganda)
  northeast  asExit(uganda)
  east       asExit(tanzania)
  southeast  asExit(tanzania)
  south      asExit(burundi)
  southwest  asExit(demorepu)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  rwanda     : NoTravelMessage { "<<alreadyInNation()>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(demorepuRoom, ugandaRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(ugandaRoom, tanzaniaRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(burundiRoom, tanzaniaRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(demorepuRoom, burundiRoom)>>" }
;
burundiRoom: AfricaRoom 'Burundi'
  capname    = 'Burundi'
  abbr       = 'BI'
  rwanda     = afrPassBuruRwan
  tanzania   = afrPassBuruTanz
  demorepu   = afrPassBuruDemo
  //rwanda     = rwandaRoom
  //tanzania   = tanzaniaRoom
  //demorepu   = demorepuRoom
  north      asExit(rwanda)
  northeast  asExit(rwanda)
  east       asExit(tanzania)
  southeast  asExit(tanzania)
  south      asExit(tanzania)
  southwest  asExit(demorepu)
  west       asExit(demorepu)
  northwest  asExit(demorepu)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  burundi    : NoTravelMessage { "<<alreadyInNation()>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(rwandaRoom, tanzaniaRoom)>>" }
;
tanzaniaRoom: AfricaRoom 'Tanzania'
  capname    = 'Tanzania'
  abbr       = 'TZ'
  kenya      = afrPassTanzKeny
  uganda     = afrPassTanzUgan
  rwanda     = afrPassTanzRwan
  burundi    = afrPassTanzBuru
  demorepu   = afrPassTanzDemo
  zambia     = afrPassTanzZamb
  malawi     = afrPassTanzMala
  mozambique = afrPassTanzMoza
  //kenya      = kenyaRoom
  //uganda     = ugandaRoom
  //rwanda     = rwandaRoom
  //burundi    = burundiRoom
  //demorepu   = demorepuRoom
  //zambia     = zambiaRoom
  //malawi     = malawiRoom
  //mozambique = mozambiqueRoom
  northeast  asExit(kenya)
  north      asExit(uganda)
  northwest  asExit(burundi)
  west       asExit(demorepu)
  southwest  asExit(zambia)
  south      asExit(malawi)
  southeast  asExit(mozambique)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  tanzania   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(ugandaRoom, kenyaRoom)>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(ugandaRoom, rwandaRoom, burundiRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(zambiaRoom, malawiRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(malawiRoom, mozambiqueRoom)>>" }
;
angolaRoom: AfricaRoom 'Angola'
  capname    = 'Angola'
  abbr       = 'AO'
  demorepu   = afrPassAngoDemo
  zambia     = afrPassAngoZamb
  namibia    = afrPassAngoNami
  //demorepu   = demorepuRoom
  //zambia     = zambiaRoom
  //namibia    = namibiaRoom
  north      asExit(demorepu)
  northeast  asExit(demorepu)
  east       asExit(zambia)
  southeast  asExit(namibia)
  south      asExit(namibia)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  angola     : NoTravelMessage { "<<alreadyInNation()>>" }
;
zambiaRoom: AfricaRoom 'Zambia'
  capname    = 'Zambia'
  abbr       = 'ZM'
  namibia    = afrPassZambNami
  angola     = afrPassZambAngo
  demorepu   = afrPassZambDemo
  tanzania   = afrPassZambTanz
  malawi     = afrPassZambMala
  mozambique = afrPassZambMoza
  zimbabwe   = afrPassZambZimb
  botswana   = afrPassZambBots
  //namibia    = namibiaRoom
  //angola     = angolaRoom
  //demorepu   = demorepuRoom
  //tanzania   = tanzaniaRoom
  //malawi     = malawiRoom
  //mozambique = mozambiqueRoom
  //zimbabwe   = zimbabweRoom
  //botswana   = botswanaRoom
  west       asExit(angola)
  northwest  asExit(demorepu)
  north      asExit(demorepu)
  northeast  asExit(tanzania)
  east       asExit(malawi)
  southeast  asExit(mozambique)
  south      asExit(zimbabwe)
  southwest  asExit(namibia)
  ambCongo   asExit(demorepu)
  ambRepub   asExit(demorepu)
  zambia     : NoTravelMessage { "<<alreadyInNation()>>" }
  //east      : NoTravelMessage { "<<ambigCompass(malawiRoom, mozambiqueRoom)>>" }
  //southeast : NoTravelMessage { "<<ambigCompass(mozambiqueRoom, zimbabweRoom)>>" }
  //south     : NoTravelMessage { "<<ambigCompass(botswanaRoom, zimbabweRoom)>>" }
;
malawiRoom: AfricaRoom 'Malawi'
  capname    = 'Malawi'
  abbr       = 'MW'
  tanzania   = afrPassMalaTanz
  mozambique = afrPassMalaMoza
  zambia     = afrPassMalaZamb
  //tanzania   = tanzaniaRoom
  //mozambique = mozambiqueRoom
  //zambia     = zambiaRoom
  west       asExit(zambia)
  northwest  asExit(zambia)
  north      asExit(tanzania)
  northeast  asExit(tanzania)
  east       asExit(mozambique)
  southeast  asExit(mozambique)
  south      asExit(mozambique)
  southwest  asExit(mozambique)
  malawi     : NoTravelMessage { "<<alreadyInNation()>>" }
;
mozambiqueRoom: AfricaRoom 'Mozambique'
  capname    = 'Mozambique'
  abbr       = 'MZ'
  tanzania   = afrPassMozaTanz
  malawi     = afrPassMozaMala
  zambia     = afrPassMozaZamb
  zimbabwe   = afrPassMozaZimb
  soutafri   = afrPassMozaSout
  swaziland  = afrPassMozaSwaz
  //tanzania   = tanzaniaRoom
  //malawi     = malawiRoom
  //zambia     = zambiaRoom
  //zimbabwe   = zimbabweRoom
  //soutafri   = soutafriRoom
  //swaziland  = swazilandRoom
  northeast  asExit(tanzania)
  north      asExit(malawi)
  northwest  asExit(zambia)
  west       asExit(zimbabwe)
  southwest  asExit(soutafri)
  south      asExit(soutafri)
  ambAfrica  asExit(soutafri)
  mozambique : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(malawiRoom, tanzaniaRoom)>>" }
  //northwest : NoTravelMessage { "<<ambigCompass(zambiaRoom, malawiRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(soutafriRoom, swazilandRoom)>>" }
;
namibiaRoom: AfricaRoom 'Namibia'
  capname    = 'Namibia'
  abbr       = 'NA'
  angola     = afrPassNamiAngo
  zambia     = afrPassNamiZamb
  botswana   = afrPassNamiBots
  soutafri   = afrPassNamiSout
  //angola     = angolaRoom
  //zambia     = zambiaRoom
  //botswana   = botswanaRoom
  //soutafri   = soutafriRoom
  north      asExit(angola)
  northeast  asExit(zambia)
  east       asExit(botswana)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  ambAfrica  asExit(soutafri)
  namibia    : NoTravelMessage { "<<alreadyInNation()>>" }
;
botswanaRoom: AfricaRoom 'Botswana'
  capname    = 'Botswana'
  abbr       = 'BW'
  namibia    = afrPassBotsNami
  zambia     = afrPassBotsZamb
  zimbabwe   = afrPassBotsZimb
  soutafri   = afrPassBotsSout
  //namibia    = namibiaRoom
  //zambia     = zambiaRoom
  //zimbabwe   = zimbabweRoom
  //soutafri   = soutafriRoom
  west       asExit(namibia)
  northwest  asExit(namibia)
  north      asExit(zambia)
  northeast  asExit(zimbabwe)
  east       asExit(zimbabwe)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  southwest  asExit(soutafri)
  ambAfrica  asExit(soutafri)
  botswana   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(namibiaRoom, zambiaRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(zimbabweRoom, soutafriRoom)>>" }
  //southwest : NoTravelMessage { "<<ambigCompass(namibiaRoom, soutafriRoom)>>" }
;
zimbabweRoom: AfricaRoom 'Zimbabwe'
  capname    = 'Zimbabwe'
  abbr       = 'ZW'
  zambia     = afrPassZimbZamb
  mozambique = afrPassZimbMoza
  soutafri   = afrPassZimbSout
  botswana   = afrPassZimbBots
  //zambia     = zambiaRoom
  //mozambique = mozambiqueRoom
  //soutafri   = soutafriRoom
  //botswana   = botswanaRoom
  northwest  asExit(zambia)
  north      asExit(zambia)
  northeast  asExit(mozambique)
  east       asExit(mozambique)
  southeast  asExit(mozambique)
  south      asExit(soutafri)
  southwest  asExit(botswana)
  west       asExit(botswana)
  ambAfrica  asExit(soutafri)
  zimbabwe   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(zambiaRoom, mozambiqueRoom)>>" }
;
swazilandRoom: AfricaRoom 'Swaziland'
  capname    = 'Swaziland'
  abbr       = 'SZ'
  soutafri   = afrPassSwazSout
  mozambique = afrPassSwazMoza
  //soutafri   = soutafriRoom
  //mozambique = mozambiqueRoom
  northeast  asExit(mozambique)
  east       asExit(mozambique)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  southwest  asExit(soutafri)
  west       asExit(soutafri)
  northwest  asExit(soutafri)
  north      asExit(soutafri)
  ambAfrica  asExit(soutafri)
  swaziland  : NoTravelMessage { "<<alreadyInNation()>>" }
;
soutafriRoom: AfricaRoom 'South Africa'
  capname    = 'South Africa'
  abbr       = 'ZA'
  namibia    = afrPassSoutNami
  botswana   = afrPassSoutBots
  zimbabwe   = afrPassSoutZimb
  mozambique = afrPassSoutMoza
  swaziland  = afrPassSoutSwaz
  lesotho    = afrPassSoutLeso
  //namibia    = namibiaRoom
  //botswana   = botswanaRoom
  //zimbabwe   = zimbabweRoom
  //mozambique = mozambiqueRoom
  //swaziland  = swazilandRoom
  //lesotho    = lesothoRoom
  northwest  asExit(namibia)
  north      asExit(botswana)
  northeast  asExit(mozambique)
  east       asExit(swaziland)
  southeast  asExit(lesotho)
  in         asExit(lesotho)
  ambAfrica  : NoTravelMessage { "<<alreadyInNation()>>" }
  soutafri   : NoTravelMessage { "<<alreadyInNation()>>" }
  //north     : NoTravelMessage { "<<ambigCompass(namibiaRoom, botswanaRoom,
  //                                              zimbabweRoom)>>" }
  //northeast : NoTravelMessage { "<<ambigCompass(zimbabweRoom, mozambiqueRoom,
  //                                              swazilandRoom, lesothoRoom)>>" }
  //east      : NoTravelMessage { "<<ambigCompass(mozambiqueRoom, swazilandRoom,
  //                                              lesothoRoom)>>" }
;
lesothoRoom: AfricaRoom 'Lesotho'
  capname    = 'Lesotho'
  abbr       = 'LS'
  soutafri   = afrPassLesoSout
  //soutafri   = soutafriRoom
  north      asExit(soutafri)
  northeast  asExit(soutafri)
  east       asExit(soutafri)
  southeast  asExit(soutafri)
  south      asExit(soutafri)
  southwest  asExit(soutafri)
  west       asExit(soutafri)
  northwest  asExit(soutafri)
  out        asExit(soutafri)
  ambAfrica  asExit(soutafri)
  lesotho     : NoTravelMessage { "<<alreadyInNation()>>" }
;
*/


































































// -------------------------------------------------------------------
// NATION MAZES: ROOMS: MEXICO ROOMS
// -------------------------------------------------------------------

bajasurRoom: MexicanRoom
  vocabWords = '(baja) (california) sur bs'
  name       = 'Baja California Sur'
  capname    = 'Baja California Sur'
  abbr       = 'BS'
  mainDesc =
    "This is the southern tip of Mexico<./s>s Baja California 
      peninsula, bounded on the east by the Gulf of California, 
      and on the west by the Pacific Ocean. "
  bajacali   = mexPassBasuBaca
  northwest  asExit(bajacali)
  north      asExit(bajacali)
  bajasur    : NoTravelMessage { "<<alreadyInNation()>>" }
;
bajacaliRoom: MexicanRoom
  vocabWords = 'baja california bc'
  name       = 'Baja California'
  capname    = 'Baja California'
  abbr       = 'BC'
  mainDesc =
    "This is the northern part of the Baja California peninsula. 
      The peninsula continues to the south, while the rest of Mexico 
      lies to the east. "
  bajasur    = mexPassBacaBasu
  sonora     = mexPassBacaSono
  south      asExit(bajasur)
  southeast  asExit(bajasur)
  east       asExit(sonora)
  northeast  asExit(sonora)
  bajacali   : NoTravelMessage { "<<alreadyInNation()>>" }
;
sonoraRoom: MexicanRoom
  vocabWords = 'sonora so'
  name       = 'Sonora'
  capname    = 'Sonora'
  abbr       = 'SO'
  mainDesc =
    "This is an area along the Gulf of California, filled with 
      the mountains of the Sierra Madre Occidental. "
  bajacali   = mexPassSonoBaca
  chihuahua  = mexPassSonoChih
  sinaloa    = mexPassSonoSina
  west       asExit(bajacali)
  northwest  asExit(bajacali)
  east       asExit(chihuahua)
  south      asExit(sinaloa)
  southeast  asExit(sinaloa)
  sonora     : NoTravelMessage { "<<alreadyInNation()>>" }
;
chihuahuaRoom: MexicanRoom
  vocabWords = 'chihuahua ch'
  name       = 'Chihuahua'
  capname    = 'Chihuahua'
  abbr       = 'CH'
  mainDesc =
    "A huge desert fills this region, with the Sierra Madre
      Occidental lying to the west. "
  sonora     = mexPassChihSono
  sinaloa    = mexPassChihSina
  durango    = mexPassChihDura
  coahuila   = mexPassChihCoah
  northwest  asExit(sonora)
  west       asExit(sonora)
  southwest  asExit(sinaloa)
  south      asExit(durango)
  southeast  asExit(durango)
  east       asExit(coahuila)
  chihuahua  : NoTravelMessage { "<<alreadyInNation()>>" }
;
coahuilaRoom: MexicanRoom
  vocabWords = 'coahuila co'
  name       = 'Coahuila'
  capname    = 'Coahuila'
  abbr       = 'CO'
  mainDesc =
    "The Sierra Madre Oriental run through the eastern part
      of this area, with rugged desert to the west. "
  chihuahua  = mexPassCoahChih
  durango    = mexPassCoahDura
  zacatecas  = mexPassCoahZaca
  nuevoleon  = mexPassCoahNuev
  northwest  asExit(chihuahua)
  west       asExit(chihuahua)
  southwest  asExit(durango)
  south      asExit(zacatecas)
  southeast  asExit(nuevoleon)
  east       asExit(nuevoleon)
  coahuila   : NoTravelMessage { "<<alreadyInNation()>>" }
;
nuevoleonRoom: MexicanRoom
  vocabWords = '(nuevo) leon le\u00F3n nl'
  name       = 'Nuevo Le\u00F3n'
  capname    = 'Nuevo Le\u00F3n'
  abbr       = 'NL'
  mainDesc =
    "This area is taken up by the mountains of the 
      Sierra Madre Oriental. "
  coahuila   = mexPassNuevCoah
  sanluis    = mexPassNuevSanl
  tamaulipas = mexPassNuevTama
  northwest  asExit(coahuila)
  west       asExit(coahuila)
  southwest  asExit(sanluis)
  south      asExit(sanluis)
  southeast  asExit(tamaulipas)
  east       asExit(tamaulipas)
  northeast  asExit(tamaulipas)
  nuevoleon  : NoTravelMessage { "<<alreadyInNation()>>" }
;
tamaulipasRoom: MexicanRoom
  vocabWords = 'tamaulipas tm'
  name       = 'Tamaulipas'
  capname    = 'Tamaulipas'
  abbr       = 'TM'
  mainDesc =
    "This area runs along the Gulf of Mexico to the east,
      and the Rio Grande River to the north. "
  nuevoleon  = mexPassTamaNuev
  sanluis    = mexPassTamaSanl
  veracruz   = mexPassTamaVera
  northwest  asExit(nuevoleon)
  west       asExit(nuevoleon)
  southwest  asExit(sanluis)
  south      asExit(veracruz)
  southeast  asExit(veracruz)
  tamaulipas : NoTravelMessage { "<<alreadyInNation()>>" }
;
sinaloaRoom: MexicanRoom
  vocabWords = 'sinaloa si'
  name       = 'Sinaloa'
  capname    = 'Sinaloa'
  abbr       = 'SI'
  mainDesc =
    "This is a long, narrow region running along the Pacific coast. "
  sonora     = mexPassSinaSono
  chihuahua  = mexPassSinaChih
  durango    = mexPassSinaDura
  nayarit    = mexPassSinaNaya
  northwest  asExit(sonora)
  north      asExit(sonora)
  northeast  asExit(chihuahua)
  east       asExit(durango)
  southeast  asExit(nayarit)
  south      asExit(nayarit)
  sinaloa    : NoTravelMessage { "<<alreadyInNation()>>" }
;
durangoRoom: MexicanRoom
  vocabWords = 'durango dr'
  name       = 'Durango'
  capname    = 'Durango'
  abbr       = 'DR'
  mainDesc =
    "Mountains and dry plains run through here. "
  sinaloa    = mexPassDuraSina
  chihuahua  = mexPassDuraChih
  coahuila   = mexPassDuraCoah
  zacatecas  = mexPassDuraZaca
  nayarit    = mexPassDuraNaya
  northwest  asExit(chihuahua)
  north      asExit(chihuahua)
  northeast  asExit(coahuila)
  east       asExit(zacatecas)
  southeast  asExit(zacatecas)
  south      asExit(nayarit)
  southwest  asExit(sinaloa)
  west       asExit(sinaloa)
  durango    : NoTravelMessage { "<<alreadyInNation()>>" }
;
zacatecasRoom: MexicanRoom
  vocabWords = 'zacatecas zc'
  name       = 'Zacatecas'
  capname    = 'Zacatecas'
  abbr       = 'ZC'
  mainDesc =
    "This is an area of dry plains and mountains, 
      lying on a large plateau. "
  sanluis    = mexPassZacaSanl
  jalisco    = mexPassZacaJali
  aguascal   = mexPassZacaAgua
  nayarit    = mexPassZacaNaya
  durango    = mexPassZacaDura
  coahuila   = mexPassZacaCoah
  northeast  asExit(coahuila)
  east       asExit(sanluis)
  southeast  asExit(jalisco)
  south      asExit(aguascal)
  southwest  asExit(jalisco)
  west       asExit(nayarit)
  northwest  asExit(durango)
  north      asExit(durango)
  zacatecas  : NoTravelMessage { "<<alreadyInNation()>>" }
;
sanluisRoom: MexicanRoom
  vocabWords = '(san) luis potos\u00ED potosi sl'
  name       = 'San Luis Potos\u00ED'
  capname    = 'San Luis Potos\u00ED'
  abbr       = 'SL'
  mainDesc =
    "This area is filled with a large plateau, plus a few mountains. "
  nuevoleon  = mexPassSanlNuev
  tamaulipas = mexPassSanlTama
  veracruz   = mexPassSanlVera
  hidalgo    = mexPassSanlHida
  queretaro  = mexPassSanlQuer
  guanajuato = mexPassSanlGuan
  jalisco    = mexPassSanlJali
  zacatecas  = mexPassSanlZaca
  north      asExit(nuevoleon)
  northeast  asExit(tamaulipas)
  east       asExit(veracruz)
  southeast  asExit(hidalgo)
  south      asExit(guanajuato)
  southwest  asExit(jalisco)
  west       asExit(zacatecas)
  northwest  asExit(zacatecas)
  sanluis    : NoTravelMessage { "<<alreadyInNation()>>" }
;
nayaritRoom: MexicanRoom
  vocabWords = 'nayarit ny'
  name       = 'Nayarit'
  capname    = 'Nayarit'
  abbr       = 'NY'
  mainDesc =
    "This is a mountainous region on the Pacific coast. "
  sinaloa    = mexPassNayaSina
  durango    = mexPassNayaDura
  zacatecas  = mexPassNayaZaca
  jalisco    = mexPassNayaJali
  northwest  asExit(sinaloa)
  north      asExit(durango)
  northeast  asExit(zacatecas)
  east       asExit(jalisco)
  southeast  asExit(jalisco)
  south      asExit(jalisco)
  nayarit    : NoTravelMessage { "<<alreadyInNation()>>" }
;
jaliscoRoom: MexicanRoom
  vocabWords = 'jalisco jl'
  name       = 'Jalisco'
  capname    = 'Jalisco'
  abbr       = 'JL'
  mainDesc =
    "The mountains of the Sierra Madre Occidental run through here. "
    //"The Sierra Madre Occidental runs through here, 
    //  as well as a few volcanic mountains. "
  nayarit    = mexPassJaliNaya
  zacatecas  = mexPassJaliZaca
  aguascal   = mexPassJaliAgua
  sanluis    = mexPassJaliSanl
  guanajuato = mexPassJaliGuan
  michoacan  = mexPassJaliMich
  colima     = mexPassJaliColi
  west       asExit(nayarit)
  northwest  asExit(nayarit)
  north      asExit(zacatecas)
  northeast  asExit(sanluis)
  east       asExit(guanajuato)
  southeast  asExit(michoacan)
  south      asExit(colima)
  southwest  asExit(colima)
  jalisco    : NoTravelMessage { "<<alreadyInNation()>>" }
;
aguascalRoom: MexicanRoom
  vocabWords = 'aguascalientes ag'
  name       = 'Aguascalientes'
  capname    = 'Aguascalientes'
  abbr       = 'AG'
  mainDesc =
    "This small region contains many hot springs. "
  zacatecas  = mexPassAguaZaca
  jalisco    = mexPassAguaJali
  southwest  asExit(zacatecas)
  west       asExit(zacatecas)
  northwest  asExit(zacatecas)
  north      asExit(zacatecas)
  northeast  asExit(zacatecas)
  east       asExit(jalisco)
  southeast  asExit(jalisco)
  south      asExit(jalisco)
  aguascal   : NoTravelMessage { "<<alreadyInNation()>>" }
;
guanajuatoRoom: MexicanRoom
  vocabWords = 'guanajuato gn'
  name       = 'Guanajuato'
  capname    = 'Guanajuato'
  abbr       = 'GN'
  mainDesc =
    "This is a plateau region directly in the center of Mexico. "
    // once known for its wealthy mines
  jalisco    = mexPassGuanJali
  sanluis    = mexPassGuanSanl
  queretaro  = mexPassGuanQuer
  michoacan  = mexPassGuanMich
  north      asExit(sanluis)
  northeast  asExit(sanluis)
  east       asExit(queretaro)
  southeast  asExit(michoacan)
  south      asExit(michoacan)
  southwest  asExit(michoacan)
  west       asExit(jalisco)
  northwest  asExit(jalisco)
  guanajuato : NoTravelMessage { "<<alreadyInNation()>>" }
;
queretaroRoom: MexicanRoom
  vocabWords = 'quer\u00E9taro queretaro qr'
  name       = 'Quer\u00E9taro'
  capname    = 'Quer\u00E9taro'
  abbr       = 'QR'
  mainDesc =
    "This a small section of plains in central Mexico. "
  sanluis    = mexPassQuerSanl
  hidalgo    = mexPassQuerHida
  mexico     = mexPassQuerMexi
  michoacan  = mexPassQuerMich
  guanajuato = mexPassQuerGuan
  north      asExit(sanluis)
  northeast  asExit(sanluis)
  east       asExit(hidalgo)
  southeast  asExit(mexico)
  south      asExit(michoacan)
  southwest  asExit(michoacan)
  west       asExit(guanajuato)
  northwest  asExit(guanajuato)
  queretaro  : NoTravelMessage { "<<alreadyInNation()>>" }
;
hidalgoRoom: MexicanRoom
  vocabWords = 'hidalgo hd'
  name       = 'Hidalgo'
  capname    = 'Hidalgo'
  abbr       = 'HD'
  mainDesc =
    "This is a mountainous region near the southern end 
      of the Sierra Madre Oriental. "
  veracruz   = mexPassHidaVera
  puebla     = mexPassHidaPueb
  tlaxcala   = mexPassHidaTlax
  mexico     = mexPassHidaMexi
  queretaro  = mexPassHidaQuer
  sanluis    = mexPassHidaSanl
  north      asExit(sanluis)
  northeast  asExit(veracruz)
  east       asExit(puebla)
  southeast  asExit(puebla)
  south      asExit(tlaxcala)
  southwest  asExit(mexico)
  west       asExit(queretaro)
  northwest  asExit(queretaro)
  hidalgo    : NoTravelMessage { "<<alreadyInNation()>>" }
;
colimaRoom: MexicanRoom
  vocabWords = 'colima cl'
  name       = 'Colima'
  capname    = 'Colima'
  abbr       = 'CL'
  mainDesc =
    "This is a small mountainous area on the Pacific coast. "
  jalisco    = mexPassColiJali
  michoacan  = mexPassColiMich
  west       asExit(jalisco)
  northwest  asExit(jalisco)
  north      asExit(jalisco)
  northeast  asExit(jalisco)
  east       asExit(michoacan)
  southeast  asExit(michoacan)
  south      asExit(michoacan)
  colima     : NoTravelMessage { "<<alreadyInNation()>>" }
;
michoacanRoom: MexicanRoom
  vocabWords = 'michoac\u00E1n michoacan mc'
  name       = 'Michoac\u00E1n'
  capname    = 'Michoac\u00E1n'
  abbr       = 'MC'
  mainDesc =
    "The Sierra Madre Occidental come in here from the north,
      while a few volcanic mountains extend to the east. "
  colima     = mexPassMichColi
  jalisco    = mexPassMichJali
  guanajuato = mexPassMichGuan
  queretaro  = mexPassMichQuer
  mexico     = mexPassMichMexi
  guerrero   = mexPassMichGuer
  west       asExit(colima)
  northwest  asExit(jalisco)
  north      asExit(guanajuato)
  northeast  asExit(queretaro)
  east       asExit(mexico)
  southeast  asExit(guerrero)
  south      asExit(guerrero)
  michoacan  : NoTravelMessage { "<<alreadyInNation()>>" }
;
mexicoRoom: MexicanRoom
  vocabWords = 'm\u00E9xico mexico mx'
  name       = 'M\u00E9xico'
  capname    = 'M\u00E9xico'
  abbr       = 'MX'
  mainDesc =
    "This area is taken up by a large valley and a few 
      volcanic mountains. "
  hidalgo    = mexPassMexiHida
  tlaxcala   = mexPassMexiTlax
  puebla     = mexPassMexiPueb
  distrito   = mexPassMexiDist
  morelos    = mexPassMexiMore
  guerrero   = mexPassMexiGuer
  michoacan  = mexPassMexiMich
  queretaro  = mexPassMexiQuer
  west       asExit(michoacan)
  northwest  asExit(queretaro)
  north      asExit(hidalgo)
  northeast  asExit(hidalgo)
  east       asExit(tlaxcala)
  southeast  asExit(puebla)
  south      asExit(distrito)
  southwest  asExit(guerrero)
  in         asExit(distrito)
  mexico     : NoTravelMessage { "<<alreadyInNation()>>" }
;
distritoRoom: MexicanRoom
  vocabWords = 'distrito federal district df'
  name       = 'Distrito Federal'
  capname    = 'Distrito Federal'
  abbr       = 'DF'
  mainDesc =
    "This small area is where the ancient Aztecs built their city 
      of Tenochtitlan, which was later renamed Mexico City. "
  mexico     = mexPassDistMexi
  morelos    = mexPassDistMore
  west       asExit(mexico)
  northwest  asExit(mexico)
  north      asExit(mexico)
  northeast  asExit(mexico)
  east       asExit(mexico)
  southeast  asExit(morelos)
  south      asExit(morelos)
  southwest  asExit(morelos)
  out        asExit(mexico)
  distrito   : NoTravelMessage { "<<alreadyInNation()>>" }
;
morelosRoom: MexicanRoom
  vocabWords = 'morelos mr'
  name       = 'Morelos'
  capname    = 'Morelos'
  abbr       = 'MR'
  mainDesc =
    "This is small region of mountains and forests. "
  distrito   = mexPassMoreDist
  mexico     = mexPassMoreMexi
  puebla     = mexPassMorePueb
  guerrero   = mexPassMoreGuer
  north      asExit(distrito)
  west       asExit(mexico)
  northwest  asExit(mexico)
  northeast  asExit(mexico)
  east       asExit(puebla)
  southeast  asExit(mexico)
  south      asExit(guerrero)
  southwest  asExit(guerrero)
  morelos    : NoTravelMessage { "<<alreadyInNation()>>" }
;
tlaxcalaRoom: MexicanRoom
  vocabWords = 'tlaxcala tl'
  name       = 'Tlaxcala'
  capname    = 'Tlaxcala'
  abbr       = 'TL'
  mainDesc =
    "This small, mountainous region was once home to 
      the ancient independent city-state of Tlaxcala, 
      which resisted the mighty Aztec Empire. "
  hidalgo    = mexPassTlaxHida
  puebla     = mexPassTlaxPueb
  mexico     = mexPassTlaxMexi
  northeast  asExit(puebla)
  east       asExit(puebla)
  southeast  asExit(puebla)
  south      asExit(puebla)
  southwest  asExit(puebla)
  west       asExit(mexico)
  northwest  asExit(hidalgo)
  north      asExit(hidalgo)
  out        asExit(puebla)
  tlaxcala   : NoTravelMessage { "<<alreadyInNation()>>" }
;
pueblaRoom: MexicanRoom
  vocabWords = 'puebla pb'
  name       = 'Puebla'
  capname    = 'Puebla'
  abbr       = 'PB'
  mainDesc =
    "This is one of the most mountainous regions of Mexico, 
      filled with peaks such as Citlalt\u00E9petl, 
      Popocat\u00E9petl, and Iztacc\u00EDhuatl. "
  veracruz   = mexPassPuebVera
  oaxaca     = mexPassPuebOaxa
  guerrero   = mexPassPuebGuer
  morelos    = mexPassPuebMore
  mexico     = mexPassPuebMexi
  tlaxcala   = mexPassPuebTlax
  hidalgo    = mexPassPuebHida
  north      asExit(veracruz)
  northeast  asExit(veracruz)
  east       asExit(veracruz)
  southeast  asExit(oaxaca)
  south      asExit(oaxaca)
  southwest  asExit(guerrero)
  west       asExit(tlaxcala)
  northwest  asExit(hidalgo)
  in         asExit(tlaxcala)
  puebla     : NoTravelMessage { "<<alreadyInNation()>>" }
;
guerreroRoom: MexicanRoom
  vocabWords = 'guerrero gr'
  name       = 'Guerrero'
  capname    = 'Guerrero'
  abbr       = 'GR'
  mainDesc =
    "Most of this area was once controlled by the Aztecs,
      with the notable exception of Acapulco, whose mighty
      fortress held out and remained independent for many years. "
  michoacan  = mexPassGuerMich
  mexico     = mexPassGuerMexi
  morelos    = mexPassGuerMore
  puebla     = mexPassGuerPueb
  oaxaca     = mexPassGuerOaxa
  west       asExit(michoacan)
  northwest  asExit(michoacan)
  north      asExit(mexico)
  northeast  asExit(puebla)
  east       asExit(oaxaca)
  southeast  asExit(oaxaca)
  guerrero   : NoTravelMessage { "<<alreadyInNation()>>" }
;
oaxacaRoom: MexicanRoom
  vocabWords = 'oaxaca ox'
  name       = 'Oaxaca'
  capname    = 'Oaxaca'
  abbr       = 'OX'
  mainDesc =
    "This region is filled with the mountains of the 
      Sierra Madre del Sur, plus a few valleys and plains. "
  guerrero   = mexPassOaxaGuer
  puebla     = mexPassOaxaPueb
  veracruz   = mexPassOaxaVera
  chiapas    = mexPassOaxaChia
  west       asExit(guerrero)
  northwest  asExit(puebla)
  north      asExit(veracruz)
  northeast  asExit(veracruz)
  east       asExit(chiapas)
  southeast  asExit(chiapas)
  oaxaca     : NoTravelMessage { "<<alreadyInNation()>>" }
;
veracruzRoom: MexicanRoom
  vocabWords = 'veracruz vr'
  name       = 'Veracruz'
  capname    = 'Veracruz'
  abbr       = 'VR'
  mainDesc =
    "This is a long, sprawling section of land on the Caribbean coast. "
  tamaulipas = mexPassVeraTama
  sanluis    = mexPassVeraSanl
  hidalgo    = mexPassVeraHida
  puebla     = mexPassVeraPueb
  oaxaca     = mexPassVeraOaxa
  chiapas    = mexPassVeraChia
  tabasco    = mexPassVeraTaba
  north      asExit(tamaulipas)
  northwest  asExit(sanluis)
  west       asExit(hidalgo)
  southwest  asExit(puebla)
  south      asExit(oaxaca)
  southeast  asExit(chiapas)
  east       asExit(tabasco)
  veracruz   : NoTravelMessage { "<<alreadyInNation()>>" }
;
chiapasRoom: MexicanRoom
  vocabWords = 'chiapas cp'
  name       = 'Chiapas'
  capname    = 'Chiapas'
  abbr       = 'CP'
  mainDesc =
    "This is a humid and tropical region, bordering the Pacific Ocean. "
  oaxaca     = mexPassChiaOaxa
  veracruz   = mexPassChiaVera
  tabasco    = mexPassChiaTaba
  west       asExit(oaxaca)
  northwest  asExit(veracruz)
  north      asExit(tabasco)
  northeast  asExit(tabasco)
  chiapas    : NoTravelMessage { "<<alreadyInNation()>>" }
;
tabascoRoom: MexicanRoom
  vocabWords = 'tabasco tb'
  name       = 'Tabasco'
  capname    = 'Tabasco'
  abbr       = 'TB'
  mainDesc =
    "This is a plains region along the shore of the Gulf of Mexico. "
  veracruz   = mexPassTabaVera
  chiapas    = mexPassTabaChia //CP
  campeche   = mexPassTabaCamp //CM
  west       asExit(veracruz)
  southwest  asExit(veracruz)
  south      asExit(chiapas)
  southeast  asExit(chiapas)
  east       asExit(campeche)
  northeast  asExit(campeche)
  north      asExit(campeche)
  tabasco    : NoTravelMessage { "<<alreadyInNation()>>" }
;
campecheRoom: MexicanRoom
  vocabWords = 'campeche cm'
  name       = 'Campeche'
  capname    = 'Campeche'
  abbr       = 'CM'
  mainDesc =
    "The climate is hot and humid on this western side 
      of the Yucat\u00E1n Peninsula. "
  tabasco    = mexPassCampTaba
  yucatan    = mexPassCampYuca
  quintana   = mexPassCampQuin
  south      asExit(tabasco)
  southwest  asExit(tabasco)
  west       asExit(tabasco)
  north      asExit(yucatan)
  northeast  asExit(yucatan)
  east       asExit(quintana)
  southeast  asExit(quintana)
  campeche   : NoTravelMessage { "<<alreadyInNation()>>" }
;
quintanaRoom: MexicanRoom
  vocabWords = 'quintana roo qn'
  name       = 'Quintana Roo'
  capname    = 'Quintana Roo'
  abbr       = 'QN'
  mainDesc =
    "This is the eastern side of the Yucat\u00E1n Peninsula, 
      facing the Caribbean. The ancient Maya had many 
      settlements here, including Canc\u00FAn and Cozumel. "
  campeche   = mexPassQuinCamp
  yucatan    = mexPassQuinYuca
  southwest  asExit(campeche)
  west       asExit(campeche)
  northwest  asExit(yucatan)
  north      asExit(yucatan)
  quintana   : NoTravelMessage { "<<alreadyInNation()>>" }
;
yucatanRoom: MexicanRoom
  vocabWords = 'yucat\u00E1n yucatan yc'
  name       = 'Yucat\u00E1n'
  capname    = 'Yucat\u00E1n'
  abbr       = 'YC'
  mainDesc =
    "This part of the Yucat\u00E1n Peninusla was home 
      to such ancient peoples as the Mayas and the Toltecs, 
      and to such sites as Chich\u00E9n Itz\u00E1 and Uxmal. "
  campeche   = mexPassYucaCamp
  quintana   = mexPassYucaQuin
  west       asExit(campeche)
  southwest  asExit(campeche)
  south      asExit(quintana)
  southeast  asExit(quintana)
  east       asExit(quintana)
  yucatan    : NoTravelMessage { "<<alreadyInNation()>>" }
;

modify aguascalRoom
  borderRooms = [zacatecasRoom, jaliscoRoom]
;
modify bajacaliRoom
  borderRooms = [bajasurRoom, sonoraRoom]
;
modify bajasurRoom
  borderRooms = [bajacaliRoom]
;
modify chihuahuaRoom
  borderRooms = [sonoraRoom, sinaloaRoom, durangoRoom, coahuilaRoom]
;
modify colimaRoom
  borderRooms = [jaliscoRoom, michoacanRoom]
;
modify campecheRoom
  borderRooms = [tabascoRoom, yucatanRoom, quintanaRoom]
;
modify coahuilaRoom
  borderRooms = [chihuahuaRoom, durangoRoom, zacatecasRoom, nuevoleonRoom]
;
modify chiapasRoom
  borderRooms = [oaxacaRoom, veracruzRoom, tabascoRoom]
;
modify distritoRoom
  borderRooms = [mexicoRoom, morelosRoom]
;
modify durangoRoom
  borderRooms = [chihuahuaRoom, coahuilaRoom, zacatecasRoom, nayaritRoom, sinaloaRoom]
;
modify guanajuatoRoom
  borderRooms = [sanluisRoom, queretaroRoom, michoacanRoom, jaliscoRoom]
;
modify guerreroRoom
  borderRooms = [michoacanRoom, mexicoRoom, morelosRoom, pueblaRoom, oaxacaRoom]
;
modify hidalgoRoom
  borderRooms = [sanluisRoom, veracruzRoom, pueblaRoom, tlaxcalaRoom, mexicoRoom, queretaroRoom]
;
modify jaliscoRoom
  borderRooms = [nayaritRoom, zacatecasRoom, aguascalRoom, sanluisRoom, guanajuatoRoom, michoacanRoom, colimaRoom]
;
modify michoacanRoom
  borderRooms = [colimaRoom, jaliscoRoom, guanajuatoRoom, queretaroRoom, mexicoRoom, guerreroRoom]
;
modify morelosRoom
  borderRooms = [mexicoRoom, distritoRoom, pueblaRoom, guerreroRoom]
;
modify mexicoRoom
  borderRooms = [hidalgoRoom, tlaxcalaRoom, pueblaRoom, morelosRoom, distritoRoom, guerreroRoom, michoacanRoom, queretaroRoom]
;
modify nuevoleonRoom
  borderRooms = [coahuilaRoom, sanluisRoom, tamaulipasRoom]
;
modify nayaritRoom
  borderRooms = [sinaloaRoom, durangoRoom, zacatecasRoom, jaliscoRoom]
;
modify oaxacaRoom
  borderRooms = [guerreroRoom, pueblaRoom, veracruzRoom, chiapasRoom]
;
modify pueblaRoom
  borderRooms = [veracruzRoom, oaxacaRoom, guerreroRoom, morelosRoom, mexicoRoom, tlaxcalaRoom, hidalgoRoom]
;
modify quintanaRoom
  borderRooms = [campecheRoom, yucatanRoom]
;
modify queretaroRoom
  borderRooms = [sanluisRoom, hidalgoRoom, mexicoRoom, michoacanRoom, guanajuatoRoom]
;
modify sinaloaRoom
  borderRooms = [sonoraRoom, chihuahuaRoom, durangoRoom, nayaritRoom]
;
modify sanluisRoom
  borderRooms = [nuevoleonRoom, tamaulipasRoom, veracruzRoom, hidalgoRoom, queretaroRoom, guanajuatoRoom, jaliscoRoom, zacatecasRoom]
;
modify sonoraRoom
  borderRooms = [bajacaliRoom, chihuahuaRoom, sinaloaRoom]
;
modify tabascoRoom
  borderRooms = [veracruzRoom, chiapasRoom, campecheRoom]
;
modify tlaxcalaRoom
  borderRooms = [pueblaRoom, mexicoRoom, hidalgoRoom]
;
modify tamaulipasRoom
  borderRooms = [nuevoleonRoom, sanluisRoom, veracruzRoom]
;
modify veracruzRoom
  borderRooms = [tamaulipasRoom, sanluisRoom, hidalgoRoom, pueblaRoom, oaxacaRoom, chiapasRoom, tabascoRoom]
;
modify yucatanRoom
  borderRooms = [campecheRoom, quintanaRoom]
;
modify zacatecasRoom
  borderRooms = [coahuilaRoom, sanluisRoom, jaliscoRoom, aguascalRoom, nayaritRoom, durangoRoom]
;


/*
aguascalRoom: MexicanRoom 'Aguascalientes'
  capname    = 'Aguascalientes'
  abbr       = 'AG'
  desc =
    "This small region contains many hot springs. "
  zacatecas  = mexPassAguaZaca
  jalisco    = mexPassAguaJali
  southwest  asExit(zacatecas)
  west       asExit(zacatecas)
  northwest  asExit(zacatecas)
  north      asExit(zacatecas)
  northeast  asExit(zacatecas)
  east       asExit(jalisco)
  southeast  asExit(jalisco)
  south      asExit(jalisco)
  aguascal   : NoTravelMessage { "<<alreadyInNation()>>" }
;
bajacaliRoom: MexicanRoom 'Baja California'
  capname    = 'Baja California'
  abbr       = 'BC'
  desc =
    "This is the northern part of the Baja California peninsula. 
      The peninsula continues to the south, while the rest of Mexico 
      lies to the east. "
  bajasur    = mexPassBacaBasu
  sonora     = mexPassBacaSono
  south      asExit(bajasur)
  southeast  asExit(bajasur)
  east       asExit(sonora)
  northeast  asExit(sonora)
  bajacali   : NoTravelMessage { "<<alreadyInNation()>>" }
;
bajasurRoom: MexicanRoom 'Baja California Sur'
  capname    = 'Baja California Sur'
  abbr       = 'BS'
  desc =
    "This is the southern tip of Mexico<./s>s Baja California 
      peninsula, bounded on the east by the Gulf of California, 
      and on the west by the Pacific Ocean. "
  bajacali   = mexPassBasuBaca
  northwest  asExit(bajacali)
  north      asExit(bajacali)
  bajasur    : NoTravelMessage { "<<alreadyInNation()>>" }
;
chihuahuaRoom: MexicanRoom 'Chihuahua'
  capname    = 'Chihuahua'
  abbr       = 'CH'
  desc =
    "The Sierra Madre Occidental mountains are here to the west, 
      while a huge desert region extends to the east. "
  sonora     = mexPassChihSono
  sinaloa    = mexPassChihSina
  durango    = mexPassChihDura
  coahuila   = mexPassChihCoah
  northwest  asExit(sonora)
  west       asExit(sonora)
  southwest  asExit(sinaloa)
  south      asExit(durango)
  southeast  asExit(durango)
  east       asExit(coahuila)
  chihuahua  : NoTravelMessage { "<<alreadyInNation()>>" }
;
colimaRoom: MexicanRoom 'Colima'
  capname    = 'Colima'
  abbr       = 'CL'
  desc =
    "This is a small area on the Pacific coast. "
  jalisco    = mexPassColiJali
  michoacan  = mexPassColiMich
  west       asExit(jalisco)
  northwest  asExit(jalisco)
  north      asExit(jalisco)
  northeast  asExit(jalisco)
  east       asExit(michoacan)
  southeast  asExit(michoacan)
  south      asExit(michoacan)
  colima     : NoTravelMessage { "<<alreadyInNation()>>" }
;
campecheRoom: MexicanRoom 'Campeche'
  capname    = 'Campeche'
  abbr       = 'CM'
  desc =
    "The climate is hot and humid on this western side 
      of the Yucat\u00E1n Peninsula. "
  tabasco    = mexPassCampTaba
  yucatan    = mexPassCampYuca
  quintana   = mexPassCampQuin
  south      asExit(tabasco)
  southwest  asExit(tabasco)
  west       asExit(tabasco)
  north      asExit(yucatan)
  northeast  asExit(yucatan)
  east       asExit(quintana)
  southeast  asExit(quintana)
  campeche   : NoTravelMessage { "<<alreadyInNation()>>" }
;
coahuilaRoom: MexicanRoom 'Coahuila'
  capname    = 'Coahuila'
  abbr       = 'CO'
  desc =
    "Rugged desert lies in the west here, while the 
      Sierra Madre Oriental runs through to the east. "
  chihuahua  = mexPassCoahChih
  durango    = mexPassCoahDura
  zacatecas  = mexPassCoahZaca
  nuevoleon  = mexPassCoahNuev
  northwest  asExit(chihuahua)
  west       asExit(chihuahua)
  southwest  asExit(durango)
  south      asExit(zacatecas)
  southeast  asExit(nuevoleon)
  east       asExit(nuevoleon)
  coahuila   : NoTravelMessage { "<<alreadyInNation()>>" }
;
chiapasRoom: MexicanRoom 'Chiapas'
  capname    = 'Chiapas'
  abbr       = 'CP'
  desc =
    "This is a humid and tropical region, bordering the Pacific Ocean. "
  oaxaca     = mexPassChiaOaxa
  veracruz   = mexPassChiaVera
  tabasco    = mexPassChiaTaba
  west       asExit(oaxaca)
  northwest  asExit(veracruz)
  north      asExit(tabasco)
  northeast  asExit(tabasco)
  chiapas    : NoTravelMessage { "<<alreadyInNation()>>" }
;
//There should be a note on the ground here, reading, "Tenochtitlan: why<./s>d it leave our lexicons? That<./s>s nobody<./s>s business but the Mexicans<./s>."
distritoRoom: MexicanRoom 'Distrito Federal'
  capname    = 'Distrito Federal'
  abbr       = 'DF'
  desc =
    "This small area is the site of the ancient Aztecs<./s> 
      capital city of Tenochtitlan, which was later renamed Mexico City. "
  mexico     = mexPassDistMexi
  morelos    = mexPassDistMore
  west       asExit(mexico)
  northwest  asExit(mexico)
  north      asExit(mexico)
  northeast  asExit(mexico)
  east       asExit(mexico)
  southeast  asExit(morelos)
  south      asExit(morelos)
  southwest  asExit(morelos)
  out        asExit(mexico)
  distrito   : NoTravelMessage { "<<alreadyInNation()>>" }
;
durangoRoom: MexicanRoom 'Durango'
  capname    = 'Durango'
  abbr       = 'DR'
  desc =
    "The mountains of the Sierra Madre Occidental 
      run through the western part of this area, 
      with dry plains to the east. "
  sinaloa    = mexPassDuraSina
  chihuahua  = mexPassDuraChih
  coahuila   = mexPassDuraCoah
  zacatecas  = mexPassDuraZaca
  nayarit    = mexPassDuraNaya
  northwest  asExit(chihuahua)
  north      asExit(chihuahua)
  northeast  asExit(coahuila)
  east       asExit(zacatecas)
  southeast  asExit(zacatecas)
  south      asExit(nayarit)
  southwest  asExit(sinaloa)
  west       asExit(sinaloa)
  durango    : NoTravelMessage { "<<alreadyInNation()>>" }
;
guanajuatoRoom: MexicanRoom 'Guanajuato'
  capname    = 'Guanajuato'
  abbr       = 'GN'
  desc =
    "This is a plateau region directly in the center of Mexico. "
    // once known for its wealthy mines
  jalisco    = mexPassGuanJali
  sanluis    = mexPassGuanSanl
  queretaro  = mexPassGuanQuer
  michoacan  = mexPassGuanMich
  north      asExit(sanluis)
  northeast  asExit(sanluis)
  east       asExit(queretaro)
  southeast  asExit(michoacan)
  south      asExit(michoacan)
  southwest  asExit(michoacan)
  west       asExit(jalisco)
  northwest  asExit(jalisco)
  guanajuato : NoTravelMessage { "<<alreadyInNation()>>" }
;
guerreroRoom: MexicanRoom 'Guerrero'
  capname    = 'Guerrero'
  abbr       = 'GR'
  desc =
    "This area was once controlled by the Aztecs, 
      who built their mighty fortress of Acapulco here. "
  michoacan  = mexPassGuerMich
  mexico     = mexPassGuerMexi
  morelos    = mexPassGuerMore
  puebla     = mexPassGuerPueb
  oaxaca     = mexPassGuerOaxa
  west       asExit(michoacan)
  northwest  asExit(michoacan)
  north      asExit(mexico)
  northeast  asExit(puebla)
  east       asExit(oaxaca)
  southeast  asExit(oaxaca)
  guerrero   : NoTravelMessage { "<<alreadyInNation()>>" }
;
hidalgoRoom: MexicanRoom 'Hidalgo'
  capname    = 'Hidalgo'
  abbr       = 'HD'
  desc =
    "This is a mountainous region near the southern end 
      of the Sierra Madre Oriental. "
  veracruz   = mexPassHidaVera
  puebla     = mexPassHidaPueb
  tlaxcala   = mexPassHidaTlax
  mexico     = mexPassHidaMexi
  queretaro  = mexPassHidaQuer
  sanluis    = mexPassHidaSanl
  north      asExit(sanluis)
  northeast  asExit(veracruz)
  east       asExit(puebla)
  southeast  asExit(puebla)
  south      asExit(tlaxcala)
  southwest  asExit(mexico)
  west       asExit(queretaro)
  northwest  asExit(queretaro)
  hidalgo    : NoTravelMessage { "<<alreadyInNation()>>" }
;
jaliscoRoom: MexicanRoom 'Jalisco'
  capname    = 'Jalisco'
  abbr       = 'JL'
  desc =
    "The Sierra Madre Occidental runs through 
      this region, separating the coastal plains 
      from a large plateau. "
  nayarit    = mexPassJaliNaya
  zacatecas  = mexPassJaliZaca
  aguascal   = mexPassJaliAgua
  sanluis    = mexPassJaliSanl
  guanajuato = mexPassJaliGuan
  michoacan  = mexPassJaliMich
  colima     = mexPassJaliColi
  west       asExit(nayarit)
  northwest  asExit(nayarit)
  north      asExit(zacatecas)
  northeast  asExit(sanluis)
  east       asExit(guanajuato)
  southeast  asExit(michoacan)
  south      asExit(colima)
  southwest  asExit(colima)
  jalisco    : NoTravelMessage { "<<alreadyInNation()>>" }
;
michoacanRoom: MexicanRoom 'Michoac\u00E1n'
  capname    = 'Michoac\u00E1n'
  abbr       = 'MC'
  desc =
    "The mountains of the Sierra Madre Occidental run through here. "
  colima     = mexPassMichColi
  jalisco    = mexPassMichJali
  guanajuato = mexPassMichGuan
  queretaro  = mexPassMichQuer
  mexico     = mexPassMichMexi
  guerrero   = mexPassMichGuer
  west       asExit(colima)
  northwest  asExit(jalisco)
  north      asExit(guanajuato)
  northeast  asExit(queretaro)
  east       asExit(mexico)
  southeast  asExit(guerrero)
  south      asExit(guerrero)
  michoacan  : NoTravelMessage { "<<alreadyInNation()>>" }
;
morelosRoom: MexicanRoom 'Morelos'
  capname    = 'Morelos'
  abbr       = 'MR'
  desc =
    "This is small region of mountains and forests. "
  distrito   = mexPassMoreDist
  mexico     = mexPassMoreMexi
  puebla     = mexPassMorePueb
  guerrero   = mexPassMoreGuer
  north      asExit(distrito)
  west       asExit(mexico)
  northwest  asExit(mexico)
  northeast  asExit(mexico)
  east       asExit(puebla)
  southeast  asExit(mexico)
  south      asExit(guerrero)
  southwest  asExit(guerrero)
  morelos    : NoTravelMessage { "<<alreadyInNation()>>" }
;
mexicoRoom: MexicanRoom 'M\u00E9xico'
  capname    = 'M\u00E9xico'
  abbr       = 'MX'
  desc =
    "This is a rather small region, mostly taken up by a large valley. "
  hidalgo    = mexPassMexiHida
  tlaxcala   = mexPassMexiTlax
  puebla     = mexPassMexiPueb
  distrito   = mexPassMexiDist
  morelos    = mexPassMexiMore
  guerrero   = mexPassMexiGuer
  michoacan  = mexPassMexiMich
  queretaro  = mexPassMexiQuer
  west       asExit(michoacan)
  northwest  asExit(queretaro)
  north      asExit(hidalgo)
  northeast  asExit(hidalgo)
  east       asExit(tlaxcala)
  southeast  asExit(puebla)
  south      asExit(distrito)
  southwest  asExit(guerrero)
  in         asExit(distrito)
  mexico     : NoTravelMessage { "<<alreadyInNation()>>" }
;
nuevoleonRoom: MexicanRoom 'Nuevo Le\u00F3n'
  capname    = 'Nuevo Le\u00F3n'
  abbr       = 'NL'
  desc =
    "This large north-south area is dominated by the mountains 
      of the Sierra Madre Oriental. "
  coahuila   = mexPassNuevCoah
  sanluis    = mexPassNuevSanl
  tamaulipas = mexPassNuevTama
  northwest  asExit(coahuila)
  west       asExit(coahuila)
  southwest  asExit(sanluis)
  south      asExit(sanluis)
  southeast  asExit(tamaulipas)
  east       asExit(tamaulipas)
  northeast  asExit(tamaulipas)
  nuevoleon  : NoTravelMessage { "<<alreadyInNation()>>" }
;
nayaritRoom: MexicanRoom 'Nayarit'
  capname    = 'Nayarit'
  abbr       = 'NY'
  desc =
    "This is a fairly small region on the Pacific coast. 
      The mountains of the Sierra Madre Occidental 
      run through here. "
  sinaloa    = mexPassNayaSina
  durango    = mexPassNayaDura
  zacatecas  = mexPassNayaZaca
  jalisco    = mexPassNayaJali
  northwest  asExit(sinaloa)
  north      asExit(durango)
  northeast  asExit(zacatecas)
  east       asExit(jalisco)
  southeast  asExit(jalisco)
  south      asExit(jalisco)
  nayarit    : NoTravelMessage { "<<alreadyInNation()>>" }
;
oaxacaRoom: MexicanRoom 'Oaxaca'
  capname    = 'Oaxaca'
  abbr       = 'OX'
  desc =
    "This region is filled with the mountains of the 
      Sierra Madre del Sur, plus a few valleys and plains. "
  guerrero   = mexPassOaxaGuer
  puebla     = mexPassOaxaPueb
  veracruz   = mexPassOaxaVera
  chiapas    = mexPassOaxaChia
  west       asExit(guerrero)
  northwest  asExit(puebla)
  north      asExit(veracruz)
  northeast  asExit(veracruz)
  east       asExit(chiapas)
  southeast  asExit(chiapas)
  oaxaca     : NoTravelMessage { "<<alreadyInNation()>>" }
;
pueblaRoom: MexicanRoom 'Puebla'
  capname    = 'Puebla'
  abbr       = 'PB'
  desc =
    "This is one of the most mountainous regions of Mexico, 
      filled with mountains such as Citlalt\u00E9petl, 
      Popocat\u00E9petl, and Iztacc\u00EDhuatl. "
  veracruz   = mexPassPuebVera
  oaxaca     = mexPassPuebOaxa
  guerrero   = mexPassPuebGuer
  morelos    = mexPassPuebMore
  mexico     = mexPassPuebMexi
  tlaxcala   = mexPassPuebTlax
  hidalgo    = mexPassPuebHida
  north      asExit(veracruz)
  northeast  asExit(veracruz)
  east       asExit(veracruz)
  southeast  asExit(oaxaca)
  south      asExit(oaxaca)
  southwest  asExit(guerrero)
  west       asExit(tlaxcala)
  northwest  asExit(hidalgo)
  in         asExit(tlaxcala)
  puebla     : NoTravelMessage { "<<alreadyInNation()>>" }
;
quintanaRoom: MexicanRoom 'Quintana Roo'
  capname    = 'Quintana Roo'
  abbr       = 'QN'
  desc =
    "This is the eastern side of the Yucat\u00E1n Peninsula, 
      facing the Caribbean. The ancient Maya had many 
      settlements here, including Canc\u00FAn and Cozumel. "
  campeche   = mexPassQuinCamp
  yucatan    = mexPassQuinYuca
  southwest  asExit(campeche)
  west       asExit(campeche)
  northwest  asExit(yucatan)
  north      asExit(yucatan)
  quintana   : NoTravelMessage { "<<alreadyInNation()>>" }
;
queretaroRoom: MexicanRoom 'Quer\u00E9taro'
  capname    = 'Quer\u00E9taro'
  abbr       = 'QR'
  desc =
    "This a small section of plains in central Mexico. "
  sanluis    = mexPassQuerSanl
  hidalgo    = mexPassQuerHida
  mexico     = mexPassQuerMexi
  michoacan  = mexPassQuerMich
  guanajuato = mexPassQuerGuan
  north      asExit(sanluis)
  northeast  asExit(sanluis)
  east       asExit(hidalgo)
  southeast  asExit(mexico)
  south      asExit(michoacan)
  southwest  asExit(michoacan)
  west       asExit(guanajuato)
  northwest  asExit(guanajuato)
  queretaro  : NoTravelMessage { "<<alreadyInNation()>>" }
;
sinaloaRoom: MexicanRoom 'Sinaloa'
  capname    = 'Sinaloa'
  abbr       = 'SI'
  desc =
    "This long, narrow region runs along the Pacific coast 
      for hundreds of miles. "
  sonora     = mexPassSinaSono
  chihuahua  = mexPassSinaChih
  durango    = mexPassSinaDura
  nayarit    = mexPassSinaNaya
  northwest  asExit(sonora)
  north      asExit(sonora)
  northeast  asExit(chihuahua)
  east       asExit(durango)
  southeast  asExit(nayarit)
  south      asExit(nayarit)
  sinaloa    : NoTravelMessage { "<<alreadyInNation()>>" }
;
sanluisRoom: MexicanRoom 'San Luis Potos\u00ED'
  capname    = 'San Luis Potos\u00ED'
  abbr       = 'SL'
  desc =
    "This fairly large region is filled by a large plateau 
      and by the mountains of the Sierra Madre Oriental. "
  nuevoleon  = mexPassSanlNuev
  tamaulipas = mexPassSanlTama
  veracruz   = mexPassSanlVera
  hidalgo    = mexPassSanlHida
  queretaro  = mexPassSanlQuer
  guanajuato = mexPassSanlGuan
  jalisco    = mexPassSanlJali
  zacatecas  = mexPassSanlZaca
  north      asExit(nuevoleon)
  northeast  asExit(tamaulipas)
  east       asExit(veracruz)
  southeast  asExit(hidalgo)
  south      asExit(guanajuato)
  southwest  asExit(jalisco)
  west       asExit(zacatecas)
  northwest  asExit(zacatecas)
  sanluis    : NoTravelMessage { "<<alreadyInNation()>>" }
;
sonoraRoom: MexicanRoom 'Sonora'
  capname    = 'Sonora'
  abbr       = 'SO'
  desc =
    "This area hugs the Gulf of California and is filled with 
      the mountains of the Sierra Madre Occidental. "
  bajacali   = mexPassSonoBaca
  chihuahua  = mexPassSonoChih
  sinaloa    = mexPassSonoSina
  west       asExit(bajacali)
  northwest  asExit(bajacali)
  east       asExit(chihuahua)
  south      asExit(sinaloa)
  southeast  asExit(sinaloa)
  sonora     : NoTravelMessage { "<<alreadyInNation()>>" }
;
tabascoRoom: MexicanRoom 'Tabasco'
  capname    = 'Tabasco'
  abbr       = 'TB'
  desc =
    "This is a plains region along the shore of the Gulf of Mexico. "
  veracruz   = mexPassTabaVera
  chiapas    = mexPassTabaChia //CP
  campeche   = mexPassTabaCamp //CM
  west       asExit(veracruz)
  southwest  asExit(veracruz)
  south      asExit(chiapas)
  southeast  asExit(chiapas)
  east       asExit(campeche)
  northeast  asExit(campeche)
  north      asExit(campeche)
  tabasco    : NoTravelMessage { "<<alreadyInNation()>>" }
;
tlaxcalaRoom: MexicanRoom 'Tlaxcala'
  capname    = 'Tlaxcala'
  abbr       = 'TL'
  desc =
    "This small, mountainous region was once home to 
      the ancient independent city-state of Tlaxcala, 
      which resisted the mighty Aztec Empire. "
  hidalgo    = mexPassTlaxHida
  puebla     = mexPassTlaxPueb
  mexico     = mexPassTlaxMexi
  northeast  asExit(puebla)
  east       asExit(puebla)
  southeast  asExit(puebla)
  south      asExit(puebla)
  southwest  asExit(puebla)
  west       asExit(mexico)
  northwest  asExit(hidalgo)
  north      asExit(hidalgo)
  out        asExit(puebla)
  tlaxcala   : NoTravelMessage { "<<alreadyInNation()>>" }
;
tamaulipasRoom: MexicanRoom 'Tamaulipas'
  capname    = 'Tamaulipas'
  abbr       = 'TM'
  desc =
    "This area hugs both the Gulf of Mexico and also 
      the Rio Grande River. "
  nuevoleon  = mexPassTamaNuev
  sanluis    = mexPassTamaSanl
  veracruz   = mexPassTamaVera
  northwest  asExit(nuevoleon)
  west       asExit(nuevoleon)
  southwest  asExit(sanluis)
  south      asExit(veracruz)
  southeast  asExit(veracruz)
  tamaulipas : NoTravelMessage { "<<alreadyInNation()>>" }
;
veracruzRoom: MexicanRoom 'Veracruz'
  capname    = 'Veracruz'
  abbr       = 'VR'
  desc =
    "This is a long, sprawling section of Caribbean coastal plain. "
  tamaulipas = mexPassVeraTama
  sanluis    = mexPassVeraSanl
  hidalgo    = mexPassVeraHida
  puebla     = mexPassVeraPueb
  oaxaca     = mexPassVeraOaxa
  chiapas    = mexPassVeraChia
  tabasco    = mexPassVeraTaba
  north      asExit(tamaulipas)
  northwest  asExit(sanluis)
  west       asExit(hidalgo)
  southwest  asExit(puebla)
  south      asExit(oaxaca)
  southeast  asExit(chiapas)
  east       asExit(tabasco)
  veracruz   : NoTravelMessage { "<<alreadyInNation()>>" }
;
yucatanRoom: MexicanRoom 'Yucat\u00E1n'
  capname    = 'Yucat\u00E1n'
  abbr       = 'YC'
  desc =
    "This part of the Yucat\u00E1n Peninusla was home 
      to such ancient peoples as the Mayas and the Toltecs, 
      and to such sites as Chich\u00E9n Itz\u00E1 and Uxmal. "
  campeche   = mexPassYucaCamp
  quintana   = mexPassYucaQuin
  west       asExit(campeche)
  southwest  asExit(campeche)
  south      asExit(quintana)
  southeast  asExit(quintana)
  east       asExit(quintana)
  yucatan    : NoTravelMessage { "<<alreadyInNation()>>" }
;
zacatecasRoom: MexicanRoom 'Zacatecas'
  capname    = 'Zacatecas'
  abbr       = 'ZC'
  desc =
    "This is an area of semiarid plains and mountains, 
      lying on a large plateau. "
  sanluis    = mexPassZacaSanl
  jalisco    = mexPassZacaJali
  aguascal   = mexPassZacaAgua
  nayarit    = mexPassZacaNaya
  durango    = mexPassZacaDura
  coahuila   = mexPassZacaCoah
  northeast  asExit(coahuila)
  east       asExit(sanluis)
  southeast  asExit(jalisco)
  south      asExit(aguascal)
  southwest  asExit(jalisco)
  west       asExit(nayarit)
  northwest  asExit(durango)
  north      asExit(durango)
  zacatecas  : NoTravelMessage { "<<alreadyInNation()>>" }
;
*/


// -------------------------------------------------------------------
// NATION MAZES: SCENERY: AFRICA SCENERY
// -------------------------------------------------------------------

class SmallAfricanDecoration: Decoration
  //notImportantMsg =
  //  'Sheila says, <.q>I get the feeling I don<./s>t need
  //    to spend a lot of time worrying specifically about '
  //    + theName + '.<./q> '
;

class AfricanDecoration: MultiLoc, SmallAfricanDecoration
  //notImportantMsg =
  //  'Sheila says, <.q>I get the feeling I don<./s>t need
  //    to spend a lot of time worrying specifically about '
  //    + theName + '.<./q> '
;

atlanticOcean: AfricanDecoration
  'atlantic ocean/sea/coast/shore/beach/water'
  'Atlantic Ocean'
  locationList = [
    moroccoRoom, westsahaRoom, mauritaniaRoom, senegalRoom, 
    gambiaRoom, guinbissRoom, guineaRoom, sierleonRoom, 
    liberiaRoom, ivorcoasRoom, ghanaRoom, togoRoom, 
    beninRoom, nigeriaRoom, cameroonRoom, equaguinRoom, 
    gabonRoom, congoRoom, demorepuRoom, angolaRoom, 
    namibiaRoom, soutafriRoom
  ]
  aName = theName
  desc {
    "The Atlantic Ocean lies here to the ";
    switch (bot.getOutermostRoom) {
      case sierleonRoom:
      case liberiaRoom : "southwest. "; break;
      case ivorcoasRoom:
      case ghanaRoom   :
      case togoRoom    :
      case beninRoom   :
      case nigeriaRoom : "south. "; break;
      default          : "west. "; break;
    }
  }
;

indianOcean: AfricanDecoration
  'indian ocean/sea/coast/shore/beach/water'
  'Indian Ocean'
  locationList = [
    //djiboutiRoom,
    somaliaRoom, kenyaRoom, tanzaniaRoom, 
    mozambiqueRoom, soutafriRoom
  ]
  aName = theName
  desc {
    "The Indian Ocean lies here to the east. ";
  }
;

mediterraneanSea: AfricanDecoration
  'mediterranean ocean/sea/coast/shore/beach/water'
  'Mediterranean Sea'
  locationList = [
    moroccoRoom, algeriaRoom, tunisiaRoom, libyaRoom, 
    egyptRoom
  ]
  aName = theName
  desc {
    "The Mediterranean Sea lies here to the north. ";
  }
;

redSea: AfricanDecoration
  'red ocean/sea/coast/shore/beach/water'
  'Red Sea'
  locationList = [
    egyptRoom, sudanRoom, eritreaRoom
  ]
  aName = theName
  desc {
    "The Red Sea lies here to the east. ";
  }
;

// In Djibouti, "Indian Ocean" is a synonym for "Gulf of Aden."
// In Somalia, the two are separate things.

djiboutianGulfOfAden: SmallAfricanDecoration
  'aden indian gulf/bay/ocean/sea/coast/shore/beach/water'
  'Gulf of Aden'
  @djiboutiRoom
  aName = theName
  desc {
    "The Gulf of Aden lies here to the north. ";
  }
;

somaliGulfOfAden: SmallAfricanDecoration
  'aden gulf/bay/coast/shore/beach/water'
  'Gulf of Aden'
  @somaliaRoom
  aName = theName
  desc {
    "The Gulf of Aden lies here to the north. ";
  }
;
straitOfGibraltar: SmallAfricanDecoration
  'gibraltar strait/channel'
  'Strait of Gibraltar'
  @moroccoRoom
  aName = theName
  desc {
    "The Strait of Gibraltar lies here to the north, separating 
      the Atlantic Ocean from the Mediterranean Sea. ";
  }
;

suezCanal: SmallAfricanDecoration
  'suez canal'
  'Suez Canal'
  @egyptRoom
  aName = theName
  desc {
    "The Suez Canal lies here to the east, connecting 
      the Mediterranean and Red seas, and also separating 
      the Sinai Peninsula from the rest of Egypt. ";
  }
;

// Surface areas of a few African lakes (in square kilometers):
// Victoria   68,800 http://en.wikipedia.org/wiki/Lake_Victoria
// Tanganyika 32,900 http://en.wikipedia.org/wiki/Lake_Tanganyika
// Malawi     29,600 http://en.wikipedia.org/wiki/Lake_Malawi
// Volta       8,502 http://en.wikipedia.org/wiki/Lake_Volta
// Chad        1,540 http://en.wikipedia.org/wiki/Lake_Chad

lakeVictoria: AfricanDecoration
  'lake victoria -'
  'Lake Victoria'
  locationList = [
    ugandaRoom, kenyaRoom, tanzaniaRoom
  ]
  isProperName = true
  desc {
    "Lake Victoria, the largest lake in Africa, lies here to the ";
    switch (bot.getOutermostRoom) {
      case ugandaRoom  : "southeast. "; break;
      case kenyaRoom   : "southwest. "; break;
      case tanzaniaRoom: "north. "; break;
    }
  }
;

lakeTanganyika: AfricanDecoration
  'lake tanganyika -'
  'Lake Tanganyika'
  locationList = [
    tanzaniaRoom, demorepuRoom, burundiRoom, zambiaRoom
  ]
  isProperName = true
  desc {
    "Lake Tanganyika, the second largest lake in Africa, lies here ";
    switch (bot.getOutermostRoom) {
      case tanzaniaRoom: "to the west. "; break;
      case demorepuRoom: "to the east. "; break;
      case burundiRoom : "to the southwest. "; break;
      case zambiaRoom  : "in the extreme north. "; break;
    }
  }
;

lakeMalawi: AfricanDecoration
  'lake (malawi) -'
  'Lake Malawi'
  locationList = [
    tanzaniaRoom, malawiRoom, mozambiqueRoom
  ]
  isProperName = true
  desc {
    "Lake Malawi, the third largest lake in Africa, lies here ";
    switch (bot.getOutermostRoom) {
      case tanzaniaRoom  : "to the south. "; break;
      case malawiRoom    : "to the east. "; break;
      case mozambiqueRoom: "in the extreme north. "; break;
    }
  }
;

lakeVolta: SmallAfricanDecoration
  'lake volta -'
  'Lake Volta'
  @ghanaRoom
  isProperName = true
  desc {
    "The massive Lake Volta lies here. 
      The Black Volta and White Volta Rivers empty into it 
      from the northwest and northeast, respectively.
      On the southern end of of the lake is the Akosombo Dam,
      beyond which the Volta River continues to the ocean. ";
  }
;

lakeChad: AfricanDecoration
  'lake chad -'
  'Lake Chad'
  locationList = [
    nigerRoom, chadRoom, nigeriaRoom, cameroonRoom
  ]
  isProperName = true
  desc {
    "Lake Chad, a very shallow lake, lies here ";
    switch (bot.getOutermostRoom) {
      case nigerRoom   : "in the extreme southeast. "; break;
      case chadRoom    : "to the west. "; break;
      case nigeriaRoom : "in the extreme northeast. "; break;
      case cameroonRoom: "in the extreme north. "; break;
    }
  }
;









nileRiver: AfricanDecoration
  'nile river -'
  'Nile River'
  locationList = [
    egyptRoom, sudanRoom
  ]
  aName = theName
  desc {
    if (bot.isIn(egyptRoom))
      "The Nile River flows northward here, emptying into the
        Mediterranean Sea. ";
    else
      "The White Nile and Blue Nile join here to form the 
        Nile River proper, which flows north into Egypt. ";
  }
;
sudaneseBlueNileRiver: SmallAfricanDecoration
  'blue (nile) (river) -'
  'Blue Nile'
  @sudanRoom
  aName = theName
  desc {
    "The Blue Nile flows northwestward into this area, 
      where it joins with the White Nile. ";
  }
;
sudaneseWhiteNileRiver: SmallAfricanDecoration
  'white (nile) (river) -'
  'White Nile'
  @sudanRoom
  aName = theName
  desc {
    "The White Nile flows northward into this area, 
      where it joins with the Blue Nile. ";
  }
;
southsudaneseWhiteNileRiver: SmallAfricanDecoration
  'white (nile) (river) -'
  'White Nile'
  @southsudanRoom
  aName = theName
  desc {
    "The White Nile flows northward through this area. ";
  }
;
ethiopianBlueNileRiver: SmallAfricanDecoration
  'blue nile river -'
  'Blue Nile'
  @ethiopiaRoom
  aName = theName
  desc {
    "The Blue Nile originates in the highlands of this region,
      then circles and flows out to the west. ";
  }
;
ugandanWhiteNileRiver: SmallAfricanDecoration
  'white nile river -'
  'White Nile'
  @ugandaRoom
  aName = theName
  desc {
    "One of the branches of the Nile originates here, 
      flowing out of Lake Victoria and tracing a tortuous path northwards. ";
  }
;
senegalRiver: AfricanDecoration
  '(senegal) (s\u00E9n\u00E9gal) river -'
  'S\u00E9n\u00E9gal River'
  locationList = [
    senegalRoom, mauritaniaRoom, maliRoom
  ]
  aName = theName
  desc {
    switch (bot.getOutermostRoom) {
      case maliRoom:
        "The S\u00E9n\u00E9gal River flows through here 
          in the extreme west. ";
        break;
      case mauritaniaRoom:
        "The S\u00E9n\u00E9gal River flows along the southwestern
          border of this region. ";
        break;
      case senegalRoom:
        "The S\u00E9n\u00E9gal River flows along the northern
          border of this region. ";
        break;
    }
  }
;
gambiaRiver: AfricanDecoration
  '(gambia) river -'
  'Gambia River'
  locationList = [
    gambiaRoom, senegalRoom, guineaRoom
  ]
  aName = theName
  desc {
    switch (bot.getOutermostRoom) {
      case guineaRoom:
        "The Gambia River originates in the northern part of 
          this region, then flows out to the north. ";
        break;
      case senegalRoom:
        "The Gambia River flows through the southeastern part of 
          this region. ";
        break;
      case gambiaRoom:
        "The Gambia River flows in from the east, runs 
          all the way through this region, then flows out
          to the Atlantic in the west. ";
        break;
    }
  }
;
nigerRiver: AfricanDecoration
  '(niger) river -'
  'Niger River'
  locationList = [
    guineaRoom, maliRoom, nigerRoom, beninRoom, nigeriaRoom
  ]
  aName = theName
  desc {
    switch (bot.getOutermostRoom) {
      case guineaRoom:
        "The Niger River originates here, then flows out to the 
          northeast. ";
        break;
      case maliRoom:
        "The Niger River flows in a broad arc through the southern
          portion of this region. ";
        break;
      case nigerRoom:
        "The Niger River flows through the southwest portion
          of this region. ";
        break;
      case beninRoom:
        "The Niger River flows across the northern boundary 
          of this region. ";
        break;
      case nigeriaRoom:
        "The Niger River flows through here and empties
          out to the Atlantic. ";
        break;
    }
  }
;
burkinabeBlackVoltaRiver: AfricanDecoration
  'mouhoun black volta river -'
  'Black Volta'
  locationList = [
    burkfasoRoom, ivorcoasRoom
  ]
  aName = theName
  desc {
    switch (bot.getOutermostRoom) {
      case burkfasoRoom:
        "The Black Volta originates in the western part of this
          region, then loops around to the south. ";
        break;
      case ivorcoasRoom:
        "The Black Volta flows along the extreme northeastern
          border of this region. ";
        break;
    }
  }
;
burkinabeWhiteVoltaRiver: SmallAfricanDecoration
  'nakambe white volta river -'
  'White Volta'
  @burkfasoRoom
  aName = theName
  desc {
    "The White Volta originates in the northern part of this
      region, then flows out to the south. ";
  }
;
ghanaianBlackVoltaRiver: SmallAfricanDecoration
  'mouhoun black (volta) (river) -'
  'Black Volta'
  @ghanaRoom
  aName = theName
  desc {
    "The Black Volta flows in from the west, 
      then empties into Lake Volta. ";
  }
;
ghanaianWhiteVoltaRiver: SmallAfricanDecoration
  'nakambe white (volta) (river) -'
  'White Volta'
  @ghanaRoom
  aName = theName
  desc {
    "The White Volta flows in here from the north
      and empties into Lake Volta. ";
  }
;
voltaRiver: SmallAfricanDecoration
  'volta river -'
  'Volta River'
  @ghanaRoom
  aName = theName
  desc {
    "The Volta River proper flows from the Akosombo Dam 
      at the southern end of Lake Volta and empties into
      the Atlantic. Its main tributaries, the Black Volta
      and the White Volta, lie to the northwest and
      northeast, respectively. ";
  }
;
ogooueRiver: AfricanDecoration
  'ogooue ogoou\u00E9 river -'
  'Ogoou\u00E9 River'
  locationList = [
    congoRoom, gabonRoom
  ]
  aName = theName
  desc {
    switch (bot.getOutermostRoom) {
      case congoRoom:
        "The Ogoou\u00E9 River originates here, then flows out
          to the west. ";
        break;
      case gabonRoom:
        "The Ogoou\u00E9 River flows through the heart of this
          region, emptying out into the Atlantic. ";
        break;
    }
  }
;
congoRiver: AfricanDecoration
  '(congo) river -'
  'Congo River'
  locationList = [
    demorepuRoom, congoRoom, angolaRoom
  ]
  aName = theName
  desc {
    switch (bot.getOutermostRoom) {
      case demorepuRoom:
        "The Congo River originates here in the extreme south,
          then traces a huge arc through this entire region,
          before it finally empties out into the Atlantic. ";
        break;
      case congoRoom:
        "The Congo River flows along most of the southeastern
          border of this region. ";
        break;
      case angolaRoom:
        "The Congo River flows briefly along the northwestern
          border of this region before emptying into the Atlantic. ";
        break;
    }
  }
;
zambeziRiver: AfricanDecoration
  'zambezi river -'
  'zambezi River'
  locationList = [
    zambiaRoom, angolaRoom, namibiaRoom, botswanaRoom, 
    zimbabweRoom, mozambiqueRoom
  ]
  aName = theName
  desc {
    switch (bot.getOutermostRoom) {
      case zambiaRoom:
        "The Zambezi River flows through the western part of this
          region, then flows for a while along the southern boundary. ";
        break;
      case angolaRoom:
        "The Zambezi River flows through the far eastern part of this region. ";
        break;
      case namibiaRoom:
        "The Zambezi River flows along the extreme northeastern
          tip of this region. ";
        break;
      case botswanaRoom:
        "The Zambezi River barely touches this region, but it does 
          flow along the northern boundary for just a few miles. ";
        break;
      case zimbabweRoom:
        "The Zambezi River flows along the entire northwestern 
          boundary of this region. ";
        break;
      case mozambiqueRoom:
        "The Zambezi River flows in here from the west, then empties
          out into the Indian Ocean. ";
        break;
    }
  }
;

// Mountains

atlasMountains: AfricanDecoration
  '(tall) (high) (rugged) atlas range (chain) mountain (mt) mount peak *mountains*mounts*peaks'
  'Atlas Mountains'
  locationList = [
    moroccoRoom, algeriaRoom, tunisiaRoom
  ]
  //aName = theName
  isPlural = true
  desc {
    switch (bot.getOutermostRoom) {
      case moroccoRoom:
        "The Atlas Mountains run all the way along this region. ";
        break;
      case algeriaRoom:
        "The Atlas Mountains run through the northern part of this
          region. ";
        break;
      case tunisiaRoom:
        "A small section of the Atlas Mountains lie here to the
          northwest. ";
        break;
    }
  }
;

drakensbergMountains: AfricanDecoration
  '(tall) (high) (rugged) drakensberg range (chain) mountain (mt) mount peak *mountains*mounts*peaks'
  'Drakensberg Mountains'
  locationList = [
    soutafriRoom, lesothoRoom, swazilandRoom
  ]
  //aName = theName
  isPlural = true
  desc {
    "The Drakensberg Mountains run through ";
    switch (bot.getOutermostRoom) {
      case soutafriRoom:
        "the eastern part of this region. ";
        break;
      case lesothoRoom:
        "this region, tall and rugged. ";
        break;
      case swazilandRoom:
        "this region, tall and rugged. ";
        break;
    }
  }
;

africanMountains: AfricanDecoration
  '(tall) (high) (rugged) atlas range (chain) mountain (mt) mount peak *mountains*mounts*peaks'
  'mountains'
  locationList = [
    chadRoom, sudanRoom, eritreaRoom, guineaRoom, 
    nigeriaRoom, cameroonRoom, demorepuRoom, ugandaRoom, 
    kenyaRoom, burundiRoom, tanzaniaRoom, angolaRoom, 
    zambiaRoom, namibiaRoom, zimbabweRoom
  ]
  isPlural = true
  desc {
    switch (bot.getOutermostRoom) {
      case chadRoom:
        "A few mountains lie here in the north. ";
        break;
      case sudanRoom:
        "A few mountains lie here in the west. ";
        break;
      case ethiopiaRoom:
        "The highlands here boast several very tall mountains. ";
        break;
      case guineaRoom:
        "The highlands here contain quite a few rugged mountains. ";
        break;
      case cameroonRoom:
        "Several mountains lie here, partiularly along the northeast border. ";
        break;
      case demorepuRoom:
        "There are a few mountains on the fringes of this region,
          particularly in the east. ";
        break;
      case kenyaRoom:
        "In the highlands here stand several of Africa<./s>s tallest 
          mountains. ";
        break;
      case zimbabweRoom:
        "A tall ridge runs along this region, northeast to southwest. ";
        break;
      //case eritreaRoom:
      //case nigeriaRoom:
      //case ugandaRoom:
      //case burundiRoom:
      //case tanzaniaRoom:
      //case angolaRoom:
      //case zambiaRoom:
      //case namibiaRoom:
      default:
        "Several tall mountains lie scattered throughout this region. ";
        break;
    }
  }
;

africanUnmountains: MultiLoc, Unthing
  '(tall) (high) (rugged) range (chain) mountain (mt) mount peak *mountains*mounts*peaks'
  'mountains'
  isPlural = true
  initialLocationClass = AfricaRoom
  isInitiallyIn(obj) {
    if (africanMountains.locationList.indexOf(obj))
      return nil;
    if (atlasMountains.locationList.indexOf(obj))
      return nil;
    if (drakensbergMountains.locationList.indexOf(obj))
      return nil;
    if (!obj || !obj.ofKind(AfricaRoom))
      return nil;
    else
      return true;
  }
  notHereMsg = 'Your bot fails to notice any prominent mountains 
    in this region. '
;

// Highlands/Plateaus

ethiopianHighlands: SmallAfricanDecoration
  '(tall) (flat) (high) (broad) (large) ethiopian highland/plateau*highlands*plateaus*plateaux'
  'Ethiopian Highlands'
  @ethiopiaRoom
  isPlural = true
  desc {
    "The Ethiopian Highlands are a very tall region with several
      mountains, dominating the whole middle part of this region. ";
  }
;

africanPlateau: AfricanDecoration
  '(tall) (flat) (high) (broad) (large) highland/plateau*highlands*plateaus*plateaux'
  'highlands'
  isPlural = true
  locationList = [
    eritreaRoom, guineaRoom, beninRoom, cameroonRoom, 
    centafriRoom, ugandaRoom, kenyaRoom, rwandaRoom, 
    burundiRoom, tanzaniaRoom, angolaRoom, zambiaRoom, 
    namibiaRoom, botswanaRoom, zimbabweRoom, swazilandRoom, 
    soutafriRoom, lesothoRoom
  ]
  desc {
    "Plateaus and highlands run through a large part of this region. ";
  }
;

africanUnplateau: MultiLoc, Unthing
  '(tall) (flat) (high) (broad) (large) highland/plateau*highlands*plateaus*plateaux'
  'highlands'
  isPlural = true
  initialLocationClass = AfricaRoom
  isInitiallyIn(obj) {
    if (obj == ethiopiaRoom)
      return nil;
    if (africanPlateau.locationList.indexOf(obj))
      return nil;
    if (!obj || !obj.ofKind(AfricaRoom))
      return nil;
    else
      return true;
  }
  notHereMsg = 'Your bot fails to notice any prominent plateaus
    or highlands in this region. '
;

africanHills: AfricanDecoration
  '(hilly) (rugged) (tall) (high) hill*hills'
  'hills'
  isPlural = true
  initialLocationClass = AfricaRoom
  desc {
    "There may be a few hills in this area, but nothing
      that stands out as special. ";
  }
;

saharaDesert: AfricanDecoration
  'sahara sand dry arid desert/dunes'
  'Sahara Desert'
  aName = theName
  locationList = [
    moroccoRoom, algeriaRoom, tunisiaRoom, libyaRoom, 
    egyptRoom, westsahaRoom, mauritaniaRoom, maliRoom, 
    nigerRoom, chadRoom, sudanRoom
  ]
  desc {
    "The Sahara Desert, dry and barren, takes up ";
    switch (bot.getOutermostRoom) {
      case moroccoRoom:
        "some of this region in the southeast. ";
        break;
      case tunisiaRoom:
        "the southern part of this region. ";
        break;
      case maliRoom:
      case nigerRoom:
      case chadRoom:
      case sudanRoom:
        "the whole northern part of this region. ";
        break;
      //case algeriaRoom:
      //case libyaRoom:
      //case egyptRoom:
      //case westsahaRoom:
      //case mauritaniaRoom:
      default:
        "most of this region. ";
        break;
    }
  }
;
namibDesert: SmallAfricanDecoration
  'namib sand (bone) bone-dry dry arid desert/dunes'
  'Namib Desert'
  @namibiaRoom
  aName = theName
  desc {
    "The bone-dry dunes of the Namib Desert lie here to the west. ";
  }
;
kalahariDesert: AfricanDecoration
  'kalahari sand dry arid desert/dunes'
  'Kalahari Desert'
  aName = theName
  locationList = [
    namibiaRoom, botswanaRoom, soutafriRoom
  ]
  desc {
    "The arid Kalahari Desert takes up ";
    switch (bot.getOutermostRoom) {
      case namibiaRoom:
        "the eastern part of this region. ";
        break;
      case botswanaRoom:
        "most of this region. ";
        break;
      case soutafriRoom:
        "the far northern part of this region. ";
        break;
    }
  }
;

sinaiPeninsula: SmallAfricanDecoration
  'sinai peninsula -'
  'Sinai Peninsula'
  @egyptRoom
  desc {
    "In the eastern part of this region, the Sinai Peninsula
      juts southward into the Red Sea. ";
  }
;
hornOfAfrica: AfricanDecoration
  'horn (africa) (african) (somali) peninsula'
  'Horn of Africa'
  locationList = [
    ethiopiaRoom, somaliaRoom
  ]
  desc {
    switch (bot.getOutermostRoom) {
      case ethiopiaRoom:
        "Although this region is landlocked, the eastern part of it
          is part of a peninsula that extends east into the Indian Ocean. ";
        break;
      case somaliaRoom:
        "This region is the greater part of a peninsula 
          that extends east into the Indian Ocean. ";
        break;
    }
  }
;
akosomboDam: SmallAfricanDecoration
  'akosombo dam'
  'Akosombo Dam'
  @ghanaRoom
  desc {
    "The Akosombo Dam stands on the southern end of Lake Volta,
      separating it from the Volta River proper, which flows
      southward from there. ";
  }
;

mountKilimajaro: SmallAfricanDecoration
  'volcano volcanic mt mt. mount kilimanjaro (mountain) -'
  'Mount Kilimanjaro'
  @tanzaniaRoom
  desc {
    "The volcanic Mount Kilimajaro rises here in the northeast,
      the highest mountain in Africa. ";
  }
;

africanGrasslands: AfricanDecoration
  'semi-arid (semi) (arid) grassland/savanna/savannah*grasslands*savannas*savannahs'
  'grasslands'
  isPlural = true
  locationList = [
    botswanaRoom, soutafriRoom, namibiaRoom, mauritaniaRoom, 
    maliRoom, nigerRoom, chadRoom, sudanRoom, southsudanRoom, 
    eritreaRoom, somaliaRoom, senegalRoom, guinbissRoom, 
    guineaRoom, ivorcoasRoom, burkfasoRoom, ghanaRoom, 
    togoRoom, beninRoom, nigeriaRoom, cameroonRoom, 
    congoRoom, centafriRoom, demorepuRoom, ugandaRoom, 
    kenyaRoom, tanzaniaRoom, angolaRoom, zambiaRoom, 
    malawiRoom, mozambiqueRoom, zimbabweRoom, swazilandRoom, 
    lesothoRoom
  ]
  desc {
    "Grasslands and savannas lie scattered in various places throughout
      this region. ";
  }
;
africanUngrasslands: MultiLoc, Unthing
  'semi-arid (semi) (arid) grassland/savanna/savannah*grasslands*savannas*savannahs'
  'grasslands'
  isPlural = true
  initialLocationClass = AfricaRoom
  isInitiallyIn(obj) {
    if (africanGrasslands.locationList.indexOf(obj))
      return nil;
    if (!obj || !obj.ofKind(AfricaRoom))
      return nil;
    else
      return true;
  }
  notHereMsg = 'Your bot fails to notice any prominent grasslands
    in this region. '
;

africanForest: AfricanDecoration
  '(huge) (tropical) (rain) forest/jungle/rainforest*forests*jungles*rainforests'
  'forest'
  locationList = [
    chadRoom, sudanRoom, southsudanRoom, ethiopiaRoom, somaliaRoom, 
    senegalRoom, gambiaRoom, guinbissRoom, guineaRoom, 
    sierleonRoom, liberiaRoom, ivorcoasRoom, burkfasoRoom, 
    ghanaRoom, togoRoom, beninRoom, nigeriaRoom, 
    cameroonRoom, equaguinRoom, gabonRoom, congoRoom, 
    centafriRoom, demorepuRoom, ugandaRoom, kenyaRoom, 
    rwandaRoom, burundiRoom, tanzaniaRoom, angolaRoom, 
    zambiaRoom, malawiRoom, mozambiqueRoom
  ]
  desc {
    "Forests and jungles lie scattered in various places throughout
      this region. ";
  }
;
africanUnforest: MultiLoc, Unthing
  '(huge) (tropical) (rain) forest/jungle/rainforest*forests*jungles*rainforests'
  'forest'
  initialLocationClass = AfricaRoom
  isInitiallyIn(obj) {
    if (africanForest.locationList.indexOf(obj))
      return nil;
    if (!obj || !obj.ofKind(AfricaRoom))
      return nil;
    else
      return true;
  }
  notHereMsg = 'Your bot fails to notice any prominent forests
    in this region. '
;

africanSwamp: AfricanDecoration
  '(mangrove) swamp*swamps'
  'swamp'
  locationList = [
    sudanRoom, southsudanRoom, senegalRoom, gambiaRoom, guinbissRoom, 
    guineaRoom, sierleonRoom, liberiaRoom
  ]
  desc {
    "There are a few swamps in this region, although your bot
      sees nothing special about them. ";
  }
;
africanUnswamp: MultiLoc, Unthing
  '(mangrove) swamp*swamps'
  'swamp'
  initialLocationClass = AfricaRoom
  isInitiallyIn(obj) {
    if (africanSwamp.locationList.indexOf(obj))
      return nil;
    if (!obj || !obj.ofKind(AfricaRoom))
      return nil;
    else
      return true;
  }
  notHereMsg = 'Your bot fails to notice any prominent swamps
    in this region. '
;

africanUnplains: MultiLoc, Unthing
  '(coastal) plain*plains'
  'plains'
  isPlural = true
  initialLocationClass = AfricaRoom
  notHereMsg = 'There may be a few plains in this region,
    but nothing that stands out as worthy of attention. '
;



/*
mediterraneanSea: MultiFaceted, Decoration
  locationList =
    [moroccoRoom, algeriaRoom, tunisiaRoom, libyaRoom, egyptRoom]
  instanceObject: Fixture { 'mediterranean sea' 'Mediterranean Sea'
    desc {
      "It glistens peacefully to the ";
      switch (gNbmLoc) {
        //case algeriaRoom: 
        //case libyaRoom:   
        //case egyptRoom:   "north. "; break;
        case moroccoRoom: "northeast. "; break;
        case tunisiaRoom: "north and east. "; break;
        default:          "north. "; break;
      }
    }
  }
;

atlanticOceanEast: MultiFaceted, Decoration
  locationList =
    [moroccoRoom, westsahaRoom, mauritaniaRoom, senegalRoom,
     gambiaRoom,  guinbissRoom, guineaRoom,     sierleonRoom,
     liberiaRoom, ivorcoasRoom, ghanaRoom,      togoRoom,
     beninRoom,   nigeriaRoom,  cameroonRoom,   equaguinRoom,
     gabonRoom,   congoRoom,    demorepuRoom,   angolaRoom,
     namibiaRoom, soutafriRoom]
  instanceObject: Decoration { 'atlantic ocean' 'Atlantic Ocean'
    desc {
      "It glistens peacefully to the ";
      switch (gNbmLoc) {
        //case moroccoRoom:    
        //case westsahaRoom:   
        //case mauritaniaRoom: 
        //case senegalRoom:    
        //case gambiaRoom:     
        //case guinbissRoom:   
        //case equaguinRoom:   
        //case gabonRoom:      
        //case demorepuRoom:   
        //case angolaRoom:     
        //case namibiaRoom:    
        //case soutafriRoom:   "west. "; break;
        case ivorcoasRoom:   
        case ghanaRoom:      
        case togoRoom:       
        case beninRoom:      
        case nigeriaRoom:    "south. "; break;
        case guineaRoom:     
        case sierleonRoom:   
        case liberiaRoom:    
        case cameroonRoom:   
        case congoRoom:      "southwest. "; break;
        default:             "west. "; break;
      }
    }
  }
;

indianOcean: MultiFaceted, Decoration
  'indian ocean' 'Indian Ocean'
  locationList =
    [djiboutiRoom,   somaliaRoom,
     kenyaRoom,      tanzaniaRoom,
     mozambiqueRoom, soutafriRoom]
  instanceObject: Decoration { 'indian ocean' 'Indian Ocean'
    "It glistens peacefully to the east. "
  }
;

saharaDesert: MultiFaceted, Decoration
  'sahara desert' 'Sahara Desert'
  locationList =
    [moroccoRoom, algeriaRoom,  tunisiaRoom,    libyaRoom,
     egyptRoom,   westsahaRoom, mauritaniaRoom, maliRoom,
     nigerRoom,   chadRoom,     sudanRoom ]
  instanceObject: Decoration { 'sahara desert' 'Sahara Desert'
    "It<./s>s a harsh expanse of sand and baked rock, with hardly
      a rare oasis. "
  }
;
*/

africaCities: MultiLoc, Unthing
  name = 'cities'
  isPlural = true
  //desc = "No cities seem to be visible. "
  notHereMsg = 'No cities seem to be visible. '
  initialLocationClass = AfricaRoom
  //location
  vocabWords = 'cape
                dar
                (es)
                (el)
                porto
                port
                addis
                casablanca/
                rabat/
                marrakech/marrakesh
                algiers/
                tunis/
                carthage/
                tripoli/
                cairo/
                alexandria/
                giza/
                thebes/
                memphis/
                laayoune/la\u00E2youne/el-aaiun/aaiun/el-aai\u00FAn/aai\u00FAn/
                nouakchott/
                bamako/
                timbuktu/tombouctou/timbuctu/timbuctoo/tumbutu/
                niamey/
                ndjamena/
                n\'djamena/
                khartoum/
                juba/
                omdurman/
                asmara/asmera/
                ababa/abeba/
                mogadishu/
                dakar/
                banjul/
                conakry/konakry/
                freetown/
                monrovia/
                yamoussoukro/
                abidjan/
                ouagadougou/
                accra/
                lome/lom\u00E9/
                novo/hogbonou/adjace/adjac\u00E9/
                abuja/
                lagos/
                kano/
                ibadan/
                kaduna/
                harcourt/
                yaounde/yaound\u00E9/
                douala/
                malabo/
                bata/
                libreville/
                brazzaville/
                bangui/
                kinshasa/
                lubumbashi/elisabethville/elizabethville/
                kampala/
                nairobi/
                kigali/
                bujumbura/
                salaam/
                dar-es-salaam/mzizima/
                dodoma/
                luanda/loanda/
                lusaka/
                lilongwe/
                blantyre/
                maputo/
                windhoek/windhuk/
                gaborone/
                harare/salisbury/
                mbabane/
                lobamba/
                pretoria/
                bloemfontein/
                johannesburg/
                soweto/
                town/
                durban/
                maseru/
                city*cities*ports'
  //vocabWords = 'Cape
  //              Dar
  //              es
  //              Porto
  //              Addis
  //              Casablanca/
  //              Rabat/
  //              Marrakech/
  //              Algiers/
  //              Tunis/
  //              Tripoli/
  //              Cairo/
  //              Alexandria/
  //              Laayoune/
  //              L\'ayoune/
  //              Nouakchott/
  //              Bamako/
  //              Niamey/
  //              Ndjamena/
  //              N\'djamena/
  //              Khartoum/
  //              Asmara/
  //              Ababa/
  //              Mogadishu/
  //              Dakar/
  //              Banjul/
  //              Conakry/
  //              Freetown/
  //              Monrovia/
  //              Yamoussoukro/
  //              Ouagadougou/
  //              Accra/
  //              Lome/
  //              Novo/
  //              Abuja/
  //              Yaounde/
  //              Malabo/
  //              Libreville/
  //              Brazzaville/
  //              Bangui/
  //              Kinshasa/
  //              Kampala/
  //              Nairobi/
  //              Kigali/
  //              Bujumbura/
  //              Salaam/
  //              Dar-es-Salaam/
  //              Zanzibar/
  //              Luanda/
  //              Lusaka/
  //              Lilongwe/
  //              Maputo/
  //              Windhoek/
  //              Gaborone/
  //              Harare/
  //              Mbabane/
  //              Pretoria/
  //              Johannesburg/
  //              Town/
  //              Durban/
  //              Maseru'
;

//// djibouti is also the name of the capital
//bissau // not sure about that

// -------------------------------------------------------------------
// NATION MAZES: SCENERY: MEXICO SCENERY
// -------------------------------------------------------------------

africaSign: Readable, Fixture
  '(tourist) engraved metal pole/sign/marker' 'sign'
  @gambiaRoom
  specialDesc = "There is a sign standing here. "
  desc {
    "A slender metal pole, embedded in the ground, rises and widens
        to form a handsome sign. In engraved letters it reads:
      <p><.q>Dr. Livingstone, I presume? 
        Well, whoever you are, welcome to Africa. Africa is one of 
        Earth<./s>s continents, and was once divided into 48 
        <i>nations,</i> or independently goverened territories,
        plus one disputed region.
      <p><.q>Nowadays we tend to think of Africa
        as one of the few continents that stretches into the 
        Southern Hemisphere, and thus one of the few 
        that is still partially habitable.
        Back on ancient Earth, though, Africa was famous
        for much more than that, because Africa was 
        the setting of many great works of interactive fiction.
      <p><.q>Everyone knows about <i>Infidel</i> (Berlyn; 1983),
        Infocom<./s>s classic treasure hunt, set in the Egyptian desert.
        But did you know about games such as
        <i>African Adventure</i> (Fullerton & Russell; 1980) 
        and <i>Dark Continent</i> (Knopf; 1986)?
        Both of these games feature a delightful two-word parser, 
        and both are nicely unencumbered by plot.
      <p><.q>Now you must navigate through all the nations of this
        great continent. Can you do it?
        It might not be as easy as you think!<./q> ";
    hasBeenDescribed = true;
  }
  hasBeenDescribed = nil
;

mexicoSign: Readable, Fixture
  '(tourist) engraved metal pole/sign/marker' 'sign'
  @bajasurRoom
  specialDesc = "There is a sign standing here. "
  desc {
    "A slender metal pole, embedded in the ground, rises and widens
        to form a handsome sign. In engraved letters it reads:
      <p><i><.q>&iexcl;Hola, los jugadores!</i> Welcome to Mexico. 
      <p><.q>Mexico was one of the <i>nations</i> of ancient 
        Earth -- that is, it was an independently governed territory, 
        and was divided into 31 <i>states,</i> plus one 
        <i>federal district.</i> 
      <p><.q>Of all the things Mexico is known for, 
        surely the greatest is its prominence in several 
        works of interactive fiction. By no means is 
        <i>Ruins II: The Reliques of Chich&eacute;n Itz&aacute;</i> 
        (Graham Nelson; 2039) the only example. 
        No indeed, Mexico is famous as the setting 
        of many other games, from <i>The Mask of the Sun</i> 
        (Ultrasoft; 1982) to <i>Raiders of the Star Temple</i> 
        (Conrad Knopf; 1989) -- to say nothing of the 
        <i>Leyendas de Ci-U-Than</i> series (Aventuras AD; 1990-91). 
      <p><.q>But it is not enough to recognize Mexico 
        as a powerful source of inspiration for IF.
        Now you must navigate through all its subdivisions.
        Can you do it? It might not be as easy as you think!<./q> ";
    hasBeenDescribed = true;
  }
  hasBeenDescribed = nil
;






class MexicanDecoration: MultiLoc, Decoration
  //notImportantMsg =
  //  'Sheila says, <.q>I get the feeling I don<./s>t need
  //    to spend a lot of time worrying specifically about '
  //    + theName + '.<./q> '
;

// Mountains

class MexicanMountains: MexicanDecoration
  isPlural = true
  //dobjFor(ClimbUp) {
  //  verify { }
  //  check {
  //    "Sheila says, <.q>I get the feeling that I don<./s>t 
  //      need to spend a lot of time climbing up these
  //      mountains.<./q> ";
  //    exit;
  //  }
  //}
  //dobjFor(Climb) asDobjFor(ClimbUp)
;

sierraMadreOccidental: MexicanMountains
  '(tall) rugged sierra madre occidental range (chain) mountain (mt) mount peak hill *mountains*mounts*peaks*hills'
  'Sierra Madre Occidental'
  locationList = [
    sonoraRoom, chihuahuaRoom, sinaloaRoom, durangoRoom, 
    nayaritRoom, zacatecasRoom, jaliscoRoom, colimaRoom, 
    michoacanRoom
  ]
  aName = theName
  desc {
    "The mountains of the Sierra Madre Occidental run through ";
    switch (bot.getOutermostRoom) {
      case sonoraRoom:
      case sinaloaRoom:
        "the eastern part of "; break;
      case chihuahuaRoom:
      case durangoRoom:
      case zacatecasRoom:
        "the western part of "; break;
      case michoacanRoom:
        "the northern part of "; break;
    }
    "this region, tall and rugged. ";
  }
;

sierraMadreOriental: MexicanMountains
  '(tall) rugged sierra madre oriental range (chain) mountain (mt) mount peak hill *mountains*mounts*peaks*hills'
  'Sierra Madre Oriental'
  locationList = [
    coahuilaRoom, nuevoleonRoom, tamaulipasRoom, sanluisRoom, 
    queretaroRoom, hidalgoRoom, pueblaRoom, veracruzRoom
  ]
  aName = theName
  desc {
    "The mountains of the Sierra Madre Oriental run through ";
    switch (bot.getOutermostRoom) {
      case coahuilaRoom:
      case sanluisRoom:
      case queretaroRoom:
        "the eastern part of "; break;
      case pueblaRoom:
      case veracruzRoom:
        "the northern part of "; break;
    }
    "this region, tall and rugged. ";
  }
;

// &aacute; = \u00E1
// &eacute; = \u00E9
// &iacute; = \u00ED
// &oacute; = \u00F3
// &uacute; = \u00FA
// &yacute; = \u00FD
// &ntilde; = \u00F1
// &uuml;   = \u00FC
// &iquest; = \u00BF
// &iexcl;  = \u00A1
volcanicMountains: MexicanMountains
  '(tall) rugged volcanic range (chain) volcano mountain (mt) mount peak hill 
    citlalt\u00E9petl popocat\u00E9petl iztacc\u00EDhuatl
    citlaltepetl popocatepetl iztaccihuatl
    ixtacc\u00EDhuatl ixtaccihuatl (el) popo (don) goyo pico (de) orizaba
    *mountains*mounts*peaks*hills*volcanos*volcanoes'
  'volcanic mountains'
  // Citlaltepetl, Popocatepetl, and Iztaccihuatl are not 
  // in all of the rooms named here. But whatever, close enough.
  locationList = [
    distritoRoom, morelosRoom, tlaxcalaRoom, veracruzRoom, 
    michoacanRoom, mexicoRoom, pueblaRoom
  ]
  desc {
    switch (bot.getOutermostRoom) {
      case distritoRoom:
      case morelosRoom:
      case tlaxcalaRoom:
        "This region is filled with a number of "; break;
      case veracruzRoom:
        "The central part of this region is scattered with "; break;
      case michoacanRoom:
        "The eastern part of this region is scattered with "; break;
      case mexicoRoom:
        "Around the fringes of this region are "; break;
      case pueblaRoom:
        "The southern part of this region is scattered with "; break;
    }
    "rugged mountains, some of which look like they might be volcanic. ";
  }
;

sierraMadreDelSur: MexicanMountains
  '(tall) rugged sierra madre (del) (de) (el) sur range (chain) mountain (mt) mount peak hill *mountains*mounts*peaks*hills'
  'Sierra Madre del Sur'
  locationList = [
    guerreroRoom, oaxacaRoom
  ]
  aName = theName
  desc {
    "The mountains of the Sierra Madre del Sur run through here ";
    if (bot.getOutermostRoom == guerreroRoom)
      "and to the east, ";
    else
      "and to the west, ";
    "tall and rugged. ";
  }
;

bajaMountains: MexicanMountains
  '(tall) rugged range (chain) mountain (mt) mount peak hill *mountains*mounts*peaks*hills'
  'mountains'
  locationList = [
    bajacaliRoom, bajasurRoom
  ]
  desc {
    "A mountain range runs through here ";
    if (bot.getOutermostRoom == bajacaliRoom)
      "and to the south, ";
    else
      "and to the north, ";
    "tall and rugged. ";
  }
;

mexicanUnmountains: MultiLoc, Unthing
  '(tall) (rugged) range (chain) mountain (mt) mount peak hill *mountains*mounts*peaks*hills'
  'mountains'
  locationList = [
    aguascalRoom, campecheRoom, chiapasRoom, guanajuatoRoom, 
    quintanaRoom, tabascoRoom, yucatanRoom
  ]
  isPlural = true
  notHereMsg = 'Your bot fails to notice any prominent mountains 
    in this region. '
;

// Plateaus

mexicanPlateau: MexicanDecoration
  '(mexican) plateau*plateaus*plateaux'
  'plateau'
  locationList = [
    chihuahuaRoom, coahuilaRoom, durangoRoom, zacatecasRoom, 
    sanluisRoom, jaliscoRoom, aguascalRoom, guanajuatoRoom, 
    queretaroRoom
  ]
  desc {
    "A large plateau takes up ";
    switch (bot.getOutermostRoom) {
      case durangoRoom:
      case zacatecasRoom:
      case jaliscoRoom:
        "the eastern part of "; break;
      case coahuilaRoom:
      case queretaroRoom:
      case sanluisRoom:
        "the western part of "; break;
      //case chihuahuaRoom:
      //case aguascalRoom:
      //case guanajuatoRoom:
      default:
        "most of "; break;
    }
    "this region. ";
  }
;

mexicanUnplateau: MultiLoc, Unthing
  '(mexican) plateau*plateaus*plateaux'
  'plateau'
  initialLocationClass = MexicanRoom
  isInitiallyIn(obj) {
    if (mexicanPlateau.locationList.indexOf(obj))
      return nil;
    if (!obj || !obj.ofKind(MexicanRoom))
      return nil;
    else
      return true;
  }
  notHereMsg = 'Your bot fails to notice any prominent plateau
    in this region. '
;

sonoranDesert: MexicanDecoration
  'sonoran dry arid desert'
  'Sonoran Desert'
  locationList = [
    bajasurRoom, bajacaliRoom, sonoraRoom
  ]
  desc {
    "The dry Sonoran Desert takes up ";
    switch (bot.getOutermostRoom) {
      //case sonoraRoom:
      //  "the western part of "; break;
      default:
        "most of "; break;
    }
    "this region. ";
  }
;

chihuahuanDesert: MexicanDecoration
  'chihuahuan dry arid desert'
  'Chihuahuan Desert'
  locationList = [
    chihuahuaRoom, coahuilaRoom, durangoRoom, zacatecasRoom
  ]
  desc {
    "The dry Chihuahuan Desert takes up ";
    switch (bot.getOutermostRoom) {
      case chihuahuaRoom:
        "the eastern part of "; break;
      case coahuilaRoom:
        "most of "; break;
      case durangoRoom:
        "the northeastern part of "; break;
      case zacatecasRoom:
        "the northern part of "; break;
    }
    "this region. ";
  }
;

mexicanUndesert: MultiLoc, Unthing
  'desert'
  '(dry) (arid) desert'
  initialLocationClass = MexicanRoom
  isInitiallyIn(obj) {
    if (sonoranDesert.locationList.indexOf(obj))
      return nil;
    if (chihuahuanDesert.locationList.indexOf(obj))
      return nil;
    if (!obj || !obj.ofKind(MexicanRoom))
      return nil;
    else
      return true;
  }
  notHereMsg = 'Some parts of this region may be drier than others,
    but your bot fails to notice any outright desert here. '
;

mexicanUnforest: MultiLoc, Unthing
  'forest/woods/forests'
  'forest'
  initialLocationClass = MexicanRoom
  notHereMsg = 'There may be some scattered trees here,
    but no forest that stands out as noteworthy. '
;

mexicanUnplains: MultiLoc, Unthing
  'plain/plains'
  'plains'
  initialLocationClass = MexicanRoom
  notHereMsg = 'There may be sections of flat plains in this region,
    but nothing that particularly stands out as noteworthy. '
  isPlural = true
;

mexicanUnvalley: MultiLoc, Unthing
  'valley/valleys'
  'valley'
  initialLocationClass = MexicanRoom
  notHereMsg = 'There may be a valley or two in this region, but
    nothing that stands out as noteworthy. '
;

hotSprings: Decoration
  'hot spring/springs'
  'hot springs'
  @aguascalRoom
  "Numerous hot springs are scattered throughout this region. "
  isPlural = true
;

// Peninsulas

bajaPeninsula: MexicanDecoration
  '(baja) (california) peninsula'
  'Baja California Peninsula'
  locationList = [bajacaliRoom, bajasurRoom]
  aName = theName
  desc = "The Baja California Peninsula lies here, separating 
    the Gulf of California and the Pacific Ocean. "
;

yucatanPeninsula: MexicanDecoration
  '(yucat\u00E1n) (yucatan) peninsula'
  'Yucat\u00E1n Peninsula'
  locationList = [
    campecheRoom, yucatanRoom, quintanaRoom
  ]
  aName = theName
  desc = "The Yucat\u00E1n Peninsula lies here, separating
    the Gulf of Mexico and the Caribbean Sea. "
;

// Bodies of water

pacificOcean: MexicanDecoration
  'pacific ocean/sea/coast/shore/beach/water'
  'Pacific Ocean'
  locationList = [
    bajasurRoom, bajacaliRoom, sonoraRoom, sinaloaRoom, 
    nayaritRoom, jaliscoRoom, colimaRoom, michoacanRoom, 
    guerreroRoom, oaxacaRoom, chiapasRoom
  ]
  aName = theName
  desc {
    "The Pacific Ocean lies here to the ";
    switch (bot.getOutermostRoom) {
      case sonoraRoom :
      case nayaritRoom:
      case jaliscoRoom: "west. ";      break;
      case oaxacaRoom : "south. ";     break;
      default         : "southwest. "; break;
    }
  }
;

gulfOfMexico: MexicanDecoration
  '(mexico) atlantic gulf/sea/ocean/coast/shore/beach/water'
  'Gulf of Mexico'
  locationList = [
    tamaulipasRoom, veracruzRoom, tabascoRoom, campecheRoom, 
    yucatanRoom
  ]
  aName = theName
  desc {
    "The Gulf of Mexico lies here to the ";
    switch (bot.getOutermostRoom) {
      case tamaulipasRoom: "east. ";      break;
      case veracruzRoom  : "northeast. "; break;
      case campecheRoom  : "northwest. "; break;
      default            : "southwest. "; break;
    }
  }
;

gulfOfCalifornia: MexicanDecoration
  '(california) gulf/water'
  'Gulf of California'
  locationList = [
    bajasurRoom, bajacaliRoom, sonoraRoom, sinaloaRoom
  ]
  aName = theName
  desc {
    "The Gulf of California lies here to the ";
    switch (bot.getOutermostRoom) {
      case bajasurRoom : "east. "; break;
      default          : "west. "; break;
    }
  }
;

caribbeanSea: MexicanDecoration
  'caribbean atlantic ocean/sea/coast/shore/beach/water'
  'Caribbean Sea'
  locationList = [
    quintanaRoom
  ]
  aName = theName
  desc {
    "The Caribbean Sea lies here to the east. ";
  }
;

rioGrandeRiver: MexicanDecoration
  'rio grande river -'
  'Rio Grande River'
  locationList = [
    chihuahuaRoom, coahuilaRoom, nuevoleonRoom, tamaulipasRoom
  ]
  aName = theName
  desc {
    "The Rio Grande River lies on the northern boundary
      of this region, flowing peacefully eastward. ";
  }
;

coloradoRiver: MexicanDecoration
  'colorado river -'
  'Colorado River'
  locationList = [
    bajacaliRoom, sonoraRoom
  ]
  aName = theName
  desc {
    "The Colorado River flows here along the
      north<<bot.getOutermostRoom == sonoraRoom ? 'west' : 'east'>>ern
      boundary for a short distance before emptying into the 
      Gulf of California. ";
  }
;

// Cities (and Cozumel Island)

class MexicanCity: Unthing
  isProperName = true
  desc = "\^<<name>> is nowhere to be seen, but you know that it
    used to stand upon this very spot. "
;

cozumel: MexicanDecoration
  'cozumel island/city/site*cities*sites'
  'Cozumel Island'
  @quintanaRoom
  "The island of Cozumel lies here to the east, just off the coast. "
  isProperName = true
;

acapulco: MexicanCity
  'acapulco (de) (juarez) (ju\u00E1rez) city/site*cities*sites'
  'Acapulco'
  @guerreroRoom
  isProperName = true
;
cancun: MexicanCity
  'cancun canc\u00FAn city/site*cities*sites'
  'Canc\u00FAn'
  @quintanaRoom
  isProperName = true
;
mexicoCity: MexicanCity
  'tenochtitlan ciudad (de) (d.f.) (df) (mexico) (m\u00E9xico) city/site*cities*sites'
  'Mexico City'
  @distritoRoom
  "\^<<name>> is nowhere to be seen. However, right about 
    in the place where it once stood, you see a star-shaped 
    memorial embedded in the ground. "
  isProperName = true
;
chichenItza: MexicanCity
  'chichen itza chich\u00E9n itz\u00E1 city/site*cities*sites'
  'Chich\u00E9n Itz\u00E1'
  @yucatanRoom
  isProperName = true
;
uxmal: MexicanCity
  'uxmal city/site*cities*sites'
  'Uxmal'
  @yucatanRoom
  isProperName = true
;

distritoMemorial: Readable, Fixture
  'star-shaped star shaped shiny stone surface/memorial/monument'
  'star-shaped memorial'
  @distritoRoom
  "The memorial lies flat along the ground, and is a star-shaped
      surface of shiny stone. In engraved letters it reads:
    <p><.q>Why did Tenochtitlan leave our lexicons?
      <br>That<./s>s nobody<./s>s business but the Mexicans<./s>.<./q> "
  specialDesc = "There is a star-shaped memorial embedded 
    in the ground here. "
;

mexicanCities: MultiLoc, Unthing
  name = 'cities'
  isPlural = true
  //desc = "No cities seem to be visible. "
  notHereMsg = 'No cities seem to be visible. '
  initialLocationClass = MexicanRoom
  // Leon is omitted because its name is too similar to Nuevo Leon.
  // Acapulco, Cancun, Cozumel, Mexico City (Tenochtitlan),
  // Chichen Itza, and Uxmal are omitted because they are mentioned
  // in room descriptions and handled separately.
  vocabWords = 'ecatepec
                guadalajara
                tijuana
                ciudad juarez ju\u00E1rez
                nezahualcoyotl nezahualc\u00F3yotl
                zapopan
                monterrey
                naucalpan
                mexicali
                guadalupe
                merida m\u00E9rida
                tlalnepantla
                chimalhuacan
                saltillo
                morelia
                hermosillo
                tlaquepaque
                culiacan culiac\u00E1n
                tuxtla gutierrez guti\u00E9rrez
                toluca
                xalapa
                villahermosa
                cuernavaca
                tepic
                pachuca
                chilpancingo
                chetumal
                (la) paz
                santiago (de) (queretaro)
                victoria' //ciudad victoria
                //leon le\u00F3n
;



// -------------------------------------------------------------------
// NATION MAZES: MAPS: FUNCTIONS: AFRICA MAP FUNCTIONS
// -------------------------------------------------------------------

modify glob
  hackNationMaps = nil
;

function afrImg(num, c1, c2) {
  local str = 'africa/af';
  str = str + num;
  if (glob.hackNationMaps == true) {
    str = str + 'xx';
  }
  else {
    if (( c1.beenThere) && ( c2.beenThere)) str = str + 'xx';
    if (( c1.beenThere) && (!c2.beenThere)) str = str + 'x-';
    if ((!c1.beenThere) && ( c2.beenThere)) str = str + '-x';
    if ((!c1.beenThere) && (!c2.beenThere)) str = str + '&#45;&#45;';
  }
  str = str + '.png';
  return str;
}

function afrIm3(num, c1, c2, c3) {
  local str = 'africa/af';
  str = str + num;
  if (glob.hackNationMaps == true) {
    str = str + 'xxx';
  }
  else {
    if (( c1.beenThere) && ( c2.beenThere) && ( c3.beenThere)) str = str + 'xxx';
    if (( c1.beenThere) && ( c2.beenThere) && (!c3.beenThere)) str = str + 'xx-';
    if (( c1.beenThere) && (!c2.beenThere) && ( c3.beenThere)) str = str + 'x-x';
    if (( c1.beenThere) && (!c2.beenThere) && (!c3.beenThere)) str = str + 'x&#45;&#45;';
    if ((!c1.beenThere) && ( c2.beenThere) && ( c3.beenThere)) str = str + '-xx';
    if ((!c1.beenThere) && ( c2.beenThere) && (!c3.beenThere)) str = str + '-x-';
    if ((!c1.beenThere) && (!c2.beenThere) && ( c3.beenThere)) str = str + '&#45;&#45;x';
    if ((!c1.beenThere) && (!c2.beenThere) && (!c3.beenThere)) str = str + '&#45;&#45;&#45;';
  }
  str = str + '.png';
  return str;
}

function afrImg001() { return afrImg('001', moroccoRoom   , westsahaRoom  ); }
function afrImg002() { return afrImg('002', moroccoRoom   , algeriaRoom   ); }
function afrImg003() { return afrImg('003', algeriaRoom   , tunisiaRoom   ); }
function afrImg004() { return afrImg('004', tunisiaRoom   , libyaRoom     ); }
function afrImg005() { return afrImg('005', libyaRoom     , egyptRoom     ); }
function afrImg006() { return afrImg('006', westsahaRoom  , mauritaniaRoom); }
function afrImg007() { return afrImg('007', algeriaRoom   , mauritaniaRoom); }
function afrImg008() { return afrImg('008', mauritaniaRoom, maliRoom      ); }
function afrImg009() { return afrImg('009', algeriaRoom   , maliRoom      ); }
function afrImg010() { return afrImg('010', algeriaRoom   , libyaRoom     ); }
function afrImg011() { return afrImg('011', algeriaRoom   , nigerRoom     ); }
function afrImg012() { return afrImg('012', libyaRoom     , nigerRoom     ); }
function afrImg013() { return afrImg('013', libyaRoom     , chadRoom      ); }
function afrImg014() { return afrImg('014', nigerRoom     , chadRoom      ); }
function afrImg015() { return afrImg('015', libyaRoom     , chadRoom      ); }
function afrImg016() { return afrImg('016', libyaRoom     , sudanRoom     ); }
function afrImg017() { return afrImg('017', egyptRoom     , sudanRoom     ); }
function afrImg018() { return afrImg('018', mauritaniaRoom, senegalRoom   ); }
function afrImg019() { return afrImg('019', gambiaRoom    , senegalRoom   ); }
function afrImg020() { return afrImg('020', senegalRoom   , guinbissRoom  ); }
function afrImg021() { return afrImg('021', guinbissRoom  , guineaRoom    ); }
function afrImg022() { return afrImg('022', mauritaniaRoom, maliRoom      ); }
function afrImg023() { return afrImg('023', maliRoom      , burkfasoRoom  ); }
function afrImg024() { return afrImg('024', maliRoom      , guineaRoom    ); }
function afrImg025() { return afrImg('025', maliRoom      , burkfasoRoom  ); }
function afrImg026() { return afrImg('026', burkfasoRoom  , ghanaRoom     ); }
function afrImg027() { return afrImg('027', maliRoom      , nigerRoom     ); }
function afrImg028() { return afrImg('028', burkfasoRoom  , nigerRoom     ); }
function afrImg029() { return afrImg('029', burkfasoRoom  , beninRoom     ); }
function afrImg030() { return afrImg('030', nigerRoom     , nigeriaRoom   ); }
function afrImg031() { return afrImg('031', nigerRoom     , chadRoom      ); }
function afrImg032() { return afrImg('032', nigeriaRoom   , chadRoom      ); }
function afrImg033() { return afrImg('033', nigeriaRoom   , cameroonRoom  ); }
function afrImg034() { return afrImg('034', chadRoom      , chadRoom      ); }
function afrImg035() { return afrImg('035', chadRoom      , sudanRoom     ); } // 2016-10-29: Same variables, though the images have changed
function afrImg036() { return afrImg('036', sudanRoom     , eritreaRoom   ); }
function afrImg037() { return afrImg('037', guineaRoom    , sierleonRoom  ); }
function afrImg038() { return afrImg('038', sierleonRoom  , liberiaRoom   ); }
function afrImg039() { return afrImg('039', guineaRoom    , liberiaRoom   ); }
function afrImg040() { return afrImg('040', guineaRoom    , ivorcoasRoom  ); }
function afrImg041() { return afrImg('041', liberiaRoom   , ivorcoasRoom  ); }
function afrImg042() { return afrImg('042', ivorcoasRoom  , burkfasoRoom  ); }
function afrImg043() { return afrImg('043', ivorcoasRoom  , ghanaRoom     ); }
function afrImg044() { return afrImg('044', ghanaRoom     , togoRoom      ); }
function afrImg045() { return afrImg('045', togoRoom      , beninRoom     ); }
function afrImg046() { return afrImg('046', beninRoom     , nigeriaRoom   ); }
function afrImg047() { return afrImg('047', nigeriaRoom   , cameroonRoom  ); }
function afrImg048() { return afrImg('048', cameroonRoom  , chadRoom      ); }
function afrImg049() { return afrImg('049', cameroonRoom  , centafriRoom  ); }
function afrImg050() { return afrImg('050', chadRoom      , centafriRoom  ); }
function afrImg051() { return afrImg('051', centafriRoom  , demorepuRoom  ); }
function afrImg052() { return afrImg('052', centafriRoom  , congoRoom     ); }
function afrImg053() { return afrIm3('053', centafriRoom  , sudanRoom     , southsudanRoom); } // 2016-10-29: Changed for South Sudan
function afrImg054() { return afrImg('054', centafriRoom  , demorepuRoom  ); }
function afrImg055() { return afrIm3('055', sudanRoom     , southsudanRoom, demorepuRoom  ); } // 2016-10-29: Changed for South Sudan
function afrImg056() { return afrIm3('056', sudanRoom     , southsudanRoom, ethiopiaRoom  ); } // 2016-10-29: Changed for South Sudan
function afrImg057() { return afrImg('057', ethiopiaRoom  , eritreaRoom   ); }
function afrImg058() { return afrImg('058', ethiopiaRoom  , djiboutiRoom  ); }
function afrImg059() { return afrImg('059', ethiopiaRoom  , kenyaRoom     ); }
function afrImg060() { return afrImg('060', djiboutiRoom  , somaliaRoom   ); }
function afrImg061() { return afrImg('061', ethiopiaRoom  , somaliaRoom   ); }
function afrImg062() { return afrImg('062', equaguinRoom  , gabonRoom     ); }
function afrImg063() { return afrImg('063', gabonRoom     , congoRoom     ); }
function afrImg064() { return afrImg('064', congoRoom     , demorepuRoom  ); }
function afrImg065() { return afrImg('065', gabonRoom     , congoRoom     ); }
function afrImg066() { return afrImg('066', congoRoom     , demorepuRoom  ); }
function afrImg067() { return afrImg('067', congoRoom     , demorepuRoom  ); } // 2016-10-29: Same variables, though the images have changed
function afrImg068() { return afrImg('068', demorepuRoom  , ugandaRoom    ); }
function afrImg069() { return afrImg('069', rwandaRoom    , tanzaniaRoom  ); }
function afrImg070() { return afrImg('070', burundiRoom   , tanzaniaRoom  ); }
function afrImg071() { return afrImg('071', southsudanRoom, ugandaRoom    ); } // 2016-10-29: Changed for South Sudan. Same images, new variables.
function afrImg072() { return afrImg('072', southsudanRoom, kenyaRoom     ); } // 2016-10-29: Changed for South Sudan. Same images, new variables.
function afrImg073() { return afrImg('073', ugandaRoom    , kenyaRoom     ); }
function afrImg074() { return afrImg('074', kenyaRoom     , tanzaniaRoom  ); }
function afrImg075() { return afrImg('075', kenyaRoom     , somaliaRoom   ); }
function afrImg076() { return afrImg('076', kenyaRoom     , tanzaniaRoom  ); }
function afrImg077() { return afrImg('077', demorepuRoom  , angolaRoom    ); }
function afrImg078() { return afrImg('078', demorepuRoom  , tanzaniaRoom  ); }
function afrImg079() { return afrImg('079', demorepuRoom  , zambiaRoom    ); }
function afrImg080() { return afrImg('080', tanzaniaRoom  , zambiaRoom    ); }
function afrImg081() { return afrImg('081', zambiaRoom    , malawiRoom    ); }
function afrImg082() { return afrImg('082', tanzaniaRoom  , malawiRoom    ); }
function afrImg083() { return afrImg('083', tanzaniaRoom  , mozambiqueRoom); }
function afrImg084() { return afrImg('084', angolaRoom    , namibiaRoom   ); }
function afrImg085() { return afrImg('085', angolaRoom    , zambiaRoom    ); }
function afrImg086() { return afrImg('086', namibiaRoom   , botswanaRoom  ); }
function afrImg087() { return afrImg('087', zambiaRoom    , zimbabweRoom  ); }
function afrImg088() { return afrImg('088', zambiaRoom    , botswanaRoom  ); }
function afrImg089() { return afrImg('089', zambiaRoom    , zimbabweRoom  ); }
function afrImg090() { return afrImg('090', zambiaRoom    , mozambiqueRoom); }
function afrImg091() { return afrImg('091', zimbabweRoom  , mozambiqueRoom); }
function afrImg092() { return afrImg('092', malawiRoom    , mozambiqueRoom); }
function afrImg093() { return afrImg('093', malawiRoom    , mozambiqueRoom); }
function afrImg094() { return afrImg('094', namibiaRoom   , botswanaRoom  ); }
function afrImg095() { return afrImg('095', botswanaRoom  , zimbabweRoom  ); }
function afrImg096() { return afrImg('096', zimbabweRoom  , mozambiqueRoom); }
function afrImg097() { return afrImg('097', namibiaRoom   , soutafriRoom  ); }
function afrImg098() { return afrImg('098', botswanaRoom  , soutafriRoom  ); }
function afrImg099() { return afrImg('099', zimbabweRoom  , soutafriRoom  ); }
function afrImg100() { return afrImg('100', soutafriRoom  , mozambiqueRoom); }
function afrImg101() { return afrImg('101', swazilandRoom , swazilandRoom ); }
function afrImg102() { return afrImg('102', soutafriRoom  , lesothoRoom   ); }
function afrImg103() { return afrImg('103', demorepuRoom  , tanzaniaRoom  ); }
function afrImg104() { return afrImg('104', angolaRoom    , namibiaRoom   ); }
function afrImg105() { return afrImg('105', swazilandRoom , mozambiqueRoom); }
function afrImg106() { return afrImg('106', soutafriRoom  , soutafriRoom  ); }


// Outdated lines of code due to South Sudan and/or "ZR -> CD":
//function afrImg053() { return afrImg('053', centafriRoom  , sudanRoom     ); }
//function afrImg055() { return afrImg('055', sudanRoom     , demorepuRoom  ); }
//function afrImg056() { return afrImg('056', sudanRoom     , ethiopiaRoom  ); }
//function afrImg071() { return afrImg('071', sudanRoom     , ugandaRoom    ); }
//function afrImg072() { return afrImg('072', sudanRoom     , kenyaRoom     ); }

// -------------------------------------------------------------------
// NATION MAZES: MAPS: FUNCTIONS: MEXICO MAP FUNCTIONS
// -------------------------------------------------------------------

function mexImg(num, c1, c2) {
  local str = 'mexico/mx';
  str = str + num;
  if (( c1.beenThere) && ( c2.beenThere)) str = str + 'xx';
  if (( c1.beenThere) && (!c2.beenThere)) str = str + 'x-';
  if ((!c1.beenThere) && ( c2.beenThere)) str = str + '-x';
  if ((!c1.beenThere) && (!c2.beenThere)) str = str + '&#45;&#45;';
  str = str + '.png';
  return str;
}

function mexImg01() { return mexImg('01', bajacaliRoom   , sonoraRoom     ); }
function mexImg02() { return mexImg('02', sonoraRoom     , chihuahuaRoom  ); }
function mexImg03() { return mexImg('03', chihuahuaRoom  , coahuilaRoom   ); }
function mexImg04() { return mexImg('04', chihuahuaRoom  , sinaloaRoom    ); }
function mexImg05() { return mexImg('05', coahuilaRoom   , zacatecasRoom  ); }
function mexImg06() { return mexImg('06', coahuilaRoom   , nuevoleonRoom  ); }
function mexImg07() { return mexImg('07', coahuilaRoom   , nuevoleonRoom  ); }
function mexImg08() { return mexImg('08', bajasurRoom    , sonoraRoom     ); }
function mexImg09() { return mexImg('09', sonoraRoom     , sinaloaRoom    ); }
function mexImg10() { return mexImg('10', sinaloaRoom    , durangoRoom    ); }
function mexImg11() { return mexImg('11', sinaloaRoom    , nayaritRoom    ); }
function mexImg12() { return mexImg('12', chihuahuaRoom  , durangoRoom    ); }
function mexImg13() { return mexImg('13', durangoRoom    , zacatecasRoom  ); }
function mexImg14() { return mexImg('14', coahuilaRoom   , zacatecasRoom  ); }
function mexImg15() { return mexImg('15', coahuilaRoom   , durangoRoom    ); }
function mexImg16() { return mexImg('16', durangoRoom    , zacatecasRoom  ); }
function mexImg17() { return mexImg('17', zacatecasRoom  , sanluisRoom    ); }
function mexImg18() { return mexImg('18', nuevoleonRoom  , sanluisRoom    ); }
function mexImg19() { return mexImg('19', nuevoleonRoom  , tamaulipasRoom ); }
function mexImg20() { return mexImg('20', durangoRoom    , nayaritRoom    ); }
function mexImg21() { return mexImg('21', durangoRoom    , zacatecasRoom  ); }
function mexImg22() { return mexImg('22', nayaritRoom    , jaliscoRoom    ); }
function mexImg23() { return mexImg('23', zacatecasRoom  , jaliscoRoom    ); }
function mexImg24() { return mexImg('24', zacatecasRoom  , aguascalRoom   ); }
function mexImg25() { return mexImg('25', zacatecasRoom  , sanluisRoom    ); }
function mexImg26() { return mexImg('26', zacatecasRoom  , jaliscoRoom    ); }
function mexImg27() { return mexImg('27', zacatecasRoom  , aguascalRoom   ); }
function mexImg28() { return mexImg('28', aguascalRoom   , jaliscoRoom    ); }
function mexImg29() { return mexImg('29', jaliscoRoom    , guanajuatoRoom ); }
function mexImg30() { return mexImg('30', zacatecasRoom  , sanluisRoom    ); }
function mexImg31() { return mexImg('31', sanluisRoom    , guanajuatoRoom ); }
function mexImg32() { return mexImg('32', guanajuatoRoom , queretaroRoom  ); }
function mexImg33() { return mexImg('33', queretaroRoom  , hidalgoRoom    ); }
function mexImg34() { return mexImg('34', tamaulipasRoom , sanluisRoom    ); }
function mexImg35() { return mexImg('35', tamaulipasRoom , tamaulipasRoom ); }
function mexImg36() { return mexImg('36', sanluisRoom    , queretaroRoom  ); }
function mexImg37() { return mexImg('37', hidalgoRoom    , veracruzRoom   ); }
function mexImg38() { return mexImg('38', veracruzRoom   , pueblaRoom     ); }
function mexImg39() { return mexImg('39', sanluisRoom    , veracruzRoom   ); }
function mexImg40() { return mexImg('40', jaliscoRoom    , colimaRoom     ); }
function mexImg41() { return mexImg('41', jaliscoRoom    , michoacanRoom  ); }
function mexImg42() { return mexImg('42', guanajuatoRoom , michoacanRoom  ); }
function mexImg43() { return mexImg('43', queretaroRoom  , mexicoRoom     ); }
function mexImg44() { return mexImg('44', michoacanRoom  , mexicoRoom     ); }
function mexImg45() { return mexImg('45', hidalgoRoom    , mexicoRoom     ); }
function mexImg46() { return mexImg('46', distritoRoom   , mexicoRoom     ); }
function mexImg47() { return mexImg('47', hidalgoRoom    , pueblaRoom     ); }
function mexImg48() { return mexImg('48', tlaxcalaRoom   , pueblaRoom     ); }
function mexImg49() { return mexImg('49', colimaRoom     , michoacanRoom  ); }
function mexImg50() { return mexImg('50', michoacanRoom  , guerreroRoom   ); }
function mexImg51() { return mexImg('51', mexicoRoom     , guerreroRoom   ); }
function mexImg52() { return mexImg('52', mexicoRoom     , morelosRoom    ); }
function mexImg53() { return mexImg('53', morelosRoom    , guerreroRoom   ); }
function mexImg54() { return mexImg('54', morelosRoom    , pueblaRoom     ); }
function mexImg55() { return mexImg('55', pueblaRoom     , guerreroRoom   ); }
function mexImg56() { return mexImg('56', pueblaRoom     , oaxacaRoom     ); }
function mexImg57() { return mexImg('57', guerreroRoom   , oaxacaRoom     ); }
function mexImg58() { return mexImg('58', tamaulipasRoom , veracruzRoom   ); }
function mexImg59() { return mexImg('59', pueblaRoom     , veracruzRoom   ); }
function mexImg60() { return mexImg('60', veracruzRoom   , chiapasRoom    ); }
function mexImg61() { return mexImg('61', veracruzRoom   , oaxacaRoom     ); }
function mexImg62() { return mexImg('62', veracruzRoom   , tabascoRoom    ); }
function mexImg63() { return mexImg('63', oaxacaRoom     , chiapasRoom    ); }
function mexImg64() { return mexImg('64', tabascoRoom    , chiapasRoom    ); }
function mexImg65() { return mexImg('65', tabascoRoom    , campecheRoom   ); }
function mexImg66() { return mexImg('66', campecheRoom   , yucatanRoom    ); }
function mexImg67() { return mexImg('67', yucatanRoom    , quintanaRoom   ); }

// -------------------------------------------------------------------
// NATION MAZES: MAPS: AFRICA MAP
// -------------------------------------------------------------------

function africaMapPrint() {
return
'<table border=0 cellspacing=0 cellpadding=0 width=0>
 <tr>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td><img src=\"' + afrImg001() + '\" border=0></td>
     <td><img src=\"' + afrImg002() + '\" border=0></td>
     <td><img src=\"' + afrImg003() + '\" border=0></td>
     <td><img src=\"' + afrImg004() + '\" border=0></td>
     <td><img src=\"' + afrImg005() + '\" border=0></td>
     <td><img src=\"africa/dotclear.jpg\" width=50 height=57 border=0></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td><img src=\"' + afrImg006() + '\" border=0></td>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td><img src=\"' + afrImg007() + '\" border=0></td>
       </tr>
       <tr>
        <td><img src=\"' + afrImg008() + '\" border=0></td>
       </tr>
      </table>
     </td>
     <td><img src=\"' + afrImg009() + '\" border=0></td>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td><img src=\"' + afrImg010() + '\" border=0></td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + afrImg011() + '\" border=0></td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + afrImg012() + '\" border=0></td>
                 <td><img src=\"' + afrImg013() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg014() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td><img src=\"' + afrImg015() + '\" border=0></td>
           <td><img src=\"' + afrImg016() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
     <td><img src=\"' + afrImg017() + '\" border=0></td>
     <td><img src=\"africa/dotclear.jpg\" width=50 height=51 border=0></td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td> 
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg018() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg019() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg022() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg023() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td><img src=\"' + afrImg027() + '\" border=0></td>
           <td><img src=\"' + afrImg031() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td>
                     <table border=0 cellspacing=0 cellpadding=0>
                      <tr>
                       <td>
                        <table border=0 cellspacing=0 cellpadding=0>
                         <tr>
                          <td><img src=\"' + afrImg020() + '\" border=0></td>
                         </tr>
                         <tr>
                          <td><img src=\"' + afrImg021() + '\" border=0></td>
                         </tr>
                        </table>
                       </td>
                       <td><img src=\"' + afrImg024() + '\" border=0></td>
                      </tr>
                     </table>
                    </td>
                   </tr>
                   <tr>
                    <td>
                     <table border=0 cellspacing=0 cellpadding=0>
                      <tr>
                       <td>
                        <table border=0 cellspacing=0 cellpadding=0>
                         <tr>
                          <td><img src=\"' + afrImg037() + '\" border=0></td>
                         </tr>
                         <tr>
                          <td>
                           <table border=0 cellspacing=0 cellpadding=0>
                            <tr>
                             <td><img src=\"' + afrImg038() + '\" border=0></td>
                             <td><img src=\"' + afrImg039() + '\" border=0></td>
                            </tr>
                           </table>
                          </td>
                         </tr>
                        </table>
                       </td>
                       <td>
                        <table border=0 cellspacing=0 cellpadding=0>
                         <tr>
                          <td><img src=\"' + afrImg040() + '\" border=0></td>
                         </tr>
                         <tr>
                          <td><img src=\"' + afrImg041() + '\" border=0></td>
                         </tr>
                        </table>
                       </td>
                      </tr>
                     </table>
                    </td>
                   </tr>
                  </table>
                 </td>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg025() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg042() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg043() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg026() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg044() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg028() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg029() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td>
                     <table border=0 cellspacing=0 cellpadding=0>
                      <tr>
                       <td><img src=\"' + afrImg045() + '\" border=0></td>
                       <td><img src=\"' + afrImg046() + '\" border=0></td>
                      </tr>
                     </table>
                    </td>
                   </tr>
                  </table>
                 </td>
                </tr>
               </table>
              </td>
             </tr>
             <tr>
              <td><img src=\"africa/dotclear.jpg\" width=113 height=38 border=0></td>
             </tr>
            </table>
           </td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg030() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg047() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg062() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg063() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg032() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg033() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                 <td><img src=\"' + afrImg034() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg048() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg049() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg065() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"africa/dotclear.jpg\" width=113 height=9 border=0></td>
           <td><img src=\"' + afrImg064() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td><img src=\"' + afrImg035() + '\" border=0></td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg050() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg051() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg053() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg054() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td><img src=\"' + afrImg055() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg052() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg066() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td><img src=\"' + afrImg067() + '\" border=0></td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg068() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg069() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg070() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + afrImg036() + '\" border=0></td>
           <td><img src=\"africa/dotclear.jpg\" width=50 height=33 border=0></td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg056() + '\" border=0></td>
             </tr>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + afrImg071() + '\" border=0></td>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg072() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg073() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                </tr>
               </table>
              </td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg074() + '\" border=0></td>
             </tr>
            </table>
           </td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg057() + '\" border=0></td>
             </tr>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + afrImg058() + '\" border=0></td>
                 <td><img src=\"' + afrImg060() + '\" border=0></td>
                </tr>
                <tr>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg059() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg075() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                 <td><img src=\"' + afrImg061() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + afrImg076() + '\" border=0></td>
                 <td><img src=\"africa/dotclear.jpg\" width=50 height=18 border=0></td>
                </tr>
               </table>
              </td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
    </tr>
   </table>
  </td>
 </tr>
 <tr>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td><img src=\"africa/dotclear.jpg\" width=148 height=180 border=0></td>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg077() + '\" border=0></td>
             </tr>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + afrImg084() + '\" border=0></td>
                 <td><img src=\"' + afrImg085() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
            </table>
           </td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg078() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg079() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg087() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + afrImg104() + '\" border=0></td>
           <td><img src=\"' + afrImg086() + '\" border=0></td>
           <td><img src=\"' + afrImg088() + '\" border=0></td>
           <td><img src=\"' + afrImg089() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + afrImg094() + '\" border=0></td>
           <td><img src=\"' + afrImg095() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + afrImg097() + '\" border=0></td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + afrImg098() + '\" border=0></td>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg099() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg101() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                </tr>
               </table>
              </td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg102() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td><img src=\"' + afrImg103() + '\" border=0></td>
       </tr>
       <tr>
        <td><img src=\"' + afrImg080() + '\" border=0></td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + afrImg081() + '\" border=0></td>
                 <td><img src=\"' + afrImg082() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + afrImg090() + '\" border=0></td>
                   </tr>
                   <tr>
                    <td><img src=\"' + afrImg091() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                 <td><img src=\"' + afrImg092() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
            </table>
           </td>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + afrImg083() + '\" border=0></td>
             </tr>
             <tr>
              <td><img src=\"' + afrImg093() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
       </tr>
       <tr>
        <td><img src=\"' + afrImg096() + '\" border=0></td>
       </tr>
       <tr>
        <td><img src=\"' + afrImg100() + '\" border=0></td>
       </tr>
       <tr>
        <td><img src=\"' + afrImg105() + '\" border=0></td>
       </tr>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + afrImg106() + '\" border=0></td>
           <td><img src=\"africa/dotclear.jpg\" width=53 height=45 border=0></td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
     <td><img src=\"africa/dotclear.jpg\" width=50 height=180 border=0></td>
    </tr>
   </table>
  </td>
 </tr>
</table>';
}

// -------------------------------------------------------------------
// NATION MAZES: MAPS: MEXICO MAP
// -------------------------------------------------------------------

function mexicoMapPrint() {
return '<table border=0 cellspacing=0 cellpadding=0 width=395>
 <tr>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + mexImg01() + '\" border=0></td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg08() + '\" border=0></td>
          </tr>
         </table>
        </td>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + mexImg02() + '\" border=0></td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg09() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td><img src=\"mexico/dotclear.png\" border=0 width=104 height=118></td>
    </tr>
   </table>
  </td>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td><img src=\"' + mexImg03() + '\" border=0></td>
    </tr>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg04() + '\" border=0></td>
              <td><img src=\"' + mexImg12() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg10() + '\" border=0></td>
              <td><img src=\"' + mexImg13() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + mexImg15() + '\" border=0></td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg16() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg11() + '\" border=0></td>
              <td><img src=\"' + mexImg20() + '\" border=0></td>
              <td><img src=\"' + mexImg21() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg22() + '\" border=0></td>
          </tr>
         </table>
        </td>
        <td><img src=\"' + mexImg23() + '\" border=0></td>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + mexImg24() + '\" border=0></td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg26() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td><img src=\"' + mexImg40() + '\" border=0></td>
        <td><img src=\"' + mexImg41() + '\" border=0></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td><img src=\"' + mexImg49() + '\" border=0></td>
    </tr>
   </table>
  </td>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg05() + '\" border=0></td>
              <td><img src=\"' + mexImg06() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + mexImg14() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg17() + '\" border=0></td>
                </tr>
               </table>
              </td>
              <td><img src=\"' + mexImg18() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td><img src=\"' + mexImg07() + '\" border=0></td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg19() + '\" border=0></td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td><img src=\"' + mexImg25() + '\" border=0></td>
        <td><img src=\"' + mexImg34() + '\" border=0></td>
        <td><img src=\"' + mexImg35() + '\" border=0></td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg27() + '\" border=0></td>
              <td><img src=\"' + mexImg30() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + mexImg28() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg29() + '\" border=0></td>
                </tr>
               </table>
              </td>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + mexImg31() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg32() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg42() + '\" border=0></td>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + mexImg43() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg44() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg50() + '\" border=0></td>
              <td><img src=\"' + mexImg51() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + mexImg36() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg33() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg45() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg46() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg52() + '\" border=0></td>
                </tr>
               </table>
              </td>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td><img src=\"' + mexImg39() + '\" border=0></td>
                    <td><img src=\"' + mexImg58() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                </tr>
                <tr>
                 <td>
                  <table border=0 cellspacing=0 cellpadding=0>
                   <tr>
                    <td>
                     <table border=0 cellspacing=0 cellpadding=0>
                      <tr>
                       <td><img src=\"' + mexImg37() + '\" border=0></td>
                      </tr>
                      <tr>
                       <td><img src=\"' + mexImg47() + '\" border=0></td>
                      </tr>
                     </table>
                    </td>
                    <td><img src=\"' + mexImg38() + '\" border=0></td>
                   </tr>
                  </table>
                 </td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg48() + '\" border=0></td>
                </tr>
               </table>
              </td>
              <td><img src=\"' + mexImg59() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td>
                  <img src=\"' + mexImg53() + '\" border=0><img src=\"' + mexImg54() + '\" border=0>
                 </td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg55() + '\" border=0></td>
                </tr>
               </table>
              </td>
              <td><img src=\"' + mexImg56() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
         </table>
        </td>
       </tr>
      </table>
     </td>
    </tr>
    <tr>
     <td><img src=\"' + mexImg57() + '\" border=0></td>
    </tr>
   </table>
  </td>
  <td>
   <table border=0 cellspacing=0 cellpadding=0>
    <tr>
     <td><img src=\"mexico/dotclear.png\" border=0 width=138 height=169></td>
    </tr>
    <tr>
     <td>
      <table border=0 cellspacing=0 cellpadding=0>
       <tr>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg61() + '\" border=0></td>
              <td>
               <table border=0 cellspacing=0 cellpadding=0>
                <tr>
                 <td><img src=\"' + mexImg62() + '\" border=0></td>
                </tr>
                <tr>
                 <td><img src=\"' + mexImg60() + '\" border=0></td>
                </tr>
               </table>
              </td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg63() + '\" border=0></td>
          </tr>
         </table>
        </td>
        <td>
         <table border=0 cellspacing=0 cellpadding=0>
          <tr>
           <td>
            <table border=0 cellspacing=0 cellpadding=0>
             <tr>
              <td><img src=\"' + mexImg65() + '\" border=0></td>
              <td><img src=\"' + mexImg66() + '\" border=0></td>
             </tr>
            </table>
           </td>
          </tr>
          <tr>
           <td><img src=\"' + mexImg64() + '\" border=0></td>
          </tr>
         </table>
        </td>
        <td><img src=\"' + mexImg67() + '\" border=0></td>
       </tr>
      </table>
     </td>
    </tr>
   </table>
  </td>
 </tr>
</table>';
}

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG
africaFixture: Fixture 'africa' 'africa' @gambiaRoom
  dobjFor(Default) {
    verify {
      illogical('You can<./s>t do that. ');
    }
  }
  dobjFor(Pow) {
    verify {
      logicalRank(150, 'intended for powing');
    }
  }
;
roots: Fixture 'alex haley roots -' 'roots' @gambiaRoom;
sombrero: Wearable 'sombrero' 'sombrero'
  @bajasurRoom
  "It<./s>s big. "
;
bigBrownBag: Thing 'big brown bag' 'big brown bag'
  @bajasurRoom
;
yucatanObj: Thing 'yucatan/yucat\u00E1n' 'yucat\u00E1n'
  @kitchen
  "It<./s>s a yucat\u00E1n. "
;
//pinata: Thing
//  vocabWords = 'pinata/pinyata/pi\u00F1ata'
//  name = 'pi\u00F1ata'
//  location = kitchen
//  desc = "The pi\u00F1ata is full of goodies and ready 
//    for someone to break it open. "
//;
africaTest: Room 'Africa test'
  desc {
    "This is an Africa test room.\b";
    africaMapPrint();
    "\b";
    "South takes you back to where you came from. North takes you to Egypt. ";
  }
  north = gambiaRoom
  northeast = kitchen
  south = kitchen
;

#endif // __DEBUG


