#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"
//#include "qtalk.h"
//Quip template "desc"? "reply"?;

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// SCOPE OF FILE
// ALIENS: CLASSES
// ALIENS: THE FIVE ALIENS (Neton, Ovan, assistant, old guard, young guard)
// ALIENS: SECONDARY CHARACTERISTICS
// ALIENS: POSSESSIONS
// ALIENS: COLLECTIVE GROUPS
// PRISONERS: CLASS
// PRISONERS: THE TWO PRISONERS
// PRISONERS: COLLECTIVE GROUP
// PRISONERS: SECONDARY CHARACTERISTICS
// PRISONERS: POSSESSIONS
// JUNK
// DEBUG STUFF

// -------------------------------------------------------------------
// SCOPE OF FILE
// -------------------------------------------------------------------

// Note: This file, 1npcs.t, is mainly for *intro-related* NPC code. 
// Most *endgame-related* NPC code is in 3npcs.t. Also, the conversation
// with Vicki and Diane is in 1cell.t.

// -------------------------------------------------------------------
// ALIENS: CLASSES
// -------------------------------------------------------------------

// The Npc class is given in 3npcs.t, since that class contains stuff 
// for NPC movement, a much bigger issue in the endgame than in the 
// intro.

class Alien: Npc
  isAlien = true
  isHim = true
  //isListed {
  //  if (!isInEndgame) return true;
  //  else return nil;
  //}
  //useSpecialDesc {
  //  if (!isInEndgame) return true;
  //  else return nil;
  //}
  //isListed() {
  //  if (curState.ofKind(AlienNorthwards)) return nil;
  //  else return true;
  //}
  //isListedInContents = isListed
  //  specialDesc = "<<TheDesc>> is infesting the nearby area with his evil presence. "
  purportedSpecies = alien
  npcDesc() {
    say(speciesDesc);
    say(alienDesc);
    //say(soiledDesc);
  }
  speciesDesc = "\^<<theName>> 
    is a short, stout humanoid, about four feet tall, with green skin 
    like that of a fish or reptile. "
  alienDesc = "" // override
  soiledDesc() {
    if (hasCrap && hasGuacamole)
      return 'He has been splattered with guacamole dip 
        and some other substance most foul. ';
    else if (hasCrap)
      return 'He has been splattered with a truly foul substance. ';
    else if (hasGuacamole)
      return 'He has been splattered with guacamole dip. ';
    else
      return '';
  }
  examineStatus {
    say(soiledDesc);
    inherited;
  }
  smellDesc() {
    if (hasCrap && hasGuacamole)
      "He reeks of bad guacamole dip and another
        substance even more foul. ";
    else if (hasCrap)
      "He reeks of something truly foul. ";
    else if (hasGuacamole)
      "He reeks of bad guacamole dip. ";
    else
      "He doesn<./s>t smell like much. ";
  }
  //matchNameCommon(origTokens, adjustedTokens) {
  //  if (!gPlayerChar.isIn(stairs)) { local k; k = k / k; }
  //  if (gAction && gAction.ofKind(TalkToAction))
  //    return nil;
  //  return self;
  //}
  isDead {
    return (!realLocation);
  }
  canMove {
    if (!isDead && !isStunned)
      return true;
    return nil;
  }
  dobjFor(ShootWith) {
    // an especially good match
    verify { logicalRank(140, 'maze-loving violator of human rights'); }
  }
;

modify Actor
  // Hacked to reverse the order in which the information is 
  // presented in NPC descriptions. I want the actor's inventory
  // to appear before the postureDesc and the ActorState desc.
  examineStatus() {
      examineListContents(); // Inventory lister
      if (!isPlayerChar())
          postureDesc;
      curState.stateDesc;
  }
  holdingDescInventoryLister = actorHoldingDescInventoryListerShort
  isDead = nil
;

class Professional: Alien
  // see 1conf.t for Professional.dobjFor(TalkTo) modifications.
  //uniqueTokens = ['profs','professors']
  //collectiveGroup {
  //  if (gAction && gAction.ofKind(TalkToAction) && tokensAreUnique)
  //    return professionalGroup;
  //  else
  //    return alienGroup;
  //}
  //collectiveGroup = professionalGroup
  alienDesc() {
    if (!curMood) {
      return;
    }
    else {
      say(curMood.moodDesc);
      return;
    }
  }
  curMood = nil
;

class Guard: Alien
  //collectiveGroup = guardGroup
  //uniqueTokens = ['guards']
  //collectiveGroup {
  //  local k = 0;
  //  if (gAction && gAction.ofKind(TalkToAction))
  //    k = k / k;
  //  if (gAction && gAction.ofKind(TalkToAction) && tokensAreUnique)
  //    return guardGroup;
  //  else
  //    return alienGroup;
  //}
  dobjFor(TalkTo) {
    action {
      if (!glob.isInEndgame) {
        introGuardTalkMsg;
      }
      else {
        endgameGuardTalkMsg;
      }
    }
  }
  endgameGuardTalkMsg = "<<endgameTalkMsg(glob.pluralTalkers)>>"
;

// -------------------------------------------------------------------
// ALIENS: THE FIVE ALIENS (Neton, Ovan, assistant, old guard, young guard)
// -------------------------------------------------------------------

// These NPCs are modified in 3npcs.t to add their endgame-related 
// characteristics.

neton: Professional 
  'alien oo professor prof neton n (in) (the) green (jacket) -*profs*professors*aliens*oos'
  //'alien oo professor prof neton n (in) (the) green (jacket) -*profs*professors'
  name() {
    if (hasBeenIdentified) return 'Neton';
    else return 'alien in the green jacket';
  }
  realName = 'Neton'
  jacketColor = 'green'
  hasEnteredConfRoom = nil
  isProperName = (hasBeenIdentified)
  hasBeenIdentified = nil
  //personalAlienToken = netonToken
  defaultMood = stoicMood
  curMood = stoicMood
  autoName = (hasBeenIdentified ? 'Neton'
    : 'the alien in the green jacket')
  //specialDescListWith = [alienSpecialDesc]
;

ovan: Professional 
  'alien professor prof ovan o oo (in) (the) yellow (jacket) -*profs*professors*aliens*oos'
  //'alien professor prof ovan o oo (in) (the) yellow (jacket) -*profs*professors'
  name() {
    if (hasBeenIdentified) return 'Ovan';
    else return 'alien in the yellow jacket';
  }
  realName = 'Ovan'
  jacketColor = 'yellow'
  hasEnteredConfRoom = nil
  isProperName = (hasBeenIdentified)
  hasBeenIdentified = nil
  //personalAlienToken = ovanToken
  curMood = impishMood
  defaultMood = impishMood
  autoName = (hasBeenIdentified ? 'Ovan' 
    : 'the alien in the yellow jacket')
  //specialDescListWith = [alienSpecialDesc]
  
;

assistant: Professional 
  'alien assistant oo (moon) (in) (the) beige tan (jacket) master asst assistant -*aliens*oos'
  //'alien assistant professor prof oo (in) (the) beige tan (jacket) asst assistant -*profs*professors'
  'assistant'
  //personalAlienToken = assistantToken
  //specialDescListWith = [alienSpecialDesc]
;

assisan: Nonsense 
  'assisan'
  'assisan'
  @nil
  bulk = 3
;

youngGuard: Guard 
  'alien oo young younger muscular youthful guard youth -*guards*aliens*oos' 
  //'alien oo young younger muscular youthful guard youth -*guards' 
  'young guard'
  alienDesc = "He is quite muscular, and he projects an air
    of intensity. "
  //specialDescListWith = [alienSpecialDesc]
  introGuardTalkMsg =
    "You start to speak, but the young guard growls
      ferociously, raises his
      hand cannon, and points it directly at your face.
      Deciding not to press the point,
      you fall silent. "
  //personalAlienToken = youngGuardToken
;

oldGuard: Guard 
  'alien oo old older elder elderly guard -*guards*aliens*oos' 
  //'alien oo old older elderly guard -*guards' 
  'old guard'
  alienDesc() {
    if (getOutermostRoom == youngGuard.getOutermostRoom)
      "He seems a bit older than his companion. ";
  }
  //specialDescListWith = [alienSpecialDesc]
  introGuardTalkMsg {
    if (!hasBeenTalkedTo) {
      "You start to speak, but the old guard glares at you
        threateningly. Deciding not to press the point,
        you fall silent. ";
        hasBeenTalkedTo = true;
    }
    else {
      "You start to speak, but the old guard raises his
        hand cannon and points it directly at your face.
        Deciding not to press the point,
        you fall silent. ";
    }
  }
  hasBeenTalkedTo = nil
  //personalAlienToken = oldGuardToken
;

// -------------------------------------------------------------------
// ALIENS: SECONDARY CHARACTERISTICS
// -------------------------------------------------------------------

class AlienDefaultShowTopic: DefaultShowTopic
  "<<gDobj.isIn(gActor)
      ? 'You show {the dobj/him} to {the iobj/him}. '
      : 'You point out {the dobj/him} to {the iobj/him}. '>>
    <p>{The iobj/him} ignores you. "
;
AlienDefaultShowTopic location = neton;
AlienDefaultShowTopic location = ovan;
AlienDefaultShowTopic location = oldGuard;
AlienDefaultShowTopic location = youngGuard;
AlienDefaultShowTopic location = assistant;

class AlienDefaultGiveTopic: DefaultGiveTopic
  "You offer {the dobj/him} to {the iobj/him}. 
    <p>{The iobj/him} ignores you. "
;
AlienDefaultGiveTopic location = neton;
AlienDefaultGiveTopic location = ovan;
AlienDefaultGiveTopic location = oldGuard;
AlienDefaultGiveTopic location = youngGuard;
AlienDefaultGiveTopic location = assistant;

modify Actor
  actorMoodFuse = nil
  // This is for temporary mood changes.
  changeMood(md) {
    curMood = md;
    //local k = 0; k = 9 / k;
    // I don't understand why the third argument here is 2
    // and not 1. Supposedly if you want something to run *next*
    // turn, the value should be 1. But for some reason 2 is what 
    // works.
    actorMoodFuse = new Fuse(self, &resetMood, 1);
  }
  resetMood() {
    //"<font color=blue>resetMood.</font> ";
    curMood = defaultMood;
    if (actorMoodFuse) {
      actorMoodFuse.removeEvent();
      actorMoodFuse = nil;
    }
  }
;

// Perhaps others might have used ActorStates rather than this 
// "mood" setup, but for the limited functionality I need, this
// is easier.

class Mood: object
;

impishMood: Mood
  moodDesc = "He has an impish grin on his face. "
;
stoicMood: Mood
  moodDesc = "He has a calm, stoic expression. "
;
impatientMood: Mood
  moodDesc = "He is waiting impatiently. "
;

class ConfSittingState: ActorState
  isInitState = true
;

netonConfSitting: ConfSittingState location = neton;
ovanConfSitting : ConfSittingState location = ovan ;


// -------------------------------------------------------------------
// ALIENS: POSSESSIONS
// -------------------------------------------------------------------

class NpcPossession: SometimesDistant
  farDesc {
    if (location.ofKind(Alien) || location.ofKind(Corpse)) {
      "\^<<theName>> <<verbToBe>> ";
      if (location.ofKind(Alien)) {
        if (isWorn)
          "being worn ";
        else if (location.ofKind(Alien))
          "being carried ";
        "by <<location.theName>> ";
      }
      else {
        if (isWorn)
          "being worn by <<location.theName>> ";
        else
          "being clutched by <<location.theName>> ";
      }
      "<<relativeLocationStr>>. ";
    }
    else
      "\^<<theName>> <<verbToBe>> 
        visible <<relativeLocationStr>>. ";
  }
  transformObj {
    if (location.ofKind(Alien) || (location.ofKind(Corpse) && isDistant))
      return location;
    else
      return self;
  }
;

class NpcClothing: NpcPossession, InitiallyWorn
  dobjFor(Doff) {
    verify {
      if (!isWorn)
        illogicalAlready(&notWearingMsg);
      if (gDobj && isWorn && wornBy.ofKind(Corpse))
        { } // removing a dead body's clothing is permissible.
      else if (gDobj && isWorn && !isIn(gActor)) {
        //if (gKey()) { }
        illogicalAlready(cannotRemoveClothing);
      }
    }
    action {
      if (wornBy != gActor)
        replaceAction(Take, self);
      else
        inherited;
    }
    //preCond = [touchObj]
    //check {
    //}
  }
  dobjFor(Take) {
    action {
      if (isWorn)
        makeWornBy(nil);
      inherited;
    }
  }
  willNotLetGoMsg(holder, obj) {
    //gMessageParams(holder, obj);
    return cannotRemoveClothing;
  }
  cannotRemoveClothing = 
    '\^' + location.theName + '<./s>s hardly going to 
      let you strip ' + location.itObj + '. '
  iobjFor (ThrowAt) {
    verify { }
    check {
      if (wornBy == location && location.ofKind(Prisoner))
        location.checkIobjThrowAt;
    }
  }
  transformObj {
    if (wornBy)
      return wornBy;
    else
      return self;
  }
;

// Some of the following code enforces that, in the unlikely
// event that you're already wearing a coat (stolen from a
// professor or from the assistant, or from a taco-turned-coat 
// transformation), you need to remove the coat you're wearing
// before putting on another.

class Cloak: object // a mix-in class for Wearable items.
  dobjFor(Wear) {
    preCond = [notWearingCloak, objHeld]
  }
;

modify Actor
  curCloak {
    for(local cur = firstObj(Cloak); cur != nil;
      cur = nextObj(cur, Cloak)) {
      if (cur.isWornBy(self))
        return cur;
    }
    return nil;
  }
;

notWearingCloak: PreCondition
    checkPreCondition(obj, allowImplicit) {
        // if gActor is already not wearing a hat, we're already done
        if (gActor.curCloak == nil)
            return nil;
        // try to implicitly remove the hat
        if (allowImplicit && tryImplicitAction(Doff, gActor.curCloak)) {
            // We just tried the implicit command. If it didn't work,
            // abort.
            if (gActor.curCloak != nil)
                exit;
            // tell the caller we executed an implied command
            return true;
        }
        // can't remove the hat implicitly; report the failure
        conditionFailed(obj);
        exit;
    }
    // The condition failed; report the failure and give up.
    conditionFailed(obj) {
        // can't do the implicit action - report failure and give up
        reportFailure('If you want to wear {the dobj/him},
          you<./s>ll have to take off ' + gActor.curCloak.theName 
          + ' first. ');
        // make it the pronoun
        gActor.setPronounObj(obj);
    }
; 

class ProfJacket: Cloak, NpcClothing
  nearDesc = "The jacket is <<jacketColor>>, and is rather
    odd-looking, in that it has six pockets 
    in the front, three on the left and three on the
    right. "
  dobjFor(Use) asDobjFor(Wear)
  // Somewhat of a kludge, but it should work as long as 
  // these clothing items are always worn by their 
  // intended wearers
  //dobjFor(Remove) asDobjFor(Take)
;

greenJacket: ProfJacket
  '(dark) (green) jacket/trenchcoat/coat/pockets*jackets*trenchcoats*coats' 
  'green jacket'
  jacketColor = 'dark green'
  location = neton
  wornBy = neton
  originalOwner = neton
  zapT = transform(self, greenJacke)
;
yellowJacket: ProfJacket
  '(bright) (yellow) jacket/trenchcoat/coat/pockets*jackets*trenchcoats*coats' 
  'yellow jacket'
  jacketColor = 'bright yellow'
  location = ovan
  wornBy = ovan
  originalOwner = ovan
  zapT = transform(self, yellowJacke)
;
beigeJacket: ProfJacket
  'beige tan jacket/trenchcoat/coat/pockets*jackets*trenchcoats*coats' 
  'beige jacket'
  jacketColor = 'beige'
  location = assistant
  wornBy = assistant
  originalOwner = assistant
  zapT = transform(self, beigeJacke)
;

greenJacke: Nonsense 
  'green jacke'
  'green jacke'
  @nil
  bulk = 3
;
yellowJacke: Nonsense 
  'yellow jacke'
  'yellow jacke'
  @nil
  bulk = 3
;
beigeJacke: Nonsense 
  'beige tan jacke'
  'beige jacke'
  @nil
  bulk = 3
;

class AlienPossession: object
;

ovanPda: AlienPossession, Thing
  'electronic (personal) digital (assistant) pda screen tablet device jkjkjk*devices*tablets'
  'tablet device'
  desc {
    "This tablet device, the size of a small book, 
      is apparently ";
    if (ovan.hasBeenIdentified)
      "Ovan<./s>s pride and joy. ";
    else
      "the pride and joy of the alien in the yellow jacket. ";
    if (gPlayerChar.canSee(ovan)) {
      "It has a screen and a few buttons, but 
        you can<./s>t see more than that from where you are. ";
      //"It<./s>s hard to tell what the purpose of the device is, 
      //  but it looks like a personal digital assistant, and 
      //  <<ovan.hasBeenIdentified ? 'Ovan' : 'the alien'>>
      //  has been using it like a tablet device, so you<./s>re inclined
      //  to think that that<./s>s what it is. ";
    }
    else
      "It has a screen, which is blank, and a few buttons. ";
  }
  dobjFor(TurnOn) {
    verify { }
    check {
      "You try pushing a few buttons on the tablet device, and try swiping 
        the screen, but find no way of turning it on. ";
      exit;
    }
  }
  dobjFor(TurnOff) {
    verify { }
    // Do this in check, not verify, so that preconditions 
    // will trump this as needed.
    check {
      "Its screen is completely blank. I guess that
        means it<./s>s as off as it<./s>s ever going to be. ";
      exit;
    }
  }
  dobjFor(EnterOn) {
    verify { }
    check {
      "You try pushing a few buttons on the tablet device, but nothing 
        happens. ";
      exit;
    }
  }
  dobjFor(Feel) asDobjFor(TurnOn)
  dobjFor(TypeOn) asDobjFor(EnterOn)
  dobjFor(TypeLiteralOn) asDobjFor(EnterOn)
  dobjFor(Use) asDobjFor(TurnOn)
  dobjFor(Run) asDobjFor(TurnOn)
  // isn't present in the endgame, so can't be transformed, either with the ary or the T-remover
  //zapAry = transform(self, pad) 
  bulk = 3
;

pad: Thing
  '(mouse) pad'
  'pad'
  @nil
  "It<./s>s a plain, ordinary mouse pad. "
  madeOfPaper = true
  bulk = 2
;

ovanPdaButtons: AlienPossession, Button, Component
  '(electronic) (personal) (digital) (assistant) (pda) (tablet) (device) button*buttons'
  'tablet buttons'
  @ovanPda
  "You see nothing unusual about the buttons on the tablet device. "
  isPlural = true
  dobjFor(Push) {
    action {
      "You try pushing a few buttons on the tablet device, but nothing 
        happens. ";
    }
  }
  dobjFor(Feel) asDobjFor(Push)
  dobjFor(EnterOn) {
    verify { }
    check {
      "You try pushing a few buttons on the tablet device, but nothing 
        happens. ";
      exit;
    }
  }
  dobjFor(TypeOn) asDobjFor(EnterOn)
  dobjFor(TypeLiteralOn) asDobjFor(EnterOn)
  dobjFor(Strike) asDobjFor(Push)
  dobjFor(Hit) asDobjFor(Push)
  dobjFor(Use) asDobjFor(Push)
  //transformObj = ovanPda // isn't present in the endgame, so can't be transformed
;

cryoPapers: Unhittable, AlienPossession, Readable
  'paper*papers'
  'papers'
  isPlural = true
  madeOfPaper = true
  desc {
    if (!glob.isInEndgame && gPlayerChar.canSee(youngGuard) 
        && !isIn(gActor))
      "You can<./s>t see much about the papers from 
        where you<./s>re sitting. ";
    else
      readDesc;
  }
  dobjFor(Read) {
    preCond = [touchObj]
  }
  readDesc = 
    "These are your cryogenic records, the ones you 
      signed years ago&mdash;over 150 years ago, come to think
      of it. They contain plenty of information, like your 
      name and social security number, but nothing
      you didn<./s>t already know, and nothing that helps you
      in your present situation. "
  dobjFor(Use) asDobjFor(Read)
;

netonBooks: AlienPossession, Thing, Readable
  '(old) hardcover stack/book/*books*hardcovers'
  'books'
  "The books are hardcovers, and many of them seem quite 
    old, but you can<./s>t tell much more 
    than that, since the spines are facing away from you. "
  dobjFor(Read) {
    preCond = [touchObj]
  }
  dobjFor(Use) asDobjFor(Read)
  isPlural = true
;

//class ActorGroup: CollectiveGroup, Actor
//  isPlural = true
//  actionIsForCollective {
//    
//  }
//  //actionIsForActorCollective(action) {
//  //  return true;
//  //}
//  //actionIsForActorCollectiveBackup(action) {
//  //  // Examine, etc.
//  //  if (   action.ofKind(ExamineAction)
//  //      || action.ofKind(ReadAction)
//  //      || action.ofKind(LookInAction)
//  //      || action.ofKind(SearchAction)
//  //      || action.ofKind(LookUnderAction)
//  //      || action.ofKind(LookBehindAction)
//  //      || action.ofKind(LookThroughAction))
//  //    return true;
//  //  
//  //  // ListenTo, Smell
//  //  if (   action.ofKind(ListenToAction)
//  //      || action.ofKind(SmellAction))
//  //    return true;
//  //  
//  //  // Attack, etc.
//  //  if (   action.ofKind(AttackAction)
//  //      || action.ofKind(AttackWithAction)
//  //      || action.ofKind(BreakAction)
//  //      || action.ofKind(CutAction)
//  //      || action.ofKind(CutWithAction))
//  //    return true;
//  //  
//  //  // Actor actions
//  //  if (   action.ofKind(GiveToAction)
//  //      || action.ofKind(ShowToAction)
//  //      || action.ofKind(FollowAction))
//  //    return true;
//  //  
//  //  // TalkTo
//  //  if (   action.ofKind(TalkToAction))
//  //    return true;
//  //  
//  //  // Throw
//  //  if (   action.ofKind(ThrowAction)
//  //      || (action.ofKind(ThrowAtAction) && self==gDobj)
//  //      || (action.ofKind(ThrowToAction) && self==gDobj))
//  //    return true;
//  //  
//  //  // ThrowAt, ThrowTo
//  //  if (   (action.ofKind(ThrowAtAction) && self==gIobj)
//  //      || (action.ofKind(ThrowToAction) && self==gIobj))
//  //    return true;
//  //  
//  //  // Basic physical actions
//  //  if (   action.ofKind(TasteAction)
//  //      || action.ofKind(FeelAction)
//  //      || action.ofKind(TakeAction)
//  //      || action.ofKind(RemoveAction)
//  //      || action.ofKind(TakeFromAction)
//  //      || action.ofKind(DropAction)
//  //      || action.ofKind(PutInAction)
//  //      || action.ofKind(PutOnAction)
//  //      || action.ofKind(PutUnderAction)
//  //      || action.ofKind(PutBehindAction)
//  //      || action.ofKind(WearAction)
//  //      || action.ofKind(DoffAction)
//  //      || action.ofKind(KissAction)
//  //      || action.ofKind(DigAction)
//  //      || action.ofKind(DigWithAction)
//  //      || action.ofKind(JumpOverAction)
//  //      || action.ofKind(JumpOffAction)
//  //      || action.ofKind(PushAction)
//  //      || action.ofKind(PullAction)
//  //      || action.ofKind(MoveAction)
//  //      || action.ofKind(MoveWithAction)
//  //      || action.ofKind(MoveToAction)
//  //      || action.ofKind(TurnAction)
//  //      || action.ofKind(TurnToAction)
//  //      || action.ofKind(TurnWithAction)
//  //      || action.ofKind(ScrewAction)
//  //      || action.ofKind(ScrewWithAction))
//  //    return true;
//  //  
//  //  // Unlikely physical actions
//  //  if (   action.ofKind(SetToAction)
//  //      || action.ofKind(ConsultAction)
//  //      || action.ofKind(ConsultAboutAction)
//  //      || action.ofKind(TypeOnAction)
//  //      || action.ofKind(TypeLiteralOnAction)
//  //      || action.ofKind(EnterOnAction)
//  //      || action.ofKind(SwitchAction)
//  //      || action.ofKind(FlipAction)
//  //      || action.ofKind(TurnOnAction)
//  //      || action.ofKind(TurnOffAction)
//  //      || action.ofKind(LightAction)
//  //      || action.ofKind(BurnAction)
//  //      || action.ofKind(BurnWithAction)
//  //      || action.ofKind(ExtinguishAction)
//  //      || action.ofKind(AttachToAction)
//  //      || action.ofKind(DetachFromAction)
//  //      || action.ofKind(DetachAction)
//  //      || action.ofKind(ClimbAction)
//  //      || action.ofKind(ClimbUpAction)
//  //      || action.ofKind(ClimbDownAction)
//  //      || action.ofKind(OpenAction)
//  //      || action.ofKind(CloseAction)
//  //      || action.ofKind(LockAction)
//  //      || action.ofKind(UnlockAction)
//  //      || action.ofKind(LockWithAction)
//  //      || action.ofKind(UnlockWithAction)
//  //      || action.ofKind(EatAction)
//  //      || action.ofKind(DrinkAction)
//  //      || action.ofKind(PourAction)
//  //      || action.ofKind(PourIntoAction)
//  //      || action.ofKind(PourOntoAction)
//  //      || action.ofKind(CleanAction)
//  //      || action.ofKind(CleanWithAction)
//  //      || action.ofKind(SitOnAction)
//  //      || action.ofKind(LieOnAction)
//  //      || action.ofKind(StandOnAction)
//  //      || action.ofKind(BoardAction)
//  //      || action.ofKind(GetOutOfAction)
//  //      || action.ofKind(GetOffOfAction)
//  //      || action.ofKind(FastenAction)
//  //      || action.ofKind(FastenToAction)
//  //      || action.ofKind(UnfastenAction)
//  //      || action.ofKind(UnfastenFromAction)
//  //      || action.ofKind(PlugInAction)
//  //      || action.ofKind(PlugIntoAction)
//  //      || action.ofKind(UnplugAction)
//  //      || action.ofKind(UnplugFromAction)
//  //      || action.ofKind(UnscrewAction)
//  //      || action.ofKind(UnscrewWithAction)
//  //      || action.ofKind(EnterAction)
//  //      || action.ofKind(GoThroughAction)
//  //      || action.ofKind(PushTravelAction))
//  //    return true;
//  //    
//  //  // Something to catch any other possible cases.
//  //  return true;
//  //}
//;

class GuardUniform: NpcClothing
  name = 'black uniform'
  desc = "The uniform mainly consists of a black jumpsuit made of some 
    unidentifiable alien material. It also includes a rubbery
    hat with a Mohawk-shaped ridge on top. "
  isEquivalent = true
  // Somewhat of a kludge, but it should work as long as 
  // these clothing items are always worn by their 
  // intended wearers
  //dobjFor(Remove) asDobjFor(Take)
  dobjFor(Wear) {
    verify {
      illogical('You couldn<./s>t possibly squeeze into the uniform. 
        It<./s>s a jumpsuit designed for aliens who
        are two feet shorter than you. ');
    }
  }
;

youngGuardUniform: GuardUniform
  vocabWords = 
    '(young) (black) (odd) (rubbery) mohawk mohawk-shaped uniform/jumpsuit/hat' 
  location = youngGuard
  //wornBy = youngGuard
;

oldGuardUniform: GuardUniform
  vocabWords = 
    '(old) (black) (odd) (rubbery) mohawk mohawk-shaped uniform/jumpsuit/hat' 
  location = oldGuard
  //wornBy = oldGuard
;

//class GuardHat: Wearable
//  '(black) (odd) (rubber) (rubbery) hat' 'black hat'
//  "It's an odd-looking hat, made of some black rubbery substance,
//    with a Mohawk-shaped ridge running "
//;

class ByConfDoorState: ActorState
  stateDesc = "He<./s>s standing watch to the 
    <<whichSideOfDoor>> of the door. "
  //specialDesc = "A young guard and an old guard are 
  //  standing watch on either side of the door. "
  whichSideOfDoor = ''
;

class youngGuardByConfDoorState: ByConfDoorState
  location = youngGuard
  //specialDesc = nil
  whichSideOfDoor = 'left'
;

class oldGuardByConfDoorState: ByConfDoorState
  location = oldGuard
  //specialDesc = nil
  whichSideOfDoor = 'right'
;

// Since GunThing derives from NpcPossession, the multiple inheritance 
// from NpcPossession is redundant. I think I'm just going overboard 
// in case I decide to change GunThing to make it no longer derive 
// from NpcPossession.

class HandCannon: NpcPossession, GunThing
  name = 'hand cannon'
  desc =
    "This hand cannon is surely as big as the guard<./s>s whole 
      arm<<location && location.ofKind(Guard) ? '' : ' was'>>. 
      The metal gleams icily. "
  okayShootMsg = 
    'A bright bolt of light streams out of the hand cannon 
      and disappears into the distance. '
  isEquivalent = true
  bangTarget {
    "A bright bolt of light streams out of the hand cannon
      and strikes {the dobj/him}. {The dobj/him} seem{s}
      unaffected. [BUG! This is unacceptable in some cases
      and must be changed!] ";
  }
;

oldGuardHandCannon: HandCannon
  vocabWords = '(old) (metal) hand cannon/gun/firearm/weapon/trigger*guns*firearms*weapons*triggers*cannons' 
  location = oldGuard
  asscGuard = oldGuard
;

youngGuardHandCannon: HandCannon
  vocabWords = '(young) (metal) hand cannon/gun/firearm/weapon/trigger*guns*firearms*weapons*triggers*cannons' 
  location = youngGuard
  asscGuard = youngGuard
;

// -------------------------------------------------------------------
// ALIENS: COLLECTIVE GROUPS
// -------------------------------------------------------------------

//alienGroup: CollectiveGroup
//  '-*aliens*oos'
//  'aliens'
//  isPlural = true
//  location = nil
//  // I'm not sure if this is done right, but I think so.
//  moreThanOneIsPresent() {
//    if (
//        (gPlayerChar.canSee(oldGuard) ||
//         gPlayerChar.canSee(youngGuard))
//        &&
//        (gPlayerChar.canSee(neton) ||
//         gPlayerChar.canSee(ovan) ||
//         gPlayerChar.canSee(assistant))
//       )
//      return true;
//    else
//      return nil;
//  }
//  isCollectiveAction(action, whichObj) {
//    if (moreThanOneIsPresent && action.ofKind(TalkToAction))
//      return true;
//    else
//      return nil;
//  }
//  dobjFor(TalkTo) {
//    verify { }
//    action {
//      if (professionalGroup.moreThanOneIsPresent)
//        professionalGroup.actionDobjTalkTo;
//      else if (gPlayerChar.canSee(neton))
//        neton.actionDobjTalkTo;
//      else if (gPlayerChar.canSee(ovan))
//        ovan.actionDobjTalkTo;
//      else if (gPlayerChar.canSee(neton))
//        assistant.actionDobjTalkTo;
//      // for the following to happen, something would have
//      // to be wrong somewhere.
//      else
//        neton.actionDobjTalkTo;
//    }
//  }
//;


alienGroup: CollectiveGroup
  '-*aliens*oos'
  'aliens'
  //'-*tokens'
  //'tokens'
  // No description needed, I believe.
  isPlural = true
  location = nil
  // This method may not be necessary
  moreThanOneIsPresent() {
    local alienCount = 0;
    if (gPlayerChar.canSee(oldGuard  )) alienCount++;
    if (gPlayerChar.canSee(youngGuard)) alienCount++;
    if (gPlayerChar.canSee(neton     )) alienCount++;
    if (gPlayerChar.canSee(ovan      )) alienCount++;
    if (gPlayerChar.canSee(assistant )) alienCount++;
    
    if (alienCount >= 2)
      return true;
    else
      return nil;
  }
  isCollectiveAction(action, whichObj) {
    //return true;
    if (
        //moreThanOneIsPresent && 
        action.ofKind(TalkToAction))
      return true;
    else
      return nil;
  }
  dobjFor(TalkTo) {
    verify { }
    action {
      if (professionalGroup.moreThanOneIsPresent)
        professionalGroup.actionDobjTalkTo;
      else if (gPlayerChar.canSee(neton))
        neton.actionDobjTalkTo;
      else if (gPlayerChar.canSee(ovan))
        ovan.actionDobjTalkTo;
      else if (gPlayerChar.canSee(assistant))
        assistant.actionDobjTalkTo;
      else if (gPlayerChar.canSee(youngGuard))
        youngGuard.actionDobjTalkTo;
      else if (gPlayerChar.canSee(oldGuard))
        oldGuard.actionDobjTalkTo;
      // for the following to happen, something would have
      // to be really wrong somewhere.
      else
        neton.actionDobjTalkTo;
    }
  }
  //matchNameCommon(origTokens, adjustedTokens) {
  //  if (gAction && gAction.ofKind(TalkToAction))
  //    return self;
  //  return nil;
  //}
;

guardGroup: CollectiveGroup
  //'-*guards*aliens*oos'
  '-*guards'
  //'guards aliens oo oos guys -'
  name = 'guards'
  isPlural = true
  location = nil
  moreThanOneIsPresent() {
    if (gPlayerChar.canSee(oldGuard) && gPlayerChar.canSee(youngGuard))
      return true;
    else
      return nil;
  }
  isCollectiveAction(action, whichObj) {
    if (moreThanOneIsPresent && action.ofKind(TalkToAction))
      return true;
    else
      return nil;
  }
  dobjFor(TalkTo) {
    verify { }
    action {
      if (!glob.isInEndgame) {
        introGuardTalkMsg;
      }
      else {
        endgameGuardTalkMsg;
      }
    }
  }
  introGuardTalkMsg =
    "You start to speak, but the old guard growls
      ferociously at you, and the young guard points 
      his hand cannon directly at your face.
      Deciding not to press the point,
      you fall silent. "
  endgameGuardTalkMsg = "<<endgameTalkMsg(true)>>"
  // This wild and crazy idea didn't work.
  //collectiveGroup = alienGroup
;

endgameTalkMsg(plural) {
  glob.pluralTalkers = nil;
  if (!plural)
    return 'It doesn<./s>t look like 
      he<./s>s in a talking mood. ';
  else
    return 'It doesn<./s>t look like 
      they<./s>re in a talking mood. ';
}

professionalGroup: CollectiveGroup
  '-*profs*professors*aliens*oos'
  //'guards aliens oo oos guys -'
  name = 'professors'
  isPlural = true
  location = nil
  // probably not optimal, but good enough
  moreThanOneIsPresent() {
    if (gPlayerChar.canSee(neton) && gPlayerChar.canSee(ovan))
      return true;
    else if (gPlayerChar.canSee(neton) && gPlayerChar.canSee(assistant))
      return true;
    else if (gPlayerChar.canSee(ovan) && gPlayerChar.canSee(assistant))
      return true;
    else
      return nil;
  }
  isCollectiveAction(action, whichObj) {
    if (moreThanOneIsPresent && action.ofKind(TalkToAction))
      return true;
    else
      return nil;
  }
  dobjFor(TalkTo) {
    verify {
      logicalRank(120, 'professors');
    }
    action {
      if (!glob.isInEndgame) {
        Professional.actionDobjTalkTo;
      }
      else {
        "<<endgameTalkMsg(true)>>";
      }
    }
  }
  // This wild and crazy idea didn't work.
  //collectiveGroup = alienGroup
;

//modify Actor
//  tokensAreTestable {
//    if (!gAction)
//      return nil;
//    if (!gAction.getOrigTokenList)
//      return nil;
//    if (gAction.getOrigTokenList.length < 1)
//      return nil;
//    // We have a viable token list.
//    return true;
//  }
//  tokensAreUnique {
//    if (!tokensAreTestable)
//      return nil;
//    // We have a viable token list.
//    for (local a = 1; a <= gAction.getOrigTokenList.length; a++) {
//      for (local b = 1; b <= uniqueTokens.length; b++) {
//        if (gAction.getOrigTokenList[a][1] == uniqueTokens[b])
//          return true;
//      }
//    }
//    // If we're still here, then nothing unique was found.
//    return nil;
//  }
//  uniqueTokens = ['dueksuiasjdvwerhnjcvdr']
//;


// -------------------------------------------------------------------
// PRISONERS: CLASS
// -------------------------------------------------------------------

class Prisoner: Npc
  shadowList = [hallway1, hallway2, hallway3, cell]
  isHer = true
  npcDesc() {
    prisonerDesc;
    moodDesc;
  }
  moodDesc() {
    if (!curMood) {
      return;
    }
    else {
      say(curMood.moodDesc);
      return;
    }
  }
  curMood = nil
  //collectiveGroup = prisonerGroup
  companion = nil // override
  rescued = nil
  // "isAntagonized" starts out nil, and will usually remain that way,
  // except in the event that you fire a weapon at Vicki
  // and/or Diane. Then they will become antagonized.
  isAntagonized = nil
  gunsOwned = 0
  dobjFor(TalkTo) {
    verify {
      if (gDobj && gActor.getOutermostRoom != getOutermostRoom)
        illogical((glob.pluralTalkers ? 'Vicki and Diane are ' 
          : '{The dobj/he} {is} ')
          + 'too far away. ');
      else
        logicalRank(140, 'human');
    }
    check {
    }
    action {
      prisonerGroup.actionDobjTalkTo;
      //if (!glob.isInEndgame) {
      //  vd1Main.select();
      //}
      //else {
      //  //"You can<./s>t think of anything to say. ";
      //  prisonerGroup.actionDobjTalkTo;
      //}
    }
  }
  // In case I ever reinstate the "screw" verb.
  dobjFor(Screw) {
    verify {
      if (gDobj)
        illogical('I think not. ');
    }
  }
  // Both "feel" and "kiss" are equally inappropriate.
  dobjFor(Feel) asDobjFor(Kiss)
  dobjFor(Hit) asDobjFor(Attack)
  dobjFor(Break) asDobjFor(Attack)
  dobjFor(Attack) {
    verify {
      illogical(dontAttackPrisonerMsg);
    }
    check {
      say(dontAttackPrisonerMsg);
      exit;
    }
  }
  dobjFor(AttackWith) asDobjFor(Attack)
  dobjFor(HitWith) asDobjFor(Hit)
  iobjFor(ThrowAt) {
    verify {
      illogical(dontThrowAtPrisonerMsg);
    }
    check {
      say(dontThrowAtPrisonerMsg);
      exit;
    }
  }
  dobjFor(Push) {
    verify {
      illogical(dontPushPrisonerMsg);
    }
    check {
      say(dontPushPrisonerMsg);
      exit;
    }
  }
  cannotBoardMsg = '{The dobj/he} probably wouldn<./s>t {|have} like{|d} that. '
  dontPushPrisonerMsg =
    (theresNoCauseStr + ' to go pushing ' + noCausePredicateStr + ' around. ')
  dontThrowAtPrisonerMsg =
    (theresNoCauseStr + ' to go throwing stuff at ' + noCausePredicateStr + '. ')
  dontAttackPrisonerMsg =
    (theresNoCauseStr + ' to go attacking ' + noCausePredicateStr + '. ')
  theresNoCauseStr = 'There<./s>s no cause'
  noCausePredicateStr = (theName)
  desiredFood = nil
  foodEaten = 0
  satiationLevel = 3 // prisoners don't want to eat more than 3 food items
  isHungry = (foodEaten < satiationLevel)
  dobjFor(ShootWith) {
    verify {
      if (!gDobj || !gIobj) {
        logical;
      }
      else {
        //local deadlyGun;
        //if (gIobj == phaser && phaser.curSetting == 'stun')
        //  deadlyGun = phaser;
        //else if (gIobj is in (laser, aryUng, rayGun, tRemovingGun))
        //  deadlyGun = nil;
        //else
        //  deadlyGun = true;
        //if (deadlyGun is in (phaser, true))
        //  illogicalNow(theresNoCauseStr + ' to go shooting ' 
        //    + noCausePredicateStr + '. ');
        //else
        //  illogicalNow('As weapons go, {the iobj/he} may be 
        //    relatively harmless, 
        //    but {the dobj/he} isn<./s>t likely to know that, 
        //    and you don<./s>t want to risk antagonizing
        //    the few friends you<./s>ve got. '
        //    + (self == diane ? 'Even if they<./s>re really
        //    obnoxious sometimes. ' : ''));
        illogicalNow(theresNoCauseStr + ' to go shooting ' 
          + noCausePredicateStr + '. ');
      }
    }
  }
;

// -------------------------------------------------------------------
// PRISONERS: THE TWO PRISONERS
// -------------------------------------------------------------------

vicki: Prisoner
  'vicki vicky vickie vikki vikky vikkie murakami v oriental asian black-haired gray-haired grey-haired 
    woman gal prisoner person human lady
    *women*gals*prisoners*people*humans*ladies'
  name {
    if (hasBeenIdentified) return 'Vicki';
    else return 'woman of Asian descent';
  }
  //location = cell
  prisonerDesc() {
    "Vicki is a gray-haired woman of Asian descent, perhaps in her late fifties. ";
  }
  leaving = nil
  companion = diane
  hasExplainedProfession = nil
  formerUniversity = 'Florida New College'
  isProperName = (hasBeenIdentified)
  hasBeenIdentified = nil
  curMood = friendlyMood
  //collectiveGroup = prisonerGroup
  dobjFor(Kiss) {
    check {
      "You haven<./s>t developed that kind of relationship
        with Vicki. ";
      exit;
    }
  }
  vickiShowResponse =
    "Vicki glances at herself without much interest, shrugs, 
      then looks away. "
;

diane: Prisoner
  'diane diana gadke d blonde blond blonde-haired blond-haired 
    woman gal prisoner person human lady
    *women*gals*prisoners*people*humans*ladies'
  name() {
    if (hasBeenIdentified) return 'Diane';
    else return 'blonde-haired woman';
  }
  //location = cell
  prisonerDesc() {
    "Diane is a blonde-haired woman, perhaps in her late fifties. ";
  }
  companion = vicki
  isProperName = (hasBeenIdentified)
  hasExplainedProfession = nil
  hasBeenIdentified = nil
  curMood = apatheticMood
  //collectiveGroup = prisonerGroup
  dobjFor(Kiss) {
    check {
      "I think Diane would run you over with a steamroller
        before she let you do that. ";
      exit;
    }
  }
  theresNoCauseStr = 'Diane may be trying, but that<./s>s still no cause'
  noCausePredicateStr = 'her'
  afterAction() {
    if (gActionIs(Yell)) {
      if (!glob.isInEndgame)
        "<p><.q>Oh, great,<./q> says Diane.
          <.q>They<./s>ve locked us in here with
          a screaming madman.<./q> ";
      else if (diane.getOutermostRoom == me.getOutermostRoom)
        "<p><.q>Oh, great,<./q> says Diane.
          <.q>It<./s>s the return of the screaming
          maze-runner.<./q> ";
    }
  }
  dianeShowResponse =
    "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve 
      successfully located me.<./q> ";
;

// -------------------------------------------------------------------
// PRISONERS: COLLECTIVE GROUP
// -------------------------------------------------------------------

prisonerGroup: CollectiveGroup
  '-*women*gals*prisoners*people*humans*ladies'
  name = 'women'
  isPlural = true
  location = nil
  // probably not optimal, but good enough
  moreThanOneIsPresent() {
    if (gPlayerChar.canSee(vicki) && gPlayerChar.canSee(diane))
      return true;
    else
      return nil;
  }
  isCollectiveAction(action, whichObj) {
    if (moreThanOneIsPresent && action.ofKind(TalkToAction))
      return true;
    else
      return nil;
  }
  dobjFor(TalkTo) {
    verify { }
    check { }
    action {
      if (!glob.isInEndgame) {
        vd1Main.select();
      }
      // Endgame stuff follows:
      else { 
        vd2Main.select;
        // The following code, designed to make the prisoners
        // more patient, has been moved to the actual conversation code.
        // The prisoners only have a chance of becoming more patient
        // if you not only type TALK TO VICKI, but also then proceed
        // to say something meaningful.
        //vicki.waitLength = -1;
        //if (vicki.waitList != waitTwelve)
        //  vicki.waitList = vicki.waitNine;
      }
    }
  }
  dianeShowResponse =
    "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve 
        successfully located me.<./q> "
;

// -------------------------------------------------------------------
// PRISONERS: SECONDARY CHARACTERISTICS
// -------------------------------------------------------------------

class RestingState: ActorState
  isInitState = true
  stateGerund(str) {
    return str;
  }
;

vickiResting: RestingState location = vicki;
dianeResting: RestingState location = diane;


friendlyMood: Mood
  moodDesc = "She is smiling politely at you. "
;
apatheticMood: Mood
  moodDesc = "She is glancing at the floor with a bored expression. "
;

//DefaultGiveTopic
//  topicResponse {
//    //if (gDobj == foodCube)
//    //  
//    //else
//      "You offer {the dobj/him} to {the iobj/him}. 
//        <p><.q>Uh, no thanks,<./q> says Vicki. ";
//  }
//  location = vicki
//;
//
//DefaultGiveTopic
//  topicResponse {
//    //if (gDobj == foodCube)
//    //  
//    //else
//      "You offer {the dobj/him} to {the iobj/him}.
//        <p><.q>No, no,<./q> says Diane.
//          <.q>There<./s>s no way you<./s>re going 
//          to pawn {that dobj/him} off on me.<./q> ";
//  }
//  location = diane
//;

//GiveTopic @foodCube
//  " "
//  location = vicki
//;
//
//GiveTopic @foodCube
//  "You offer {the dobj/him} to {the iobj/him}.
//    <p><.q>No, no,<./q> Diane says.
//      <.q>There<./s>s no way you<./s>re 
//      going to pawn {that dobj/him} off on me.<./q> "
//  location = diane
//;

// These awkward hacks are because my girlfriend thinks
// "you show you to vicki" and "you show vicki to vicki"
// aren't good enough. There's just no pleasing some 
// people. Or is there?

DefaultShowTopic
  topicResponse {
    if (gDobj == gActor)
      "<<gDobj.isIn(gActor)
          ? 'You show yourself to {the iobj/him}. '
          : 'You point out yourself to {the iobj/him}. '>>
        <p>{The iobj/him} glances at {it dobj/him} without much
          interest, shrugs, then looks away. ";
    else if (gDobj == gIobj)
      "<<gDobj.isIn(gActor)
          ? 'You show {the dobj/him} to herself. '
          : 'You point out {the dobj/him} to herself. '>>
        <p>{The iobj/him} glances at herself without much
          interest, shrugs, then looks away. ";
    //else if ()
    //  "<<gDobj.isIn(gActor)
    //      ? 'You show {the dobj/him} to {the iobj/him}. '
    //      : 'You point out {the dobj/him} to {the iobj/him}. '>>
    //    <p>{The iobj/him} glances at {it dobj/him} without much
    //      interest, shrugs, then looks away. ";
    else
      "<<gDobj.isIn(gActor)
          ? 'You show {the dobj/him} to {the iobj/him}. '
          : 'You point out {the dobj/him} to {the iobj/him}. '>>
        <p>{The iobj/him} glances at {it dobj/him} without much
          interest, shrugs, then looks away. ";
  }
  location = vicki
; 
DefaultShowTopic
  topicResponse {
    if (gDobj == gActor)
      "<<gDobj.isIn(gActor)
        ? 'You show yourself to Diane. 
            <p><.q>Congratulations,<./q> says Diane. 
              <.q>You<./s>re the proud owner of 
              {a dobj/him}.<./q> '
        : 'You point out yourself to Diane. 
            <p><.q>Congratulations,<./q> says Diane. 
              <.q>You<./s>ve successfully located 
              yourself.<./q> '>>";
    else if (gDobj == gIobj)
      "<<gDobj.isIn(gActor)
        ? 'You show {the dobj/him} to herself. 
            <p><.q>Congratulations,<./q> says Diane. 
              <.q>You<./s>re the proud owner of 
              {a dobj/him}.<./q> '
        : 'You point out {the dobj/him} to herself. 
            <p><.q>Congratulations,<./q> says Diane. 
              <.q>You<./s>ve successfully located 
              me.<./q> '>>";
    else
      "<<gDobj.isIn(gActor)
        ? 'You show {the dobj/him} to Diane. 
            <p><.q>Congratulations,<./q> says Diane. 
              <.q>You<./s>re the proud owner of 
              {a dobj/him}.<./q> '
        : 'You point out {the dobj/him} to Diane. 
            <p><.q>Congratulations,<./q> says Diane. 
              <.q>You<./s>ve successfully located 
              {the dobj/him}.<./q> '>>";
  }
  location = diane
  //topicResponseHolding = 
  //  "You show {the dobj/him} to Diane. 
  //    <p><.q>Congratulations,<./q> says Diane. 
  //      <.q>You<./s>re the proud owner of {a dobj/him}.<./q> "
  //topicResponseNotHolding =
  //  "You point out {the dobj/him} to Diane. 
  //    <p><.q>Congratulations,<./q> says Diane. 
  //      <.q>You<./s>ve successfully located {the dobj/him}.<./q> "
  //handleTopic(fromActor, obj) { 
  //  noteInvocation(fromActor); 
  //  setTopicPronouns(fromActor, obj); 
  //  if (obj.isHeldBy(gActor)) {                    
  //    topicResponseHolding;
  //  } 
  //  else { 
  //    topicResponseNotHolding; 
  //  }      
  //} 
; 

//+ ShowTopic @foodCube
//  topicResponse { 
//    "<.q>Congratulations,<./q> Diane says. <.q>I can see you<./s>re 
//      the proud owner of a food cube.<./q> ";
//  } 
//; 

// -------------------------------------------------------------------
// PRISONERS: POSSESSIONS
// -------------------------------------------------------------------

class PrisonerClothing: NpcClothing
  //dobjFor(Doff) {
  //  check() {
  //    "No. ";
  //    exit;
  //  }
  //}
  theDisambigName = (disambigName)
  aDisambigName = (disambigName)
;

class PrisonerShirt: PrisonerClothing
  '(white) shirt'
  'white shirt'
  desc = "\^<<location.theName>> is wearing a plain white shirt. "
;
class PrisonerPants: PrisonerClothing
  '(white) pants/trousers/pair'
  'white pants'
  desc = "\^<<location.theName>> is wearing a plain white pair of pants. "
  isPlural = true
  isQualifiedName = true
;

class VickiClothing: object
  //willNotLetGoMsg(holder, obj) {
  //  gMessageParams(holder, obj);
  //  return 'Vicki<./s>s hardly going to let you strip her. ';
  //}
  location = vicki
;
class DianeClothing: object
  willNotLetGoMsg(holder, obj) {
    //gMessageParams(holder, obj);
    return 'I think Diane would run you over with a steamroller
      before she let you strip her. ';
  }
  location = diane
;

vickiShirt: VickiClothing, PrisonerShirt
  disambigName = 'Vicki<./s>s white shirt'
;

dianeShirt: DianeClothing, PrisonerShirt
  disambigName = 'Diane<./s>s white shirt'
;

vickiPants: VickiClothing, PrisonerPants
  disambigName = 'Vicki<./s>s white pants'
;

dianePants: DianeClothing, PrisonerPants
  disambigName = 'Diane<./s>s white pants'
;

// -------------------------------------------------------------------
// JUNK
// -------------------------------------------------------------------

// ------------------
// JUNK: alien tokens
// ------------------

// Note: As of March 2007, I am baffled as to why I put alien tokens
// here. Apparently they no longer serve a purpose, and I can't figure 
// out what purpose they used to serve. Therefore, I am commenting
// them out, and if this produces no problems, this section may be 
// deleted.

// <begin stuff that wasn't commented out as of Feb 2007>

//netonToken     : object;
//ovanToken      : object;
//assistantToken : object;
//oldGuardToken  : object;
//youngGuardToken: object;

// <end stuff that wasn't commented out as of Feb 2007>



//class AlienToken: Component
//  '-*aliens*oos'
//  name = (location.name)
//  isProperName = (location.isProperName)
//  //'token*tokens'
//  //'token'
//  dobjFor(All) {
//    verify { }
//    preCond = []
//    check { }
//    action {
//      //replaceAction(gAction, gDobj, gIobj);
//      if (!gIobj)
//        _replaceAction(gActor, gAction, location);
//      else
//        _replaceAction(gActor, gAction, location, gIobj);
//    }
//  }
//  collectiveGroup = alienGroup
//;

//class AlienToken: Component
//  '-*aliens*oos'
//  name = (location.name)
//  isProperName = (location.isProperName)
//  //'token*tokens'
//  //'token'
//  collectiveGroup = alienGroup
//  //matchNameCommon(origTokens, adjustedTokens) {
//  //  if (gAction && gAction.ofKind(TalkToAction))
//  //    return self;
//  //  return nil;
//  //}
//;
//
//netonToken     : AlienToken ;
//ovanToken      : AlienToken ;
//assistantToken : AlienToken ;
//oldGuardToken  : AlienToken ;
//youngGuardToken: AlienToken ;
//
//modify netonToken      location = neton     ;
//modify ovanToken       location = ovan      ;
//modify assistantToken  location = assistant ;
//modify oldGuardToken   location = oldGuard  ;
//modify youngGuardToken location = youngGuard;

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

// The following was a test to see whether CollectiveGroups with non-nil
// location properties can be used with MultiLoc things. Apparently
// they can't.

westPark: OutdoorRoom
  'West Side of the Park'
  "You are on the west side of a park. East of you, near the center
    of the park, are three statues, depicting a dolphin, an eggplant, 
    and a mushroom, of all things. "
  east = eastPark
;
eastPark: OutdoorRoom
  'East Side of the Park'
  "You are on the east side of a park. West of you, near the center
    of the park, are three statues, depicting a dolphin, an eggplant, 
    and a mushroom, of all things. "
  west = westPark
;

class MultiLocInPark: MultiLoc
  locationList = [westPark, eastPark]
;
class ObjectInWestPark: object
  location = westPark
;
class BronzeStatue: Fixture
  desc = "It's not the finest work you've ever seen, but it's a
    good likeness of a <<statueSubject>>, cast of solid bronze. "
  collectiveGroup = statueGroup
;

dolphinStatue: MultiLocInPark, BronzeStatue
  'bronze dolphin statue*statues' 'dolphin statue'
  statueSubject = 'dolphin'
;
eggplantStatue: MultiLocInPark, BronzeStatue
  'bronze eggplant statue*statues' 'eggplant statue'
  statueSubject = 'eggplant'
;
mushroomStatue: MultiLocInPark, BronzeStatue 
  'bronze mushroom statue*statues' 'mushroom statue'
  statueSubject = 'mushroom'
;

statueGroup: CollectiveGroup
  'bronze -*statues'
  name = 'statues'
  desc = "The statues aren't masterpieces, but they are cast of 
    shiny bronze and seem a nice addition to the park. "
  isPlural = true
  location = nil
  // this is the default behavior; modify if necessary
  isCollectiveAction(action, whichObj) {
    if (action.ofKind(ExamineAction))
      return true;
    return nil;
  }
;

parkFixture: Fixture 'park' 'park fixture'
  @westPark
;

#endif // __DEBUG

