/* FIRST THINGS FIRST - header.t
/*  Copyright (c) 1996, 1997, 1999, 2000, 2001, 2002, 2006 
/*  by J. Robinson Wheeler. All Rights Reserved. */
/*
	First Things First					[Working title:  Hard Day's Night]
	Interactive Fiction by Rob Wheeler.
	
	Developed with TADS: The Text Adventure Development System.
	
	Version 1.0  -	alpha test. compiled March 1997. playtested 3-30-97.
					sent to testers 10-22-99.
	Version 1.01 - 	fixed timeKnob.setting bug that broke time machine
					sent to testers 10-22-99.
	Version 1.02 -	fixed  in intro. fixed 'push button' when on platform.
					fixed double-search item findings (initSearch was done
					twice). implemented 'fullscore' system. fixed bug that
					gave you a score even if you didn't have enough money
					to open a bank account. (10-27-99)
	Version 1.03 -	Just kind of picking off nits as I see them as I scroll
					through the code. (10-29-99)
	Version 1.04 -	Attempting to add fifty lines of code just to keep 
					moving. (11-24-99) Also, adding timeOfDay function,
					paging up from the bottom of the file ironing out 
					verbs and other sundries. (11-29-99)
				(12-08-99) Added secret door ability. Cleaned up some
					vague things. Put seats in the car. Am wondering why
					gutter2.ioPutIn -> drainpipe didn't behave properly
					when Jota went on his >PUT ALL IN GUTTER tear. It
					should have mapped to drainpipe, saving him the 
					consternation. The ropeItem sort of worked. The
					backwards behavior (>TIE TIRE TO ROPE instead of
					>TIE ROPE TO TIRE) I might be able to fix now, but
					I'm leaving it alone. The code for stopping my fall
					with the tire tied to the rope didn't seem to activate
					for some reason, maybe because I was using wizard 
					commands instead of doing it straight. The code looks
					like it should work, anyway. Lots of things with that
					rope need ironing out, but fortunately a good deal of
					it functions. Back in 1997 I remember it functioning
					fairly well under various tests, but it's not working
					well now.
				(next night) Hey, somehow it was testing for object
					"tireSwing" instead of just "tire". Wonder why I
					changed that. Now I'm adding all sorts of fiddly
					drop-things-out-the-window code to allow for more
					freedom of player action.
	Version 1.05 - 	(12-12-99) Er. Not sure yet. Something.
					(12-15-99) Continuing third day of NPC conversation.
	Version 1.06 -  Continuing NPC conversation.
				(02-23-00) Added code to create secret door/passage
				(02-24-00) Added stand/sit/lie on rock, thinkVerb.
					Made rock a floatingItem. Made air a floatingItem,
					finally. Pondered adding tree to future areas.
				(02-25-00) Am just about to start -- I've gotten as
					far as the time machine manual, and I'm thinking
					about making it a consult-able object, or allowing
					players to read individual chapters, which are 
					mentioned in the general readdesc. Not sure, though.
					Perhaps I'll just keep doing conversation stuff so
					that I can bully through as much of that as possible.
					
					(11pm) I just made TELL NPC ABOUT synonymous with 
					ASK NPC ABOUT, which was what all the code was 
					built to handle.
					
					(11:33pm) I decided to try fixing the rope code. There
					are only two items that can be tied to the rope, and
					I wanted to make the syntax TIE ROPE TO ValidObj 
					work, which it never did before (you had to type
					the more awkward TIE ValidObj TO ROPE, and there
					was even an error message that pointed you to this
					syntax).
				(02-26-00) I tightened up the blueprint-changing code,
					hopefully allowing DRAW DOOR ON BLUEPRINT.
				(02-28-00) I've just gotten to line 9000, the rooms of
					the future. I fixed up the account-opening code, and
					the global.money system. Maybe all that stuff will
					work. Rather stupidly, as is my habit, I haven't 
					tried compiling as I've been adding stuff. It's
					looking much more ship-shape, though, I think. It
					would be really nice to test out a new version that
					can actually go all the way to the end of the game
					as I originally designed it. I still worry about 
					adding something new -- for example, interesting
					things to do in the evil Far Future. But let's 
					leave that aside for the moment, I guess. My ideas
					are still too nebulous, although in the past couple
					of days I've started thinking that maybe some of the
					NPCs (or, specifically, Fred and Laura) should show
					up in the evil Far Future as workers for the big
					corporation, which would be kind of interesting.
					Maybe it would make them seem like characters in the
					game instead of purely-functional robots. Hm... (12:43am)
				(02-29-00) Hooray, I just finally got through the end of
					game code on my long mission to add NPC conversation
					to every object. This is going to be a real chore to
					debug, though. I'm not at all sure how I'm going to
					get around the hideous disambiguation problems. One
					thing I might need to do is to create floatingItems
					out of all of the scenery that appears more than 
					once, like I did for the rock. That will get a bit
					more complicated, but maybe I can make a new class of
					time-durable objects that will simplify the task of
					making them appear in various times and places. There's
					still more I want to do with NPCs and with the evil
					Far Future, but I guess I should try to debug this 
					and compile it and call the compiled game version
					beta 1.10. (2:48am)
	Version 1.07 (02-29-00) Compiled earlier today with only a few typo
					related errors. Just started testing tonight (10pm).
					Found a problem in air floatingItem ldesc. Also, 
					ioSynonym askAbout = tellAbout doesn't work. The
					interesting thing is that there aren't any disambig
					problems per se with ASK ABOUT -- if there are lots
					of objects with the same noun, it chooses the first
					one instead of asking the player to disambiguate.
				(11pm) Also a problem with code in southOfHouse, for 
					checking whether a rope is dangling. Just fixed
					<<addressMe>> -- getting rid of it, because the
					PC isn't a specific gender or character. Finally,
					tried to fix TELL ABOUT. Hm, just remembered that
					SHOW obj TO NPC should do the same. Let me get that
					before I compile again. (11:12pm) Whoa, wait. After
					adding the code, I noticed that SHOW obj TO NPC was
					already working! So I guess I'll take out my dodgy
					new showTo code. Hm. Well, good, I guess. 
				(11:24pm) I also separated the xdesc (exits description) 
					by a full line space. I think I like it that way, but 
					I'm not sure. I haven't seen anyone else use it before. 
					And just now I made sure all plural items are set isThem,
					because the adv.t I'm using is smart enough to use
beta version 1.071	isn't/aren't by checking the isThem property.

	Version 1.08 (03-01-00) Started writing Future room descriptions, realized
					I hadn't even built the whole map. This whole section of
					the game was always underdeveloped, but I think I'm going
					to beef it up pretty well now. It's sort of the dawning-
					horror part of the game, should be creepy, rainy, a little
					spooky.

	(03-04-00) (3:23am) Started really rewriting the descriptions here [future.t], 
		and going through one room at a time and setting the stage. 
		
		I'd just gotten to the complicated bit where you first see your house,
		and either it's burned down or it's burned down AND a tree has fallen
		on it, when I started thinking, "Hm, maybe this is too much. " Part of
		the atmosphere I'd established in the versions up until now was that
		the future was creepy for being desolate, but the real scare wasn't
		until you jumped to the far future. If I have all of this fire damage
		and whatnot, then the future is almost more of a horror than the far
		future. This place was sort of a gradual turn for the worse, but not
		a really bad scene. I do want the far future to seem like the big 
		evil deal up ahead that you need to subvert in the past, so maybe I
		shouldn't go this far with it.

			1.081 (3-14-00) Jota started playing again and reported bugs when
					sitting on the rock. I also remembered that there was a 
					bug with the timeVerb, and I think I may have fixed that.
					I know I saw some other bugs in my playtest the other night,
					but I haven't re-loaded it to check them out.
	Version 1.09 (03-16-00) Added future.t module.
	Version 1.091 (same) Compiled version of version 1.09, cleaned up compiler-
					stopping bugs. Ran several short playtests (with transcripts).
					Fixed some bugs found during the playtests.
	Version 1.095 (03-17-00) This version is the preparation for the compile 
					of Version 1.10 tonight, which I set a deadline to make.
					I am going to split the source code into modules.
				  (03-18-00) Well, I didn't actually make that deadline. Getting
				  	the split code to compile normally took quite a while. Then
				  	I started trying to chase down old bugs. By about 5pm-7pm,
				  	I was focusing on getting actorDaemon behavior to the 
				  	squirrel, Fred, and Laura, ironing out inconsistencies in
				  	their coding, and on making the lightningRod functional in
				  	the plot (as far as the Future goes, and also showing it to
				  	the Architect). It seems silly to have an object in the game
				  	that's so non-interactive. Really, I need to allow players
				  	to install it themselves, not give it to the architect to
				  	do. He would likely say, "that's not my job to install" 
				  	anyway. That'll take more work, though.
	Version 1.10 (3-19-00) I gave version 1.095 to Jota to play with, but I'm
					going to keep pressing ahead, and any changes I make for
					the next few days I wanted to go under the header of v1.1
					for some reason. (1:29pm)
				(3:22pm) Okay, I started out with a couple of playtests, 
					trying to play it through from the beginning. Caught 
					some old bugs, finally -- like why the wheelbarrow would
					jump two locations sometimes. Somehow, I got on a tangent
					of trying to embellish the broken tree descriptions/actions
					in the future, and got knotted up by the sloppy way I'm
					keeping track of the multiple possible states. I need to
					have one place to check for what the state is, so that I
					don't get confused writing it. I'm going to take a break 
					to muse on that, or to stop musing on it, or something.
	cont.       (6-13-00 5:15am) Yikes, *three* months? Well, the first thing
					I'm going to do is fix the bug where Laura's turn-by-turn
					actions are printed when you're with the squirrel. Then
					I'm going to change exitDesc back to the way it was, 
					without the extra newline preceding it. There's also 
					an extra newline on the northRoof before the description
					of the gutter that doesn't need to be there. Then I'm
					going to work on the game-state for the future, with
					(I think it was) eight states depending on whether you've
					installed the lightning rod, etc., and see how far that
					gets me. 
		
	(06-13-00) (6:26am) Just built the future.state function, and am now
		going to try carefully implementing it into the code so far. If I
		do it right, it will work the same but be clearer (to me) what is
		going on and which descriptions need to be printed.

      (06-14-00) (4:30pm) 
            I changed it so that future.state is called once during the
            housecleaning at the end of every turn, and the result is placed
            in the state variable of the "future" object -- which was handy
            anyway in that I wanted to create a "future" object just as 
            an available conversation topic for Fred and Laura. However, it
            almost seems like extended conversations should be possible on
            the subject, but extended conversations is a whole new can of 
            worms. I really need to focus on filling out this section. Now
            I'm at the point where it's time to build the interior of the 
            house for the first time.

	(6-16-00) Did a bare-bones construction of the interior of the house,
		leaving out all of the descriptions. Wrote notes on the plot,
		trying to figure out how to connect the game to the ending,
		didn't resolve anything. Jota suggested I start from the end
		and work backward in my thinking, which seemed like a good
		idea.

	(6-18-00) (7:35pm) Hoping to write some of those room descriptions
		now. I'm trying to think what could make them interesting. One
		thing that bothers me is that there is no particular point to
		wandering around in the house -- it's all scenery and no plot,
		although I was going to have future-Fred rummaging in there
		somewhere.

	(6-23-00) (5:34pm) A couple of days ago I was compiling the code on
		the notebook computer for the first time. It uses a more updated
		TADS compiler and adv.t library, and I was hitting errors that 
		didn't show up when I compiled on the Mac. One particularly 
		puzzling error required me to use the debugger to trace line
		by line what was going on. Finally it came down to the fact that
		the moveableActor.travelTo() routine in adv.t wasn't checking
		if the coming-from location were nil before sending it to a 
		method that did checks on properties and methods of that 
		location. This always causes an "Object value required" error.
		It seemed to be a bug in the adv.t code, that a check for nil
		should have been there but wasn't. I sent a report of this to
		Mike Roberts, the author of TADS, and he said he'd look into 
		it. Turns out I was right, it was a missing check for nil, and
		he gave me a little patch code and will update the next release
		of adv.t. Woo, caught a bug in TADS itself. That's kind of neat.
		Shows a little self-confidence, that I didn't just assume it was
		some bug in my own code and try to work around it.

		And now I need to work some more on FFred's actorDaemon code,
		which is where this funny error showed up the other day.

		(6:49pm) Wrong - I've spent the last hour or so trying to fix the
		listenDesc code, especially the functions that are supposed to
		swap out and replace a new listenDesc for an old one, and then
		restore the original later on. I was using double-quoted strings,
		which turned out to be the wrong choice. Single-quoted strings
		make it all work like it was supposed to. Now I'm trying to 
		see if I can make the restoration work after several listenDesc
		changes in a row. (First you hear a noise downstairs, then you
		hear Fred about to come upstairs, then you hear Fred's wheezy
		breathing, and then, as a test, it should restore the original
		listenDesc of the room.)

		(7:09pm) Yay! Finally got the swapping and restoring working
		properly. Whew. And due to time constraints, I think that's 
		all I have time for right now.

	6-24-00 (9:22pm) Started this afternoon working on FFred's actorDaemon.
		I'd left off after only really handling case 0 and case 1, and 
		a bit of case 2 with a lot of notes for that one. I ended up making
		more headway than I thought. After a couple of hours of coding, I
		had case 2 finished off, and without any compilation errors, amazingly.
		After weeding out typos and such, I went ahead and did case 3, deciding
		(wisely) to curtail the actorDaemon after that turn. That is, Fred finds
		the bottle and goes to the garage that turn, wherever it happens to be.
		Millions of compiler errors this time, oh well. I ended up splitting
		off all code that got used at least twice into little routines, which
		I always like to do to keep things tidy.

		There is a case I haven't handled yet, which is if you put the bottle
		into hiding -- such as back in the hole, or perhaps into some other
		item in your inventory. Until I had to wrestle so much to get the bugs
		out of the case 3 code, I was feeling like I could keep marching onward,
		but now I'm a bit fatigued and maybe should give it a rest for now.

		I was lucky with my design of this. I coded the hole in the wall as a
		searchHider without having any idea what would be in it, originally.
		I just knew that there should be something there. Then I came up with
		the bottle of liquor, which was a good idea because I knew something
		had to motivate finding future Fred, something would have to summon
		him. The bit of luck turned out to be the timing -- since Fred got 
		moved into the kitchen on the turn you find the bottle, there were
		all sorts of limits on how far the player could travel in the next
		three turns, which made handling each subsequent turn a lot less 
		complicated.

		The other thing I need to look into is the code for searchHiders --
		because even though >LOOK IN HOLE and >SEARCH HOLE ostensibly do the
		same thing, I put the code to trigger FFred's actorDaemon in the 
		doSearch method, and if you type >LOOK IN HOLE you find the bottle
		but Fred never appears. Grr. I guess I'll just have to be redundant
		about it, but I'm glad I've got this basic actorDaemon stuff handled
		fully. After he goes to the garage, he stays there.

		I'm going to have to put in askingAboutMe( who ) code for FFred 
		everywhere, though. Argh.

		(9:44pm) Oh dear. The code is terribly buggy, and I can tell that
		I don't have the energy to work on it right now. It probably won't
		be too hard to fix -- there are systematic patterns to the bad 
		output -- but I need a break and some food. I guess I'll go home
		and eat dinner and maybe work on it more later tonight. Or there's
		always tomorrow.

	(6-25-00) (6:34pm) Aha. With some food and rest and a fresh start this
		afternoon, it was fairly trivial to see what was wrong with the
		code from yesterday. One of the main things was that I had forgotten
		to reassign FFred's location at the beginning of the case 3 code.
		There were unnecessary redundancies in case 2's code that I also
		knocked out. Actually, the first thing I did today was to get 
		>LOOK IN and >SEARCH doing the same thing. I just put the special
		code into searchObj() instead of doSearch().

		(6:50pm) Finally implemented Fred.met when you enter the sandwich
		shop, and added ldescs for FFred. And I just reminded myself that
		I need to do the reverse here -- if you meet Fred after meeting
		FFred, it should say "You are horrified to recognize that the old
		wino you met is Fred." or whatever.

		(8:36pm) Okay, it's been about two solid hours of weeding out bugs.
		Every time I test, I change the timing of what I do -- where the
		bottle is, and where I am, on the third turn -- and each time it's
		not getting it quite right and I have to handle it. It is kind of 
		fun to keep thinking up different variations. It's so complex, and
		at the same time I'm trying to keep the code as non-redundant as
		possible, rather than a separate hack for each case. I finally had
		to add a couple of hacks like that, but they were the only way to
		make sure it was working. I haven't even tried the cases where the
		player puts the bottle inside another object yet -- argh. How many
		days have I been working on this? And to the player, it'll just be
		three turns of the game out of thousands, but you never know which
		way any particular player will go during those three turns. Dropping
		the bottle, then picking it up again? Taking it to another room,
		dropping it, then picking it up again? Dropping it where it is? 
		Just taking it downstairs? Waiting for Fred to appear and then 
		giving it to him? Oy...

		(9:52pm) Okay, I think I've finally found all the permutations. It's
		amazing how many there were. I shouldn't have gloated the other day
		about how cleverly I'd limited the options. The last one I chased 
		down was if you drop the bottle in the attic and then come back down
		into the hallway. That variation actually produces the most text of
		any of the permutations -- I guess because I was handling a single
		case. The others are more or less the same response. And now I think
		I'm tired and hungry again, and should call it a night, although as
		usual it seems like it would be fun to keep going. Maybe I should just
		stay here and eat and get some more coffee and... hmm. I dunno if that's
		a really good idea. I need to get up by noon tomorrow. Hmmmmmmm.

		(11:14pm) Had a sandwich, but not more coffee. Did some work 
		synchronizing the descriptions depending on whether you meet Fred
		or FFred first, and whether you'd examined Fred before or after
		meeting FFred, and various. It was more finicky than I expected.
		It led me to clean up a little bit of the NPC class code. The 
		FFred.actorDaemon code seems robust now, finally. However, I tried
		asking FFred about something, and he said "I have no opinion about the
		<<whatever>>." -- which was amusingly out of character. Maybe writing
		dialogue for him is the next step, for tomorrow.

	Version 1.20 (6-25-00) (11:22pm) I just decided to call what I've now
		got running here tonight Version 1.2.

		(6-26-00) (5:45pm) Just as I was walking to my car last night, I
		remembered one more variation that I hadn't checked. When I got home
		I tried it, and sure enough it wasn't handled properly! Argh! This
		was the case if you dropped the bottle downstairs and then went back
		upstairs after that, so that he has to go back downstairs to pick it
		up. I coded that in last night, but I did it somewhat wrongly, so I
		had to kind of re-do it just now, but now it all seems to be working
		properly. Now -- I guess I should follow through on my plan to make
		him conversational. Urgh.

		Something that is about to come up is differentiating between
		ASK NPC ABOUT FOO and TELL NPC ABOUT FOO. That is, the difference
		between asking what they know and telling them what you know. It
		might be that in most cases, it gets the same response, but I'm
		forseeing that in order to get some of the plot working, you're
		going to have to be able to tell them things. For example, TELL
		FRED ABOUT FUTURE FRED. However, will the player know that there
		is a difference if for most of the game they are synonymous verbs?
		Glerm.

		On the same walk back to my car, I was puzzling over how to solve
		this plot problem that I just invented. When I wrote the code to
		make you recognize the old wino as Fred and vice-versa, the text
		was written in such a way that it leaned heavily towards this being
		yet another problem to solve, another sad future to avert. But how
		do you get Fred to change his own future? It's not like you can 
		drag him to an alcoholic treatment program. Finally I came with
		what has to be done -- and it was yet again an idea that had been
		in the back of my mind, but one that I didn't really know what to
		do with: taking Fred along on a time-jump. I think what you have to
		do is confront Fred with future Fred, show him his miserable future,
		and I can see that snapping Fred into line, making him realize what
		he has to look forward to if he doesn't make some changes. That 
		seemed like a really good solution, but it means coding up the
		ability for Fred to follow you out of the shop and take a journey,
		go wandering with you. Yikes.

		There may be a similar thing to be done with Laura, but I'm
		not sure what it is, yet.

		The other thing I want to allow is some bit of altruism. Like,
		give the old wino money or one of his own sandwiches. If you do
		that, you can't solve some of the other problems in the game, 
		although with the money situation it looks like there might be
		a way for the player to make back the money in some other way,
		by selling stuff. More complications, but it seems like it needs
		to be allowed. If you've got money or food, how can you not try
		to give some to this poor guy? Should you score points for doing
		so? Hmmm. What a can of worms this all opens, but I think it makes
		the game better.

		I'm just hoping I start to see the end of this project at some
		point. At every stage, the peak of the mountain seems as high
		and far away as it did when I was standing at the base.

		(8:33pm) I'm kind of fighting a headache today, so I took a while
		to just kind of read and sit here. Finally I started up again, and
		worked out the code to differentiate ASK and TELL, or to revert to
		ASK if there's no special TELL code. I put in a funny hack to give
		the player an extra message if you try TELL FRED ABOUT FRED and he's
		met future-Fred (or Laura and future Laura). It seems to be working
		adequately enough that all I need to do is just sort of come up with
		conversation text for appropriate objects. I think I might need some
		more coffee to get into that.

		(11:09pm) I started making a small headway into adding conversation
		about FFred, or with FFred, when I got led into activating Fred into
		following the player to the future. Again I've done the dumb thing of
		coding and coding without stopping to see how it compiles -- but a lot
		of that is because it won't compile until I tie up loose coding ends,
		things I have to add because I've invented new references to make it
		work. It occurred to me earlier that if I code up everything having
		to do with FFred's being in the storyline, I will have made a 
		significant advance towards tying together the whole game. A lot of
		elements that had been kind of separate and loose are being neatly
		sewn together, tightening everything. Well, I shouldn't say things
		like this, because they tend to turn sour on me when some sort of new
		and weird problem crops up, but that's how it feels. For example, 
		doing everything to make sure all interactions with FFred are handled
		is not only motivating this stuff with Fred following you, but it will
		make me complete the code for the money system, of buying and selling
		and having spare cash, and all that. And once I do that, I'll probably
		be led down some pathway having to do with coding Laura more completely.
		And once I've done all that, the game really will be nigh on complete.

		I should probably stop speculating and go back to coding, or maybe
		compiling. Something is bound to go blooie.

		(6-27-00) (12:04am) Augh! It should be working -- and it is, kind of --
		except for the fact that when it starts Fred.actorDaemon2, it starts
		two of them. Why, I dunno. Which means that it counts doubly fast 
		every turn, and then turns off one of them, but the other starts 
		over again. There is only one notify call to Fred.actorDaemon2, so
		why it is starting two of them is quite beyond me. I think this is
		a signal to stop for the night, although I don't know what I'm going
		to do about it tomorrow. I guess I can always go home now and ask on
		ifMUD to see if anyone knows anything about it.

		(6-27-00) (8:37pm) Spent a couple of hours this afternoon working on
		Fred. When I got home last night, I fixed the double-daemon problem.
		It was being called from a verification method, so it was running
		through the consultWords silently before doing it for real. So, 
		today I tried to keep going on the take-Fred-with-you code, giving
		him various things to say along the way. I also made him more responsive
		if you make repeat trips back to the shop. I'm falling back on my 4in1
		habit of using rand() calls to generate different conversation snippets
		at any given moment, but with that comes the question of exactly what
		random number works best -- what would make Fred speak up a little bit
		too often, or not enough? I'm erring on the side of "not enough" so 
		far, and I might need to keep tweaking it.

		I still haven't coded what happens if you actually bring Fred into
		contact with FFred, but I think that's what I'm going to do right
		now, because then that will be done and I can look at some other
		parts of the code. It's been in the back of my head since this 
		morning that maybe it's time to make a throrough search through
		the transcripts that Jota created. I want to make sure I've handled 
		all the fiddly little problems that he pointed out as he played, 
		because I know I haven't done that with any thoroughness yet.
		
		(6-28-00) (9:27pm) I've made tremendous progress today filling in 
		missing details. I started with Ellison (jdblask)'s log, and then
		went to the first of Jota's. I've lost track of every change I made
		today. One of the last things I was working on was adding a consult
		verb (for CONSULT [book] ABOUT [topic]) -- and giving the various
		books in the game information about certain topics. I was able to
		foreshadow the plot of the game in the library book about time 
		travel, for example. Thanks go to Jota again for trying this command
		and coming up empty. It's a good way to lump in a lot of exposition
		that I've wanted to get out somewhere. I spruced up the antique shop,
		moving the lightningRod from the locksmith shop to there, where it
		obviously belongs, but the whole buying/selling/money thing is still
		on the back burner for now. I also attempted to make it possible to
		put the key back under the doormat, but I haven't tested it yet. I
		also fixed the scoring system, which was a little buggy. Quite a 
		good day, it makes me feel (yet again) like the game is really coming
		together, and that I'm closing in on making it fully playable from
		beginning to end, which has never yet been possible. I guess constant
		progress really does make a difference, even if it takes several weeks
		to start to see it.
		
		(6-29-00) (7:40pm) I continued to go through Jota's logs. He wanted
		all sorts of functionality for the car, some of which I still haven't
		really handled properly -- like opening the hood and the trunk. I've
		been adding verbs and so forth to handle all of them, and I'm barely
		getting started on the first of his logs because of this.
		
		I finally stopped and decided to compile, and everything is fine except
		that I'm getting a strange error message: 
		
			ftf\ftf_1_20.t(23): error TADS-1008: invalid datatypes for 
			binary '+' operator
		
		I can't progress until I figure out how to track this down, but I'm
		at a loss. I've searched for every instance of '+' in all of my own
		files, and nothing was erroneous. This means that I've coded something
		such that some internal operation, or some adv.t function, is getting
		passed bad data types that it's trying to add. Ummmmm. Duhhhh. I guess
		this is a strong reason why one should compile frequently. Bummer.
		
		(6-29-00) (9:41pm) Well, I ignored the problem at hand and kept going
		on other things. Actually, I embarked on a line-by-line search of 
		present.t, fixing something that's bothered me for a while -- that
		all of the askingMeAbout( who ) code was tabbed over in a different
		format from everything else, and it always stuck out. So as I went,
		I regularized it. As usual, I went off on tangents. I made it so
		that you can hack through the foliage with the machete, finally --
		making it yet-another solution to that maze. I added some interactivity
		to the soccer ball and the tire pump. A lot of little futzing with
		many of the objects, actually. And then I got to a point where I needed
		to finally add a merchant NPC to the antique store, and work out the
		general selling-things-to-him mechanism. (I might change the merchant
		to be a she, but he's a he right now.) I've replaced or cleaned up a
		lot of very old, very early code -- though a lot of it is simply
		standardizing the coding style to what I use today. Some of this
		code is four years old! I also cleaned up the Architect.actorDaemon,
		which had previously been a completely separate daemon function. 
		All in all, a certain amount of progress, although if I can't get
		the game to compile any mor ebecause of the 1008 error, I don't know
		what I'm going to do. I need to put out a call for help about tracking
		down that error, because I'm really at a loss otherwise.

		(6-30-00) (4:48pm) Okay, I'm back in business. TenthStone and inky
		came through on ifMUD last night, and helped me track it down. inky
		had the idea that the compiler runs preinit() at the end of compilation,
		so that was probably where the error was. That led to a diagnosis of
		initSearch() as the problem spot -- it was being passed a nil value
		instead of a valid datatype. There was a red herring search for a
		problem with underHiders, because I had tried to tweak the two
		underHiders in the first room so that you could put stuff back 
		underneath them. However, I isolated the problem as being with a
		searchHider -- and the guilty code was in the lightningRod, which
		I shuffled from the locksmith shop (its temporary location, until
		I thought of a better one) without being careful. I changed the
		'location' property to 'searchLoc' without updating its value to
		point to the searchHider ('antiques') instead of 'locksmiths'.

		This reminds me that I need to implement the 'credits' and 'about'
		verbs so that I can thank these people properly. I think I'll start
		there and then see where the day leads me.

		(7:57pm) Okay, I went on a long sidetrack journey involving various
		complicated behaviors of the library books in the game. I came upon
		the librarySlip object in future.t -- which I had commented out a 
		while back, unsure of how to handle it. So when I decided to activate
		it, I had to make it disappear when you put the library book into
		the slot. If I did that, I had to have the library book disappear
		down the chute, because figuring out how to make the library slip
		reappear again if you retrieved the book from the slot (it was a
		simple qcontainer) was too complicated. And if that's what happens
		if you put a book in the slot, it has to happen to all three books.
		And if it happens to all three books, how do you retrieve the two
		other books from the slot in the first place? Thus a dummy item of
		the two books, wedged into the slot.
		
		Now, after all that, I had to take care of something else that had
		been niggling at the back of my mind for quite some time: the rare
		book you give to the squirrel belongs to the library, and it's a
		bit unethical for you to give it to the squirrel and have it 
		disappear. Thus, I had to make the rare book reappear at some
		point. After some thinking, I decided to have the player discover
		it in the top branches of the tree at its full height, as if the
		squirrel had left it there. A lot of fiddly code went into this
		operation, including making the ldesc, readdesc, and consultAbout
		methods variable.
		
		Lastly, to make the rare book retrievable from the tree only once,
		I decided to make tree locations a special class of room, where
		if you drop items they plummet to the ground. That was a fix 
		probably worth doing anyway, because how can you drop something
		when you're up in a tree and have it stay there?
		
		All of this is good stuff.

		(8:50pm) Okay, it's compiling, and it's playing -- with some buggy
		behavior -- but I've been at this nonstop all week and it's time to
		take a day off. Whew.
		
		(7-01-00) (11:45pm) Hello again. I've finally finished going through
		all of the modules step-by-step and cleaning up the code that's out
		of line, which is nice. However, now I'm staring the big problems in
		the face again. Coming across the code for the duplicateKey, the one
		you make at the end of the game and use to get in your front door,
		I pondered the puzzles that led up to it, the ones I started to put
		in place long ago. As always, I come smashing against the idea that
		they're bizarre and arbitrary. The point of growing the tree was to
		get you into the attic window, where you would find the blue pencil,
		which would allow you to change the blueprint so that there's a secret
		entrance on the south side of the house that goes into a secret passage.
		The point of the secret passage was to be that you have to leave the
		key grinder in there, so that you can make the duplicate key from the
		original key that you find in the future. However, um, why can't you
		just carry the key grinder with you when you go? And if that's the 
		case (and I don't see why it wouldn't be), why do you need to create
		the secret passage? The secret passage basically is useless to the
		plot, and I've known this for a long time. And if the secret passage
		is useless to the plot, then so is the goal of changing the blueprint,
		which means that getting into the attic is a very complicated but 
		ultimately meaningless endeavor.
		
		It was this very train of thought that put a halt to my work on the
		game for a year and a half. I spent those 18 months trying to figure
		out how to make the creation of the secret passage non-arbitrary to
		the plot, and I never could.
		
		One thing it does mean (or will mean, when I implement the secret
		passage code) is that there will be yet another way to get into
		the house in the future. You can climb in through the tree, or 
		pry open the front door with the crowbar, or enter through the
		secret passage. I'm trying to decide what to do about the garage
		door, whether the garage opener should work. Actually, it won't,
		because there's no electricity in the house. But what, is it stuck
		shut? And if it's stuck shut, how does future Fred get into the
		garage? And if there's a way in through the garage, what's the 
		point of having the player climb in through the tree, which was
		supposed to be the only way to get in when I thought of it.
		
		Grr. I don't like having things be so arbitrary. The new stuff
		I've been writing has gone a long way towards making things seem
		integrated and necessary -- Fred and Laura in particular. I also
		don't like the reliance on money, on the whole thing about getting
		the cash together to open an account, and then making piles of money
		by return trips. It's complicated and it's kind of dumb at the same
		time. It's a bit too RPG-ish for my own tastes, kind of a different
		style of game than what I'm trying to write.
		
		It's possible that if I go back to what I was doing, i.e. moving
		through Jota's transcripts and implementing what he tries, I'll
		eventually come upon an idea that solves some of these problems.
		Some sort of "Aha!" moment, where Jota's attempts to do things
		suggest a course of player action that makes solid sense. That's
		putting a lot of eggs in the Jota basket, although it worked for
		making Fred more interactive and crucial.
		
		Hm. I guess that's what I'll do, then. Keep plugging away at things
		I can plug away at, and keep my eyes peeled for a solution to these
		bigger problems.

		(7-02-00) (7:31pm) Well, that was excruciating. I spent what must
		have been an hour and a half trying to make CONSULT work for the
		books. I thought it already had, but it was full of bad code. I
		was also trying to add LOOK UP, which is a synonym for CONSULT
		but with the direct and indirect objects reversed. Happily, it
		all works now, but it took a lot of the steam out of me right off
		the bat today.
		
		(10:29pm) It takes forever to go through Jota's logs. In fact, I'm
		still less than halfway through his first (of seven or eight?),
		because he keeps trying verbs that don't exist, and then I have
		to fully implement the verb. Often, that means adding handlers for
		that verb on a number of objects, and those handlers often have
		complex behaviors. It's all well and good, I guess, but doesn't
		make me feel like I'm really making progress.
		
		Side note: I've decided not to use the librarySlip after all, 
		because I don't like the whole business about items disappearing
		from your inventory because you changed something. Changes happening
		"off-camera" are okay, but I don't like that particular side effect.
		I started pondering this late last night when I was staring at the
		drainpipe in the future, and trying to make it do what the one in
		the present does. It occurred to me that if you hadn't unclogged 
		the drainpipe in the present yet, all of the items moved into 
		stuckLimbo (because they got lost down the pipe) should come 
		bursting out of the future drainpipe if you shove the cannonball
		down there. However, what if you do that, and pick up all those
		items, and then go back and shove the cannonball down the drainpipe
		in the present? The items should come shooting out again, and thus
		never be there in the future for you to have picked them up, so 
		they would have to disappear from your inventory. Same deal. So
		I guess what I'll do is: if you haven't unclogged the present
		drainpipe, the future one will be so overclogged that even the
		cannonball won't have any effect. In fact, it's so clogged nothing
		goes down it. If you have unclogged the one in the past, then the
		one in the future will be uncloggable with the cannonball, but only
		things you drop down it in the future will be in there.
		
		You can see why this is taking so long. Sigh.

		(07-03-00) (1:01am) Yay! I finally finished going through Jota's
		first transcript. I had to add like a zillion new verbs and 
		scenery objects and nouns and whatnot, but I'm glad I did it.
		And now... on to the next eight or nine of them. Sigh.
		
		(07-03-00) (7:02pm) I started working with lurd's transcript today.
		This means a lot of business right at the beginning of the game,
		again, but it's good because he was trying things that didn't
		occur to Jota (amazingly enough). For example, opening and
		closing the library book. Also, he seemed to want more to happen
		when he typed READ BOOK. I got rid of the old libraryBook.ldesc
		("It has a blue cover with gold lettering", or somesuch) and put
		the old readdesc as the ldesc ("Tonight, like every night...").
		For the readdesc, it now prints the first ConsultAbout blurb,
		as if you had done LOOKUP TIME TRAVEL IN BOOK. I made 'READ ABOUT'
		a synonym for LOOKUP, too. It all seemed to work fine. Then I saw
		lurd trying to put the spare key under the mat. I had written that
		code last week, but hadn't tested it. Well, it was broken. Happily,
		it wasn't too hard to fix, and now it works fine. You can put the
		spare key back under the stones, or under the mat. I'm happy that
		these actions are allowed, because a good many players will likely
		try to do them, too.
		
		(9:09pm) What a long digression I just went on. I'm still on the 
		first page of lurd's transcript, because this is all somehow still
		connected to my trying to get PUT KEY UNDER MAT to work. I ended
		up writing and then subsequently removing a lot of dodgy extra
		code to handle GET KEY FROM UNDER MAT. The whole 'from under' 
		thing was a lost cause, so I took it all out. There was a funny
		bug where if you looked under the mat at the beginning of the
		game, it said 'You find , which you take' -- i.e., some kind of
		null object. The code should have worked. I had to change a call
		to ( doormat.underCont = nil ) to be ( length(doormat.underCont) = 0 ) 
		for it to work. Weird. Anyway, then I started rewriting some of the
		text for trying to unlock the door, ultimately replacing the first
		text (or some of it) that I ever wrote for the game, four years
		ago -- the "No suck luck! (Unfortunately, this game is a lot more
		complicated than that.)" I was just going to change the parenthetical
		statement there, wanting to replace "game" with "story". Then I 
		decided that was too mimesis-breaking anyway (there was a lot of that
		in my original writing) and made it a sort of premonition. Then I 
		described how there was "something in the air." So then I went back
		to my generic "air" object and twiddled with its descriptions. Then
		I recalled that I had written "Light streams prettily through the
		canopy of trees..." in the clearing. Jota had been trying to figure
		out what time of day it was. I always thought it was night, but that
		description was all wrong. So I changed it to "Moonlight streams
		prettily..." 
		
		And then I thought, okay, now I need to add "the moon" as an object
		you can look at. Since I added that, I had to add "the sun" and 
		"the sky" and "the stars" while I was at it, adjusting each for
		the various time locations. And then I had to make a check to see
		if the player is indoors or not. I put a flag for that, but I ran
		out of energy before being able to do the task of adding "indoors = true"
		to all indoor locations. That's going to require going through all of
		the code again and setting a flag on every other room. Sigh.
		
		I do a lot of sighing. What should happen is that I win the Xyzzy Award
		for Best Use of Medium, which is supposedly supposed to go for the IF
		author who has put the most number of original responses for various
		actions, so that the number of generic error messages is very few.
		Will I? Well, I don't know. I have to finish the game and release it,
		first.

		(7-04-00) (9:34pm) I told myself yesterday to take a holiday today,
		since it's Independence Day, but here I am anyway. I started slowly,
		just kind of poking around, pretending I wasn't actually "working",
		but I ended up doing a number of fixes. I got the code in place to
		give the lightning rod to the architect, although it still feels 
		tentative. I settled what I suppose is the final version of the
		game's score card, with 25 items and a total possible score of 141 
		points. Hm, I'm having trouble thinking of what else I did today.
		Those were the main things.
		
	Version 1.21 (7-05-00) (2:52am)
		
		My how the time has flown -- with my just trying to get the #$*(#$
		little car to work! For a useless bit of scenery, essentially a fancy
		container to hold the garage door opener, this has been a real pain
		in the ass to implement. Everyone wants to start the car, to drive 
		it (argh, wait, I haven't implemented DRIVE yet!), to open the hood,
		check the oil, look in the trunk, check the tires, etc etc etc. So I
		have to implement all of that (after all, this is at the very start
		of the game, so it's part of the general first impressions that any
		player will get). I mean, I guess I should really go whole hog and
		implement each little car part I can think of as a separate object
		and make them really work -- you can look through the windows, you can
		lift the windshield wipers, etc -- because this is one of the first, and
		most obvious, things to play around with at the very very start of the
		game. It's just so unbelievably tedious, made worse by the fact that
		I know it's all perfectly useless and no player should spend any time
		fussing with the car *at all*. But now it's been three hours tonight,
		and there's lots more I could still do with the car. Which means another
		hour or two to really finish it off, which means five or so hours of
		coding without MAKING THE GAME ANY MORE FINISHED. Oh, but I guess it 
		is. I'm just in a really foul mood because of all of the ridiculous
		fighting I had to do just to get this car code to work. I put an engine
		under the hood, but it wasn't showing up in the description, that sort
		of thing. Arrrrr. I was hoping to get more done tonight than just 3/4
		of the car, you know?
		
		(4:38am) Okay, I created an unimportantItem class to deal with the 
		rest of the car parts, interior and exterior. Even so, it still took
		me until now to finish it up, but I'm satisfied. Gunther and inky 
		heard my gripes and convinced me that unimportantItems were the way
		to go if the car really isn't meant to be functional. Whew. I'm glad
		that I implemented as much as I did, though.
		
		Side note: I've been working at home this evening since about 11:30pm.
		Maybe I'll work here tomorrow, too, instead of going to the coffee shop.
		Not sure, though.
		
		(7-06-00) (11:49pm) I took sort of a day and a half off, thankfully.
		I got started tonight with some completely silly business, prompted
		by something lurd tried ("ACT LIKE A NUT") -- which is to code in as
		many complete in-joke phrases as possible. These range from "HELLO
		SAILOR" to "I LIKE A MONKEY" and even "FRED, I LOVE YOU" and various
		combinations -- i.e., "FRED, I LIKE A MONKEY". Made sure the WAYLAY
		verb was there, as well as a passel of 'magic words' from various
		IF's -- Jota to thank for typing them all in succession during a 
		bored moment. Silly business, but earning brownie points, one supposes, 
		from any player who tries one, and, finding a response, tries more 
		of them.
		
		(7-07-00) (12:36am) Taking up again the goal of making the game 
		playable from beginning to end, even in a simplified form, I started
		to work on making the keyGrinder functional. However, I'm butting up
		against a big knotty problem -- which is that the player is free to
		make a duplicate of the car key, and then try to use it in all of the
		ways that the original car key can be used. However, all of the
		general code for making keys work relies on keyedLockable items
		having a "mykey" property, which only takes one argument. I'll have
		to rewrite all of that to work with a two-item "mykey" just for it
		to work. Argh, more with the stupid car! Either that or I can cheat
		and have the grinder spit out a faulty copy of the car key. That 
		would be the cheap and easy way to go, and I guess maybe I'll do
		that for now and see if anyone raises a fuss. However, if the car
		key makes a bad duplicate, players might think that it won't work
		for the house key, or that the grinder needs to be repaired somehow,
		which would be misleading. Grumble...
		
		(07-09-00) (10:20pm) A couple of days off, during which I recompiled
		Four in One and wrote a SpeedIF game, "A Scurvy Gift for Bosn Chuck".
		Now I'm trying to remember where I left off. Oh yeah. Duplicate car
		key. Let's see, I think if the mykey property becomes mykey( obj ),
		returning true or false, that will work...
		
		(10:38pm) It works! Yay.
		(10:55pm) Um, I mean, NOW it works. There was a lot of fiddly business
		with putting both keys under the stones. I also discovered that I had
		forgotten to handle putting anything besides the car key under the
		stones when I wrestled with that last week. But all is well, now.
		
		(11:21pm) Oh hey. The other day I was lamenting how to motivate the
		creation of the secret passage, and I just realized that I'd found
		a way to motivate it a long time ago, but forgot. You have to plug
		in the key grinder, and the only place you'll be able to do that is
		in the secret passage.
		
		(07-10-00) (12:48am) More fun with the key grinder. I'm working out
		all of its possible behaviors. It was working pretty well with all
		the combinations, until I realized that it would be possible to 
		make not just one corrupted duplicate (made by grinding the front
		door key into the shape of the car key, or vice versa), but two.
		You could, say, turn the blank into a duplicate car key, and then
		grind both car keys into corrupted duplicates of the front door
		key, one after the other. Doh. I'm now going to test the code for
		having two corrupted keys. If so, I think that accounts for every
		possible silly player action.
		
		There was also a little bug with the car key that had been hidden
		for some time, and which was thankfully easy to fix. Because it
		had a variable sdesc (first it's "spare key", then "car key" when
		you open the car with it), somehow the game was printing an extra
		newline whenever it came up in a GET/TAKE ALL series.
		
		(1:03am) Out of dissatisfaction with when the notify.t score
		messages got printed sometimes, I've deleted the module and added
		the code into verbs.t and the housekeeping() function I have in
		functions.t. That way, the messages always are printed after the 
		regular turn-handling output.
		
		(1:05am) ACK! I just typed FULLSCORE and got the full score list,
		even though I've only earned 6 points! I must have done something
		to make it go blooie when I tweaked it recently. Darn.
		
		(1:37am) Egad! The scoring system was all full of bugs. Well, not,
		but it looked like it. I kept thinking I would see a score message
		as soon as I found the spare key under the stones, but it didn't
		come until I picked it up. That's the way it's always been, so I
		guess that I won't change it. However, there were still a bunch
		of bugs in FULLSCORE that I'm trying to weed out.
		
		(2:03am) Uh oh, time to go home because this place is about to 
		close. I just weeded out some smellVerb errors, and some other
		things having to do with the time machine appearing and changing
		the light, and other things like that. Not a bad night's work.
		
		(07-11-00) (1:57am) Darn, about time to go, and I'm right in the
		middle of things. I started with making sure that WHERE IS and
		WHAT IS worked, implementing a clever .iseen system for all 
		objects, set to true if the player has come in sight of them yet
		or not. That will turn out to be helpful in a few places. Then I
		had to fix some Fred.actorDaemon code that was a bit dodgy. Then
		I set to trying to implement a help system, whereby the various
		characters will bring up topics if the player hangs around long
		enough. It's tied to the scoreCard system, which fullscore uses,
		and I've rearranged the fullscore list to be more appropriate to
		the order that I've seen people solve the puzzles in the game,
		based on transcripts.
		
		What I was just doing (whoops, there goes the 5 minute closing
		call) was finally implementing the thing where the wheelbarrow
		wheel completely breaks if you're trying to cart the miracle gro
		back to the time machine. Yet another frustration for the player.
		I've meant to do this one for years now, and tonight was the 
		night. Unfortunately, I have to pack up and go home without 
		being able to test whether it works or not. Sigh. I think I'll
		probably be picking up where I left off as soon as I get home
		tonight.
		
		(4:12am) Okay, starting up again. Unfortunately, it wasn't
		compiling due to an unterminated string, apparently in functions.t --
		but I couldn't track it down before I had to leave the coffee shop.
		So, that's the first order of business.
		
		(5:39am) I just finished going through all of the chooseTopic 
		options and assigning an item to talk about as a topic for each,
		which really gives me a sense of the whole game, and how the plot
		progresses. I finally have the sense that tha game is nearing 
		completion. What's left to do, really, is selling stuff to get 
		money to open the account. I think the account stuff works already.
		Then, buying stock. Then having things automatically get better.
		I think.
		
		You know, it's a tempting idea to forget about FutureLaura and
		FarFutureLaura, because it's dealing with them that was the extra
		long complication to be facing at this point. Perhaps I can still
		get to them, but for the next version I give to beta testers, one
		that you can play through from beginning to end, I can leave that
		stuff out.
		
		There are probably a zillion problems along the way from turn 1 to
		the end of the game that I haven't seen yet. I recall that I never
		fixed the ropeItem, for example. (Although, it worked three years
		ago, darnit!) But I really am seeing how I might be close. Hooray.
		
		(07-11-00) (9:59pm) I've been at it for an hour or two now, still
		monkeying with the hint system. I created a second one that does
		the same thing as asking Fred or Laura for information, but in a
		more general way, and linked to the THINK / THINK ABOUT verb. It's
		working pretty well. I'm still tweaking the order of the hints. I
		had them mostly set, but I think I need to reverse the first two.
		Most people find the spare key right away, so the first hint should
		be about that, instead of pointing you to go up on the roof. There's
		an odd bug with the garageOpener.isseen not being set to true when
		you open the armrest compartment, even after you pick it up. However,
		when I SNARFed it, it was set to true. I'm still looking into this.
		
		(10:40pm) Whoa, forty minutes. Anyway, while trying to figure out
		why the iseen was going kerflooie on the armrest compartment and
		the garageOpener (somehow, its being a container that is discovered
		by a search affects the way isVisible() works on it, so neither it
		nor its contents are having their isseen property set to true), I
		went off on a tangent -- changing the inventory listing to 'TALL'
		format instead of wide. It's sort of the Inform way of doing it,
		and I think players will prefer it. I then decided to change the
		wheelbarrow to list its contents in TALL format as well. These 
		little changes are also making me feel like the game is nearing 
		its public release state.
		
		(10:52pm) Woo, I think I just fixed one of the more annoying
		behaviors vis a vis the wheelbarrow, because I was tinkering 
		with how its TALL contents listing looked. Doing TAKE/PUT ALL
		when you're with the wheelbarrow would always grab things from
		the wheelbarrow even if they were already inside it. I watched
		Jota dealing with this repeatedly, but didn't realize there was
		a simple fix: set the wheelbarrow's notakeall property to true.
		Yay.
		
		There's another problem, though, that I don't get. The junk in
		the garage is not appearing in the right order. The divining rod
		and the machete keep popping up first, even though the first 
		item is supposed to be the crowbar. I don't want to spend too
		much time on this, but the idea was that an obviously useful
		item would appear first, so that the player might not suspect
		right away that there was more to come.
		
		(11:05pm) Whoops, I was way wrong. There is no simple fix for
		the wheelbarrow's contents. Unless maybe I make the item a 
		qcontainer, but that futzes with other behaviors. Hrrm. I do
		definitely need to fix this, because it's going to drive 
		players batty.
		
		(11:31pm) Finally got it working. I modified thing.noautotake
		to return true if the item is in the wheelbarrow, and that 
		seemed to work for TAKE ALL. For PUT ALL, I had to have the
		validDo just return the actor's inventory, which is probably
		all right in general anyway. Now I'm pushing the barrow around,
		and once again hit the years-old bug of moving doubly if you
		try to push the barrow from southOfHouse. Suddenly, the problem
		was obvious -- in my four-years-ago naivete, I had put a 
		travelTo() into the exit instead of just return()-ing the 
		new location. So it traveled, and then traveled again. Glad
		to have that old bug gone. That's been there since always.
		
		(07-12-00) (12:38am) Yow, can it really be the 12th of July
		already? Anyway. So, it all comes back to the little car. 
		None of the regular isseen stuff works for things inside
		the little car.
		
		(12:50) Argh. I'm getting bad room.firstseen behavior. I must
		have done something to mung the default behavior, because the
		firstseen.. oh. It's because isseen is getting fiddled with.
		Drat. That's what it is. I need to re-think my isseen property
		dingus, I guess.
		
		(1:06am) Whoa. I had set one of the returns on isVisible to 
		true when it should have returned nil. That was probably 
		what was doing a lot of the wackier damage. Sheesh. In any
		case, I also removed all of the lines that set isseen to nil.
		I figure, if it's set once to true, it should never be set
		again to nil. Well, except in the case that its location is
		nil. Hm.
		
		(1:45am) Okay, through various brute-force hacks, I've gotten
		all of the code working. I found even more littleCar-related
		bugs dealing with IN and OUT and searching with the door open/
		closed and ARGH! But everything's fine now. I'm testing the
		hint system one step at a time, making sure it's always saying
		the right next thing. So far, for the very beginning of the 
		game, it works pretty smoothly.
		
		One interesting thing this has taught me is that, even though
		the game is rather sprawling, and one is free to putter about
		in several different times/areas, the progression of puzzles
		is quite linear for most of the game. Which means that the game
		feels non-linear, but is actually linear. There have been a lot
		of discussions about linearity in IF on the newsgroups recently,
		so knowing where my game falls into the spectrum is interesting.
		I think it's quite a success to make a linear game feel to the
		player like it's wide-open, because that's been one of the big
		criticisms of linear games -- constricted movement.
		
		Okay, time to pack up again. Maybe I'll pick it up again in 
		a couple of hours.
		
		(5:14am) Starting up again.
		
		(5:46pm) I'm fine-tuning the hint system step by step. Basically,
		it's holding your hand through a walkthrough of the game. I wonder
		if this makes it too easy or if it makes it just about right.
		
		In any case, what I was going to say is that I was still having
		buggy behavior from rooms -- they were running their firstseen
		routines every time I entered, which meant that their isseen 
		property was getting reset to nil all the time. I finally hit
		upon the idea of distinguishing my object.isseen stuff from 
		room.isseen stuff, so that I wouldn't interfere with any of the
		normal room code. All I did was capitalize the 's', i.e., 
		obj.isSeen. I think that should take care of everything.
		
		Also, I straightened out the problem of the junk not being serial
		searched in the proper order by force-resetting the junk.searchCont
		list when you enter the garage the first time. (This was one of the
		reasons I noticed that firstseens were still acting funny -- if
		you left the garage and came back, you'd find the crowbar again
		when you searched the junk.)
		
		(7:00am) I've finished the hints (and various tweaks along the way)
		for basically Act I - Exploration. Hm, what are the other Acts 
		in the story called? Act II - Problem Solving. Act III - Making a
		New Future & Epilogue. Something like that. And now I'm going to 
		shut down for a bit, I think. I need to go do some Krone establishing
		shot filming in about an hour, and I think I'll relax a bit first.
		
		(07-13-00) (8:34pm) Hm, I didn't write any logs when I worked last night,
		a little bit just after midnight, and then more later in the morning.
		I was going through lurd's log again. 
		
		I just picked up again around 7pm. First I constructed a starting
		transcript, which goes through all of the basic "Act I" moves.
		I'll use it to provide a base saved-game for betatesters who have
		already been through all of this. It leaves you on the time machine
		platform in the present, with the library book, the car key, the 
		garage door opener, the crowbar, the five-dollar bill, the biology 
		book, the shovel, the bad shingle, the cannonball, the acorn, the 
		time machine manual, the package (which contains the Herring detector), 
		and the divining rod in the wheelbarrow, which is also on the platform. 
		You've been once to the far past, the past, and the future, and the 
		maze in the far past has already been traversed. You have 61 points, 
		giving you the rank of budding apprentice.
		
		Then I got knotted up with the money system. I think I'm going to
		have to look for a module that someone has already written, because
		this is going to be a pain to write myself. I've made an attempt to
		create a moneyItem class that handles things, but the whole deal with
		having first a five-dollar bill item and then a fourDollars item, and
		then varying amounts depending on what you sell and how much you take
		out of your account, etc etc., is knotty. It might grind things to a
		halt, but it's sort of the next thing to take care of to make sure the
		game can be played straight through.
		
		(9:19pm) Say, I just noticed that the game's status line wasn't 
		displaying the sdesc of the current location. That indicated to me
		that I'd messed up the default behavior -- and of course I had, with
		years-ago code. I've been customizing unnecessary elements, because
		more recent versions of TADS have added hooks for doing the kind of
		thing I was doing with brute force hacks for TADS 2.2. Time to fix
		that, I guess.
		
		(07-15-00) (1:47am) Been at it a couple of hours. Finished lurd's
		transcript, finally. Had to add CHASE and CATCH and other verbs that
		he knows darn well aren't part of the standard library. Otherwise,
		looking good. Added SPRAY for using the WD-40 -- which maybe makes
		it less of a red herring, too. I guess it's a functional red herring.
		One of the problems with all of these transcripts is that they cover
		only Act I. I suppose Jota made headway into Act II and I should 
		concentrate on those trancripts instead of more Act I transcripts.
		
		I haven't made any final decisions about the money system since two
		nights ago. Also, updating the statusLine stuff to TADS 2.5 room 
		code didn't quite work smoothly. I thought it would, but the arrangement
		of bookending hooks always either ends up deleting a line break I want
		or adding a newline where there's no need for another. This is a bit
		frustrating, just because it means I'll have to paste in the entire
		nrmlLookAround (or whatever) code and change one line of it somewhere,
		which is what all the hooks are supposed to save you from having to
		do. Sigh.
		
		Okay, bit silly for me to still be here. I've got a filming day 
		tomorrow, starting at 11am. Time to go.
		
		(07-16-00) (11:37pm) Started up tonight working on the money system
		again, instead of finding a module that someone else has already
		made. I created a "sellable" class for all items that you can sell,
		although there are only two so far (the cannonball and the wheelbarrow).
		I've just written a function to handle the problem of getting more money
		if you're holding the five dollar bill or the fourDollars object already,
		or vice-versa -- picking up the five/four dollars if you've already got
		some cash from selling an object. Don't know if it works yet, but if it
		does, then we're getting darned close. I can see having a game you can
		complete by the end of this week if I keep at it for another six days.
		
		(7-17-00) (2:01am) Uh oh, time to go, and there's still issues with
		my re-writing of the heating/cooling off code. It's weird to be shoving
		around four year old code. But, got to go. Will fix at home, I think.
		
		(8:09am) Okay, I didn't get started until about 7:30am. I was playing
		through, and discovering bugs. Argh. One in particular that's rather
		unsettling (because I don't know how to track it down) is that the
		spare/car key doesn't get parsed in get/take all commands. Ummmmmmm.
		
		(8:13am) Oh, whew. It's because of some silly hack-work I did to make
		it still parseable when it's hidden under the stones or the mat. Argh.
		I guess I'll leave it the way it is. It's not really broken, it's just
		that I used a special testing verb to snarf it without looking under the
		stones to pick it up, and isfixed was still set to true.
		
		On the plus side, money code seems to be working. Well, kind of. Somehow
		five dollars turned magically into ten dollars, which wasn't so good.
		However, I used that bug to make a total of 105 dollars, so that I could
		open an account and still buy a sandwich from Fred.
		
		(9:07am) I seem to have gotten things to work. Money works. The car
		key works. The time manual can be read (including invididually 
		numbered chapters). Whoops, wait, money doesn't quite work -- I had
		money tucked in the package, and it vanished when I received cash for
		selling the wheelbarrow. Sigh. Darn. And I'm definitely too sleepy to
		continue at the moment.
		
	Version 1.2.5  (07-18-00) (12:31am) 
		
		Picked up again around 10:30pm tonight, and plunged right into the
		task of creating a working ATM machine. Kind of a fun little exercise, 
		kind of like something you'd do in CS 101. I think it works. Haven't 
		tested it yet. I did surprise myself with something I did a long time 
		ago, which is that as soon as you go into the mailbox location in the 
		future, after having opened an account, it prints out the message, 
		"There's something in your mailbox." Excellent. I'd forgotten that 
		I'd done that, since I'd never gotten to the point where I could 
		successfully open an account before.
		
		There is still a little bit of a problem with the handleMoneyTrade
		routine that I need to sort out, as well as a rewrite of the updateAccount
		function (if you withdraw cash in the future, the future account balance
		will get reset to its pre-withdrawal balance when updateAccount runs, 
		which is not good).
		
		Dagnabbit, I'm getting close here. Hooray.
		
		(1:13am) Whoo! It works! Well, apart from the things that I just
		mentioned still need to be fixed. What I mean is that the ATM
		machine works pretty well now. I took out 20 dollars and then
		bought both sandwiches from Fred. Excellent. Next thing to do
		is make the secret passage appear, and have the keyGrinder work
		there. And then the thing about buying stock. Still up in the air
		is exactly how buying the stock makes any difference. I think you
		have to meet future Laura, and have her make an offer to buy your
		property, that you refuse. She will recognize you as the majority
		stockholder of DibbleBits (because, perhaps, she won't appear until
		you are the majority stockholder of DibbleBits).
		
		And after that, I think you can move into the New Future. How about
		that?
		
		(07-18-00) (11:24pm) Got started again an hour ago or so. Decided
		to test (and create a script for) Part 2 of the game -- planting
		the acorn, growing the tree, going into the attic, getting the
		blue pencil, bringing the hot sandwich to the architect, and 
		changing the blueprint so that the secret passage appears. I
		encountered a number of little bugs along the way. The rope code
		actually mostly worked. I got out with the blue pencil, but I'd
		goofed with the compartment when I twiddled it the other night,
		and so I couldn't put the sandwich in it. However, this operation
		was more of a success than not, thankfully. I wonder how much I
		can get done tonight. I'll have to leave here in two and a half
		hours. I haven't been very good about picking up when I get home
		again, but tonight I might have to force myself, because I'm 
		really running short on time to keep hammering at this game. My
		time and energies really need to go other places. I'm darn close
		now, though. Darn close.
		
		(07-19-00) (1:40am) Darn. I almost have the secret door/switch/passage
		stuff working. Lots of compiler errors that I don't have time to fix
		before I have to go home. Grrr. Oh well.
		
		(1:49am) Whew. Got the compiler errors weeded out. Now I can go 
		home with a clean conscience.
		
		(4:00am) Starting up again. Let's see how far I can get to the
		end in a playthrough.
		
		(4:45am) The answer is -- not much farther. I just realized you
		don't have enough money to open an account if you buy a sandwich
		with the five dollars. That's going to drive people crazy, but
		there it is. However, I think you'll be able to sell something
		else to make up the difference -- perhaps the tv set in the
		future house. This leads me to the chore of implementing objects
		described in the house, which I left undone several weeks ago.
		There's also the problem that the living room ldesc is dependent
		upon the television set's being there. That probably wasn't a 
		good idea anyway, but that's where I'm up to.
		
		I still haven't implemented a locksmith shop NPC. He (or she --
		but actually I think the antique store NPC should be a she)
		probably can say something about "Well, we're goin' out of 
		business because that damn corporation's buying up everything."
		Or somesuch.
		
		So let's see. I make it so that you can sell the tv to open 
		the account. Once you've opened the account, you can buy the
		key grinder. Then what I'll need to do is add the buying-stock
		thing. In order to do that, I might need to implement the bank
		teller, but that's probably not too big a deal.
		
		If I do all that, then I need some way of wrapping things up
		so that the New Future gets created. The way I've been thinking
		of just in the past few days is a scene where future Laura 
		appears and tries to make a deal with you. If you say no to
		all her deals, that's it, that's how you win. If you say yes --
		well, hm. There probably should be a way to undo that, because
		otherwise you end up at the end of the story but with a bad
		ending. Hm. Hm. Hm. Okay, now I'm worried again that I actually
		can't finish this by the end of the week. Well, let's try to 
		streamline what we do as much as possible and see what happens.
		
		(07-19-00) (5:39pm) Okay, so where did I leave off this morning?
		I was cruising through the house in future.t, building decoration
		items. I notice that I could have been using adv.t's "decoration"
		class, instead of making my own "unimportantItem" class. I 
		suppose I could change it, but oh well. Too late. I finally got
		to the tv, which you can take -- ooh, I forgot to make it an
		item that you can sell -- and ended up creating plug and socket
		classes, and making the keyGrinder work as a plug-in device,
		and making an electrical socket appear in the secret passage.
		I still need to finish going through future.t house, and I need
		to clear up an ambiguity problem with >DRAW SECRET ON BLUEPRINT,
		because I have quite a number of items with the adjective 
		'secret'. Hm.
		
		(6:34pm) Just finished wrangling out the DRAW SECRET ON BLUEPRINT
		ambiguity, and ended up writing a few paragraphs of cut-scene text
		to play out after the architect comes back and sees that you've
		changed the blueprint. Before, he made no reaction whatsoever,
		which wasn't quite right. Let's see -- back to future.t, I guess.
		
		(8:15pm) Whoa, almost two hours have passed. I just finished
		building all of the house items. I cut out one of the rooms 
		because I just didn't have the stamina -- a walk-in closet in
		the master bedroom that would have been just another empty room.
		Why have a large dresser if you have a walk-in closet, anyway?
		I built secret door code for the bedroom (untested), and had to
		come up with some interesting new verbs to handle various bathroom
		fixtures and the paraphernalia in the master bedroom. Seems pretty
		good. Assuming all of this works, I think I've built everything I
		need up to the buying-DibbleBits scenario. Hmmm.
		
		But first, a short break.
		
		(8:19pm) Wait, I forgot the garage! D'oh!
		
		(10:51pm) Whoa, two and a half hours? It's amazing what a refill
		of coffee will do. I've been powering ahead like mad, working out
		more secret passage stuff. By accident I had assigned all of the
		master bedroom secret door stuff to that location instead of having
		them be nil, but that was good because it let me test them for the
		first time. The secret door opening mechanism is really pretty 
		nifty -- step on the switch, knock on the wall, and zing! The
		door opens. Worked like a charm, first time. Amazing. Now I'm
		tunneling into the secret chamber and trying to decide what to
		do with it. It's my old idea of having a second time machine that
		allows you to -- hm, it just occurred to me that instead of the
		secret chamber I've described, it should be a natural limestone
		cavern. Well, okay, if you take the second time machine into the
		far past, it will be. That's another old idea, that the time 
		"locations" of the game are supposed to roughly correspond to
		eras of IF. Therefore, there should be some sort of natural cave
		crawl in the far past. I always thought that it would lead from
		the grotto to a cavern under the house where you'd find the time
		machine. I think I will do that, but it makes more sense to have
		the cavern be findable-but-empty if you go through the grotto 
		without having opened the secret passage. Putting the time 
		machine in the present -- ooh, I haven't made that clear yet --
		will make that work out.
		
		Gee, the ideas are still coming. Actually, most of these are
		ideas that I just hadn't seen how to assemble together yet.
		I'm almost wondering if the DibbleBits thing doesn't need to
		happen, but I think it still needs to.
		
		Time to get back to it. I've got another 3 hours before I have
		to go home.
		
		(07-20-00) (12:45am) Got sidetracked taking care of some old
		unfinished business again -- which is being able to write or
		draw something into the wet driveway, and have it show up from
		then on in all incarnations of the driveway. I'd wanted to do
		that for a while, but hadn't gotten around to it. Funny, I don't
		think it occurred to me when I first put in the wet driveway, but
		it was one of those ideas that just seemed appropriate during my
		recent thinking about the game. It does make it interactive, at
		least, which it wasn't before.
		
		I'm not sure how I ended up doing that when I started out making
		limestone crawls in the far past. Umm. Somehow it sidetracked from
		putting a working lightbulb in the secret passage. Oh well, never
		mind. Back to cave digging.
		
		(1:58am) I just finished building the cave crawl all the way to
		the end. Instead of a limestone cavern, it's a crystal cavern.
		Just a week or so ago I read about one being discovered in Spain,
		so in it goes. And this is a wonderful stopping place for the
		day's work here.
		
		(07-20-00) (11:25pm) Started tonight by chasing a random idea I
		got this morning, when I was playing the game at home and noticed
		that the grotto pool -- which I spent a lot of time coding up --
		didn't seem to exist where it should have. In other words, I 
		forgot to set its location property. I've done that so many times
		recently that I decided to make a storage room where, by default,
		everything would sit that didn't have a location property set at
		the beginning of the game. That way I can check in and see whether
		something hasn't had its location set that should have.
		
		The first time I did this, the only unusual thing I saw was an
		object with no sdesc or ldesc or noun -- basically a blank object,
		except that it was a container. I jiggered things to give all items
		a noun and sdesc ("groo"), but that didn't really help because noun 
		properties are additive, so everything, including the mysterious
		"groo" object, was parsed when I tried to inspect the "groo". So
		I did some more fiddling, realizing I could try >PUT ALL IN GROO
		to isolate the one I meant, and created a wizard verb that could
		teleport an item somewhere else. That way, I could teleport all
		of the other nowhereRoom container items away. Then I used the
		debugger, putting something into the groo and taking it out again,
		and seeing what the object was that was holding it. I was for a long
		while baffled, but finally realized what I had done -- when I made
		the doubleKeyedLockable class (for things that could be opened by
		a real key and a duplicate key), I forgot to use the "class" 
		directive. So, it was just an instance, not a class. I didn't 
		realize that new objects could inherit an object as a class, but
		evidently they can. I could create Foo: FFred, and it would inherit
		everything from FFred even though he's not a class.
		
		So, an hour went away while I futzed with this and then wrote about
		it. I haven't quite got my bearings as to what I should be doing
		next, exactly, is the problem.
		
		(07-21-00) (12:24am) I've been occupying myself with building the
		second time machine. I'm actually using the behavior I just discovered
		to kind of cut down on some of the code. I'm declaring things this
		way:
			timeMachine2: timeMachine
			alertLight2: alertLight
			platform2: platform
		
		Et cetera. I've also put all of the functions that move the time
		machine around into the 2nd time machine components. They are 
		separate game functions for the first one, because that's all I
		knew how to do when I wrote them four years ago. I feel like leaving
		them there just to cut down on work and to preserve the bits of the
		game code that are older.
		
		Lots of compiler bugs. Time to try this thing out.
		
		(1:47am) Finally got the second time machine working. Turns out the
		assignment thing was a total bust. And then I hosed myself further
		by once again forgetting the "class" directive when I made my fix.
		Oops. But, it seems to be working now. All is well, and now it's
		time to quit again, darnit. I hate these short working days.
		
Version 1.3.0 (07-21-00) (8:38pm) Urk. I made an attempt to start working at about
		8pm, after a long day with not enough sleep. I tried working out how
		the teller window would work, though really what I wanted to do was
		just do some generic buying-DibbleBits-stock thing. Now I'm really
		feeling the fatigue, and think maybe I don't really have the goods 
		to do any good work tonight. Maybe I could if I stuck to something
		really simple and mindless, but this teller stuff is too complicated
		at the moment.
		
		(07-22-00) (10:33pm) Grrnngh. I'm trying again to do the deposit/
		withdrawal stuff, and it's still too complicated for me to handle.
		It's tempting to get rid of it entirely, but that would mean getting
		rid of too much. There wouldn't be a Laura if there weren't an account
		to open, for example. Maybe I should write something else for the moment,
		like future Laura and far future Laura. Except -- argh. I really need 
		to figure some stuff, still, apparently. Eeeagh. I want to finish this
		by the end of next week, so tonight's the night to figure this out.
		
		(07-22-00) (11:45pm) Fixing What Ain't Broke Dept.: I was noodling
		around trying to think of a way to fill empty jugs with water, and
		was hacking around with four-year-old jug code that WORKED FINE FOR
		FOUR YEARS, and when I was in it up to my elbows I realized that I
		didn't really have a firm grasp on what I was doing and stopped.
		Since filling jugs with water isn't a solution to anything (except
		Jota's misguided wishes), maybe I shouldn't be trying to make it
		work at the expense of functionality that I can't afford to lose 
		this late in the game, as it were.
		
		(07-23-00) (1:50am) Okay, finished twinking with pouring stuff. Shut
		off FILL JUG stuff with "That's not important." Made a waterItem
		class to help with that, as well as providing generic water interactivity
		(wading, swimming, drinking, etc.). Then I remembered that I'd meant to
		add some extra stuff to the part where you drop the rope out of the 
		attic window after tying it to the pipe, so I did that. And now it's
		time to go again, sigh.
		
		(07-23-00) (8:43am) I started up just after 7am and tried to figure
		out account and money stuff. I actually managed to get deposits 
		working. I opened the account, went to the future, took out $9400,
		went back to the past, deposited the $9400, and ended up with a new
		future account of something close to a million dollars. Just when I
		was thinking this was all too much trouble, that kind of thing is too
		much fun to pass up. However, I'm thinking -- how realistic should this
		be? ATMs have limits on how much cash they dispense at any one time,
		or during one banking day. There's also the idea of the player carrying
		vast piles of cash around. Maybe people would think it was funny, or
		maybe I need to give the player something to carry the cash in, or ...
		I dunno. So suppose the player ends up with multiple millions in the
		bank account. Then what?
		
		I guess that's the question, but I'm too tired to work out the answer.
		Time to quit until later today or tonight, I guess.
		
		(07-23-00) (10:49pm) I'm a couple of hours into it now, at least. It's
		one of those nights where I start out intending to do one thing and 
		end up ensnarled in a huge sidetrack. I was going to actually build
		some far future rooms, things inside the skyscraper, when somehow I
		got off on the tangent of allowing the player to both buy and sell
		things in the antique store. I had the selling thing down, but I 
		forgot about the buying. I now have a bunch of untested code -- but
		code that compiles anyway. One snag was if the player wants to buy
		back something already sold -- for example, the wheelbarrow. Darn,
		I forgot about the cannonball. Hrm. Oh well. (Okay, just fixed that
		for the other sellable items.) No idea if this stuff works.
		
		New ideas: the antiques are going to be a searchHider like the junk
		in the garage, holding all manner of things. Like the junk, only a
		couple of them will be useful. One will be some sort of briefcase,
		allowing you to withdraw and carry a gigantic pile of cash from the
		future back to the past. I think I might need an interior bank 
		location in the future as well as the far past, because that way you
		can make an enormous withdrawal from a teller that you couldn't do
		from an ATM.
		
		Some details I'm skipping over in all this are 1) having to show some
		form of ID to do transactions, and 2) having to fill out forms in order
		to do transactions. Ehn. Who cares.
		
		There might be an ATM in the lobby of the big skyscraper. I'll 
		probably allow you to go in there from the parking lot, but a 
		security guard will stop you if you try to use the elevator to
		go anywhere. Thus, if you use the second time machine to go there,
		you can get on the elevator there and ride it up past the lobby.
		However, I think what happens in that case is that security guards
		pick you up anyway, and take you to see far future Laura to be 
		interrogated to a degree.
		
		So, things are moving. There will be an investments/brokerage 
		place in the far past bank (and maybe in the future bank, too,
		because it'll be the same bank). With sufficient funds, you can
		buy a rather enormous stake in DibbleBits, which will affect
		things in the future in some way I haven't quite worked out 
		yet. However, with the stuff I've done this weekend, I think
		I am still on track to have a winnable game by next weekend.
		Here's hoping.
		
		(11:08pm) Woo-hoo! I just bought the wheelbarrow again! It worked!
		
		(07-24-00) (1:29am) This is probably a good stopping place for the
		night. I've spent the last hour and a half making sure my little
		auto transcripts work correctly. They do, so now I have working
		walkthroughs that go about up to where I've finished coding the
		game, which is finding the second time machine. I just made a test
		of depositing money, taking the 800 thousand dollars or so out of 
		the future ATM, and putting it back into the far past bank account.
		When I returned to the future, I had something like 86 million
		dollars in the account. That's funny. I'm going to have to put a
		hard stop on the player doing this deposit trick any further than
		this -- there's almost a danger of the numbers getting too big for
		the computer to handle. So probably after the second deposit (or
		third?), the teller window will close, or some such. The player
		should be buying stock after that point, anyway.
		
		But -- hey, everything works up to this miraculous point that's
		very, very, very near the endgame. Pretty exciting. My gosh, I've
		almost reached the finish line.
		
		(1:40am) Eeeeagh!! While I was trying to back up to the floppy before
		leaving I got a fatal Windows error! And now the computer has been
		acting screwy and refusing to talk to the floppy drive! AIIEEEEE!!!
		
Version 1.5.0 (07-24-00) (4:29am) This version is going to be the first winnable
		beta. Once I get it so that I can play the whole game with walkthrough
		scripts, that'll be the official 1.5.0 version. Then I might do a 
		version or so after that, as I add anything else I can think of
		before handing it to beta-testers, which will be Version 2.0.0 beta.
		What I'm trying to remind myself to do is to disable wizard verbs
		and XYZZY (currently, xyzzyVerb magically plants the acorn and 
		pours fertilizer on it) before handing it over. Hm. Anyway, starting
		work again this morning, things to do: buying stock, skyscraper 
		interiors, past.t workers activity (and Infocom references).
		
		(7:19am) No way, has it been this long? Nearly 3 hours? Egad. I guess
		"Jaws" has played all the way through at least once on the DVD player
		since I started. Wow. Okay. So, all I've done so far is work on past.t,
		getting the worker activity (and then lack of activity during lunch
		break) working. I just stole code straight from 4in1 and then changed
		the messages (often just changing nouns and adjectives and leaving the
		rest), which is why I'm surprised three hours went by. There were a lot
		of little details to take care of, but you know what? I think I can
		pretty much call past.t finished. Hm, there might be some decoration
		items to put in the underground "broken cavern" room, but otherwise,
		I think that's a 'wrap' for past.t -- which is quite a good thing,
		I think. If I could just wrap far_past.t... and then present.t... (hm,
		is present.t already finished? It might be) and then... etc...
		
		(07-24-00) (10:23pm) Starting up again. So let's see... either the
		brokerage stuff or far future interiors. I think I'll start with the
		far future interiors.
		
		(11:50pm) Well, so far so good. I've built the lobby and a security
		guard to sit in the lobby (and throw you out if you try her patience).
		Next, maybe I can connect the storage room (2nd time machine location)
		to the lobby...
		
		(07-25-00) (1:14am) Have to make a stopping point here to take care of
		some other business. I've built the sub-basement, short-cutting for the
		sake of necessity the implementation of more than a couple of rooms. It
		also lets the player know that endless exploration isn't necessary. Why
		not? Ok. So, I've left off with needing to build elevators, and then
		what happens if you get out of the elevators. This is all fairly good 
		progress, I think.
		
		(07-25-00) (8:58pm) Started tonight with some futzy things... adding
		a BRIBE verb (for the security guard), a VERBS verb to list all verbs
		in the game, and some other meta-stuff that's slipped my mind already.
		I want to get back to the buying-stock idea, leaving aside the far 
		future for the moment, though.
		
		(07-25-00) (10:48pm) Long digression of putting a wrench in the attic
		just to do an awful pun (in response to a classic awful pun). That's
		a joke I've planned to put in for ages, but hadn't yet. That led to
		noticing that I hadn't sorted out things about the future.t house, and
		being in the attic, and making the descriptions dependent on the state
		yet. This is all stuff I've needed to do, so I guess building new stuff
		will have to wait until I make it through these older, back-burner things.
		
		(07-26-00) (12:10am) Still cleaning up attic stuff, or in this case,
		window and rope and tire stuff. For the longest time, I had made it
		so that you can't climb back into the attic once you've successfully
		climbed down from it. That doesn't really make any sense, though, so
		it's once again an option.
		
		(12:16am) I just remembered what I was looking at that got me off on
		three hours of attic digression. I was going to finally implement the
		shimmy-along-the-broken-trunk method of getting into the attic. So, 
		time to do that, finally.
		
		(1:48am) Have to stop again at a real cliffhanger, with the player
		hanging for dear life on the underside of the tree, with only one
		turn remaining before their grip gives way and they plummet. I don't
		know what happens next! I'm not even sure how they get out of it. On
		the whole, though, this tree-shimmying adventure has turned out as
		good as I'd hoped, with a kind of Zarfian pulse going through it.
		I'm now trying to think of ways to make this the "real" way into the
		house in the future, but you can always ignore it and pry the boards
		instead. Shucks, because it's really pretty nice and I'd hate to think
		about people just giving it a miss by the dozen. Hrm.
		
		But I have to go home again now. I wish I'd started an hour eariler.
		Sigh. Still, good work, again.
		
		(07-27-00) (1:05am) I meant to get an early afternoon start today and
		work a full shift, but unfortunately I didn't get going until after 
		8pm again. I've spent this evening working again on the broken-trunk
		crawl, and it's still not finished. What's there is more robust, with
		some rewriting to tighten it, and with scenery objects implemented,
		but I still haven't coded any farther than the cliffhanger I left 
		on last night. I'm also flagging, feeling my brain's resources fading.
		I also feel that the work on this has left me at least one day behind
		schedule, and there's no way the game will be ready for Beta 2.0 by
		this weekend. In fact, I almost have to predict it will be another
		week after that at least, since I'm going to be filming this weekend.
		Thursday, Friday, and Saturday will be devoted to that.
		
		Maybe I'm just forgetting how close I am. Maybe this whole trunk-crawl
		is a metaphor for trying to finish this game. Heh, I think that may 
		actually be accurate, although I conceived it before I was in this
		metaphorical state -- before I felt myself shimmying forward, inch by
		slippery inch, the goal stretching farther back, an endless hallway of
		a nightmare...
		
		Anyway. Feeling like this is probably adding some subconscious power
		to the writing, which is good. I now definitely have to block the 
		player from entering the house any other way than this. That means
		that you can't pry open the front door, and the garage door will be
		closed and locked and unopenable. It also means you can't get the 
		lightning rod until after you've done this. I thought that, perhaps,
		having the player need the money to purchase the lightning rod would
		be curtailment enough (and a fairly elegant means to that end), but
		it's possible to sell the wheelbarrow straightaway and buy the rod.
		I guess I can have the antique merchant suddenly put a lightning rod
		on display only after the player has entered the house in the future,
		or something. It feels heavily contrived -- I like the sense of 
		nonlinearity that the game provides, even though it is quite linear
		in design. I'll have to think about how to do this gracefully.
		
		Sigh. I think I might have to stop here for now and reconnoiter later.
		If possible.
		
		(07-27-00) (6:57am) Another hour into it now, or so. Sat down and 
		worked through all of the new verbs and such that I can think of for
		the player to use at the cliffhanger point. Unfortunately, it does 
		seem to be a bit of a guess-the-verb puzzle because of it. However,
		it seems likely that the player will try to CLIMB. It is much less
		likely that, without prompting, the player will try to RELAX. Will
		the player try YELLing, or YELL FOR HELP, or PRAY, or even PRAY FOR 
		HELP? Those are alternate solutions, anyway. I can't decide whether
		Fred or Laura (or both) would come running to help the player if the
		player screams (or prays) for help. If Fred comes running, which was
		my first thought -- show that he's still a good guy under there --
		it sort of goofs up everything I wrote for his appearance. All of 
		that complicated stuff would have to get slightly more complicated
		to account for his remembering that he just saved your life. Hm,
		maybe if he saves you, you get a completely alternate version where
		he's already found his bottle and is just in his garage, short-cutting
		the other introduction for this one. I suppose that's possible. Different
		branches of the story, depending on what you do, but the story continues.
		Hmmm. That's possible.
		
		I did also like the idea of Laura and her Lothario Corp goons saving
		you, too. Same kind of reason. Then she could start grilling you right
		then and there. Or maybe she and Fred come running, and she can yell
		at Fred and you at the same time, and get a lot of exposition out of
		the way. Hmmm. Hmmm. Well, I sort of have to choose, don't I?
		
		Unless yelling brings one of them and praying brings another and
		just falling off without yelling or praying brings both. Or. hm.
		Some combination. I guess I've got three choices and three outcomes,
		and I just need to decide. Then there's the fourth way, where you 
		make it into the attic and met Fred as I wrote a month (!) ago, and
		Laura shows up on her own steam the way-I-had-planned-to-do-but-hadn't-
		completely-sussed-out-yet.
		
		Since I've got all the verb hooks in place, and now it's time to put
		on the writer's hat (instead of the programmer's hat) again, I think 
		I might once again take a break for now and come at it fresh. Gee,
		will that be later today, or days from now? Sigh.
		
		(07-30-00) (10:34pm) Urgh. Three and a half days off is a long time.
		It's not even three and a half days of reinvigorating rest, either,
		but three days of trying to do KRONE movie stuff. I know exactly 
		where I left off, but I'm having some trouble gearing up again
		mentally. Oh well. Let's see. Hanging for dear life, right? Hm...
		
		(07-31-00) (1:41am) Quitting time again. Surprising though it may
		seem, I haven't finished off this section yet. I did work out all of
		the code to climb back to safety, but I have only just barely started
		the yell-for-help outcome. I haven't written the you-fall-off-the-tree-
		because-you-took-too-long outcome at all. This means that it'll take
		another working day to finish it, if it'll even be finished then. What
		it will mean is that by the time I'm done, I will have finally written
		the code to introduce future Laura, which otherwise I had no plans to
		do yet. I will also be sort of set up to finish the Fred-meets-future-
		Fred scenario, still left hanging from a month ago.
		
		In any case, I'm glad I've gotten a little farther, even if it's not
		very much farther.
		
		(08-01-00) (12:52am) Another short night, I think. I've written two
		thirds of the outcomes now, and am pondering eliminating the third
		one I had planned -- one, to reduce the workload before I can keep
		going; and two, because I can't quite figure out a three-outcome flag
		that works for the situation. I wrote a huge chunk of text for the
		Laura-rescues-you scenario, but I'm not sure it's appropriate for 
		the situation. Some of the ideas in it were supposed to be played
		out in the far future, with far-future-Laura. I might have to do
		some rewriting and smushing things around, and I still don't feel
		like I'm firing on all cylinders again yet. My brain is just plain
		tired, and is requiring more force to make it work.
		
		I suppose the good coincidence of timing here is that I spent the
		weekend (and all last night) reading Adam's novel, so his writing
		style is in my brain right now. The tree-trunk-shimmy was supposed
		to be Zarfian, and all of the bits with future Laura were supposed
		to be Cadrean, and it has worked out well enough that way.
		
		I think I'm going to stop and do something else, and I don't know
		if I'll work on it at home later tonight or put it off until tomorrow
		again. The fact that I really don't seem to be close to finishing 
		this off, once again, has really bruised my overall morale.
		
		(08-01-00) (10:15pm) Been at it for a couple of hours now. I started
		working on making future Fred walk away from you after he saves you,
		and that led to a lot of small refinements to the actorDaemon code
		I wrote a while back for meeting him in the house. With a couple of
		extra checks to see if you had already met him, and where you are
		standing at various points, I could segue fairly easily into the 
		old code if I just moved him as far as the kitchen. I relied on the
		fact that he's drunk and has no short-term memory to speak of in order
		to gloss over the fact that he talks to you like he's never seen you
		before. Nice and tidy. I also finally changed it so that you cannot
		open the front door from outside, eliminating that as a way in. I 
		secured it so that you cannot open the garage door from the outside,
		eliminating that possible entry, also. That leaves the tree as the
		only entrance to the house, provided I come up with some means to
		have the player not get ahold of the lightning rod until after the
		player enters the house. Hm, I feel somewhat back on track again.
		
		Two things left to do in this future.t module: introduce future 
		Laura, assuming you make it safely into the house without having
		her goons catch you; and the scenario where Fred, Laura, and Laura's
		goons all come to your aid when you yell for help. Hmmm. Okay. Not
		bad. Not bad...
		
		(08-02-00) (11:16pm) Details, details. That's what I've been working
		on tonight. I remembered that I still hadn't worked out all of the
		future.t house exteriors to change their descriptions and exits to
		be based on the future.state. So, that's what I've been doing. It's
		also led me to make some fixes to some old present.t code for going
		up the stone wall, and such things. I think I've managed to do it --
		hm, except for the FfrontOfHouse location. That should cover all of
		this stuff, I think, and get me back on track to work out the 
		new scenarios I described in last night's note.
		
		(08-07-00) (5:44pm) Five days off is a long time. I guess it was a 
		refreshing break. At least now I won't have to deal with power supply
		problems that get in the way at inappropriate moments. Where in the
		world was I? I suppose that I can pick up anywhere I want to now that
		I'm starting up after a break, and see where it gets me. Hmmmm...
		
		(8:04pm) Okay, I just spent the last half hour drawing in my sketchbook,
		so I can tell my heart isn't in it tonight. I did manage to set up the
		arrival of Laura if she isn't the one who rescues you from the tree,
		but it's still got problems. I got sidetracked clearing up various
		problems with FFred's actorDaemon2 code, and things having to do with
		room description printing. When I first wrote the original FFred 
		actorDaemon code, I was confident in the assumption that the player
		would have to already be in the house, so I didn't make any conditions
		for the player, say, wandering into town while FFred was moving around.
		Now, however, that's a possibility. There's also a lot of weird special
		cases for calling Laura to the scene. I just don't have the concentration
		to tackle these now, so I guess that's for tomorrow.
		
		(08-08-00) (10:57pm) Okay, things left hanging yesterday evening seem to
		be more or less sorted out. FFred's chain of actorDaemons is now in working
		order. A problem from yesterday -- that if Laura rescues you, you are left
		with no way into the house -- has been sorted out. FFred pops out of the
		garage after she leaves.
		
		What could I do next? I could write the scene where Fred meets future Fred.
		That would also be, I've decided, what triggers the appearance of the 
		lightning rod, because once you get the lightning rod, doesn't FFred 
		disappear? Hm, maybe not. FFred would disappear when somehow you change
		everything by becoming rich and powerful. Another thing I need to do is
		write askAbout dialogue for FFred and FLaura -- assuming FLaura shows
		up again long enough to talk to her. Hmmm.
		
		I'm definitely having trouble getting back into the swing of this. Too
		many days off, too many resources shifted to KRONE activities. I'm close,
		though, right? Just need to keep at it, right? Hrrmrmmrmmm.
		
		(11:50pm) Just wrote the Fred-meets-FFred scene and consequences. That
		might be all for tonight.
		
		(11:59pm) It all works fine, except the score notification doesn't happen
		until the turn after Fred disappears, which is a problem. Not sure how to
		solve it, but that's tomorrow's problem, anyway.
		
		(08-10-00) (7:52pm) Cancelled a day and a half of Krone shooting, buying
		myself an extra night of working on this. When I left off, Fred's exit
		had a problem -- the score notification message happened the turn after
		he left, a problem caused by calling a daemon from a daemon, sort of.
		So, I fixed that with a clever hack, but it still didn't work -- because
		of the order that daemons are run, the score notification happened before
		the text of Fred's exit was printed. Grr. So, I had to do yet another
		hack, and use the housekeeping daemon to print Fred's exit text, which is
		not what that function is for, but oh well. Maybe there's some clever way
		to organize the order in which daemons are run, but I'll let the hack do
		for now. So, that all seems to be working. I even have it handle the case
		of the player using the second time machine to transport Fred back. You 
		never can tell. Anyway, so now what do I need to do? Go back to the whole
		DibbleBits stock thing? Glrm.
		
		That's starting to seem more and more like a red herring (an authorial
		red herring, that I left myself four years before, and have been trying
		to deal with ever since). When I was pondering the whole thing of getting
		money from the bank (in the future, which I haven't implemented yet), it
		occurred to me that this might be where Future Laura still works. I was
		going to have it so that the teller will call the manager in to approve
		any enormous cash withdrawal the player tries to make. If that's the case,
		it might as well be Laura.
		
		This means that Laura will know that the player has ready cash enough to
		forestall the foreclosure; indeed, to stave off any kind of offer to buy
		up the property. That would be quite an interesting development. However,
		wouldn't Laura know this the first time she meets the player? She says
		she has files on you, so wouldn't she know that you're one of the bank's
		biggest clients, having just piles and piles of cash in the account? This
		depends on when the player does all the stuff necessary to have the big
		pile of cash -- before or after you first meet future Laura. Hmmmm.
		
		What I'm getting at is a scenario where merely being filthy rich due to
		clever use of time travel is enough to change the future, and you don't
		need to bother with buying stock. I don't quite see how it works, yet,
		but I'm liking this because it means I don't have to bother with the
		DibbleBits stuff, which I wasn't looking forward to implementing. Hmm.
		
		(08-11-00) (11:11pm) Went off in another direction when I started tonight.
		It had been on my mind that I hadn't finished implementing things in the
		cave crawl in the far past. The player couldn't take a crystal from the
		crystal cavern, and there was a narrow ledge and a gap that were 
		described but not implemented. So, I finished that stuff off. Always 
		good to knock another item off the list of things to do.
		
		I still don't have a shopkeeper in the locksmith shop. Grrm. Maybe it's
		time to do that, because I am getting close to the end here. Really? Hm,
		maybe so. There's also the unimplemented elevators in the far future.
		
		(11:20pm) I'm sitting here trying to figure out where Far Future Laura
		comes into the story, and what her role is.
		
		(11:30pm) I just commented out the newspaper in the future, eliminating
		(for the moment) the DibbleBits distraction. Supposing that's gone, if
		simply putting enough money in your bank account allows you right now to
		change the future, you can pretty much win the game right now. There are
		loose ends left over, though. The second time machine is also a useless
		red herring. The entire far future section is a useless red herring.
		Future Laura is essentially one also. So is the secret passage, because
		I'd made it important by having it lead to the second time machine. Hrm.
		So it can't be JUST the money. You might still have to tell future Laura
		to go jump in a lake with her buyout offer. But that doesn't involve the
		second time machine.
		
		The only thing that would tie all of these loose ends back into the plot
		would be if you HAD to use the second time machine to go inside the 
		skyscraper in the far future in order to do SOMETHING. I can't yet figure
		out what you could possibly do in the far future to prevent the far future,
		though, so I'm a bit mystified. Unless, simply, you learn there what to do
		to prevent this scary future from realizing itself. That seems right. You
		go there, meet Far Future Laura, and learn -- what? What is it that you
		specifically learn that you need to do, so that you can go back and do 
		it? And assuming, for the moment, that I come up with a good idea for this,
		how do you escape back to the time machine in order to carry this out? 
		
		This scenario smacks of end-of-game climax, which means I'd need to make
		sure that the player has done everything else possible in the game before
		the secret passage appears. However, it's not quite that simple. Presently,
		you can create the secret passage before doing a lot of stuff. You just 
		need to grow the tree and leap to the attic. It's non-trivial, but it
		doesn't preclude anything. In fact, you need to do that before you show
		Fred his future self, because otherwise he can't sell you a sandwich. Well,
		more or less.
		
		(11:52pm) The problem with the just-the-money scenario is that you
		can make millions without really doing much else in the way of solving
		the game's puzzles. You can start the game, search the garage, sell the 
		wheelbarrow and cannonball, and open the account. You are then enabled 
		to withdraw and redeposit funds, becoming an instant multimillionaire.
		If that's all you need to do to win, then the game is already over. Even
		if the action of buying DibbleBits stock were again required, you could
		do that immediately, too. So the problem with the money is - what do you
		do with it?
		
		Perhaps if I get rid of the newspaper, you have to learn what stock to
		buy with your money by talking to Far Future Laura. Perhaps she gets up
		and says, "Let me tell you the history of this corporation..." Or maybe
		you get a moment to root around in some files and you read about the
		history of the corporation. Something like that. So then you find out
		about crucial moments in the corporation, when, had something been just
		a little different, it wouldn't be the gigantic scary monster it is 
		today (relatively speaking). Maybe it's not just DibbleBits, but several
		different stocks, including Lothario Corp stock itself. Maybe you need
		to spend all of the cash you've got to make it work, but you only learn
		in the far future which things to buy. Maybe you buy enough Lothario to
		become a voting shareholder, and in the Future, you get to make your 
		vote on a crucial deal. You get to swing it one way or the other. Or
		maybe it could happen in the Present. Anyway, this MIGHT work.
		
		(08-12-00) (12:02am) Okay, so you have to go to the far future and get
		inside the skyscraper and go up and talk to far future Laura to find out
		where you need to invest your money and what crucial vote to nix. How do
		I contrive a way for this to be done at the end of the game, when 
		everything else is over and done? Or is that no longer such a concern?
		If the player's done enough to get to the second time machine, isn't
		that enough in itself? What would be left undone at that point? Doing
		the lightning rod? Maybe that's not important. Showing Fred his future
		self? Maybe that's a perfect-win score, but not crucial. 
		
		Gee, I need to think about this. Maybe I'm closer than I thought. If
		I write the far future scenario where you meet Far Future Laura and 
		learn what to do with your money, that might get me to the New Far Future.
		And if I'm at the New Far Future, then we're at the end of the game, and
		all is well.
		
		Maybe I can write this far future bit tonight, in the next couple of
		hours. If so -- dang, maybe I might have something here. I'd still need
		to go back to the idea of buying the stock(s), and somehow making the
		Important Vote (probably through a second meeting with Future Laura, who
		comes to the house to ask what my vote is, since they can't seem to get
		ahold of me otherwise). Once you make the vote, you hop on the time 
		machine, go to the New Future, grind the duplicate key, and ... hm, hey,
		I still need to make that locksmith NPC. D'oh. Maybe I should do that
		first. Oh, I dunno. But gosh, this is close. Finally! Close! It is!
		It really is! Man.
		
		(1:43am) Darn, have to stop for the night, just when I was getting 
		somewhere. Where I got to, actually, was having the player take the
		elevator up to the floor where Laura's office is, at the top of the
		skyscraper. I haven't been able to playtest this, though. Yikes. It
		compiled, but will it run? I'm really streamlining things here. Places
		where I put in hooks for exciting things to happen (like the guard 
		placing the player under arrest) have been smoothed over or eliminated.
		No more fooling around, I guess. There was a thing where you hear people
		walking around in the sub-basement; that's gone, too. The elevator is
		already arrived and waiting. Apart from a thing I'm going to do where 
		you get nabbed by guards if you get off on any other floor besides the
		top floor, the lobby, or the sub-basement, I'm at the point where I can
		write the meeting with Far Future Laura. I'm assuming that once I write
		that, I'll have told myself what the player needs to do to change the
		future once and for all. And then -- gee, practically done. I'm thinking
		now that I should eliminate the locksmith shop and just put the key 
		grinder for sale in the antique store. In fact, it probably shouldn't
		be an antique store, it should be a pawn shop. Maybe it should be a
		pawn shop and be in the future, instead of an antique shop in the past.
		Hm. Oh well. This is neither here nor there, I guess. Time to stop for
		the night. Like a dummy, I forgot to bring my floppy disk to make a 
		backup before I drive home. Grr. I hate when I do that. Makes me feel
		like I'm really leaving things at risk of loss.
		
		But, a pretty good night.
		
		(08-15-00) (7:01pm) So where was I? Oh yeah. Elevators. Haven't tested
		code yet. Will test, then will keep writing. Soon will be done. Mmm,
		yes...
		
		(9:26pm) Okay. Now I'm mulling over ideas for what Far Future Laura 
		tells the player. I've built her ridiculous office, and now I have
		to think of what someone who has to sit in it every day would have to 
		say. I think it's going to be something rather weighty.
		
		(10:16pm) I still haven't written her speech yet. I've been rooting out
		minor problems with the code -- how it displays -- so far. I think I will
		take a moment to do something else, to reorganize my thoughts. Maybe I'll
		even try writing a draft of the speech in my sketchbook in longhand, 
		instead of just typing it out directly.
		
		(08-16-00) (12:18am) Sure enough, I wrote the speech out in my notebook.
		Sure enough, by the end of it I'd invented a way to streamline the end
		of the game, one that has nothing to do with money or stocks or anything.
		Far Future Laura gives you a sealed envelope to give to herself in the 
		far past, and that's all you need to do to change the future. You don't
		change it, Laura does. Amazing.
		
		Now, the only problem (hah, "only") with this is that -- discounting the
		red-herring-ness of the whole money thing -- the player will likely not
		have had enough interaction with Laura to start thinking of her as a
		real character, instead of just an NPC there to help you open an account.
		There's a bit of that going on with Fred, but the player gets to know
		future Fred well enough to kind of feel something for the guy. The brief
		meeting with future Laura just doesn't cut it.
		
		What might happen is that I'll need to set Laura up somewhere else.
		Maybe you need to meet her in the present as well, in a context where
		conversation is the only thing that makes sense. Or I need to take her
		out of the bank and put her in some other location, because the bank is
		a big false goose chase now. However, there was something to the idea
		that she starts working in the bank and eventually, as the bank is 
		swallowed by Lothario Corp, she becomes an executive there. However,
		I never wrote anything about 'VistaBank - now a division of Lothario'.
		I was planning to, if I went ahead and wrote a bank interior in the
		future, so that you could withdraw a lot of cash. 
		
		You know what? If you don't need to open an account, then the whole
		antique store becomes somewhat useless, too. It's there so that you
		can sell things to earn enough to open an account. It was also there
		so that you could get a lightning rod (now deprecated, or at least
		a problem that I might streamline out of the story completely) or
		even a suitcase to carry the cash. That's all rendered moot, now, too.
		
		It's possible I could salvage the idea by making it so that you can
		completely pay off your mortgage or the architect or something, but
		that feels really artificial. A bit too real-worldy for a fantasy
		story like this. I guess the problem is that I've streamlined too 
		much out, and it's leaving gaps that I would still have to fill.
		
		I think the give-envelope-to-Laura idea is good, though. It reduces
		the endgame to a no-brainer activity that players will understand.
		GIVE ENVELOPE TO LAURA is a pretty good use of the medium to wrap
		up a storyline. You then need to go to the far future one last time,
		and maybe by then have the key grinder and whatnot, and then that's
		it. However, all these missing chunks bother me a bit. 
		
		How about if I type in the speech, and code in the give-envelope-to-
		Laura thing, have that set the New Future to exist, and finally try
		to make a winnable game, leaving aside these plot gaps for the 
		moment? I think that's a good idea.
		
		(1:39am) Hm, almost time to go. I coded up the speech I wrote. Oddly
		enough, I had a placemarker for the speechDaemon, eight parts, and
		the speech I wrote broke up into exactly eight parts, with a pause
		for a yes/no answer at each one. How tidy is that? Amazing. Okay,
		I guess I have time to kind of test how it goes, and that's about
		it for the night. 
		
		(1:43am) Note to self: one of the questions isn't yes/no -- it's
		coffee/water/wine/wealth/fame/power. I need to code that in. Also,
		'DEAL' as an answer to the next one after that. Also, the jacket.
		
		(2:08am) Also also, there's a bug with Laura's desk in the bank.
		She's unreachable if you're there.
		
		(2:10am) Yes, you can now reach the new future with the time 
		machine. Wow. Gnight.
		
		(08-17-00) (7:06pm) I was almost thinking, as I got up today, that
		the speech was a little much, especially the last bit where Laura
		disrobes. Oh well. I have been trying to come up with a way for
		Laura to enter the story at a different point, so that she would
		come more alive as a character. It basically means that I have to
		introduce her in at least one other time period.
		
		The past seems a likely candidate, just in recent musings. As a
		representative of the bank, she could be coming to talk to you 
		about your mortgage, for example. She could also be in kind of a
		distracted mood -- perhaps she's at one of those crossroads in her
		life that will lead her to become the evil future Laura. It's not
		really going to be possible to, say, get her to change her life at
		that point, convince her to go a different direction, but maybe I
		can contrive it so that she provides some necessary exposition (about
		how the player owns/affords/doesn't own/can't afford the house and
		property) as well as invites conversation on more personal topics.
		Some of it depends on the timing. The player should be reasonably
		far along, far enough so that the switch from puzzle-game to story-
		game isn't so blunt. That's what I don't like about the speech right
		now -- as far as I know, the player has just completed the last of
		some very hard and basically pure puzzles -- getting into the attic
		and creating the secret passage, and having a really minor character
		suddenly launch into an extended monologue and then commit virtual
		suicide seems like a shock in the wrong kind of way. I was picturing
		my brother playing this and being completely turned off and/or baffled.
		I might have to go back to calling this "interactive fiction by JRW"
		instead of "a text adventure game by JRW", which is what I changed
		it to a few weeks ago.
		
		Maybe if I have Past Laura intercept the player on the way back to
		the time machine after the player has given the bad shingle to the
		architect, that would be appropriate timing. I note that I never 
		built the shopping village in the past, but I'm wondering whether
		I might need to create that -- even if just for continuity's sake, 
		but also to give the player and Laura somewhere to go.
		
		(8:22pm) Whoops, called away on Krone business. My contribution for
		the day has been to build a shopping village in the past, and the
		linking locations between it and the construction site. I was just
		starting to write the PLaura character when I got paged. So, that's
		all for now, but it leaves me in a good place to pick up from later,
		or tomorrow, depending on what the case may be.
		
		(08-21-00) (1:53am) I managed to get an hour and a half in here, 
		creating the meeting with Past Laura. She smacks her briefcase open
		on the big rock and you have to help her pick up the papers. Then she
		tells you she has good news and bad news, and it actually works if the
		player says, LAURA, WHAT'S THE GOOD/BAD NEWS? Hooray. I think ASK LAURA
		ABOUT THE BAD NEWS and LAURA, TELL ME ABOUT THE BAD NEWS also work. Then
		she leads you into walking with her back to the bank, my attempt at getting
		a full conversation to happen. I'm not exactly sure how to handle that
		next part, but I feel good about this introductory bit. I've got my work
		cut out for me, implementing conversation (with all possible Lauras) about
		various topics that come up in the course of asking about initial topics.
		That's mainly just writing, not intensive coding, however. If I can get
		the walk-back-to-the-bank working in a satisfactory way, then I really
		am down to filling in conversation items.
		
		Well, not exactly. I still haven't written the New Future epilogue. That's
		bound to be a little more complicated than I'm imagining, but should be a
		two day job. The conversation stuff could be a two-day job also, unless I
		manage to get some eight hour days working this week. Tonight's work is
		done, I guess, unless I can muster the diligence to work on it back at 
		home again.
		
		(08-22-00) (1:06am) Whoa. I just wrote the code to walk Past Laura back
		to the bank, and it compiled the first time. That doesn't mean it'll work
		correctly, but that's a nice change. The problem with building all of the
		shopping village in the past is that it requires there to be a sandwich
		shop in the past, which means -- hm, being able to buy a sandwich in the
		past. Does this mean you have the ability to get a hot sandwich to the 
		Architect even faster? I hate having more than one sandwich shop. I mean,
		then the player is unlikely to spend time interacting with Fred. I suppose
		I could put the description of the sandwich shop from the far_past into the
		past -- i.e., the shop is only just about to open for the first time. What
		would go into the far_past village, then? Hmmm.
		
		So, still left to do (assuming this code works): Laura conversation stuff.
		Epilogue coding. Is that really it? That's hope-inspiring.
		
		(1:39am) Okay, got it patched up and working, more or less. Maybe I can get
		here early in the afternoon tomorrow and plough through much of what's left.
		Perhaps this could finally be the week when.. nah. Better not make any
		predictions.
		
		(08-22-00) (8:17pm) Okay, this is it. Contradictions or lapses and all, my
		goal tonight is to make a winnable, playthrough-able game file. Really what
		this means is that I need to build the last few rooms of the New Future and
		make sure the player can get ahold of the front door key. Then I need to make
		sure the walkthrough works. And that's basically that. Shouldn't take too long,
		right? I"ve got almost six hours set aside here.
		
		Let's see if I can do it.
		
		(9:14pm) First two rooms complete. Third room started.
		
		(11:08pm) I've got pretty much all of the exterior and interior rooms 
		built, and am now facing straight the tour-of-the-house that the mysterious
		yet friendly young man takes you on before he gives you the front door key.
		There are still a lot of decoration objects needing to be created, but it's
		still within the realm of reason that I can connect to the finish line 
		tonight. There's still three hours left.
		
		(08-23-00) (12:56am) Argh! One hour to go. Well, I've just handed off the
		original front door key to the player. Assuming the player is prepared to
		grind the duplicate key, all I need to do is the hand-off to the young man
		of the original and write the exit. I think I've already written the win-the-
		game code in the present. Woo. It's going to take more than an hour to create
		the walkthrough and debug it, though, but I guess I've pretty much accomplished
		tonight's mission. Hooray.
		
		(1:48am) Well well well well well. It's the end of my time here at the coffee
		shop, and I think I've got it all linked together. I haven't once gotten to
		playtest it, though! I may have to force myself to go home and finish this
		up, because I'm feeling like I've run out of time. Tonight's the night. Can
		I play through from the very beginning to the very end of the game? I'm 
		anxious to make it happen. In fact, I guess I'll pack up now, ten minutes
		early, because that'll be ten minutes earlier I can get some food in my
		stomach and keep hashing at this. I am DETERMINED to be done with this.
		
		(08-23-00) (9:47pm) My mission tonight is to make the game work via a full
		scripted walkthrough. No idea what pitfalls lie in the way. I'm sure the
		Past Laura code is going to screw with the walkthroughs I already have, 
		for example.
		
		(9:53pm) Well, what do you know. All 4 of my previous walkthroughs still
		execute without errors. That means I just need to play through the last
		bit of it with a script on, and see if I can get all the way to the end.
		
		(08-24-00) (12:28am) Naturally, I was wrong about that. There were problems
		with the first scripts. Well, part4, really. Past Laura's arrival was a
		problem, but there were also funny other errors. For some reason, FFred
		wasn't summoned when I went to the hole and searched it for the bottle!
		That was how I tested and retested and re-retested that code a hundred
		times! I can't figure out when I might have changed it. Anyway, it works
		now, but geez. I now have the scripts working all the way up to the end
		of far future Laura's speech. Only an hour and a half left here -- can
		I make it?
		
		(1:55am) Argh! Five till two and I still haven't managed to grind the
		duplicate key! I'm *THIS* close!
		
		(2:03am) ARRRRRRRGGHHHH!! THE KEY GRINDER DOESN'T WORK ANY MORE!!!! WHY????
		
		(2:08am) I fixed the grinder. I have no idea why it was broken -- or why
		I didn't know it was broken before now. Grrr. I think it was because it
		wasn't a plug-in item before. But, METRO is closed now. I didn't make 
		it. Dang.
		
	Version 2.0  (08-24-00) (3:39am) 
		Yay! I did it. If only I'd been able to run it one more time at the 
		coffee shop, I could have seen it there. There were one or two minor
		fixes I did at the end, and then I ran the complete walkthrough as one
		file, and it made it all the way to the very very end. Amazing. And now,
		I give it to testers, and wonder what to do with myself. Maybe a comp
		game...
		
	Version 2.0.1 (08-25-00) (?)
		Fixed a bug with the herring detector.
	
	Version 2.1.0 (09-01-00) (1:00am)
		Went through Iain's first set of notes, as well as what I remembered
		from conversations with boucher and TableSaw.
		
		List of fixes:
		- Looking at the library deposit slot now lists the wedged books up front.
		- The paper napkins were non-interactive, and now are.
		- Bug if you type 'OUT' when standing on the platform.
		- Description ambiguities with the garage doors fixed (and work the
			same way as the ones in the future).
		- TURN ON CAR should have worked, but didn't, and now does.
		- TURN KEY should work for the car.
		- Response to KICK NPC had a typo.
		- SHOUT AT responses were missing an sdesc.
		- PUSH BUTTON if you're in the garage should automatically open the 
			garage door without prompting the player to disambiguate which
			garage door opener button he means.
		- X COMPARTMENT when standing on the platform works as it should.
		- Fixed description ambiguity vis. "pale and blue" / "bright" light.
		- Attempted to make rock appear everywhere it should. Might still need 
			further fixing.
		- ASK MERCHANT ABOUT ANTIQUES was missing a return(true) and consequently
			gave a funny sequence of responses.
		- SEARCH ANTIQUES returned a bizarre error message.
		- X DESK when in the bank lobby gave an odd disambiguation request.
			Should be fixed.
		- Fixed missing prompt when asking Laura about new accounts.
		- Fixed typo in Front of House (future) room description.
		- Changed locksmith shop room description, which hadn't been changed 
			since a much earlier version of the game.
		- "You can't reach that" messages when trying to THINK ABOUT stuff on
			the large rock have been cleared up.
		- Typo in THINK ABOUT response has been fixed.
		- Added DISEMBARK synonym for getting out of/off things.
		- Added INSIDE synonym for the preposition "in" (hrm).
		- Gave a response for ASK MERCHANT ABOUT TIME MACHINE
		- Streamlined disambiguation for >CUT FOO entered without prep, iobj.
		- Fixed text for (-10) Laura's exit, which wasn't properly separated from
			the end of the room description.
		- Added verb to turn on/off wizard debugging verbs so I don't have to
			remember to recompile with/without them every time.

11-21-00 7:37pm
	Version 3.00 - A major rewrite.
	
	My plan for Version 3 is to slim the game down. All of the people who were
	testing Beta Version 2 quit halfway through, which is just after planting
	the tree and growing it, finally. No one climbed into the house in the 
	Future, no one got to the end. It seems clear to me that the game simply
	bogs down too much on the grow-the-tree puzzle, and saps the player's 
	strength too much. Even if you manage to get into the attic, not much
	happens. Hrm.
	
	Up until now, I'd been too attached to old ideas to throw anything out
	that wasn't working, but I guess I'm finally going to bite the bullet and
	do what I need to do to make the game friendlier. I'm going to make it
	simpler to grow the tree, for a start, perhaps giving up on the idea of
	the multiple jugs and providing just one jug of Miracle-Gro. This sort 
	of eliminates the need for an inventory limit, which eliminates the need
	for the wheelbarrow. The other use for the wheelbarrow was pawning it for
	money, but I've never liked the whole money aspect of the game. If I do
	that, then a whole huge chunk of the game goes away, too. So be it.
	
	The task, then, would be to come up with some other place to meet Laura,
	some other job for her to have. This might end up being better, anyway,
	since I have the endgame now. It didn't make too much sense for Laura
	to start at a bank and end up running Lothario Corp. Maybe Lothario Corp
	needs to be there from the beginning of time (so to speak). Except, if
	that's the case -- hm. If what you do is not prevent Lothario from existing
	in the first place, or at least prevent it from becoming the consuming
	mega-entity that it is in the far future, but prevent Laura from ascending
	in its ranks, how does that prevent Lothario from...? I guess the answer
	is that it was Laura, in her rising role in the corporation, who guided
	it to that fate. Remove her from its ranks, and it never grows that...
	
	Hold on. I was just thinking that there was a metaphorical parallel here
	between the player growing the tree and Laura growing the corporation.
	The player grows the tree, serving a purpose and satisfying a need, but
	it has tragic consequences -- it demolishes the house. A smart writer
	would find some way to exploit the parallelism, to use it as a theme,
	to write it that way on purpose.
	
	Okay. Maybe I'm back on track here. So many ups and downs with this 
	story, with this game. But I am going to start by taking out my machete
	and hacking away at the undergrowth. Maybe I'll find my path.

	(8:47pm) Okay, it's not "taking." I've been trying to cut things out, but
	the game is resisting it. Everything's too intricately linked together to
	do any kind of hack job. I did slim down the jug problem to just two jugs
	instead of five, but that's about the only thing that I could figure out
	to do. I tried eliminating the money system and inventory limit puzzle
	and the wheelbarrow, but everything kept tying into something else that
	would break if I extracted it, or would leave gaping holes that would 
	need filling with something else. Either that or I just don't have the
	energy right now to rewrite all of the Far Past shopping village to make
	it only a bank. Or, if I were getting rid of the bank, what would be 
	there at all? Maybe nothing.
	
	Hm. I guess if I eliminated the whole money thing, I wouldn't need any
	of the Far Past shopping village locations. I could just eliminate that
	entirely, and say that it didn't exist yet. What would be wrong with
	that? Hmm.

Version 4.00 - 03-02-01
	
	I already changed something on Feb 17, which was the quirky error 
	in past.t where you could take the sewer hole with you, but not
	be able to drop it. This version, now, is going to include the 
	choose-your-own-adventure easter egg, and I'm going to be working
	from Vincent Lynch's bug reports and whatnot. I've also re-solicited
	the feedback from the Iron-Men Betatest last November, and some of
	that has come back (I lost it in a hard drive crash in December).
	
	(10:19pm) Okay, I've got the CYOA module included and working. Yay.

	(03-06-01) (9:37pm) Cleaned up some code. I'd mistakenly started
	calling the alert bulb an "alert light" in the time machine manual,
	which meant that it told you to look up a topic that couldn't be 
	parsed. Then I modified the herring detector code, allowing for
	pointing the detector at objects, or pointing objects at the 
	detector, or pointing with the detector at objects, or pointing
	with an object at the detector. All of that works, now. I also
	made it so that you can use 'all' with the checkVerb, so you can,
	say, check all of the junk in the garage in one big swoop. Messy-
	looking output, but Vincent Lynch was complaining about having to
	check everything tediously one at a time -- that the discovery of
	the detector just meant a lot of work, and feeling obliged to
	check every new item all the time. Oh well! It stays in the game.
	
	So, what else to do, now? Hmm. I noticed that you can't look up
	"the present" in the time travel library book, even though "the
	past" and "the future" are valid concepts. You also can't refer
	to "the far past" or "the far future," but I'm not sure if that's
	important since those are internal to the game's code and are never
	referred to in the game's text.
	
	(10:12pm) Fixed a bug at the tellerWindow, where walking east or
	out from there would move you into the far past village every time.
	There was also an erroneous use of self.travelTo instead of 
	Me.travelTo in the teller's sayGoodbye() routine.
	
Version 4.0.1
	(03-07-01) (7:42pm) Fixed a bug with isIn() -- I was using it to
	check whether an item was in the player, but it only recursed among
	items with contentsVisible properties, allowing the player to conceal
	items inside other items inside other items, and get away with things.
	I created a deepIsIn() method that did the same thing with full 
	recursion, whether or not an object was inside a nest of a closed 
	containers. Originally, I was just going to replace the normal isIn()
	with this behavior, but I decided to leave it intact, allowing me to
	compare the results of deepIsIn() and normal isIn() -- and thereby
	chastise the player for trying to steal away with items that he
	shouldn't, by hiding them inside things!
	
Version 4.0.2
	(03-08-01) (9:15pm) Another stalwart from the Iron Men Betatest,
	Vincent Laviano, finally forwarded me copies of our previous
	correspondence. He pointed out a number of niggling little bugs,
	so tonight's work is dedicated to fixing them.
		
		- Fixed bug at end of guided tour (missing moveInto()'s).
		- Typo in secret passage xdesc (s/east/west/).	
		- Typo: "him [Carl] stops before the penultimate door..."
		- Typo: in fullscore output, giving a piping hot sandwich to
  			the architect was misaligned with respect to the other items.
		- secretDoorItem class wasn't set noAutoOpen = true.
		- Erroneous xdesc in Broken Cavern.
		- I halved the results of the savings account interest function to 
		  make the interest dividends somewhat less fantastic.
		- After putting an item under the mat and retrieving it, 
		  'look under mat' commands returned the error msg:
		  [ TADS-1023: invalid type for built-in function]
	
	(10:02pm) Well, that appears to be that. The only other thing Vincent 
	Laviano pointed out was that there was no point to accruing vast amounts 
	of cash through time travel (true), and that you got the same epilogue
	text no matter what you did or didn't do. That's not a trivial bug
	fix, so I'll have to think about what to do with that. Otherwise,
	it's nice to have taken care of these things.
	
Version 4.0.3 
	(03-10-01) (4:10am) A chat with Ellison the other night brought up a
	bug that had confused both him and, I recalled, Vincent Lynch -- the
	FLaura.meetLaura method was printing the same message whether they had
	rescued you from falling from the tree or if you had just come upon them
	parked in the driveway. This confused both of them into thinking they had
	missed something or done something out of order. 
	
	In fixing this, I ended up rewriting much of the FLaura.actorDaemon code,
	arranging it to be more efficient and to make more sense. It was a bit of
	a muddle as I found it. After that, I was chasing down all instances of
	a call to FLaura.meetLaura, and remembered something else that Vincent
	Lynch had point out -- if you managed to save yourself from falling, the
	last two tree trunk room descriptions were still missing! In fact, I 
	realized that one of them was superfluous and deleted it. I wrote the
	room description and some room-to-room movement text for finally 
	clambering into the attic from the tree. These are satisfying fixes to
	have made. I think I'm very close to a release.
	
	(4:28am) Fixed a bug whereby you could get into the future house by
	the front door by setting noAutoOpen = true. (Same for the present
	front door, and the inside future front door.)
	
Version 4.1.0
	(03-15-01) (7:06pm) Okay. The main thing left to do is make sure the
	ending changes depending on what you did or didn't do in the game --
	for example, if you didn't help poor Fred, he shouldn't show up looking
	hale and hearty.
	
	What I'd like to concentrate on for the moment are some clean-up things
	that will reduce incidence of bugs. The rock's being a floatingItem has
	never worked properly, so I will dispense with that and just make five
	different rocks in the five time locations. The secret tunnel being only
	one location that exists in several times also seems likely to get 
	goofed up, so I'm going to make it five different rooms as well. This
	is something I did in BAP, for example, and it kept the code cleaner
	than trying anything more fancy. I'd also like to disable the hint
	system, which also cleans up some of the rock code: no more THINK 
	or THINK ABOUT verbs to act up. HELP will do something different, like
	print a menu of settings options. HINT will say "No hints available."
	If people, on their own, think of asking NPCs for hints, that will 
	still be available. I might disable the auto-hint function that NPCs
	have been given, though.
	
	(10:45pm) Fixes made so far:
		- Changed rock from a floatingItem to five unique scenery objects
			in the five time zones.
		- Added self.location and self.location.contents to the time
			machine platforms' reachable[] lists.
		- Created FsecretPassage and accoutrements.
		- Eliminated need to ask architect about electricity in order for
			light bulb and socket to appear in secret passage(s).
		- Made it so that leaving the light on in the secret passage, in
			the present, gives you a useless burned-out bulb in the
			future.
		- Created NFsecretPassage and accoutrements.
		- Modified the NFsecretPassageLightBulb and room.lightDesc to
			describe some sort of futuristic kind of light bulb.
		- Made the size of the secret chamber/laboratory match the
			dimensions of the prototype time machine described in
			the time machine manual.
		- Added additional scenery objects to the laboratory.
		- Disabled HINT verb.
		- Disabled HELP verb until I can think of something better to
			put there.
		- Disabled THINK verb.
		- Changed WHOOPS, WOW, and LAUGH verb responses.
		- Disabled THINK ABOUT verb.
		- Gave a direct clue to the player to check the work shed for 
			the fifth jug of miracle-gro.
		- Changed miracle-gro to miracle-grow (trademark sensitivity issue).
		- Created Blackie, a dog who guards the fifth jug.
		- Changed tennisBall and frisbee so that they are no longer
			red herrings, because they can be used to distract Blackie.
		- Implemented distracting Blackie with the tennis ball, frisbee,
			or a sandwich of some kind. 
		- Added code for THROW OBJ OUT SHED/DOOR. 
	
Version 4.1.1
	(03-16-01) (9:21pm) Hm, oops. Tried running the walkthroughs again, and
	hit a snag. I thought the snag was going to be the dog, but I never put
	in the code to make the dog appear (just as well, since I'm still 
	rethinking its necessity). The snag is that I changed the interest
	function, thinking it would end up with the player earning only half
	of what he had been, but instead it was drastically less. Instead of
	having $9400 available in the future, the player only had $57. Grr.
	Let me think how to make it actually come out with only half, instead
	of this tiny fraction. 0.6%? Jiminy crickets...	
	
	- Amended part3.t walkthrough because it was out-of-sync with a 
		correction I recently made to the teller.sayGoodbye routine,
		obviating the need to go south after finishing a transaction.
	- Changed the prompt when handling a transaction to make it clearer
		to the player that it is not a conventional parser prompt.
	- Interest function changed to 71% instead of 80%.
	- Fixed typo in Pbend.ldesc: "construction of site" instead of 
		"construction site".
	- Changed wowVerb response again.
	- Conformed various walkthroughs to current state of game.
	- Created new FsecretChamber instead of inheriting from the
		other secretChamber room.
	- Fixed exit in laboratory (and added redundant south exit).
	
	Oops! I just realized that I haven't written the code to shuffle items
	left in the secret passage to the future if the player does a time jump.
	Grr. That's real work, and I'm at a stopping point for the evening. Oh
	well. Gives me something to do next time. (10:55pm)
	
Version 4.1.2
	(03-17-01) (7:47am) Okay, starting up again already. Going to add any
	items dropped in a secret passage to a special list that the time machines
	can access when they jump forward and backward. Hm, this might take some
	real thinking about. I guess I'll blunder into it and see what I come
	up with.
	
	I'm thinking I might also put Blackie the dog there in the workshed at
	the start of the game. He's an easy puzzle, anyway. I'm tempted to put
	the burly landscaper in as an NPC when you go for the fifth jug. He'll
	say, "Say, who's been stealing my miracle-grow?" and the player will
	have to come clean, maybe, in order to get the fifth one. Something
	like that.
	
	(10:02am) Hm, there's a problem with the machineDust on the second
	time machine. It's got a dobjGen() method that's supposed to print
	a message, and it doesn't.
	
	Another problem is that the special going-down-to-the-secret-chamber
	travel message was being printed too many times -- including during a
	time jump. I fixed that instance, but the larger problem remains.
	
	I feel like there was a third thing I ran across, but I cannot think
	of it right now.
	
	What I was mainly going to say is that, after spending two hours writing
	and debugging what I thought were clever functions to shuttle stuff around
	in the secret passage, I'm going to have to abandon the idea. It's too
	complicated; there are too many permutations. Thus, I'm also going to
	abandon the idea of having a wall socket in the secret passage, and just
	put one in the laboratory. There we go, case closed.
	
	The other thing is that I'm too tired to be doing this, and if I keep
	trying I'm in danger of really screwing something up. So, I'll leave
	myself these notes and call it a night. Or a day. Or whatever is
	most appropriate. (10:10am)
	
	(03-17-01) (10:12pm) Okay, starting over. Removing all of the stuff
	I wrote this morning, except these notes. Going to put the socket in
	the laboratory. Also, I remembered the third thing from this morning.
	It was that the plugItem code is a bit buggy -- it doesn't print
	the correct sdesc for what it's attached to, and PLUG GRINDER INTO
	SOCKET didn't map to PLUG CORD INTO SOCKET, which it's supposed to.
	So I need to look into all of that.
	
	At the very least, the bumbling around this morning pointed out these
	little errors -- although perhaps Vincent Lynch was all set to point
	them out already. He's supposed to send me a big bug list this weekend.
	
	(11:01pm) There, finally. The main problems with the plugging and 
	unplugging stuff turned out to be in the socketItem code, not in the
	pluggable or plugItem code.
	
	- Put a wall socket in the laboratory.
	- Removed wall sockets from secretPassage, FsecretPassage, and NFsecretPassage.
	- Created pluggable class for electric items that can be plugged in.
	- Cleaned up bugs in pluggable, plugItem, and socketItem classes. 
	
Version 4.1.3
	(03-20-01) (5:45am) Now, where was I ...?
	
	- Fixed a bug with the housekeeping() function's goodbye-to-Fred
		messages. It wasn't correctly checking to see whether Fred was
		indoors (in the secret chamber) or outdoors, and was printing
		the outdoors-farewell message every time.
	
	Hmm, the fix I made to the teller routines, giving them a non-standard
	prompt, have munged the transcript walkthroughs, which rely on standard
	prompts to be parsed correctly. Grr.
	
	(6:13am) Whuh-oh. Something weird is going on with the key grinder.
	It seems to disappear from the wheelbarrow and reappear, without being
	listed in the room description, at the present southOfHouse. I'm trying
	to figure out when it does this before I track down how or why it does
	this. Sigh.
	
	(6:31am) Hm, apparently it's because I made the pluggable class fixedBlock.
	I've changed it to item.
	
	(6:59am) Okay, the walkthroughs all work again, all the way to the end.
	Hooray.
	
	- Set NFmasterBedroomSecretDoor.isopen to nil.
	- Set finalroom.xdesc to "\n" because it was printing "There are no exits."
		(Default message I recently set.)
	- Put an extra newline in die() function for aesthetic reasons.
	- Synchronized all walkthroughs to current version (act1, act2, act3,
		part1, part2, part3, part4, part5, part6, and epilogue).
		
	Okay, that's it for version 4.1.x, I think. Next version I do (4.2.0) 
	will concentrate on polishing the guided tour in the epilogue,
	making it slightly less on the tracks and having its descriptions 
	dependent on what the player has or hasn't done (like helping Fred
	change his future). (7:20am)
	
Version 4.1.4
	(03-21-01) (3:33am) Okay, it's not version 4.2.0 yet -- because 
	Vincent Lynch finally sent in a whole bunch of transcripts with
	commented bugs and problems. I guess I'll bore through them as best
	I can (energies are a little low this morning), and call this
	version 4.1.4. I'm going to save rewriting/tweaking the epilogue
	for version 4.2.0, though.
	
	- Made colorful shopping village signs readable.
	- Fixed bug where you could drop the library book into the depository
		slot even if the wedged books were supposedly blocking the 
		opening.
	- Removed 'hot' and 'cold' as adjectives from everything but the
		sandwiches, because Fred was answering questions in a really
		odd manner.
	- Put check for the spare key not being found yet if you ask 
		someone about "key".
	- Added moneyItem class askingAboutMe to dummyBill.
	- Added a napkin dispenser unimportantItem to the sandwich shop.
	- Fixed bug with time machine compartment ldesc.
	- Forced disambiguation of 'check with' iobj to the herring detector.
	- Changed time machine manual readdesc to refer to chapter numbers 
		using digits instead of 'one' 'two' ... 'ten', because parser
		couldn't accept those words as adjectives, somehow.
	- Added adjective 'schematics' to manualAppendix.
	- Fixed wording of time machine manual topics: "knob" instead of 
		"dial", "button" instead of "buttons".
	- Fixed bug where time machine would vanish (if you were not on the
		platform) even if the knob were set to 3.
	- Changed first timeButton.doPush code to be the same as timeButton2.doPush
		code.
	- Made it so that pushing the first time machine's button without standing
		on the platform sends it to the appropriate location, instead of
		nil. (The second time machine's existence makes it possible to find
		it again.)
	- Fixed bug in timeButton2.doPush code where global.timeLoc was being
		reset even if the player wasn't standing on the platform.
	- Added ledge to jumpVerb.action() location check.
	- Added brokenTrunk.doLetGo(Me) to jumpVerb.action() location = hangingForDearLife
		check.
	- Removed "[ slipDaemon deactivated ]" message from hangingForDearLife.slipDaemon.
	- Added pinholes scenery item to crystalCavern.
	- Fixed machete.ioDigWith message (it still said "shovel").
	- Fixed apparent bugs in teller routine: no check for whether an account is
		actually open or not, no goodbye message for invalid transactions.
	- Changed teller.sayGoodbye message to just "Have a nice day." instead of
		"All right. Have a nice day."
	- Added misspelling 'marchant' to antiqueMerchant noun list.
	- Removed synonym 'junk' for the antiques in the antique store, due to 
		inappropriate merchant ASK ABOUT reaction.
	- Moved 'ball' to cannonball's adjective list, to disambiguate from the
		tennis ball. Added more adjective synonyms while I was at it.
	- Removed extra new_line before printing the burly-landscaper-takes-the
		-miracle-grow-jugs mesage.
	- Added 'pillow' and 'case' synonyms to pillowcase.
	- Fixed bug where you could fit jugs of miracle-grow into the package
		and/or the pillowcase.
	- Fixed bad response to ASK TELLER ABOUT ACCOUNT (amusingly, "What do I
		look like, a bank?").
	- Added check for global.newRoof = true when asking the Architect about
		the shingles/roof.
	- Added verDoUntie() and verDoTake() rejection messages to the ribbon
		on the sapling.
	- Changed "broke" to "broken" in ASK ARCHITECT ABOUT BUSTED WHEEL message.
	- Added missing return( true ) to ASK ARCHITECT ABOUT (moneyItem).
	- Added plural = 'books' to libraryBookItem class.
	- Added adjective 'spout' to drainpipe (rooftop).
	- Fixed bug where you could repeatedly show the bad shingle to the
		Architect and continue to amass points.
	- Changed ASK ARCHITECET ABOUT BAD SHINGLE message (the one I just wrote)
		to make sense if you do this repeated-request thing.
	- Added doSwing() handling to various ropes and tires.
	- Added 'leap for' to jumpVerb synonyms.
	- Fixed typo: "twenty years of weatherand recent natural disaster".
	- Changed generic rejection message for hacking at things with the machete.
	- Added missing location property to FfrontOfHouseWindows.
	- Added jumpVerb to hangingForDearLife.roomAction().
	- Added a "rain" object available for examination in the future.
	- Mapped Lookthru -> Search for the hole in the wall (future).
	- Added isThem check to touchVerb generic response.
	- Mapped Pull -> Unplug for the plugItem class.
	- Fixed typo: "photosgraphs".
	- Added noAutoOpen = true to FkitchenBackDoor.
	- Added isHim = true to FFred.
	
	Woo! That seems to be it. I didn't know I was going to go through the whole
	thing tonight. Probably needs testing to make sure I didn't break anything
	while fixing something else... but maybe I'll let Vincent do that. (7:28am)
	
Version 4.1.5
	(03-23-01) (4:57am) Added some scanned graphics to the CYOA game.
	
	(03-26-01) (5:29pm) Added synonyms 'prise' 'prize' 'jimmy' 'jimmi' and
	'lever' to pryVerb.
	
Version 4.1.6
	(5:30pm) Vincent Lynch sent some nitpicking feedback about version
	4.1.4 -- let's see if I can take care of these things (grumble). Er,
	except I seem to have forgotten to copy his feedback to the floppy
	today. I'll do what I can remember off the top of my head (except
	stuff with the little car -- grr, I can't face mucking with that
	again right now.)
	
	- Added checkWith handling for unimportantItem class.
	- Added doLookin handling for bookItem class.
	- Changed it to print the readdesc if you Open a bookItem.
	
	(03-29-01) (7:58pm) Okay, I'm back, and I have the file with the bug
	reports. I also have another tester's reports, but maybe those will
	be version 4.1.7. Another old Iron-Man tester sent transcripts, but
	those will largely be redundant, I think. Worth going through, but
	not a priority right now, especially since there's a megabyte worth
	of transcripts to slog through.
	
	- Added "(first opening <<self.thedesc>>)" to bookItem.doLookin.
	- Added lookupVerb.action( actor ) = { askdo; }
	- Added missing sdesc to utensils.
	- Added fillVerb.action( actor ) = { askdo; }
	- Fixed nasty bug with sitting on the rock, due to deprecated code
		in the housekeeping daemon (for when the rock was a floatingItem).
	- Cleaned up rock code. Copied changes to the four other rock objects.
	- Fixed throwable.throwTo default, which was printing a blank line.
	- Added more hooks to throwable code, accounting for being up in a 
		tree, throwing to previously unaccounted-for NPCs, etc.
	- Added a crawlVerb, and various 'crawl n' 'crawl back', etc., for
		the broken trunk crawl.
	- Added ability to throw throwable items into the future attic, 
		whether from the tree or when standing on the roof.
	- Fixed platformItem.verDoStandon, which wasn't checking to see
		if the player was already on it.
	- Handled "sit in seats" when in the littleCar.
	- Changed littleCar.lookAround to print the car's ldesc, not the
		driveway's.
	- Added a blank xdesc to littleCar to avoid "There are no exits." default
		message.
	- Changed it so that the carKey moves into your inventory when you look
		under the stones, even though it still prints the noAutoTake message.
	- Fixed NPC.verDoTake to reject the action.
	- Added missing return(true) to "You" object (for parsing ASK ABOUT YOU).
	
	Note to self: All of the NPCs need personalized talkAboutMyself methods.
	
	- Reversed class inheritance order (surface, block) of the workdesk.
	- Added plural = 'pencils' to pencilItem class.
	
	Another note to self: adv.t errs in its handling of doLookin for the
		surface class, and maybe other containers.
	
	- Mapped surface.verDoLookin, doLookin to verDoSearch, doSearch.
	- Added vocabulary 'blue', 'print' to blueprint.
	- Changed blueprint.isListed to true.
	- Changed it so that you can't put anything on the Architect's workdesk.
	- Changed Architect.ioShowTo() to reject everything shown to him except
		the badShingle.
	
	Annnnnnnd... that's it for tonight. I'm a bit tired out now, and since
	I'm not going to make the goal of 03-30-01 anyway, there's no sense in
	beating myself up trying to keep at it. There's lots more still left to
	do. (10:06pm)
	
Version 4.1.7
	(04-02-01) (8:26pm) Haven't felt at all motivated for a few days, but
	I'm going to make myself keep going. I think part of the problem is that
	I keep thinking of maybe doing new things with the game. I suppose if I
	left it for another year it might be even more interesting by the end.
	Oh well, I dunno. Probably best to just debug and get it done.
	
	- Removed message "You get all turned around... and seem to end up
	back where you started." when traveling to the next correct room in
	the maze.
	- Added a special jumpVerb.action(actor) response when the player
	is in P2ndFloor.
	- Fixed typo: "traveler" / "traveller" throughout.
	- Added global.NPC_list, a list of the game's main NPCs.
	- Changed showVerb.validIoList to return global.NPC_list.
	- Fixed typo: "He is to busy to look over your things."
	- Added synonym 'boot' to carTrunk.
	- Added missing floatingItem declaration to drainpipeCloggingLeaves.
	- Added validIoList (the various bookItems) to lookupVerb.
	- Added validDoList (the various bookItems + global.NPC_list) and
	validIoList (nil) to consultVerb.
	- Removed 's' as an adjective from all instances of the 
	interiorSecretPassageDoor.
	- Added more adjectives (and an intentional misspelling) to the shrubbery.
	- Added missing return(true) to rareBook.askingAboutMe(squirrel).
	- Added missing return(true) to lightningRod.askingAboutMe(Architect).
	
	Hmmm, I'm reminded that I never put the lightning rod back into the
	game, although you can still ask the Architect about it. Why one of
	the testers did just that, I don't know. Maybe he remembered the 
	hint system from the old versions that still referenced it. I'll have
	to think about how to add it to the game again. I was waiting to figure
	out how to delay it until the player had done a certain something, 
	whatever that might be. Gotten into the future house once, maybe? Hm.
	
	This same beta tester also reported that the sewerHole was moved into 
	his inventory when he took the five dollar bill. Grr! *Still*? I note
	that I can't reproduce this behavior, despite trying various ways to
	break it, so I don't know what the deal is. I'll have to ask.
	
	- Temporarily removed the advice to "Type ABOUT, CREDITS, or HELP...".
	- Added 'keyhole' as a synonym to the front door lock.
	- Added doLift -> doOpen for the garageDoorItem class.
	- Added synonym 'box' for the glove compartment (glove box).
	- Changed garageOpenerItem.adesc to correctly say "an opener button."
	- Moved 'meatball' from hotSandwich.&noun to hotSandwich.&adjective list.
	(There's some funny bits here and there in present.t, because it's 
	code I wrote five years ago when I was first using TADS and didn't
	know better!)
	- Changed references to "time knob" to "knob" in time machine manual.
	- Rewrote the timeManual entries to be consistent, non-redundant, and 
	generally more helpful.
	- Added validTopicList to timeManual.
	- Added validDoList to lookupVerb that returns timeManual.validTopicList
	if iobj = timeManual.
	- Fixed PnewAccountsDesk.location bug.
	- Failed to figure out a way to force-disambiguate to the time manual
	when looking up an object in timeManual.validTopicList. Grr.
	- Fixed a bug where the antiqueMerchant says she already sold you
	items that you haven't bought yet.
	- Added synonym 'browse' to searchVerb.
	- Added missing xdesc to FinsideHouse.
	- Added missing new_lines to PLaura.actorDaemon output.
	- Added missing noun 'swing' to tireSwing.
	- Added synonyms 'deal', 'agreed' to yesVerb.
	
	Hm, that's it. Good stopping place, too. Pity about the disambiguation
	thing. (11:02pm)
	
Version 4.1.8
	(04-09-01) (6:44pm) More Vincent Lynch fixes (from v4.1.7), and
	Doug Jones fixes from v4.1.4.
	
	- Finally tracked down and killed the bug that moved the sewer hole
	into the player's inventory. Thanks to Doug Jones for sending a 
	transcript with the clues I needed.
	- Handled doPutIn, ioThrowIn, ioPourIn for the sewer hole.
	- Changed "premonition" in the text you get when you try unlocking
	the front door with the spare car key, to avoid redundancy with 
	the game's intro text.
	- Modified garageDoor2.verDoLock to reject the action if the 
	garage door is currently open.
	- Mapped garageOpener.doPush -> openerButton.
	- Changed "seats" to "seat" in seats.verDoSiton message.
	- Added missing noun, adjective, and location properties to the
	hatchLadder in the attic (present).
	- Removed deprecated conditional movement from fdriveway.sw, returning 
	simply fFrontOfHouse.
	- Added isListed = true to the mattress in the junk.
	- Fixed squirrel's response to ">SQUIRREL, WHO AM I".
	- Added a verDoPutIn() rejection message to the bookItem class.
	- Changed lookupVerb to disambigDobjFirst.
	- Expanded lookupVerb.validIoList to check if dobj is found in
	a particular bookItem, and if so, return only that bookItem
	as valid.
	- Added doOpenWith to the grating.
	- Added other synonyms for pryWith (useWith, openWith) to the
	shovel and the machete.
	- Copied junk.doSearch code into junk.doLookin code.
	- Made new classes: priseItem, diggingItem, hackItem.
	- Added 'dig up' to digVerb.
	- Removed (sigh) lookupVerb iobj disambiguation code, above. Restored
	original parsing sequence.
	- Removed 'bulb' as a noun property from the secretPassageLightBulb.
	- Changed pencilitem to pencilItem. Made it a priseItem (although
	not an effective one).
	- Added an ioDefault = timeManual to lookupVerb (duh).
	- Added an ioDefault = crowbar to pryVerb.
	- Added ioDefault = shovel to digVerb.
	- Added ioDefault = machete to cutVerb.
	- Added doDefault check to pushVerb, choosing a time machine button
	first, and then the wall opener if you're in the garage.
	- Debugged pushVerb.disambigDobj.
	- Modified buttonitem to add typo synonym 'buttton'.
	
	(9:03pm)
	
Version 4.1.85 
	(04-10-01) (8:15pm) Yesterday when I started up again, I found out
	that I'd forgotten to transfer the bug reports to a floppy, so what
	I did was from memory. I suppose I don't need to make this a new
	version number, but it helps me keep track of things.
	
	- Changed coffeeTable.ldesc in the easter egg room.
	- Made package.askingAboutMe() responses more specific based on
	game state (although not more helpful).
	- Fixed extra new_line bug in doFredAction function.
	- Added peskyFly unimportantItem in case players feel the need to
	interact with the one Fred occasionally swats at.
	- Separated 'empty' as a verb, from cleanVerb, making emptyVerb.
	- Implemented special responses to Me.doClean() and Me.doCleanWith.
	- Me.doEmpty() (i.e., >EMPTY ME) executes as an implied >DROP ALL.
	- Fixed spacing error in >ASK FRED ABOUT JUNK response.
	- Changed >ASK FRED ABOUT GARAGE DOOR OPENER response.
	- Added an unimportantItem called 'shop' so that when you're in the
	sandwich shop, you can >X SHOP, even though no IF location is expected
	to be available to the parser when you're standing in it. (Sorry, do 
	I sound acerbic?)
	- Changed unimportantItem class to make it easier to personalize the
	default message it prints.
	- Added a verDoEnter() rejection message to the sewer hole.
	- Synchronized the sewer hole in the past to the one in the present,
	in terms of newer action responses.
	- Added handling for attempts at entering grating/sewer hole in
	present at past, including just typing >DOWN at those locations.
	- Changed climbdownVerb.doAction -> 'ClimbDown'.
	- Changed all 'DoClimbdown's to 'DoClimbDown'.
	- Added verDoBoard() check to thing.
	- Changed chairitem.canReachContents = true
	- Restored inherited doDefault/ioDefault return to all modified
	instances if the forced-default item is not in the player's inventory.
	- Added missing pryWith checks for Pgrating for all priseItems.
	- Added typo 'abotu' to aboutPrep.&preposition list.
	- Added missing break statement to doSquirrelAction function, iteration 5.
	- Mapped generic thing.throwIn -> putIn.
	- Added setit( playerCash ) to fiveDollar.doTake().
	- Removed buyVerb.prepDefault, which was causing an error on >BUY by itself.
	- Fixed interiorLobbyDoors location property.
	- Added functionality to the lobby directory, allowing you to look up
	Laura's name. It disambiguates between just "Laura", "Laura Remick", and
	"Laura Remick-Larson"/"executive vice president".
	- Changed it so that if you're sitting on the rock (any of them), >JUMP
	will be handled as if you wanted to get off of the rock.
	- Changed Fdrainspout to a floatingItem that only appears behind the
	house when future.state is appropriate.
	- Added a check for walking southeast when the security guard stops you
	at the elevators. (This is a hack for now; basically, everything to do
	with the security guard needs to be changed from a quick and dirty
	implementation to a full one.)
	- Removed extra space in Fred's response to throwing a throwable item at him.
	- Fixed typo in the entry on paradoxes in the library book.
	- Added callVerb and implemented 'call elevators'.
	- Changed Fred.ioGiveTo() check from fiveDollar -> playerCash.
	
	(12:08am) (04-11-01)
	
Version 4.1.9
	Continuing with Doug Jones's v4.1.4 transcripts.
	
	- Cleaned up code dealing with leaves in the gutters and drainpipe (taking,
	searching, cleaning).
	- Fixed a bookItem bug (verDoPutIn instead of verIoPutIn).
	- Fixed adv.t library bug, where the standard cleanVerb response didn't
	take plural items into account.
	- Synchronized future.t roof leaves, gutter, drainpipe with present.t 
	refinements.
	- Added more descriptive (and adaptive ) text to the southOfHouseWindow.ldesc.
	- Refined southOfHouse.ldesc, making it more adaptive to game state and 
	more organized in its presentation in general.
	- Added missing adjective 'bare' to southOfHouse's secretDoorWall.
	- Created locationDesc class, for making >X HERE type commands (sigh) 
	available to the parser. Inherits from unimportantItem class.
	- Created a dummy clearing object of type locationDesc for all of the 
	clearings in the game.
	- Changed the 2x4 plank's description to be a yard instead of a meter long.
	- Added verDoLookin and verDoSearch responses for NPC class.
	- Fixed P2ndFloor's view.ldesc, which was out of sync with current version's
	descriptions of the past's shopping village. Added more adjectives.
	- Added workshed.doEnter(), outsideWorkshed.&in.
	- Fixed bug where the teller in the past still thought Laura was the
	new accounts clerk.
	- Added another scenery object to the future.t rock, filmyBlackSoot.
	- Added more functionality to the lobby elevators, e.g., doEnter().
	- Added a parseAskobjActor() function.
	- Added a waitForVerb.
	- Implemented >WAIT FOR FRED after you've told him about his future.
	- Implemented >WAIT FOR ELEVATORS.
	- Changed outsideShed.xdesc to be adaptive (workers eating lunch or not).
	- Fixed bug when putting things in the drainpipe (used another PutIn 
	command instead of moveInto).
	- Implemented putting things into the drainpipe spout (present and future).
	
	(12:43am) (04-13-01)
	
Version 4.2.0
	(05-01-01) (3:31pm) Aha, so where was I? No one has sent any more data
	in more than two weeks, so it's up to me to do something. I guess I'm
	thinking of looking at the NPCs and beefing up their interactivity and
	conversation. Past-Laura seems like a good place to start. Rather than
	a robotic cut-scene, I can implement it a little more fluidly, I think.	
	
	I'm thinking maybe it should also be possible to visit her again after
	the little scripted scene, in case you still want to talk to her.
	
	- Made a topics.t module for conversation stuff.
	- Made a Topic class, which is just fixeditem.
	- Added more conversation to PLaura and FFLaura.
	
	(4:36pm)
	
	(05-09-01) (2:12pm) Here I am again. My thoughts are rather scattershot
	today, so I'm not sure what I'm going to work on. This felt like the
	project-of-the-day to take up, is all.
	
	- Fixed 'climb rope' bugs for escaping the attic, and in general 
	reworked attic-exiting code.
	- Changed error message for trying to leave the attic without the
	rope to something that's more of a hint at the solution.
	- Removed the broken ankle thing, probably for good.
	- Added window3.doSynonym('LeapTo') = 'Board' and 'Enter'.
	- Added xdesc to 'dangling'.
	- Added climb up/down/to/in behavior to dangling room items.
	- Added >PUT obj OUT WINDOW.
	- Fixed throwVerb behavior, in a variety of locations (treeRooms, 
	mostly) and with a variety of prepositions.
	- Going >UP from southOfHouse now prints the message about the
	scrawny tree being unsuitable for climbing instead of "You can't
	go that way."
	- Fixed throwVerb behavior in topOfTree. If player doesn't specify
	an indirect object, it assumes you mean the attic window.
	
Version 4.2.5
	(06-10-01) (7:38pm) Here I am again, after another break. I guess I'll
	just go for some more NPC convo, although I think there are still bug
	reports that I haven't finished going through. 
	
	- Renamed topics.t module to convo.t.
	- Revised ABOUT and CREDITS information.
	- Created ground-floor blueprint illustration for game "feelies."

Version 4.2.9 
	late(?) June 2001

	- Created PDF manual for game release.

Version 4.3.0
	(07-12-01) (6:35pm) Time to get this ready to go. 1400 objects,
	2700 vocabulary words. Not sure of total code length (sigh). I 
	output the strings to a file, and the file was 495kb. I pruned 
	it down and made an estimate of how much of that file size could
	be considered story-text, in terms of comparing the amount of 
	writing to a book. It still seemed to be 150kb, or 600 pages.
	That still sounds like too much! Even slicing that in half yet 
	again, it's still 300 pages of writing. Could there really be
	that much writing in it? The Statesman reporter wanted to know
	what she could compare it to. Yikes. No wait, I got my math 
	wrong by a factor of five. (Assuming one byte equals one text
	character, with an average of five per word, and 250 words per
	page.) So, 160 or 80 pages.
	
	Okay, a smarter way, I just realized, is to total up the four
	complete walkthrough files, which make up a complete transcript
	of the game. They total 181kb, which is about 145 pages. That
	seems much more likely.
	
	- Added doEmpty() to container class. Checks for being on time machine
	platform or in a tree, adjusts behavior appropriately.
	- Added synonyms DUMP, DUMP OUT to emptyVerb.
	- Fixed typos in SPRAY GRATING WITH WD40 response.
	- Changed junk.thedesc and adesc.
	- Corrected sewerHole.verDoPutIn() to sewerHole.verIoPutIn(). Same
	for PsewerHole.
	- Complete overhaul of hacking-through-the-maze behavior. Now leaves
	open pathways behind as you hack your way through it. It takes longer
	for your arm to get tired, but I left that code in.
	- Fixed problematic behavior from the platform. It was saying "I don't 
	see any foliage here." instead of "You can't reach that from here." 
	Problem was in the mazeFoliage.location method, which wasn't checking
	for the player being on the platform. 
	- Added powVerb ability to unimportantItem class.
	- Added better adjectives to the dummyClearing locationDesc items.
	- Modified when FPclearing.noMaze is set. Now it prints a message and
	sets the flag only when you first enter the clearing from the northeast.
	- Changed FPclearing.rodPoint so that it points northeast instead of
	south once that pathway is open.
	
	One of the things I like about this hacking business is that if you
	hack open too many pathways, it still functions like a maze, and you
	can get lost in it even with the open paths. I had to snarf the 
	divining rod while testing to find my way through it! I'm pleased
	now with this final version of the forest maze.
	
	- Added hackDirVerb for handling HACK NW, HACK SOUTH, etc. I wish
	I could allow it, but it prints an error message instead. It would
	be freakishly complicated to add this capability. Well, maybe just
	time consuming. I'm not going to do it tonight, anyway. (10:54pm)
	
Version 4.3.1
	(07-13-01) (7:34pm) Well, having played Freecell for about four 
	hours, I guess I'm ready to start again. Sigh.
	
	- Added DOWN direction to the ledge/crevice in the cave crawl.
	- Added verDoClimb() rejection to the mazeFoliage.
	- Added a crystalCavernPool in the crystalCavern, which was mentioned
	in the room's lightDesc.
	- Added a couple of adjectives to the genericLight object.
	- Added verIoPutIn() handling to the waterItem class.
	- Changed the carTrunk so that it's automatically locked when it's closed,
	and automatically opens when you unlock it.
	- Added carTrunk check for crowbar.ioPryWith().
	- Added verDoOpenWith() to openable and doorway classes.
	- Removed fixedBlock class from the carTrunk declaration.
	- Added automatic handling of OPEN TRUNK "(with the ___ key)" handling
	if you are carrying either of the appropriate keys.
	- Added deepGrab and recursiveOpen functions, for moving things from
	deep within containers in the player's inventory to the player's hands.
	- Fixed bug in deepIsIn method where it called isIn() instead of itself for
	the recursive pass.
	- Fixed detector bug; 'herring' was listed as a noun instead of an adjective.
	(More old old old code!)
	- Removed annoying room class xdesc that said "There are no exits." It
	didn't help anything, and the message it printed never made sense.
	- Added GET OFF TIRE/ROPE when you're dangling from the attic.
	- Changed FfrontDoorInside.ldesc (it used to inherit directly from 
	FfrontDoor.ldesc, which didn't apply).
	- Added a FfrontdoorInsideNails unimportantItem. Made sure they disappear
	if the nailedBoards are pried off the front door.
	- Added a tree to Fattic when future.state = 3.
	- Fixed bug in Architect.actorDesc if he's not in P2ndFloor.
	- Fixed typo when you ask Fred about the past.
	- Fixed spelling errors: labelled, stencilled, supiciously, accomodate,
	lablled, coencentric, foward, straighens, vistor.
	- Fixed fullscore typo: the points for pouring jugs said "for for..."
	
Version 4.3.2
	(07-14-01) (8:10pm) More...
	
	- Chased down a bug in all verbs where I'd added a disambigDobj or 
	disambigIobj method. It was doing the check and then saying "pass disambigDobj",
	but there was no inherited routine, which caused a Stack Underflow error. I
	changed this to "return ( [ DISAMBIG_CONTINUE ] + objlist )".
	- Added adjectives 'u' and 'd' to the up and down elevator buttons.
	- Added a mention of the kitchen door entrance to the inGarage.xdesc.
	- Fixed typo "isLocked" instead of "islocked" in garageState function.
	- Added a special message for attempting to put a sandwichItem into the 
	sewerHole.
	- Added a mirroring room and objects at the ledge/jaggedGap. Now there's
	a south version and a north version, with slightly different descriptions
	depending on which side of the gap you're standing on.
	- Changed the crystalCavern.xdesc to be more generic, in case the player
	didn't arrive from the cave crawl.
	- Changed brightBend.xdesc so that it only mentions the ledge if you've
	already visited either ledgeSouth or ledgeNorth, otherwise describes the
	tunnel disappearing into darkness.
	
	Hm, that's it for the beta-test reports. Now what I need to do is work
	on the NPCs. The security guard needs work, and then there are all the
	various Lauras and Freds and so forth. There's also the on-rails portions
	of the game that need to be loosened up. However, things are looking good.
	I thought it would take longer to go through the rest of the reports, but
	I'd already handled a number of things from them without moving the files
	into the "logs-done" folder. (9:14pm)
	
Version 4.3.3
	(07-16-01) (2:33am) Time to figure out if I want to change the convo
	system at all -- it's very old code, never updated, but it works. My
	only reason to update it would be to make it easier to plug in the
	rest of the conversation stuff that I want to add, or to make some
	conversation branching possible in the PLaura monologue -- ie, making
	that less of a monologue. Hrm. I'm also thinking of activating that
	code for Blackie the dog, finally. Time to experiment a bit and see
	what I come up with, although I just realized tonight that I don't
	have quite as much time to finish this off as I thought. Instead of
	a full week left, I only have until thursday night/friday morning,
	really. Sigh. So close and yet so far. Oh well. It won't be perfect,
	but I hope it will be limited-but-good.
	
	- Put Blackie the dog's location insideShed. Hope he works.
	- Moved jug5 of miracle-grow to the front of the house, meaning it is
	the only jug that is immediately available for taking. This means that
	the miracle-grow puzzle has two stages 1: pacify Blackie, 2: figure out
	how to grab all of the jugs before the guy swipes them, by using the
	wheelbarrow.
	- Added a smellDesc to miracle-grow jug and liquid classes.
	- Fixed various Blackie behaviors and responses.
	- Added a tickleVerb.
	- Added a head, belly, tail, and ears to Blackie.
	- Modified the sdesc and thedesc on Blackie's paws.
	- Added rub, scratch, and tickle handlers to NPC class.
	- Added rub, scratch, and tickle handlers to Blackie and his various parts.
	- Added rub, scratch, and tickle handlers to Me.
	- Added goodVerb handling to basic classes.
	- Revised workers.actorDaemon so it doesn't print an extra blank line if you're
	not within earshot of the construction noise.
	- Added Blackie to global.NPC_list, eliminating a bug with showVerb.
	- Added typo 'sandiwch' to the two sandwiches.
	- Added Blackie to the sandwiches' askingAboutMe().
	- Added special handling for dropping items in the shed that are of 
	immediate interest to Blackie.
	- Added a badVerb.
	- Modified NPC.actorAction for giveVerb.
	- Modified squirrel.actorAction for giveVerb, which had an inappropriate 
	(backwards) response.
	- Created a rollVerb.
	- Added rollVerb behavior to ball objects.
	- Added special doDrop actions on the cannonball if you drop it while
	on the roof.
	- Added doClean methods to the frisbee and tennis ball, in case Blackie
	got them all slobbery.
	- Added speak, sit, stand, lie down, roll over, beg commands to Blackie.
	- Added playWith and PLAY CATCH/FETCH WITH.
	- Fixed bug where the frisbee and tennis ball were described as slobbery but
	weren't becoming so.
	
	(6:55am)
	
Version 4.3.4
	(07-17-01) (12:20am) 
	Re-implements the lightningRod and significantly expands NPC conversation
	on a range of new Topics. Am finally seeing how to work the dibbleBits stock
	idea back into the game (wow), which means I might put the newspaper object
	back into the game. Basically, you give PLaura a suitcase containing $5000
	and she'll make investments for you, and you can suggest DibbleBits -- from
	your amazing knowledge of the future. This would effectively tie up all of
	the loose ends dangling since the early planning of the game. How exciting.
	To do this, I'm going to have to implement PLaura's office, probably making
	it unavailable until after you've met FLaura. 
	
	- Revised HELP information.
	- Added code to make the lightningRod appear in the antiqueShop, triggered
	the first time you meet Future Fred.
	- Changed FFLaura.doAskAbout() to reject further inquiries if she's finished
	her speech.
	- Added conversation for various convo.t Topic items.
	- Forced the conversation to start if you don't help PLaura pick up her
	spilled papers.
	- Moved 'chewbacca' references from the Architect to a Chewbacca topic.
	
Version 2.3.5
	(01-17-01) (8:14pm) Okay, I think what I want to do is figure out that
	stuff with the stocks and so forth. A place to start, anyway. It'll 
	probably lead me to fix a bunch of other things as I go.
	
	- Routed questions about the various Lauras to a general askingAboutLaura
	Topic.
	
	Okay, the weird and the neat thing about wanting to tie up all of these
	loose ends is that there are placeholders and currently-dormant objects
	all throughout the code for everything I was planning to do, as if this
	was how it was supposed to be all along, even if I'd set it aside for the
	longest time. How strange. I keep surprising myself by thinking, "I should
	make a... oh wait, here it is already."
	
	- Added talkAboutMyself methods to all of the Lauras.
	- Put the newspaper back into the game.
	- Added an investInVerb.
	- Added a stockItem class.

	(07-18-01) (4:30am) Went home, had something to eat, mixed some songs.
	Read a magazine. Now I'm back again.
	
	- Modified the museum tour at the end to take into account whether you
	have helped Fred or not.
	- Added personalized disavow() messages to various NPCs.
	- Modified consultWords to have better TELL NPC ABOUT ME handling.
	- Modified ABOUT text again.
	- Revised NPC.doTellAbout() code so that it doesn't overlap or use askAbout 
	code any more.
	- Added tellAboutDisavow() to NPC class.
	- Modified FFLaura ASK rejection message when she's finished with her speech.
	- Added FFLaura TELL rejection message when she's finished with her speech.
	- Added the metal suitcase to the game.
	- Added bulk to moneyItem class.
	- Changed it so that you lose any loose piles of cash you have with you 
	during a time jump.
	
	Argh! I'm getting a weird compiler error -- invalid types for + operator, but
	it lists the error as coming from the ftf_4.t file, which is just a bunch of
	#include statements. I have no idea where the actual error is, despite looking
	over all of the changes to moneyItem and playerCash code I just made (which 
	seems like what must be causing it). I can't exactly do a search for '+' with
	any efficiency, either. Sigh. 
	
	Okay, I did a systematic search for '+' in all of the files I've changed 
	tonight, and I still can't find any errant use of it. This is so disappointing!
	I don't know how to figure out where this error is coming from, which means I
	have to stop for the night without compiling and with no clue how to start
	again tomorrow. Bleah. (7:11am)
	
	Hmm, I think I've tracked it down to far_past.t, which is good to know. (7:33am)
	
	It's definitely the far_past.t file. The problem goes away when I replace it
	with the last archived version. However, I still can't find a bad use of '+'
	in the file. I guess now I'm going to go through the good and the bad versions
	line by line and restore the changes I made tonight one at a time until I 
	either get the compiler error again or end up with an updated but non-compiler-
	crashing version. (7:50am)
	
	- Moved the two daylight-description objects in flowingStream and grotto into
	those locations' lightDesc properties.
	- Added listenDescs to the stream and stream locations.
	- Fixed dastardly bug by making antiques a searchHider again.
	
	It occurs to me that I went through this before, when I was fiddling with
	the front doormat. It's the bug that tenthstone (John McCall) helped me
	track down. preinit() was bombing because I assigned a searchLoc to an
	object that wasn't listed as being a searchHider. Whew. Okay, now I can
	go home. (8:16am)
	
Version 4.3.6
	(07-19-01) (12:26am) Foof. I don't even know where to start tonight.
	Maybe with the actual implementation of the stockItem class? We'll see.
	
	- Rearranged version.sdesc.
	- Removed investInVerb and moved its verbs to buyVerb.
	- Expanded NPC, WHERE IS ___ abilities.
	- Added LAURA, BUY [stock] to PLaura.
	- Added exit to PLaurasOffice from inTheBank.
	- Added handleStockPurchase function.
	- Handled trying to give Laura a massive pile of cash.
	- Moved handleStockPurchase to stockItem class.
	
	(07-19-01) (8:48pm) Had kind of a short day yesterday. I'm starting to 
	get some kind of a cold, and I can feel my reserve energies being allocated
	to fighting it off, leaving me slightly foggy-headed and unable to keep track
	of the large number of parallel details involved in writing code. Oh well, I'll
	try to work as best I can, but I guess I don't want to kill myself to meet the
	deadline, either.
	
	- Added a variousStock Topic which has handlers for various real-world tech
	stocks that went big. Player isn't allowed to buy them, ha ha.
	- Wrote FLaura.meetLaura2, which is conditional on your owning DibbleBits
	stock.
	- Added points for installing the lightningRod, buying DibbleBits stock, and
	(should have been there, but wasn't coded) grinding the duplicate front door
	key, bringing the total points to 151.
	- Fixed bug where it was still moving jug5 into the shed after pouring a
	fourth jug of miracle-grow.
	- Added a weird hack to make the score notification for buying DibbleBits
	appear at the end of the correct turn.
	- Expanded the scoreRank function by one more rank to account for the extra
	10 points that are now available.
	- Modified inTheBank.xdesc to take into account the new west exit.
	- Fixed bug with the secretSwitch class, where it was improperly assuming
	all three time periods used the same switch, thus confusing setit(), among
	other problems.
	- Fixed bugs with the three secret doors, which were missing otherside and
	doordest properties.
	- Fixed bug where it didn't take into account your being in the garage
	when FFred shambles back into it.
	- Fixed missing \b in FLaura.actorDaemon.
	- Fixed bug where the special message upon entering the secret chamber was
	printed even if the player had already seen it or had arrived via the 2nd
	time machine.
	- Fixed bug where the north exit from FmasterBedroom skipped the 
	downstairs hallway and pointed at the foyer.
	- Fixed bug with FmasterBedroomSecretDoor, which also had its otherside
	and doordest properties either wrong or missing.
	- Fixed FmasterBedroom southeast exit to return self.noexit instead of
	nil if FmasterBedroomSecretDoor isn't there.
	- Updated all of the test transcripts to conform to the current game state,
	winnable with a full 151 points.
	- Added a couple of handlers for taking Fred to meet Laura and/or PLaura.
	
	
Version Release 1.0
	(07-20-01) (3:47am) Hmm, Could it be? I have to call it done at some point,
	and tonight's as good a night as any. I wish I could do more, but I think
	I'll be glad to call it done for now after all these years. Wow.
	
	
Version Release 1.1
	(07-23-01) (12:23am) The release had some weird bugs in it, mainly to do
	with any decoration item that was a tree, a plant, or leaves. No idea why
	yet. Also, one of my last changes on emptyVerb munged responses for, say,
	>CLEAN GUTTER and CLEAN DRAINPIPE. Not too bad, though. 
	
	- Fixed ABOUT text, which was still printing the stuff that was supposed
	to be commented out.
	- Fixed mazeFoliage.location method, which was forgetting to check if 
	Me.location.location was valid before evaluating Me.location.location.isFoliageRoom.
	- Moved generic doEmpty behavior from container class to openable class.
	- Put the same doEmpty code into the cartItem class.
	- Fixed typo in CYOA game.
	- Fixed useVerb behavior with the herring detector.
	- Changed pourVerb defaultPrep from inPrep to onPrep.
	- Mapped EMPTY IN/ON to POUR IN/ON.
	- Mapped miracleGrowItem doEmpty behavior to miracleGrowItem doPour behavior.
	- Moved verb reassignments -> platform from the timeMachineItem class to the
	specific time machine objects.
	- Added missing doBoard and doUnboard verb reassignments to time machine 
	objects.
	- Removed the red herring property from the pillowcase.
	- Added a verDoClean message to gutter1 and Fgutter1.
	- Added doEnter handling for House scenery objects.
	- Added doSynonym('Enter') = 'Board' to chimney.
	- Fixed talkToVerb doAction, which wasn't properly capitalized.
	- Removed self.isSeen check from thinkAbout behavior.
	- Changed NPC.playerTypedTalkToOnce to global.playerTypedTalkToOnce.
	- Added missing global.playerTypedTalkToOnce := true statement.
	- Added antiqueMerchant to global.NPC_list.
	- Changed diggingSpot.xdesc so that it doesn't use the word "through" twice.
	- Added doBuy and doBuyFrom actions to the antiques object.
	- Changed dummyBill.askingAboutMe( Laura ) to return account.askingAboutMe( Laura )
	because it was being tapped first by ASK LAURA ABOUT MONEY.
	- Added missing handlers for dibbleBits and lotharioCorp.askingAboutMe( Laura ),
	which now initiate their handleStockPurchase methods.
	- Changed variousStock sdesc, adesc, and thedesc properties.
	- Added a variousStock.handleStockPurchase method and askingAboutMe( PLaura ) 
	handler.
	- Changed PLaura.buyCommand check from walkPathCount < 8 to < 7.
	- Added decoration desk and cabinet objects to PLaurasOffice.
	- Added missing return( true ) to dummyBill.askingAboutMe( Architect ).
	- Fixed broken and/or confused FinsideHouse exit properties, notably west, south,
	and out.
	
	
Version Release 2.0
	(02-20-02) (12:45pm) Well, I've been nominated for a couple of Xyzzies --
	Best Game and Best Puzzles, I think. So I'm uploading it to the ifarchive
	and fixing some of the bugs reported on V1.1. I was going to call it version
	1.2, but I like the idea of version 2.0 having serial number 20020220.
	
	- Fixed bug in theFloor, where I called actor.location.location.doUnboard() 
	instead of just actor.location.doUnBoard(). 	
	- Fixed bug with OPEN CAR, where if statements were nested incorrectly, 
	and there was no 'pass doOpen' at the end.
	- Boosted metalSuitcase capacity.
	- Removed antiques.verDoSearch(), which was overriding the ability to 
	search the antiques with a flat message. I'd forgotten that I'd put the
	metal suitcase in there as something to be found by searching.
	- Added a leaving() handler for the antiqueItem class, preventing the
	player from walking out with unpaid-for merchandise.
	- Modified antiqueStore.leaveRoom() to print special messages.
	- Removed stupid loseMoney() function, which robbed you of all cash
	when making a time machine jump.
	- Fixed another problem with the car, namely being inside it and typing
	OPEN CAR. When it was locked, it said "It's locked. Opened."
	- Fixed more car things, all dealing with being inside it when you type
	OPEN or UNLOCK or UNLOCK WITH.
	- Fixed bug where the Architect would act as if you'd changed the blueprint
	when you hadn't. (Missing {} around a call to waitForPlayer, so it was
	always being run.)
	- Fixed bug in future.t where it was using garageDoor1 instead of 
	FgarageDoor1 to tell you whether the door was open or closed in the
	room description.
	- Fixed bug (yay) whereby people were teleporting straight into the
	Fattic without doing the whole tree crawl. I really hated knowing this
	bug was in there. It was, again, a case of missing {} on an else clause,
	which meant that it was printing a denial and then moving the player to
	the attic anyway.
	- Fixed bug where you could take the lightning rod after it was 
	attached to the house.
	- Fixed bug in rescue.decideWhoComesForHelp that was bringing FLaura
	back after you'd already met her.
	- Fixed bug whereby you could enter the house from the secret passage
	even if future.state said there should only be a burned-out shell.
	- Added synonyms for Architect. (Yet more 1996-version legacy code!)
	- Changed default responses to trunkRoomAtticOpening.doEnter().
	- Fixed bug whereby the car trunk was takeable.
	- Added proper statusPrep and outOfPrep to stainedCouch.
	- Fixed bug with FFred sdesc, thedesc, adesc where it would say
	'someone' more than the very first time, always looking odd.
	- Added a couple of more descriptions for giving the whisky bottle to
	FFred, assuming you're in the garage when this happens.
	- Added a missing check to see if FFred is already in the garage before
	moving him there. Doing this caused a phantom FFred (really, his follower)
	to appear in the garage also, confusing the parser (and the player).
	- Fixed bug where laboratoryWorkdeskDrawer was takeable.
	- I had commented out the NOTIFY verb. Don't know why. It's back in.
	- Fixed bug in my score notification feature, where global.lastScore
	was only getting zeroed if score notification was on. It now zeroes
	it every turn, regardless.
	
	(5:00pm) (8:13pm)
	
	- Put FFred sdesc/adesc/thedescs back the way they were, because I 
	suspected that my extra code (assigning self.met to true) would break
	something. However, I changed 'someone' to 'shabby man' in each case.
	- Changed reference to 80-story skyscraper to 70.
	- Fixed typo in CYOA book p_94.
	- Put in another check for out-of-range elevator button values on
	numberedButtons.doPush().
	- Changed references to Laura Foster to Laura Remick.
	- Fixed bug in cutscene that had Carl remembering rescuing you when he
	hadn't.
	- Moved Laura's line about "Don't forget your things" to tinyChar.doUnboard
	instead of fooling around with leaveLists and counting contents lengths and
	so forth.
	- Fixed bug with tinyChair where re-sitting in it would start FFLaura's
	speech all over again.
	- Fixed handling of selling an item and gathering your money together.
	If you don't have the rest of your cash in the antique store when you
	sell something, it prints a fudge-y message about how you 'somehow'
	gather all your money together. Better that than losing some of it.
	I wish I could make the message funnier, so that at least players would
	be in on the joke of it.
	- Put a check on showing-NPCs-to-the-merchant, so she doesn't consider
	them merchandise.
	- Made the whole antiqueMerchant.ioShowTo() routine a little more 
	elaborate, allowing for first-time and repeat messages; and checks for
	NPCs (including the merchant herself) and the player.
	- Added check to make Fred refuse to leave the storage room (the path
	that ultimately leads to FFLaura's office).
	- Put a check in so that Fred doesn't say 'Woo! Where to this time?'
	after just being all freaked out and wanting to leave the storage room.
	- Put a check in so that Fred notices if you push the time button(s)
	without getting onto the platform(s) first.
	- Finally changed it so that you don't have to SEARCH CAR to find the
	armrest compartment, it's just there in the description. This was 
	something everyone complained about. (Yet, curiously, everyone who
	complained about it solved it. They were just annoyed when they
	discovered it.) Points for finding the armrest have changed to points
	for opening the armrest and finding the garage door opener. Although,
	if you ask me, that's too easy. It's easy to find the spare key, and
	finding the garage opener is one step after that. The point, and the
	reason I kept it the way it was for so long, was to properly pace the
	player's explorations. Oh well.
	- Fixed bug in lightningRod.ioAttachTo(), which used <<self.thedesc>>
	instead of <<io.thedesc>>.
	- Removed a few adjectives from secondBlueCrystal to clear up parser
	ambiguities.
	- Fixed typo: erroneous leading \" when you don't have enough money
	to open an account.
	- Removed deprecated (and parser-confusing) FdummyNhouse object.
	- Fixed bug where opening the bank account was double-scored.
	- Added double-check in setupAccount function to make sure the account
	is not, in fact, already open before running through it all.
	- Fixed bug in, er, ExcreteVerb.
	- Added a strongVerb for other curses.
	- Fixed bug with FpinkInsulation.location (was using attic not Fattic).
	- Fixed bug with Thing.doSell() that caused a blank line as output.
	- Added more handling to antiqueMerchant.ioSellTo(), similar to the 
	additions I made to antiqueMerchant.ioShowTo().
	- Removed 'blue' adjective from genericLight because it gets confused
	with the blue pencil at times.
	- Fixed bug with hackItem.ioKillWith(). Also wrote a special message
	if it's the squirrel you're trying to kill.
	- Fixed bug where NFLaura said 'forty years ago' you helped her, even
	if it was PLaura (30 years ago) to whom you gave the envelope.
	
	And that's it for Version 2.0, because it's almost midnight and I
	want to have the date be official. Also, this is significantly improved,
	so I feel good about it. (11:59pm)
	
	
Version Release 3.0
(3:14pm 12-10-06)
	Work on this new version was occasioned by the discovery of the missing
	first pages of the XXX Gang story, which is the Easter Egg game within
	the game. Having opened the files to do some tinkering, however, I decided
	to see if there were any bug reports that had gone unfixed. Big surprise,
	there were.
	
	- Modified about text for CYOA game to mention the new pages.
	- Added 'climb ladder' to PinsideHouse location.
	- Fixed 'draw on blueprint with pencil' handling.
	- Changed 'version' and 'about' texts to be in line with Version 3.0.
	- Changed the #2 pencil to be a 'school pencil', because '#2' couldn't
	  be parsed by TADS.
	- Fixed Psewerhole.DoLookin() and .DoLookunder responses. (Gad, this is
	  based on really early code, and put together in a manner I now consider
	  highly illogical and convoluted. I'm tempted to "fix" the sewer hole in
	  the Present, but I don't want to risk breaking it, since the code has
	  worked for ten years.)
	- Fixed responses for any attempt to draw on the blueprint when the Architect 
	  is present.
	- Fixed messages when attempting to draw with the lead pencil. 
	- Fixed missing else-if after 'draw on blueprint with blue pencil' message.
	- Added missing verDoOpenWith() to Pgrating.
	- Fixed response to PsewerHole.DoLookin().

	(12:11pm 12-11-06)
	- Added new CYOA pages. Fixed an OCR-generated typo in the old material.
	- Fixed inconsistencies with climbing the large tree in the future when
		future.state = 2. It was allowing you to shimmy along the branch
		to the attic, then chiding you for getting there by cheating, among
		other erroneous behaviors. Wrote a few more descriptions to go with
		response points.
	- Fixed bug with trunkRoomAtticOpening.verDoEnter() and .doEnter, related
		to the above.
	- Modified numObj methods to check for global.wizard rather than 
		actor.islit for the wizard-setting powers to set future.state and
		global.timeLoc.
	- Changed the wizard-power invoking magic word to 'kertimetravel'.
	- Fixed bug with shimmyTrunk's location method.
	- Modified handHolds.ldesc to mention strong branches up ahead only
		when future.state = 3.
	- Added 'shimmy on' 'shimmy off' 'shimmy forward' 'crawl on' 'crawl off' 
		'crawl forward' synonyms.
	- In general, tried to straighten out all shimmy/climb/crawl synonyms
		with and without prepositions for climbVerb, inVerb, outVerb, and
		climbDownVerb. Probably with mixed success.
	- Added alongPrep because the game told you that you can 'shimmy along'
		the trunk, but without allowing it.
	- Added backPrep, for crawling back to safety.
	
	(10:09am 12-12-06)
	- Using the wizard verb now gives you 500 dollars as well.
	- Before calling yorn() when asked questions by NPCs, the game now prints
		a double prompt >> instead of a single one, to distinguish it.
	- global.lastScore now accumulates a total for the turn, rather than
		setting itself solely to the last score tallied, leading to an
		incorrect score notification (only the notification feature was
		affected).
	- Removed 'new' and 'accounts' ask adjectives from Laura's desk, because
		it interefered with >ASK LAURA ABOUT NEW ACCOUNTS.
	- Added 'accounts' to the account object.
	- Tweaked newlines in new account transaction.
	- Removed newline from beginning of garageOpenerItem.doPush output.
	- Being a wizard lets you pick up the wheelbarrow.
	- Commented out old testing cheat when entering the antique store.

(11:02am) Oh, man. The money handling is all screwed up. It's redundantly
	keeping track of the player's assets twice, with global.money (the 
	original system, deprecated but intact) and playerCash both tallying
	the same number in parallel, and some functions checking global.money
	and some checking playerCash.value. I really would like to clear that
	up, but what a can of worms. I mean, it works right now, and if I try
	to fix it, I have to fix eighty things at once without introducing an
	error into any of them, which is -- sigh, risky. Grrr. Grumph. Hrm.
	Part of it is that if I just use playerCash and moneyItems, I can 
	see how to do something I didn't have the patience to do at the time,
	which is actually let the player drop little free bits of cash in
	various places, and having them agglomerate when held or stored 
	together. But that's a pretty big deal, too! I guess what I will do
	for the moment -- I was chasing a bug when you had cash and sold the
	wheelbarrow, and the original cash you had disappears -- is try to fix
	that and leave the rest of it as it is for the moment.
	
	Ok, wait. This is what started me on this line of thinking. What the
	problem is is that the handleMoneyTrade function is broken, and not
	doing what it is purportedly supposed to do. A smarter bit of code
	that does a recursive check to see if the player has cash tucked away
	somewhere, then adds the new cash to that stash, exists in the sellable
	class doSellTo() method. I need to put something like that in the handleMoneyTrade
	function, except that leads me to want to make deeper changes to that function
	while I'm at it. I guess I should stil try to be surgical. 
	
	- Added topLocation() function.
	- Changed penny.askingAboutMe() for Laura, who erroneously said that 
		you could deposit pennies into your account.
	- Rewrote handleMoneyTrade() function. Kept the magic ("Presto!") part 
		where if you left some cash lying around somewhere other than the
		transaction that just took place, it is all magically gathered up
		and put in your possession, just because keeping that means I don't
		have to rewrite anything else.
	- Edited and trimmed the text when crawling along the tree, which was
		nicely written but way too dense after the halfway point. 
	- Changed the floorDesc for several of the crawling-on-the-branch rooms,
		so that looking at the ground inspires vertigo and sends you to
		hangingForDearLife immediately.

	(1:52pm) Hmm. Picton makes an interesting point about the future. One, there
	is no incentive to get into the house there via the trunk, since you can get
	in via the secret passage. He suggests making you have to find something in
	the future house before the secret passage can be created, which is a good
	idea in theory, but I have to think it through more thoroughly. It occurs to
	me that, in general, apart from the ATM, the future world is entirely scenic
	rather than connected to the plot. Even if you go in the house and find 
	future Fred, dealing with him is optional. Getting into the house lets you
	see what a mess it is, but it's also optional. You don't actually have to.
	I was personally shocked to see that getting successfully to the house via
	the tree trunk doesn't give you any points! I need to fix that, but that is
	a big mess because of the way the global.scoreCard is hard-coded. In fact,
	just giving points for that would at least give the player the motivation
	of doing it to get a full score at the end, but that's lame. What is the
	reason for going in the house? There has to be something to *do* besides 
	seeing how crappy everything is.
	
	Note to self for tomorrow: meeting future Laura is a hell of a chunk of
	non-interactive text.
	
	(11:13am 12-13-06)
	- Edited meetLaura and meetLaura2 cutscene text.
	- Opening the secret passage causes FLaura to show up, if she hasn't already.
	- Changed engineering blueprints to engineering schematics, for disambiguation
		and accuracy of terminology's sake.
	- Suppressed FFred's actorDesc if you're meeting him for the first time.
	- Architect now says he'll give some thought to the "secret switch" rather
		than the "secret mechanism", because asking about the mechanism got
		a "I don't have an opinion about springs and tumblers" response.
	- Fixed FLaura.actorDaemon bug that incremented a counter erroneously.
	- Entering the FAttic for the first time also triggers FLaura to appear,
		if she hasn't already.
	- Added muddy car tracks scenery to go with a description added to the
		FLaura.actorDaemon. (Although, I'm not sure that gets printed in
		the current configuration. However, I might continue to rewrite
		this tomorrow, in which case it will become relevant again.)
	- Set the FwallOpenerButton.isListed to nil.
	- More rewriting of the meeting FLaura scene, making it smarter about
		recognizing when she's waiting for you, and placing the dark sedan
		as scenery viewable from within the house. 
		
	I really would like to break up this scene into individual turns, where you 
	can examine the people and the car and attempt to make conversation to a 
	limited extent, but that's really -- I dunno. First I want to just
	get it working a little more nicely the way it already exists, in
	case I run out of energy to do anything more. There are still other
	bugs in the game to fix.
	
	There is still an extraneous newline in the FinGarage room description
	the first time you enter, and I cannot figure out why it's being printed.
	It's driving me crazy, but I may have to just leave it that way. 
	
	- Set FgarageDoor1 (and its otherside) to be open after FFred starts
		wandering around.
	- Fixed buggy FgarageBackDoor, which seemed to be open, closed, locked,
		and unlocked, all at the same time.
	- Set FkitchenBackDoor.noAutoOpen to nil after FFred bursts out.
	- The back door into the garage is no longer locked, since there wasn't
		any reason (that I could think of, though I recall that I originally
		had a reason) for it to be that way.
	- Added sayHello() messages to FFred, who didn't have any but the
		generic one. Sheesh.
	- Removed extraneous newlines when climbing up and down the stone wall
		to the roof of the Future house.
	
	Note for next time: there shouldn't be a working secret passage if
	the house is too burned to support it. This makes it possible to
	arrive at the new future even if you never do the rod or the roof.
	Fixing all three should be more or less mandatory before you can
	get to the endgame.
	
	(12:14pm 12-14-06)
	
	- Changed FgarageDoor1 and 2 to be isListed = nil.
	- Made the game more precisely aware of when the house is too damaged
		to allow for a working secret door.
	- Modified the secret door, wall, and switch in the future, as above.
	- Added 'charred' and 'timbers' and suchlike to the general burned-house
		scenery item, because those are mentioned in room descriptions.
	- Modified theFloor.discoverSwitch(), same.
	- All four sides of the house are now consistent in how their exits 
		behave if future.state < 3 or >= 3.
	- Removed the down exit from FinsideHouse that allowed passage to the
		secret chamber, provided the player had seen it. Now it is 
		disallowed with a special message acknowledging that it has the
		potential to exist. (I'm not sure how a player could have seen
		the passage yet end up in the burned shell of the house, but 
		maybe it's possible, so I'll leave it like this.)
	- Added more synonyms for the furnitureRemains scenery, as well as an
		ldesc.
	- Changed the east exit for all behindHouse locations to say "You can't
		enter the house from here" instead of the generic "There is nowhere
		to go in that direction."
	- Removed (with some regret, at the lost possibility of a little more
		fun to be had) the teasing suggestion that "Perhaps there's 
		another way to access the back yard" in the New Future, because
		there is not. Maybe in version 4...
	
	Okay, changing the garage door to be isListed = nil seems to have gotten
	rid of the extra newlines that were appearing in FnorthOfHouse, but the
	extra space is still there in FinGarage. Grr.
	
	- The furnitureRemains now only exist in future.state 2. 

	The furniture remains had been listed everywhere as being in the 
	future.state 0 version of the house descriptions, which didn't make any 
	sense. However, now the problem I'm having is that all of the descriptions
	of the house from the four sides are exactly the same, which is really lazy
	of me. It doesn't even make a whole lot of sense sometimes, like describing
	the damage to the south half of the house when describing the north half.
	The east and west sides both use the same descriptions as the south. It's
	really crying out for a tailoring job, but argh. I can see why I didn't do
	it in the first place. It's not really that important, but it requires a lot
	of effort. Hrrm.
	
	- Did a lot of work on the north and south roof in the future. You can only
		walk as far as the north roof because of the hole in the south roof.
		Scenery items relating to the damage have been moved from the south
		to the north roof. Some descriptions have been rewritten as the mood
		has struck.
	- Made a separate scenery item for plural debris.
	- FFred.actorDesc now runs meetFred() if self.met = nil. (Aha, that's what
		was causing the newline problem in the garage.)
	- Modified Fjunk descriptions and interactions.
	- Modified (again) the down exit from insideHouse, saying the way is 
		blocked with debris.
	- Modified the up/south exit from the secret chamber (which you can get 
		to, if you have created the secret passage but haven't done the lightning
		rod or fixed the roof) so you can't exit if the house is burned.
	
	Hmm. I'm suddenly struck with the notion that Picton was valiantly and
	repeatedly trying to bring to my attention. I had the creation of the 
	secret passage pegged as the point where you can open the endgame, because
	you get access to the second time machine. If that means that you can 
	immediately go and talk to FFLaura and all that, then that's really
	screwed up. He was trying to tell me that you could create the New Future
	even though the Future is still a burned-up house, and I think he's right.
	This is a very serious problem, and I'm not sure what to do about it. I
	wanted to get on with some business that was more fun (a new Easter Egg
	mini-quest, where you collect various otherwise unimportant items from
	everywhere in the game, and put them in a trophy case, and get some sort
	of bonus prize at the end), but I really have to think about this. Hrm.
	
	- Modified the herring detector, so that it no longer tells you specifically
		what its job is, merely hints at it. Discerning the meaning
		of what it does, and how to use it, is now another small puzzle 
		for the player.
	- Modified the bank teller, and the deposit and withdrawal objects, so
		that conversational responses are more sensible.
	- Teller now has responses to >[ASK/TELL] TELLER ABOUT ME.
	- Fixed bug in NFmasterBedroomSecretDoor where otherside pointed to
		a non-NF door object.
	- Fixed bug in deposit.verDoMake that was failing to recognize that
		the player was in the bank.
	- Added ability to type $>I at the 'how much do you want to deposit?' 
		prompt to get a report of how much money you have with you.
	- Changed the antiqueDoor to a simple scenery object, with a direct
		entrance to the antiqueStore from FPvillage.east.
	- Changed the behavior of cartItem (actually, the cartMove function),
		and I hope not inadvisably, so that the wheelbarrows do not 
		fit through doorways. Wait! I need to make an exception for the
		garage doors.
	- Changed FgarageDoor1 and 2 to inherit from garageDoorItem class, which
		they should have anyway, but now they especially need to.
	
	Grrrrrr. The garageDoorItem class does nothing useful except screw up
	normal opening and closing behaviors, which is exactly wrong for the
	garage doors in the future, which is why they didn't inherit from that
	class in the first place. It seems stupid to make them inherit from it,
	then override the only thing that class does, but that's what I have to
	do, so.
	
	- Wrote tailored descriptions for opening and closing the garage doors
		in the Future. (So there.)
	- FFred now has more tailored responses for interactions.
	- Added giveItemToSomeone method to NPC class, which is run when the
		player does >NPC, GIVE [OBJECT] TO ME or >ASK NPC FOR OBJECT.
	- Modified FFred's giveItemToSomeone, so he won't give up the whiskey
		bottle.
	- Rewrote Me.ioGiveTo() to give a more sensible response ("You accept
		the foo from you." was what the adv.t default ended up printing.)
	- Rewrote the bits that follow from giving FFred the whiskey bottle,
		hopefully eliminating a bug that tried to move him into the 
		garage even when he was there. (The original code was trying 
		to check for that, and apparently not working.)
	- FFred.stopActorDaemon explicitly moves the FFredFollower object 
		to nil, just so there's no disambiguation confusion should it
		happen to end up in the garage also.
	- Added a missing check to case 1 of FFred's actorDaemon, to give a
		special description if the player is in the kitchen when it is
		run.
	- FFred can take the whiskey bottle even if the player has nestedly
		hidden it, as he now has the powers of deepIsIn() at his 
		feverish disposal.
	
	Okay, unfortunately, it's quitting time. Reminder to self: you need
	to test all of this FFred code you just added. (6:35pm)
	
	(7:53pm) Back again. What I want to do with the New Future, or rather
	New Far Future as well, is make the game more symmetrical at the end,
	so that the New Far Future resembles the forest of the Far Past. Maybe
	in some way the New Future could resemble the Past, with construction
	work being done on the house once again. But I'm not sure I can do that
	tonight. What I'd like to do now is try to playtest the game as it stands,
	and see if I can get to the end. If I remember how... 
	
	- Added a Note verb that takes a string as a direct object, so I can
		write transcript notes to myself.
	- Fixed a doubled word in FPclearing ldesc.
	- Fixed the spelling of "desiccating" everywhere it appears.
	
	(9:24pm) SERIOUS BUG: You can deposit $100 immediately after opening
	the account, ending up with $200 in there right away. I guess it isn't
	checking playerCash, or something. And fix the inconsistent map leading
	to the shopping village in each time period. I forgot to make it so that
	you can't give the envelope to PLaura, you have to go to FPLaura. Drop the
	schematics from the exhibition room. Work on NPC.ioShowTo().
	
	- Added missing doordest to NFmasterBedroomSecretDoor.
	- NFFrontDoor no longer locked.
	- The shiny new key is now a 'copy', and the original no longer is,
		but it's now 'old', and has a modified ldesc.
	
	Playtest is over! It's still winnable, whew. But I noted 104 things,
	although I fixed these few, and some of them are positive comments,
	and some of them are things for a hypothetical Version 4 that has
	more substantial changes than I have time to do now. (11:06pm 12-14-06)
	
	(11:43am - 12-19-06)
	Just going to make some small changes, I hope. I want to spend the rest
	of the time thinking about maybe an improved PDF to go with the game, and
	how to compile it with metadata, which all the kids are doing these days.
	
	- Fixed laying -> lying in frontOfHouse room description.
	- Added 'moonlight', 'sunlight', and 'starlight' to permanent scenery objects.
	- Added 'woods' scenery to clearing, and 'leaves' to canopy.
	- Added ldescs to stoneWall1 and FstoneWall1.
	- Rewrote item.verDoPointAt().
	- Modified time machine description and coolDesc to be smarter about
		reporting the heat state.
	- PLaura is now summoned when you give the Architect the hot sandwich,
		not when you give him the bad shingle.
	- Modified package.ldesc, adding the "spindly hand" description and
		eliminating the need to separately READ the package (though it
		is still allowed).
	- Modified the detector's happy response, eliminating a double space.
	- Removed, however, the package and the detector entirely, for the time
		being, since they don't make any sense. I might like to put the 
		package back in if I could think of something genuinely useful
		to put in it.
	- Fixed bug where Blackie leaves the item at your feet but it appears
		in the shed instead.
	- Fixed a bug where if you throw a sandwich out of the shed, it assumes
		that Blackie is there to chase after it, which isn't always the
		case.
	- Planting the acorn now removes the softSpot.
	- Restored the original game behavior where you have to look for the
		fifth jug only after pouring the first four. The new change is
		that Blackie only appears when the fifth does, guarding that
		last silly jug.
	- Pouring out a jug adds the adjective 'empty' to that jug, and changes
		its sdesc and pluraldesc.
	- Cut the number of construction worker messages to one every other
		turn on average.
	- Experimentally starting Blackie PnorthOfHouse instead of nowhere.
	- Removed an assumption of location = insideShed from throwable.DoThrowTo.
	- Okay, I think Blackie needs to start nowhere and then appear in the
		shed, despite what I just did.
	- But I added a mention of Blackie when the burly landscaper steals
		the jugs.
	- You can snarf things from NPCs (and the squirrel) that they would
		not otherwise cede when you have wizard powers activated.
	- The jugs use deepIsIn to make their leaveList check.
	- The burly landscaper now appears when you're leaving the shed, not
		when you re-enter it later, so that you have the chance to UNDO
		that turn as soon as you've made the game unwinnable. (I thought
		it was already like that! Silly 1996-me.) This also eliminated
		a lot of doubled (tripled) code and put it in one sensible place.
	- Reluctantly added a duplicate class of emptyJugItem so that empty
		jugs replace the full jugs when you pour them out.
	- Removed loseMoney() function entirely and all references to it.
	- Changed numObj.doSay and .doTime to say something other than 
		"Nothing happens", which could be misleading to players, since
		they don't know about the wizard verb.
	- Added special-case handling for throwing a sandwich, inside and outside
		the workshed, with and without Blackie in the former case.
	- Rewrote the Architect's hunger gripe slightly.
	- Fixed a long-standing bug in Architect.actorDesc that exactly prevented
		the proper description from being printed (and printed it when it 
		shouldn't have).
	- Special parsing for ASK ARCHITECT FOR SECRET PASSAGE.
	- Swapped the garage opener and the tourist map, so that the useful item
		is in the locked glove compartment and the useless one is in the
		silly armrest.
	- Changed completely the lightningRod situation:
		- You find it by searching the antiques.
		- The merchant therefore doesn't greet you with a special message
			later on in the game, alerting you to it.
		- It now costs 85 dollars.
		- It doesn't have the weird initials 'wcwd' any more. I still
			wonder what that was supposed to stand for when I came
			up with it.
		- It has a slightly different sales pitch now, since the 
			initials are gone.
	- The antiques merchant greets you differently the first time you
		bring the wheelbarrow in. She also welcomes you back on repeat
		visits, and asks a rhetorical question that possibly can be
		answered by the player.
	- She has an actorDesc now.
	- The antiques are now noAutoTake, serialSearch = true.
	- Eliminated the Pbend location. PfrontOfHouse.east => Psidewalk.north => Pvillage.
		This also eliminated the nonsense of having yet another copy of the
		sewer hole and the trickle of water.
	- Wrote a salesPitch for the metal suitcase. Removed the restriction on
		closing it before taking it.
	- Changed the divining rod to a "divining wand", because the lightning rod
		disambiguation was driving me crazy, especially when asking people
		their opinions on one or the other.
	- The epilogue clearing is now a rodroom, with the rod pointing at the
		fountain pool.
	- Removed the insulation from Fattic, and changed the state=5,7 description
		to eliminate mention of it. It mentions the warped floorboards instead.
	- The strip mall is now north of Fsidewalk.
	- Fixed the FFred bug that made a TADS object error. (It was checking
		whiskeyBottle.location.upstairs when the location was nil.)
	- Rewrote AboutTheGame text.
	- Pushing the wheelbarrow says "You push the wheelbarrow forward."
	- >GET ON with no object now defaults to the time machine platform.
	- >GET ON TIME MACHINE gives you a message saying you need to specify the
		platform, a consequence of fixing the above.
	
	(1:56pm 12-20-06)
	- Pushing the wheelbarrow says "You push the wheelbarrow northeast.", etc.
	- Fixed Fattic out/south exit messages.
	- Added DoUnboard check to FatticWindow and gapingHole.
	- Fixed bug with Fattic_tree not being declared a floatingItem.
	- Special message when pushing the wheelbarrow, ie, northeast when starting
		on a time machine platform.
	- Created GameInfo metadata file and cover art.
	- Asking the merchant about the wheelbarrow and the cannonball now works. (GRR)
		Argh, no they still don't. I'm too tired and fed up to figure out why
		her generic rejection messages, or completely blank messages, are being
		printed. I shouldn't have to be still doing things at this level! I wanted
		to be done already, but these errors are so basic. You can't ask her about
		any of the things she's willing to buy! GRRR.
	- Fixed bug where trying to take the playerCash item out of the wheelbarrow
		put it back into the wheelbarrow, rendering it effectively untakeable.
	- Fixed mechant -> merchant typo.
	- Fixed bug where you could buy the wheelbarrow again, but the merchant
		wouldn't let you leave the store with it.
	- Fixed bug where you could sell the cannonball without having it with you,
		by asking the merchant about it.
	
	(9:10pm 12-20-06)
	I'm making so many random changes I can't keep track any more. I'm still trying
	to get the dealings with the antiques merchant to work. And I started on that
	because I was trying to figure out the error with the teller allowing you to
	make a deposit after you used all your money to open the account, thus 
	doubling your money. But now there's a completely inexplicable problem where
	if you just type >DEPOSIT after opening an account, the game stops doing 
	anything, although you can type carriage returns, which is unusual for a 
	crash. (Eight minutes later.) Hm, okay, things seem to be working more or
	less all right now.
	
	- Added verDoDepositIn and doDepositIn to moneyItem.
	- Modified the teller.makeWithdrawal so he just rejects the withdrawal
		rather than pretending to start the transaction and giving you a
		lame excuse.
	- Changed zigzag room exits and ldesc. Modified adjacent rooms to match.
	- Changed Laura's ldesc.
	- Added verIoDepositIn to account.
	- Answering '0' to the teller's request for a deposit amount will
		cancel the transaction.
	- Changed Laura's response to the rare book.
	- Altered default doHello check, using topLocation instead of Me.isIn.
	- Removed code in helloVerb that was allowing for any object, present or
		not, to be a validDo.
	- Removed code from sayVerb that made the acorn the default direct 
		object. (Uhh.)
	- Modified FFred.takeBottleFromLocation, which was printing messages 
		copied from takeBottleFromPlayer and didn't make sense in context.
	- Expanded timeTravel askingAboutMe responses, and made tellingAboutMe
		return the same respones.
	- Modified FnorthOfHouse state 3 description and smellDesc.
	- Added a thankVerb, and NPC responses to being thanked.
	- Added responses to >THANK YOU and >THANK GOD.
	- Modified Pvillage.north response to drop the bit about good old Fred.
	- Added check for Me.contents before FFLaura tells you to take your things.
	- Added ask/tell responses for the sealed envelope for various Lauras.
	- Added 'q' and 'quity' handling for die() function prompt.
	- PLaura will no longer accept the envelope.
	- FFLaura only reacts to conversation about the envelope when she's
		finished speaking.
	- NPCs have a notImpressedMsg, which is that they're not impressed by
		whatever you're showing them. That was always the default, but 
		FFLaura now has a different message. In the future, perpaps,
		other NPCs will as well.
	
	(12:19am 12-21-06) Okay, I guess I'm compiling it with resources added
	and possibly releasing it as-is.

*/

/* eof */
