import "story/archway"

function vultures_appear()
	image "vultures"

	clearText()

	if calledOutInCell then
		text [[The birds – it seems there are two? – regard you with deep suspicion.]]

		text [["Was it you making all the noise? That commotion we heard from across the district?"]]
		text [["What is the purpose? Are you ill?"]]

	else
		text [[The bird – birds? two of them? – seem almost as surprised as you. Four avian eyes blink slowly. "You're awake."]]

	end

	text [[They take a few steps forward into the room proper, and in the meagre light you can see more clearly that they are in fact a single bird - a large vulture with two bald heads, both beaks clattering as they barrack you with questions.]]

	text [["Have you decided to confess your crimes?"]]
	text [["Do you suffer from any maladies, lunar derangement, things of that nature?"]]
	text [["Are you an habitual criminal? Does your family have a history of malfeasance?"]]
	text [["Have you considered throwing yourself on the mercy of the court?"]]

	choice([[Try to interrupt: "You can talk?"]], "vultures_youtalk")
end

function vultures_youtalk()
	text [[They stop.]]

	text [["So can you. What's improper about that?"]]
	text [["All creatures of intelligence can talk."]]
	choice([["Why are there two of you?"]], "vultures_2ofu")
end

function vultures_2ofu()
	text [[Both heads protest: "There's only one of me!"]]
	choice([["I mean, why do you have two heads?"]], "vultures_2heads")
end

function vultures_2heads()
	text [[The bird's left head draws itself up proudly, or at least draws up the half of the bird that it occupies. "The law," it declares, "in its infinite impartiality, must always look in both directions at once."]]

	text [[The bird's right head turns to look at it. "That doesn't address the question at all. Answer her!"]]
	choice([[Interject. "The law?"]], "vultures_thelaw")
end

function vultures_thelaw()
	text [["Yes! The law." Left head. "I - which is to say *we* - am or are the duly appointed prosecutor designate pursuant to the upcoming hearing of Miss-Name-Goes-Here with regard to her wayward conduct and the appropriate redress thereof."]]

	text [[The right head leans forward. "What *is* your name, by the way? The Remembrancer will need it. For the records."]]
	choice([["My name? Is it important?"]], "vultures_myname")
end

function vultures_myname()
	text [["It could be." The right head nods knowingly. "I have witnessed Leofric surgically obliterate defendants who can not remember times or places. Imagine what he could do against someone who does not know who they are!"]]

	choice([["Leofric?"]], "vultures_leofs")
end

function vultures_leofs()
	text [[The left head answers "Yes?"]]
	text [[You turn to the bird's right head. "And you're also Leofric?"]]
	text [["Don't be absurd. Imagine if we had two of the same name! What a confusion would result! My name is Leofwine."]]
	jump "vultures_hub"
end


--HUB STARTS HERE


function vultures_hub()
	choiceOnce([["Wait, what was that you said about defence? And redress? What's going on here?"]], "vultures_h_defence")

	choiceOnce([["I'm on trial? This is ridiculous! I haven't done anything!"]], "vultures_h_haventdone")

	choiceOnce([["So I'm being kidnapped?"]], "vultures_h_kidnapped")

	choice([["Can I leave?"]], "vultures_h_leave")
end

function vultures_h_defence()
	text [[Leofwine's speech takes on a slowed frustration, like a tutor coaching a pupil through a sum they should know how to do already.]]

	text [["Even as an outsider to the city, you are entitled to a full hearing, during which you will be given leave to account for your criminal activities and express your remorse." ]]

	text [[Leofric is nodding.]]

	text [["A comprehensive admission of responsibility will go a long way toward preparing for your rehabilitation and reintegration into society."]]

	jump "vultures_hub"
end

--HAVEN'T DONE ANYTHING


function vultures_h_haventdone()
	text [["We'll be the judge of that!" Leofric snaps.]]
	text [["We will most certainly not. The matter will be adjudicated by the Remembrancer, as the authority designate during Her Serenity's period of absence."]]
	choice([["But what crime am I accused of?"]], "vultures_h_crime")
end

function vultures_h_crime()
	text [["Vagrancy."]]
	text [["Trespassing in the outer city."]]
	text [["Impersonating a True Citizen."]]
	text [["Dereliction of work duties."]]
	text [["Sleeping without due care and attention."]]
	text [[Leofwine shakes his head. "The outlook, sad to say, is bleak."]]
	jump "vultures_hub"
end

--KIDNAPPING

function vultures_h_kidnapped()
	text [["Kidnapping," says Leofwine carefully, as he fixes his gaze on you, "is most certainly a crime."]]
	text [["A criminal matter!"]]
	text [["I wouldn't go throwing such accusations around hither and yon if I were you. It could be very detrimental."]]
	text [["Your present state" – Leofric is becoming increasingly agitated – "owes only to your own malfeasance, and the proper operation of the law! You are being held in confinement custodial, to await your hearing in the fullness of time."]]
	jump "vultures_hub"
end

--CAN I LEAVE

function vultures_h_leave()
	text[["No." Both together.]]
	text[["You must understand–" begins Leofwine "–what difficulty that would present for your case. Fleeing the city before your hearing even begins would be as good as a confession! And you'd be brought back forthwith, make no mistake about that.]]
	text[["As your advocate I would advise against it in no uncertain terms."]]
	choice([["Very well. You agree that if I leave…the city…it would damage my case?"]], "vultures_h_case")
end

function vultures_h_case()
	text[["Incontrovertibly."]]
	text[["Irreparably."]]
	choice([["But how can I build a case at all without any evidence? I should be allowed to walk around the city as long as I don't leave."]], "vultures_h_evidence")
end

function vultures_h_evidence()
	text[[Both look immediately unsure.]]
	text[[You interrupt Leofric before he can say anything. "And if I do leave, you said yourself, I'll be brought straight back. So even if I'm wandering the city I can't escape the law."]]

	text[[Leofric stops. He doesn't say anything for a moment.]]
	text[["Out of the question," says Leofwine. "The harm you would do to your position if you happened to stray outside, even for a moment, would be incalculable. Even the suggestion could be ruinous to your case."]]

	text[["On the other hand," Leofric says thoughtfully, "there is precedent for allowing the condemn-…the accused to participate in scaffolding their defence. I refer of course to the case of *Choak v Grunhallow*-"]]

	text[["With consent proper obtained from their appointed attorney! Which in respect of the case before us I must refuse to grant, on grounds of this defendant's-"]]

	text[["But if you refer, my good Leofwine, to the matter of *Tregaskis v Penhaligon*, you will of course be reminded that in matters pertaining to the defendant's own inclinations the need for attorney's consent may be obviated by order of the authority designate, by which and in other words I mean the Remembrancer…"]]

	choice([[Try to get their attention.]], "vultures_h_attention")
	choice([[Steal the key while they're not looking.]], "vultures_h_steal")
end

function vultures_h_attention()
	vultureNonsense()

	choice([[Steal the key while they're not looking.]], "vultures_h_steal")
end

function vultures_h_steal()
	text [[You snatch up the key and run to the door. The two heads are so preoccupied that they completely fail to notice you escape.]]
	jump "archway"
end

function vultureNonsense()
	local calls = {
		[["Under the Purbury Convention…"]],
		[["…*without* which the assessor *must* provide an eel-measuring apparatus of a *standard* length…"]],
		[["If you recall the case of *Cuthbert v Gramswade*…"]],
		[["With reference to the prosecution of Trengrouse for unlicensed grouse-training…"]],
	}
	local responses = {
		[["Yes, but only on alternate Thursdays!"]],
		[["That has no bearing here, as well you know!"]],
		[["A preposterous linkage. You're merely extemporising!"]],
		[["That precedent was abolished in the *same year* by the *same judge!*"]],
	}
	local c, r = math.random(#calls), math.random(#responses)
	text(calls[c])
	text(responses[r])
end
