/*
 *
 * Portcullis
 *
 * Places
 *
 * code and data dealing with the map
 *
 */

DAEMONS = [];
 
var Place = new Object;
NUM_PLCS = 0;
function pl(name,fullname,description,append,sights,special,exits,hExits,daemon)
{
	Place[++NUM_PLCS] = new Object;
	Place[NUM_PLCS].id = NUM_PLCS;
	Place[NUM_PLCS].name = name;
	Place[NUM_PLCS].fullname = fullname;
	Place[NUM_PLCS].description = description;
	Place[NUM_PLCS].append = append;
	Place[NUM_PLCS].sights = sights;
	Place[NUM_PLCS].special = special;
	Place[NUM_PLCS].exits = exits;
	Place[NUM_PLCS].hExits = hExits ? hExits : '';
	Place[NUM_PLCS].daemon = daemon;
	eval(name + ' = Place[' + NUM_PLCS + '];');
	
	// flags that don't need to be part of the constructor
	Place[NUM_PLCS].isTown = false;
	Place[NUM_PLCS].isCastle = false;
	Place[NUM_PLCS].isOutdoors = false;
	Place[NUM_PLCS].floorNumber = -10;

}


function set_conditional_exits() {
	set_inn_exits();
	set_drawbridge_exits();
	
	// make sure we know the magic word!
	var knowMagic = false;
	var dotmagicdot = '.' + gs(MAGIC_WORD) + '.';
	for(var i=1; i<=NUM_SYNS; ++i) {
		if(('.' + Synonyms[i]).indexOf(dotmagicdot)!=-1) {
			knowMagic = true;
			return;
		}
	}
	if(!knowMagic) { words(gs(MAGIC_WORD)); }
}

function floor(place) {
	if(place.isCastle || !place.isOutdoors) {
		return 'floor';
	} else {
		return 'ground';
	}
}


pl('nowhere',
'nowhere',
'You\'re nowhere! You shouldn\'t be here!',
'',
'',
'');

pl('hut',
	'Hut',
	'You [[ gs(BEGUN_GAME) ? "are" : (sgs(BEGUN_GAME, 1) , "start your day") ]] in \
	your hut, a small cubical dwelling of dark brown wood. By way of furniture, there\'s a bed, a \
	couple of chairs and a small table. The place isn\'t much, but it keeps the rain out.',
	'',
	{
		'bed' : 'Just a plain wooden bed with a straw mattress.',
		'table' : 'A small wooden table. Rather knobbly, but it does the job.',
		'chair' : 'Just a couple of creaky old chairs.'
	},
	{},
	{
		'out' : 'outside_hut'
	},
	{
	}
);
hut.isTown = true;

pl(	'outside_hut',
	'Outside hut',
	'You are in the back streets of Portcullis, outside your own hut. \
	A mud track runs through a neighbourhood of similar shacks. The sea \
	lies to the west, and you can make out the harbour to the north.',
	'',
	{
		huts : 'A row of ramshackle huts from the amateur school of architecture, \
				   built by the peasants of Portcullis out of whatever they could find. \
				   Your own hut is one of the more modest examples, but hopefully among the less \
				   likely to actually fall down.',
		sea: '[[ harbour.sights.sea ]]'
	},
	{
		west : 'The sea blocks your way in that direction.',
		swim : 'Not likely!'
	},
	{
		north : 'harbour',
		east : 'outside_inn',
		in : 'hut',
	},
	{
	}
);
outside_hut.isTown = true;
outside_hut.isOutdoors = true;

pl('harbour',
'Harbour',
"A square of water is isolated by driftwood fences from the western sea. There are a couple of \
jetties[[ gs(BOAT_GONE) ? '' : ', to one of which a fishing boat is moored' ]].",
'',
{
	sea: 'The western sea stretches off to the horizon, shimmering green and brown in the sunlight.',
	jetty: 'Two narrow wooden structures leading out across the harbour\'s water. There are no boats moored to them.'
},
{
	west: 'The sea blocks your way in that direction.',
	swim: 'Not likely!'
},
{ north: 'beach', east: 'town_square', south: 'outside_hut' },
{},
null);
harbour.isTown = true;
harbour.isOutdoors = true;


pl('outside_inn',
	'By the inn',
	'You stand outside a homely stone building. Below a sign \
	reading "THE RAMPART INN" is an open door, emanating a smell of cheap \
	beer and happiness.',
	'',
	{
		'inn' : 'A cozy little place, the Rampart is Portcullis\'s hottest nightspot \
				(not that that\'s a particularly high bar.) Lanterns are on inside, \
				and the odour of dark beer wafts invitingly from the doorway.'
	},
	{},
	{
		north : 'town_square',
		east: 'outside_alchemists',
		west : 'outside_hut',
		in : 'inn'
	},
	{
	}
);
outside_inn.isTown = true;
outside_inn.isOutdoors = true;

// pl(name,fullname,description,append,sights,special,exits,hExits,daemon)
pl('inn',
	'Inn',
	'The Rampart Inn is warm and comfortable, with a fireplace, comfy seats, and \
	welcoming conversation of an evening, though it\'s not busy at the moment.[[ gs(BEER_CELLAR_OPEN) ? " A ladder leads down through a trapdoor in the floor." : "" ]]',
	'*set_inn_exits()',
	{ 'furnace' : "A nice old coal-burning fireplace. It's not lit, but somehow its presence makes the room feel warmer anyway." },
	{ 'buy' : "*buy_drink()"},
	{ 'out' : 'outside_inn' },
	{},
	function() {
		if(heroloc()==inn && gs(READ_NOTE) & !gs(MEETING_HAPPENED)) {
			if(ppgs(WAITED_IN_PUB) == 2 && !gs(BEER_CELLAR_OPEN)) {
				say("\n\nA party of professional adventurers arrives: Ariane the Elf, Fraf the Barbarian, \
				Miranda the Priestess, and Staunton the Wizard.\n\
				Miranda says something to Lara. Lara opens a previously invisible trap door in the floor, revealing \
				a ladder leading to a cellar. The four adventurers climb down.");
				/* Bechdel point! */
				get_point_for(BEER_CELLAR_OPEN);
				set_personloc(ariane, beer_cellar);
				set_personloc(fraf, beer_cellar);
				set_personloc(miranda, beer_cellar);
				set_personloc(staunton, beer_cellar);
				set_inn_exits();
			}
		}
	}
);
inn.isTown = true;
function set_inn_exits() {
	if(gs(BEER_CELLAR_OPEN)) {
		inn.exits = { out : 'outside_inn', down : 'beer_cellar' };
	}
	else {
		inn.exits = { out : 'outside_inn' };
	}
}
function buy_drink() {

	if(personloc(lara) != heroloc()) {
		say("There's nobody serving.");
		return;
	}

	else if(!Token[2]) {
		say("I'm not sure what you want to buy.");
		return;
	}
	
	//                             (fudge, since "give lara money" gets redirected here too)
	else if(Token[2]!='drink' && !(Token[1]=='give' && Token[2]=='money' &&Token[3]=='lara')) {
		say('Lara shakes her head. "We\'ve got beer, beer or beer."');
		return;
	}
		
	else if(gs(BOUGHT_DRINK)) {
		say('Lara shakes her head. "You\'re not having another. I remember how you got at solstice."');
		return;
	}
	
	if(spend(1)) {
		say('You pay Lara one zorkmid, and she pulls a pint of foaming ale and hands it to you.');
		give_hero(drink);
		get_point_for(BOUGHT_DRINK);
	}
}

pl('beer_cellar',
'Beer cellar',
"You are in the Rampart Inn's damp beer cellar. A little light beams down from a trapdoor in the low ceiling, \
and a ladder leads up through it. The place is half full of barrels, some of which have been arranged in a circle \
as makeshift seats.",
'',
{
	'barrel' : 'Oak barrels with iron bands, smelling of various types of beer.',
	'stair' : 'A metal ladder leads up to the main room of the inn. It\'s a bit rusty, but looks solid.'
},
{
	'smell.barrel' : 'The barrels smell of sour beer and mildew.'
},
{
	up : 'inn'
},
{
	out: 'up'
}
);
beer_cellar.isTown = true;

pl('outside_alchemists',
'By the alchemist\'s shack',
'You are outside a tiny shack made of metal sheets leaning together at precarious angles. \
Colourful flashes and various chemical odours come from inside. A sign reads \
"Portcullis Centre for the Alchemical Sciences".',
'',
{},
{},
{ north: 'temple',
  west: 'outside_inn',
  in: 'alchemists_shack'
},
{},
null
);
outside_alchemists.isTown = true;
outside_alchemists.isOutdoors = true;

pl('alchemists_shack',
'Alchemist\'s shack',
'You are inside a tiny metal shack. Glass jars of powder line the walls, \
and a blackboard in one corner displays an esoteric formula. In the middle of the \
room is a huge cylindrical vat full of a bubbling green liquid.',
'',
{
	blackboard: "*look_blackboard()",
	vat: "A cylindrical vat about four feet in diameter and just as high, containing \
	      a frothing greenish liquid. Every so often a bubble rises to the top and bursts \
	      in a flash of coloured light.",
	jar: "Glass jars of various powders are arranged on shelves around the shack's walls. \
	      Some of them sparkle strangely, and others appear to be trembling slightly."
},
{},
{ out: 'outside_alchemists' },
{},
null
);
alchemists_shack.isTown = true;
function look_blackboard() {
	say('The blackboard reads: <div class="formula"><img src="img/formula.png" alt="String of esoteric symbols beginning with Pb and ending with Au" /></div>Fascinating.');
}



pl('town_square',
	'Town square',
	'The civic centre of Portcullis is a wide, stony open-air plaza with a number of benches \
arranged in a circle. There used to be the occasional town meeting here, before \
Zapdorf banned assemblies and took over most of the decision making. At one side \
is the town hall, a grandiose structure of grey stone.',
	'',
	{
		hall: "Portcullis's town hall is a hefty stone building that serves as the office of the \
		       mayor. It looks a bit tumbledown these days."
	},
	{},
	{ north : 'by_drawbridge',
	  east : 'temple',
	  south : 'outside_inn',
	  west : 'harbour',
	  in : 'town_hall' },
	{},
	null
);
town_square.isTown = true;
town_square.isOutdoors = true;

pl('town_hall',
	'Town hall',
	'Portcullis\'s town hall used to be where democratic (ish) decisions were made. \
	These days, it\'s rarely occupied. There are a dozen rows of seats, a \
	rickety-looking stage at one end, and a propaganda poster on the wall. A narrow staircase \
	leads up the wall to a loft office.',
	'',
	{
		stair : 'A narrow stairway leading upwards toward a loft office.',
		stage : 'A small stage, raised about a foot off the floor. It is empty.',
		poster: 'The poster reads: <center><img align="center" class="npc" src="img/poster.png" width="200" height="283" \
		         alt="Your friend the undead minion - oppressing you for your own good" /></center>'
	},
	{
		up : climb_townhall_stairs,
		'take.poster' : "It's fixed to the wall."
	},
	{
	 up : 'mayors_office',
	 out : 'town_square' },
	{},
	{}
);
town_hall.isTown = true;
function climb_townhall_stairs() {
	if(!gs(TOLD_ABOUT_JOB)) {
		say("The office isn\'t open yet.");
		return true;
	}
	if(pick(10) < gs(DRUNK)) {
		say('You try to climb the stairs, but you fall down them. Oof - umf - yowch!');
		return true;
	}
	
	return false;
}

pl('mayors_office',
	'Mayor\'s office',
	'A poky room with a balcony overlooking the hall. There is a desk here with \
	some ledgers on it, and a smell of spirits.',
	'',
	{},
	{ down : '*descend_townhall_stairs()', out: '*descend_townhall_stairs()' },
	{ down : 'town_hall' },
	{ out : 'down' },
	{}
);
mayors_office.isTown = true;
function descend_townhall_stairs() {
	if(pick(10) < gs(DRUNK)) {
		say('You fall down the stairs. Oof - umf - yowch!\n\n');
	}
	move();
}


pl('by_drawbridge',
'Drawbridge',
"You stand on the south bank of the moat of Zapdorf's castle, an immense fortress that dwarfs \
the rest of the city. [[ gs(DRAWBRIDGE_OPEN) ? 'The lowered drawbridge lies across the moat.' : \
'You are opposite the drawbridge, which stands resolutely closed against the castle wall.' ]] \
Above the entryway is a row of hideous gargoyles.",
'',
{
	drawbridge: 'A sturdy drawbridge made of thick teak planks, studded with dark metal spikes, \
				[[ gs(DRAWBRIDGE_OPEN) ? "lying flat across the moat." : "with a few \
				minor scratches where heavy-duty battering-rams have splintered like matchwood against it." ]]\
				[[ fraf_comments_drawbridge() ]]',
	door: "[[ by_drawbridge.sights.drawbridge ]]",
	moat: "The moat is a wide trench of nasty-looking greyish water, with a fast bubbling flow probably \
			caused by magic. Occasionally you think you see a fin or a tentacle pop up, but you'd rather \
			not make sure.",
	sea: "[[ by_drawbridge.sights.moat ]]", // syn. water
	gargoyle: "Five grotesque caricatures of animals, painted in garish colours: [[ gargoyle_descriptions() ]]."
},
{
	'open.drawbridge' : "[[ gs(DRAWBRIDGE_OPEN) ? \"It's already open!\" : \"There's no obvious way to do that.\" ]]",
	'open.door' : "[[ by_drawbridge.special['open.door'] ]]",
	'take.drawbridge' : "It's [[gs(DRAWBRIDGE_OPEN) ? 'far too heavy to lift.' : 'on the other side of the moat!' ]]",
	'take.door' : "[[ by_drawbridge.special['take.drawbridge'] ]]",
	'swim' : "No chance."
},
{	east: 'market',
	south: 'town_square',
	west: 'beach' },
{ north: 'in' },
null
);
by_drawbridge.isTown = true;
by_drawbridge.isOutdoors = true;
drawbridge_exits_closed = { east: 'market', south: 'town_square', west: 'beach' };
drawbridge_exits_open = { east: 'market', south: 'town_square', west: 'beach', in: 'entrance_hall' };
function set_drawbridge_exits() {
	
	if(gs(DRAWBRIDGE_OPEN)) {
		by_drawbridge.exits = drawbridge_exits_open;
		by_drawbridge.hExits = { north: 'in' };
		by_drawbridge.special['in'] = '*move()';
		by_drawbridge.special['north'] = '*move()';
		
		entrance_hall.exits = entrance_exits_open;
		entrance_hall.hExits = { south: 'out' };
		entrance_hall.special['out'] = '*move()';
		entrance_hall.special['south'] = '*move()';
	} else {
		var drawbridge_closed_msg = "The drawbridge is closed.";
		
		by_drawbridge.exits = drawbridge_exits_closed;
		by_drawbridge.hExits = {};
		by_drawbridge.special['in'] = drawbridge_closed_msg;
		by_drawbridge.special['north'] = drawbridge_closed_msg;
		
		entrance_hall.exits = entrance_exits_closed;
		entrance_hall.hExits = {};
		entrance_hall.special['out'] = drawbridge_closed_msg;
		entrance_hall.special['south'] = drawbridge_closed_msg;
	}
}
function fraf_comments_drawbridge() {
	if(!gs(DRAWBRIDGE_OPEN) && personloc(fraf)==by_drawbridge) {
		say('\n"We\'re not getting that open from this side," says Fraf.');
	}
}
function gargoyle_descriptions() {
	// animals: fish, lion, owl, snake, ox
	// colours: white, green, red, blue, amethyst
	
	var colours = ['white','green','red','blue','purple'];
	var animals = ['fish','lion','owl','snake','ox'];
	
	var gargoyles = [];
	for (var i=0; i<5; ++i) {
		gargoyles.push( 'a ' + colours[i] + ' ' + animals[ parseInt( gs(PYRAMID_KEY).charAt(i), 10) ] );
	}
	
	return joinWithAnd([ gargoyles[parseInt(gs(GARGOYLE_SHUFFLE_ORDER).charAt(0), 10)],
	         gargoyles[parseInt(gs(GARGOYLE_SHUFFLE_ORDER).charAt(1), 10)],
	         gargoyles[parseInt(gs(GARGOYLE_SHUFFLE_ORDER).charAt(2), 10)],
	         gargoyles[parseInt(gs(GARGOYLE_SHUFFLE_ORDER).charAt(3), 10)],
	         gargoyles[parseInt(gs(GARGOYLE_SHUFFLE_ORDER).charAt(4), 10)] ]);
}


pl('market',
 'Market stall',
 'You are beside a makeshift market stall on the south bank of the castle moat. \
 The stall is a structure of ash poles and striped fabric. On the counter is a handmade \
 sign reading \"ADVENTURERS\' SUPPLIES AND GIFTS\".',
 '',
 { sign: 'It still says "ADVENTURERS\' SUPPLIES AND GIFTS".',
   stall: 'A rattletrap structure that looks like it was designed and built in about five minutes \
           out of some branches and an old bathing costume.' },
 {
	 buy: buy_from_market,
	 pay: buy_from_market,
	 south: check_paid,
	 west: check_paid,
	 east: check_paid,
 },
 { west: 'by_drawbridge',
   south: 'temple' },
 {},
null
);
market.isTown = true;
market.isOutdoors = true;
function check_paid() {
	if(personloc(maynard)==market && (in_inv(snowglobe) && !gs(BOUGHT_SNOWGLOBE)) || (in_inv(tshirt) && !gs(BOUGHT_TSHIRT))) {
		say('"Oi!" Maynard holds you back. "Haven\'t you forgotten to pay?"');
		return true;
	}
	
	if(in_inv(snowglobe)) {
		get_point_for(GOT_SNOWGLOBE);
	}
	
	return false;
}
function buy_from_market() {
	
	if(personloc(maynard)!=market) {
		say("The stall seems to have been abandoned.");
		return true;
	}
	
	if(!in_inv(money)) {
		say("You haven't got any money.");
		return true;
	}
	
	if(gs(BOUGHT_TSHIRT) && gs(BOUGHT_SNOWGLOBE)) {
		say('"Sorry," says Maynard, "I\'m sold out."');
		return true;
	}
	
	// allow you to specify one or both objects, or none (just pay for what you've got)
	
	var no_obj = !Token[2] || (Token[2]=='maynard');
	var buying_snowglobe = !gs(BOUGHT_SNOWGLOBE) && (Token[2]=='snowglobe' || Token[3]=='snowglobe' || (no_obj && in_inv(snowglobe)));
	var buying_tshirt = !gs(BOUGHT_TSHIRT) && (Token[2]=='tshirt' || Token[3]=='tshirt' || (no_obj && in_inv(tshirt)));

	if(!buying_snowglobe && !buying_tshirt) {
		say("I don't understand what you want to buy.");
		return true;
	}
	
	var got_snowglobe = false;
	var got_tshirt = true;
	if(buying_snowglobe && spend(1)) {
		say("Okay. You have bought the snowglobe.");
		give_hero(snowglobe);
		sgs(BOUGHT_SNOWGLOBE, 1);
		get_point_for(GOT_SNOWGLOBE);
		got_snowglobe = true;
	}
	if(got_snowglobe && buying_tshirt) { say("\n"); }
	if(buying_tshirt && spend(1)) {
		say("Okay. You have bought the T-shirt.");
		give_hero(tshirt);
		sgs(BOUGHT_TSHIRT, 1);
		got_tshirt = true;
	}
	
	
	return true;
}

pl('temple',
	'Ruined temple',
	"A magnificent limestone cathedral defining the city skyline, Portcullis's magnificent temple \
	of all the gods is what used to be here before Zapdorf had it blown up, outlawing the worship \
	of anything except Zapdorf. Now it's more of a scorchmark on the ground, with a signpost sticking up from the middle.",
	'',
	{
		sign : 'It reads: "Zapdorf Is Great!"',
		scorchmark : 'A circular sooty burn mark about twenty yards in diameter, the typical residue of a \
					necromantic phlogiston bomb. Grass won\'t be growing here any time soon.'
	},
	{},
	{   north : 'market',
		south : 'outside_alchemists',
		west : 'town_square' },
	{
		
	}
);
temple.isTown = true;
temple.isOutdoors = true;

pl('beach',
'Beach',
"A narrow strip of pebbly beach between the western sea and the wall of Zapdorf's castle to the northeast. There is a \
small basement door in the castle wall.",
'',
{
	door: 'An unceremonious door, probably a service entrance rather than one used by noteworthy visitors. It is closed.',
	sea: '[[harbour.sights.sea]]',
},
{
	'knock.door' : '*enter_kitchen()',
	'knock.on.door' : '*enter_kitchen()',
	knock : '*enter_kitchen()',
	northeast: '*enter_kitchen()',
	in: '*enter_kitchen()'
},
{
	east: 'by_drawbridge',
	south: 'harbour',
	in: 'kitchen'
},
{
	northeast: 'in'
},
null);
beach.isOutdoors = true;
function enter_kitchen() {

	if(!gs(MEETING_HAPPENED)) {
		// don't let the player into the castle before the meeting of the Adventurers -
		// can't have you solving all the puzzles without them!
		
		if(Token[1]!='knock') {
			say("You try the door, but it\'s closed and locked.");
		} else {
			say("You knock on the door.");
		}
		say("\nAn exasperated voice comes from within: \"[[ capitalise(chef_swear()) ]], but it is so early! Come back later.\"");
		return;
	}
	
	// after that, chef stops you unless gs(TALKED_TO_MAYOR)
	if(personloc(chef)!=kitchen)
	{
		if(Token[1]=='knock') {
			say ('There is no answer.')
		} else {
			Token[1]='northeast';
			move();
		}
	} else {
	
		say('A portly chef meets you at the door.');
		if(!gs(TALKED_TO_MAYOR)) {
			say(' "No more beggars!" he says, and slams it in your face.');
		} else {

			if(!gs(MET_CHEF)) {
				say(' "So, you are ze new assistant zat ze Mayor sent a scroll about?" ');
				if(gs(DRUNK)) {
					say('He sniffs your breath. "Come back when you\'re sober."');
				} else {
					say('He ushers you inside.\n\n');
					get_point_for(MET_CHEF);
					
					// move the minion to the castle
					set_personloc(minion, castle_stairs_g);
					
				}
			} else {
				say(' "You again!" He ushers you inside.\n\n');
			}
							
			Token[1]='northeast';
			move();
		}
	}
}

/*****************************************************************************
 *
 *                           The Castle
 *
 *****************************************************************************/

/******************************** Basement ***********************************/
 
pl('kitchen',
	'Kitchen',
	'A large, white-tiled basement kitchen with a stone floor. Taking up the \
	entire south wall is a huge cooking stove, covered in sizzling pots and pans, with \
	[[gs(OVEN_OPEN) ? "open" : "closed"]] oven doors. To the east is a walk-in pantry. \
	Stairs lead up to the north.',
	'',
	{
		stair: 'A steep stairway leading up to the ground floor of the castle.',
		pantry: "It's a walk-in pantry. You could always walk in.",
		oven: "A large, sophisticated kitchen range, with several saucepans simmering on top, and a \
			large pair of cast-iron doors, which are [[gs(OVEN_OPEN) ? 'open' : 'closed']].",
		saucepan: "The range is covered in pots and pans of various sizes, bubbling away happily."
	},
	{
		up : '*ascend_kitchen_stairs()',
		north : '*ascend_kitchen_stairs()',
		out : '*leave_castle()',
		southwest : '*leave_castle()',
		'open.oven' : '*open_oven()',
		'close.oven' : '*close_oven()',
		'open.door' : '*open_oven()',
		'close.door' : '*close_oven()',
		'in.oven' : "*enter_oven()",
		'take.in.oven' : '[[ kitchen.special["in.oven"] ]]',
		'up.in.oven' : '[[ kitchen.special["in.oven"] ]]',
		chef : "You're not much of a cook.",
		'take.saucepan' : "[[ personloc(chef)==kitchen ? \"The chef slaps your hand away with a spatula.\" : \"Better leave those alone. You're not much of a cook.\" ]]"
	},
	{ 	east: 'pantry',
		up: 'castle_stairs_g',
		out: 'beach' },
	{ north: 'up',
	  southwest: 'out',
	  in: 'east' },
	null
);
kitchen.isCastle = true;
kitchen.floorNumber = -1;
function leave_castle() {
	say('You leave the castle.\n\n');
	move();
}
function ascend_kitchen_stairs() {
	if(personloc(chef)==kitchen) {
		say('The chef turns and grabs you by the shoulder. "Where do you think you\'re going? You stay down \'ere and assist!"');
	} else {
		move();
	}
}
function open_oven() {
	if(personloc(chef)==kitchen) {
		say('The chef slaps your hand away with a spatula.');
		if(gs(WHAT_CHEF_WANTS)) {
			say(' "Don\'t touch zat! And where is my ' + Thing[gs(WHAT_CHEF_WANTS)].name + '?"');
		}
	} else if(gs(OVEN_PERMASHUT)) {
		say('The oven doors are stuck fast.');
	} else if(gs(OVEN_OPEN)) {
		say('The oven doors are already open.');
	} else {
		say('You open the stove doors to reveal a spacious oven, and are pushed back by a blast of intense heat.');
		sgs(OVEN_OPEN, 1);
		if(!gs(OVEN_EVER_OPENED)) {
			get_point_for(OVEN_EVER_OPENED);
		}
	}
}
function close_oven() {
	if(gs(OVEN_OPEN)) {
		say('You close the oven doors. The room is a little cooler.');
		sgs(OVEN_OPEN, 0);
	} else {
		say('The oven doors are already closed.');
	} 
}
function enter_oven() {
	if(personloc(chef)==kitchen) {
		say('The chef slaps you away with a spatula.');
		if(gs(WHAT_CHEF_WANTS)) {
			say(' "Don\'t touch zat! Where is zat ' + Thing[gs(WHAT_CHEF_WANTS)].name + '?"');
		}
	} else if(gs(OVEN_OPEN)) {
		say('The painful heat makes you think better of that.');
	} else {
		say('The oven doors are closed.');
	}
}

pl('pantry',
	'Pantry',
	'You are in a walk-in pantry lined with shelves.',
	'',
	{},
	{},
	{ west : 'kitchen' },
	{ out : 'west' },
	null
);
pantry.isCastle = true;
pantry.floorNumber = -1;

/******************************** Ground floor ***********************************/

pl('castle_stairs_g',
	'Stairs (ground floor)',
	"You stand on the ground-floor landing of a stairwell that spirals up the side of the castle.",
	'',
	{
		stair: "A steep, narrow spiral staircase of shiny bluish stone."
	},
	{
		south: not_with_kite,
		east: not_with_kite,
		down: not_with_kite,
	},
	{ south: 'entrance_hall',
	  east: 'mess_hall',
	  up: 'castle_stairs_1',
	  down: 'kitchen' },
	{},
	null
);
castle_stairs_g.isCastle = true;
castle_stairs_g.floorNumber = 0;

pl('pyramid_room',
 'Pyramid room',
 'An octagonal chamber with sand-coloured walls emblazoned with hieroglyphics.[[ gs(PYRAMID_OPENED) ? "" : " In the center of the floor \
 is a square-based pyramid made of rough red stone, about six feet high and the same along each edge. \
 Five gemstones are set into one side of it: a diamond, an emerald, a ruby, a sapphire, and an amethyst." ]]',
 '',
 {
	pyramid: '[[ gs(PYRAMID_OPENED) ? "The pyramid is gone. There\'s just a slightly lighter patch on the floor \
				where it used to be." : \
				"A square-based pyramid made of angled terracotta blocks, with five gemstones \
				set into the side nearest to you." ]]',
	gem: "[[ gs(PYRAMID_OPENED) ? 'The gems are gone.' : \
			'Five gems are embedded in the side of the pyramid: a sparkling white diamond, a deep green emerald, \
	a shining red ruby, a glistening blue sapphire and an amethyst in a daring purple.' ]]",
	white: "[[ pyramid_room.sights.gem ]]",
	green: "[[ pyramid_room.sights.gem ]]",
	red: "[[ pyramid_room.sights.gem ]]",
	blue: "[[ pyramid_room.sights.gem ]]",
	purple: "[[ pyramid_room.sights.gem ]]",
	hieroglyphic : '*look_hieroglyphics();',
	wall : '*look_hieroglyphics();',
	
 },
 {
	 push: push_gems,
	 'take.gem': "The gems are all set tightly into the side of the pyramid. They do seem to give way a little when pushed, though.",
	 'take.white' : "[[ pyramid_room.special['take.gem'] ]]",
	 'take.green' : "[[ pyramid_room.special['take.gem'] ]]",
	 'take.red' : "[[ pyramid_room.special['take.gem'] ]]",
	 'take.blue' : "[[ pyramid_room.special['take.gem'] ]]",
	 'take.purple' : "[[ pyramid_room.special['take.gem'] ]]"
 },
 { north: 'mess_hall',
   west: 'entrance_hall' },
 {},
 null
);
pyramid_room.isCastle = true;
pyramid_room.floorNumber = 0;
function push_gems() {
	if('.red.blue.green.white.purple.'.indexOf('.' + Token[2] + '.')==-1) {
		return false;
	}
	
	if(gs(PYRAMID_OPENED)) {
		say('The gemstones have all gone.');
		return true;
	}
	
	// in alphabetical order by gemstone name (diamond,emerald,ruby,sapphire)
	var gem_name = '';
	if(Token[2]=='white') {
		gem_name = 'diamond';
		submit_combination_digit( gs(PYRAMID_KEY).charAt(0) );
	} else if(Token[2]=='green') {
		gem_name = 'emerald';
		submit_combination_digit( gs(PYRAMID_KEY).charAt(1) );
	} else if(Token[2]=='red') {
		gem_name = 'ruby';
		submit_combination_digit( gs(PYRAMID_KEY).charAt(2) );
	} else if(Token[2]=='blue') {
		gem_name = 'sapphire';
		submit_combination_digit( gs(PYRAMID_KEY).charAt(3) );
	} else if(Token[2]=='purple') {
		gem_name = 'amethyst';
		submit_combination_digit( gs(PYRAMID_KEY).charAt(4) );
	} else if(Token[2]=='gem') {
		say("You'll have to be more specific.");
		return true;
	} else {
		say('That achieves nothing.');
		return true;
	}
	
	say('You push the ' + gem_name + '.');
	/*
	 * This was an alternate way to solve this puzzle. It was intended to be an easy and boring alternative,
	 * but it's so easy you'll probably find it by accident before realising the other puzzle is even there.
	 * Then we effectively have only the boring puzzle.
	 *
	var brightness = 0;
	// the brightness clues give an alternative, if dull, way to solve the puzzle.
	if(gs(PYRAMID_CODE_ENTERED).charAt(4) == gs(PYRAMID_COMBINATION).charAt(0)) { brightness = 1; }
	if(gs(PYRAMID_CODE_ENTERED).substring(3,5) == gs(PYRAMID_COMBINATION).substring(0,2)) { brightness = 2; }
	if(gs(PYRAMID_CODE_ENTERED).substring(2,5) == gs(PYRAMID_COMBINATION).substring(0,3)) { brightness = 3; }
	if(gs(PYRAMID_CODE_ENTERED).substring(1,5) == gs(PYRAMID_COMBINATION).substring(0,4)) { brightness = 4; }
	if(gs(PYRAMID_CODE_ENTERED)==gs(PYRAMID_COMBINATION)) { brightness = 5; }
	
	var previous_brightness = parseInt(gs(GEMS_GLOWING), 10);
	
	var gem_lit = ''
	if(previous_brightness==1) gem_lit = ['diamond','emerald','ruby','sapphire','amethyst'][parseInt( gs(PYRAMID_KEY).indexOf( parseInt(gs(PYRAMID_CODE_ENTERED).charAt(3), 10) ) , 10)]
	
	if(brightness==0) {
		if(previous_brightness == 0) {
			say(' Nothing happens.');
		} else {
			say(' The ' + (previous_brightness == 1 ? gem_lit + ' stops' : 'other gems stop') + ' glowing.');
		}
	} else {
		say(' It glows ' + ['', 'faintly', 'brightly', 'brilliantly', 'dazzlingly', 'blindingly'][brightness] + '.');
	}
	
	sgs(GEMS_GLOWING, brightness);

	*/

	if(gs(PYRAMID_CODE_ENTERED)!=gs(PYRAMID_COMBINATION)) { say(" It glows faintly."); }
			
	// allow the player to push multiple gems in the same turn.
	if(gs(PYRAMID_CODE_ENTERED)!=gs(PYRAMID_COMBINATION)) {
		var nextCommand = ['push'];
		for(var i=3; i<=MAX_TOKENS; ++i) {
			if('.red.blue.green.white.purple.'.indexOf('.' + Token[i] + '.')!=-1) {
				nextCommand.push(Token[i]);
			}
		}
		if(nextCommand.length > 1) {
			Token[1] = 'push';
			Token_str = 'push';
			for(var i=1; i<=MAX_TOKENS; ++i) {
				Token[i] = nextCommand[i-1];
				Token_str += '.' + nextCommand[i-1];
			}
			say('\n');
			obey();
			return true;
		}
		return true;
	}
    
    say('\n\nAll five gems glow brilliantly. With a noise like a church organ being demolished, \
    	the triangular walls of the pyramid \
	    retract into the floor to reveal a bandaged mummy lying on its back.\n\
	    The mummy emits a groaning noise, stretches its arms, climbs heavily onto its feet.');
	
	if(personloc(fraf)==pyramid_room) {
		say('\nFraf yells "Mummy!" and runs off to the north. The mummy turns to chase him.');
		set_personloc(fraf, mess_hall);
		sgs(FRAF_BEING_CHASED, 1);
	}
	
	get_point_for(PYRAMID_OPENED);
	set_personloc(mummy, pyramid_room);
	return true;
			
}
function submit_combination_digit(n) {
	
	sgs(PYRAMID_CODE_ENTERED, ('' + gs(PYRAMID_CODE_ENTERED) + n).substring(1));
	
}

function look_hieroglyphics() {
	say('The hieroglyphics read:\n' + hieroglyphics_html() + 'Gripping stuff.');
}
function hieroglyphics_html() {
	var hieroglyphicsHTML = '<div class="hieroglyphics">'
	for(var i=0; i<5; ++i) {
		var thisAnimal = PYRAMID_ANIMALS[ parseInt(gs(PYRAMID_COMBINATION).charAt(i), 10) ];
		hieroglyphicsHTML += '<img class="hieroglyph" src="img/' + thisAnimal + '.png" alt="'+ thisAnimal +'" />';
	}
	hieroglyphicsHTML += '</div>';
	return hieroglyphicsHTML;
}


pl('entrance_hall',
'Entrance hall',
'A rather bare entrance hall with a checkerboard-tiled floor, a very high ceiling, and walls of big dark stone blocks. \
In the south wall is [[ gs(DRAWBRIDGE_OPEN) ? "an open archway, through which you can see the drawbridge lying flat across \
the moat." : "the closed drawbridge, upright against the outside of the archway." ]] Beside the archway is a lever.',
'',
{
	drawbridge: "[[ by_drawbridge.sights['drawbridge'] ]]",
	moat: ' [[ gs(DRAWBRIDGE_OPEN) ? by_drawbridge.sights["moat"] : "You can\'t see the moat from here." ]]',
	lever: "A shiny silver metal lever with a red knob on the end. It is in \
			[[ gs(DRAWBRIDGE_OPEN) ? 'a lowered position' : 'an upright position' ]]."
},
{
	'push.drawbridge' : "Pushing the drawbridge only hurts your hands.",
	'push.lever' : "*close_drawbridge()",
	'pull.lever' : "*open_drawbridge()",
	'open.drawbridge' : "*lit_open_drawbridge()",
	'open.door' : "*lit_open_drawbridge()",
	'close.drawbridge' : "*close_drawbridge()", // allowed for convenience once you've PULLed LEVER at least once
	'close.door' : "close_drawbridge()" // allowed for convenience (once you've opened the drawbridge, you know about the lever anyway)
},
{},
{},
null);
entrance_hall.isCastle = true;
entrance_hall.floorNumber = 0;
entrance_exits_open = { north: 'castle_stairs_g', east: 'pyramid_room', out: 'by_drawbridge' };
entrance_exits_closed = { north: 'castle_stairs_g', east: 'pyramid_room' };
function open_drawbridge() {
	if(gs(DRAWBRIDGE_OPEN)) {
		say('The drawbridge is already open.');
		return;
	}
	
	say('You pull the lever all the way down. With a scraping noise, the drawbridge falls open.');
	sgs(DRAWBRIDGE_OPEN, 1);
	set_drawbridge_exits();
	if(!gs(DRAWBRIDGE_EVER_OPENED)) {
		get_point_for(DRAWBRIDGE_EVER_OPENED);
		say('\n\nAriane the Elf, Fraf the Barbarian, Miranda the Priestess and Staunton the Wizard rush in from outside.\n\
			"Sorcerer\'s castle, type 2B," says Ariane. "Four storeys, plus the battlements. There\'ll be a \
			trap or puzzle of some sort on each. We\'ll all take a floor, then meet at the top for the big showdown. \
			Fraf, you take the ground.\"\n\
			The aventurers nod. Fraf walks east, and the rest head north towards the stairs.\n\
			"Oh, and thank you, child," says Miranda casually as she leaves. "You can go home now."');
		if(thingloc(bananaskin)==castle_stairs_g) {
			say('\n"Yuck, litter," comes the dwindling voice of Ariane from the north.');
		}
		// put everyone else in the puzzle rooms on their respective floors.
		
		
		// Fraf: the mummy
		set_personloc(fraf, pyramid_room);
		
		if(personloc(mummy)==pyramid_room) {
			say('\n\nA moment later there is a cry of "Mummy!" from the northeast.');
			set_personloc(fraf, mess_hall);
			sgs(FRAF_BEING_CHASED, 1);
		}
		
		// Ariane: the elf trap, or the dwarf room if it's disarmed
		if(thingloc(waybread)==elf_trap_room && thingloc(tile)!=elf_trap_room && !gs(TRAP_DISARMED)) {
			set_personloc(ariane, elf_trap_room);
			sgs(ARIANE_IN_TRAP, 1);
			sgs(DWARF_HAS_BOW, 1);
		} else {
			// The trap is disarmed, so Ariane doesn\'t fall for it: she eats the waybread, then gets into a standoff with the dwarf
			set_thingloc(waybread, nowhere);
			set_personloc(ariane, dwarf_room);
		}
		
		// Miranda: the robot
		set_personloc(miranda, laboratory);
		
		// Staunton: the dog
		unsleep(hellhound);
		set_personloc(staunton, dog_room);
		sgs(DOG_HAS_STAUNTON, 1);
	}
}
function standoff_happening() {
	return( personloc(ariane) == personloc(dwarf) );
}
function close_drawbridge() {
	if(!gs(DRAWBRIDGE_OPEN)) {
		say('The drawbridge is already closed.');
		return;
	}
	
	say('You push the lever all the way up. With a scraping noise, the drawbridge rises and shuts.');
	sgs(DRAWBRIDGE_OPEN, 0);
	set_drawbridge_exits();
}
function lit_open_drawbridge() {
	if(gs(DRAWBRIDGE_EVER_OPENED)) {
		open_drawbridge();
	} else {
		say("You'll have to tell me how to do that.");
	}
}


// pl(name,fullname,description,append,sights,special,exits,hExits,daemon)
pl('mess_hall',
'Mess hall',
'An enormous rectangular dining room.',
'',
{},
{},
{ south: 'pyramid_room',
  west: 'castle_stairs_g' },
{},
null);
mess_hall.isCastle = true;
mess_hall.floorNumber = 0;

/********************************** First floor ******************************/

pl('castle_stairs_1',
 'Stairs (first floor)',
 "You stand on the first-floor landing of a stairwell that spirals up the side of the castle.",
 '[[ personloc(dwarf)==elf_trap_room ? (set_personloc(dwarf, dwarf_room), "") : "" ]]', // returns dwarf to her room after elf dies
 {
	 stair: [[ castle_stairs_g.sights['stair'] ]]
 },
 {
	 east: not_with_kite
 },
 { east: 'elf_trap_room',
   up: 'castle_stairs_2',
   down: 'castle_stairs_g'
 },
 {},
 null
);
castle_stairs_1.isCastle = true;

pl('dwarf_room',
 "Smallest room",
 "This is a cramped chamber  fitted with a full range of furniture - comfy chair, workdesk, \
 even a four-poster bed - none of it more than three feet high. The air has the yeasty smell \
 of brewing beer.\
[[ standoff_happening() ? '\\nThere is a tense standoff taking place.' : '' ]]",
 '',
 {
	 table: "Just an ordinary table, apart from the fact that it's about a foot off the ground.",
	 chair: "Just an ordinary chair, apart from the fact that the seat is about six inches off the ground.",
	 bed: "Just an ordinary, bare bed, apart from the fact that it's about six inches off the ground, \
	 with three-foot posts at the corners."
 },
 {
	 give: give_standoff,
	 smell: "Everything in this room smells of brewing beer."
 },
 {
   north: 'elf_trap_room'
 },
 {
	 out: 'north'
 },
 function() {
	 see_dead_dwarf();
 }
);
dwarf_room.isCastle = true;
function see_dead_dwarf() {
	if(heroloc()==dwarf_room && !gs(SEEN_DEAD_DWARF) && gs(DWARF_DEAD) && !gs(STANDOFF_INTERRUPTED)) {
		say('\nThere is a dwarf here, lying prone with an arrow in her back. As you watch, the body \
		     vanishes in a cloud of greasy black smoke.');
		// in this storyline, only get the point when you see the body
		get_point_for(SEEN_DEAD_DWARF);
	}
}
function give_standoff() {
	if(!standoff_happening()) { return false; }
	
	var giveWhat = null;
	var toWhom = null;
	if(is_personname(Token[2]) && is_thingname(Token[3])) {
		giveWhat = eval(Token[3]);
		toWhom = eval(Token[2]);
	} else if(is_personname(Token[3]) && is_thingname(Token[2])) {
		giveWhat = eval(Token[2]);
		toWhom = eval(Token[3]);
	} else {
		say("I'm not sure what you want to show to whom.");
		return;
	}
	
	if(standoff_happening() && ( toWhom==dwarf || toWhom==ariane )) {
		say(capitalise(the_person(toWhom)) + ' takes no notice.');
	} else {
		present(toWhom, giveWhat);
	}
	
}
function standoff_won_by(winner) {
	var loser = (winner == ariane ? dwarf : ariane);
	var hisorher = (winner==ariane ? 'her' : 'him');
	
	say(capitalise(the_person(loser)) + ' turns ' + hisorher + ' head in your direction for a fraction of a second.\n\
	    It\'s long enough. ');
	
	if(winner==ariane) {
		say('Ariane gets her shot off. The arrow pierces the dwarf\'s heart, and her body vanishes in a cloud of greasy \
		black smoke.\n\
		"What are you doing here?" says Ariane. "I had that completely under control. You nearly mucked everything \
		up completely." She stomps off to the north, trying to conceal the wound to her pride.');
		set_personloc(ariane, castle_stairs_1);
		get_point_for(ARIANE_FREE);
		set_personloc(dwarf, nowhere);
		get_point_for(DWARF_DEAD);
		sgs(STANDOFF_INTERRUPTED, 1);
	} else {
		say("The dwarf lets fly with her axe. It whirls across the room and embeds itself between Ariane's eyes. \
		The elf falls backwards, her mouth an 'O' of surprise, and her body vanishes in a shower of pink sparkles.");
		get_point_for(ARIANE_DEAD);
		minion_cackle();
		say("\n\nThe dwarf gives you a quick wink. \"Guess I can take my trap down now,\" she says, and scurries north.");
		set_personloc(ariane, nowhere);
		set_personloc(dwarf, elf_trap_room);
		get_point_for(TRAP_DISARMED);
	}
	
}

pl('elf_trap_room',
 "Elven safety hazard",
 "You are in a plain-looking room with walls painted faint green. [[ gs(TRAP_DISARMED) ? \"\" : \"There's very little \
 to comment on, except maybe for the steel cage hanging by a rope from the ceiling.\"]][[ gs(PLAYER_IN_TRAP) ? \" And, \
 of course, the fact that you\'re stuck in it.\" : \"\" ]]",
 '',
 {
	 'cage': 'A cage of hard steel bars, about two feet by two feet by six feet tall, hanging from the ceiling by a thick rope.',
	 'rope': 'A thick, rough, hemp rope. You can\'t reach it.'
 },
 {
	 'take.waybread': "*take_waybread()",
	 'take.tile': "*take_tile()",
	 'drop.tile': "*drop_tile()",
	 'wear.tile': "*drop_tile()",
	 take : "*take_from_trap_room()",
	 south :'*leave_trap_room()',
	 west : '*leave_trap_room()',
 },
 { south: 'dwarf_room',
   west: 'castle_stairs_1' },
 {},
 function() {
	 if(gs(PLAYER_IN_TRAP)==1) {
		 sgs(PLAYER_IN_TRAP, 2);
	 } else if(gs(PLAYER_IN_TRAP)==2) {
		 set_personloc(dwarf, elf_trap_room);
		 say('\nA threatening little dwarf enters the room. "My elf trap worked!" she says. "Caught you, elf."');
		 sgs(PLAYER_IN_TRAP, 3);
	 } else if(gs(PLAYER_IN_TRAP)==3) {
		 say('\n"Prepare to die, elf," says the dwarf, taking a disproportionately large axe out of her tunic.');
		 sgs(PLAYER_IN_TRAP, 4);
	 } else if(gs(PLAYER_IN_TRAP)==4) {
		 die('\nThe dwarf hurls her axe in your direction. It\'s a well-aimed throw.');
	 }
 }
);
elf_trap_room.isCastle = true;
function leave_trap_room() {
	if(gs(PLAYER_IN_TRAP)) {
		say("You're not going anywhere.");
	} else {
		move();
	}
}
function take_from_trap_room() {
	if(gs(PLAYER_IN_TRAP) && is_thingname(Token[2])) {
		say("You can't reach that from here.");
	} else if(is_thingname(Token[2])) {
		take(eval(Token[2]));
	} else {
		say('Sorry, you can\'t get that.');
	}
}
function drop_tile() {
	if(drop(tile)) {
		if(!gs(TRAP_DISARMED) && !gs(ARIANE_IN_TRAP)) {
			say(' There is a faint clicking noise.');
			
			get_point_for(PUT_TILE_ON_TRAP);
		}
	}
}
function eat_waybread() {
	if(thingloc(tile)==elf_trap_room || gs(TRAP_DISARMED) || gs(ARIANE_IN_TRAP)) {
		// treat normally
		if(!in_inv(waybread)) {
			say("You haven't got the waybread.")
		} else {
			say(waybread.uses['eat']);
		}
	} else {
		spring_trap(waybread);
	}
}
function take_waybread() {
	if(gs(PLAYER_IN_TRAP) && thingloc(waybread)==heroloc()) {
		say("You can't reach that from here.");
	} else if(thingloc(tile)==elf_trap_room || gs(TRAP_DISARMED) || gs(ARIANE_IN_TRAP) || gs(PLAYER_IN_TRAP)) {
		take(waybread); // includes checking if waybread is not here, etc
	} else {
		spring_trap(waybread);
	}
}
function take_tile() {
	if(thingloc(waybread)==elf_trap_room || gs(TRAP_DISARMED) || gs(ARIANE_IN_TRAP)) {
		take(tile);
	} else {
		spring_trap(tile);
	}
}
function spring_trap(bait) {
	say('As your fingers close around the ' + bait.shortname + ', you hear a loud "BOING!" \
	     Immediately, through some ingenious mechanism of springs, screws and balances, you \
	     are hoist upwards, ending up dangling inside the cage. The ' + bait.shortname +
	     ' falls to the floor.');
	if(gs(DWARF_DEAD) || personloc(dwarf)==nowhere) {
		
		if(personloc(ariane)==elf_trap_room || personloc(ariane)==dwarf_room) {
			say("\nAriane [[ personloc(ariane)==dwarf_room ? (set_personloc(ariane, elf_trap_room), 'walks in from the south, ') : '' ]]rolls her eyes, and grudgingly shoots through the rope holding the cage up. \
			       The cage crashes to the floor and shatters into pieces. You land with a bump, but you're okay.");
			get_point_for(TRAP_DISARMED);
		} else {
			die("\nYou shout for help for a while, but unfortunately, the maintainer of the trap \
			       seems to be unavailable.", "You are stuck");
		}
	} else {
		sgs(PLAYER_IN_TRAP, 1);
	}

}


/********************************* Second floor ******************************/

pl('castle_stairs_2',
 'Stairs (second floor)',
 "You stand on the second-floor landing of a stairwell that spirals up the side of the castle.",
 '',
 {	 stair: [[ castle_stairs_g.sights['stair'] ]]
 },
 {},
 { southeast: 'laboratory',
   up: 'castle_stairs_3',
   down: 'castle_stairs_1'
 },
 {},
 null
);
castle_stairs_2.isCastle = true;

pl('laboratory',
 'Laboratory',
 "You are in a large laboratory, taking up almost an entire floor of the castle. Benches line the walls. \
 [[ describe_slab() ]]",
 '',
 { 
   slab : "A marble slab, about eight feet long and four feet wide." },
 {},
 { northwest: 'castle_stairs_2' },
 { out: 'northwest' },
 do_argument
);
laboratory.isCastle = true;
function do_argument() {
	if(argument_happening() && heroloc()==laboratory) {
		var n = parseInt(gs(ARGUMENT_POINTER), 10);
		say('\n');
		if(n > 1 && gs(MIRANDA_HAS_WATER)) {
			miranda_water_splash();
		}
		else if(n < religious_arguments.length) {
			say(religious_arguments[n]);
			sgs(ARGUMENT_POINTER, 1 + n);
		} else {
			say('Miranda and the robot continue their gripping debate on the existence of deities.');
		}
	}
}
function miranda_water_splash() {
	
	say("\"You need a good old-fashioned baptism,\" says Miranda to the robot.\n\
	     She holds aloft the phial of holy water, and pours the contents over the robot's head.\n\
	     There is an acrid smell, a loud CRACK, and a flash of electric blue light. Miranda \
	     stands rigid, with her eyes wide and her skin smoking gently for a few moments, \
	     then crumbles into a pile of fused carbon.\n\
	     \"SHORT CIRCUIT DETECTED. BL-\" says the robot, and explodes in flames.");
	get_point_for(MIRANDA_DEAD);
	get_point_for(ROBOT_DEAD);
	set_personloc(miranda, nowhere);
	set_personloc(robot, nowhere);
	sgs(ARGUMENT_POINTER, religious_arguments.length);
	if(in_inv(kite)) { // actually this shouldn't be able to happen, as the robot has to be online.
		die("\nA white arc zooms up the wire of the kite you are holding. ZOT!", "Shocking");
	}
	
}

function describe_slab() {
	if(gs(ROBOT_ACTIVATED)) {
		say("In the centre is an empty marble slab.");
	} else {
		say('In the centre is a marble slab.');
	}
}

/********************************* Third floor ******************************/

pl('castle_stairs_3',
 'Stairs (third floor)',
 "You stand on the third-floor landing of a stairwell that spirals up the side of the castle.",
 '',
 {	 stair: [[ castle_stairs_g.sights['stair'] ]]
 },
 {
	 east: not_with_kite,
	 south: not_with_kite
 },
 {
	east: 'dog_room',
	south: 'library',
	up: 'battlements',
	down: 'castle_stairs_2'
 },
 {},
 null
);
castle_stairs_3.isCastle = true;
castle_stairs_3.floorNumber = true;

pl('library',
 'Library',
 "This room has an air of sophistication to it: oak panelling, a wingback armchair, \
 and the east wall is taken up by a floor-to-ceiling bookcase and [[ !gs(PAINTING_REMOVED) ? 'a painting' : 'a pair of spyholes' ]].",
 '',
 {
	 bookcase: "*describe_bookcase()",
	 painting: "[[ painting.description ]]",
	 book: read_library_book,
	 chair: "A wingback armchair upholstered in purple velvet.",
	 spyhole: "*describe_spyholes()"
 },
 {
	 'take.painting': take_painting,
	 'remove.painting': take_painting,
	 'pull.painting': take_painting,
	 'drop.painting.wall': put_back_painting,
	 'drop.painting.on.wall': put_back_painting,
	 'drop.painting.on.wall': put_back_painting,
	 'wear.painting.wall': put_back_painting,
	 'drop.painting.back': put_back_painting,
	 'drop.back.painting' : put_back_painting,
	 'hang.painting' : put_back_painting,
	 'hang.up.painting' : put_back_painting,
	 drop: bookshelf_drop,
	 take: bookshelf_take,
	 'pull.book': bookshelf_take,
	 look: bookshelf_look
 },
 { north: 'castle_stairs_3' },
 { out: 'north' },
 find_conspiracy
);
library.isCastle = true;
library.floorNumber = 3;
function take_painting() {
	if(!gs(PAINTING_REMOVED)) {
		say("You take the painting off the wall, revealing a rather obvious pair of spyholes where its subject's eyes were.");
		give_hero(painting);
		sgs(PAINTING_REMOVED, 1);
		get_point_for(PAINTING_EVER_REMOVED);
		return true;
	} else return false;
}
function put_back_painting() {
	if(gs(PAINTING_REMOVED)) {
		say("You hang the painting back on the wall, positioning its subject's eyes over the spyholes.");
		take_away(painting);
		set_thingloc(painting, nowhere);
		sgs(PAINTING_REMOVED, 0);
	} else {
		say("The painting is already on the wall.");
	}
	return true;
}
function describe_spyholes() {
	if(!gs(PAINTING_REMOVED)) {
		say("Looking closely at the eyes the man in the painting, you can see they are hiding a pair of spyholes \
		that go straight through the wall.");
	} else {
		say("A pair of rather obvious spyholes in the wall beside the bookcase.");
	}
	say(" It's too dark to see what's in the space on the other side.");
	return true;
}
function bookshelf_look() {
	if(Thing[gs(THING_IN_BOOKCASE)].name == Token[2]) {
		if(Token[2]=='book') {
			say('You reach for one of the books. ');
			bookshelf_take();
		} else {
			say(Thing[gs(THING_IN_BOOKCASE)].description);
		}
		return true;
	} else return false;
}
function read_library_book() {
	if(gs(THING_IN_BOOKCASE)!=book.id) {
		
		if(in_inv(book) || thingloc(book)==library) {
			say(book.description);
			return true;
		} else {
			describe_bookcase();
			return true;
		}
	}
	
	say('You reach for one of the books. ');
	Token[2] = 'book';
	bookshelf_take();
	return true;
}
function describe_bookcase() {
	say("A full-length bookcase stuffed with books - not dark grimoires as you might expect, \
	    but mainly economics textbooks");
	if(gs(THING_IN_BOOKCASE) && gs(THING_IN_BOOKCASE)!=book.id) {
		say(" (and " + Thing[gs(THING_IN_BOOKCASE)].fullname + ")" );
	}
	say(".");
}
function bookshelf_take() {

	// nasty kludge: "get banana skin" wouldn't work in library
	for(var i=2; i<=MAX_TOKENS - 1; ++i) {
		if(Token[i]=='banana' && Token[i+1]=='bananaskin') {
			Token[i] = 'bananaskin';
			for(var j=i+1; j<MAX_TOKENS; ++j) {
				Token[j]=Token[j+1];
			}
			Token[MAX_TOKENS]='';
		}
	}

	if(is_thingname(Token[2])) {
		var th = eval(Token[2]);
		
		if(th==book && !in_inv(book) && thingloc(book)!=heroloc() && gs(THING_IN_BOOKCASE)!=book.id) {
			say("All the other books seem to be fixed in place.");
			return true;
		}
		
		if(gs(THING_IN_BOOKCASE) == th.id) {
			sgs(THING_IN_BOOKCASE, 0);
			say('As you lift the ' + th.shortname + ', the bookcase revolves, taking you with it!\n\n');
			set_heroloc((heroloc()==library) ? closet : library);
			give_hero(th);
			look();
			return true;
		}
	}

	return false;
}
function find_conspiracy() {
	if(heroloc()==library && personloc(lara)==library && personloc(maynard)==library) {
		
		if(personloc(lara)==library) {
			// walked in on Lara and Maynard

			if(personloc(helmut)==library) {
				// ...and Helmut, in which case you may have saved his life, have a point
				get_point_for(SAVED_HELMUT);
			}
			
			say('\nLara and Maynard look startled. "Er, hi," says Maynard. "We were just, er..."\n\
			    "We\'ve been captured by Zapdorf," puts in Lara. "What an evil sorcerer he is!"\n\
			    "Yes. So we\'d better be back off to our cells," says Maynard.\n\
			    "Which are in a dungeon," Lara adds, "so there\'s no point looking on the roof."\n\
			    The two of them leave quickly, and you hear two sets of footsteps ascending a staircase in a hurry.');
			set_personloc(lara, turret);
			set_personloc(maynard, turret);
			
			sgs(LIBRARY_SCENE, 0);
			sgs(SEEN_CONSPIRACY, 1); // even if you didn't hear the actual conversation
		}
		
	}
}

pl('closet',
'In the closet',
"You are in a small dusty closet with no light except for what comes through a pair of spyholes in \
the western wall. You can just about make out a bookcase beside them.",
'',
{
	spyhole: look_through_spyhole,
	library: look_through_spyhole,
	bookcase: "*describe_bookcase()"
	
},
{ 	look: closet_look,
	talk: closet_talk,
	calcaneus: closet_talk,
    drop: bookshelf_drop,
    wear: bookshelf_drop,
    take: bookshelf_take,
},
{},
{},
do_library_scene);
closet.isCastle = true;
closet.floorNumber = 3;
function closet_talk() {
	
	var peopleInLibrary = [];
	for(var i=1; i<NUM_CHRS; ++i) {
		if(personloc(Person[i])==library) {
			peopleInLibrary.push(Person[i]);
		}
	}
	if(peopleInLibrary.length) {
		var whichperson = pickOne(peopleInLibrary);
		if(whichperson==hellhound) { // exclude people who can't talk!
			say("The hellhound pricks up its ears and looks perplexed.");
		} else {
			say(capitalise(the_person(whichperson)) + ' pauses. ' +
			    pickOne(['"Hello?"', '"Is somebody there?"', '"Who\'s there?"']) + '\n');
			if(Token[1]=='calcaneus' || Token[2]=='calcaneus') {
				summon_minion();
			}
		}
		return true;
	}
	
	return false;
}
function closet_look() {
	
	if(is_thingname(Token[2])) {
		var th = eval(Token[2]);
		if(th==book || th==scroll || th==paper) {
			say("It's too dark to read in here.");
			return true;
		} else {
			return false;
		}
	}
	
	var sight = Token[2];
	
	if(!closet.sights[sight] && library.sights[sight]) {
		say("You peer through the spyholes...\n" + library.sights[sight]);
		return true;
	} else if(is_personname(sight)) {
		if(personloc(eval(sight))==library) {
			say("You peer through the spyholes...\n" + eval(sight).description);
			return true;
		} else return false;
	} else if(is_thingname(sight)) {
		if(thingloc(eval(sight))==library) {
			say("You peer through the spyholes...\n" + eval(sight).description);
			return true;
		} else return false;
	}
	
	return false;
}
function look_through_spyhole() {
	say("Through the spyholes, you have a clear view of the library.\
	[[ !gs(LOOKED_THROUGH_PAINTING) ? (sgs(LOOKED_THROUGH_PAINTING, 1), \
	' You realise you are looking through the eyes of the man in the painting.') : '' ]]");
	for(var i=1; i<=NUM_CHRS; ++i) if(personloc(Person[i])==library) {
		var person = Person[i];
		if(person==helmut) {
			say("\nMayor Helmut slumps in the armchair with his bottle of whisky.");
		} else if(person==maynard) {
			say("\nMaynard, the merchant, paces up and down the room.");
		} else if(person==lara) {
			say("\nLara, the landlady of the Rampart Inn, stands in the doorway.");
		} else {
			say("\n" + capitalise(the_person(person)) + " is in there.");
		}
		
	}
}
function bookshelf_drop() {
	
	// nasty kludge: "Put banana skin on shelf" wouldn't work
	for(var i=2; i<=MAX_TOKENS - 1; ++i) {
		if(Token[i]=='banana' && Token[i+1]=='bananaskin') {
			Token[i] = 'bananaskin';
			for(var j=i+1; j<MAX_TOKENS; ++j) {
				Token[j]=Token[j+1];
			}
			Token[MAX_TOKENS]='';
		}
	}
	
	if((is_thingname(Token[2]) && (Token[3]=='bookcase' || Token[4]=='bookcase')) ||
	   ( (Token[2]=='back' && is_thingname(Token[3])) || (Token[3]=='back' && is_thingname(Token[2]) ) )) {
		var th = is_thingname(Token[2]) ? eval(Token[2]) : eval(Token[3]);
		if(!in_inv(th)) {
			return false;
		} else if(gs(THING_IN_BOOKCASE)) {
			say("There's no room in the bookcase.");
			return true;
		} else {
			say("As you put the " + th.name + " on the shelf, the bookcase revolves, taking you[[ \
			personloc(minion)==closet ? ' and the skeletal minion' : '' ]] with it!\n\n");
			take_away(th);
			sgs(THING_IN_BOOKCASE, th.id);
			if(th != book) {
				get_point_for(BOOKCASE_SOLVED);
			}
			if(personloc(minion)==closet) { set_personloc(minion, library); }
			set_heroloc((heroloc()==library) ? closet : library);
			look();
			return true;
		}
	} else {
		return false;
	}
}

library_hears = ['', // start at 1!
	'You hear the sound of several people entering the library.',
	
	'From the library, you hear the voice of Mayor Helmut: "I tell you, the people aren\'t going to stand for \
     this much longer."\n\
     "You shut up and keep mayoring," comes the voice of Lara.',
	
	'"It\'s immoral," says Helmut weakly. "I mean, yes, it\'s all been a boost for tourism, but putting \
	 people out of work? Undead minions everywhere? And now you want dragons on the streets?"\n\
	 "Our arrangement was simple," says Maynard. "You keep signing what we give you to sign, and we keep \
	 the money and booze flowing. If you\'ve a problem with that, I\'m sure we can find another mayor."',
	 
	 '"Look at it this way, Helmut," says Lara. "When you became mayor, this city was nothing. A coastal \
	 hamlet stinking of fish, mud and failure. Now the adventurer trade brings in thousands of zorkmids a month. \
	 Board and lodging, food and supplies sales, heroism tax. All thanks to a certain evil sorcerer."\n\
	  "But the commoners -" says Helmut.\n\
	  "It trickles down,\" says Maynard.',
	  
	 '"I won\'t do it any longer," says Helmut, his voice quavering.\n\
	 There is a pause.\n\
	 "All right," says Maynard. "You don\'t have to. CALCANEUS!"\n[[ personloc(minion)==heroloc() ? \
	 \'The skeletal minion disappears from the closet and appears in the library.\' : \'You hear a familiar, skeletal "Gruuueeeerrrrghhh!"\' ]]\
	 [[ get_point_for(HEARD_WHOLE_CONVERSATION), set_personloc(minion,library), "" ]]',
	 
	 function() {
		 
		 // fudge: if the minion wandered to castle_stairs_3, put him back
		 if(personloc(minion)==castle_stairs_3) {
			 set_personloc(minion, library);
		 }
		 
		 // but the player might have cleverly saved Helmut by saying calcaneus from the closet
		 // (ooh, skeleton in a closet, there's even a clue, how about that)
		 if(personloc(minion)==library) {
			 
			 say('\n"Minion," says Lara, "This man is an enemy of Overlord Zapdorf."\n\
			 There is a brief wail, followed by the unpleasant sound of a mayor being stabbed with a darkly enchanted spear, \
			 and the \'pop\' of a corpse conveniently vanishing.\
			 [[ set_personloc(helmut, nowhere), set_personloc(minion, library), sgs(LIBRARY_SCENE, 10), "" ]]');
		 } else {
			 say('\n"Minion," says Lara, then looks around in frustration. "Where did that boneheaded skeletal plonker go? \
			      You\'re not getting away with this, Helmut!"\n\
			      She and Maynard storm out of the room.');
			 set_personloc(lara, nowhere);
			 set_personloc(maynard, nowhere);
			 get_point_for(SAVED_HELMUT);
		 }
		 
	 }
];

library_hears_alt = ['', // this is what you hear if you've taken the painting off the wall.
	'You hear the sound of several people entering the library.',

	'From the library, you hear the voice of Lara: "Well, isn\'t that typical? We\'re all set to deliver this \
	expository scene where we don\'t think we\'re being overheard, and some bozo goes and removes the painting \
	to reveal the obvious spyholes."\n\
	"Yeah," comes the voice of Maynard the merchant. "There\'s no way I\'m saying a bunch of incriminating things \
	and exposing our conspiracy in front of those."\n\
	"Whatever," comes the quivering voice of Mayor Helmut.[[ get_point_for(SAVED_HELMUT), sgs(SEEN_CONSPIRACY, 1), "" ]]'
	/*,
	
	'"In fact," says Maynard, "Let\'s have a conversation about how we\'re not having a conspiracy at all."\n\
	 "Yes," says Lara. "And how Zapdorf is totally real and evil and the Mayor here is the one that sold us all out."\n\
	 "Whatever," comes the trembling voice of Mayor Helmut.' */
		
];


function do_library_scene() {
	if(gs(SEEN_CONSPIRACY)) {
		return;
	}
	
	if(heroloc()==closet) {
		
		if(!gs(LIBRARY_SCENE)) {
			sgs(LIBRARY_SCENE, 1);
		}
		
		var sceneNumber = parseInt(gs(LIBRARY_SCENE), 10);

		var dialogue = !gs(PAINTING_REMOVED) ? library_hears : library_hears_alt;
				
		if(sceneNumber==1) {
			set_personloc(lara, library);
			set_personloc(helmut, library);
			set_personloc(maynard, library);
			get_point_for(HEARD_LIBRARY_SCENE);
		}
		
		
		if(sceneNumber < dialogue.length) {
			
			if(typeof dialogue[sceneNumber] == 'function') {
				dialogue[sceneNumber]();
			} else {
				say('\n' + dialogue[sceneNumber]);
			}
			
			sgs(LIBRARY_SCENE, 1 + sceneNumber);
		} else {
			sgs(LIBRARY_SCENE, library_hears.length); // longer of the two conversations; otherwise they get confused
		}
		
		// leave the characters in the library at the end
		return true;
		

	}
}

pl('dog_room',
'In the doghouse',
'This is a warm room with whitewashed walls, patches of gingerish hairs on the floor, and a slight canine odour.',
'',
{},
{},
{ west: castle_stairs_3 },
{ out: 'west' },
null);
dog_room.isCastle = true;
dog_room.floorNumber = 3;




/**************************** Battlements and turret ************************/

pl('battlements',
 'Battlements',
 "You stand in the open air on the castle battlements, at the top of a long spiral staircase. A walkway runs \
 along the front of the castle, giving a commanding view of the city, and there is a steep \
 tiled roof to your north. To the east is a wide cylindrical turret, the door to which is [[ \
 !turret_open() ? 'bolted shut' : 'flapping open in the breeze' ]].",
 '',
 {
	 tile: see_tile,
	 roof: 'A steeply slanted roof tiled with lead plates.[[ gs(GOT_TILE) ? " One tile is missing." : "" ]]',
 	 stair: [[ castle_stairs_g.sights['stair'] ]]

 },
 {
	 'take.tile' : get_tile,
	 'fight.roof' : '*get_tile()',
	 'pull.tile' : '*get_tile()',
	 'knock.tile' : '*get_tile()',
	 'loosen.tile' : '*get_tile()',
	 'break.roof': '*get_tile()',
	 
	 'open.door' : open_turret_door,

	 north: "The roof is too steep to climb.",
	 up: "[[ battlements.special['north'] ]]",
	 east: not_with_kite,
	 east: check_puzzle_count,
	 in: check_puzzle_count
	 
 },
 {
	east: 'turret',
 	down: 'castle_stairs_3',
 },
 {	in: 'east' },
 null
);
function see_tile() {
	if(gs(GOT_TILE) && (in_inv(tile) || thingloc(tile)==battlements)) {
		thingsee(tile);
	} else {
		say(battlements.sights['roof']);
	}
}

function turret_open() {
	
	if(!gs(DRAWBRIDGE_EVER_OPENED)) { return false; }
	return (num_floors_solved() >= 4) && gs(SEEN_CONSPIRACY);
}

function open_turret_door() {
	if(!turret_open()) {
		say("The turret door is locked fast, and there\'s no way to get through it - yet.");
		return true;
	}
	return false;
}

function all_survivors_present() {
	var arianep = gs(ARIANE_DEAD) || personloc(ariane)==battlements;
	var frafp = gs(FRAF_DEAD) || personloc(fraf)==battlements;
	var mirandap = gs(MIRANDA_DEAD) || personloc(miranda)==battlements;
	var stauntonp = gs(STAUNTON_DEAD) || personloc(staunton)==battlements;
	return arianep && frafp && mirandap && stauntonp;
}

function check_puzzle_count() {
	var advsPresent = [];
	[ariane,fraf,miranda,staunton].forEach(function(adventurer) {
		if(personloc(adventurer)==battlements) {
			advsPresent.push(adventurer);
		}
	});
	
	if(!turret_open()) {
		say('The turret door is locked fast.');
		if(advsPresent.length) {
			
			if(num_floors_solved() < 4) {
				say('\n"We\'d better wait for everyone to get here," says ' + capitalise(pickOne(advsPresent).name) + '.');
			} else {
				say('\n"There must be something else that has to happen," says ' +
		    	capitalise(pickOne(advsPresent).name) + '.'); 
	    	}
		}
		return true;
	} else if(!all_survivors_present()) {
		say('\n'  + capitalise(pickOne(advsPresent).name) + ' holds you back. "We\'d better wait for everyone to get here."');
		return true;
	}
	
	var advnames = [];
	advsPresent.forEach(function(adventurer) {
		advnames.push(capitalise(adventurer.name));
	});
	
	if(advnames.length) {
		say(joinWithAnd(advnames) + ' enter the turret with you.\n\n');
	}
	advsPresent.forEach(function(adventurer) {
		set_personloc(adventurer, turret);
	});
	
	return false;
}
battlements.isCastle = true;
battlements.isOutdoors = true;
function get_tile() {
	
	if(thingloc(tile)==battlements) {
		return false;
	}
	
	if(gs(GOT_TILE)) {
		say('All the tiles remaining on the roof are secure.');
	} else {
		say('You give one of the tiles a swift tug, and after putting up a brief fight it comes away in your hand.');
		give_hero(tile);
		get_point_for(GOT_TILE);
	}
	return true;
}


// pl(name,fullname,description,append,sights,special,exits,hExits,daemon)
pl('turret',
'Turret',
"You are in a wide circular turret at the very top of the castle.",
'',
{},
{ out: noone_leaves,
  west: noone_leaves,
},
{	out: 'battlements' },
{	west: 'out' },
function() {
	if(heroloc()==turret) {
		final_scene() // in porspec.js
	}
});
function noone_leaves() {
	say('Maynard stops you. "No-one leaves," he says.');
	return true;
}


// direction of kite trail

battlements.kiteTrail = 'down';
castle_stairs_3.kiteTrail = 'down';
castle_stairs_2.kiteTrail = 'southeast';
castle_stairs_1.kiteTrail = 'up';
castle_stairs_g.kiteTrail = 'up';

function not_with_kite() {
	if(in_inv(kite)) {
		say("The kite's wire snaps tight. You'll need to drop it if you want to go in that direction.");
		return true;
	}
}


