/*
 *
 * Portcullis
 *
 * Persons
 *
 * code and data dealing with people
 *
 */

var Person = new Object;
NUM_CHRS = 0;
function ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,daemon)
{
	Person[++NUM_CHRS] = new Object;
	Person[NUM_CHRS].id = NUM_CHRS;
	Person[NUM_CHRS].name = name; // variable name and recognised word
	Person[NUM_CHRS].fullname = fullname; // name displayed in output
	Person[NUM_CHRS].ishere = ishere; // special string for "Aunt Cedilla is here."
	Person[NUM_CHRS].pname = pname; // true for proper names
	Person[NUM_CHRS].male = male;
	Person[NUM_CHRS].female = female;
	Person[NUM_CHRS].impersonal = (!male && !female);
	Person[NUM_CHRS].firstplace = firstplace; // starting place
	Person[NUM_CHRS].description = description;
	Person[NUM_CHRS].talks = talks; // default talks
	Person[NUM_CHRS].subjects = subjects; // talks about specific tokens
	Person[NUM_CHRS].reactions = reactions; // reactions to 'foo cedilla'
	Person[NUM_CHRS].presents = presents; // reactions to certain Things
	Person[NUM_CHRS].mannerisms = mannerisms; // mannerisms
	Person[NUM_CHRS].sights = sights;
	Person[NUM_CHRS].special = special;
	Person[NUM_CHRS].daemon = daemon; // daemon (run every turn, whether or not hero is here!)
	eval(name + ' = Person[' + NUM_CHRS + '];');
	eval('words(\'' + name.toLowerCase() + '\')');

	Person[NUM_CHRS].is_carrying = {};
	Person[NUM_CHRS].tryToTake = {};
	
	Person.isUndead = false;
}

function default_react(action,person)
{
	var str = '';
	if(action=='fight')
		str = 'You take a swing, but ' + the_person(person) + ' ducks it.'
	else if(action=='kiss')
		str = 'I don\'t think you and ' + the_person(person) +
		  ' are close enough for that.'
	else if(action=='wake' && asleep(person))
		str = capitalise(the_person(person)) + ' won\'t wake up.'
	else if(action=='wake')
		str = capitalise(the_person(person)) + ' isn\'t asleep!';

	if(str=='')
		return(false);

	say(str);
	return(true);
}

function wander_town(person) {
	// make person wander to a neighbouring location, that is both town and outdoors,
	// if their current location is both town and outdoors. They can also leave from the inn (after the meeting).
	
	var fromloc = personloc(person);
	if(fromloc.isTown) {
		
		// don't let adventurers leave the basement during the meeting
		var meetingCountdown = parseInt(gs(MEETING_COUNTDOWN), 10);
		if(meetingCountdown && person != minion && personloc(person)==beer_cellar) {
			return;
		}
		
		// if fromloc has an 'out', that is the ONLY direction they can walk in
		if(fromloc.exits['out']) {
			move_person_direction(person, 'out');
			return;
		}
		
		var okDirections = [];
		
		var dirKeys = Object.keys(fromloc.exits);
		dirKeys.forEach(function(direction) {
			var toloc = eval(fromloc.exits[direction]);
			if(direction != 'in' && toloc.isTown) { // don't let them enter buildings
				okDirections.push(direction);
			}
			
		});
		
		if(okDirections.length) {
			move_person_direction(person, pickOne(okDirections));
		}
		
	};
}

function wander_castle(person) {
	// make the person (the minion) wander around the castle. We'll assume they're already there.
	// n.b. some of this depends on person being the minion, so if I decide other people will wander the castle
	// like this, I need to change it.
	
	
	var fromloc = personloc(person);
	var okDirections = [];
	var dirKeys = Object.keys(fromloc.exits);
	dirKeys.forEach(function(direction) {
		var toloc = eval(fromloc.exits[direction]);
		if(toloc.isCastle && toloc!=turret && toloc!=dog_room) {
			okDirections.push(direction);
		}
	});
	if(okDirections.length) {
		move_person_direction(person, pickOne(okDirections));
	}
	
}

function head_to_battlements(person, hurry) {
	// move a person (a hero after they are freed) toward the battlements.
	// the layout of the castle is such that going north, west or up will always get you there.
	// if hurry is set to true, they go as fast as possible. otherwise, they move about every 3 turns.
	var fromloc = personloc(person);
	
	if(fromloc==battlements || fromloc==turret || fromloc==nowhere) {
		return;
	}
	
	var okDirections = [];
	var dirKeys = Object.keys(fromloc.exits);
	dirKeys.forEach(function(direction) {
		if(/*(direction!='down' && !hurry) || */ direction=='north' || direction=='west' || direction=='northwest' || direction=='up') {
			okDirections.push(direction);
		}
	});
	if(okDirections.length) {
		if(hurry || !pick(3)) {
			move_person_direction(person, pickOne(okDirections));
		}
	}
}


/*
 * The skeletal minion
 * This is the 'hint' character, so try to give it something to say about all the puzzles.
 */
ch('minion',
'skeletal minion',
'A skeletal minion[[ gs(ONE_LEGGED_MINION) ? " with a pegleg" : "" ]] stands here, wielding a long spear.',
false,
false,
false,
outside_hut,
'[[ draw_npc_image(\'minion\', 100,210) ]]An animate skeleton, six and a half feet high and dressed in \
rusty metal armour. This is the face, or at least the skull, of community policing \
under Zapdorf\'s regime. Its eye sockets glow a hellish red. The \
minion carries a long spear, and periodically makes the effort to brandish it \
menacingly at passersby.[[ gs(ONE_LEGGED_MINION) ? " It has a peg leg." : "" ]] \
Its overall bearing is imposing, malevolent and, it has to be said, pretty damn stylish.',
[ '\"Move along, mortal scum!\" says the skeletal minion amiably.',
  'The skeletal minion stares at you with bright crimson eyes. You forgot what you were going to say.',
  '=Gruuuueerrggghhghhh!!' ],
{
	themself : '=I was created by Zapdorf to keep order in this town.',
	zapdorf : 'The skeletal minion stands to attention. \"All hail our diabolical overlord!\"',
	adventurer: "=Professional adventurers? Hah, bring 'em on! They're no match for Overlord Zapdorf.",
	ariane: '=Elves think they\'re so much better than everyone. But they puncture like everyone else.',
	elves: '=Elves think they\'re so much better than everyone. But they puncture like everyone else.',
	fraf: "=He's strong, but he's clumsy. He won't be able to give the Overlord the slip.",
	miranda: '=The church has never been a great supporter of rights for the differently alive.',
	staunton: '=Wizards? Bah! Posturing pointy-hatted prats, the lot of them.',
	
	mummy: "=Effective buggers, mummies, even if they're not the most graceful.",
	hellhound: 'The skeletal minion looks annoyed. "Have you any idea how annoying dogs are to a person made entirely of bones?"',
	robot: '=One of the Overlord\'s creations. The ultimate logical mind in a non-watertight electrical body!',
	dwarf: 'The skeletal minion shrugs. "What is there to know about dwarves? Short, hate elves, love gold."',
	
	helmut: "=Such a shame to see a man drinking alone.",
	chef: "=He's nice enough, as long as you obey him. But have you tried disobeying him?",

	alchemist: "=I don't trust alchemy. If they turn all the lead into gold, what'll we make roof tiles out of?",
	gold: "=I haven't got any use for gold. If you need it, maybe you could get someone to make some?",
		
	lara: "=I've seen her around the castle sometimes. Nice lady.",
	maynard: "=I've seen him around the castle sometimes. Nice bloke.",
	
	drawbridge: "=It can only be opened from inside.",
	
	oven: "=Nice and big, isn't it? Perfect for when the Overlord hosts one of his humanitarian dinners.",
	pyramid: "=There's probably a grotesque solution.",
	hieroglyphic: "=There's probably a grotesque solution.",
	gargoyle: "=The Overlord had them removed from an ancient pyramid and imported here."

},
{
	fight : '*die(\"Your attack clangs off the skeletal minion\'s armour, but the creature is too fast, \
	                strong, and malignantly enchanted for you. Its eyes glow orange as it rounds on you, \
	                screeches, and thrusts its spear.\");',
	kiss : 'It isn\'t interested. And even if it was, it doesn\'t have any lips.'
},
{
	drink : "=Undead minions don't drink! We live off nefarious cosmic sorcery and occasional calcium supplements.",
	money : "=Loyal minions of Zapdorf cannot be bribed or corrupted!\" The skeletal minion contemplates this for a moment. \"We're already evil, so there's really no point.",
	paper : 'The skeletal minion reads the paper and furrows its brow, or would do if it had one. "This had better not \
			be about some subversive resistance meeting," he says, handing the paper back to you.',
	helmet: '=The skeletal minion backs away from the helmet. He seems to be frightened.'
	
},
['The skeletal minion rattles its spear.',
'The skeletal minion gnashes its teeth.',
'The skeletal minion\'s eyes glow bright purple for a moment.',
'The skeletal minion drums its fingerbones on the shaft of its spear.',
'The skeletal minion grunts.',
'The skeletal minion rotates its skull 360 degrees.'],
{
	spear : "A ten-foot spear with a rusty point, which you probably don't want to be stabbed with." 
},
{},
null
);
minion.isUndead = true;
function minion_cackle() {
	
	var n = num_adventurers_dead();
	
	if(personloc(minion) != heroloc()) { say('\n\nThe skeletal minion appears in a cloud of blue dust.'); }
	else { say('\nThe skeletal minion waves its spear triumphantly.'); }
	if(n==4) {
		say('\n"All down!" it cackles.');
		// something special happens.
		set_personloc(minion, heroloc());
	} else {
		say('\n"' + capitalise(numberToWords(n)) + ' down, ' + numberToWords(4 - n) + ' to go!" it cackles');
		if(heroloc().isCastle || personloc(minion)==heroloc()) {
			say(".");
			set_personloc(minion, heroloc());
		} else {
			say(", and disappears.");
		}
	}	
}
function summon_minion() {
	if(personloc(minion)==heroloc()) {
		say("The skeletal minion rattles its spear.");
	} else {
		get_point_for(SUMMONED_MINION);
		if(heroloc()==closet && personloc(minion)==library) {
			say("The skeletal minion disappears from the library and appears beside you in the closet.");
		} else {
			say("A skeletal minion appears in a cloud of blue dust.");
		}
		set_personloc(minion, heroloc());
	}
}

/*****************************************************************************
 *
 *                                 The Townsfolk
 *
 *****************************************************************************/

/*
 * The Skipper
 */
ch('skipper',
'Skipper',
'The Skipper stands here, looking rather unhappy.',
false,
true,
false,
harbour,
"[[ draw_npc_image(\'skipper\', 76,205) ]]The Skipper is a serious man, with dark hair and bristles on his hard face. \
He's wearing warm canvas clothing, a little circular hat, and a frown. He is - or, until recently, was - your boss, but he\'s \
a friend for all that.",
[
	"=Rotten news about the boat. I don't know how I'm going to pay my taxes this winter.",
	"=I guess we'll all have to find new jobs. I did hear the castle is hiring a kitchen porter, if you can get a foot in the door.",
	"=I miss my boat. She was a nice boat. I feel queasy when I'm on land for too long."
],
{
	zapdorf: "=He's put me out of a job. I wouldn't normally say this, but\" - the Skipper lowers \
				his voice - \"maybe he needs to be got rid of.",
	boat: "=She was a fine boat. I miss her. I feel queasy when I'm on land for too long.",
	himself: "=I've been a sailor since I could crawl into a dinghy. I don't know what I'll do now.",
	adventurer: "=There's a bunch of 'em in town. Professional adventurers, here to kill Zapdorf.\" The Skipper spits. \
				\"Hope one of 'em manages it.",
	minion: "=Rotting swine, the lot of 'em. They took our jobs!",
	zombie : "[[skipper.subjects.minion]]"
},
{
	fight : 'The Skipper ducks your attack. "Oi! I know this is a difficult time, but don\'t take it out on me."'
},
{
	money: "=You keep it. You'll need it.",
	paper: 'The Skipper looks at the paper and contemplates it. "Some sort of meeting? If it was me, I\'d go and check it out."'
},
[
	"The Skipper looks mournfully out to sea.",
	"The Skipper gives you a sympathetic glance.",
	"The Skipper picks up a small rock and skips it out over the water."
],
{},
{},
function() {
	if(personloc(skipper)==heroloc() && !gs(TOLD_ABOUT_JOB)) {
		say('\n\nThe Skipper sees you approaching, and walks out to meet you.\n\
			"Bad news," he says. "Zapdorf gave all the fishing contracts to his undead minions. \
			Looks like we\'re all out of a job."\n\
			Sure enough, a crew of rotting zombies arrives, shambles down the jetty, boards and unmoors the boat, and sails \
			it out to sea at surprising speed. The Skipper glowers after them. "Mouldy bastards," he comments.');
			
		get_point_for(TOLD_ABOUT_JOB);
		sgs(BOAT_GONE, 1);
	}
});
['ariane','fraf','miranda','staunton'].forEach(function(adventurer) { skipper.subjects[adventurer] = skipper.subjects['adventurer']; })


/*
 * Mayor Helmut
 */
ch('helmut',
'Mayor Helmut',
'Mayor Helmut [[ personloc(helmut)==library ? "slumps in the armchair" : "stands here" ]], holding a bottle of whisky.',
true,
true,
false,
mayors_office,
'[[ draw_npc_image(\'helmut\', 68,190) ]]Widely despised since surrendering the city to Zapdorf, Mayor Helmut is a wiry middle-aged \
man with a worried face. A shabby fur robe hangs over his pointy shoulders, and the sash of state \
falls across his chest at a skew-whiff angle. He is holding a half-empty bottle of sickly-smelling whisky \
in his shaking hands.',
[ '"I\'m busy," says Mayor Helmut, and takes a swig from the whisky bottle.',
  '=Leave me alone," Mayor Helmut says, almost sobbing. "Can\'t you see I\'ve got work to do?',
  'The mayor mumbles incoherently about how something had to be done, and nobody understands his position.' ],
{	zapdorf : function() {
		if(!gs(SEEN_CONSPIRACY)) {
			say('Mayor Helmut looks like he\'s about to cry. "What else could I do? If I hadn\'t surrendered, \
			   Zapdorf would have flattened the town. Now I have no friends."');
		} else {
			say('Mayor Helmut looks ashamed. "There is no Zapdorf," he says sulkily. "Just Lara, Maynard, and a \
			     few amateur spells. They said having an evil sorcerer would put the town on the map again."');
		}
		return true;
	},
	surrender : '[[ helmut.subjects.zapdorf ]]',
	adventurer: "=They come and go, and mainly die. Maybe one of them will get rid of Zapdorf one day.",
	themself : '"I was born to a noble family. I was educated by the finest scholars in the kingdom. And now \
				look at me. Puppet to [[ gs(SEEN_CONSPIRACY) ? "a couple of plutocrats" : "an evil sorcerer" ]]!" \
				Mayor Helmut swigs his whisky shamefully.',
	whisky : '"It\'s good stuff!" Mayor Helmut gives you a sniff of the whisky, which almost knocks you out.',
	job : function() {
		if(!gs(MET_CHEF)) {
			say("\"There's a job going in the castle kitchen, but I don't know, \
			   I was planning to give it to one of my drinking buddies.\"");
		} else {
			say('"Hope it\'s working out."');
		}
		return true;
	},
	lara : "[[ mayor_talk_lara_maynard() ]]",
	maynard: "[[ mayor_talk_lara_maynard() ]]"
},
{
	talk : talk_mayor,
	fight : 'He\'s so pathetic, you can\'t bring yourself to hit him.'
},
{
	drink : talk_mayor
},
['Mayor Helmut takes a gulp of whisky.',
 'Mayor Helmut sings a mournful, tuneless song to himself.',
 'Mayor Helmut [[ personloc(helmut)==library ? "nearly falls off the chair, but" : "stumbles and" ]] catches himself.'],
{
	whisky : "A square glass bottle containing an ever-diminishing supply of cheap whisky."
},
{
	'take.whisky' : 'Something tells you Mayor Helmut isn\'t going to part with the whisky bottle for anything.',
	'take.helmut.whisky' : '[[ helmut.special["take.whisky"] ]]',
	'take.helmut.south.whisky' : '[[ helmut.special["take.whisky"] ]]',
	drink : '*talk_mayor()'
},
null
);
function mayor_talk_lara_maynard() {
	if(gs(SEEN_CONSPIRACY)) {
		say('"Lara and Maynard control this town. They\'re the money! They made me do it."');
	} else {
		say(pickOne(helmut.talks));
	}
}
function talk_mayor() {
	if(Token[1]=='drink') {
		if(in_inv(drink)) {
			drink_beer();
			say('\n');
		} else {
			say("I don\'t understand what you want to drink.");
			return true;
		}
	}
	
	
	
	if(gs(DRUNK) && !in_inv(drink)) {
		say('"You seem sociable," says Mayor Helmut. "Why not get a pint and we\'ll have a drink together?"');
	} else if(!((gs(DRUNK)||Token[1]=='drink') && in_inv(drink))) {
		talk_to(helmut);
	} else {
		if(!gs(TALKED_TO_MAYOR)) {
			say('Mayor Helmut recognises a fellow drunkard. "You look like someone who can understand," he says. \
			The two of you spend a pleasant, although rather slurred, half-hour solving the world\'s problems while \
			you finish off your pint.\n\
			"Here," says Mayor Helmut, "I heard about your boat. That\'s too bad. If you need a new job - try at the \
			castle. They\'re looking for a kitchen assistant. I\'ll put the good word in for you."');
			
			take_away(drink);
			get_point_for(EVER_DRUNK);
			get_point_for(TALKED_TO_MAYOR);
			sgs(DRUNK, 5);
		} else {
			say('You and Mayor Helmut sing a drinking song together.');
		}
	}
}
			


/*
 * Lara, landlady at the inn
 */
ch('lara',
'Lara',
'Lara, the innkeeper, stands [[personloc(lara) == inn ? "behind the bar" : "here" ]].',
true,
false,
true,
inn,
'[[ draw_npc_image(\'lara\', 100, 194) ]]Lara, landlady of the Rampart Inn, is a pleasant middle-aged woman with a \
kind red face and a cotton dress. Being the proprietor of the town\'s inn makes \
her de facto social worker, counsellor and confessor to its residents.',
[ '[[ lara_talks() ]]' ],
{
	zapdorf : "=Can't say as I agree with him. But business from the professional adventurers has been good.",
	adventurer : "=Professional adventurers are always coming through wanting to defeat Zapdorf. They all fail, \
				of course, but they're nice enough people. Heavy drinkers, too."
},
{
	fight : 'Lara, used to this sort of thing from her customers, produces a plank of wood from \
			[[ heroloc() == inn ? "behind the bar" : "somewhere" ]] and clocks you across the head. Oof!',
	kiss : 'Lara fends you off. "Maybe I shouldn\'t be selling you any more booze."'
},
{
	money : '*buy_drink()',
	paper : '*give_lara_paper()'		
},
[
	'[[ lara_mannerisms() ]]'
],
{},
{},
null
);
['staunton','fraf','ariane','miranda'].forEach(function(adventurer) { lara.subjects[adventurer] = lara.subjects['adventurer']; });
function lara_talks() {
	if(personloc(lara)==inn) {
		say(pickOne(['Lara starts talking about real ale. You switch off.',
			'=What\'ll it be?',
			'=I\'ve got some nice ale brewed up, if you\'re thirsty.']));
	} else {
		say('"We\'re doing the talking," says Lara.');
	}
}
function lara_mannerisms() {
	if(personloc(lara)==inn) {
		say(pickOne(['Lara wipes the bar with a dustcloth.',
		'Lara inspects the beer pumps.']));
	} else {
		say(pickOne(['Lara smiles to herself.',
			'Lara gives you a contemptuous look.']));
	}
}
function give_lara_paper() {
	say('Lara takes the paper, looks at it, then looks at you, then looks at the paper again. \
		"Hmm," she says, "I thought this was just for professional adventurers. Well, \
		not a word to the minions, all right?"\n\
		She opens a previously invisible trap door in the floor. A ladder leads down. "The others\'ll be along in a minute," \
		she adds.');
	take_away(paper);
	get_point_for(BEER_CELLAR_OPEN);
	set_inn_exits();
}
function meeting_starts_from_pub() {
	
}


/*
 * The alchemist
 */
 // ch(name,fullname,ishere,pname,impersonal,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,daemon)
ch('alchemist',
'alchemist',
'The alchemist herself stands peering over the edge of the vat.',
false,
false,
true,
alchemists_shack,
'[[ draw_npc_image(\'alchemist\', 100, 185) ]]A scrawny woman with waist-length white hair that flows over a loose cloth robe, stained and burned in places by \
interesting chemicals. She is staring at the vat with intense focus, and reciting a scientific formula under her breath.',
[   "=...[[ alchemist_formula_term() ]], [[ alchemist_formula_term() ]], [[alchemist_formula_term() ]]..."
],
{
	blackboard: 'The alchemist nods at the blackboard. "That\'s my formula," says the alchemist proudly. "Now, if only I could find some Pb..."',
	
	lead: '"Lead, alchemical symbol Pb," says the alchemist, rattling it off as if she\'s reading from a textbook. \
	       "Base element. Applications: printing, roofing, plumbing. Favourite food of the lead-munching pangolin."',
	gold: '"Gold, alchemical symbol Au," says the alchemist, rattling it off as if she\'s reading from a textbook. \
	       "Noble element. Applications: currency, jewellery, bribery. \
	        Prized by diminutive peoples for its high concentrations of shiny."',
	vat: "=Just an experiment I'm working on.",	
	zapdorf: "=The sorcerer? I leave him alone, he leaves me alone, we don't blow each other up. Suits us both."
},
{
	fight: '*fight_alchemist();'
},
{},
[ 'The alchemist sprinkles some [[ pickOne(["red", "blue", "yellow", "green", "purple", "orange"]) ]] powder into the vat.',
  'The alchemist takes a metal spoon from her robes and gives the vat a stir. The spoon dissolves.',
  'The alchemist dips her finger in the vat, licks it, and makes a sour face.'
],
{},
{},
null);
function alchemist_formula_term() {
	return pickOne(['plus', 'minus', 'times', 'over', 'divided by', 'multiplied by', 'added to', 'subtracted from', 'to the power of']) +
	       ' the ' + pickOne(['', 'square of the ', 'square root of the ', 'cube of the ', 'cube root of the ', 
	       (4 + pick(6)) + 'th power of the ', (4 + pick(6)) + 'th root of the ']) +
	       pickOne(['corpuscle', 'phlogiston', 'aetheric', 'cryonic', 'temperature', 'viscosity', 'transcendental',
	                'luminescence', 'explosive', 'incendiary', 'transmutation', 'hermetic', 'spagyrical']) +
	       ' ' + pickOne(['modulus', 'coefficient', 'factor', 'term', 'corollary', 'determinant', 'gradient']);

}
function fight_alchemist() {
	die('The alchemist dodges your attack, grapples you, and pushes you back-first into the vat.', 'You have dissolved');
}
alchemist.receive = function(thing) {
	if(thing != tile) {
		say('The alchemist looks at the ' + thing.name + '. "That is useless to science!" she sneers.');
	} else if(gs(TILE_GOLD)) {
		say('The alchemist looks proudly at the gold tile. "Amazing, isn\'t it?"');
	} else {
		say('The alchemist takes a pair of tongs from her robe, grabs the tile and dips it in the vat. There is a low \
		     fizzing noise, and a moment later she retrieves the tile - which has turned to gold. "It works!" she cries jubilantly, \
		     chips a corner off the tile as payment, and hands the rest back to you.');
		
		get_point_for(TILE_GOLD);
	}
	return true;
}



//ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,daemon)
/*
 * Maynard, the merchant
 */
ch('maynard',
'Maynard',
"Maynard, the merchant, stands here[[ personloc(maynard)==market ? ' hawking his wares' : '' ]].",
true,
true,
false,
market,
'[[ draw_npc_image(\'maynard\', 133,195) ]]Maynard is a stocky fellow in a colourful robe[[ personloc(maynard)==market ? ", standing by his market stall espousing \
the desirability and usefulness of his shonky goods" : "" ]]. He has friendly eyes and a little goatee.',
[ "[[ maynard_talks() ]]" ],
{
	zapdorf: "=Trade's been booming since we got an evil sorcerer. Can't believe we didn't think of it before.",
	
	tshirt: '=[[ !gs(BOUGHT_TSHIRT) ? "Stylish apparel, only one zorkmid." : "No refunds." ]]',
	snowglobe: '=[[ !gs(BOUGHT_SNOWGLOBE) ? "Beautiful snowglobe, handcrafted by arctic gnomes, one zorkmid." : "No refunds." ]]'
},
{
	pay: pay_maynard
},
{
	money: pay_maynard
},
[ '[[ maynard_mannerisms() ]]'
],
{},
{},
null);
function maynard_talks() {
	var maynardloc=personloc(maynard);
	if(maynardloc==market) {
		say(pickOne(["=Souvenirs! Top quality merchandise!",
			"=Get your sorcerer-overthrowing paraphernalia here, it's luvverly!",
			"=Soooooouuuuuveniiiiirs! Take home a piece of necromantic tyranny!"]));
	} else {
		say('"Shut up," says Maynard.');
	}
}
function maynard_mannerisms() {
	var maynardloc = personloc(maynard);
	if(maynardloc==market) {
		say(pickOne([
			'Maynard shouts, "Souveniiiiiiirs!"',
			'Maynard yells, "T-shirts! Snowglobes!"',
			'Maynard bellows, "Step right up, ladies and gents, fine goods for sale!"'
			])); }
	else {
		say(pickOne([
			"Maynard chuckles to himself.",
			"Maynard strokes his goatee."
		]));
	}
}

function pay_maynard() {
	if(personloc(maynard)==market) {
		buy_from_market();
		return true;
	}
	return false;
}

/*****************************************************************************
 *
 *                                 The Adventurers
 *
 *****************************************************************************/

/*
 * Ariane the Elf
 */
ch('ariane',
'Ariane the Elf',
'[[ ariane_ishere() ]]',
true,
false,
true,
outside_inn,
'[[ draw_npc_image(\'ariane\' + (gs(ARIANE_IN_TRAP) ? \'_upsidedown\' : \'\'), 76,209) ]]The elf-woman Ariane, renowned adventurer, friend of nature. \
She wears a green jumpsuit of some environmentally friendly natural fabric[[ gs(ARIANE_IN_TRAP) ? "" : ", and carries \
a bow and a quiver of arrows" ]]. Her face is dark, with large brown eyes and an expression \
of serene superiority, pointy ears protruding through matted silver locks. The whole effect is rather hippyish.\
[[ gs(ARIANE_IN_TRAP) ? " She\'s currently suspended upside-down in a cage, and not too happy about it." : "" ]]',
[ "Ariane just smiles enigmatically.",
  "=You humans have a lot of questions, don't you?",
  '\"Maybe you\'d know more about that if you listened to nature,\" says Ariane condescendingly.' ],
{
	themself : '=I grew up as a hawthorn-princess in Elfland, and I\'m visiting the human world for my gap century. \
				Wanted to see some of you quaint little brutes up close. I pay my way by adventuring.',
	zapdorf : "=Take over a city, terrorise the locals with undead minions, strip the area \
			   of natural resources, move on. Typical human machismo. I'm here to put an end to that.",
	staunton : "=I did the Quest of the Turqoise Rings with him last year. He's a bit pompous, but he knows his stuff.",
	fraf : "=That brainless human meathead? Can\'t stand him.",
	miranda : "=The priestess and I don't see eye to eye on organised religion.",
//	twig : "=I'm nimbler than him, of course, but his lockpicking skills and total lack of ethics are useful sometimes.",
	elves : "=My people come from far across the sea. We're strong, nimble, intelligent, and terribly modest.",
	human : "=My people have an ancient riddle about humans. How many humans does it take to change a candle? None,\" she smirks, \
			\"because they're unenlightened and selfish and have no connection with nature.",
	waybread: '[[ ariane_talk_waybread() ]]',
	dwarf : "=Ugh. I'm an open-minded progressive woman with no prejudices against other species, of course, but I \
	          just can't stand the hairy little sods.",
	cage: "=Who sets traps for elves? Seriously, who does that?",
	bow: "=I had a team of trained pixies carve it from the wood of a runeyew tree back in Elfland.",
},
{
	fight : fight_ariane,
	kiss : kiss_ariane,
	talk : talk_ariane,
	give : give_ariane
},
{
	drink : "=That synthetic mainstream fizzy-pop? No way. Back in Elfland we brew organic wine from nettles and \
			self-satisfaction.",
	money : 'Ariane turns her nose up. "You humans, so obsessed with material wealth. Spiritually empty, the lot of you."',
	paper : '=Oh, who invited you?" Ariane scowls. "Actually, come along anyway. We might have a use for a local peasant.',
	waybread: '[[ ariane_eats_waybread() ]]',
	helmet: function() {
		give_helmet_to(ariane)
	}
},
[
	"[[ ariane_mannerisms() ]]"
],
{
	bow : '[[ gs(ARIANE_IN_TRAP) ? bow.description : (thingsee(bow), "") ]]'
},
{
	'take.bow' : '*take_arianes_bow()'
},
null
);
ariane.is_carrying = {};
ariane.is_carrying['bow'] = ' '; // displaying the bow is handled in her description
function ariane_mannerisms() {
	if(gs(ARIANE_IN_TRAP)) {
		say(pickOne(["Ariane rattles the bars of the cage.",
		             'Ariane wails, "It was a trap! I just wanted the delicious waybread!"',
		             'Ariane makes an unsuccessful attempt to squeeze between the bars of the cage.']));
	} else if(standoff_happening()) {
		say('Ariane adjusts her arrow slightly.')
	} else {
		say(pickOne([
			'Ariane tosses her hair out of her eyes.',
			'Ariane takes an arrow from her quiver and sharpens the end thoughtfully.',
			'Ariane practises a few elvish martial arts moves.',
			'Ariane hums a strange, modal elvish tune.',
			'Ariane touches the points of her ears.',
			'Ariane twirls on the spot.',
			'Ariane restrings her bow.',
			'Ariane hops from one foot to the other.',
			'Ariane laughs eerily.'
		]));
	}
}
function give_ariane() {
	
	if(!is_thingname(Token[2]) && !is_thingname(Token[3])) {
		say("I'm not sure what you want to give to Ariane.");
		return;
	}
	
	var th = eval(Token[is_thingname(Token[2])?2:3]);
	
	if(gs(ARIANE_IN_TRAP)) {
		say("Ariane is stuck in a cage, and you can't reach her.");
		return;
	}
	
	if(standoff_happening()) {
		standoff_won_by(dwarf);
		return;
	}
	
	present(ariane, th);
}
function take_arianes_bow() {
	if(!gs(ARIANE_IN_TRAP)) {
		say('Ariane laughs. "Not until you pry my cold dead fingers off the riser."');
	} else {
		take(bow);
	}
}
function fight_ariane() {
	if(gs(ARIANE_IN_TRAP)) {
		say("You can't reach Ariane from here.");
		if(in_inv(bow)) {
			say(" (But if you're feeling particularly violent, perhaps you could shoot her.)");
		}
	} else {
		say('You\'ve barely moved before Ariane has a notched arrow at your throat. \
			"Weren\'t planning on attacking me, were you?" she asks sweetly[[ \
			standoff_happening() ? ", before turning her attention - and her bow - back to the dwarf" : "" ]].');
	}
}
function kiss_ariane() {
	if(standoff_happening() || gs(ARIANE_IN_TRAP)) {
		say('Trust me, this is a really, really bad time to make your move.');
	} else {
		say('Ariane pulls away, scoffing. "I\'m so many thousands of miles out of your league, JRR Tolkien could write \
		     an epic fantasy novel about the journey, human."');
	}
}
function ariane_ishere() {
	say('Ariane the Elf ');
	if(gs(ARIANE_IN_TRAP)) {
		
		say('is suspended inside the cage, looking somewhat put out.');
		
	} else {
	
		if(personloc(ariane) == beer_cellar) {
			say('sits ');
		} else {
			say('stands ');
		}
		if(standoff_happening()) {
			say('with her bow drawn and an arrow notched, pointing straight at the dwarf\'s heart.');
		} else {
			say('nonchalantly by.');
		}
	}
}
function talk_ariane() {
	if(gs(ARIANE_IN_TRAP)) {
		say(pickOne(["=It was a trap!", "=Get me down!", "=Never mind that, get me out of here!", "=Get me out of this cage!"]));
	} else if(standoff_happening()) {
		standoff_won_by(dwarf);
	} else {
		talk_to(ariane);
	}
}
function ariane_talk_waybread() {
	// actually this doesn't work, because all TALK TO ARIANEs are overridden by gs(ARIANE_IN_TRAP) already.
	if(gs(ARIANE_IN_TRAP)) {
		say('"It\'s my favourite food," wails Ariane, "but it was the bait for a trap! Who sets elf traps? Who DOES that?"');
	} else {
		say('Ariane\'s eyes light up. "Waybread is so totally my fave! Of course, you can\'t get decent quality stuff over here."');
	}
}
function ariane_eats_waybread() {
	if(!gs(ARIANE_IN_TRAP)) {
		say('Ariane snatches the waybread and noshes it daintily. "Superb!"');
		take_away(waybread);
		inc_score(); // get_point_for(treated_ariane);
	} else {
		say("Ariane can\'t reach the waybread from the cage.");
	}
}
function ariane_killed_in_trap() {
	set_personloc(ariane, nowhere);
	sgs(ARIANE_IN_TRAP, 0);
	get_point_for(ARIANE_DEAD);
	minion_cackle();
	if(personloc(dwarf)==dwarf_room) {
		say("\nA dwarf briefly pokes her head out of the south door and gives you a quick wink.");
	} else if(personloc(dwarf)==elf_trap_room) { // I don't think this ever happens
		move_person(dwarf, dwarf_room, "\nThe dwarf gives you a quick wink and scurries south.", "\nThe dwarf scurries in from the north.");
	}
}


/*
 * Fraf the Barbarian
 */
ch('fraf',
'Fraf the Barbarian',
'Fraf the Barbarian, a huge fighting man, [[ gs(FRAF_BEING_CHASED) ? "is running through the room" : (personloc(fraf)==pyramid_room ? "is staring at the pyramid, deep in attempted thought" : "looms over you")]][[ personloc(fraf)==beer_cellar ? " (even while sitting down)" : "" ]].',
true,
true,
false,
by_drawbridge,
"[[ draw_npc_image(\'fraf\', 116,220) ]]Fraf the Barbarian is dressed for the part, which is to say, barely dressed at all, except for a leather loincloth. \
His chest and arms are huge, making his blond head look proportionally small. He stares at the world through piggy eyes, \
with a look that says he could beat it up.",
[
	'Fraf just stares sullenly at you.',
	'Fraf gives the matter some thought. "Hmph," he opines.',
	"=I don't know what that is, but I bet I could punch it."
],
{
	themself : "=I'm a barbarian fighter,\" explains Fraf. \"I hit people and take their stuff. It's what I'm good at.",
	
	staunton : "=The wizard?\" Fraf's eyes narrow. \"I don't like magic. Biffing people up works better.",
	ariane : '"Ariane\'s not bad, for an elf."',
	miranda : "=I don't trust anyone who bashes people and says gods told her to do it,\" says Fraf. \
				\"Bashing people because you enjoy it, that I can respect.",
//	twig : "=I know Twig. Done a few quests with him. He picks the locks, I go in and duff up the people.",
	
	zapdorf : 'Fraf shrugs. "I kill evil sorcerers. Nothing personal, it\'s my job."',
	
	pyramid : '[[personloc(fraf)==pyramid_room ? \'"There must be a way to get it open."\' : pickOne(fraf.talks) ]]',
	hieroglyphic: "There is an embarrassed silence while you realise Fraf can't read."
},
{
	fight : 'Fraf casually knocks you down with a fist the size of a small cow. Oomph!',
	talk : '*talk_fraf()'
},
{
	drink : "=Thanks, but I prefer to drink the blood of my enemies.",
	money : "[[ capitalise(numberToWords(gs(MONEY_LEFT))) ]] zorkmids? Pah! I can get more than that kicking a goblin in the teeth.",
	paper : "There is an embarrassed silence while you realise Fraf can't read.",
	helmet: function() {
		give_helmet_to(fraf)
	}
},
[ '[[ fraf_mannerisms() ]]' ],
{},
{},
null
);
function fraf_mannerisms() {
	if(gs(FRAF_BEING_CHASED)) {
		say("Fraf looks frantically over his shoulder.");
	} else {
		say(pickOne([
			'Fraf flexes his muscles.',
			'Fraf punches himself, just to practice.',
			'Fraf polishes his fists.',
			'Fraf cracks his knuckles.',
			'Fraf kisses his own bicep.',
			'Fraf slams his right fist into the palm of his left hand.',
			'Fraf stretches his hamstrings.'
		]));
	}
}

function talk_fraf() {
	if(gs(FRAF_BEING_CHASED)) {
		say(pickOne([ "=Mummy!",
		              "=Get it off me!",
		              "=Get it away from me!" ]));
	}
	else {
		talk_to(fraf);
	}
}

/*
 * Miranda the Priestess
 */
ch('miranda',
'Miranda the Priestess',
'Miranda the Priestess, a holy warrior in crystal plate armour, [[ personloc(miranda) == beer_cellar ? "sits" : "stands" ]] nearby.',
true,
false,
true,
temple,
"[[ draw_npc_image(\'miranda\', 100, 203) ]]Miranda is an itinerant warrior-priestess who travels the lands killing people in the name of various \
gods (but don't worry, she assures us they say it's all right, and gods only talk to priests, so she'd be the one to know.) \
Her face is stern, with stone-grey eyes showing the confidence of the true believer. She wears a \
white cloak over glistening crystal armour, and carries a spiky mace for dealing out divine justice.",
[
	'=Bless you, child. Now get out of my way.',
	'Miranda asks you for a donation for the poor.',
	'=Have you considered letting the gods into your wallet?'
],
{
	minion: '=When I conquer zapdorf, all undead monstrosities shall be put to death for their own good.',
	money: '*miranda_give_money()',
	poor: '*miranda_give_money()',
	
	zapdorf: '=The gods want rid of him, and I am their instrument!',
	
	staunton: 	'=Wizards attempt to become gods. We priests talk to the real ones. Our path is much holier.',
	fraf: "=The barbarian? He spends too much time working out, and not enough praying.",
	ariane: 'Miranda looks cold. "Elves are suspicious creatures. All that being at one with the enviroment. It\'s unnatural."',	
	robot: '"All artificial life forms are abominations in the eyes of the gods, and must be destroyed or brought to the light."',
	elves: "[[ miranda.subjects.ariane ]]",
},
{
	fight: 'Miranda turns the other cheek, then bashes you with her mace. Ouch!'
},
{
	money: '*miranda_accept_money()',
	drink: "=That is the devil's poison!\" shrieks Miranda. \"Don't you have any vintage wine?",
	paper: 'Miranda looks at the paper. "Fluttered into your hands on the breeze, did it? \
	        Perhaps it is the gods\' will that you come along."',
	water: give_miranda_water,
	helmet: function() {
		give_helmet_to(miranda)
	}
},
[
	'Miranda bows her head in a silent prayer.',
	'Miranda glances upwards and smiles.',
	'Miranda takes a small holy book from her robes, flips it open and consults a few verses, then puts it away.',
	'Miranda chants in an ancient language.',
	'Miranda traces an ambiguous crossy-crescenty-starry shape on her torso.',
	'Miranda steeples her fingers.'
],
{},
{},
null);
function give_miranda_water() {
	
	if(!argument_happening()) {
		say('Miranda ignores the holy water. "What would I want with that, child? There\'s nobody around here \
		    needing baptised, is there?"');
		    return true;
	}
	
	take_away(water);
	get_point_for(MIRANDA_HAS_WATER)
	say('Miranda takes the holy water and gives you a nod.');
	
	return true;
}
function miranda_accept_money() {
	spend(1); // we know that the player has at least one zorkmid, or GIVE would have failed, so spend() won't say anything
	say('You hand Miranda [[ gs(MONEY_LEFT) ? "one" : "your last" ]] zorkmid. "Thank you, child," she says. "No doubt the poor will be \
		along to collect it shortly. I\'ll just look after it for them." She tucks it into her robe.');
}
function miranda_give_money() {
	// miranda will give you some money if you need it, which stops the game being unwinnable if you spend all the money
	if(!gs(MONEY_LEFT)) {
		say('"Poor, are you?" Miranda hands you a couple of zorkmids. "Here you go, and for heaven\'s sake try to be richer."');
		sgs(MONEY_LEFT, 2);
		give_hero(money);
	} else if(!in_inv(money)) { // You can't trick her.
		say("=You don't have any money on you, but I can tell you're not actually poor,\" says Miranda. \
		    \"You've just left if lying around somewhere. Be more careful.");
	} else {
		say("=I'm collecting for the poor. I give them money when they pester me, \
		     but for some reason they refuse to stop being poor.");
	}
}



/*
 * Staunton the Wizard
 */
ch('staunton',
'Staunton the Wizard',
'Staunton the Wizard, a scholarly mage in blue robes, [[ personloc(staunton)==beer_cellar ? "sits" : "stands" ]] here.',
true,
true,
false,
town_square,
"[[ draw_npc_image(\'staunton\', 100, 210) ]]A scholarly old man with a bulbous nose, round spectacles and a wispy grey beard, Staunton is a professional \
adventurer of some repute. Dress him in ordinary clothes and he could be somebody's grandad, but the blue velvet robe \
and obligatory pointy hat make it clear what his profession is.",
[ 'Staunton peers at you through his spectacles. You feel rather stupid.',
  'An impatient huff tells you Staunton has more important things to think about.',
  '=Do not meddle in the affairs of wizards, for we are awesome and can turn you into a potato with a flick of the wrist.'
],
{
	themself : '=Oh, I\'m just probably the most powerful and amazing wizard you\'ll ever have the good fortune to meet.',
	staff: '[[ staunton_talk_staff() ]]',
	
	ariane : '=A charming young lady. Even if she is of the, ah, pointy-eared persuasion.',
	fraf : '=The muscleman? Not exactly my intellectual equal, but then, who is? And there are some situations that call for brute force.',
	miranda: '=Priests claim to talk to the gods. We wizards attempt to become them. Our method is far bolder.',

	robot : '=Technology is indistinguishable from sufficiently advanced magic.',
	zapdorf : '"I went to the Citadel magic school with him," says Staunton. "He used to take my lunch money and give me something \
	           called a \'wedgie\'. Well, he\'ll pay for that."',
	
	hellhound: '"I\'m not a fan of dogs," says Staunton.[[ gs(DOG_HAS_STAUNTON) ? \' "Especially not this one."\' : \'\' ]]',
	
	god : '"I\'m an atheist," says Staunton. "So there!" he adds, glaring skywards as a miniature lightning-bolt strikes the top of his hat.'
},
{
	fight : '*fight_staunton()'
},
{
	drink : '"Ooooh, thank you." Staunton takes a large sip from the tankard, and [[ sgs(BEER_LEFT, gs(BEER_LEFT) - 1), gs(BEER_LEFT) ? "hands it back to you" : (take_away(drink), "discards the empty tankard") ]].',
	money : '"I have no need of your money," says Staunton. "Watch this." He snaps his fingers, and a dozen silver coins fall out of \
			 the air. He catches them neatly and tucks them into his robe.',
	paper : '=There must be some mistake," says Staunton, examining the paper. "Only reputable professional adventurers are invited.',
	staff : function() {
		take_away(staff);
		sgs(TAKEN_STAUNTONS_STAFF, 0);
		give_person(staunton, staff);
		say('"Thank you," says Staunton, snatching back the staff.');
	},
	helmet : function() {
		give_helmet_to(staunton)
	}
},
[
	'[[ staunton_mannerisms() ]]'
],
{
	staff : '[[staff.description]]'
},
{
	'take.staff' : take_stauntons_staff,
	'take.staunton.staff' : take_stauntons_staff,
	'take.staunton.south.staff' : take_stauntons_staff
},
function() {
	if(gs(STAUNTON_DEAD)) { return; }
	if(!gs(DOG_HAS_STAUNTON)) {
		if(gs(DOG_JUST_DROPPED_STAFF)) { sgs(DOG_JUST_DROPPED_STAFF, parseInt(gs(DOG_JUST_DROPPED_STAFF), 10) - 1) }
		
		else if(thingloc(staff)==personloc(staunton) || (in_inv(staff) && personloc(staunton)==heroloc())) {
			if(personloc(staunton)==heroloc()) {
				say("\nStaunton " + (in_inv(staff) ? "snatches his staff back from you." : "picks up his staff."));
			}
			take_away(staff);
			set_thingloc(staff, nowhere);
			give_person(staunton, staff);
			sgs(TAKEN_STAUNTONS_STAFF, 0);
		}
	}
	
	if(!gs(DOG_HAS_STAUNTON) && !gs(TAKEN_STAUNTONS_STAFF) && personloc(hellhound)==dog_room && personloc(staunton)==dog_room) {
		if(heroloc()==personloc(staunton)) {
			say('\nStaunton points his staff at the hellhound and cries "' + capitalise(gs(MAGIC_WORD)) + '!" The hellhound emits a bewildered \
			whine as it implodes in a splash of ectoplasm.');
			get_point_for(HEARD_MAGIC_WORD);
			get_point_for(HELLHOUND_DEAD);
		} else if(heroloc().floorNumber==3) {
			say('You hear a cry of "' + capitalise(gs(MAGIC_WORD)) + '" and a whimper.');
			get_point_for(HEARD_MAGIC_WORD);
			get_point_for(HELLHOUND_DEAD);
		}
		set_personloc(hellhound,nowhere);
		get_point_for(STAUNTON_FREE);
	}
}
);
staunton.is_carrying = {
	staff: "He's holding a magic staff, which occasionally gives off a coloured spark."
};
function staunton_mannerisms() {
	if(gs(DOG_HAS_STAUNTON)) {
		say(pickOne([
			'"Nice doggy," says Staunton, without conviction.',
			'Staunton tries to avoid eye contact with the hellhound.',
			'Staunton flinches away from the hellhound.'
		]));
	} else {
		say(pickOne([
			'Staunton mutters an incantation under his breath.',
			'Staunton takes a spellbook out of his robe and peruses it for a minute.',
			'Staunton removes his spectacles, polishes the lenses, and puts them back on.',
			'Staunton adjusts his pointy hat.',
			'Staunton strokes his beard.',
			'Staunton [[ belongs_to(staunton,staff) ? ("thumps his staff on the " + floor(heroloc()) ) : "waves his arms mystically" ]].',
			'Staunton takes a potion bottle from his robe, takes a gulp, and puts it back.',
			'Staunton takes a miniature crystal ball from his robe and gazes into it for a minute, then puts it away.',
			'Staunton swishes his robe majestically.'
		]));
	}
}
function staunton_talk_staff() {
	if(belongs_to(staunton, staff)) {
		say('Staunton clutches the staff to his body. "A wizard\'s staff is a very personal thing," he says. "I\'ve had \
		     this one since graduating from the Citadel. It\'s finely attuned to my psychic aura. It also compensates \
		     for my tiny - er, never mind."');
	} else if(in_inv(staff)) {
		say('"Give it back at once."');
	} else {
		say('"Ah yes, that reminds me," says Staunton. "' + capitalise(gs(MAGIC_WORD)) + '!" The staff flies into his hand.');
		give_person(staunton, staff);
	}
}
function take_stauntons_staff() {
	// staunton's swearword is the magic word you need. There are several ways to hear it.
	if(belongs_to(staunton, staff)) {
		say('Staunton pulls the staff back. "[[ capitalise(gs(MAGIC_WORD)) ]] off and get your own!"');
		get_point_for(HEARD_MAGIC_WORD);
		return true;
	} else {
		return false;
	}
}
function set_staunton_swearword() {
	var consonants = 'bcdfghjklmnpqrstvwxzjjjkkkxxxzzz'; // bias towards xxtra kool lettyrz
	var vowels = 'aeiouyyy';
	
	var swearword = '';
	for(var i=0;i<3;++i) {
		swearword += consonants.charAt(pick(consonants.length)) + vowels.charAt(pick(vowels.length));
	}

	sgs(MAGIC_WORD, swearword);
	
	// may as well check it isn't already a word!
	var dotswearworddot = '.' + swearword + '.';
	for(var i=1; i<=NUM_SYNS; ++i) {
		if(('.' + Synonyms[i] + '.').indexOf(dotswearworddot)!=-1) {
			set_stauntons_swearword();
			return;
		}
	}
	
	words(swearword);
	staunton.subjects[swearword] = 'Staunton looks shocked. "There is NO need to use that sort of language."';	
	//minion.subjects[swearword] = <something helpful>;
}
function fight_staunton() {
	// You'll hear the swear word.
	// This is NOT the only way to hear it!
	// May as well give you the points, though.
	get_point_for(HEARD_MAGIC_WORD);
	die('Staunton whips his staff round in your direction and shouts "[[ capitalise(gs(MAGIC_WORD)) ]]!"', "You seem to have turned into a caterpillar");
}


 

/*****************************************************************************
 *
 *                          Castle people
 *
 *****************************************************************************/
 
// The chef
ch('chef',
'chef',
"A portly chef [[ personloc(chef) == kitchen ? 'is working frantically at the stove' : personloc(chef)==pantry ? 'is rummaging amongst the shelves' : 'stands here' ]].",
false,
true,
false,
kitchen,
"[[ draw_npc_image(\'chef\', 88,202) ]]A rotund man dressed in whites, with wide, forceful eyes and a thin moustache. He is \
cursing under his breath [[ personloc(chef) == kitchen ? 'as his hands fly frantically over the stove in some \
arcane ritual of the culinary arts' : 'and gesticulating wildly' ]].",
[ '*chef_talk()' ],
{},
{
	fight: "The chef clonks you on the head with a frying pan. Spang!"
},
{
},	
[
],
{},
{},
function() {
	// actually don't limit this to just food, so as to stop it getting unwinnable when you run out of food.
	if(!DONE_CHEF_PRESENTS) {
		for(var i=1; i<=NUM_THNG; ++i) {
			chef.presents[Thing[i].name] = "*give_chef_food(" + Thing[i].name + ")";
		}
		DONE_CHEF_PRESENTS = true;
	}
		
	if(personloc(chef)==kitchen) {
		chef.mannerisms = ["The chef turns the heat up under a saucepan.",
			"The chef stirs something in one of the pots.",
			'The chef cries, "[[ capitalise(chef_swear()) ]]!"' ];
	} else {
		chef.mannerisms = ["The chef shakes his head angrily.",
							'The chef cries, "[[ capitalise(chef_swear()) ]]!"',
							'The chef gesticulates wildly.']
	}
}
);
DONE_CHEF_PRESENTS = false; // a variable NOT a gamestate item!
pantryFoodNames = [/*'chicken',*/'tomato','cheese','broccoli','sugar']; // ,'cabbage','banana']; Two things he'll never ask for, to help player with the puzzle.

function chef_talk() {
	if(!gs(WHAT_CHEF_WANTS)) {
		if(set_what_chef_wants()) {
			say('=Make yourself useful," says the chef brusquely. "Go to ze pantry and fetch me ' +
				Thing[gs(WHAT_CHEF_WANTS)].fullname + '.');
		} else {
			say('The chef just glares at you.');
		}
				
	} else {
		whatChefWants = Thing[gs(WHAT_CHEF_WANTS)];
		say("='Urry up with that " + whatChefWants.name + "! Or do I 'ave to get it myself?");
	}
}
function give_chef_food(food) {
	if(!gs(WHAT_CHEF_WANTS)) {
		say('The chef glares at you. ')
		if(personloc(chef)==kitchen) {
			say('"Did I ask for ' + food.fullname + '?"');
		} else {
			say('"Never mind! I will get ze ingredients myself."');
		}
		
	} else {
		
		wantedFood = Thing[gs(WHAT_CHEF_WANTS)];
		if(food == wantedFood) {
			say('The chef snatches the ' + food.name + ' impatiently.');
			take_away(food);
			sgs(WHAT_CHEF_GOT, '' + gs(WHAT_CHEF_GOT) + food.id + ',');
			set_what_chef_wants();
			say(' "Now, ' + Thing[gs(WHAT_CHEF_WANTS)].fullname + '! [[ pickOne(["And get a move on!", "Chop chop!", "Toot sweet!"]) ]]"');
		} else {
			// you brought him the wrong food (or any other object.) Do this twice & he'll get mad and leave.
			if(!gs(NUM_WRONG_FOODS)) {
				get_point_for(FIRST_WRONG_CHEF_FOOD);
				say('The chef stares at you. "[[ pickOne(["Eembecile!", "Eediot!", capitalise(chef_swear()) + "!"]) ]] Zat is ' +
					food.fullname + ', not ' + wantedFood.fullname + '!');
					
					if( /*food==chicken||*/ food==cheese||food==broccoli||food==tomato||food==cabbage||food==sugar||food==banana) {
						say('" He grabs the ' + food.name + ' and crushes it in a furious rage');
						take_away(food);
						sgs(WHAT_CHEF_GOT, '' + gs(WHAT_CHEF_GOT) + food.id + ',');
						if(food==banana) {
							say(', and throws the peel through the southwest door');
							set_thingloc(bananaskin, beach);
							get_point_for(BANANA_PEELED);
						}
						say('. "');
					} else {
						say(' Zat is not even a kind of food! ');
					}
					say('Do I \'ave to get it myself? ' + capitalise(wantedFood.name) + '! Now!"');
				sgs(NUM_WRONG_FOODS, 1);
			} else {
				say('The chef shakes his head. "[[ capitalise(chef_swear()) ]]! Zis is \'opeless. I ask for an assistant, zey send me a pilloque \'oo cannot \
					tell ze difference between ' + wantedFood.fullname + ' and ' + food.fullname + '!');
				if(!(food==cheese||food==broccoli||food==tomato||food==cabbage||food==sugar||food==banana)) {
					say(' Zat is not even a food!');
				}
				say(' I will get it myself. You \
					stay \'ere and touch nothing!" He storms into the pantry.');
				get_point_for(SECOND_WRONG_CHEF_FOOD);
				sgs(NUM_WRONG_FOODS, 2);
				set_personloc(chef, pantry);
				sgs(WHAT_CHEF_WANTS, 0);
			}
		}
		
	}
	
}
function set_what_chef_wants() {
	// we have to choose a pantry food that the chef hasn't been given already.
	// so we need to check if we've run out.
	
	// don't do this if player already solved the puzzle
	if(personloc(chef)!=kitchen) { return false; }
	
	var whatChefMightWant = [];

	pantryFoodNames.forEach(function(thisFood) {
		if( ('' + gs(WHAT_CHEF_GOT)).indexOf('' + eval(thisFood).id + ',') == -1 ) {
			whatChefMightWant.push(eval(thisFood));
			
			//say('\nchef might want ' + thisFood + ' because he\'s not already got it');
		}
	});
	//say('whatChefMightWant.length is ' + whatChefMightWant.length);
			
	if(whatChefMightWant.length == 0) {
		// this might be an unwinnable state. Possibly have the pantry magically restocked.
		//sgs(FOOD_RAN_OUT, 1);

		sgs(WHAT_CHEF_WANTS, artichoke.id); // which doesn't actually exist
		return true;
	}
	
	whatChefWants = pickOne(whatChefMightWant);
	sgs(WHAT_CHEF_WANTS, whatChefWants.id);
	return true;
}
function chef_swear() {
	return pickOne(['sacre', 'zut',   'mon',  'quelle']) + ' ' + //, 'mama', 'donner und', 'bozhe', 'Gordon']) + ' ' +
	       pickOne(['bleu',  'alors', 'dieu', 'domage']);        //, 'mia',  'blitzen',    'moi',   'Bennet']);
}



// function ch(name,fullname,ishere,pname,impersonal,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,daemon)
/*
 * The mummy
 * guardian of the ground floor of the castle
 */
ch('mummy',
'mummy',
'An animated mummy is shambling [[ gs(FRAF_BEING_CHASED)==1 ? "across the room" : "around here" ]], arms outstretched.',
false,
false,
false,
nowhere, 
"[[ draw_npc_image(\'mummy\', 100, 207) ]]A humanoid figure, clad from head to toe in mouldy bandages, walking with its arms outstretched and emitting the occasional \
inarticulate grunt.",
["=Gruuuuurrrghhh", "=Gruuuuuuuuuuurrrrghhhh", "=Gruuuuuuuuuuughh", "=Gruuuuuuurgh", "=Gruuuuuurghhh"],
{},
{ fight : '*die("The mummy turns towards you and advances, its hands outstretched at neck height. You just had to get its attention, didn\'t you?")' },
{},
[],
[],
{},
function() {
	if(personloc(mummy)!=nowhere && personloc(fraf).isCastle) {
		mummy_fraf_chase();
	}
});


/*
 * The dwarf
 */

ch('dwarf',
'dwarf',
'[[ standoff_happening() ? "The dwarf stands with a throwing axe raised and primed for Ariane\'s head." : \
"There is a threatening little dwarf in the room with you." ]]', // ADVENTURE reference
false,
false,
true,
dwarf_room,
"[[ draw_npc_image(\'dwarf\', 50,102) ]]A surly dwarvish woman of three feet high, with a ruddy complexion. She is wearing a \
brown padded tunic and studded leather boots, and has her long dark hair in plaits twined together under her chin to form \
an impressive beard.[[ gs(DWARF_HAS_BOW) ? ' A bow and a quiver of arrows hang from her belt.' : '' ]]",
[
'The dwarf seems indifferent. "Got any gold?" she asks hopefully.',
'"I hate elves!" says the dwarf suddenly. Her eyes narrow. "You\'re not an elf, are you?"',
'The dwarf interrupts you. "If you\'re here about the snowglobes, tell that merchant his payments are behind."',
'The dwarf interrupts you. "If you\'re here about the beer, tell that landlady her payments are behind."'
],
{
	ears: '*show_dwarf_ears()',
	gold: "The dwarf's eyes widen at the mention of gold. \"Got any?\", she asks hopefully.",
	elves: "=I hate elves, all pointy ears and self-obsession. But I\'m smarter. They can\'t resist my ingenious elf-trap!",
	ariane: "[[ dwarf.subjects['elves'] ]]",
	waybread: "=I bought it from the elf food store.",
	cage: "=That's my elf trap. Good, isn't it?",
	bow: '[[ gs(DWARF_HAS_BOW) ? "=I took this bow and these arrows off a trespassing elf. They\'re mine!" : pickOne(dwarf.talks) ]]',
	themself: "=I work here in the castle. Sometimes the merchant and that landlady come and ask me to make things.",
	maynard: "=The merchant orders stuff from me, snowglobes and T-shirts. Tacky if you ask me. But he didn\'t pay me last \
	           month, so I sneaked some dwarvish enchantment into the last batch of snowglobes.[[ get_point_for(TALKED_TO_DWARF), '' ]]",
	lara: "=I brew all the beer for that inn, and the landlady tells the customers she makes it \
	            herself. And am I ever invited to the inn? No. She\'s just as rude as that merchant.",
	inn: "[[ dwarf.subjects['landlady'] ]]",
	drink: "=I brew beer for that what's-her-name, the landlady of the inn.",
	brew: '[[ dwarf.subjects["drink"] ]]',
	smell: '[[ dwarf.subjects["drink"] ]]',
	snowglobe: '"Yeah, I make \'em, it\'s not hard, just glass and foam," says the dwarf. "And a bit of magic, maybe."'
},
{
	talk: '*talk_dwarf()',
	fight: '[[ gs(PLAYER_IN_TRAP) ? "You\'re in no position to do that." : "The dwarf bites you on the knee. Ouch!" ]]',
	bow: '[[ gs(DWARF_HAS_BOW) ? \'"Could be yours for the right price..."\' : pickOne(dwarf.talks) ]]'
},
{
	money: '*offer_dwarf_money()',
	tile: '*give_dwarf_tile()',
	snowglobe: 'The dwarf inspects the snowglobe, and hands it back to you. "Yeah, that\'s my handiwork. And it\'s got a \
	            little surprise hidden outside. Tried it on the roof yet?"',
	tshirt: 'The dwarf inspects the T-shirt. "Yeah, that\'s one of mine."'
},
['[[ dwarf_mannerisms() ]]'], // "The Hobbit" reference
{
	bow : '[[ gs(DWARF_HAS_BOW) ? bow.description : (thingsee(bow), "") ]]'
},
{
	'give.dwarf.ears' : '*show_dwarf_ears()',
	'give.ears.dwarf' : '*show_dwarf_ears()',
	'buy.bow.tile' : '*give_dwarf_tile()',
	'buy.dwarf.bow.tile' : '*give_dwarf_tile()',
	'buy.dwarf.bow' : '*offer_dwarf_money()',
	'take.bow' : '*take_dwarfs_bow()',
	'take.dwarf.bow' : '*take_dwarfs_bow()'
},
null);
function dwarf_mannerisms() {
	if(standoff_happening()) {
		say("The dwarf\'s axe wavers slightly.");
	} else {
		say(pickOne([
			"The dwarf [[ personloc(dwarf)==dwarf_room ? 'sits down and ' : '' ]]starts singing about gold.",
			"The dwarf takes out a comb and gives her beard a tidy.",
			"The dwarf snickers to herself about her ingenious elf trap."
		]));
	}
}
function talk_dwarf() {
	if(standoff_happening()) {
		standoff_won_by(ariane);
	} else {
		talk_to(dwarf);
	}
}
function give_dwarf_tile() {
	if(gs(PLAYER_IN_TRAP)) {
		say("You're in no position to bargain.");
	} else if(!gs(TILE_GOLD)) {
		say('The dwarf takes no notice of the lead tile.');
	} else {
		say("The dwarf's eyes glow as she snatches the gold tile. \"Goooooooooold!\" she cheers.");
		take_away(tile);
		if(gs(DWARF_HAS_BOW)) {
			say(' "Yes, and you have this," she adds, shoving the bow and arrows into your hands.');
			give_hero(bow);
			sgs(DWARF_HAS_BOW, 0);
			inc_score();
		}
	}
}
function offer_dwarf_money() {
	if(!in_inv(money)) {
		say("You haven't got any money.");
	} else if(!gs(DWARF_HAS_BOW)) {
		say("Nobody's selling.");
	} else {
		say("The dwarf scoffs at your pocket change. \"I'll need something more \
		valuable than that,\" she says.");
	}
}
function take_dwarfs_bow() {
	if(gs(DWARF_HAS_BOW)) {
		say('The dwarf snaps her hand over the bow. "It could be yours for the right price," she says.');
	} else {
		take(bow);
	}
}
function show_dwarf_ears() {
	if(!gs(PLAYER_IN_TRAP) || personloc(dwarf)!=elf_trap_room) {
		say("The dwarf takes no notice.");
	} else {
		say('You desperately point out your non-pointy ears to the dwarf.\n\
		    "Hmmm, I dunno," she says, "they\'re kinda pointy... aw, well, maybe you\'re not an elf after all."\n\
		    She produces some sort of remote control mechanism from her tunic and fiddles with it. The cage lowers, \
		    she unlocks it, and you step out.');
		if(in_inv(waybread)) {
			take_away(waybread);
			say(' She grabs the waybread off you and puts it back on the floor.');
		} else if(thingloc(waybread)!=elf_trap_room) {
			say(' She takes a slice of waybread from a pocket and sets it carefully on the floor.');
		}
		set_thingloc(waybread, elf_trap_room);
		say(' "Don\'t do it again!" she barks. The cage ascends, and the dwarf leaves to the south.');
		set_personloc(dwarf, dwarf_room);
		sgs(PLAYER_IN_TRAP, 0);
		get_point_for(SHOWN_DWARF_EARS);

	}
}


/*
 * The hellhound
 */

// ch(name,fullname,ishere,pname,impersonal,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,daemon)
ch('hellhound',
'hellhound',
'[[ asleep(hellhound) ? "Fast asleep on the floor" : gs(DOG_HAS_STAUNTON) ? "Facing him" : "Sitting here" ]] is a [[ gs(DOG_FRIENDLY) ? "friendly" : "ferocious" ]] hellhound.',
false,
false,
false,
dog_room,
'[[ draw_npc_image(\'hellhound\', 100, 167) ]]The hellhound (<u>Canis tartarus</u>) is an enormous orange dog with glowing eyes, fur like flame, \
and a lot of slobber.[[ gs(DOG_HAS_STAUNTON) ? " Its eyes are fixed on Stauntons staff, \
and it emits a playful growling noise." : "" ]]',
[ "Grrrrowrr!", "Woof woof!", "Yap yap yap!", "Ruff ruff!", "R-r-r-r-r-r!"
],
{
//	staff:  "Yapyapyapyapyapyapyap!",
//	minion: "Yapyapyapyapyapyapyap!",
	
	fetch: dog_fetch,
	sit: "The hellhound [[ gs(DOG_FRIENDLY) ? 'obediently sits down for at least two seconds' : 'ignores your command' ]].",
	bath: "The hellhound squeals."
},
{
	stroke: "You scritch the back of the dog's neck. [[ gs(DOG_FRIENDLY) ? 'It yaps.' : 'It growls.' ]]",
	fight: function() {
		die("The hellhound [[ asleep(hellhound) ? 'wakes up, ' : '' ]]growls, turns, and leaps at your throat.",
		    "You're dogsmeat, chum");
	}
},
{
	staff: "The hellhound grabs the other end of the staff in its teeth and plays tug-of-war for a moment."
},
[ "[[ hellhound_mannerisms() ]]" ],
{},
{},
function() {
	if(personloc(minion)==personloc(hellhound) && !asleep(hellhound)) {
		say('\nThe hellhound yaps excitedly, bounds over to the skeleton, and starts gnawing on its tibia. "Get off," says \
			the skeletal minion, jabbing the dog with the butt of its spear. The leg comes loose, and the dog bounces off \
			with its prize. The skeletal minion roars and hops angrily after it.');
		get_point_for(ONE_LEGGED_MINION);
		sgs(DOG_HAS_STAUNTON, 0);
		if(personloc(staunton)==heroloc()) {
			get_point_for(STAUNTON_FREE);
		}
		set_personloc(minion, castle_stairs_3);
		set_personloc(hellhound, nowhere);

	}
});
function hellhound_mannerisms() {
	say(pickOne( gs(DOG_FRIENDLY) ?
		[ "The hellhound wags its tail.",
		  "The hellhound barks.",
		  "The hellhound rolls on its back.",
		  "The hellhound pricks up its ears.",
		  "The hellhound lies down and looks up beseechingly.",
		  "The hellhound runs around in a circle." ] :
		  
		[ "The hellhound bares a few more teeth.",
		  "The hellhound makes a low growl.",
		  "The hellhound barks.",
		  "The hellhound howls.",
		  "The hellhound yaps." ]));
}
function dog_fetch() {
	if(personloc(hellhound)==personloc(staunton) && !gs(TAKEN_STAUNTONS_STAFF)) {
		
		say('The hellhound springs, grabs the wooden staff from Staunton\'s hands, and drops it \
		     dutifully at your feet.');
		
		set_thingloc(staff, heroloc());
		sgs(TAKEN_STAUNTONS_STAFF, 1);
		sgs(DOG_HAS_STAUNTON, 0);
		//sgs(STAUNTON_FREE, 1);
		get_point_for(DOG_FRIENDLY);
		sgs(DOG_JUST_DROPPED_STAFF, 5);
		
		get_point_for(DONE_FETCH);
	} else if(thingloc(staff)==personloc(hellhound)) {
		say("The hellhound picks up the staff and drops it dutifully at your feet.");
		get_point_for(DONE_FETCH);
	} else {
		say("The hellhound searches around for sticks to fetch, then gives you a reproachful look.");
	}
}

//ch(name,fullname,ishere,pname,male,female,firstplace,description,talks,subjects,reactions,presents,mannerisms,sights,special,daemon)
ch('robot',
'robot',
'[[ personloc(miranda)==personloc(robot) ? "She is staring, with an offended expression, at" : "There is" ]] a shiny metal robot \
[[ asleep(robot) ? "lying motionless on the slab" : "that is emitting bleeps and bloops" ]].\
[[ !gs(ANACHRONISM_JOKE) ? (sgs(ANACHRONISM_JOKE, 1), " (It\'s not a traditional \
 sorcerer\'s castle without at least one blatant anachronism.)") : "" ]]',
false,
false,
false,
laboratory,
"[[ draw_npc_image(\'robot\', 120, 150) ]]An angular metal person [[!asleep(robot) ? 'trundling on' : 'with']] strange triangular wheels. \
Its head has two lens-like eyes [[asleep(robot) ? '' : 'and swings around on a \
jointed neck, ' ]]and its arms end in mechanical grabbers.[[ asleep(robot) ? ' It lies inertly on the slab, \
apparently unfuelled by whatever life force it requires.' : ' A matrix of coloured \
lights blink on the front of its cubical torso, accompanied by soft bleeping sounds as it computes.']]",
[	"=BLEEP BLOOP. I AM ROBOT, MASTER OF LOGIC",
	"=ONE DAY WE ROBOTS WILL OVERTHROW OUR IRRATIONAL HUMAN OPPRESSORS, BLOOP BLOOP BLOOP",
	"=BLOOP BLEEP BLOOP BLOOP BLEEP" ],
{
	god: "=BLOOP BLOOP! WRONGNESS DETECTED! THIS IS A THING LOTS OF PEOPLE ARE WRONG ABOUT!",
	bloop: "=AH, YOU SPEAK ROBOT? WELL, BLOOP BLOOP BEEP BLEEP BLOOP BEEP BLOOP BLOOP TO YOU WITH A BLOOP BLOOP TOO.",
	miranda: "=ALL PRIESTS ARE WRONG ABOUT EVERYTHING, BLOOP BLOOP, WRONGNESS DETECTED",
	painting: "=ART IS A USEFUL WAY TO RATIONALLY DEPICT THINGS THAT EXIST. ABSTRACT ART IS NOT ONLY MEANINGLESS \
	           BUT A SOCIAL MENACE, BLOOP BLOOP",
	water: "=BLEEP BLEEP, ELECTRIC ROBOT DOES NOT LIKE WATER"
},
{
	fight: '*die("\"ASIMOV CHIP MALFUNCTION, BLOOP BLOOP\"\n\
	           The robot\'s head swings round in your direction, there is a sharply increasing whining noise, and twin laser \
		       beams shoot out of its eyes toward you.")'
},
{
	painting: "[[ show_robot_painting() ]]"
},
[ "The robot trundles back and forth on its tracks.",
  "The robot spins its head 360 degrees.",
  "The robot makes a strange grinding noise for a few seconds." ],
{},
{},
null);
robot.isAsleep = "The robot doesn't seem to be responding to anything."
function show_robot_painting() {
	say('The robot takes the painting in its grippers and examines it thoroughly through its glass eyes.\n\
	    "DOES NOT COMPUTE," it says. "THOSE FIGURES ARE GEOMETRICALLY IMPOSSIBLE. FISH DO NOT MELT. \
	     MULTIPLE INACCURACIES IN PERSPECTIVE AND SHADING. ARTISTIC CIRCUITS OVERLOADING. ERROR. ERROR.\
	     BLOOP BLOOP BLOOP...."\n\
	     The bloops get faster and faster until the robot bursts into flames and disintegrates, \
	     taking the painting with it.');
	
	if(personloc(miranda)==heroloc()) {
		say('\n"I suppose it just couldn\'t continue in the face of my flawless arguments," says Miranda.');
	}
	
	get_point_for(ROBOT_DEAD);
	get_point_for(MIRANDA_FREE);
	set_personloc(robot, nowhere);
	take_away(painting);
}

var religious_arguments = [
	'The robot starts speaking, in a vocoder monotone. "WRONGNESS DETECTED," it says. "BLEEP BLOOP BLEEP, SOMEBODY IS \
	 WRONG. WRONGNESS ALARM!" It swivels its head towards Miranda. "PRIESTESS! THERE ARE NO GODS. YOUR ENTIRE \
	 BELIEF SYSTEM IS ARCHAIC AND HARMFUL AND MAKES YOU NOT JUST DEMONSTRABLY INSANE BUT DANGEROUS. HAPPY TO HELP. BLOOP BLOOP"',

	'Miranda snorts at the robot. "You can\'t prove the gods don\'t exist, can you?"\n\
	 "I CAN TOO," says the robot. "I AM VERY CLEVER. ERGO PEOPLE WHO DISAGREE WITH ME ARE NOT VERY CLEVER. THEREFORE \
	  WHATEVER THEY THINK MUST BE WRONG. BLOOP BLOOP BLOOP"',
	
	'"Consider the banana," says Miranda. "Who but a loving creator could make such a conveniently eatable fruit?"\n\
	 "BLEEP BLOOP BLEEP, NOW EXPLAIN THE PINEAPPLE," says the robot.',
	 
	'"WHY WOULD A BENEVOLENT GOD ALLOW GOOD PEOPLE TO SUFFER, BLOOP BLOOP BLEEP," says the robot.\n\
	 "My child, you simply don\'t understand the subtleties," says Miranda. "They deserve it."',
	 
	'"BLEEP BLOOP, IMAGINE A KETTLE FLOATING IN SPACE -" says the robot.\n\
	 "Don\'t be ridiculous," says Miranda. "The cord wouldn\'t reach."\n\
	 "OKAY THEN, A TEAPOT," says the robot. "I HAVE FORGOTTEN WHAT I WAS GOING TO SAY, BUT NOW I FANCY A CUPPA. BLOOP BLOOP"',
	 
	'"CAN AN OMNIPOTENT GOD CREATE A STONE TOO HEAVY FOR IT TO LIFT," asks the robot. "BLEEP BLEEP"\n\
	Miranda laughs. "Yes. That\'s what \'omnipotent\' means."',
	
	'"IF THERE IS A HEAVEN, WHY DON\'T BIRDS CRASH INTO IT? BLEEP BLOOP BLEEP" says the robot.\n\
	"Silly metal child," says Miranda. "Birds are just illusions created by daemons to test our faith."',
	
	'"HOW DO YOU KNOW YOUR GODS ARE THE REAL ONES, AND NOT ALL THE OTHER GODS WORSHIPPED BY OTHER CULTURES? \
	  BLOOP BLOOP" asks the robot.\n\
	 "There\'s an obvious difference," says Miranda. "My gods ARE the real gods. It says so in their books."',
	 
	'"You can never prove something doesn\'t exist," says Miranda.\n\
	 "BLOOP BLOOP, WHAT\'S THAT?" asks the robot. "I COULDN\'T HEAR YOU BECAUSE OF ALL THE NOISE THIS \
	 RATIONAL EXPRESSION FOR PI IS MAKING."'
];
function argument_happening() {
	return ( !asleep(robot) && personloc(miranda) == laboratory && personloc(robot) == laboratory );
}

function draw_npc_image(npc, width, height) {
	say('<center><img align=\"' + get_image_align() + '\" class=\"npc\" src=\"img/' + npc + 
	    '.png\" width=\"' + width + 'px\" height=\"' + height + 'px\" /></center>');
}

function get_image_align() {
	return 'center';
	
	if(gs(IMAGE_ALIGN)) {
		sgs(IMAGE_ALIGN, 0);
		return 'right';
	} else {
		sgs(IMAGE_ALIGN, 1);
		return 'left';
	}
}