/*================================================================
 * rassa.c -- Handle output to the product file
 * Copyright(c) 1991 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 01 Sep 93 - modified
 *   Version 2.3.6 - 17 Dec 93 - modified
 *==============================================================*/

#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"
#include "interp.h"

#define MAXPAGESIZE 65536
#define MAXROWS 512
#define MAXCOLS 512
INT _cols = 0, _rows = 0;
INT curcol = 1, currow = 1;
INT outputmode = BUFFERED;
static STRING pagebuffer = NULL;
static char linebuffer[1024];
static INT linebuflen = 0;
static STRING bufptr = linebuffer;
STRING outfilename;

STRING noreport = "No report was generated.";
STRING whtout = "What is the name of the output file?";

/*========================================
 * initrassa -- Initialize program output.
 *======================================*/
initrassa ()
{
	outputmode = BUFFERED;
	linebuflen = 0;
	bufptr = linebuffer;
	curcol = 1;
}
/*========================================
 * finishrassa -- Finalize program output.
 *======================================*/
finishrassa ()
{
	if (outputmode == BUFFERED && linebuflen > 0 && ofp) {
		fwrite(linebuffer, linebuflen, 1, ofp);
		linebuflen = 0;
		bufptr = linebuffer;
		curcol = 1;
	}
}
/*=========================================
 * _pagemode -- Switch output to page mode.
 *   usage: pagemode(INT, INT) -> VOID
 *=======================================*/
WORD _pagemode (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	INT cols, rows = (INT) evaluate(ielist(node), stab, eflg);
	if (*eflg) return NULL;
	cols = (INT) evaluate(inext((INTERP)ielist(node)), stab, eflg);
	if (*eflg) return NULL;
	*eflg = TRUE;
	if (cols < 1 || cols > MAXCOLS || rows < 1 || rows > MAXROWS)
		return NULL;
	*eflg = FALSE;
	outputmode = PAGEMODE;
	_rows = rows;
	_cols = cols;
	if (pagebuffer) stdfree(pagebuffer);
	pagebuffer = (STRING) stdalloc(_rows*_cols);
	memset(pagebuffer, ' ', _rows*_cols);
	return NULL;
}
/*=========================================
 * _linemode -- Switch output to line mode.
 *   usage: linemode() -> VOID
 *=======================================*/
WORD _linemode (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	outputmode = BUFFERED;
	linebuflen = 0;
	bufptr = linebuffer;
	curcol = 1;
	*eflg = FALSE;
	return NULL;
}
/*=======================================
 * _newfile -- Switch output to new file.
 *   usage: newfile(STRING, BOOL) -> VOID
 *=====================================*/
WORD _newfile (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	STRING name = (STRING) evaluate(ielist(node), stab, eflg);
	BOOLEAN aflag;
	if (*eflg || !name || *name == 0) return NULL;
	aflag = (BOOLEAN) evaluate(inext((INTERP) ielist(node)), stab, eflg);
	if (ofp) {
		finishrassa();
		fclose(ofp);
	}
	outfilename = strsave(name);
	if (!(ofp = fopenpath(name, aflag?"a":"w", llreports))) {
		mprintf("Could not open file %s", name);
		return NULL;
	}
	return NULL;
}
/*=====================================
 * _outfile -- Return output file name.
 *   usage: outfile() -> STRING
 *===================================*/
WORD _outfile (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	if (!ofp) {
		ofp = ask_for_file("w", whtout, &outfilename, llreports);
		if (!ofp)  {
			message(noreport);
			return;
		}
		setbuf(ofp, NULL);
	}
	*eflg = FALSE;
	return (WORD) outfilename;
}
/*================================================
 * _pos -- Position page output to row and column.
 *   usage: pos(INT, INT) -> VOID
 *==============================================*/
WORD _pos (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	INT col, row = (INT) evaluate(ielist(node), stab, eflg);
	if (*eflg) return NULL;
	col = (INT) evaluate(inext((INTERP) ielist(node)), stab, eflg);
	if (*eflg) return NULL;
	*eflg = TRUE;
	if (outputmode != PAGEMODE || row < 1 || row > _rows ||
	    col < 1 || col > _cols) return NULL;
	*eflg = FALSE;
	currow = row;
	curcol = col;
	return NULL;
}
/*=========================================
 * _row -- Position output to start of row.
 *   usage: row(INT) -> VOID
 *=======================================*/
WORD _row (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	INT row = (INT) evaluate(ielist(node), stab, eflg);
	if (*eflg) return NULL;
	*eflg = TRUE;
	if (outputmode != PAGEMODE || row < 1 || row > _rows) return NULL;
	*eflg = FALSE;
	currow = row;
	curcol = 1;
	return NULL;
}
/*===================================
 * _col -- Position output to column.
 *   usage: col(INT) -> VOID
 *=================================*/
WORD _col (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	INT newcol = (INT) evaluate(ielist(node), stab, eflg);
	if (*eflg) return NULL;
	if (newcol < 1) newcol = 1;
	if (newcol > 100) newcol = 100;
	if (newcol == curcol) return NULL;
	if (newcol < curcol) poutput("\n");
	while (curcol < newcol) poutput(" ");
	return NULL;
}
/*=======================================================
 * _pageout -- Output current page and clear page buffer.
 *   usage: pageout() -> VOID
 *=====================================================*/
WORD _pageout (node, stab, eflg)
INTERP node; TABLE stab; BOOLEAN *eflg;
{
	char scratch[MAXCOLS+2];
	STRING p;
	INT row, i;
	*eflg = TRUE;
	if (outputmode != PAGEMODE) return NULL;
	if (!ofp) {
		ofp = ask_for_file("w", whtout, &outfilename, llreports);
		if (!ofp)  {
			message(noreport);
			return;
		}
		setbuf(ofp, NULL);
	}
	*eflg = FALSE;
	scratch[_cols] = '\n';
	scratch[_cols+1] = 0;
	p = pagebuffer;
	for (row = 1; row <= _rows; row++) {
		memcpy(scratch, p, _cols);
		for (i = _cols - 1; i > 0 && scratch[i] == ' '; i--)
			;
		scratch[i+1] = '\n';
		scratch[i+2] = 0;
		fputs(scratch, ofp);
		p += _cols;
	}
	memset(pagebuffer, ' ', _rows*_cols);
	return NULL;
}
/*==========================================
 * poutput -- Output string in current mode.
 *========================================*/
poutput (str)
STRING str;
{
	STRING p, name;
	INT c, len;
	if (!str || *str == 0 || (len = strlen(str)) <= 0) return;
	if (!ofp) {
		ofp = ask_for_file("w", whtout, &name, llreports);
		if (!ofp)  {
			message(noreport);
			return;
		}
		setbuf(ofp, NULL);
		outfilename = strsave(name);
	}
	switch (outputmode) {
	case UNBUFFERED:
		fwrite(str, len, 1, ofp);
		adjust_cols(str);
		return;
	case BUFFERED:
		if (len > 1024) {
			fwrite(linebuffer, linebuflen, 1, ofp);
			fwrite(str, len, 1, ofp);
			linebuflen = 0;
			bufptr = linebuffer;
			adjust_cols(str);
			return;
		}
		if (len + linebuflen > 1024) {
			fwrite(linebuffer, linebuflen, 1, ofp);
			linebuflen = 0;
			bufptr = linebuffer;
		}
		linebuflen += len;
		while (c = *bufptr++ = *str++) {
			if (c == '\n')
				curcol = 1;
			else
				curcol++;
		}
		--bufptr;
		return;
	case PAGEMODE:
		p = pagebuffer + (currow - 1)*_cols + curcol - 1;
		while (c = *str++) {
			if (c == '\n') {
				curcol = 1;
				currow++;
				p = pagebuffer + (currow - 1)*_cols;
			} else {
				if (curcol <= _cols && currow <= _rows)
					*p++ = c;
				curcol++;
			}
		}
		return;
	default:
		FATAL();
	}
}
/*====================================================
 * adjust_cols -- Adjust column after printing string.
 *==================================================*/
adjust_cols (str)
STRING str;
{
	INT c;
	while (c = *str++) {
		if (c == '\n')
			curcol = 1;
		else
			curcol++;
	}
}
