/*================================================================
 * valid.c -- Record validation functions.
 * Copyright(c) 1992 by Thomas T. Wetmore IV; all rights reserved.
 *   Version 2.3.4 - 24 Jun 93 - controlled
 *   Version 2.3.5 - 02 Sep 93 - modified
 *================================================================
 */
#include <stdio.h>
#include "standard.h"
#include "table.h"
#include "gedcom.h"

STRING badind = "You cannot edit the INDI line in a person record.";
STRING badfmc = "You cannot edit the FAMC line in a person record.";
STRING badfms = "You cannot edit the FAMS lines in a person record.";
STRING badfam = "You cannot edit the FAM line in a family record.";
STRING badhsb = "You cannot edit the HUSB line in a family record.";
STRING badwif = "You cannot edit the WIFE line in a family record.";
STRING badchl = "You cannot edit the CHIL lines in a family record.";
STRING bademp = "The record is empty.";
STRING badin0 = "The record does not begin with an INDI line.";
STRING badfm0 = "The record does not begin with a FAM line";
STRING badmul = "The record contains multiple level 0 lines.";
STRING badnnm = "This person record does not have a name line.";
STRING badenm = "This person record has bad GEDCOM name syntax.";
STRING badpsx = "You cannot change the sex of a parent.";

/*=======================================
 * valid_indi_tree -- Validate INDI tree.
 *=====================================*/
BOOLEAN valid_indi_tree (indi, pmsg, isex, indi0, famc0, fams0)
NODE indi;
STRING *pmsg;
INT isex;
NODE indi0, famc0, fams0;
{
	NODE name, sex, body, famc, fams, node;
	if (!indi) {
		*pmsg = bademp;
  		return FALSE;
	}
	if (strcmp("INDI", ntag(indi))) {
		*pmsg = badin0;
		return FALSE;
	}
	if (nsibling(indi)) {
		*pmsg = badmul;
		return FALSE;
	}
	node = nchild(indi);
	name = NULL;
	for (node = nchild(indi); node; node = nsibling(node)) {
		if (!strcmp("NAME", ntag(node))) name = node;
	}
	if (!name) {
		*pmsg = badnnm;
		return FALSE;
	}
	split_indi(indi, &name, &sex, &body, &famc, &fams);
	for (node = name; node; node = nsibling(node)) {
		if (!valid_name(nval(node))) {
			*pmsg = badenm;
			join_indi(indi, name, sex, body, famc, fams);
			return FALSE;
		}
	}
	if (indi0 && !iso_list(indi, indi0)) {
		*pmsg = badind; 
		join_indi(indi, name, sex, body, famc, fams);
		return FALSE;
	}
	if (!iso_list(famc, famc0)) {
		*pmsg = badfmc;
		join_indi(indi, name, sex, body, famc, fams);
		return FALSE;
	}
	if (!iso_list(fams, fams0)) {
		*pmsg = badfms; 
		join_indi(indi, name, sex, body, famc, fams);
		return FALSE;
	}
	if (isex != SEX_UNKNOWN && isex != val_to_sex(sex)) {
		*pmsg = badpsx;
		join_indi(indi, name, sex, body, famc, fams);
		return FALSE;
	}
	join_indi(indi, name, sex, body, famc, fams);
	return TRUE;
}
/*=====================================
 * valid_fam_tree -- Validate FAM tree.
 *===================================*/
BOOLEAN valid_fam_tree (fam, pmsg, fam0, husb0, wife0, chil0)
NODE fam;
STRING *pmsg;
NODE fam0, husb0, wife0, chil0;
{
	NODE husb, wife, chil, rest;

	if (!fam) {
		*pmsg = bademp;
  		return FALSE;
	}
	if (strcmp("FAM", ntag(fam))) {
		*pmsg = badfm0;
		return FALSE;
	}
	if (nsibling(fam)) {
		*pmsg = badmul;
		return FALSE;
	}
	split_fam(fam, &husb, &wife, &chil, &rest);
	if (fam0 && !iso_list(fam, fam0)) {
		*pmsg = badfam; 
		join_fam(fam, husb, wife, chil, rest);
		return FALSE;
	}
	if (!iso_list(husb, husb0)) {
		*pmsg = badhsb;
		join_fam(fam, husb, wife, chil, rest);
		return FALSE;
	}
	if (!iso_list(wife, wife0)) {
		*pmsg = badwif;
		join_fam(fam, husb, wife, chil, rest);
		return FALSE;
	}
	if (!iso_list(chil, chil0)) {
		*pmsg = badchl;
		join_fam(fam, husb, wife, chil, rest);
		return FALSE;
	}
	join_fam(fam, husb, wife, chil, rest);
	return TRUE;
}
/*=============================
 * valid_name -- Validate name.
 *===========================*/
BOOLEAN valid_name (name)
STRING name;
{
	INT c, n = 0;
	while (c = *name++) {
		if (c == '/') n++;
	}
	return n == 2;
}
