/* Version 2.3.4 - controlled 24 June 1993 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "standard.h"
#include "btree.h"

/*--------------------------------------------------------------
 * addfile - add record to btree from the contents of a file
 *--------------------------------------------------------------
 */
BOOLEAN addfile (btree, rkey, file)
BTREE btree;	/* btree to be added to */
RKEY rkey;	/* record key of new record */
STRING file;	/* file that holds the new record */
{
	FILE *fp;
	STRING mem;
	struct stat buf;
/*printf("ADDFILE: rkey, file = %s, %s\n", rkey2str(rkey), file);/**/
	if ((fp = fopen(file, "r")) == NULL) {
/*printf("addfile: file does not exist\n");/**/
		return FALSE;
	}
	if (fstat(fileno(fp), &buf) != 0) {
/*printf("addfile: can't stat file\n");/**/
		fclose(fp);
		return FALSE;
	}
	if ((mem = (STRING) stdalloc(buf.st_size)) == NULL) {
/*printf("addfile: can't allocate memory");/**/
		fclose(fp);
		return FALSE;
	}
	if (fread(mem, buf.st_size, 1, fp) != 1) {
/*printf("addfile: can't read file");/**/
		fclose(fp);
		return FALSE;
	}
	addrecord(btree, rkey, mem, buf.st_size);
	stdfree(mem);
	fclose(fp);
	return TRUE;
}

/*--------------------------------------------------------------
 * getfile - get a record from btree and write to file
 *--------------------------------------------------------------
 */
BOOLEAN getfile (btree, rkey, file)
BTREE btree;	/* btree to retrieve record from */
RKEY rkey;	/* record key of record to retrieve */
STRING file;	/* file to write the record to */
{
	FILE *fp;
	INT len;
	RECORD record = getrecord(btree, rkey, &len);

	if (record == NULL) {
/*printf("there is no record with key %s\n", rkey2str(rkey));/*DEBUG*/
		return FALSE;
	}
	if ((fp = fopen(file, "w")) == NULL) {
/*printf("cannot open file to write the record in");/*DEBUG*/
		stdfree(record);
		return FALSE;
	}
	if (fwrite(record, len, 1, fp) != 1) {
/*printf("cannot write the record in the file");/*DEBUG*/
		stdfree(record);
		fclose(fp);
		return FALSE;
	}
	stdfree(record);
	fclose(fp);
	return TRUE;
}
