/*===================================================================
 * addkey.c -- This file contains the code needed to add a new key to
 *   a BTREE.
 * Copyright(c) 1991 by Thomas Trask Wetmore IV; all rights reserved.
 * Version 2.3.4 - controlled 24 June 1993
 *===================================================================
 */
#include "standard.h"
#include "btree.h"

/*=================================
 * addkey -- Adds a key to a BTREE.
 *===============================*/
addkey (btree, ikey, rkey, fkey)
BTREE btree;  /*btree handle*/
FKEY ikey;    /*index file key -- index to add the key to*/
RKEY rkey;    /*record key of the new entry*/
FKEY fkey;    /*file key of the new entry*/
{
	INDEX index;
	SHORT lo, hi;

/*wrintf("ADDKEY: ikey, rkey = %s, %s; ", fkey2path(ikey), rkey2str(rkey));
wrintf("fkey = %s\n", fkey2path(fkey));/*DEBUG*/
/*------------------------
 * Validate the operation.
 *----------------------*/
	if ((index = getindex(btree, ikey)) == NULL)
		FATAL();
	if (nkeys(index) >= NOENTS - 1)  FATAL();
/*-----------------------------------------------------------------
 * Search for the record key in the index -- it shouldn't be there.
 *---------------------------------------------------------------*/
	lo = 1;
	hi = nkeys(index);
	while (lo <= hi) {
		SHORT md = (lo + hi)/2;
		INT rel = strncmp(rkey.r_rkey, rkeys(index, md).r_rkey, 8);
		if (rel < 0)
			hi = --md;
		else if (rel > 0)
			lo = ++md;
		else
			FATAL();
	}
/*------------------------------------------
 * Add the new RKEY, FKEY pair to the index.
 *----------------------------------------*/
	for (hi = nkeys(index); hi >= lo; hi--) {
		rkeys(index, hi+1) = rkeys(index, hi);
		fkeys(index, hi+1) = fkeys(index, hi);
	}
	rkeys(index, lo) = rkey;
	fkeys(index, lo) = fkey;
	nkeys(index)++;
/*------------------------------------
 * If the index is now full, split it.
 *----------------------------------*/
	if (nkeys(index) >= NOENTS - 1) {
		INDEX newdex = crtindex(btree);
		SHORT n = NOENTS/2 - 1;
		nkeys(newdex) = nkeys(index) - n - 1;
		nkeys(index) = n;
		putindex(btree, index);
		for (lo = 0, hi = n + 1; hi < NOENTS; lo++, hi++) {
			rkeys(newdex, lo) = rkeys(index, hi);
			fkeys(newdex, lo) = fkeys(index, hi);
		}
		putindex(btree, newdex);
/*-------------------------------------------------------
 * Special case -- the split requires a new master index.
 *-----------------------------------------------------*/
		if (iself(index) == iself(bmaster(btree))) {
			INDEX master = crtindex(btree);
			nkeys(master) = 1;
			fkeys(master, 0) = ikey;
			rkeys(master, 1) = rkeys(newdex, 0);
			fkeys(master, 1) = iself(newdex);
			newmaster(btree, master);
			writeindex(bbasedir(btree), master);
		} else	
			addkey(btree, iparent(index), rkeys(newdex, 0),
				iself(newdex));
	} else
		putindex(btree, index);
}
