
static char rcsid[] = "@(#)$Id: atonum.c,v 5.1 1993/01/19 04:46:21 syd Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 5.1 $   $State: Exp $
 *
 * 			Copyright (c) 1993 USENET Community Trust
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Syd Weinstein, Elm Coordinator
 *	elm@DSI.COM			dsinc!elm
 *
 *******************************************************************************
 * $Log: atonum.c,v $
 * Revision 5.1  1993/01/19  04:46:21  syd
 * Initial Checkin
 *
 *
 ******************************************************************************/

#include <ctype.h>

/*
 * This is similar to atoi(), but it complains if the string
 * contains any non-numeric characters.  Returns the numeric
 * value on success, -1 on error.
 */
int atonum(str)
register char *str;
{
    register int value;

    if (*str == '\0')
	return -1;
    value = 0;
    while (isdigit(*str))
	value = (value*10) + (*str++ - '0');
    return (*str == '\0' ? value : -1);
}


#ifdef _TEST
#include <stdio.h>
main()
{
	char buf[1024];
	while (gets(buf) != NULL)
		printf("atonum(%s) = %d\n", buf, atonum(buf));
	putchar('\n');
	exit(0);
}
#endif

