/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 5.1 $   $State: Exp $
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Syd Weinstein, Elm Coordinator
 *	elm@DSI.COM			dsinc!elm
 *
 *******************************************************************************
 * $Log: aliasdb.c,v $
 * Revision 5.1  1992/12/20  05:14:05  syd
 * Initial checkin
 *
 *
 ******************************************************************************/

/** Alias interface with dbz routines.

	This code is shared with newalias and elm so that
  it is easier to do updates while in elm.  The routines in
  this file are interface routines between elm alias code,
  newalias, and listalias and the dbm routines.

**/

#include "headers.h"
#include <ctype.h>
#include "ndbz.h"

#ifdef BSD
#  include <sys/file.h>
#  undef tolower
#  undef toupper
#endif

#ifdef DEBUG
extern FILE *debugfile;
extern int  debug;
#endif

/* byte-ordering stuff */
#define	MAPIN(o)	((db->dbz_bytesame) ? (of_t) (o) : bytemap((of_t)(o), db->dbz_conf.bytemap, db->dbz_mybmap))
#define	MAPOUT(o)	((db->dbz_bytesame) ? (of_t) (o) : bytemap((of_t)(o), db->dbz_mybmap, db->dbz_conf.bytemap))

static of_t			/* transformed result */
bytemap(ino, map1, map2)
of_t ino;
int *map1;
int *map2;
{
	union oc {
		of_t o;
		char c[SOF];
	};
	union oc in;
	union oc out;
	register int i;

	in.o = ino;
	for (i = 0; i < SOF; i++)
		out.c[map2[i]] = in.c[map1[i]];
	return(out.o);
}

read_one_alias(db, ar)
DBZ *db;
struct alias_rec *ar;
{
/*
 *	Read an alias (name, address, etc.) from the data file
 */

	FILE *data_file = db->dbz_basef;

	if (data_file == NULL)
	    return(0);	/* no alias file, but hash exists, error condition */

	if (fread((char *) ar, sizeof(struct alias_rec), 1, data_file) <= 0)
	    return(0);

	ar->status = (int) MAPIN(ar->status);
	ar->alias = (char *) MAPIN(ar->alias);
	ar->last_name = (char *) MAPIN(ar->last_name);
	ar->name = (char *) MAPIN(ar->name);
	ar->comment = (char *) MAPIN(ar->comment);
	ar->address = (char *) MAPIN(ar->address);
	ar->type = (int) MAPIN(ar->type);
	ar->length = (long) MAPIN(ar->length);

	return(1);
}
