#include "EXTERN.h"
#include <wafe.h>
#include "perl.h"
#include "XSUB.h"

XS(XS_wafe_wafe_cmd)
{
    dXSARGS;
    if (items != 1) {
	croak("Usage: wafe::cmd(cmd)");
    }
    {
	char *	cmd = (char *)SvPV(ST(0),na);
	char *	RETVAL;
	    wafeEval( wafeInterpreter, cmd, "perl");
	    RETVAL =  wafeInterpreter->result;
            ST(0) = sv_newmortal();
            sv_setpv((SV*)ST(0), RETVAL);
    }
    XSRETURN(1);
}

XS(XS_wafe_wafe_set)
{
    dXSARGS;
    if (items != 2) {
	croak("Usage: wafe::set(var,value)");
    }
    {
	char *	var = (char *)SvPV(ST(0),na);
	char *	value = (char *)SvPV(ST(1),na);
	   Tcl_SetVar(wafeInterpreter, var, value, TCL_GLOBAL_ONLY);
    }
    XSRETURN(1);
}

XS(XS_wafe_wafe_process_events)
{
    dXSARGS;
    if (items != 0) {
	croak("Usage: wafe::process_events()");
    }
    {
	  wafeProcessEvents();
    }
    XSRETURN(1);
}

XS(boot_wafe)
{
    dXSARGS;
    char* file = __FILE__;

    newXS("wafe::cmd", XS_wafe_wafe_cmd, file);
    newXS("wafe::set", XS_wafe_wafe_set, file);
    newXS("wafe::process_events", XS_wafe_wafe_process_events, file);

    /* Initialisation Section */

	    init_wafe();


    /* End of Initialisation Section */

    ST(0) = &sv_yes;
    XSRETURN(1);
}
