proc XbaeCaption-type {} { return {creationCommand Widget}}
set wafeHelp(XbaeCaption) { The 'XbaeCaption' widget class is a simple Motif manager widget
 used to associate an XmLabel (caption) with it's single child. The
 label may be either an XmString or Pixmap and can be displayed in
 any one of twelve positions around the perimeter of the
 child. XbaeCaption's geometry management technique is to simply
 "shrink wrap" it's child and display the caption alongside it.  By
 using XbaeCaption with an XmFrame child, groups of related widgets
 can be labeled similarly to the IBM CUA "Group Box", but with more
 flexibility.  XbaeCaption is also useful for associating labels
 with individual XmTextField widgets.}

proc XbaeMatrix-type {} { return {creationCommand Widget}}
set wafeHelp(XbaeMatrix) { The 'XbaeMatrix' widget class is a Motif widget which presents an
 editable array of string data to the user in a scrollable table
 similar to a spreadsheet. The rows and columns of the Matrix may
 optionally be labeled. Also, a number of "fixed" leading rows or
 columns may be specified - these behave similarly to the
 labels. While XbaeMatrix looks and acts like a grid of XmTextField
 widgets, it actually contains only one XmTextField.  This means
 that XbaeMatrix widgets with hundreds or thousands of rows have
 much less overhead than they would if they used an XmTextField for
 each cell. XbaeMatrix has callbacks for doing field validation and
 customizing traversal. It allows cells to be assigned independent
 colors.  It allows rows, columns and regions of cells to be
 selected (highlighted).  The matrix can be dynamically grown or
 shrunk by adding and deleting rows and columns at any position.
 Special percentcode subsititutions are performed for listed callbacks:
    %r: row
        enterCellCallback, leaveCellCallback, traverseCellCallback, selectCellCallback, modifyVerifyCallback
    %c: column
        enterCellCallback, leaveCellCallback, traverseCellCallback, selectCellCallback, modifyVerifyCallback
    %s: value
        leaveCellCallback
    %R: next row
        traverseCellCallback
    %C: next column
        traverseCellCallback
    %i: position of insert cursor
        modifyVerifyCallback
    %n: new position of cursor
        modifyVerifyCallback
    %f: startPos (from)
        modifyVerifyCallback
    %t: endPos (to)
        modifyVerifyCallback
    %s: text
        modifyVerifyCallback}

proc XbaeMatrixAddEmptyColumns-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {const: NULL} {const: NULL} {const: NULL} {const: NULL} {const: NULL} {const: NULL} {const: NULL} {in: int} ## {Xbae Matrix Widget} {position} {columns} {labels} {widths} {max_lengths} {alignments} {label alignments} {colors} {number of columns to be insterted}}}

proc XbaeMatrixAddEmptyRows-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {const: NULL} {const: NULL} {const: NULL} {in: int} ## {Xbae Matrix Widget} {position} {rows} {labels} {pixels} {number of rows to be insterted}}}

proc XbaeMatrixCancelEdit-type {} { return {function {void} {in: XbaeMatrixWidget} {in: Boolean} ## {Xbae Matrix Widget} {umap after canel?}}}

proc XbaeMatrixCommitEdit-type {} { return {function {void} {in: XbaeMatrixWidget} {in: Boolean} ## {Xbae Matrix Widget} {umap after canel?}}}

proc XbaeMatrixDeleteColumns-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {in: int} ## {Xbae Matrix Widget} {position} {number of columns to be deleted}}}

proc XbaeMatrixDeleteRows-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {in: int} ## {Xbae Matrix Widget} {position} {number of rows to be deleted}}}

proc XbaeMatrixDeselectAll-type {} { return {function {void} {in: XbaeMatrixWidget} ## {Xbae Matrix Widget}}}

proc XbaeMatrixDeselectColumn-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} ## {Xbae Matrix Widget} {column}}}

proc XbaeMatrixDeselectCell-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {in: int} ## {Xbae Matrix Widget} {row} {column}}}

proc XbaeMatrixDeselectRow-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} ## {Xbae Matrix Widget} {row}}}

proc XbaeMatrixEditCell-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {in: int} ## {Xbae Matrix Widget} {row} {column}}}

proc XbaeMatrixGetCell-type {} { return {function {String} {in: XbaeMatrixWidget} {in: int} {in: int} ## {Xbae Matrix Widget} {row} {column}}}

proc XbaeMatrixSelectRow-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} ## {Xbae Matrix Widget} {row}}}

proc XbaeMatrixSelectColumn-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} ## {Xbae Matrix Widget} {column}}}

proc XbaeMatrixSetCell-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {in: int} {in: String} ## {Xbae Matrix Widget} {row} {column} {value}}}

proc XbaeMatrixSetCellColor-type {} { return {function {void} {in: XbaeMatrixWidget} {in: int} {in: int} {in: Pixel} ## {Xbae Matrix Widget} {row} {column} {value}}}

proc XbaeEnterCellCBset-type {} { return {function {} {in: Boolean} ## {doit}}}

proc XbaeLeaveCellCBset-type {} { return {function {} {in: Boolean} ## {doit}}}

proc XbaeTraverseCellCBset-type {} { return {function {} {in: int} {in: int} ## {next row} {next column}}}

proc XbaeModifyVerifyCBset-type {} { return {function {} {in: Boolean} {in: long} {in: long} {in: long} {in: String} ## {doit} {currInsert or -1} {startPos or -1} {endPos or -1} {String}}}

