#! ../wafe --f

# In this example the toggle buttons 't1' and 't2' form a radio
# group. When the push button 'PressMe' is activated, the radio button
# 't1' will be set, if necessary, 't2' will be
# unset. XawToggleSetCurrent offers a conveniant way to activate a
# toggle buttons from a program.


mergeResources topLevel *t1.radioData a  *t2.radioData b *Command.width 150

Box b topLevel
  Label Toggles: b borderWidth 0
  Toggle t1 b
  Toggle t2 b radioGroup t1

  Command c1 b label "Set first Toggle"  callback {XawToggleSetCurrent t2 a}
  Command c2 b label "Set second Toggle" callback {XawToggleSetCurrent t2 b}
  Command c3 b label "Unset all Toggles" callback {XawToggleUnsetCurrent t2}
  Command quit b callback quit

realize

