/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Tue Nov  9 12:36:08 EST 1993 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef XMGRAPH

#define XMGRAPH_C

#include <stdio.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include "wafe.h"                             
#define ARC(w) (XmArcWidget)(w)

#include <Graph.h>
#include <Arc.h>
/* 
 * void
 * XmArcGetPos
 * 	in: ARC(XmArcWidget)			# name of arc Widget
 * 	out: Position				# out: x1
 * 	out: Position				# out: y1
 * 	out: Position				# out: x2
 * 	out: Position				# out: y2
 */

int 
com_mArcGetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER("mArcGetPos");  

     if (argc != 6) 
	 {
	 argcError("mArcGetPos","",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmArcWidgetClass,"XmArc")))
          {
          convError("mArcGetPos","1",argv[1],"XmArcWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmArcGetPos(ARC(localVar1),&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%hd", localVar2);
     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar3);
     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);
     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar5);
     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


#include <Graph.h>
/* 
 * void
 * XmGraphInsertRoots
 * 	in: XmGraphWidget   # XmGraphWidget
 * 	in: [Widget]        # List of Widgets
 *         const: argc-2
 */

int 
com_mGraphInsertRoots(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget * localVar2;

     DBUG_ENTER("mGraphInsertRoots");  

     if (argc < 3) 
	 {
	 argcError("mGraphInsertRoots","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmGraphWidgetClass,"XmGraph")))
          {
          convError("mGraphInsertRoots","1",argv[1],"XmGraphWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    Widget *ptr;
          argv += 2;
          localVar2 = ptr =
             (Widget *)XtMalloc((argc-2)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                  {
                  convError("mGraphInsertRoots","2",*argv,"Widget");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     XmGraphInsertRoots(localVar1,localVar2,argc-2);
     MMreplace(MMgetAttribList(localVar1),WafePermStringToQuark("mGraphInsertRoots"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_XmGraphGen()
{
#ifdef XMGRAPH
 createWidgetCommand("mArc",xmArcWidgetClass,NULL,False);
 createWidgetCommand("mGraph",xmGraphWidgetClass,NULL,False);
 createWidgetCommand("mScrolledGraph",xmGraphWidgetClass,XmCreateScrolledGraph,False);
#ifdef XMGRAPH
 strcat(wafePackages,"XMGRAPH ");
#endif
 Tcl_CreateCommand(wafeInterpreter, "mArcGetPos", com_mArcGetPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "mGraphInsertRoots", com_mGraphInsertRoots, NULL, NULL);

#else
#endif
}
