# tkutil.tcl - utility tcl routines
#



# return the name of the top level window for w, or "" if it is .

proc utilGetTopLevel {w} {
    set t [winfo toplevel $w]
    if {"$t" == "."} {
	return ""
    }
    return $t
}


# get the selection or return an empty string

proc utilGetSelection {} {
    set s ""
    catch {set s [selection get]} err
    return $s
}


# if the widget exists, make it visible and reconfigure it
# otherwise create it with the given options

proc utilReUseWidget {type w args} {
    if {[winfo exists $w]} {
	eval "$w config $args"
	wm deiconify $w
    } else {
	eval "$type $w $args"
    }
}


# temp: until Tk4.0

proc cget {w option} {
    return [lindex [$w config $option] 4]
}
