# LabelMessage.tcl - Itcl widget for displaying a label and a message
#
# Copyright (C) 1994 Allan Brighton (allan@piano.sta.sub.org)


itcl_class LabelMessage {
    inherit FrameWidget


    #  Get the value in the message

    method get {} {
	return [set value [lindex [$this.message config -text] 4]]
    }
   

    #  Get the value in the message, but don't reset the value member variable

    method get_ {} {
	return [lindex [$this.message config -text] 4]
    }


    # return true if the value has changed since it was last configured
    # or read (makes more sense in subclasses that change the value)

    method changed {} {
	return [expr {"[get_]" != "$value"}]
    }
   

    # constructor: create a new LabelMessage widget

    constructor {config} {
	FrameWidget::constructor

	pack [label $this.label] \
	    -side $side -ipadx 1m
	pack [message $this.message -relief $relief -anchor w] \
	    -side $side -expand 1 -fill x -padx 1m -ipadx 1m

	set initialized_ 1

	#  Explicitly handle config's that may have been ignored earlier
	foreach attr $config {
	    config -$attr [set $attr]
	}
    }

   
    # -- public variables --


    # set the text message's label
    public text {} {
	if {$initialized_} {
	    $this.label config -text $text
	}
    }

    # set the value in the message
    public value {} {
	if {$initialized_} {
	    $this.message config -text $value
	}
    }


    # set the width for  displaying the label (in chars)
    public labelWidth {} {
	if {$initialized_} {
	    $this.label config -width $labelWidth
	}
    }
    
    # set the width for displaying the value (in GetPixels(3))
    # see the message man page for details
    public valueWidth {} {
	if {$initialized_} {
	    $this.message config -width $valueWidth
	}
    }
    
    # set the font for  displaying the label
    public labelFont {} {
	if {$initialized_} {
	    $this.label config -font $labelFont
	}
    }
    
    # set the font for displaying the value
    public valueFont {} {
	if {$initialized_} {
	    $this.message config -font $valueFont
	}
    }
    
    # set the background color
    public bg {} {
	if {$initialized_} {
	    $this.message config -bg $bg
	    $this.label config -bg $bg
	}
    }
    
    # set the message relief 
    public relief {flat} {
	if {$initialized_} {
	    $this.message config -relief $relief
	}
    }
    

    # set the message aspect 
    public aspect {} {
	if {$initialized_} {
	    $this.message config -aspect $aspect
	}
    }
    
    
    # set the label anchor (the message follows)
    public anchor {} {
	if {$initialized_} {
	    $this.label config -anchor $anchor
	}
    }
    

    # pack option: use left for horizontal orient, top for vert.
    public side {left}

    
    # -- protected vars --

    # set to 1 in constructor
    protected initialized_ 0
}

