### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


proc setup {} {
  global setup temp widget2Help saveInfo 

  if {[winfo exists .setup]} {
    raise .setup
    wm deiconify .setup
    return
  }
  toplevel .setup

  foreach var {file print whatToGenerate generateDefault
    saveOnGenerate placeWindows} {
    set temp($var) $setup($var)
  }
  
  label .setup.label -text "Setup"
  pack .setup.label

  frame .setup.filename
  pack .setup.filename -expand 1 -fill both
  set i 0
  foreach elm $setup(dotfile) {
    pack [frame .setup.filename.$i] -expand 1 -fill x
    label .setup.filename.$i.label -text [lindex $elm 1]
    entry .setup.filename.$i.entry -textvariable temp(dotfile$i) \
	-bd 2 -relief sunken
    label .setup.filename.$i.label2 -text "Comment character: "
    entry .setup.filename.$i.commentChar -textvariable temp(commentChar$i)\
	-width 5
    pack .setup.filename.$i.label .setup.filename.$i.entry \
	.setup.filename.$i.label2 .setup.filename.$i.commentChar -side left
    set temp(dotfile$i) [lindex $elm 2]
    set temp(commentChar$i) [lindex $elm 3]
    incr i
  }

  frame .setup.save
  pack .setup.save -expand 1 -fill x
  checkbutton .setup.save.1 -text "Generate to file" \
      -variable temp(file) -anchor w 
  checkbutton .setup.save.2 -text "Print" \
      -variable temp(print) -anchor w 
  pack .setup.save.1 .setup.save.2 -fill x -side left -fill x -expand 1
  
  checkbutton .setup.whatTosave -text "Generate defaults too" \
      -variable temp(generateDefault) -anchor w

  pack [frame .setup.whatToGen] -expand 1 -fill x
  radiobutton .setup.whatToGen.onePage -variable temp(whatToGenerate) \
      -value one -text "One page"
  radiobutton .setup.whatToGen.selected -variable temp(whatToGenerate) \
      -value selected -text "Selected pages"
  radiobutton .setup.whatToGen.all -variable temp(whatToGenerate) \
      -value all -text "All pages"
  pack .setup.whatToGen.onePage .setup.whatToGen.selected .setup.whatToGen.all\
      -side left
  
  checkbutton .setup.saveOnGenerate -text "Save when generating" \
      -variable temp(saveOnGenerate) -anchor w
  pack .setup.whatTosave .setup.saveOnGenerate -fill both -expand 1

  ### place windows
  checkbutton .setup.place -text "Place windows" \
      -variable temp(placeWindows) -anchor w
  pack .setup.place -fill both -expand 1
  
  frame .setup.buttons
  pack .setup.buttons -expand 1 -fill x
  button .setup.buttons.ok -text "OK" -command {
    foreach var {file print whatToGenerate generateDefault saveOnGenerate
      placeWindows} {
      set setup($var) $temp($var)
    }
    set i 0
    set new {}
    foreach elm $setup(dotfile) {
	lappend new [list [lindex $elm 0] [lindex $elm 1] \
			 $temp(dotfile$i) $temp(commentChar$i)]
	set fileHandles([lindex $elm 0]) $temp(dotfile$i)
	incr i
    }
    set setup(dotfile) $new
    setWhatToGenerate
    catch "destroy .setup"
  }
  button .setup.buttons.cancel -text "CANCEL" -command {
    catch "destroy .setup"
  }
 
  pack .setup.buttons.ok .setup.buttons.cancel -side left -fill x -expand 1
  bind .setup <3> "generalHelp Setup"
}
