############################################################
# cut an element from an extended entry to the clipboard
############################################################
proc extEntryCut {path prefix name row} {
  global scrollValue editInfo children 

  set function $editInfo(name)
  
  ### first of all copy the entry
  extEntryCopy $path $prefix $name $row

  ### move all elements one down
  moveElm -1 $prefix $name $row

  ### erasing the last element

  ### ordanary variables
  set actualRow [expr [lindex $scrollValue(${prefix}_$name) 0]-1]
  foreach varname [uplevel \#0 "info vars ${prefix}_$name${actualRow}_*"] {
    upvar \#0 $varname var
    if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${row}_"
    }
    unset var
  }
  ### the state variable
  foreach varname [array names state ${prefix}_$name${actualRow}_*] {
    if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${actualRow}_"
    }
    unset state($varname)
  }
  ### the scrollValue variable
  foreach varname [array names scrollValue ${prefix}_$name${actualRow}_*] {
    if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${actualRow}_"
    }
    unset scrollValue($varname)
  }
  ### the fillList variable
  foreach varname [array names fillList ${prefix}_$name${actualRow}_*] {
    if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${actualRow}_"
    }
    unset fillList($varname)
  }

  foreach child $children(${function}__$name) {
    setVariable $child ${prefix}_$name$actualRow {}
  }

  ### Telling the scrollbar that there's one less element
  set totalUnit  [lindex $scrollValue(${prefix}_$name) 0]
  set windowUnit [lindex $scrollValue(${prefix}_$name) 1]
  set firstUnit  [lindex $scrollValue(${prefix}_$name) 2]
  set lastUnit   [lindex $scrollValue(${prefix}_$name) 3]

  if {$totalUnit-1 == $lastUnit && $firstUnit != 0} {
    set scrollValue(${prefix}_$name) "[max  $windowUnit [expr $totalUnit-1]] $windowUnit [expr $firstUnit-1] [expr $lastUnit-1]"
  } else {
    set scrollValue(${prefix}_$name) "[max  $windowUnit [expr $totalUnit-1]] [lrange $scrollValue(${prefix}_$name) 1 end]"
  }
  
  ### packing the extentry again, so state and scrollValue will be updated.
  Pack $path $prefix $name 0
}

############################################################
# copy and element from an extended entry to the clipboard
############################################################
proc extEntryCopy {path prefix name row} {
  global clipboardName state scrollValue fillList
  set clipboardName $name

  ### erasing old variables
  foreach varname [uplevel \#0 "info vars clipboard_*"] {
    uplevel \#0 "unset $varname"
  }
  foreach varname [array names state clipboard_*] {
    unset state($varname)
  }
  foreach varname [array names scrollValue clipboard_*] {
    unset scrollValue($varname)
  }
  
  ### copying the ordanary variables
  foreach varname [uplevel \#0 "info vars ${prefix}_$name${row}_*"] {
    upvar \#0 $varname var
    if {![regexp "^${prefix}_$name${row}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${row}_"
    }
    upvar \#0 clipboard_$lastname clipboard
    set clipboard $var
  }

  ### copying the variable state
  foreach varname [array names state ${prefix}_$name${row}_*] {
    if {![regexp "^${prefix}_$name${row}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${row}_"
    }
    set state(clipboard_$lastname) $state($varname)
  }

  ### copying the variable scrollValue
  foreach varname [array names scrollValue ${prefix}_$name${row}_*] {
    if {![regexp "^${prefix}_$name${row}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${row}_"
    }
    set scrollValue(clipboard_$lastname) $scrollValue($varname)
  }
  ### copying the variable fillList
  foreach varname [array names fillList ${prefix}_$name${row}_*] {
    if {![regexp "^${prefix}_$name${row}_(.*)\$" $varname all lastname]} {
      error "Couldn't match $varname with ${prefix}_$name${row}_"
    }
    set fillList(clipboard_$lastname) $fillList($varname)
  }
}

############################################################
#     insert into an extended entry from the clipboard
############################################################
proc extEntryPaste {path prefix name row} {
  global scrollValue state fillList

  ### move all element one up
  moveElm +1 $prefix $name $row

  ### inserting the element from the clipboad
  
  ### first ordanary variables
  set count [lindex $scrollValue(${prefix}_$name) 0]
  foreach varname [uplevel \#0 "info vars clipboard_*"] {
    upvar \#0 $varname clipboard
    if {![regexp {^clipboard_(.*)$} $varname all lastname]} {
      error "Couldn't match $varname with clipboard_"
    }
    upvar \#0 ${prefix}_$name${row}_$lastname var
    set var $clipboard
  }

  ### the state variable
  foreach varname [array names state clipboard_*] {
    if {![regexp {^clipboard_(.*)$} $varname all lastname]} {
      error "Couldn't match $varname with clipboard_"
    }
    set state(${prefix}_$name${row}_$lastname) $state(clipboard_$lastname)
  }
  ### the scrollValue variable
  foreach varname [array names scrollValue clipboard_*] {
    if {![regexp {^clipboard_(.*)$} $varname all lastname]} {
      error "Couldn't match $varname with clipboard_"
    }
    set scrollValue(${prefix}_$name${row}_$lastname) \
	$scrollValue(clipboard_$lastname)
  }
  ### the fillList variable
  foreach varname [array names fillList clipboard_*] {
    if {![regexp {^clipboard_(.*)$} $varname all lastname]} {
      error "Couldn't match $varname with clipboard_"
    }
    set fillList(${prefix}_$name${row}_$lastname) $fillList(clipboard_$lastname)
  }

  ### Telling the scrollbar that there's one more element
  set scrollValue(${prefix}_$name) "[expr $count+1] [lrange $scrollValue(${prefix}_$name) 1 end]"

  ### packing the extentry again, so state and scrollValue will be updated.
  Pack $path $prefix $name 0
}

############################################################
#       insert a blank tuple into an extended entry
############################################################
proc extEntryInsert {path prefix name row} {
  global scrollValue children editInfo initFunc changeElm activeNivau
  
  moveElm +1 $prefix $name $row
  
  set count [lindex $scrollValue(${prefix}_$name) 0]
  set function $editInfo(name)

  ### Telling the scrollbar that there's one more element
  set scrollValue(${prefix}_$name) "[expr $count+1] [lrange $scrollValue(${prefix}_$name) 1 end]"

  foreach child $children(${function}__$name) {
    setVariable $child ${prefix}_$name$row {}
  }

  # calling the init or change function
  set childs $children(${function}__$name)
  UpdateActive [lindex $childs 0] ${prefix}_$name$row
  if {[info exists initFunc($function)]} {
    set changeElm $name
    uplevel \#0 $initFunc($function)
  } else {
    set activeNivau($name) $row
    foreach child $childs {
      changeAll $child
    }
  }

  ### packing the extentry again, so state and scrollValue will be updated.
  Pack $path $prefix $name 0
}

############################################################
# This function move the element in an extentry one up or
# one down, from an element to the end.
############################################################
proc moveElm {direction prefix name row} {
  global scrollValue state fillList changed

  set changed 1; # the configuration page has changed
  
  set count [lindex $scrollValue(${prefix}_$name) 0]

  if {$direction == -1} {
    # copi things downwards (removed an element)
    set actualRow [expr $row+1]
    set test {$actualRow < $count}
  } else {
    # copy things upwards (inserted an element)
    set actualRow [expr $count-1]
    set test {$actualRow >= $row}
  }
  set d $direction
  
  for {} {[expr $test]} {incr actualRow [expr -$direction]} {
    ### ordanary variables
    foreach varname [uplevel \#0 "info vars ${prefix}_$name[expr $actualRow + $d]_*"] {
      uplevel \#0 unset $varname
    }
    foreach varname [uplevel \#0 "info vars ${prefix}_$name${actualRow}_*"] {
      upvar \#0 $varname from
      if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
	error "Couldn't match $varname with ${prefix}_$name${actualRow}_"
      }
      upvar \#0 ${prefix}_$name[expr $actualRow+$d]_$lastname to
      set to $from
    }
    ### the state variable
    foreach varname [array names state ${prefix}_$name${actualRow}_*] {
      if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
	error "Couldn't match $varname with ${prefix}_$name${actualRow}_"
      }
      set state(${prefix}_$name[expr $actualRow+$d]_$lastname) $state($varname)
    }
    ### the scrollValue variable
    foreach varname [array names scrollValue ${prefix}_$name${actualRow}_*] {
      if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
	error "Couldn't match $varname with ${prefix}_$name${actualRow}_"
      }
      set scrollValue(${prefix}_$name[expr $actualRow+$d]_$lastname) \
	  $scrollValue($varname)
    }
    ### the fillList variable
    foreach varname [array names fillList ${prefix}_$name${actualRow}_*] {
      if {![regexp "^${prefix}_$name${actualRow}_(.*)\$" $varname all lastname]} {
	error "Couldn't match $varname with ${prefix}_$name${actualRow}_"
      }
      set fillList(${prefix}_$name[expr $actualRow+$d]_$lastname) $fillList($varname)
    }
  }
}
