#
# $Header: /home/rockware/cvs-main/operator/tcl/opDirTree.tcl,v 1.40 1995/03/16 12:43:20 erez Exp $
# Written by: Erez Strauss (C) All Rights Reserved 1994, 1995.
#
# 3. Directory Trees handling functions.
# Written by: Erez Strauss (C), 1994.
#
itcl_class OpDirTree {
    inherit OpDirDisplay
    constructor {directory config} {
        if $files_flag {set f {-f}} {set f {}}
        
        set tmp_menus "$tl_menus $dird_menus $dt_menus"

        OpDirDisplay::constructor $directory \
            -menus $tmp_menus \
            -menu_bar $dt_menubar \
            -iconbitmap tree \
            -pipe_cmd "[opNameToFile srtree prog] $f -d \$depth ."

        set ws $work_space.i
        set canvas $ws.u.c
        frame $ws -relief flat
        ::pack $ws -expand on -fill both
        OpSCanvas :: create $ws

        # *** remove the active help bind - use the OpTopLevel::active_help.
        opActiveHelpBind $this "Directory Tree - $this"
        bind $canvas <Double-1> "+$this canvas_select %x %y"
        $canvas bind all <1> "+if {\[string match \[$canvas type current] text]} {
            $canvas select from current 0
            $canvas select to current end
        }
        "
        opLabeledEntry $work_space.dpth {Tree depth} {} 5
        bind $work_space.dpth.entry <Key-Return> \
            "$this config -depth \[$work_space.dpth.entry get]"

        if $depth_display { 
            ::pack $work_space.dpth -before $work_space.i -fill x -side bottom
        }

        blt_drag&drop source $canvas config \
            -button 3 \
            -packagecmd "$this dd_pkg" \
            -send all \
            -sitecmd "$this dd_valid" \
            -tokenanchor nw \
            -selftarget true

        blt_drag&drop source $canvas handler \
            file_name "$this dd_send_file"

        global OPDirTree
        set OPDirTree($this,depth) $depth_display
        set OPDirTree($this,files) $files_flag

        ::update
        update
        ::update
    }
    destructor {
        OpDirDisplay::destructor
    }
    method config config {}

    method disp_start {} {
        label $this.title.pw -text "Please wait" -relief raised -bg red \
            -foreground black -borderwidth 1
        ::pack $this.title.pw -side right
        OpTopLevel :: cursor_all watch
        set x 0
        set y 20
        set to_update 0
        $canvas delete all
        ::update
    }
    # No comments inside this function as it is called many times.
    method disp_entry entry {
        set x [expr $colWidthPix * ( [llength [split $entry /]] - 1 ) + 10]
        set d [file dirname $entry]
        set base [file tail $entry]
        $canvas create text $x $y -anchor w -fill black -text $base -tag $entry
        if {$entry != "." && [set bx [$canvas coords $d]] != {}} {
            set by [lindex $bx 1]
            set bx [lindex $bx 0]
            set bx [expr $bx+15.0]
            set by [expr $by+5.0]
            set x  [expr $x-3.0]
            $canvas create line $x $y    $bx $y    $bx $by
        }
        incr y 14
        if {$to_update > 10} {
            OpSCanvas :: update $work_space.i
            set to_update 0
            ::update
        } {incr to_update}
    }
    method disp_end {} {
        OpTopLevel :: cursor_all
        ::pack forget $this.title.pw
        destroy $this.title.pw
        OpSCanvas :: update $work_space.i
        ::update
        if {[$canvas find all] == {}} {.fileEmptyDisplay on}
    }
    method canvas_select {x y} {
        set cur [$canvas find withtag current]
        if {[string match [$canvas type $cur] text]} {
            set tag [lindex [lindex [$canvas itemconf $cur -tag] 4] 0]
            if [file isdirectory $dir/$tag] {
                if $open_new_win {
                    OpDirTree :: open $dir/$tag
                } {
                    $this move_to_dir $dir/$tag
                }
            } {
                opFileActivate $dir/$tag
            }
        }
    }
    method canv {} {return $canvas}
    method what_label {} {return DirTree}


    method dd_pkg token {
        if {[winfo children $token] == {}} {
            label $token.value
            ::pack $token.value
        }
        set cur [$canvas find withtag current]
        if ![string match [$canvas type $cur] text] {
            return {}
        }
        set file [lindex [lindex [$canvas itemconf $cur -tag] 4] 0]

        # should be bitmap with file or directory.
        # $token.value config -text "$this - $type - $file"
        # puts "Source from '$this', $dir / $file."
        return [what_dir]/[string range $file 2 end]
    }

    proc open {d {f 0}} {
        set swd [pwd]
        if ![file isdirectory $d] {set d [file dirname $d]}
        cd $d
        set d [pwd]
        cd $swd
        if [::info exists dir2obj(OpDirTree,$d)] {
            $dir2obj(OpDirTree,$d) raise
            return
        }
        incr serial_number
        if $f {
            OpDirTree .dir_tree$serial_number $d -files_flag 1
        } {
            OpDirTree .dir_tree$serial_number $d
        }
    }
    public depth 0 {
        if $after_constructor {
            if $files_flag {set f {-f}} {set f {}}
            set pipe_cmd "[opNameToFile srtree prog] $f -d $depth ."
            update
        }
    }
    public depth_display 1 {
        if $after_constructor {
            if $depth_display {
                ::pack $work_space.dpth -before $work_space.i -fill x -side bottom
            } {
                ::pack forget $work_space.dpth
            }   
        }
    }
    public files_flag 0 {
        if $after_constructor {
            if $files_flag {set f {-f}} {set f {}}
            set pipe_cmd "[opNameToFile srtree prog] $f -d $depth ."
            update
        }
    }
    protected canvas {}
    protected x 0
    protected y 0
    protected to_update 0
    protected colWidthPix 40
    # 5*8
    common serial_number 0

    common dt_menus {
        {dt_view {
            {checkbutton -label {Show Filter} -onvalue 1 -offvalue 0 -variable OPDirDisplay(THIS,filter) -command {global OPDirDisplay ; THIS config -disp_filter_flag $OPDirDisplay(THIS,filter)}}
            {checkbutton -label {Dir Entry} -onvalue 1 -offvalue 0 -variable OPDirDisplay(THIS,dir_disp) -command {global OPDirDisplay ; THIS config -disp_dir_flag $OPDirDisplay(THIS,dir_disp)}}
            {checkbutton -label {Show Depth} -onvalue 1 -offvalue 0 -variable OPDirTree(THIS,depth) -command {global OPDirTree ; THIS config -depth_display $OPDirTree(THIS,depth)}}
            {checkbutton -label {With Files} -onvalue 1 -offvalue 0 -variable OPDirTree(THIS,files) -command {global OPDirTree ; THIS config -files_flag $OPDirTree(THIS,files)}}
            {checkbutton -label {New Win} -onvalue 1 -offvalue 0 -variable OPDirDisplay(new_win) -command {global OPDirDisplay ; [THIS info class] :: set_new_win $OPDirDisplay(new_win)}}
            {command -label {Go Home} -under 0 -command {THIS move_to_dir [glob ~]}}
            {command -label {Move up ..} -under 0 -command {THIS move_to_dir [THIS what_dir]/..}}}
        }
    }
    common dt_menubar {{File 0 dird_file} {Edit 0 dird_edit} {View 0 dt_view} {Windows 0 tl_wins} {Help 0 tl_help right}}
}
