# ~/.tk/edittkmodes/mh-mode.tcl - mode for composing mail in MH
######################################################################

global MODE
j:read_prefs -array MODEPREFS \
  -directory $HOME/.tk/jeditmodes -file ${MODE}-defaults {
  {textfont default}
  {textwidth 80}
  {textheight 24}
  {textwrap char}
  {sabbrev 0}
  {dabbrev 0}
  {autobreak 1}
  {autoindent 0}
  {savestate 0}
}

######################################################################
# special hooks:

proc jedit:post_read_hook { filename t } {
  set separator {}
  if [regexp -indices "\n-*\n" [$t get 0.0 end] separator] {
    set headerend [lindex $separator 0]
    $t tag add header 0.0 "0.0 + $headerend chars + 1 char"
    $t tag configure header -background LightBlue
    $t tag lower header
  }
}

######################################################################
# more procedures:

# deletesig w - delete the signature if it exists (and is tagged so):

proc deletesig {w} {
  catch {
    $w delete sig.first end
  }
}

proc insertsig {w} {
  global env
  deletesig $w
  set curr [$w index end]
  $w insert end "\n"
  $w insert end [exec cat $env(HOME)/.signature]
  $w insert end "\n"
  $w tag add sig $curr end
  $w tag configure sig -font {-*-courier-bold-r-normal--10-100-*}
  $w tag lower sig
}

proc startreply {w} {
  set reply [exec cat "@" | sed {1,/^$/d} | \
    sed {s/^>/  /} | sed {s/^/  /}]
  $w insert end $reply
}

proc whom {} {
  global FILENAME
  jedit:cmd:save
  j:more -height 10 -width 60 -title "Recipients" \
    -text [exec whom -check $FILENAME]
}

######################################################################
# define the MH menu:

if [winfo exists .menu.mh] {
  destroy .menu.mh
}

menubutton .menu.mh -text {MH} -menu .menu.mh.m

menu .menu.mh.m
.menu.mh.m add command -label {Start Reply} -command {startreply .main.t}
.menu.mh.m add command -label {Sign Email} -command {insertsig .main.t}
.menu.mh.m add command -label {List Recipients} -command {whom}
.menu.mh.m add command -label {Done} -command {jedit:cmd:save; exit}

pack append .menu .menu.mh left

######################################################################
# define the button bar:

frame .main.buttons

button .main.buttons.done -width 8 -text {Done} -command {jedit:cmd:save; exit}
button .main.buttons.whom -width 8 -text {Whom} -command {whom}
button .main.buttons.sign -width 8 -text {Sign} -command {insertsig .main.t}
button .main.buttons.reply -width 8 -text {Reply} -command {startreply .main.t}

pack append .main.buttons \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.done {right pady 10} \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.whom {right pady 10} \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.sign {right pady 10} \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.reply {right pady 10}

pack after .main.status .main.buttons {top fillx}

set rule [j:rule .main]			;# so we can use in jedit:mode_cleanup
pack after .main.status $rule {top fillx}

proc jedit:mode_cleanup {} "
  pack unpack .menu.mh
  destroy .menu.mh
  pack unpack .main.buttons
  destroy .main.buttons
  pack unpack $rule
  destroy $rule
  rename deletesig {}
  rename insertsig {}
  rename startreply {}
  rename whom {}
"
