# ~/.tk/edittkmodes/mail-mode.tcl - mode for composing mail
######################################################################

global MODE
j:read_prefs -array MODEPREFS \
  -directory $HOME/.tk/jeditmodes -file ${MODE}-defaults {
  {textfont default}
  {textwidth 80}
  {textheight 24}
  {textwrap char}
  {sabbrev 0}
  {dabbrev 0}
  {autobreak 1}
  {autoindent 0}
  {savestate 0}
}

######################################################################
# more procedures:

# deletesig w- delete the signature if it exists (and is tagged so):

proc deletesig {w} {
  catch {
    $w delete sig.first end
  }
}

proc insertsig {w} {
  global env
  deletesig $w
  set curr [$w index end]
  $w insert end "\n"
  $w insert end [exec cat $env(HOME)/.signature]
  $w insert end "\n"
  $w tag add sig $curr end
  $w tag configure sig -font {-*-courier-bold-r-normal--10-100-*}
  $w tag lower sig
}

######################################################################
# define the Mail menu:

if [winfo exists .menu.mail] {
  destroy .menu.mail
}

menubutton .menu.mail -text {Mail} -menu .menu.mail.m

menu .menu.mail.m
.menu.mail.m add command -label {Sign Email} -command {insertsig .main.t}
.menu.mail.m add command -label {Done} -command {jedit:cmd:save; exit}

pack append .menu .menu.mail left

######################################################################
# define the button bar:

frame .main.buttons

button .main.buttons.done -width 8 -text {Done} -command {jedit:cmd:save; exit}
button .main.buttons.sign -width 8 -text {Sign} -command {insertsig .main.t}
button .main.buttons.reply -width 8 -text {Reply} -command {startreply .main.t}

pack append .main.buttons \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.done {right pady 10} \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.sign {right pady 10}

pack after .main.status .main.buttons {top fillx}

set rule [j:rule .main]			;# so we can use in jedit:mode_cleanup
pack after .main.status $rule {top fillx}

proc jedit:mode_cleanup {} "
  pack unpack .menu.mail
  destroy .menu.mail
  pack unpack .main.buttons
  destroy .main.buttons
  pack unpack $rule
  destroy $rule
  rename deletesig {}
  rename insertsig {}
"
