# ~/.tk/jeditrc.tcl - user customisation file for edit.tk
######################################################################

######################################################################
# additions to GUI:

proc jedit:userhook {} {
  if [winfo exists .menu.user] {
    destroy .menu.user
  }
  .main.t tag configure hilight -background gold
  .main.t tag raise hilight				;# ????
  
  menubutton .menu.user -text {User} -menu .menu.user.m
  
  tk_menuBar .menu .menu.editor .menu.file .menu.abbrev .menu.pipe .menu.user
  
  menu .menu.user.m
  .menu.user.m add command -label {Hilight} -command {
    catch {
      .main.t tag add hilight sel.first sel.last
    }
  }
  .menu.user.m add command -label {Unhilight} -command {
    catch {
      .main.t tag remove hilight sel.first sel.last
    }
  }
  .menu.user.m add command -label {Clear All Hilights} -command {
    catch {
      .main.t tag remove hilight 1.0 end
    }
  }
  .menu.user.m add separator
  .menu.user.m add command -label {Source . . .} -command {
    source [j:fs {} {File to source:}]
  }
  .menu.user.m add command -label "C\346sar Cipher" -command {
    jedit:pipe "tr \
      abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ \
      nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM"
  }
  .menu.user.m add command -label {Insert Date} -command {
    .main.t insert insert \
    [exec date | awk "\{print \$2\" \"\$3\", \"\$6\}"]
  }
  .menu.user.m add command -label {Insert Colour Name} -command {
    .main.t insert insert \
    [j:prompt_colour_name]
  }
  .menu.user.m add command -label {Insert Colour RGB} -command {
    .main.t insert insert \
    [j:prompt_colour_rgb]
  }
  .menu.user.m add command -label {Insert Font Name} -command {
    .main.t insert insert \
    [j:prompt_font]
  }
  .menu.user.m add separator
  .menu.user.m add command -label {New xterm} -command {
    exec xterm &
  }
  .menu.user.m add command -label {New jbrowser} -command {
    exec jbrowser &
  }
  pack append .menu .menu.user right
}
