# jabout.tcl - procedures for dealing with rich text
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for nonprofit, noncommercial use.
# 
# 
# these procedures are required by
#     help.tk
#     edit.tk
#     browser.tk
#     people.tk
# they may be located in the file "~/.tk/jabout.tcl" (where they will
# be source'd by those applications on startup), or in the site-wide
# tk library directory, where they will be found (and loaded) by the
# default tk  unknown  procedure.
#
# IMPORTANT: the procedures in jabout.tcl also rely on procedures in
#   jlibrary.tcl and jrichtext.tcl
######################################################################

# j:about name richtext - create an about box containing richtext
# j:about:button aboutbox label richtext - add a button to an about box
# j:about_jay - return richtext describing me
# j:about_tktcl - return richtext describing Tk and Tcl

######################################################################
# j:about name richtext - create an about box containing richtext
######################################################################

proc j:about { name args } {
  j:parse_args {
    {title "About"}
  }
  set w $name			;# name of toplevel
  set richtext [lindex $args 0]
  
  set old_focus [focus]		;# so we can restore original focus
  
  if [winfo exists $w] {destroy $w}
  toplevel $w
  wm title $w $title
  
  text $w.t -width 65 -height 15 -bd 20
  j:rt text $w.t
  eval $richtext
  j:rt:done
  
  frame $w.b
  button $w.b.ok -text OK -width 8 -command "
    focus $old_focus
    destroy $w
  "
  frame $w.b.ok-border -relief sunken -borderwidth 1
  raise $w.b.ok
  pack $w.b.ok -in $w.b.ok-border -padx 2 -pady 2

  pack append $w.b \
    [j:filler $w.b] {left} \
    [j:filler $w.b] {right}
    
  pack $w.b.ok-border -side right -pady 10
  pack $w.t -in $w -side top -fill both
  pack [j:rule $w -width 200] -in $w -side top -fill x
  pack $w.b -in $w -side top -fill x
  
  j:dialogue $w			;# position in centre of screen

  focus $w
  bind $w <Key-Return> "$w.b.ok invoke"
}

######################################################################
# j:about:button aboutbox label richtext - add a button to an about box
######################################################################

proc j:about:button { aboutbox label richtext } {
  global j:about:button:count
    if {[info exists j:about:button:count]} then {
    set j:about:button:count [expr {${j:about:button:count} + 1}]
  } else {
    set j:about:button:count 0
  }

  set parent $aboutbox.b	;# name of frame with buttons
  set button $parent.${j:about:button:count}
  set border $button-border

  set min_width [expr {[string length $label] + 2}]
  set width [expr {$min_width > 8 ? $min_width : 8}]
  
  button $button -text $label -width $width \
    -command "j:rt text $aboutbox.t; $richtext; j:rt:done"
  frame $border
  raise $button
  pack $button -in $border -padx 2 -pady 2
  pack [j:filler $parent] $border -in $parent -side right
}
  
  

######################################################################
# j:about_jay - talk about myself
######################################################################

proc j:about_jay {} {
  return {
    j:rt:hl "Jay Sekora"
    j:rt:cr
    j:rt:tt "js@it.bu.edu"
    j:rt:cr
    j:rt:tt "http://www.bu.edu/DSG/js/home.html"
    j:rt:par
    j:rt:rm "I'm a Unix systems administrator at Boston University."
    j:rt:par
    j:rt:rm "I was a linguistics major in college.  "
    j:rt:rm "I like spicy food, Celtic folk music, bad puns, New England "
    j:rt:rm "contra dancing, and "
    j:rt:it "Winnie the Pooh."
  }
}

######################################################################
# j:about_tktcl - describe tk and tcl
######################################################################

proc j:about_tktcl {} {
  return {
    j:rt:hl "Tk and Tcl"
    j:rt:par
    j:rt:rm "This application is written in "
    j:rt:tt "wish"
    j:rt:rm ", a scripting shell for X Windows applications based on the "
    j:rt:rm "Tk toolkit, which in turn is based on the Tcl"
    j:rt:rm " language and scripting library, all amazingly useful tools "
    j:rt:rm "by John Ousterhout of Berkeley."
    j:rt:par
    j:rt:rm "The Internet newsgroup "
    j:rt:tt "comp.lang.tcl"
    j:rt:rm " is devoted to Tcl and related tools, and a Tk/Tcl FAQ "
    j:rt:rm "(`Frequently Asked Questions') is periodically posted.  "
    j:rt:rm "The latest distributions are available on the FTP site "
    j:rt:tt "ftp.cs.berkeley.edu"
    j:rt:rm ", and "
    j:rt:tt "harbor.ecn.purdue.edu"
    j:rt:rm " has the FAQ and user\255contributed scripts."
  }
}


