#!/usr/local/bin/wish -f
#
#
# NODES WINDOW 
#
#	

proc xNodes  {} {
    #
    # Set up high level window functions
    #

    global nodes_open

    catch {destroy .cNodes}
    toplevel .cNodes
    wm geometry .cNodes +200+200
    wm title .cNodes "NODES LIST"
    wm iconname .cNodes "NODES"
    wm minsize .cNodes 200 200

    #
    # Create top and botton slave widgets
    #
    message .cNodes.msg  \
	    -font -Adobe-helvetica-medium-r-normal--*-120* \
	    -aspect 600 -relief raised -bd 2 \
	    -text "This NODES window shows in tabular form all nodes. The originating \"heard\" station is shown in blue, \"unheard nodes\" are brown."

    frame .cNodes.bframe -relief raised -bd 2

    button .cNodes.quit -text "QUIT" -command {
	set nodes_open 0
	destroy .cNodes
    }


    pack .cNodes.msg -side top -fill both
    pack .cNodes.bframe -side top -fill both -expand yes
    pack .cNodes.quit -side left -expand yes \
	    -fill both  -pady 5




    #
    # Create canvas
    #
    scrollbar .cNodes.bframe.vscroll -relief sunken \
	    -command ".cNodes.bframe.c yview"
    canvas .cNodes.bframe.c -width 350 -height 300 \
	    -yscroll ".cNodes.bframe.vscroll set"

    pack .cNodes.bframe.vscroll -side right -fill y
    pack .cNodes.bframe.c -in .cNodes.bframe -expand yes -fill both


    # Initialize buttons
    make_buttons

    # Window open, ready to accept data
    set nodes_open 1

    # Display nodes if any
    nodes_insert
}





# This procedure initializes the buttons.

proc make_buttons {} {

# Set the initial position of button and the distance between buttons
    set col_position 0
    set row_position 0
    set row_skip 14

    #
    # Make columns for stations
    #
    .cNodes.bframe.c create text $col_position $row_position \
	    -text "     Station    Pks %   Lst Cmd     Age    Info" \
	    -anchor nw  -font -Adobe-courier-medium-r-normal--*-120*

    for {set i 0} {$i < 50} {incr i} {
	incr row_position $row_skip

	label .cNodes.bframe.c.$i \
		-relief flat \
		-font -Adobe-courier-medium-r-normal--*-120*

	.cNodes.bframe.c create window $col_position $row_position \
		-window .cNodes.bframe.c.$i -anchor nw
    }
    clear_buttons
}





# Buttons already created, now with this prodecure \
	initialize the buttons with text (i.e., a label #)

proc clear_buttons {} {

    for {set i 0} {$i < 50} {incr i} {
	.cNodes.bframe.c.$i config -fg black \
		-text [format "%02d." $i]
    }
}






# This procedure accepts node array from the main program \
	If new packet, append to bottom of list. \
	If update node packet, update list.

proc nodes_insert {} {

    global xNet_stopped \
	    node_hrd \
	    node_lcmd \
	    node_msg \
	    node_heard \
	    node_pcnt \
	    node_fhrd \
	    node_lhrd \
	    node_cnt \
	    node_arr \
	    pac_cnt \
	    n_a

    # Return if no nodes to display
    if {$xNet_stopped} {return}


    for {set i 0} {$i < $node_cnt} {incr i} {
	set age [expr $node_arr("$n_a,$i,$node_lhrd") \
		- $node_arr("$n_a,$i,$node_fhrd")]
	set age_hrs  [expr $age / 3600]
	set age_mins [expr ($age % 3600) / 60]
	set age_secs [expr $age - ($age_hrs * 3600) - ($age_mins * 60)]
	set pac_percent \
		[expr 100 * $node_arr("$n_a,$i,$node_pcnt") / $pac_cnt]

	set txt [format "%02d%10s%5s%4s%10s%3d:%02d:%02d %s" \
		$i $node_arr("$n_a,$i,$node_hrd") \
		$node_arr("$n_a,$i,$node_pcnt") $pac_percent \
		$node_arr("$n_a,$i,$node_lcmd") $age_hrs $age_mins \
		$age_secs $node_arr("$n_a,$i,$node_msg")]

	# Heard (originating) node unique color
	if {$node_arr("$n_a,$i,$node_heard") == "H"} {
	    set node_color "blue"
	} else {
	    set node_color "brown"
	}

	.cNodes.bframe.c.$i config -fg $node_color -text $txt
    }
}
