#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))


/*
 * rects_overlap
 *
 * do points-style rectangles {x0,y0, x1,y1} {X0,Y0, X1,Y1}
 * overlap ? If so return 1. If not return 0.
 */

#define RECTS_OVERLAP(x0,y0,x1,y1,X0,Y0,X1,Y1) \
    ((MAX(x0,X0)<MIN(x1,X1)) && (MAX(y0,Y0)<MIN(y1,Y1)))

int
rects_overlap(x0,y0,x1,y1, X0,Y0,X1,Y1)
    int x0,y0,x1,y1, X0,Y0,X1,Y1;
{
    return RECTS_OVERLAP(x0,y0,x1,y1,X0,Y0,X1,Y1);
}
