set RADIUS 10.0
set PI      3.14159265358979
set SphereID 1
set TextID 2

proc paintme {{w ".top"}} {
	global SphereID TextID RADIUS PI
	g_clipping 1

	g_font "futura.m"

	g_perspective 80.0  1.0  0.001  50.0
	g_lookat 13.0  13.0  8.0  0.0  0.0  0.0  0.0

	g_color black
	g_clear 

	makesphere
	maketext "Around the world in eighty days" $TextID

	 # draw the main one in cyan
	g_color cyan

	g_callobj $SphereID

	 # draw a smaller one outside the main one in white
	g_color white

	g_pushmatrix
	g_translate 0.0  [expr -1.4*$RADIUS]  [expr 1.4*$RADIUS]
	g_scale 0.3  0.3  0.3
	g_callobj $SphereID
	g_popmatrix

	 # scale the text
	g_boxfit [expr 2.0*$PI*$RADIUS]  [expr 0.25*$RADIUS] 31

	 # now write the text in rings around the main sphere
	g_color green
	g_callobj $TextID ;#showroundtext "Around the world in eighty days "

	g_color blue

	# note: that software text is rotated here as anything else would be
	# whether you use textang or rotate depends on what you are trying
	# to do. Experience is the best teacher here.
	g_rotate 90.0  x
	g_callobj $TextID ;#showroundtext "Around the world in eighty days "

	g_color red
	g_rotate 90.0  z
	g_callobj $TextID ;#showroundtext "Around the world in eighty days "
}

# showroundtext
# 
# draw string str wrapped around a circle in 3d
proc showroundtext {str} {
	global RADIUS TextID
	set inc [expr 360.0/[string length $str]]
	for {set i 0; set x 0} {$i<360} {set i [expr $i+$inc]; incr x 1} {
		g_pushmatrix
		 # find the spot on the edge of the sphere by making it 
		 # (0 0 0) in world coordinates
		g_rotate $i  y
		g_translate 0.0  0.0  $RADIUS
		g_move 0.0  0.0  0.0
		g_drawstr [string range $str $x $x]; # *str++
		g_popmatrix
	}
}

proc maketext {str id} {
    global RADIUS
    g_makeobj $id
	showroundtext $str
    g_closeobj
}

# makesphere
# create the sphere object

# makesphere
# create the sphere object
proc makesphere {} {
	global SphereID RADIUS PI
	g_makeobj $SphereID

	for {set i 0} {$i<180} {incr i 20} {
		g_pushmatrix
		g_rotate $i  y
		g_circle 0.0  0.0  $RADIUS
		g_popmatrix
	}

	g_pushmatrix
	g_rotate 90.0  x
	for {set a -90} {$a<90} {incr a 20} {
		set r [expr $RADIUS*[cos [expr $a*$PI/180.0]]]
		set z [expr -1*$RADIUS*[sin [expr $a*$PI/180.0]]]
		g_pushmatrix
		g_translate 0.0  0.0  $z
		g_circle 0.0  0.0  $r
		g_popmatrix
	}
	g_popmatrix
	g_closeobj 
}

source main.t
