MODULE assist;

%nolist;

%INCLUDE '/sys/ins/base.ins.pas';
%INCLUDE '/sys/ins/vfmt.ins.pas';
%INCLUDE '/sys/ins/pgm.ins.pas';
%INCLUDE '/sys/ins/pfm.ins.pas';

PROCEDURE disk_full;
VAR
    buff:   STRING;
BEGIN
    write( 'Disk is full.  Type Y when files are deleted. ' );        
    read( buff );

    IF ( buff[ 1 ] <> 'Y' ) AND ( buff[ 1 ] <> 'y' ) THEN
        pgm_$exit();
END;




PROCEDURE gc_interrupt;
VAR
    buff:   STRING;
BEGIN
    write( 'Interrupt during GC.  Exit (Y/N)? ' );        
    read( buff );

    IF ( buff[ 1 ] = 'Y' ) OR ( buff[ 1 ] = 'y' ) THEN
        pgm_$exit()
    ELSE
        pfm_$enable();
END;


{ **** Hack-o floating point }

PROCEDURE t_$fladd(IN a,b: DOUBLE; OUT c: DOUBLE);
BEGIN
    c := a + b;
END;

PROCEDURE t_$flsubtract(IN a,b: DOUBLE; OUT c: DOUBLE);
BEGIN
    c := a - b;
END;

PROCEDURE t_$flmultiply(IN a,b: DOUBLE; OUT c: DOUBLE);
BEGIN
    c := a * b;
END;

PROCEDURE t_$fldivide(IN a,b: DOUBLE; OUT c: DOUBLE);
BEGIN
    c := a / b;
END;

PROCEDURE t_$sin(IN a: DOUBLE; OUT b: DOUBLE);
BEGIN
    b := sin(a);
END;

PROCEDURE t_$cos(IN a: DOUBLE; OUT b: DOUBLE);
BEGIN
    b := cos(a);
END;

PROCEDURE t_$tan(IN a: DOUBLE; OUT b: DOUBLE);
BEGIN
    b := sin(a)/cos(a);
END;

PROCEDURE t_$atan(IN a: DOUBLE; OUT b: DOUBLE);
BEGIN
    b := arctan(a);
END;
                    
PROCEDURE t_$exp(IN a: DOUBLE; OUT b: DOUBLE);
BEGIN
    b := exp(a);
END;

PROCEDURE t_$log(IN a: DOUBLE; OUT b: DOUBLE);
BEGIN
    b := ln(a);
END;

PROCEDURE t_$sqrt(IN a: DOUBLE; OUT b: DOUBLE);
BEGIN
    b := sqrt(a);
END;

FUNCTION t_$flless(IN a,b: DOUBLE): INTEGER;
BEGIN
    IF (a < b) THEN t_$flless := 1 ELSE t_$flless := 0;
END;

FUNCTION t_$flequal(IN a,b: DOUBLE): INTEGER;
BEGIN
    IF (a = b) THEN t_$flequal := 1 ELSE t_$flequal := 0;
END;

FUNCTION t_$flgreater(IN a,b: DOUBLE): INTEGER;
BEGIN
    IF (a > b) THEN t_$flgreater := 1 ELSE t_$flgreater := 0;
END;

FUNCTION t_$fix (IN a: DOUBLE): INTEGER32;
BEGIN
    t_$fix := trunc(a);
END;

PROCEDURE t_$float (IN a: INTEGER32; OUT c: DOUBLE);
BEGIN
    c := a;
END;

PROCEDURE t_$atod (IN a: STRING; OUT c: DOUBLE);
VAR
    st: status_$t;
    dummy: integer;
BEGIN
    dummy := vfmt_$decode2( '%50ELF%$', a, 50, dummy, st, c, 0);
END;

PROCEDURE t_$dtoa (OUT a: STRING; IN c: DOUBLE);
VAR
    st: status_$t;                             
    dummy: integer;
BEGIN
    vfmt_$encode2( '%23.15JLE%$', a, 23, dummy, c, 0 );
END;



