#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Net::Prometheus;

my $client = Net::Prometheus->new;

{
   my $summary = $client->new_summary(
      name => "test",
      help => "A testing summary",
   );

   ok( defined $summary, 'defined $summary' );

   is( $client->render, <<'EOF', '$client->render contains summary' );
# HELP test A testing summary
# TYPE test summary
EOF

   $summary->observe( 5 );

   is( $client->render, <<'EOF', 'render after $summary->observe' );
# HELP test A testing summary
# TYPE test summary
test_count 1
test_sum 5
EOF
}

done_testing;
