#!/usr/bin/perl

use strict;
use warnings;

use blib;

use App::MatrixTool;

my $helpcmd = App::MatrixTool::Command::help->new;

my $SCRIPT = "bin/matrixtool";
open my $in, "<", $SCRIPT or
   die "Cannot open $SCRIPT for reading - $!";
open STDOUT, ">", "$SCRIPT.new" or
   die "Cannot open $SCRIPT.new for writing - $!";

while( <$in> ) {
   print;
   last if $_ =~ m/^=head1 COMMANDS/;
}

print "\n=over 4\n\n";

foreach my $cmd ( $helpcmd->commands ) {
   print <<"EOF";
=item * $cmd->[0]

$cmd->[1]

EOF
}

print "=back\n\n";

# Consume the previous content
while( <$in> ) {
   print, last if m/^=(?:head[12]|cut)/;
}

print while <$in>;

close STDOUT;
close $in;

rename "$SCRIPT", "$SCRIPT.old" or die "Cannot rename to $SCRIPT.old - $!";
rename "$SCRIPT.new", "$SCRIPT" or die "Cannot rename to $SCRIPT - $!";
